/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.model;

import com.gallery.GalleryRemote.GalleryComm;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class Gallery
extends DefaultTreeModel
implements Serializable,
PreferenceNames {
    public static final String MODULE = "Gallery";
    String stUrlString = null;
    String pnLoginUrlString = null;
    String pnGalleryUrlString = null;
    String phpnLoginUrlString = null;
    String phpnGalleryUrlString = null;
    String glLoginUrlString = null;
    String glGalleryUrlString = null;
    String username;
    String password;
    String alias;
    String userAgent;
    int type;
    transient GalleryComm comm;
    transient StatusUpdate su;
    private transient int prefsIndex;
    private transient Boolean ambiguousUrl;
    private transient boolean blockWrites;
    public transient boolean cookieLogin;
    public transient int galleryVersion;
    public transient int forceGalleryVersion;
    public transient String forceProtocolEncoding;
    public transient int resizeJpegQuality;
    public transient boolean dirty;
    public static String[] types = new String[]{"Standalone", "PostNuke", "PHPNuke", "GeekLog"};
    public static final int TYPE_STANDALONE = 0;
    public static final int TYPE_POSTNUKE = 1;
    public static final int TYPE_PHPNUKE = 2;
    public static final int TYPE_GEEKLOG = 3;
    public static final int TYPE_APPLET = 99;
    public static final int TOSTRING_MAXLEN = 40;
    public String authToken;
    ArrayList flatAlbumList;

    public Gallery(StatusUpdate su) {
        super(null);
        this.userAgent = "Gallery Remote " + GalleryRemote._().properties.getProperty("version");
        this.type = 0;
        this.comm = null;
        this.blockWrites = false;
        this.cookieLogin = false;
        this.galleryVersion = 1;
        this.forceGalleryVersion = 0;
        this.forceProtocolEncoding = null;
        this.resizeJpegQuality = -1;
        this.dirty = false;
        this.flatAlbumList = null;
        this.su = su;
        this.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                Gallery.this.flatAlbumList = null;
            }

            public void treeNodesInserted(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }

            public void treeStructureChanged(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }
        });
        if (GalleryRemote._().getMainFrame() != null) {
            this.prefsIndex = GalleryRemote._().getCore().getGalleries().getSize();
        }
    }

    public void doUploadFiles(StatusUpdate su) {
        GalleryComm comm = this.getComm(su);
        if (comm != null) {
            comm.uploadFiles(su, true);
        }
    }

    public void doFetchAlbums(StatusUpdate su) {
        this.doFetchAlbums(su, true);
    }

    public void doFetchAlbums(StatusUpdate su, boolean async) {
        GalleryComm comm = this.getComm(su);
        if (comm != null) {
            comm.fetchAlbums(su, async);
        }
    }

    public String doNewAlbum(Album a, StatusUpdate su) {
        Log.log(2, MODULE, "Creating new album " + a.toString());
        String newAlbumName = this.getComm(su).newAlbum(su, a.getParentAlbum(), a.getName(), a.getTitle(), a.getCaption(), false);
        if (!newAlbumName.equals(a.getName())) {
            a.setName(newAlbumName);
        }
        return newAlbumName;
    }

    public void incrementViewCount(Picture p, StatusUpdate su) {
        if (this.getComm(su).hasCapability(su, 15)) {
            Log.log(2, MODULE, "Incrementing viewCount on " + p.toString());
            this.getComm(su).incrementViewCount(su, p);
        }
    }

    public void logOut() {
        if (this.comm != null) {
            this.comm.logOut();
        }
        this.comm = null;
        this.setRoot(null);
    }

    public File getGalleryDefaultFile() {
        StringBuffer defaultFilePath = new StringBuffer();
        defaultFilePath.append(System.getProperty("user.home"));
        defaultFilePath.append(File.separator);
        defaultFilePath.append(".GalleryRemote");
        defaultFilePath.append(File.separator);
        defaultFilePath.append("backup.");
        defaultFilePath.append(this.getPrefsIndex());
        defaultFilePath.append(".grg");
        return new File(defaultFilePath.toString());
    }

    public ArrayList getAllPictures() {
        return this.getAllPictures(false);
    }

    public ArrayList getAllUploadablePictures() {
        return this.getAllPictures(true);
    }

    public ArrayList getAllPictures(boolean onlyUploadable) {
        ArrayList pictures = new ArrayList();
        ArrayList albumList = this.getFlatAlbumList();
        if (albumList != null) {
            Iterator i = albumList.iterator();
            while (i.hasNext()) {
                Album a = (Album)i.next();
                if (onlyUploadable) {
                    pictures.addAll(a.getUploadablePicturesList());
                    continue;
                }
                pictures.addAll(a.getPicturesList());
            }
        }
        return pictures;
    }

    public void deleteAllPictures() {
        ArrayList albumList = this.getFlatAlbumList();
        if (albumList != null) {
            Iterator i = albumList.iterator();
            while (i.hasNext()) {
                Album a = (Album)i.next();
                a.clearPictures();
            }
        }
    }

    public int countAllPictures() {
        int c = 0;
        ArrayList albumList = this.getFlatAlbumList();
        if (albumList != null) {
            Iterator i = albumList.iterator();
            while (i.hasNext()) {
                Album a = (Album)i.next();
                c += a.getSize();
            }
        }
        return c;
    }

    public boolean hasPictures() {
        ArrayList albumList = this.getFlatAlbumList();
        if (albumList != null) {
            Iterator i = albumList.iterator();
            while (i.hasNext()) {
                Album a = (Album)i.next();
                if (a.getSize() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String reformatUrlString(String urlString, boolean trailingSlash) {
        if (urlString == null) {
            throw new IllegalArgumentException("urlString must not be null");
        }
        if (trailingSlash && !urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        if (!urlString.startsWith("http://") && !urlString.startsWith("https://")) {
            urlString = "http://" + urlString;
        }
        return urlString;
    }

    public void setStUrlString(String urlString) {
        if (urlString == null) {
            this.stUrlString = null;
            return;
        }
        this.stUrlString = Gallery.reformatUrlString(urlString, true);
        if (!this.blockWrites && this.stUrlString != null) {
            GalleryRemote._().properties.setProperty("url." + this.prefsIndex, this.stUrlString);
        }
    }

    public String getStUrlString() {
        if (this.stUrlString != null) {
            return this.stUrlString;
        }
        return "http://example.com/gallery";
    }

    public void setPnGalleryUrlString(String urlString) {
        if (urlString == null) {
            this.pnGalleryUrlString = null;
            return;
        }
        this.pnGalleryUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.pnGalleryUrlString != null) {
            GalleryRemote._().properties.setProperty("pnGalleryUrl." + this.prefsIndex, this.pnGalleryUrlString);
        }
    }

    public String getPnGalleryUrlString() {
        if (this.pnGalleryUrlString != null) {
            return this.pnGalleryUrlString.toString();
        }
        return "http://example.com/modules.php?op=modload&name=gallery&file=index&include=$GALLERYFILE$";
    }

    public void setPnLoginUrlString(String urlString) {
        if (urlString == null) {
            this.pnLoginUrlString = null;
            return;
        }
        this.pnLoginUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.pnLoginUrlString != null) {
            GalleryRemote._().properties.setProperty("pnLoginUrl." + this.prefsIndex, this.pnLoginUrlString);
        }
    }

    public String getPnLoginUrlString() {
        if (this.pnLoginUrlString != null) {
            return this.pnLoginUrlString.toString();
        }
        return "http://example.com/user.php?uname=$USERNAME$&pass=$PASSWORD$&module=NS-User&op=login";
    }

    public void setPhpnGalleryUrlString(String urlString) {
        if (urlString == null) {
            this.phpnGalleryUrlString = null;
            return;
        }
        this.phpnGalleryUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.phpnGalleryUrlString != null) {
            GalleryRemote._().properties.setProperty("phpnGalleryUrl." + this.prefsIndex, this.phpnGalleryUrlString);
        }
    }

    public String getPhpnGalleryUrlString() {
        if (this.phpnGalleryUrlString != null) {
            return this.phpnGalleryUrlString.toString();
        }
        return "http://example.com/modules.php?name=gallery&include=$GALLERYFILE$";
    }

    public void setPhpnLoginUrlString(String urlString) {
        if (urlString == null) {
            this.phpnLoginUrlString = null;
            return;
        }
        this.phpnLoginUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.phpnLoginUrlString != null) {
            GalleryRemote._().properties.setProperty("phpnLoginUrl." + this.prefsIndex, this.phpnLoginUrlString);
        }
    }

    public String getPhpnLoginUrlString() {
        if (this.phpnLoginUrlString != null) {
            return this.phpnLoginUrlString.toString();
        }
        return "http://example.com/modules.php?name=Your_Account&op=login&username=$USERNAME$&user_password=$PASSWORD$";
    }

    public void setGlGalleryUrlString(String urlString) {
        if (urlString == null) {
            this.glGalleryUrlString = null;
            return;
        }
        this.glGalleryUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.glGalleryUrlString != null) {
            GalleryRemote._().properties.setProperty("glGalleryUrl." + this.prefsIndex, this.glGalleryUrlString);
        }
    }

    public String getGlGalleryUrlString() {
        if (this.glGalleryUrlString != null) {
            return this.glGalleryUrlString.toString();
        }
        return "http://example.com/path/to/gallery/$GALLERYFILE$";
    }

    public void setGlLoginUrlString(String urlString) {
        if (urlString == null) {
            this.glLoginUrlString = null;
            return;
        }
        this.glLoginUrlString = Gallery.reformatUrlString(urlString, false);
        if (!this.blockWrites && this.glLoginUrlString != null) {
            GalleryRemote._().properties.setProperty("glLoginUrl." + this.prefsIndex, this.glLoginUrlString);
        }
    }

    public String getGlLoginUrlString() {
        if (this.glLoginUrlString != null) {
            return this.glLoginUrlString.toString();
        }
        return "http://example.com/path/to/geeklog/public_html/users.php?loginname=$USERNAME$&passwd=$PASSWORD$";
    }

    public void setApUrlString(String urlString) {
        this.stUrlString = urlString;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public URL getLoginUrl(String galleryFile) {
        try {
            switch (this.type) {
                case 0: {
                    return new URL(this.stUrlString + galleryFile);
                }
                case 1: {
                    return new URL(this.replace(this.pnLoginUrlString, galleryFile));
                }
                case 2: {
                    return new URL(this.replace(this.phpnLoginUrlString, galleryFile));
                }
                case 3: {
                    return new URL(this.replace(this.glLoginUrlString, galleryFile));
                }
                case 99: {
                    return new URL(this.stUrlString);
                }
            }
            throw new RuntimeException("Unknown type: " + this.type);
        }
        catch (MalformedURLException e) {
            Log.log(1, MODULE, "Malformed URL.");
            Log.logException(1, MODULE, e);
            JOptionPane.showMessageDialog((JFrame)((Object)this.su), "Malformed URL (" + e.getMessage() + ")", "Error", 0);
            return null;
        }
    }

    public URL getGalleryUrl(String galleryFile) {
        try {
            switch (this.type) {
                case 0: {
                    return new URL(this.stUrlString + galleryFile);
                }
                case 1: {
                    return new URL(this.replace(this.pnGalleryUrlString, galleryFile));
                }
                case 2: {
                    return new URL(this.replace(this.phpnGalleryUrlString, galleryFile));
                }
                case 3: {
                    return new URL(this.replace(this.glGalleryUrlString, galleryFile));
                }
                case 99: {
                    return new URL(this.stUrlString);
                }
            }
            throw new RuntimeException("Unknown type: " + this.type);
        }
        catch (MalformedURLException e) {
            Log.log(1, MODULE, "Malformed URL.");
            Log.logException(1, MODULE, e);
            JOptionPane.showMessageDialog((Component)((Object)this.su), "Malformed URL (" + e.getMessage() + ")", "Error", 0);
            return null;
        }
    }

    String replace(String urlString, String galleryFile) {
        StringBuffer sb = new StringBuffer(urlString);
        this.replace(sb, "$USERNAME$", this.username);
        this.replace(sb, "$PASSWORD$", this.password);
        this.replace(sb, "$GALLERYFILE$", galleryFile);
        return sb.toString();
    }

    boolean replace(StringBuffer sb, String token, String value) {
        int n = sb.indexOf(token);
        if (n != -1) {
            sb.replace(n, n + token.length(), value);
            return true;
        }
        return false;
    }

    public void setUsername(String username) {
        if (!username.equals(this.username)) {
            this.username = username;
            this.logOut();
            if (!this.blockWrites) {
                GalleryRemote._().properties.setProperty("username." + this.prefsIndex, username);
            }
        }
    }

    public void setPassword(String password) {
        if (!password.equals(this.password)) {
            this.password = password;
            this.logOut();
            if (!this.blockWrites) {
                if (GalleryRemote._().properties.getBooleanProperty("savePasswords")) {
                    GalleryRemote._().properties.setBase64Property("password." + this.prefsIndex, password);
                } else {
                    GalleryRemote._().properties.setProperty("password." + this.prefsIndex, null);
                }
            }
        }
    }

    public void setType(int type) {
        this.type = type;
        if (!this.blockWrites) {
            GalleryRemote._().properties.setProperty("type." + this.prefsIndex, types[type]);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
        if (!this.blockWrites) {
            GalleryRemote._().properties.setProperty("alias." + this.prefsIndex, alias);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    public static Gallery readFromProperties(GalleryProperties p, int prefsIndex, StatusUpdate su) {
        return Gallery.readFromProperties(p, prefsIndex, su, true);
    }

    public static Gallery readFromProperties(GalleryProperties p, int prefsIndex, StatusUpdate su, boolean mustHaveUsername) {
        int type;
        String url = p.getProperty("url." + prefsIndex);
        String username = p.getProperty("username." + prefsIndex, true);
        if (mustHaveUsername && username == null) {
            return null;
        }
        String password = null;
        try {
            password = p.getBase64Property("password." + prefsIndex);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Log.log(2, MODULE, "Loaded saved URL " + prefsIndex + ": " + url + " (" + username + "/******)");
        Gallery g = new Gallery(su);
        if (GalleryRemote._().getCore() instanceof TreeModelListener) {
            g.addTreeModelListener((TreeModelListener)((Object)GalleryRemote._().getCore()));
        }
        g.setBlockWrites(true);
        g.username = username;
        g.password = password;
        g.setStUrlString(url);
        g.setPnLoginUrlString(p.getProperty("pnLoginUrl." + prefsIndex));
        g.setPnGalleryUrlString(p.getProperty("pnGalleryUrl." + prefsIndex));
        g.setPhpnLoginUrlString(p.getProperty("phpnLoginUrl." + prefsIndex));
        g.setPhpnGalleryUrlString(p.getProperty("phpnGalleryUrl." + prefsIndex));
        g.setGlLoginUrlString(p.getProperty("glLoginUrl." + prefsIndex));
        g.setGlGalleryUrlString(p.getProperty("glGalleryUrl." + prefsIndex));
        String typeS = p.getProperty("type." + prefsIndex);
        if (typeS != null && (type = Arrays.asList(types).indexOf(typeS)) != -1) {
            g.setType(type);
        }
        g.setAlias(p.getProperty("alias." + prefsIndex));
        g.forceGalleryVersion = p.getIntProperty("forceGalleryVersion." + prefsIndex, 0);
        g.forceProtocolEncoding = p.getProperty("forceProtocolEncoding." + prefsIndex);
        g.resizeJpegQuality = p.getIntProperty("resizeJpegQuality." + prefsIndex, -1);
        g.setPrefsIndex(prefsIndex);
        g.setBlockWrites(false);
        return g;
    }

    public void writeToProperties(PropertiesFile p) {
        Log.log(3, MODULE, "Writing to properties: " + this.toString());
        p.setProperty("url." + this.prefsIndex, this.stUrlString);
        p.setProperty("username." + this.prefsIndex, this.username);
        if (this.getPassword() != null && p.getBooleanProperty("savePasswords")) {
            p.setBase64Property("password." + this.prefsIndex, this.password);
        } else {
            p.setProperty("password." + this.prefsIndex, null);
        }
        p.setProperty("type." + this.prefsIndex, types[this.type]);
        if (this.getAlias() != null && this.getAlias().length() > 0) {
            p.setProperty("alias." + this.prefsIndex, this.getAlias());
        } else {
            p.setProperty("alias." + this.prefsIndex, null);
        }
        if (this.pnLoginUrlString != null) {
            p.setProperty("pnLoginUrl." + this.prefsIndex, this.pnLoginUrlString);
        }
        if (this.pnGalleryUrlString != null) {
            p.setProperty("pnGalleryUrl." + this.prefsIndex, this.pnGalleryUrlString);
        }
        if (this.phpnLoginUrlString != null) {
            p.setProperty("phpnLoginUrl." + this.prefsIndex, this.phpnLoginUrlString);
        }
        if (this.phpnGalleryUrlString != null) {
            p.setProperty("phpnGalleryUrl." + this.prefsIndex, this.phpnGalleryUrlString);
        }
        if (this.glLoginUrlString != null) {
            p.setProperty("glLoginUrl." + this.prefsIndex, this.glLoginUrlString);
        }
        if (this.glGalleryUrlString != null) {
            p.setProperty("glGalleryUrl." + this.prefsIndex, this.glGalleryUrlString);
        }
    }

    public static void removeFromProperties(PropertiesFile p, int n) {
        Log.log(3, MODULE, "Removed from properties: " + n);
        p.setProperty("url." + n, null);
        p.setProperty("username." + n, null);
        p.setProperty("password." + n, null);
        p.setProperty("type." + n, null);
        p.setProperty("pnLoginUrl." + n, null);
        p.setProperty("pnGalleryUrl." + n, null);
        p.setProperty("phpnLoginUrl." + n, null);
        p.setProperty("phpnGalleryUrl." + n, null);
        p.setProperty("alias." + n, null);
    }

    public void setPrefsIndex(int prefsIndex) {
        this.prefsIndex = prefsIndex;
    }

    protected int getPrefsIndex() {
        return this.prefsIndex;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean disambiguate) {
        if (this.alias != null) {
            return this.alias;
        }
        String tmp = null;
        switch (this.type) {
            case 0: {
                tmp = this.stUrlString;
                break;
            }
            case 1: {
                tmp = this.pnGalleryUrlString;
                break;
            }
            case 2: {
                tmp = this.phpnGalleryUrlString;
                break;
            }
            case 3: {
                tmp = this.glGalleryUrlString;
                break;
            }
            case 99: {
                tmp = this.stUrlString;
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + this.type);
            }
        }
        if (tmp == null) {
            tmp = "http://";
        }
        if (disambiguate && this.isAmbiguousUrl()) {
            tmp = this.username == null || this.username.length() == 0 ? tmp + "[username not set]" : tmp + " [" + this.username + "]";
        }
        if (tmp.length() > 40) {
            tmp = tmp.substring(0, 40) + "...";
        }
        return tmp;
    }

    public boolean isAmbiguousUrl() {
        if (this.ambiguousUrl == null) {
            DefaultComboBoxModel galleries = GalleryRemote._().getCore().getGalleries();
            String myUrl = this.toString(false);
            for (int i = 0; i < galleries.getSize(); ++i) {
                Gallery g = (Gallery)galleries.getElementAt(i);
                if (g == this || !myUrl.equals(g.toString(false))) continue;
                this.ambiguousUrl = new Boolean(true);
                break;
            }
            if (this.ambiguousUrl == null) {
                this.ambiguousUrl = new Boolean(false);
            }
        }
        return this.ambiguousUrl;
    }

    public static void uncacheAmbiguousUrl() {
        DefaultComboBoxModel galleries = GalleryRemote._().getCore().getGalleries();
        for (int i = 0; i < galleries.getSize(); ++i) {
            Gallery g = (Gallery)galleries.getElementAt(i);
            g.ambiguousUrl = null;
        }
    }

    public GalleryComm getComm(StatusUpdate su) {
        URL url;
        if (this.comm == null && this.stUrlString != null && (url = this.getGalleryUrl("")) != null) {
            this.comm = GalleryComm.getCommInstance(su, url, this);
            if (this.comm == null) {
                Log.log(1, MODULE, "No protocol implementation found");
                su.error(GRI18n.getString(MODULE, "galleryNotFound", new Object[]{this.stUrlString}));
            }
        }
        return this.comm;
    }

    public boolean hasComm() {
        return this.comm != null;
    }

    public Album getAlbumByName(String name) {
        ArrayList albumList = this.getFlatAlbumList();
        if (albumList == null || name == null) {
            return null;
        }
        Iterator it = albumList.iterator();
        while (it.hasNext()) {
            Album a = (Album)it.next();
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public void setBlockWrites(boolean blockWrites) {
        this.blockWrites = blockWrites;
    }

    public ArrayList getFlatAlbumList() {
        if (this.flatAlbumList == null) {
            if (this.getRoot() != null) {
                this.flatAlbumList = Collections.list(new TreeEnumeration((TreeNode)this.getRoot()));
            }
            if (this.getGalleryVersion() == 2 && this.flatAlbumList != null) {
                this.flatAlbumList.remove(this.getRoot());
            }
        }
        return this.flatAlbumList;
    }

    public Album createRootAlbum() {
        if (this.getRoot() != null) {
            throw new IllegalStateException("Root album already exists");
        }
        Album album = new Album(this);
        album.setTitle(GRI18n.getString("Common", "rootAlbmTitle"));
        album.setName("root.album");
        this.setRoot(album);
        return (Album)this.getRoot();
    }

    public int getGalleryVersion() {
        if (this.forceGalleryVersion != 0) {
            return this.forceGalleryVersion;
        }
        return this.galleryVersion;
    }

    public void setGalleryVersion(int galleryVersion) {
        this.galleryVersion = galleryVersion;
    }

    public int getResizeJpegQuality() {
        return this.resizeJpegQuality;
    }

    public String getForceProtocolEncoding() {
        return this.forceProtocolEncoding;
    }

    public void setForceProtocolEncoding(String forceProtocolEncoding) {
        this.forceProtocolEncoding = forceProtocolEncoding;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    class TreeEnumeration
    implements Enumeration {
        protected TreeNode root;
        protected Enumeration children;
        protected Enumeration subtree;
        boolean rootSent = false;

        public TreeEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public boolean hasMoreElements() {
            return !this.rootSent || this.subtree.hasMoreElements() || this.children.hasMoreElements();
        }

        public Object nextElement() {
            TreeNode retval = null;
            if (!this.rootSent) {
                retval = this.root;
                this.rootSent = true;
            } else if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new TreeEnumeration((TreeNode)this.children.nextElement());
                retval = this.subtree.nextElement();
            }
            return retval;
        }
    }
}

