/***************************************************************************

  archive.h

  The archive management routines

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GBX_ARCHIVE_H
#define __GBX_ARCHIVE_H

#define PROJECT_EXEC

#include "gb_table.h"
#include "gb_file.h"

typedef
  struct {
    long magic;
    long version;
    long pos_data;
    long pos_string;
    long pos_table;
    long n_symbol;
    }
  ARCH_HEADER;

typedef
  struct {
    SYMBOL sym;
    long pos;
    long len;
    }
  ARCH_SYMBOL;

typedef
  struct {
    LIST list;
    int fd;
    ARCH_HEADER header;
    ARCH_SYMBOL *symbol;
    char *string;
    }
  ARCHIVE;

typedef
  struct {
    ARCHIVE *arch;
    ARCH_SYMBOL *sym;
    long pos;
    long len;
    }
  ARCH_FIND;

#ifndef __ARCHIVe_C
EXTERN ARCHIVE *ARCHIVE_main;
EXTERN ARCHIVE *ARCHIVE_last;
#endif

PUBLIC void ARCH_init(const char *path);
PUBLIC void ARCH_exit(void);

PUBLIC void ARCH_create(const char *path);
PUBLIC void ARCH_add(const char *path);

PUBLIC bool ARCH_get(const char *path, int len_path, ARCH_FIND *find);

PUBLIC boolean ARCH_read(ARCHIVE *arch, long pos, void *buffer, long len);

PUBLIC bool ARCH_exist(const char *path);
PUBLIC void ARCH_stat(const char *path, FILE_STAT *info);

PUBLIC void ARCH_dir_first(const char *path, const char *pattern);
PUBLIC bool ARCH_dir_next(char **name, long *len);

/*PUBLIC bool ARCH_current(ARCHIVE **parch);*/

#endif
