/***************************************************************************

  CGambas.c

  The interpreter constants

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_C_GAMBAS_C

#include "gb_common.h"
#include "gbx_api.h"
#include "gambas.h"
#include "gbx_class.h"
#include "gb_file.h"
#include "gbx_compare.h"

#include "gbx_c_gambas.h"


PUBLIC GB_DESC NATIVE_Gambas[] =
{
  GB_DECLARE("gb", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("Binary", "i", GB_COMP_BINARY),
  //GB_CONSTANT("Case", "i", 1),
  GB_CONSTANT("Text", "i", GB_COMP_TEXT),
  GB_CONSTANT("Lang", "i", GB_COMP_LANG),

  GB_CONSTANT("Ascent", "i", GB_COMP_ASCENT),
  GB_CONSTANT("Descent", "i", GB_COMP_DESCENT),

  /* BE CAREFUL ! These constants are used in the compiler */
  //GB_CONSTANT("Read", "i", 0),
  //GB_CONSTANT("Write", "i", 1),
  //GB_CONSTANT("Append", "i", 2),
  //GB_CONSTANT("Create", "i", 3),
  //GB_CONSTANT("Direct", "i", 4),

  /* BE CAREFUL ! These constants are used in the compiler */
  GB_CONSTANT("Null", "i", T_NULL),
  GB_CONSTANT("Boolean", "i", T_BOOLEAN),
  GB_CONSTANT("Byte", "i", T_BYTE),
  GB_CONSTANT("Short", "i", T_SHORT),
  GB_CONSTANT("Integer", "i", T_INTEGER),
  GB_CONSTANT("Long", "i", T_LONG),
  GB_CONSTANT("Float", "i", T_FLOAT),
  GB_CONSTANT("Date", "i", T_DATE),
  GB_CONSTANT("String", "i" , T_STRING),
  //GB_CONSTANT("Function", "i" , T_FUNCTION),
  GB_CONSTANT("Variant", "i", T_VARIANT),
  GB_CONSTANT("Class", "i" , T_CLASS),
  //GB_CONSTANT("Void", "i", T_VOID),
  GB_CONSTANT("Object", "i", T_OBJECT),

  GB_CONSTANT("File", "i", GB_STAT_FILE),
  GB_CONSTANT("Directory", "i", GB_STAT_DIRECTORY),
  GB_CONSTANT("Device", "i", GB_STAT_DEVICE),
  GB_CONSTANT("Pipe", "i", GB_STAT_PIPE),
  GB_CONSTANT("Socket", "i", GB_STAT_SOCKET),
  GB_CONSTANT("Link", "i", GB_STAT_LINK),

  GB_CONSTANT("NewLine", "s", "\n"),
  GB_CONSTANT("Tab", "s", "\t"),

  GB_CONSTANT("Standard", "i", 1),
  GB_CONSTANT("GeneralNumber", "i", 2),
  GB_CONSTANT("Fixed", "i", 3),
  GB_CONSTANT("Percent", "i", 4),
  GB_CONSTANT("Scientific", "i", 5),
  GB_CONSTANT("Currency", "i", 6),
  GB_CONSTANT("GeneralDate", "i", 7),
  GB_CONSTANT("LongDate", "i", 8),
  GB_CONSTANT("MediumDate", "i", 9),
  GB_CONSTANT("ShortDate", "i", 10),
  GB_CONSTANT("LongTime", "i", 11),
  GB_CONSTANT("MediumTime", "i", 12),
  GB_CONSTANT("ShortTime", "i", 13),

  GB_CONSTANT("Read", "i", R_OK),
  GB_CONSTANT("Write", "i", W_OK),
  GB_CONSTANT("Exec", "i", X_OK),

  //GB_CONSTANT("User", "i", GB_STAT_USER),
  //GB_CONSTANT("Group", "i", GB_STAT_GROUP),
  //GB_CONSTANT("Other", "i", GB_STAT_OTHER),
  
  GB_CONSTANT("Sunday", "i", 0),
  GB_CONSTANT("Monday", "i", 1),
  GB_CONSTANT("Tuesday", "i", 2),
  GB_CONSTANT("Wednesday", "i", 3),
  GB_CONSTANT("Thursday", "i", 4),
  GB_CONSTANT("Friday", "i", 5),
  GB_CONSTANT("Saturday", "i", 6),

  GB_END_DECLARE
};

