/***************************************************************************

  CTabStrip.cpp

  The TabStrip class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CTABSTRIP_CPP



#include <qapplication.h>
#include <qframe.h>
#include <qtabwidget.h>

#include "gambas.h"

#include "CPicture.h"
#include "CConst.h"
#include "CTabStrip.h"


DECLARE_EVENT(EVENT_Click);




/***************************************************************************

  TabStrip

***************************************************************************/


static void set_tab_count(void *_object, long new_count)
{
  long count = THIS->stack->count();
  QFrame *page;
  long i;
  long index;
  QString label;
  CPICTURE *pict;

  if (new_count < 1 || new_count > 32)
  {
    GB.Error(GB_ERR_ARG);
    return;
  }

  if (new_count == count)
    return;

  if (new_count > count)
  {
    THIS->stack->resize(new_count);
    THIS->icon->resize(new_count);

    for (i = count; i < new_count; i++)
    {
      page = new MyContainer(WIDGET);
      CWidget::installFilter(page);

      label.sprintf("Tab %ld", i);
      WIDGET->insertTab(page, label);
      THIS->stack->insert(i, page);
      THIS->icon->insert(i, 0);
    }

    index = new_count - 1;
  }
  else
  {
    index = WIDGET->currentPageIndex();
    //same = (id == PARAM(index));

    for (i = new_count; i < count; i++)
    {
      if (THIS->stack->at(i)->children() != NULL)
      {
        GB.Error("Tab is not empty");
        return;
      }
    }

    for (i = new_count; i < count; i++)
    {
      if (i == index)
        index = 0;

      page = THIS->stack->at(i);
      pict = THIS->icon->at(i);
      
      WIDGET->removePage(page);
      GB.Unref((void **)&pict);
      
      delete page;
    }

    THIS->stack->resize(new_count);
    THIS->icon->resize(new_count);
  }

  THIS->container = THIS->stack->at(index);
  WIDGET->showPage(THIS->container);
}


BEGIN_METHOD(CTABSTRIP_new, GB_OBJECT parent)

  QTabWidget *wid = new QTabWidget(CONTAINER(VARG(parent))); //, 0, Qt::WNoMousePropagation);

  CWIDGET_new(wid, (void *)_object, "TabStrip");

  THIS->container = NULL;
  THIS->index = -1;
  THIS->stack = new QVector<QFrame>;
  THIS->icon = new QVector<CPICTURE>;

  QObject::connect(wid, SIGNAL(currentChanged(QWidget *)), &CTabStrip::manager, SLOT(currentChanged(QWidget *)));

  wid->show();

  set_tab_count(THIS, 1);

END_METHOD


BEGIN_METHOD_VOID(CTABSTRIP_free)

  uint i;
  CPICTURE *pict;

  for (i = 0; i < THIS->icon->count(); i++)
  {
    pict = THIS->icon->at(i);
    GB.Unref((void **)&pict);
  }
  
  delete OBJECT(CTABSTRIP)->stack;
  delete OBJECT(CTABSTRIP)->icon;

  //CALL_METHOD_VOID(CWIDGET_delete);

END_METHOD


BEGIN_PROPERTY(CTABSTRIP_tabs)

  if (READ_PROPERTY)
    GB.ReturnInteger(THIS->stack->count());
  else
    set_tab_count(THIS, VPROP(GB_INTEGER));

END_PROPERTY


static bool check_index(CTABSTRIP *_object, long index)
{
  if (index < 0 || index >= (long)THIS->stack->count())
  {
    GB.Error("Bad index");
    return true;
  }
  else
    return false;
}

BEGIN_PROPERTY(CTABSTRIP_index)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->currentPageIndex());
  else
  {
    long index = VPROP(GB_INTEGER);

    if (check_index(THIS, index))
      return;

    if (index == WIDGET->currentPageIndex())
      return;

    WIDGET->showPage(THIS->stack->at(index));
  }

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_current)

  THIS->index = WIDGET->currentPageIndex();
  RETURN_SELF();

END_PROPERTY


BEGIN_METHOD(CTABSTRIP_get, GB_INTEGER index)

  long index = VARG(index);

  if (check_index(THIS, index))
    return;

  THIS->index = index;
  RETURN_SELF();

END_METHOD


BEGIN_PROPERTY(CTABSTRIP_orientation)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->tabPosition());
  else
    WIDGET->setTabPosition((QTabWidget::TabPosition)VPROP(GB_INTEGER));

END_PROPERTY



/***************************************************************************

  .Tab

***************************************************************************/

static QFrame *get_page(CTABSTRIP *_object)
{
  int index = THIS->index;

  if (index < 0)
    return (QFrame *)WIDGET->currentPage();

  THIS->index = (-1);
  return THIS->stack->at(index);
}


BEGIN_PROPERTY(CTAB_text)

  QFrame *page = get_page(THIS);

  if (READ_PROPERTY)
    GB.ReturnNewZeroString(TO_UTF8(WIDGET->tabLabel(page)));
  else
    WIDGET->changeTab(page, QSTRING_PROP());

END_PROPERTY


BEGIN_PROPERTY(CTAB_picture)

  int index;
  QFrame *page;

  index = THIS->index;
  if (index < 0)
    index = WIDGET->currentPageIndex();
  
  page = get_page(THIS);

  if (READ_PROPERTY)
    GB.ReturnObject(THIS->icon->at(index));
  else
  {
    CPICTURE *pict;
    
    pict = THIS->icon->at(index);
    GB.Unref((void **)&pict);
    pict = (CPICTURE *)VPROP(GB_OBJECT);
    THIS->icon->insert(index, pict);
    GB.Ref(pict);
    
    if (pict)
      WIDGET->setTabIconSet(page, QIconSet(*(pict->pixmap), QIconSet::Small));
    else
      WIDGET->setTabIconSet(page, QIconSet());
  }

END_PROPERTY


BEGIN_PROPERTY(CTAB_enabled)

  QFrame *page = get_page(THIS);

  if (READ_PROPERTY)
    GB.ReturnBoolean(WIDGET->isTabEnabled(page));
  else
    WIDGET->setTabEnabled(page, VPROP(GB_BOOLEAN));

END_PROPERTY


BEGIN_METHOD_VOID(CTAB_next)

  CTABSTRIP_ENUM *iter;
  QFrame *page;
  QObjectList *list;
  unsigned int child;
  CWIDGET *widget;
  
  iter = (CTABSTRIP_ENUM *)GB.GetEnum();
  if (!iter->init)
  {
    iter->child = 0;
    iter->index = THIS->index;
    iter->init = true;
  }
  
  //qDebug("CTAB_next: iter = (%d, %d, %d)", iter->init, iter->index, iter->child);
  
  page = THIS->stack->at(iter->index);
  list = (QObjectList *)page->children();

  for(;;)
  {
    child = iter->child;

    if (list == NULL || child >= list->count())
    {
      GB.StopEnum();
      return;
    }

    iter->child = child + 1;

    widget = CWidget::getReal(list->at(child));
    if (widget)
    {
      GB.ReturnObject(widget);
      return;
    }
  }

END_METHOD


BEGIN_PROPERTY(CTAB_count)

  QFrame *page = THIS->stack->at(THIS->index);

  if (page->children() == NULL)
    GB.ReturnInteger(0);
  else
    GB.ReturnInteger(page->children()->count());

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_enabled)

  uint i;

  if (READ_PROPERTY)
    GB.ReturnBoolean(WIDGET->isEnabled());
  else
  {
    WIDGET->setEnabled(VPROP(GB_BOOLEAN));
    for (i = 0; i < THIS->stack->count(); i++)
      WIDGET->setTabEnabled(THIS->stack->at(i), VPROP(GB_BOOLEAN));
  }

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_text)

  THIS->index = -1;
  CTAB_text(_object, _param);

  /*if (READ_PROPERTY)
    GB.ReturnNewZeroString(TO_UTF8(WIDGET->tabLabel(WIDGET->currentPage())));
  else
    WIDGET->changeTab(WIDGET->currentPage(), QSTRING_PROP());*/

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_picture)

  THIS->index = -1;
  CTAB_picture(_object, _param);

  /*if (READ_PROPERTY)
    GB.ReturnNewZeroString(TO_UTF8(WIDGET->tabLabel(WIDGET->currentPage())));
  else
    WIDGET->changeTab(WIDGET->currentPage(), QSTRING_PROP());*/

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_client_width)

  if (!THIS->geom)
  {
    qApp->sendEvent(WIDGET, new QShowEvent());
    THIS->geom = WIDGET->isVisible();
  }
    
  GB.ReturnInteger(THIS->container->width());

END_PROPERTY


BEGIN_PROPERTY(CTABSTRIP_client_height)

  if (!THIS->geom)
  {
    qApp->sendEvent(WIDGET, new QShowEvent());
    THIS->geom = WIDGET->isVisible();
  }
    
  GB.ReturnInteger(THIS->container->height());

END_PROPERTY



/***************************************************************************

  Descriptions

***************************************************************************/

GB_DESC CTabChildrenDesc[] =
{
  GB_DECLARE(".TabChildren", 0), GB_VIRTUAL_CLASS(),

  GB_METHOD("_next", "Control", CTAB_next, NULL),
  GB_PROPERTY_READ("Count", "i", CTAB_count),

  GB_END_DECLARE
};


GB_DESC CTabDesc[] =
{
  GB_DECLARE(".Tab", 0), GB_VIRTUAL_CLASS(),

  GB_PROPERTY("Text", "s", CTAB_text),
  GB_PROPERTY("Picture", "Picture", CTAB_picture),
  GB_PROPERTY("Caption", "s", CTAB_text),
  GB_PROPERTY("Enabled", "b", CTAB_enabled),
  GB_PROPERTY_SELF("Children", ".TabChildren"),
  //GB_PROPERTY_WRITE("Picture", "s", CTABSTRIP_picture),

  GB_END_DECLARE
};


GB_DESC CTabStripDesc[] =
{
  GB_DECLARE("TabStrip", sizeof(CTABSTRIP)), GB_INHERITS("Container"),

  GB_CONSTANT("Top", "i", QTabWidget::Top),
  GB_CONSTANT("Bottom", "i", QTabWidget::Bottom),

  GB_METHOD("_new", NULL, CTABSTRIP_new, "(Parent)Container;"),
  GB_METHOD("_free", NULL, CTABSTRIP_free, NULL),

  GB_PROPERTY("Count", "i", CTABSTRIP_tabs),
  GB_PROPERTY("Text", "s", CTABSTRIP_text),
  GB_PROPERTY("Picture", "Picture", CTABSTRIP_picture),
  GB_PROPERTY("Caption", "s", CTABSTRIP_text),
  GB_PROPERTY_READ("Current", "i", CTABSTRIP_current),
  GB_PROPERTY("Index", "i", CTABSTRIP_index),
  GB_PROPERTY("Orientation", "i<TabStrip>", CTABSTRIP_orientation),
  GB_PROPERTY("Enabled", "b", CTABSTRIP_enabled),

  GB_PROPERTY_READ("ClientW", "i", CTABSTRIP_client_width),
  GB_PROPERTY_READ("ClientWidth", "i", CTABSTRIP_client_width),
  GB_PROPERTY_READ("ClientH", "i", CTABSTRIP_client_height),
  GB_PROPERTY_READ("ClientHeight", "i", CTABSTRIP_client_height),
  
  GB_PROPERTY("Arrangement", "i<Arrange>", CCONTAINER_arrangement),
  GB_PROPERTY("AutoResize", "b", CCONTAINER_auto_resize),
  GB_PROPERTY("Padding", "i", CCONTAINER_padding),
  GB_PROPERTY("Spacing", "i", CCONTAINER_spacing),

  GB_METHOD("_get", ".Tab", CTABSTRIP_get, "(Index)i"),

  GB_CONSTANT("_Properties", "s", CTABSTRIP_PROPERTIES),
  GB_CONSTANT("_DefaultEvent", "s", "Click"),
  GB_CONSTANT("_Arrangement", "i", ARRANGE_FILL),

  GB_EVENT("Click", NULL, NULL, &EVENT_Click),

  GB_END_DECLARE
};


/***************************************************************************

  Class CTabStrip

***************************************************************************/


CTabStrip CTabStrip::manager;

void CTabStrip::currentChanged(QWidget *wid)
{
  GET_SENDER(ob);
  ((CTABSTRIP *)ob)->container = wid;
  
  CCONTAINER_arrange((QFrame *)wid);

  if (wid->isVisible())
    RAISE_EVENT(EVENT_Click);
}


