//
// $Source: /cvsroot/gambit/gambit/sources/base/glist.h,v $
// $Date: 2002/08/26 05:49:57 $
// $Revision: 1.3 $
//
// DESCRIPTION:
// A generic (doubly) linked-list container class
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef GLIST_H
#define GLIST_H

#include "gmisc.h"
#include "gstream.h"

template <class T> class gList  {
  protected:

  class gNode   {
  public:
    T data;
    gNode *prev, *next;
 
    // CONSTRUCTOR
    gNode(const T &_data, gNode *_prev, gNode *_next);
  };

    int length;
    gNode *head, *tail;

    int CurrIndex;
    gNode *CurrNode;

    int InsertAt(const T &t, int where);

  public:
    class BadIndex : public gException   {
      public:
        virtual ~BadIndex()   { }
        gText Description(void) const;
    };

    gList(void);
    gList(const gList<T> &);
    virtual ~gList();

    gList<T> &operator=(const gList<T> &);

    bool operator==(const gList<T> &b) const;
    bool operator!=(const gList<T> &b) const;

    const T &operator[](int) const;
    T &operator[](int);

    gList<T> operator+(const T &e) const;
    gList<T>& operator+=(const T &e);

    gList<T> operator+(const gList<T>& b) const;
    gList<T>& operator+=(const gList<T>& b);

    gList<T> &Combine(gList<T> &b);
    gList<T> InteriorSegment(int, int) const;

    virtual int Append(const T &);
    int Insert(const T &, int);
    virtual T Remove(int);

    bool HasARedundancy();
    void RemoveRedundancies();

    int Find(const T &) const;
    bool Contains(const T &t) const;
    int Length(void) const;

    virtual void Flush(void);
    void Dump(gOutput &) const;
};

template <class T> gOutput &operator<<(gOutput &f, const gList<T> &b);

#endif    // GLIST_H

