//
// $Source: /cvsroot/gambit/gambit/sources/nash/Attic/efgalgorithm.h,v $
// $Date: 2002/08/27 18:29:38 $
// $Revision: 1.3 $
//
// DESCRIPTION:
// Declaration of abstract Nash equilibrium-finding class
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef EFGALGORITHM_H
#define EFGALGORITHM_H

#include "game/efg.h"
#include "behavsol.h"

class efgNashAlgorithm {
public:
  virtual ~efgNashAlgorithm() { }

  virtual gText GetAlgorithm(void) const = 0;
  virtual gList<BehavSolution> Solve(const EFSupport &, gStatus &) = 0;
};

#endif  // EFGALGORITHM_H
