/*******************************************
 *
 * $GAMGI/src/gtk/gamgi_gtk_file_import.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_expat.h"
#include "gamgi_io.h"
#include "gamgi_global.h"

#include "gamgi_gtk_dialog.h"
#include "gamgi_io_file.h"
#include "gamgi_expat_import.h"

static gamgi_bool static_dialog (char *shortname,
char *fullname, gamgi_window *window)
{
char *filename = fullname;

/*******************************************
 * ignore fullname, if it is a remote file *
 *******************************************/

if (strstr (shortname, "http://") != NULL) filename = shortname;

if (strstr (shortname, "ftp://") != NULL) filename = shortname;

return gamgi_io_file_read (filename, window);
}

static void static_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
char *shortname, *fullname;

/*******************************
 * the filename entered by the *
 * user in the selection entry *
 *******************************/

shortname = gtk_entry_get_text ((GtkEntry *) GTK_FILE_SELECTION 
(window->dialog0)->selection_entry);

/*******************************
 * the current pathname plus   *
 * the filename entered by the *
 * user in the selection entry *
 *******************************/

fullname = gtk_file_selection_get_filename
(GTK_FILE_SELECTION (window->dialog0));

if (static_dialog (shortname, fullname, window) == FALSE) return;

gamgi_gtk_dialog_task0_remove (widget, window);
gtk_widget_queue_draw (window->area);
}

void gamgi_gtk_file_import (GtkWidget *widget, void *data)
{
GtkWidget *dialog;
GtkWidget *button;
GtkWidget *label;
GdkColor  color;
gamgi_window *windows, *window = GAMGI_CAST_WINDOW data;
    
windows = gamgi->window_start;
do
  {
  windows->action = FALSE;

  if (windows->dialog0 != NULL)
    gamgi_gtk_dialog_remove (windows->dialog0, &windows->dialog0);

  if (windows->dialog1 != NULL)
    gamgi_gtk_dialog_remove (windows->dialog1, &windows->dialog1);
  }
while ((windows = windows->next) != NULL);

window->dialog0 = dialog = gtk_file_selection_new ("File import");
window->action = GAMGI_GTK_FILE_IMPORT;

gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
gtk_widget_set_size_request (dialog, 600, 450);
gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, FALSE, TRUE);
gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(window->window));
g_signal_connect (GTK_OBJECT (dialog), "delete_event",
(GtkSignalFunc) gamgi_gtk_dialog_task0_delete, window);

button = GTK_WIDGET (GTK_FILE_SELECTION (dialog)->cancel_button);
label = GTK_BIN (button)->child;

gdk_color_parse ("red", &color);
gamgi_gtk_dialog_color_fg (label, color);

g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (dialog)->ok_button),
"clicked", (GtkSignalFunc) static_ok, window);
g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (dialog)->cancel_button), 
"clicked", (GtkSignalFunc) gamgi_gtk_dialog_task0_remove, window);
    
gtk_widget_show (dialog);
}
