/*************************************************
 *
 * $GAMGI/src/gtk/group/gamgi_gtk_group_modify.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"

#include "gamgi_engine_find.h"
#include "gamgi_engine_list.h"
#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_history.h"
#include "gamgi_gtk_object.h"
#include "gamgi_mesa_select.h"
#include "gamgi_math_modify.h"
#include "gamgi_io_token.h"

/******************** internal function ****************
 *                                                     *
 *                       STATIC_MARK                   *
 *                                                     *
 *                                                     *
 *******************************************************/

static int static_mark (gamgi_atom *atom, gamgi_slist *slist_atom)
{
gamgi_slist *slist_mark;
gamgi_bond *bond;
gamgi_atom *atom_new;
gamgi_dlist *dlist_bond;

if (atom->mark == 1) return FALSE;
if (atom->mark == -1)
  {
  slist_mark = GAMGI_CAST_SLIST slist_atom->data;

  while (slist_mark != NULL)
    {

    atom = GAMGI_CAST_ATOM slist_mark->data;
    atom->mark = -1;
    slist_mark = slist_mark->next;
    }
  
  return TRUE;
  }

atom->mark = 1;
slist_mark = GAMGI_CAST_SLIST slist_atom->data;
slist_mark = gamgi_engine_slist_add_start (slist_mark);
slist_atom->data = slist_mark;
slist_mark->data = atom;

dlist_bond = atom->bond_start;
while (dlist_bond != NULL)
  {
  bond = GAMGI_CAST_BOND dlist_bond->data;
  atom_new = bond->atom1; if (atom_new == atom) atom_new = bond->atom2;

  if (static_mark (atom_new, slist_atom) == TRUE) return TRUE;

  dlist_bond = dlist_bond->next;
  }

return FALSE;
}

/******************** internal function ****************
 *                                                     *
 *                      STATIC_UNMARK                  *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_unmark (gamgi_slist *slist_atom)
{
gamgi_atom *atom;
gamgi_slist *slist_mark;

while (slist_atom != NULL)
  {
  slist_mark = GAMGI_CAST_SLIST slist_atom->data;

  while (slist_mark != NULL)
    {
    atom = GAMGI_CAST_ATOM slist_mark->data;
    atom->mark = 0;
    slist_mark = gamgi_engine_slist_remove_start (slist_mark);
    }

  slist_atom = gamgi_engine_slist_remove_start (slist_atom);
  }
}

/******************** internal function ****************
 *                                                     *
 *                     STATIC_TRANSLATE                *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_translate (gamgi_slist *slist_atom, double *translate)
{
gamgi_slist *slist_mark;
gamgi_atom *atom;

slist_mark = GAMGI_CAST_SLIST slist_atom->data;

while (slist_mark != NULL)
  {
  atom = GAMGI_CAST_ATOM slist_mark->data;
  gamgi_math_modify_translate (atom, translate);
  slist_mark = slist_mark->next;
  }
}

/******************** internal function ****************
 *                                                     *
 *                      STATIC_ROTATE                  *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_rotate (gamgi_slist *slist_atom, 
double *origin, double *rotate)
{
gamgi_slist *slist_mark;
gamgi_atom *atom;

slist_mark = GAMGI_CAST_SLIST slist_atom->data;

while (slist_mark != NULL)
  {
  atom = GAMGI_CAST_ATOM slist_mark->data;
  gamgi_math_modify_rotate (atom, origin, rotate);
  slist_mark = slist_mark->next;
  }
}

/******************** internal function ****************
 *                                                     *
 *                       STATIC_LENGTH                 *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_length (gamgi_atom *atom1, 
gamgi_atom *atom2, double *translate)
{
gamgi_atom *atom;
gamgi_bond *bond;
gamgi_slist *slist_atom;
gamgi_dlist *dlist_bond;

atom1->mark = 1;
atom2->mark = -1;

gamgi_math_modify_translate (atom1, translate);

slist_atom = NULL;
dlist_bond = atom1->bond_start;
while (dlist_bond != NULL)
  {
  bond = GAMGI_CAST_BOND dlist_bond->data;
  atom = bond->atom1; if (atom == atom1) atom = bond->atom2;

  slist_atom = gamgi_engine_slist_add_start (slist_atom);
  slist_atom->data = NULL;

  if (static_mark (atom, slist_atom) == FALSE) static_translate (slist_atom, translate);

  dlist_bond = dlist_bond->next;
  }

atom1->mark = 0;
atom2->mark = 0;

static_unmark (slist_atom);
}

/******************** internal function ****************
 *                                                     *
 *                       STATIC_ANGLE                  *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_angle (gamgi_atom *atom1, 
gamgi_atom *atom2, gamgi_atom *atom3, double *origin, 
double *rotate)
{
gamgi_atom *atom;
gamgi_bond *bond;
gamgi_slist *slist_atom;
gamgi_dlist *dlist_bond;

atom1->mark = 1;
atom2->mark = -1;
atom3->mark = -1;

gamgi_math_modify_rotate (atom1, origin, rotate);

slist_atom = NULL;
dlist_bond = atom1->bond_start;
while (dlist_bond != NULL)
  {
  bond = GAMGI_CAST_BOND dlist_bond->data;
  atom = bond->atom1; if (atom == atom1) atom = bond->atom2;

  slist_atom = gamgi_engine_slist_add_start (slist_atom);
  slist_atom->data = NULL;

  if (static_mark (atom, slist_atom) == FALSE) 
    static_rotate (slist_atom, origin, rotate);

  dlist_bond = dlist_bond->next;
  }

atom1->mark = 0;
atom2->mark = 0;
atom3->mark = 0;

static_unmark (slist_atom);
}

/******************** internal function ****************
 *                                                     *
 *                      STATIC_TORSION                 *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_torsion (gamgi_atom *atom1, 
gamgi_atom *atom2, gamgi_atom *atom3, gamgi_atom *atom4,
double *origin, double *rotate)
{
gamgi_atom *atom;
gamgi_bond *bond;
gamgi_slist *slist_atom;
gamgi_dlist *dlist_bond;

atom1->mark = 1;
atom2->mark = -1;
atom3->mark = -1;
atom4->mark = -1;

gamgi_math_modify_rotate (atom1, origin, rotate);

slist_atom = NULL;
dlist_bond = atom1->bond_start;
while (dlist_bond != NULL)
  {
  bond = GAMGI_CAST_BOND dlist_bond->data;
  atom = bond->atom1; if (atom == atom1) atom = bond->atom2;

  slist_atom = gamgi_engine_slist_add_start (slist_atom);
  slist_atom->data = NULL;

  if (static_mark (atom, slist_atom) == FALSE)
    static_rotate (slist_atom, origin, rotate);

  dlist_bond = dlist_bond->next;
  }

atom1->mark = 0;
atom2->mark = 0;
atom3->mark = 0;
atom4->mark = 0;

static_unmark (slist_atom);
}

/******************** internal function ****************
 *                                                     *
 *                       STATIC_SWITCH                 *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_switch (GtkNotebook *notebook, 
GtkNotebookPage *page, int tag, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *frame_length, *frame_angle, *frame_torsion;
GtkWidget* vbox = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), tag);
GtkWidget *entry;

frame_length = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "frame_length");
frame_angle = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "frame_angle");
frame_torsion = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "frame_torsion");

gtk_widget_hide (frame_length);
gtk_widget_hide (frame_angle);
gtk_widget_hide (frame_torsion);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_value");
gtk_entry_set_text (GTK_ENTRY (entry), "");

switch (tag)
  {
  case 2:
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name4");
  gtk_entry_set_text (GTK_ENTRY (entry), "");

  case 1:
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name3");
  gtk_entry_set_text (GTK_ENTRY (entry), "");

  case 0:
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name2");
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name1");
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  break;
  }

switch (tag)
  {
  case 0:
  gtk_widget_show (frame_length);
  break;

  case 1:
  gtk_widget_show (frame_angle);
  break;

  case 2:
  gtk_widget_show (frame_torsion);
  break;
  }

}

/******************** internal function ****************
 *                                                     *
 *                      STATIC_RESET                   *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_reset (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *notebook;
GtkWidget* vbox;
GtkEntry *entry;
int page;

notebook = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "notebook");
page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
vbox = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), page);

switch (page)
  {
  case 2:
  entry = (GtkEntry *) g_object_get_data (G_OBJECT (vbox), "entry_name4");
  gtk_entry_set_text (entry, "");

  case 1:
  entry = (GtkEntry *) g_object_get_data (G_OBJECT (vbox), "entry_name3");
  gtk_entry_set_text (entry, "");

  case 0:
  entry = (GtkEntry *) g_object_get_data (G_OBJECT (vbox), "entry_name2");
  gtk_entry_set_text (entry, "");
  entry = (GtkEntry *) g_object_get_data (G_OBJECT (vbox), "entry_name1");
  gtk_entry_set_text (entry, "");
  }

entry = (GtkEntry *) g_object_get_data (G_OBJECT (vbox), "entry_value");
gtk_widget_grab_focus (GTK_WIDGET (entry));
gtk_entry_select_region (entry, 0, entry->text_length);
}

/******************** internal function ****************
 *                                                     *
 *                         STATIC_OK                   *
 *                                                     *
 *                                                     *
 *******************************************************/

static void static_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_atom *atom1, *atom2, *atom3, *atom4;
GtkWidget *dialog = window->dialog0;
GtkWidget *notebook;
GtkWidget* vbox;
GtkWidget *entry;
int page;
const char *name;
double value;
double translate[3], origin[3], rotate[9];

notebook = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "notebook");
page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
vbox = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), page);

/***********************************
 * this unneeded initialization    *
 * avoids a O3 compilation warning *
 ***********************************/

atom1 = atom2 = atom3 = atom4 = 0;

switch (page)
  {
  case 2:

  /*************
   * Get atom4 *
   *************/

  atom4 = GAMGI_CAST_ATOM gamgi_gtk_object_name_number (vbox,
  "entry_name4", GAMGI_ENGINE_ATOM, window);
  if (atom4 == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Object", window);
    return;
    }

  case 1:

  /*************
   * Get atom3 *
   *************/

  atom3 = GAMGI_CAST_ATOM gamgi_gtk_object_name_number (vbox,
  "entry_name3", GAMGI_ENGINE_ATOM, window);
  if (atom3 == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Object", window);
    return;
    }

  case 0:

  /*************
   * Get atom2 *
   *************/

  atom2 = GAMGI_CAST_ATOM gamgi_gtk_object_name_number (vbox,
  "entry_name2", GAMGI_ENGINE_ATOM, window);
  if (atom2 == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Object", window);
    return;
    }

  /*************
   * Get atom1 *
   *************/

  atom1 = GAMGI_CAST_ATOM gamgi_gtk_object_name_number (vbox,
  "entry_name1", GAMGI_ENGINE_ATOM, window);
  if (atom1 == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Object", window);
    return;
    }

  }

switch (page)
  {
  case 2:
  if (atom4 == atom3 || atom4 == atom2 || atom4 == atom1)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Data", window);
    return;
    }

  case 1:
  if (atom3 == atom2 || atom3 == atom1)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Data", window);
    return;
    }

  case 0:
  if (atom2 == atom1)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Atom Data", window);
    return;
    }
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_value");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &value, -DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Value Data", window);
  return;
  }

/***************************
 * reset: clean atom names *
 ***************************/

static_reset (window);

/*******************************************************************
 * calculate: 2) 1) origin axis/rotate matrix; 0) translate vector *
 *******************************************************************/
 
switch (page)
  {
  case 2:
  if (gamgi_math_modify_torsion (atom4, atom3, atom2, atom1,
  value, origin, rotate, window->layer) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }
  break;
  
  case 1:
  if (gamgi_math_modify_angle (atom3, atom2, atom1,
  value, origin, rotate, window->layer) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }
  break;

  case 0:
  gamgi_math_modify_length (atom2, atom1, value, translate);
  break;
  }

/***************************************
 * Save current layer as undo buffer   *
 * layer so it can be recovered later. *
 ***************************************/

gamgi_gtk_history_update (window->layer, window->layer->undo, GAMGI_ENGINE_UNDO);

/*************************
 * apply transformations *
 *************************/

switch (page)
  {
  case 2:
  static_torsion (atom4, atom3, atom2, atom1, origin, rotate);
  break;
 
  case 1:
  static_angle (atom3, atom2, atom1, origin, rotate);
  break;

  case 0:
  static_length (atom2, atom1, translate);
  break;
  }

/************************
 * Redraw gl_area image *
 ************************/

gtk_widget_queue_draw (window->area);
}

static void static_press (gamgi_object *object, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *notebook;
GtkWidget* vbox;
GtkWidget *entry, *entry1, *entry2, *entry3, *entry4;
gamgi_atom *atom;
char string[2 * GAMGI_ENGINE_TOKEN] = "";
const char *name, *name1, *name2, *name3, *name4;
int page;

atom = GAMGI_CAST_ATOM object;

notebook = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "notebook");
page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
vbox = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), page);

/***********************************
 * this unneeded initialization    *
 * avoids a O3 compilation warning *
 ***********************************/

entry1 = entry2 = entry3 = entry4 = 0;

switch (page)
  {
  case 2:
  entry4 = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name4");

  case 1:
  entry3 = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name3");

  case 0:
  entry2 = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name2");
  entry1 = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_name1");
  }

switch (page)
  {
  case 2:
  name4 = gtk_entry_get_text (GTK_ENTRY (entry4));
  if (gamgi_io_token_check (name4) == FALSE)
    {
    sprintf (string, "%s %d", atom->object.name, atom->object.number);
    gtk_entry_set_text (GTK_ENTRY (entry4), string);
    break;
    }

  case 1:
  name3 = gtk_entry_get_text (GTK_ENTRY (entry3));
  if (gamgi_io_token_check (name3) == FALSE)
    {
    sprintf (string, "%s %d", atom->object.name, atom->object.number);
    gtk_entry_set_text (GTK_ENTRY (entry3), string);
    break;
    }

  case 0:
  name2 = gtk_entry_get_text (GTK_ENTRY (entry2));
  if (gamgi_io_token_check (name2) == FALSE)
    {
    sprintf (string, "%s %d", atom->object.name, atom->object.number);
    gtk_entry_set_text (GTK_ENTRY (entry2), string);
    break;
    }

  name1 = gtk_entry_get_text (GTK_ENTRY (entry1));
  if (gamgi_io_token_check (name1) == FALSE)
    {
    sprintf (string, "%s %d", atom->object.name, atom->object.number);
    gtk_entry_set_text (GTK_ENTRY (entry1), string);
    break;
    }
  }
if (strcmp (string, "") == 0) return;

gamgi_gtk_dialog_beep ();

switch (page)
  {
  case 2:
  name4 = gtk_entry_get_text (GTK_ENTRY (entry4));
  if (gamgi_io_token_check (name4) == FALSE) return;
  
  case 1:
  name3 = gtk_entry_get_text (GTK_ENTRY (entry3));
  if (gamgi_io_token_check (name3) == FALSE) return;

  case 0:
  name2 = gtk_entry_get_text (GTK_ENTRY (entry2));
  if (gamgi_io_token_check (name2) == FALSE) return;

  name1 = gtk_entry_get_text (GTK_ENTRY (entry1));
  if (gamgi_io_token_check (name1) == FALSE) return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (vbox), "entry_value");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (strcmp (name, "") == 0) return;

static_ok (NULL, window);
}

/******************* external function *****************
 *                                                     *
 *             GAMGI_GTK_GROUP_MODIFY_PRESS            *
 *                                                     *
 *                                                     *
 *******************************************************/

void gamgi_gtk_group_modify_press (gamgi_window *window_mouse,
int x, int y, gamgi_window *window_dialog)
{
/******************************
 * local mouse selection only *
 ******************************/

if (window_dialog != window_mouse) return;

gamgi_mesa_select_object (window_mouse, x, y, 
GAMGI_ENGINE_ATOM, FALSE, static_press);
}

/******************* external function *****************
 *                                                     *
 *                 GAMGI_GTK_GROUP_MODIFY              *
 *                                                     *
 *                                                     *
 *******************************************************/

void gamgi_gtk_group_modify (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *notebook;
GtkWidget *frame;
GtkWidget *label;
GtkWidget *vbox, *vbox0, *vbox1;
GtkWidget *hbox;
GtkWidget *entry;
GtkWidget *button;

/******************
 * Dialog level 0 *
 ******************/

dialog = gamgi_gtk_dialog_task0_create ("Group Modify", window);
window->action = GAMGI_GTK_GROUP_MODIFY;

vbox = gtk_vbox_new (FALSE, 0);
gtk_container_add (GTK_CONTAINER (dialog), vbox);
gtk_widget_show (vbox);

/*******************
 * create notebook *
 *******************/

notebook = gtk_notebook_new ();
g_object_set_data (G_OBJECT (dialog), "notebook", notebook);
gtk_box_pack_start (GTK_BOX (vbox), notebook, FALSE, FALSE, 0);
gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
gtk_notebook_set_homogeneous_tabs (GTK_NOTEBOOK (notebook), TRUE);
gtk_widget_show (notebook);

/* length page */
vbox0 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox0), 5);
label = gtk_label_new ("Length");
gtk_widget_show (vbox0);
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox0, label);

frame = gtk_frame_new ("Atom");
g_object_set_data (G_OBJECT (dialog), "frame_length", frame);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_box_pack_start (GTK_BOX (vbox0), frame, TRUE, TRUE, 0);
gtk_widget_show (frame);

vbox1 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
gtk_container_add (GTK_CONTAINER (frame), vbox1);
gtk_widget_show (vbox1);

/* atom2 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name2", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("1");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom1 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name1", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("2");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* Value */
hbox = gtk_hbox_new (FALSE, 0);
gtk_box_pack_start (GTK_BOX (vbox0), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
gtk_box_pack_end (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
g_object_set_data (G_OBJECT (vbox0), "entry_value", entry);
gtk_widget_show (entry);

label = gtk_label_new ("Value");
gtk_widget_show (label);
gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, FALSE, 5);

/* angle page */
vbox0 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox0), 5);
label = gtk_label_new ("Angle");
gtk_widget_show (vbox0);
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox0, label);

frame = gtk_frame_new ("Atom");
g_object_set_data (G_OBJECT (dialog), "frame_angle", frame);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_box_pack_start (GTK_BOX (vbox0), frame, TRUE, TRUE, 0);

vbox1 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
gtk_container_add (GTK_CONTAINER (frame), vbox1);
gtk_widget_show (vbox1);

/* atom3 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name3", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("1");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom2 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name2", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("2");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom1 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name1", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

label = gtk_label_new ("3");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* Value */
hbox = gtk_hbox_new (FALSE, 0);
gtk_box_pack_start (GTK_BOX (vbox0), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_value", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
gtk_box_pack_end (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

label = gtk_label_new ("Value");
gtk_widget_show (label);
gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, FALSE, 5);

/* torsion page */
vbox0 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox0), 5);
label = gtk_label_new ("Torsion");
gtk_widget_show (vbox0);
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox0, label);

frame = gtk_frame_new ("Atom");
g_object_set_data (G_OBJECT (dialog), "frame_torsion", frame);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_box_pack_start (GTK_BOX (vbox0), frame, TRUE, TRUE, 0);

vbox1 = gtk_vbox_new (FALSE, 5);
gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
gtk_container_add (GTK_CONTAINER (frame), vbox1);
gtk_widget_show (vbox1);

/* atom4 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name4", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("1");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom3 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name3", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("2");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom2 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name2", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("3");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* atom1 */
hbox = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_name1", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

/* names are inverted due to switch cascade */
label = gtk_label_new ("4");
gtk_widget_show (label);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* Value */
hbox = gtk_hbox_new (FALSE, 0);
gtk_box_pack_start (GTK_BOX (vbox0), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

entry = gtk_entry_new ();
g_object_set_data (G_OBJECT (vbox0), "entry_value", entry);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_10);
gtk_box_pack_end (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
gtk_widget_show (entry);

label = gtk_label_new ("Value");
gtk_widget_show (label);
gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, FALSE, 5);

/* buttons */
hbox = gtk_hbox_new (TRUE, 0);
gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
gtk_widget_show (hbox);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_ok), window);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_widget_grab_focus (button);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (gamgi_gtk_dialog_task0_remove), window);
gtk_widget_show (button);

gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
g_signal_connect (GTK_OBJECT (notebook), "switch_page",
G_CALLBACK (static_switch), window);
gtk_widget_show (dialog);
}
