/******************************************
 *
 * $GAMGI/src/mesa/gamgi_mesa_text.h
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

/*
 * OGLFT: A library for drawing text with OpenGL using the FreeType library
 * Copyright (C) 2002 lignum Computing, Inc.
 * Author: Allen Barnett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * GLE: The Tubing and Extrusion Library
 * Copyright (C) 1991,1994,2003 Linas Vepstas
 *
 * SOFTWARE AGREEMENT
 *
 * PLEASE READ THIS AGREEMENT CAREFULLY BEFORE INSTALLING OR USING THIS
 * SOFTWARE.  IF YOU INSTALL OR USE THIS SOFTWARE, YOU AGREE TO THESE
 * TERMS.
 *
 * This software is owned by International Business Machines Corporation
 * ("IBM"), or its subsidiaries or IBM's suppliers, and is copyrighted and
 * licensed, not sold.  IBM retains title to the software, and grants you a
 * nonexclusive license for the software.
 *
 * Under this license, you may:
 *
 * 1) use the software on one or more machines at a time;
 * 2) make copies of the software for use or backup purposes within your
 *    enterprise;
 * 3) modify this software and merge it with another program; and
 * 4) make copies of the original file you downloaded and distribute it,
 *    provided that you transfer a copy of this license to the other party.
 *    The other party agrees to these terms by its first use of this software.
 *
 * You must reproduce the copyright notice and any other legend of
 * ownership on each copy or partial copy of the software.
 *
 * This software, as provided by IBM, is only intended to assist in the
 * development of a working software program. The software may not function
 * as written: additional code is required. In addition, the software may
 * not compile and/or bind successfully as written.
 *
 * IBM PROVIDES THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
 * AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH YOU.  SHOULD
 * ANY PART OF THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE ENTIRE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION. IN NO EVENT, UNLESS
 * REQUIRED BY APPLICABLE LAW, SHALL IBM BE LIABLE TO YOU FOR DAMAGES,
 * INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OR INABILITY TO USE THE SOFTWARE (INCLUDING BUT
 * NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
 * SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE SOFTWARE TO
 * OPERATE WITH ANY OTHER PROGRAMS), EVEN IF IBM HAS BEEN ADVISED IN
 * ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * IBM does not warrant that the contents of the software will meet your
 * requirements, that the software is error-free or that the software does
 * not infringe on any intellectual property rights of any third party.
 *
 * IBM may make improvements and/or changes in the software at any time.
 *
 * Changes may or may not be made periodically to the information in the
 * software; these changes may be reported, for the software included
 * herein, in new editions.
 *
 * References, if any, in the software to IBM products, programs, or
 * services do not imply that IBM intends to make these available in all
 * countries in which IBM operates. Any reference to an IBM licensed
 * program in the software is not intended to state or imply that only
 * IBM's licensed program may be used. Any functionally equivalent program
 * may be used.
 *
 * The laws of New York State govern this agreement.
 */

/**********************
 * external functions *
 **********************/

void gamgi_mesa_text_data_wired (gamgi_enum font,
const float **points, const int **driver);

void gamgi_mesa_text_data_solid (gamgi_enum font, char *filename);

void gamgi_mesa_text_font_create (gamgi_enum font, int **glyphs);

void gamgi_mesa_text_font_remove (gamgi_enum font, int **glyphs);

void gamgi_mesa_text_font_start (void);

void gamgi_mesa_text_font_end (void);

/**********************
 * internal functions *
 **********************

void static_extrusion (int n_contour, double *contour, double *normals, 
double scale);

static void static_glu_begin (GLenum polygon);

static void static_glu_vertex (double* vertex)

static void static_glu_end (void);

static void static_glu_combine (double coords[3], void* vertices[4], 
float weights[4], void** output, gamgi_extruded* extruded);

static void static_glu_error (GLenum error_code);

static int static_horizontal_move (FT_Vector* to, gamgi_extruded* extruded);

static int static_horizontal_line (FT_Vector* to, gamgi_extruded* extruded);

static int static_horizontal_conic (FT_Vector* control, 
FT_Vector* to, gamgi_extruded* extruded);

static int static_horizontal_cubic (FT_Vector* control1, 
FT_Vector* control2, FT_Vector* to, gamgi_extruded* extruded);

static int static_vertical_move (FT_Vector* to, gamgi_extruded* extruded);

static int static_vertical_line (FT_Vector* to, gamgi_extruded* extruded)

static int static_vertical_conic (FT_Vector* control, 
FT_Vector* to, gamgi_extruded* extruded);

static int static_vertical_cubic (FT_Vector* control1, 
FT_Vector* control2, FT_Vector* to, gamgi_extruded* extruded);

static void static_face (gamgi_extruded *extruded, 
FT_OutlineGlyph glyph);

static gamgi_bool static_compile_wired (const float *points,
const int *driver, int c);

static gamgi_bool static_compile_solid (FT_Face face,
gamgi_extruded *extruded, int c);

static gamgi_bool static_compile (gamgi_enum font,
const float *points, const int *driver, FT_Face face,
gamgi_extruded *extruded, int c);

static gamgi_extruded *static_extruded_create (gamgi_enum font,
FT_Library *freetype, FT_Face *face);

static gamgi_bool static_extruded_remove (FT_Library freetype,
FT_Face face, gamgi_extruded *extruded);

static gamgi_bool static_start (gamgi_enum font,
const float **points, const int **driver, FT_Library *freetype, 
FT_Face *face, gamgi_extruded **extruded);

static gamgi_bool static_end (gamgi_enum font,
FT_Library freetype, FT_Face face, gamgi_extruded *extruded);

static gamgi_bool static_create (gamgi_enum font, 
int ascii, int **glyphs, int *n_glyphs, const float *points,
const int *driver, FT_Face face, gamgi_extruded *extruded);

static void static_remove (gamgi_enum font,
int ascii, int **glyphs, int *n_glyphs);

static void static_decrease (gamgi_enum font, char *string, int length);

static gamgi_bool static_new (gamgi_enum font,
char *string, int length, int **glyphs);

static gamgi_bool static_center_wired (char *string,
int length, const float *points, double *center);

static gamgi_bool static_center_solid (char *string, int length,
FT_Face face, gamgi_extruded *extruded, double *center);

 **********************
 * external functions *
 **********************/

gamgi_bool gamgi_mesa_text_font_increase (gamgi_text *text);

void gamgi_mesa_text_font_decrease (gamgi_text *text);

gamgi_bool gamgi_mesa_text_center (gamgi_enum font,
char *string, int length, double *center);

void gamgi_mesa_text_create (gamgi_text *text, const char *contents);

void gamgi_mesa_text_remove (gamgi_text *text);

void gamgi_mesa_text_draw (gamgi_text *text);

/*************
 * Rationale *
 *************

Done, solid fonts require external .ttf files.

 *************
 * Rationale *
 *************/
