/* (c) 2002-2004 by Marcin Wiacek and others */

#ifndef __coding_h
#define __coding_h

#if defined(_MSC_VER) && defined(__cplusplus)
    extern "C" {
#endif

#include <stdlib.h>
#ifdef HAVE_WCHAR_H
#  include <wchar.h>
#endif
#ifdef HAVE_WCTYPE_H
#  include <wctype.h>
#endif

#include <gammu-unicode.h>

#ifndef HAVE_WCHAR_T
typedef		int wchar_t;
#endif

#ifndef HAVE_WINT_T
typedef		int wint_t;
#endif

/* MSVC provides same function under different name */
#if _MSC_VER >= 1300
#include <stdlib.h>
#define strtoull _strtoui64
#endif

/* ---------------------------- Unicode ------------------------------------ */
bool 		myiswspace	  		(unsigned const char *src);
#ifndef HAVE_TOWLOWER
wchar_t		towlower			(wchar_t c);
#endif

int		EncodeWithUnicodeAlphabet	(const unsigned char *value, wchar_t *dest);
int		DecodeWithUnicodeAlphabet	(wchar_t value, unsigned char *dest);


void 		ReverseUnicodeString		(unsigned char *String);

void 		DecodeUnicodeSpecialNOKIAChars	(unsigned char *dest, const unsigned char *src, int len);
void 		EncodeUnicodeSpecialNOKIAChars	(unsigned char *dest, const unsigned char *src, int len);

char 		*EncodeUnicodeSpecialChars	(unsigned char *buffer);
char 		*DecodeUnicodeSpecialChars	(unsigned char *buffer);

/* ------------------------------- BCD ------------------------------------- */
unsigned char	EncodeWithBCDAlphabet		(int value);
int		DecodeWithBCDAlphabet		(unsigned char value);

void		DecodeBCD			(unsigned char *dest, const unsigned char *src, int len);
void		EncodeBCD			(unsigned char *dest, const unsigned char *src, int len, bool fill);

/* ------------------------------ UTF7 ------------------------------------- */
void 		DecodeUTF7			(unsigned char *dest, const unsigned char *src, int len);


/* ---------------------------- ISO88591 ----------------------------------- */
void		DecodeISO88591			(unsigned char *dest, const char *src, int len);
void		DecodeISO88591QuotedPrintable	(unsigned char *dest, const unsigned char *src, int len);

/**
 * Decodes UTF-8 text with XML entities to Unicode.
 */
void DecodeXMLUTF8(unsigned char *dest, const unsigned char *src, int len);

/* ------------------------------- BASE64 ---------------------------------- */
void 		EncodeBASE64			(const unsigned char *Input, unsigned char *Output, int Length);
int 		DecodeBASE64			(const unsigned char *Input, unsigned char *Output, int Length);

/* ---------------------- DefaultAlphabet for SMS -------------------------- */
void 		EncodeDefault			(unsigned char *dest, const unsigned char *src, int *len, bool UseExtensions, unsigned char *ExtraAlphabet);
void		DecodeDefault			(unsigned char *dest, const unsigned char *src, int len, bool UseExtensions,  unsigned char *ExtraAlphabet);
void 		FindDefaultAlphabetLen		(const unsigned char *src, int *srclen, int *smslen, int maxlen);

int GSM_PackSevenBitsToEight	(int offset, unsigned char *input, unsigned char *output, int length);
int GSM_UnpackEightBitsToSeven	(int offset, int in_length, int out_length,
				 unsigned char *input, unsigned char *output);

/* ----------------- Phone numbers according to GSM specs ------------------ */

/**
 * Enum to handle types of phones numbers like
 * specified in GSM 03.40 section 9.1.2.5
 */
typedef enum {
	/**
	 * Unknown number type
	 */
	NUMBER_UNKNOWN_NUMBERING_PLAN_ISDN		= 0x81,
	/**
	 * International number (full number with code of country)
	 */
	NUMBER_INTERNATIONAL_NUMBERING_PLAN_ISDN	= 0x91,
	/**
	 * Alphanumeric number (with chars too)
	 */
	NUMBER_ALPHANUMERIC_NUMBERING_PLAN_UNKNOWN	= 0xD0

	/* specification give also other values */
} GSM_NumberType;

void		GSM_UnpackSemiOctetNumber	(unsigned char *retval, unsigned char *Number, bool semioctet);
int		GSM_PackSemiOctetNumber		(unsigned char *Number, unsigned char *Output, bool semioctet);

/* ---------------------------- Bits --------------------------------------- */

void BufferAlign      (unsigned char *Destination, int *CurrentBit);
void BufferAlignNumber(int *CurrentBit);

void AddBuffer	  (unsigned char *Destination, int *CurrentBit, unsigned char *Source, int BitsToProcess);
void AddBufferByte(unsigned char *Destination, int *CurrentBit, unsigned char Source, int BitsToProcess);

void GetBuffer    (unsigned char *Source, int *CurrentBit, unsigned char *Destination, int BitsToProcess);
void GetBufferInt (unsigned char *Source, int *CurrentBit, int *integer, int BitsToProcess);
void GetBufferI   (unsigned char *Source, int *CurrentBit, int *result, int BitsToProcess);

int GetBit   (unsigned char *Buffer, int BitNum);
int SetBit   (unsigned char *Buffer, int BitNum);
int ClearBit (unsigned char *Buffer, int BitNum);

/* ---------------------------- Other -------------------------------------- */

void StringToDouble	(char *text, double *d);

#ifndef HAVE_STRNCASECMP
extern int strncasecmp (const char *s1, const char *s2, size_t n);
#endif
#ifndef HAVE_STRCASECMP
extern int strcasecmp (const char *s1, const char *s2);
#endif
#ifndef HAVE_STRCHRNUL
extern char *strchrnul(char *s, int find);
#endif

/**
 * Gets line from buffer.
 *
 * @param MergeLines: Determine whether merge lines as vCard style 
 * continuation or quoted printable continutaion.
 * @param Buffer: Data source to parse.
 * @param Pos: Current position in data.
 * @param OutBuffer: Buffer where line will be written.
 * @param MaxLen: Maximal length of data to write.
 */
void MyGetLine		(unsigned char *Buffer, int *Pos, unsigned char *OutBuffer, int MaxLen, bool MergeLines);

char *EncodeSpecialChars(unsigned char *buffer);
char *DecodeSpecialChars(unsigned char *buffer);

#ifdef ICONV_FOUND
bool IconvDecode(const char *charset, const char *input, const size_t inlen, unsigned char *output, size_t outlen);
bool IconvEncode(const char *charset, const unsigned char *input, const size_t inlen, char *output, size_t outlen);
#endif

#if defined(_MSC_VER) && defined(__cplusplus)
    }
#endif

#endif

/* How should editor hadle tabs in this file? Add editor commands here.
 * vim: noexpandtab sw=8 ts=8 sts=8:
 */
