/* (c) 2003 by Marcin Wiacek */

#include <string.h>
#include <ctype.h>

#include <gammu-config.h>

#include "../../misc/coding/coding.h"
#include "../../misc/misc.h"
#include "../gsmlogo.h"
#include "../gsmmisc.h"
#include "backics.h"

#ifdef GSM_ENABLE_BACKUP

GSM_Error SaveICS(char *FileName, GSM_Backup *backup)
{
	int 		i, Length = 0;
	unsigned char 	Buffer[1000];
	FILE 		*file;

	file = fopen(FileName, "wb");
	if (file == NULL) return ERR_CANTOPENFILE;

	Length=sprintf(Buffer, "BEGIN:VCALENDAR%c%c",13,10);
	Length+=sprintf(Buffer+Length, "VERSION:2.0%c%c",13,10);
	fwrite(Buffer,1,Length,file);

	i=0;
	while (backup->Calendar[i]!=NULL) {
		sprintf(Buffer, "%c%c",13,10);
		fwrite(Buffer,1,2,file);
		Length = 0;
		GSM_EncodeVCALENDAR(Buffer,&Length,backup->Calendar[i],false,Mozilla_iCalendar);
		fwrite(Buffer,1,Length,file);
		i++;
	}
	i=0;
	while (backup->ToDo[i]!=NULL) {
		sprintf(Buffer, "%c%c",13,10);
		fwrite(Buffer,1,2,file);
		Length = 0;
		GSM_EncodeVTODO(Buffer,&Length,backup->ToDo[i],false,Mozilla_VToDo);
		fwrite(Buffer,1,Length,file);
		i++;
	}

	Length=sprintf(Buffer, "%c%cEND:VCALENDAR%c%c",13,10,13,10);
	fwrite(Buffer,1,Length,file);

	fclose(file);
	return ERR_NONE;
}

GSM_Error LoadICS(char *FileName, GSM_Backup *backup)
{
	GSM_File 		File;
	GSM_Error		error;
	GSM_CalendarEntry	Calendar;
	GSM_ToDoEntry		ToDo;
	int			numCal = 0, numToDo = 0, Pos;

	File.Buffer = NULL;
	error = GSM_ReadFile(FileName, &File);
	if (error != ERR_NONE) return error;

	Pos = 0;
	while (1) {
		error = GSM_DecodeVCALENDAR_VTODO(File.Buffer, &Pos, &Calendar, &ToDo, Mozilla_iCalendar, Mozilla_VToDo);
		if (error == ERR_EMPTY) break;
		if (error != ERR_NONE) return error;

		if (Calendar.EntriesNum != 0) {
			dbgprintf("numCal=%i\n",numCal);
			if (numCal < GSM_MAXCALENDARTODONOTES) {
				backup->Calendar[numCal] = malloc(sizeof(GSM_CalendarEntry));
				dbgprintf("malloc=%p\n",backup->Calendar[numCal]);
			        if (backup->Calendar[numCal] == NULL) return ERR_MOREMEMORY;
				backup->Calendar[numCal + 1] = NULL;
			} else {
				dbgprintf("Increase GSM_MAXCALENDARTODONOTES\n");
				return ERR_MOREMEMORY;
			}
			memcpy(backup->Calendar[numCal],&Calendar,sizeof(GSM_CalendarEntry));
			backup->Calendar[numCal]->Location = numCal + 1;
			numCal++;
		}
		if (ToDo.EntriesNum != 0) {
			if (numToDo < GSM_MAXCALENDARTODONOTES) {
				backup->ToDo[numToDo] = malloc(sizeof(GSM_ToDoEntry));
			        if (backup->ToDo[numToDo] == NULL) return ERR_MOREMEMORY;
				backup->ToDo[numToDo + 1] = NULL;
			} else {
				dbgprintf("Increase GSM_MAXCALENDARTODONOTES\n");
				return ERR_MOREMEMORY;
			}
			memcpy(backup->ToDo[numToDo],&ToDo,sizeof(GSM_ToDoEntry));
			backup->ToDo[numToDo]->Location = numToDo + 1;
			numToDo++;
		}
	}
	return ERR_NONE;
}

#endif

/* How should editor hadle tabs in this file? Add editor commands here.
 * vim: noexpandtab sw=8 ts=8 sts=8:
 */
