/**************************************************************************
*
* File:          $RCSfile: daxpy.c,v $
* Module:        BLAS function
* Part of:       Gandalf Library
*
* Revision:      $Revision: 1.3 $
* Last edited:   $Date: 2001/10/04 16:27:00 $
* Author:        $Author: pm $
* Copyright:     Modifications (c) 2000 Imagineer Software Limited
*
* Notes:         
* Private func:  
* History:       Modified from original CLAPACK source code 
*
**************************************************************************/

#include <math.h>
#include <gandalf/linalg/cblas/daxpy.h>
#include <gandalf/common/misc_defs.h>
#include <gandalf/common/compare.h>
#include <gandalf/common/misc_error.h>

/* only define this function locally if there is no LAPACK installed */
#ifndef HAVE_LAPACK

Gan_Bool
 gan_daxpy ( long n, double da,
             double *dx, long incx, double *dy, long incy )
{
   long i;

   gan_err_test_bool ( n >= 0, "gan_daxpy", GAN_ERROR_CBLAS_ILLEGAL_ARG, "" );

   if ( incx == 1 && incy == 1 )
   {
      if ( da == 1.0 ) for ( i = n-1; i >= 0; i-- ) *dy++ +=    *dx++;
      else             for ( i = n-1; i >= 0; i-- ) *dy++ += da**dx++;
   }
   else if ( incx == 1 )
   {
      if ( da == 1.0 )
         for ( i = n-1; i >= 0; dy += incy, i-- ) *dy +=    *dx++;
      else
         for ( i = n-1; i >= 0; dy += incy, i-- ) *dy += da**dx++;
   }
   else if ( incy == 1 )
   {
      if ( da == 1.0 )
         for ( i = n-1; i >= 0; dx += incx, i-- ) *dy++ +=    *dx;
      else
         for ( i = n-1; i >= 0; dx += incx, i-- ) *dy++ += da**dx;
   }
   else /* incx != 1 && incy != 1 */
   {
      if ( da == 1.0 )
         for ( i = n-1; i >= 0; dy += incy, i-- ) *dy +=    *dx++;
      else
         for ( i = n-1; i >= 0; dy += incy, i-- ) *dy += da**dx++;
   }
   
   /* success */
   return GAN_TRUE;
}

#endif /* #ifndef HAVE_LAPACK */
