/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name */
#define CMDLINE_PARSER_PACKAGE "gmond"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * conf_arg;	/**< @brief Location of gmond configuration file (default='SYSCONFDIR/gmond.conf').  */
  char * conf_orig;	/**< @brief Location of gmond configuration file original value given at command line.  */
  const char *conf_help; /**< @brief Location of gmond configuration file help description.  */
  char * location_arg;	/**< @brief Location of this host in the cluster 'rack,rank,plane'. (default='0,0,0').  */
  char * location_orig;	/**< @brief Location of this host in the cluster 'rack,rank,plane'. original value given at command line.  */
  const char *location_help; /**< @brief Location of this host in the cluster 'rack,rank,plane'. help description.  */
  int debug_arg;	/**< @brief Debug level. If greater than zero, daemon will stay in foreground. (default='0').  */
  char * debug_orig;	/**< @brief Debug level. If greater than zero, daemon will stay in foreground. original value given at command line.  */
  const char *debug_help; /**< @brief Debug level. If greater than zero, daemon will stay in foreground. help description.  */
  int foreground_flag;	/**< @brief Run in foreground (don't daemonize) (default=off).  */
  const char *foreground_help; /**< @brief Run in foreground (don't daemonize) help description.  */
  int default_config_flag;	/**< @brief Print the default configuration to stdout and exit (default=off).  */
  const char *default_config_help; /**< @brief Print the default configuration to stdout and exit help description.  */
  int metrics_flag;	/**< @brief Print the list of metrics this gmond supports (default=off).  */
  const char *metrics_help; /**< @brief Print the list of metrics this gmond supports help description.  */
  int bandwidth_flag;	/**< @brief Calculate minimum bandwidth use for configuration (default=off).  */
  const char *bandwidth_help; /**< @brief Calculate minimum bandwidth use for configuration help description.  */
  char * convert_arg;	/**< @brief Convert a 2.5.x configuration file to the new 3.x format.  */
  char * convert_orig;	/**< @brief Convert a 2.5.x configuration file to the new 3.x format original value given at command line.  */
  const char *convert_help; /**< @brief Convert a 2.5.x configuration file to the new 3.x format help description.  */
  char * pid_file_arg;	/**< @brief Write process-id to file.  */
  char * pid_file_orig;	/**< @brief Write process-id to file original value given at command line.  */
  const char *pid_file_help; /**< @brief Write process-id to file help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int conf_given ;	/**< @brief Whether conf was given.  */
  unsigned int location_given ;	/**< @brief Whether location was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int foreground_given ;	/**< @brief Whether foreground was given.  */
  unsigned int default_config_given ;	/**< @brief Whether default_config was given.  */
  unsigned int metrics_given ;	/**< @brief Whether metrics was given.  */
  unsigned int bandwidth_given ;	/**< @brief Whether bandwidth was given.  */
  unsigned int convert_given ;	/**< @brief Whether convert was given.  */
  unsigned int pid_file_given ;	/**< @brief Whether pid-file was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
