#@local p, proof
gap> START_TEST("primality.tst");
gap> p:=2^255-19;
57896044618658097711785492504343953926634992332820282019728792003956564819949
gap> IsPrimeInt(p);
true
gap> proof := First(PrimesProofs, x -> x[1] = p);;
gap> PrimalityProof_Verify(proof[1], proof[2]);

Number proven prime by BLS1975-Th21
assuming each of [ 1130511104457987667447027748002467928093101253934732954783,
  74058212732561358302231226437062788676166966415465897661863160754340907 
 ] have no nontrivial divisors less than 11376
true

#
gap> p := 2^2203-1;
147597991521418023508489862273738173631206614533316977514777121647857029787807\
894937740733704938928938274850753149648047728126483876025919181446336533026954\
049696120111343015690239609398909022625932693502528140961498349938822283144859\
860183431853623092377264139020949023183644689960821079548296376309423663094541\
083279376990539998245718632294472963641889062337217172374210563644036821845964\
963294853869690587265048691443463745750728044182367681351785209934866084717257\
940842231667809767022401199028017047489448742692474210882353680848507250224051\
945258754287534997655857267022963396257521263747789778550155264652260998886991\
4013540483809865681250419497686697771007
gap> IsPrimeInt(p);
true
gap> proof := First(PrimesProofs, x -> x[1] = p);;
gap> PrimalityProof_Verify(proof[1], proof[2]);

Number proven prime by BLS1975-Co8

Number proven prime by BLS1975-Co11
assuming each of 
[ 
  18292712583606135150493044727518561201158368690200711624038153968913580863660\
743762696140516689578569463865867698307557499025939593837700085589741930790314\
112054564371925396423356424991580935326693400732450620240979785174259258228448\
064794390012939625703381829852877024742167126966326635417873882497683932587643\
494812841778697613663006767921726210377509464566914870960408681391304007998328\
120435685325808062486550293894541730675903838807051797590589423514098198584527\
401365514996742494548309539343171233226457592366192969469221721998402102047636\
292233790820295551666129948228370216908259240837269019259490151307167376370794\
6418775157 ] have no nontrivial divisors less than 1(which is true)

Number proven prime by BLS1975-Th21
assuming each of 
[ 
  18292712583606135150493044727518561201158368690200711624038153968913580863660\
743762696140516689578569463865867698307557499025939593837700085589741930790314\
112054564371925396423356424991580935326693400732450620240979785174259258228448\
064794390012939625703381829852877024742167126966326635417873882497683932587643\
494812841778697613663006767921726210377509464566914870960408681391304007998328\
120435685325808062486550293894541730675903838807051797590589423514098198584527\
401365514996742494548309539343171233226457592366192969469221721998402102047636\
292233790820295551666129948228370216908259240837269019259490151307167376370794\
6418775157 ] have no nontrivial divisors less than 2(which is true)
true

# the following test is disabled as it gives different output depending
# on whether FactInt is loaded or not
# gap> p := 2^2281-1;
# 446087557183758429571151706402101809886208632412859901111991219963404685792820\
# 473369112545269003989026153245931124316702395758705693679364790903497461147071\
# 065254193353938124978226307947312410798874869040070279328428810311754844108094\
# 878252494866760969586998128982645877596028979171536962503068429617331702184750\
# 324583009171832104916050157628886606372145501702225925125224076829605427173573\
# 964812995250569412480720738476855293681666712844831190877620606786663862190240\
# 118570736831901886479225810414714078935386562497968178729127629594924411960961\
# 386713946279899275006954917139758796061223803393537381034666494402951052059047\
# 968693255388647930440925104186817009640171764133172418132836351
# gap> IsPrimeInt(p);
# true
# gap> proof := First(PrimesProofs, x -> x[1] = p);;
# gap> PrimalityProof_Verify(proof[1], proof[2]);
# 
# Number proven prime by BLS1975-Co8
# 
# Number proven prime by BLS1975-Co11
# assuming each of 
# [ 
#   76735935801421285221917006422983131608987599665929736236027110501208050853877\
# 252948963413522621556901274571899691714196442428435640866487604987868726546912\
# 111135151734844420192216632495356905549956535882320850987620760841749628521163\
# 332502223416440248618661217945681920831188350861871399165452234206753048348413\
# 503267667725475390878507680628774277398827072972010529624546162994583393283987\
# 251241027063435958014512798539423872477405933563507289695378453210163745714442\
# 10664165724085724335050652954529470432104308848883205806886531133640486331 
#  ] have no nontrivial divisors less than 1(which is true)
# 
# Number proven prime by BLS1975-Th21
# assuming each of 
# [ 
#   76735935801421285221917006422983131608987599665929736236027110501208050853877\
# 252948963413522621556901274571899691714196442428435640866487604987868726546912\
# 111135151734844420192216632495356905549956535882320850987620760841749628521163\
# 332502223416440248618661217945681920831188350861871399165452234206753048348413\
# 503267667725475390878507680628774277398827072972010529624546162994583393283987\
# 251241027063435958014512798539423872477405933563507289695378453210163745714442\
# 10664165724085724335050652954529470432104308848883205806886531133640486331 
#  ] have no nontrivial divisors less than 2(which is true)
# true

#
gap> STOP_TEST("primality.tst", 1);
