/* gasql_conf.c
 *
 * Copyright (C) 1999 - 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gasql_conf.h"

void
gasql_conf_init (gASQL_Main_Config * c)
{
	c->app = NULL;
	c->appbar = NULL;
	c->nb = NULL;
	c->working_box = NULL;
	c->error_dlg = NULL;
	c->manager_bonobo_win = NULL;

	c->tables_page = NULL;
	c->queries_page = NULL;

	c->widgets_show_on_connect = NULL;
	c->widgets_show_on_disconnect = NULL;
	c->widgets_sensitive_on_connect = NULL;
	c->widgets_sensitive_on_disconnect = NULL;

	c->srv = NULL;
	c->db = NULL;
	c->config_dlg = NULL;
	c->conn_open_requested = FALSE;
	c->config_plugins_dlg = NULL;
	c->widdbrel_list = NULL;
	c->queries = NULL;
	c->id_serial = 0;

	c->working_file = NULL;
	c->save_up_to_date = TRUE;
	c->close_after_saving = FALSE;
	c->quit_after_saving = FALSE;

	c->plugins_dir = NULL;

	c->check_dlg = NULL;
	c->check_pbar = NULL;
	c->check_link_name = NULL;
	c->check_errors = NULL;
	c->check_perform = FALSE;

	c->users_list_dlg = NULL;
	c->users_groups_dlg = NULL;
	c->users_acl_dlg = NULL;

	c->printer = NULL;
	c->printcontext = NULL;

	c->datasource = NULL;
	c->user_name = NULL;
	c->user_passwd = NULL;
	c->file_to_open = NULL;
}

/*****************************************************************************/
/*                                                                           */
/* CBs to cope with the sensitiveness of objects regarding to the connection */
/* and with show/hide as well                                                */
/*                                                                           */
/*****************************************************************************/

static void destroy_widget_connect_cb (GtkObject * obj,
				       gASQL_Main_Config * c);

void
gasql_conf_register_sensitive_on_connect (gASQL_Main_Config * c,
					  GtkWidget * wid)
{
	c->widgets_sensitive_on_connect =
		g_slist_append (c->widgets_sensitive_on_connect, wid);
	gtk_signal_connect (GTK_OBJECT (wid), "destroy",
			    GTK_SIGNAL_FUNC (destroy_widget_connect_cb), c);
}

void
gasql_conf_register_sensitive_on_disconnect (gASQL_Main_Config * c,
					     GtkWidget * wid)
{
	c->widgets_sensitive_on_disconnect =
		g_slist_append (c->widgets_sensitive_on_disconnect, wid);
	gtk_signal_connect (GTK_OBJECT (wid), "destroy",
			    GTK_SIGNAL_FUNC (destroy_widget_connect_cb), c);
}

void
gasql_conf_register_show_on_connect (gASQL_Main_Config * c, GtkWidget * wid)
{
	c->widgets_show_on_connect =
		g_slist_append (c->widgets_show_on_connect, wid);
	gtk_signal_connect (GTK_OBJECT (wid), "destroy",
			    GTK_SIGNAL_FUNC (destroy_widget_connect_cb), c);
}

void
gasql_conf_register_show_on_disconnect (gASQL_Main_Config * c,
					GtkWidget * wid)
{
	c->widgets_show_on_disconnect =
		g_slist_append (c->widgets_show_on_disconnect, wid);
	gtk_signal_connect (GTK_OBJECT (wid), "destroy",
			    GTK_SIGNAL_FUNC (destroy_widget_connect_cb), c);
}


static void
destroy_widget_connect_cb (GtkObject * obj, gASQL_Main_Config * c)
{
	gboolean found = FALSE;

	if (g_slist_find (c->widgets_sensitive_on_connect, obj)) {
		c->widgets_sensitive_on_connect = g_slist_remove (c->widgets_sensitive_on_connect,
								  obj);
		found = TRUE;
	}

	if (!found && g_slist_find (c->widgets_sensitive_on_disconnect, obj)) {
		c->widgets_sensitive_on_disconnect = g_slist_remove (c->widgets_sensitive_on_disconnect,
								     obj);
		found = TRUE;
	}

	if (!found && g_slist_find (c->widgets_show_on_connect, obj)) {
		c->widgets_show_on_connect = g_slist_remove (c->widgets_show_on_connect,
							     obj);
		found = TRUE;
	}

	if (!found && g_slist_find (c->widgets_show_on_disconnect, obj)) {
		c->widgets_show_on_disconnect =	g_slist_remove (c->widgets_show_on_disconnect,
								obj);
		found = TRUE;
	}
}

void
gasql_widgets_conn_cb (GtkObject * obj, gASQL_Main_Config * c)
{
	GSList *list;

	list = c->widgets_sensitive_on_connect;
	while (list) {
		if (sql_access_is_open (c->srv))
			gtk_widget_set_sensitive (GTK_WIDGET (list->data),
						  TRUE);
		else
			gtk_widget_set_sensitive (GTK_WIDGET (list->data),
						  FALSE);
		list = g_slist_next (list);
	}
	list = c->widgets_sensitive_on_disconnect;
	while (list) {
		if (sql_access_is_open (c->srv))
			gtk_widget_set_sensitive (GTK_WIDGET (list->data),
						  FALSE);
		else
			gtk_widget_set_sensitive (GTK_WIDGET (list->data),
						  TRUE);
		list = g_slist_next (list);
	}
	list = c->widgets_show_on_connect;
	while (list) {
		if (sql_access_is_open (c->srv))
			gtk_widget_show (GTK_WIDGET (list->data));
		else
			gtk_widget_hide (GTK_WIDGET (list->data));
		list = g_slist_next (list);
	}
	list = c->widgets_show_on_disconnect;
	while (list) {
		if (sql_access_is_open (c->srv))
			gtk_widget_hide (GTK_WIDGET (list->data));
		else
			gtk_widget_show (GTK_WIDGET (list->data));
		list = g_slist_next (list);
	}
}


/*****************************************************************************/
/*                                                                           */
/* Other functions                                                           */
/*                                                                           */
/*****************************************************************************/
guint
get_id_serial (gASQL_Main_Config * c)
{
	guint ret;

	ret = c->id_serial++;
	return ret;
}

gchar *
gasql_get_title (gASQL_Main_Config * c)
{
	gchar *str;

	if (c->working_file)
		str = g_strdup_printf (_("gASQL Version %s - %s"), VERSION,
				       c->working_file);
	else
		str = g_strdup_printf (_("gASQL Version %s - No file"),
				       VERSION);
	return str;
}
