;;;
;;; gauche.vm.insn - VM instruction introspection
;;; (This file is generated automatically; DO NOT EDIT)
;;;  
;;;   Copyright (c) 2004 Shiro Kawai, All rights reserved.
;;;   
;;;   Redistribution and use in source and binary forms, with or without
;;;   modification, are permitted provided that the following conditions
;;;   are met:
;;;   
;;;   1. Redistributions of source code must retain the above copyright
;;;      notice, this list of conditions and the following disclaimer.
;;;  
;;;   2. Redistributions in binary form must reproduce the above copyright
;;;      notice, this list of conditions and the following disclaimer in the
;;;      documentation and/or other materials provided with the distribution.
;;;  
;;;   3. Neither the name of the authors nor the names of its contributors
;;;      may be used to endorse or promote products derived from this
;;;      software without specific prior written permission.
;;;  
;;;   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;;   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;;   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;;   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;;   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;;   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
;;;   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;;   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;;   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;;   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;;   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;  
;;;  $Id: insn.scm.src,v 1.2 2005/04/12 01:42:25 shirok Exp $
;;;

(define-module gauche.vm.insn
  (use util.match)
  (export <vm-insn-info>
          vm-find-insn-info
          vm-build-insn)
  )
(select-module gauche.vm.insn)

(define-class <vm-insn-info> ()
  ((name   :init-keyword :name)           ; name of insn (symbol)
   (code   :init-keyword :code)           ; code of insn (integer)
   (num-params :init-keyword :num-params) ; # of parameters
   (operand-type :init-keyword :operand-type) ; operand type
   
   (all-insns :allocation :class          ; alist of all instructions,
              :init-value '())            ;   keyed by name.
   ))

(define-method initialize ((self <vm-insn-info>) initargs)
  (next-method)
  (push! (ref self 'all-insns)
         (cons (ref self 'name) self)))

;; opcode mnemonic -> <vm-insn-info>
(define (vm-find-insn-info mnemonic)
  (cond ((assq mnemonic (class-slot-ref <vm-insn-info> 'all-insns)) => cdr)
        (else (error "No such VM instruction:" mnemonic))))

;; INSN is a list of opcode and parameters, e.g. (PUSH) or (LREF 3 2)
;; Returns an exact integer of encoded VM instruction code.
;; NB: This must match the macro definitions in src/gauche/vm.h !!!
(define (vm-build-insn insn)
  (match insn
    (((? symbol? opcode) . params)
     (let1 info (vm-find-insn-info opcode)
       (match params
         (()
          (unless (= (ref info 'num-params) 0)
            (errorf "VM instruction ~a takes no parameters, but got ~s"
                    opcode insn))
          (ref info 'code))
         ((arg0)
          (unless (= (ref info 'num-params) 1)
            (errorf "VM instruction ~a takes one parameter, but got ~s"
                    opcode insn))
          (logior (ash (logand arg0 #xffffff) 8)
                  (ref info 'code)))
         ((arg0 arg1)
          (unless (= (ref info 'num-params) 2)
            (errorf "VM instruction ~a takes two parameters, but got ~s"
                    opcode insn))
          (logior (ash (logand arg1 #x3ff) 18)
                  (ash (logand arg0 #x3ff) 8)
                  (ref info 'code)))
         (else (error "vm-build-insn: bad insn:" insn)))))
    (else
     (error "vm-build-insn: bad insn:" insn))))

;; #x000  NOP
(make <vm-insn-info> :name 'NOP :code 0 :num-params 0 :operand-type 'none)
;; #x001  CONST
(make <vm-insn-info> :name 'CONST :code 1 :num-params 0 :operand-type 'obj)
;; #x002  CONSTI
(make <vm-insn-info> :name 'CONSTI :code 2 :num-params 1 :operand-type 'none)
;; #x003  CONSTN
(make <vm-insn-info> :name 'CONSTN :code 3 :num-params 0 :operand-type 'none)
;; #x004  CONSTF
(make <vm-insn-info> :name 'CONSTF :code 4 :num-params 0 :operand-type 'none)
;; #x005  CONSTU
(make <vm-insn-info> :name 'CONSTU :code 5 :num-params 0 :operand-type 'none)
;; #x006  CONST-PUSH
(make <vm-insn-info> :name 'CONST-PUSH :code 6 :num-params 0 :operand-type 'obj)
;; #x007  CONSTI-PUSH
(make <vm-insn-info> :name 'CONSTI-PUSH :code 7 :num-params 1 :operand-type 'none)
;; #x008  CONSTN-PUSH
(make <vm-insn-info> :name 'CONSTN-PUSH :code 8 :num-params 0 :operand-type 'none)
;; #x009  CONSTF-PUSH
(make <vm-insn-info> :name 'CONSTF-PUSH :code 9 :num-params 0 :operand-type 'none)
;; #x00a  CONST-RET
(make <vm-insn-info> :name 'CONST-RET :code 10 :num-params 0 :operand-type 'obj)
;; #x00b  CONSTF-RET
(make <vm-insn-info> :name 'CONSTF-RET :code 11 :num-params 0 :operand-type 'none)
;; #x00c  CONSTU-RET
(make <vm-insn-info> :name 'CONSTU-RET :code 12 :num-params 0 :operand-type 'none)
;; #x00d  PUSH
(make <vm-insn-info> :name 'PUSH :code 13 :num-params 0 :operand-type 'none)
;; #x00e  PRE-CALL
(make <vm-insn-info> :name 'PRE-CALL :code 14 :num-params 1 :operand-type 'addr)
;; #x00f  PUSH-PRE-CALL
(make <vm-insn-info> :name 'PUSH-PRE-CALL :code 15 :num-params 1 :operand-type 'addr)
;; #x010  CHECK-STACK
(make <vm-insn-info> :name 'CHECK-STACK :code 16 :num-params 1 :operand-type 'none)
;; #x011  CALL
(make <vm-insn-info> :name 'CALL :code 17 :num-params 1 :operand-type 'none)
;; #x012  TAIL-CALL
(make <vm-insn-info> :name 'TAIL-CALL :code 18 :num-params 1 :operand-type 'none)
;; #x013  JUMP
(make <vm-insn-info> :name 'JUMP :code 19 :num-params 0 :operand-type 'addr)
;; #x014  RET
(make <vm-insn-info> :name 'RET :code 20 :num-params 0 :operand-type 'none)
;; #x015  DEFINE
(make <vm-insn-info> :name 'DEFINE :code 21 :num-params 1 :operand-type 'obj)
;; #x016  CLOSURE
(make <vm-insn-info> :name 'CLOSURE :code 22 :num-params 0 :operand-type 'code)
;; #x017  LOCAL-ENV
(make <vm-insn-info> :name 'LOCAL-ENV :code 23 :num-params 1 :operand-type 'none)
;; #x018  PUSH-LOCAL-ENV
(make <vm-insn-info> :name 'PUSH-LOCAL-ENV :code 24 :num-params 1 :operand-type 'none)
;; #x019  LOCAL-ENV-CLOSURES
(make <vm-insn-info> :name 'LOCAL-ENV-CLOSURES :code 25 :num-params 1 :operand-type 'codes)
;; #x01a  POP-LOCAL-ENV
(make <vm-insn-info> :name 'POP-LOCAL-ENV :code 26 :num-params 0 :operand-type 'none)
;; #x01b  LOCAL-ENV-JUMP
(make <vm-insn-info> :name 'LOCAL-ENV-JUMP :code 27 :num-params 1 :operand-type 'addr)
;; #x01c  LOCAL-ENV-CALL
(make <vm-insn-info> :name 'LOCAL-ENV-CALL :code 28 :num-params 1 :operand-type 'none)
;; #x01d  LOCAL-ENV-TAIL-CALL
(make <vm-insn-info> :name 'LOCAL-ENV-TAIL-CALL :code 29 :num-params 1 :operand-type 'none)
;; #x01e  BF
(make <vm-insn-info> :name 'BF :code 30 :num-params 0 :operand-type 'addr)
;; #x01f  BT
(make <vm-insn-info> :name 'BT :code 31 :num-params 0 :operand-type 'addr)
;; #x020  BNEQ
(make <vm-insn-info> :name 'BNEQ :code 32 :num-params 0 :operand-type 'addr)
;; #x021  BNEQV
(make <vm-insn-info> :name 'BNEQV :code 33 :num-params 0 :operand-type 'addr)
;; #x022  BNNULL
(make <vm-insn-info> :name 'BNNULL :code 34 :num-params 0 :operand-type 'addr)
;; #x023  BNUMNE
(make <vm-insn-info> :name 'BNUMNE :code 35 :num-params 0 :operand-type 'addr)
;; #x024  BNLT
(make <vm-insn-info> :name 'BNLT :code 36 :num-params 0 :operand-type 'addr)
;; #x025  BNLE
(make <vm-insn-info> :name 'BNLE :code 37 :num-params 0 :operand-type 'addr)
;; #x026  BNGT
(make <vm-insn-info> :name 'BNGT :code 38 :num-params 0 :operand-type 'addr)
;; #x027  BNGE
(make <vm-insn-info> :name 'BNGE :code 39 :num-params 0 :operand-type 'addr)
;; #x028  BNUMNEI
(make <vm-insn-info> :name 'BNUMNEI :code 40 :num-params 1 :operand-type 'addr)
;; #x029  BNEQC
(make <vm-insn-info> :name 'BNEQC :code 41 :num-params 0 :operand-type 'obj+addr)
;; #x02a  BNEQVC
(make <vm-insn-info> :name 'BNEQVC :code 42 :num-params 0 :operand-type 'obj+addr)
;; #x02b  RF
(make <vm-insn-info> :name 'RF :code 43 :num-params 0 :operand-type 'none)
;; #x02c  RT
(make <vm-insn-info> :name 'RT :code 44 :num-params 0 :operand-type 'none)
;; #x02d  RNEQ
(make <vm-insn-info> :name 'RNEQ :code 45 :num-params 0 :operand-type 'none)
;; #x02e  RNEQV
(make <vm-insn-info> :name 'RNEQV :code 46 :num-params 0 :operand-type 'none)
;; #x02f  RNNULL
(make <vm-insn-info> :name 'RNNULL :code 47 :num-params 0 :operand-type 'none)
;; #x030  RECEIVE
(make <vm-insn-info> :name 'RECEIVE :code 48 :num-params 2 :operand-type 'addr)
;; #x031  TAIL-RECEIVE
(make <vm-insn-info> :name 'TAIL-RECEIVE :code 49 :num-params 2 :operand-type 'none)
;; #x032  LSET
(make <vm-insn-info> :name 'LSET :code 50 :num-params 2 :operand-type 'none)
;; #x033  LSET0
(make <vm-insn-info> :name 'LSET0 :code 51 :num-params 0 :operand-type 'none)
;; #x034  LSET1
(make <vm-insn-info> :name 'LSET1 :code 52 :num-params 0 :operand-type 'none)
;; #x035  LSET2
(make <vm-insn-info> :name 'LSET2 :code 53 :num-params 0 :operand-type 'none)
;; #x036  LSET3
(make <vm-insn-info> :name 'LSET3 :code 54 :num-params 0 :operand-type 'none)
;; #x037  LSET4
(make <vm-insn-info> :name 'LSET4 :code 55 :num-params 0 :operand-type 'none)
;; #x038  GSET
(make <vm-insn-info> :name 'GSET :code 56 :num-params 0 :operand-type 'obj)
;; #x039  LREF
(make <vm-insn-info> :name 'LREF :code 57 :num-params 2 :operand-type 'none)
;; #x03a  LREF0
(make <vm-insn-info> :name 'LREF0 :code 58 :num-params 0 :operand-type 'none)
;; #x03b  LREF1
(make <vm-insn-info> :name 'LREF1 :code 59 :num-params 0 :operand-type 'none)
;; #x03c  LREF2
(make <vm-insn-info> :name 'LREF2 :code 60 :num-params 0 :operand-type 'none)
;; #x03d  LREF3
(make <vm-insn-info> :name 'LREF3 :code 61 :num-params 0 :operand-type 'none)
;; #x03e  LREF4
(make <vm-insn-info> :name 'LREF4 :code 62 :num-params 0 :operand-type 'none)
;; #x03f  LREF10
(make <vm-insn-info> :name 'LREF10 :code 63 :num-params 0 :operand-type 'none)
;; #x040  LREF11
(make <vm-insn-info> :name 'LREF11 :code 64 :num-params 0 :operand-type 'none)
;; #x041  LREF12
(make <vm-insn-info> :name 'LREF12 :code 65 :num-params 0 :operand-type 'none)
;; #x042  LREF13
(make <vm-insn-info> :name 'LREF13 :code 66 :num-params 0 :operand-type 'none)
;; #x043  LREF14
(make <vm-insn-info> :name 'LREF14 :code 67 :num-params 0 :operand-type 'none)
;; #x044  LREF-PUSH
(make <vm-insn-info> :name 'LREF-PUSH :code 68 :num-params 2 :operand-type 'none)
;; #x045  LREF0-PUSH
(make <vm-insn-info> :name 'LREF0-PUSH :code 69 :num-params 0 :operand-type 'none)
;; #x046  LREF1-PUSH
(make <vm-insn-info> :name 'LREF1-PUSH :code 70 :num-params 0 :operand-type 'none)
;; #x047  LREF2-PUSH
(make <vm-insn-info> :name 'LREF2-PUSH :code 71 :num-params 0 :operand-type 'none)
;; #x048  LREF3-PUSH
(make <vm-insn-info> :name 'LREF3-PUSH :code 72 :num-params 0 :operand-type 'none)
;; #x049  LREF4-PUSH
(make <vm-insn-info> :name 'LREF4-PUSH :code 73 :num-params 0 :operand-type 'none)
;; #x04a  LREF10-PUSH
(make <vm-insn-info> :name 'LREF10-PUSH :code 74 :num-params 0 :operand-type 'none)
;; #x04b  LREF11-PUSH
(make <vm-insn-info> :name 'LREF11-PUSH :code 75 :num-params 0 :operand-type 'none)
;; #x04c  LREF12-PUSH
(make <vm-insn-info> :name 'LREF12-PUSH :code 76 :num-params 0 :operand-type 'none)
;; #x04d  LREF13-PUSH
(make <vm-insn-info> :name 'LREF13-PUSH :code 77 :num-params 0 :operand-type 'none)
;; #x04e  LREF14-PUSH
(make <vm-insn-info> :name 'LREF14-PUSH :code 78 :num-params 0 :operand-type 'none)
;; #x04f  GREF
(make <vm-insn-info> :name 'GREF :code 79 :num-params 0 :operand-type 'obj)
;; #x050  GREF-PUSH
(make <vm-insn-info> :name 'GREF-PUSH :code 80 :num-params 0 :operand-type 'obj)
;; #x051  GREF-CALL
(make <vm-insn-info> :name 'GREF-CALL :code 81 :num-params 1 :operand-type 'obj)
;; #x052  GREF-TAIL-CALL
(make <vm-insn-info> :name 'GREF-TAIL-CALL :code 82 :num-params 1 :operand-type 'obj)
;; #x053  PUSH-GREF
(make <vm-insn-info> :name 'PUSH-GREF :code 83 :num-params 0 :operand-type 'obj)
;; #x054  PUSH-GREF-CALL
(make <vm-insn-info> :name 'PUSH-GREF-CALL :code 84 :num-params 1 :operand-type 'obj)
;; #x055  PUSH-GREF-TAIL-CALL
(make <vm-insn-info> :name 'PUSH-GREF-TAIL-CALL :code 85 :num-params 1 :operand-type 'obj)
;; #x056  PROMISE
(make <vm-insn-info> :name 'PROMISE :code 86 :num-params 0 :operand-type 'none)
;; #x057  CONST-APPLY
(make <vm-insn-info> :name 'CONST-APPLY :code 87 :num-params 1 :operand-type 'obj)
;; #x058  CONS
(make <vm-insn-info> :name 'CONS :code 88 :num-params 0 :operand-type 'none)
;; #x059  CONS-PUSH
(make <vm-insn-info> :name 'CONS-PUSH :code 89 :num-params 0 :operand-type 'none)
;; #x05a  CAR
(make <vm-insn-info> :name 'CAR :code 90 :num-params 0 :operand-type 'none)
;; #x05b  CAR-PUSH
(make <vm-insn-info> :name 'CAR-PUSH :code 91 :num-params 0 :operand-type 'none)
;; #x05c  CDR
(make <vm-insn-info> :name 'CDR :code 92 :num-params 0 :operand-type 'none)
;; #x05d  CDR-PUSH
(make <vm-insn-info> :name 'CDR-PUSH :code 93 :num-params 0 :operand-type 'none)
;; #x05e  CAAR
(make <vm-insn-info> :name 'CAAR :code 94 :num-params 0 :operand-type 'none)
;; #x05f  CAAR-PUSH
(make <vm-insn-info> :name 'CAAR-PUSH :code 95 :num-params 0 :operand-type 'none)
;; #x060  CADR
(make <vm-insn-info> :name 'CADR :code 96 :num-params 0 :operand-type 'none)
;; #x061  CADR-PUSH
(make <vm-insn-info> :name 'CADR-PUSH :code 97 :num-params 0 :operand-type 'none)
;; #x062  CDAR
(make <vm-insn-info> :name 'CDAR :code 98 :num-params 0 :operand-type 'none)
;; #x063  CDAR-PUSH
(make <vm-insn-info> :name 'CDAR-PUSH :code 99 :num-params 0 :operand-type 'none)
;; #x064  CDDR
(make <vm-insn-info> :name 'CDDR :code 100 :num-params 0 :operand-type 'none)
;; #x065  CDDR-PUSH
(make <vm-insn-info> :name 'CDDR-PUSH :code 101 :num-params 0 :operand-type 'none)
;; #x066  LIST
(make <vm-insn-info> :name 'LIST :code 102 :num-params 1 :operand-type 'none)
;; #x067  LIST-STAR
(make <vm-insn-info> :name 'LIST-STAR :code 103 :num-params 1 :operand-type 'none)
;; #x068  LENGTH
(make <vm-insn-info> :name 'LENGTH :code 104 :num-params 0 :operand-type 'none)
;; #x069  MEMQ
(make <vm-insn-info> :name 'MEMQ :code 105 :num-params 0 :operand-type 'none)
;; #x06a  MEMV
(make <vm-insn-info> :name 'MEMV :code 106 :num-params 0 :operand-type 'none)
;; #x06b  ASSQ
(make <vm-insn-info> :name 'ASSQ :code 107 :num-params 0 :operand-type 'none)
;; #x06c  ASSV
(make <vm-insn-info> :name 'ASSV :code 108 :num-params 0 :operand-type 'none)
;; #x06d  EQ
(make <vm-insn-info> :name 'EQ :code 109 :num-params 0 :operand-type 'none)
;; #x06e  EQV
(make <vm-insn-info> :name 'EQV :code 110 :num-params 0 :operand-type 'none)
;; #x06f  APPEND
(make <vm-insn-info> :name 'APPEND :code 111 :num-params 1 :operand-type 'none)
;; #x070  NOT
(make <vm-insn-info> :name 'NOT :code 112 :num-params 0 :operand-type 'none)
;; #x071  REVERSE
(make <vm-insn-info> :name 'REVERSE :code 113 :num-params 0 :operand-type 'none)
;; #x072  APPLY
(make <vm-insn-info> :name 'APPLY :code 114 :num-params 1 :operand-type 'none)
;; #x073  TAIL-APPLY
(make <vm-insn-info> :name 'TAIL-APPLY :code 115 :num-params 1 :operand-type 'none)
;; #x074  IS-A
(make <vm-insn-info> :name 'IS-A :code 116 :num-params 0 :operand-type 'none)
;; #x075  NULLP
(make <vm-insn-info> :name 'NULLP :code 117 :num-params 0 :operand-type 'none)
;; #x076  PAIRP
(make <vm-insn-info> :name 'PAIRP :code 118 :num-params 0 :operand-type 'none)
;; #x077  CHARP
(make <vm-insn-info> :name 'CHARP :code 119 :num-params 0 :operand-type 'none)
;; #x078  EOFP
(make <vm-insn-info> :name 'EOFP :code 120 :num-params 0 :operand-type 'none)
;; #x079  STRINGP
(make <vm-insn-info> :name 'STRINGP :code 121 :num-params 0 :operand-type 'none)
;; #x07a  SYMBOLP
(make <vm-insn-info> :name 'SYMBOLP :code 122 :num-params 0 :operand-type 'none)
;; #x07b  VECTORP
(make <vm-insn-info> :name 'VECTORP :code 123 :num-params 0 :operand-type 'none)
;; #x07c  IDENTIFIERP
(make <vm-insn-info> :name 'IDENTIFIERP :code 124 :num-params 0 :operand-type 'none)
;; #x07d  SETTER
(make <vm-insn-info> :name 'SETTER :code 125 :num-params 0 :operand-type 'none)
;; #x07e  VALUES
(make <vm-insn-info> :name 'VALUES :code 126 :num-params 1 :operand-type 'none)
;; #x07f  VEC
(make <vm-insn-info> :name 'VEC :code 127 :num-params 1 :operand-type 'none)
;; #x080  LIST2VEC
(make <vm-insn-info> :name 'LIST2VEC :code 128 :num-params 0 :operand-type 'none)
;; #x081  APP-VEC
(make <vm-insn-info> :name 'APP-VEC :code 129 :num-params 1 :operand-type 'none)
;; #x082  VEC-LEN
(make <vm-insn-info> :name 'VEC-LEN :code 130 :num-params 0 :operand-type 'none)
;; #x083  VEC-REF
(make <vm-insn-info> :name 'VEC-REF :code 131 :num-params 0 :operand-type 'none)
;; #x084  VEC-SET
(make <vm-insn-info> :name 'VEC-SET :code 132 :num-params 0 :operand-type 'none)
;; #x085  VEC-REFI
(make <vm-insn-info> :name 'VEC-REFI :code 133 :num-params 1 :operand-type 'none)
;; #x086  VEC-SETI
(make <vm-insn-info> :name 'VEC-SETI :code 134 :num-params 1 :operand-type 'none)
;; #x087  NUMEQ2
(make <vm-insn-info> :name 'NUMEQ2 :code 135 :num-params 0 :operand-type 'none)
;; #x088  NUMLT2
(make <vm-insn-info> :name 'NUMLT2 :code 136 :num-params 0 :operand-type 'none)
;; #x089  NUMLE2
(make <vm-insn-info> :name 'NUMLE2 :code 137 :num-params 0 :operand-type 'none)
;; #x08a  NUMGT2
(make <vm-insn-info> :name 'NUMGT2 :code 138 :num-params 0 :operand-type 'none)
;; #x08b  NUMGE2
(make <vm-insn-info> :name 'NUMGE2 :code 139 :num-params 0 :operand-type 'none)
;; #x08c  NUMADD2
(make <vm-insn-info> :name 'NUMADD2 :code 140 :num-params 0 :operand-type 'none)
;; #x08d  NUMSUB2
(make <vm-insn-info> :name 'NUMSUB2 :code 141 :num-params 0 :operand-type 'none)
;; #x08e  NUMMUL2
(make <vm-insn-info> :name 'NUMMUL2 :code 142 :num-params 0 :operand-type 'none)
;; #x08f  NUMDIV2
(make <vm-insn-info> :name 'NUMDIV2 :code 143 :num-params 0 :operand-type 'none)
;; #x090  NEGATE
(make <vm-insn-info> :name 'NEGATE :code 144 :num-params 0 :operand-type 'none)
;; #x091  NUMADDI
(make <vm-insn-info> :name 'NUMADDI :code 145 :num-params 1 :operand-type 'none)
;; #x092  NUMSUBI
(make <vm-insn-info> :name 'NUMSUBI :code 146 :num-params 1 :operand-type 'none)
;; #x093  READ-CHAR
(make <vm-insn-info> :name 'READ-CHAR :code 147 :num-params 1 :operand-type 'none)
;; #x094  PEEK-CHAR
(make <vm-insn-info> :name 'PEEK-CHAR :code 148 :num-params 1 :operand-type 'none)
;; #x095  WRITE-CHAR
(make <vm-insn-info> :name 'WRITE-CHAR :code 149 :num-params 1 :operand-type 'none)
;; #x096  CURIN
(make <vm-insn-info> :name 'CURIN :code 150 :num-params 0 :operand-type 'none)
;; #x097  CUROUT
(make <vm-insn-info> :name 'CUROUT :code 151 :num-params 0 :operand-type 'none)
;; #x098  CURERR
(make <vm-insn-info> :name 'CURERR :code 152 :num-params 0 :operand-type 'none)
;; #x099  SLOT-REF
(make <vm-insn-info> :name 'SLOT-REF :code 153 :num-params 0 :operand-type 'none)
;; #x09a  SLOT-SET
(make <vm-insn-info> :name 'SLOT-SET :code 154 :num-params 0 :operand-type 'none)
;; #x09b  SLOT-REFC
(make <vm-insn-info> :name 'SLOT-REFC :code 155 :num-params 0 :operand-type 'obj)
;; #x09c  SLOT-SETC
(make <vm-insn-info> :name 'SLOT-SETC :code 156 :num-params 0 :operand-type 'obj)

(provide "gauche/vm/insn")



