// A script to generate config.h tailored for Win32/VC build.
// Called from VC++ PreBuildEvent.

var fs = WScript.CreateObject("Scripting.FileSystemObject");

// Extract version number from configure.ac
var configure_ac = fs.OpenTextFile("..\\configure.ac");
var version = 0, ver_major, ver_minor, ver_micro;

while (!configure_ac.AtEndOfStream) {
    var s = configure_ac.ReadLine();
    if (s.search(/AC_INIT\(Gauche,\s*((\d+)\.(\d+)\.(\d+)([-\w]*))/) >= 0) {
        version = RegExp.$1;
        ver_major = RegExp.$2;
        ver_minor = RegExp.$3;
        ver_micro = RegExp.$4;
        break;
    }
}

if (!fs.FolderExists("gauche")) {
    fs.CreateFolder("gauche");
}

var output = fs.OpenTextFile("gauche\\config.h", 2, true);
(function (lines) {
    for (var i=0; i < lines.length; i++) {
        output.WriteLine(lines[i]);
    }
})
(["/* A specialized version of config.h used for Win32/VC build. */",
  "/* This is automatically generated by configure.js.  DO NOT EDIT */",
  // Tell the rest of Gauche that we're on MSVC.
  "#define MSVC 1",
  // Include the mighty windows.h.  We want to shut it up about
  // "deprecated" warnings.
  "#define _CRT_SECURE_NO_DEPRECATE 1",
  "#define _WINSOCKAPI_",
  "#include <windows.h>",
  "#include <winsock2.h>",
  "#include <shlwapi.h>",
  "#include <math.h>",
  "#include <float.h>",
  "#include <tchar.h>",
  // versions
  "#define GAUCHE_MAJOR_VERSION "+ver_major,
  "#define GAUCHE_MINOR_VERSION "+ver_minor,
  "#define GAUCHE_MICRO_VERSION "+ver_micro,
  "#define GAUCHE_VERSION \""+version+"\"",
  "#define GAUCHE_SIGNATURE \""+version+",utf8\"",
  // windows.h defines 'small' as 'char'.  What the heck.
  "#undef small",
  // some typedefs needed by other gauche's headers.
  "#ifndef _BSDTYPES_DEFINED",
  "typedef unsigned char u_char;",
  "typedef unsigned short u_short;",
  "typedef unsigned int u_int;",
  "typedef unsigned long u_long;",
  "#define _BSDTYPES_DEFINED",
  "#endif /*!_BSDTYPES_DEFINED*/",
  "typedef short            int16_t;",
  "typedef unsigned short   uint16_t;",
  "typedef __int32          int32_t;",
  "typedef unsigned __int32 uint32_t;",
  "typedef __int64          int64_t;",
  "typedef unsigned __int64 uint64_t;",
  "#define HAVE_INT32_T  1",
  "#define HAVE_UINT32_T 1",
  "#define HAVE_INT64_T  1",
  "#define HAVE_UINT64_T 1",
  // we stick to utf-8 on windows.
  "#define GAUCHE_CHAR_ENCODING_UTF_8  1",
  "#define inline __inline",
  // some more definitions.  NB: we may need to calculate SIZEOF_LONG.
  "#define SCM_TARGET_I386 1",
  "#define SIZEOF_INT      4",
  "#define SIZEOF_LONG     4",
  "#define SIZEOF_OFF_T    4",
  "#define SCM_DBL_POSITIVE_INFINITY (DBL_MAX+DBL_MAX)",
  "#define SCM_DBL_NEGATIVE_INFINITY (-DBL_MAX-DBL_MAX)",
  "#define SCM_DBL_NAN  (SCM_DBL_POSITIVE_INFINITY-SCM_DBL_POSITIVE_INFINITY)",
  // DLL suffix
  "#define SHLIB_SO_SUFFIX \"dll\"",
  ""
    ])
    
output.Close();
