import string
import os
import sys
from math import exp,log
from Tkinter import *
from plot import Gnuplot
from folder import folder
from UVVis import readorbital_data

def MO(root,screen,logfile,start,end,useold,COOP,FWHM,makeorigin,gnuplotexec):


    screen.write("Starting MO.py\n")
    start=float(start)
    end=float(end)
    FWHM=float(FWHM)

    groupatoms=[]; groupname=[]; atomorb=[]

    # Create the output directory if necessary
    gaussdir=folder(screen,logfile)

    if useold and not COOP:
        # Use the contents of orbital_data.txt (only valid for DOS)
        try:
            inputfile=open(os.path.join(gaussdir,"orbital_data.txt"),"r")
        except IOError:
            screen.write("orbital_data.txt not found\n")
            return False
        screen.write("Using old orbital_data.txt\n")

        HOMO,NBsUse,numgroups,groupname,groupatoms,orb_MPA,evalue,optional=readorbital_data(inputfile)
        inputfile.close()
        if optional!=[]:
            HOMO_beta,orb_MPA_beta,evalue_beta=optional
            unres=True
        
        groups=False
        if numgroups>0:
            groups=True
        if orb_MPA!=[]:
            overlapmatrix=True
            pop=True
    else:
        # Read in the groups (if they exist!)
        groupname=[];numgroups=0
        try:
            groupfile=open(os.path.join(gaussdir,"Groups.txt"),"rU") # Universal file import (for DOS/UNIX)
        except IOError:
            screen.write("Groups.txt not found - not going to look for overlap matrix or MOCoeff matrix\n")
            groups=False
        else:
            screen.write("Reading Groups.txt\n") # No point doing this if there's no overlapmatrix...though
            groups=True

        if groups: # i.e. if there are groups
            groupname=[]
            groupatoms=[]
            line=groupfile.readline().strip()
            while len(line)>0:
                list=[]
                groupname.append(line)
                line=groupfile.readline().strip()
                temp=line.split(",")
                for x in temp:
                    mo=x.split("-")
                    if len(mo)==1:
                        list.append(int(mo[0]))
                    else:
                        list=list+range(int(mo[0]),int(mo[1])+1)
                groupatoms.append(list)
                line=groupfile.readline().strip()
            groupfile.close()
            numgroups=len(groupname)
            screen.write("There are "+str(numgroups)+" groups\n")

    # Read in other data (Natoms,NBasis,NBsUse)

    # If there are no groups, there's no point reading in the overlap matrix, etc.

    NAtoms,NBasis,NBsUse,optional=logfile.getbasisinfo(groups)

    # Verify that groups.txt is okay
    if groups:
        temp=reduce(lambda a,b:a+b, groupatoms) # Turns into one big list
        temp.sort() # Sorts in place
        if COOP==False:
            # Each atom must appear exactly once
            if temp!=range(1,NAtoms+1):
                screen.write("Problem with groups.txt!\n(1)Every atom must be listed as a member of some group\n(2)No atom can be listed twice\n")
                return 1
        else:
            # No atom can appear twice (and cannot have any crazy atoms either)
            badatom=[x for x in temp if x not in range(1,NAtoms+1)]
            if badatom:
                screen.write("Atom number out of range in groups.txt\n")
                return 1
            for i in range(len(temp)-1):
                if temp[i]==temp[i+1]:
                    screen.write("Atom %d has been included twice\n" % temp[i])
                    return 1
            

    screen.write("The number of atoms is "+str(NAtoms)+"\n")
    screen.write("NBasis is "+str(NBasis)+"\n")
    screen.write("NBsUse is "+str(NBsUse)+"\n")

    overlapmatrix=False; pop=False
    if len(optional)>0:
        overlap=optional[0]
        if overlap!=[]:
            overlapmatrix=True
            screen.write("Found an overlap matrix\n")

        pop=True # Assuming you never get an overlap matrix without the MOCoeffs
        MOCoeff=optional[1]
        screen.write("Found the MO coefficients\n")
        atomorb=optional[2]

        if len(optional)==4:
            MOCoeff_beta=optional[3]
            screen.write("This is an unrestricted calculation - found the Beta MO coefficents\n")
        

# ************** Read MOs (symmetry and evalues)
    screen.write("Reading in the evalues and symmetry of the MOs\n")
    
    evalue,symmetry,HOMO,optional=logfile.getenergylevels()
    screen.write("Number of evalues found: %d\n" % len(evalue))

    screen.write("Number of orbital symmetries found: "+str(len(symmetry))+"\n")
    if len(symmetry)==0:
        symmetry=['?']*len(evalue)

    unres=False
    if len(optional)>0:
        evalue_beta=optional[0]
        symmetry_beta=optional[1]
        HOMO_beta=optional[2]
        screen.write("This is an unrestricted calculation - found the Beta evalues\n")
        screen.write("Number of Beta evalues found: %d\n" % len(evalue_beta))        
        unres=True
        

    # ************** Calculate the contributions of each of the fragments to each
    # ************** of the MO orbitals

    if COOP==True: # Shouldn't have to test (but I do!)
        if not (groups and overlapmatrix and pop):
            screen.write("To calculate the COOP spectrum, you need Groups.txt and a log file containing a full population analysis\n")
            return 1
        
        MOlap=[]
        for fragx in range(len(groupname)):
            MOlap.append([])
            for fragy in range(len(groupname)):
                MOlap[fragx].append([])

        for fragx in range(0,len(groupname)-1):
            for fragy in range(fragx+1,len(groupname)):
                screen.write("Calculating the overlap between "+groupname[fragx]+" and "+groupname[fragy]+":")
                for k in range(0,NBsUse): # For each of the MOs
                    screen.write(str(k+1)+" ")
                    lap=0                        
                    for l in groupatoms[fragx]:
                        for j in atomorb[l-1]:
                            for m in groupatoms[fragy]:
                                for i in atomorb[m-1]:
                                    lap+=MOCoeff[k][i]*MOCoeff[k][j]*overlap[j][i]
                    MOlap[fragx][fragy].append(lap)
                screen.write("\n")

        # Write it all to file
        output=open(os.path.join(gaussdir,"COOP_data.txt"),"w")
        output.write("MO\t\tevalue")
        for fragx in range(0,len(groupname)-1):
            for fragy in range(fragx+1,len(groupname)):
                output.write("\t"+groupname[fragx]+" and "+groupname[fragy])
        output.write("\n")
        for k in range(NBsUse):
            output.write(str(k+1)+"\t"+nameorb(HOMO,k)+"\t"+str(evalue[k]))
            for fragx in range(0,len(groupname)-1):
                for fragy in range(fragx+1,len(groupname)):
                    output.write("\t"+str(MOlap[fragx][fragy][k]))
            output.write("\n")
        output.close()

        output=open(os.path.join(gaussdir,"COOP_spectrum.txt"),"w")
        output.write("eV")
        for fragx in range(0,len(groupname)-1):
            for fragy in range(fragx+1,len(groupname)):
                output.write("\t"+groupname[fragx]+" and "+groupname[fragy])                    
        output.write("\n")
        width=end-start
        a=4*log(2)/FWHM**2
        for y in range(0,1000):
            realy=width*y/1000+start
            output.write(str(realy))
            for fragx in range(0,len(groupname)-1):
                for fragy in range(fragx+1,len(groupname)):
                    tot=0
                    for x in range(NBsUse):
                        z=exp(-a*(realy-evalue[x])**2) # FWHM=0.5eV is nice for Ru complexes
                        tot=tot+z*MOlap[fragx][fragy][x]
                    output.write("\t"+str(tot))
            output.write("\n")
        output.close()

        # Gnuplot the COOP

        line=""
        i=2
        for fragx in range(0,len(groupname)-1):
            for fragy in range(fragx+1,len(groupname)):
                if i!=2:
                    line=line+","
                line=line+"'"+os.path.join(gaussdir,"COOP_spectrum.txt")+"' using 1:"+str(i)+" title 'overlap of "+groupname[fragx]+" with "+groupname[fragy]+"' with lines"
                i=i+1
        line="set xrange ["+str(start)+":"+str(end)+"]\nset xlabel 'Energy (eV)'\nplot "+line+"\n"
        Gnuplot(root,gnuplotexec,line,"DOS spectrum")



    else: # Density of States
        variables=(screen,gaussdir,groups,overlapmatrix,pop,groupatoms,groupname,atomorb,NBsUse,symmetry)
        if not useold:
            orb_MPA=[]; orb_MPA_beta=[];
            
            if groups and overlapmatrix and pop:
                
                if not unres:
                    orb_MPA=DOScalc(MOCoeff,overlap,"Alpha/Beta",variables,NBasis)
                else:
                    orb_MPA=DOScalc(MOCoeff,overlap,"Alpha",variables,NBasis)
                    orb_MPA_beta=DOScalc(MOCoeff_beta,overlap,"Beta",variables,NBasis)


# Writing DOS and PDOS data to orbital_data.txt                

            screen.write("Writing orbital data to orbital_data.txt\n")
            outputfile=open(os.path.join(gaussdir,"orbital_data.txt"),"w")

            outputfile.write("NBasis:\t"+str(NBsUse)+"\n")
            outputfile.write("HOMO:\t"+str(HOMO+1))
            if unres:
                outputfile.write("\t"+str(HOMO_beta+1))

            if not (groups and overlapmatrix and pop):
                # No point outputting group info since we don't have the %contribs
                outputfile.write("\nGroups:\t0\n")                
            else:
                outputfile.write("\nGroups:\t"+str(len(groupname))+"\n")
                for i in range(len(groupname)):
                    line=groupname[i]+"\t"
                    for x in groupatoms[i]:
                        line=line+str(x)+" "
                    line=line+"\n"
                    outputfile.write(line)

            if unres:
                outputfile.write("\nAlpha MO\t\teV\tSymmetry")                
            else:
                outputfile.write("\nMO\t\teV\tSymmetry")
                
            if groups and overlapmatrix and pop:
                t=""
                for x in groupname:
                    t=t+"\t"+x
                outputfile.write(t+"\tAccurate values (for UVVis.py)")
            if unres:
                if groups and overlapmatrix and pop:
                    outputfile.write("\t"*(len(groupname)-1))
                outputfile.write("\tBeta MO\t\teV\tSymmetry")
                if groups and overlapmatrix and pop:
                    outputfile.write(t+"\tAccurate values (for UVVis.py)")
            outputfile.write("\n")


            for i in range(NBsUse-1,-1,-1): # Print them out backwards
                line=str(i+1)+"\t"+nameorb(HOMO,i)+"\t"+str(round(evalue[i],2))+"\t"+symmetry[i]
                if groups and overlapmatrix and pop:
                    for j in range(len(groupname)):
                        line=line+"\t"+str(int(orb_MPA[i][j]*100+.5))
                    for j in range(len(groupname)):
                        line=line+"\t"+str(orb_MPA[i][j])
                if unres:
                    line=line+"\t"+str(i+1)+"\t"+nameorb(HOMO_beta,i)+"\t"+str(round(evalue_beta[i],2))+"\t"+symmetry[i]
                    if groups and overlapmatrix and pop:
                        for j in range(len(groupname)):
                            line=line+"\t"+str(int(orb_MPA_beta[i][j]*100+.5))
                        for j in range(len(groupname)):
                            line=line+"\t"+str(orb_MPA_beta[i][j])
                outputfile.write(line+"\n")


# Print out a file suitable for drawing with origin (New addition)
        
        if makeorigin==True:
            outputfile=open(os.path.join(gaussdir,"origin_orbs.txt"),"w")
            for i in range(NBsUse):
                if numgroups>0 and overlapmatrix:
                    total=0
                    for j in range(numgroups):
                        outputfile.write(str(total)+"\t"+str(evalue[i])+"\t")
                        total+=orb_MPA[i][j]
                    outputfile.write("\n")
                    total=0
                    for j in range(numgroups):
                        total+=orb_MPA[i][j]
                        outputfile.write(str(total)+"\t"+str(evalue[i])+"\t")
                    outputfile.write("\n")
                else:
                    outputfile.write("0\t"+str(evalue[i])+"\n")
                    outputfile.write("1\t"+str(evalue[i])+"\n")
            if unres:
                for i in range(NBsUse):
                    if numgroups>0 and overlapmatrix:
                        total=0 
                        for j in range(numgroups):
                            outputfile.write(str(total)+"\t"+str(evalue_beta[i])+"\t")
                            total+=orb_MPA_beta[i][j]
                        outputfile.write("\n")
                        total=0
                        for j in range(numgroups):
                            total+=orb_MPA_beta[i][j]
                            outputfile.write(str(total)+"\t"+str(evalue_beta[i])+"\t")
                        outputfile.write("\n")
                    else:
                        outputfile.write("0\t"+str(evalue_beta[i])+"\n")
                        outputfile.write("1\t"+str(evalue_beta[i])+"\n")

            outputfile.close()
            
    # ********************* Convolute the DOS spectrum

        screen.write("\nConvoluting the DOS spectrum\n")

        if not unres:
            spectrum=DOSconvolute(orb_MPA,evalue,"DOS_spectrum.txt",variables,end,start,FWHM)
        else:
            spectrum=DOSconvolute(orb_MPA,evalue,"DOS_spectrum_alpha.txt",variables,end,start,FWHM)
            spectrum_beta=DOSconvolute(orb_MPA_beta,evalue_beta,"DOS_spectrum_beta.txt",variables,end,start,FWHM)

        # Write the convoluted DOS spectrum to disk
        screen.write("Writing DOS spectrum to DOS_spectrum.txt\n")
        outputfile=open(os.path.join(gaussdir,"DOS_spectrum.txt"),"w")
        
        firstline="DOS Spectrum"
        if unres:
            firstline+="\tAlpha"+"\t"*(len(groupname)+1)+"Beta"+"\t"*(len(groupname)+1)+"Alpha MO eigenvalues\tBeta MO eigenvalues\n"
        else:
            firstline+="\t"*(len(groupname)+1)+"MO eigenvalues\n"
        outputfile.write(firstline)

        line="Energy (eV)"
        if groups and overlapmatrix and pop:
            for x in groupname:
                line=line+"\t"+x
            line+="\tTotal"
            if unres:
                for x in groupname:
                    line=line+"\t"+x
                line+="\tTotal"
        outputfile.write(line+"\n")

        width=end-start                             
        for x in range(max(1000,NBsUse)):
            line=""
            if x<1000: # Print the spectrum
                realx=width*x/1000+start # Print the DOS spectrum from 'start' to 'end'
                line=line+str(realx)
                if groups and overlapmatrix and pop:
                    for i in range(numgroups):
                        if spectrum[i][x]<1e-10:
                            spectrum[i][x]=0
                        line=line+"\t"+str(spectrum[i][x])
                i=numgroups
                if spectrum[i][x]<1e-10:
                    spectrum[i][x]=0
                line=line+"\t"+str(spectrum[i][x]) # Print the total
                if unres:
                    if groups and overlapmatrix and pop:
                        for i in range(numgroups):
                            if spectrum_beta[i][x]<1e-10:
                                spectrum_beta[i][x]=0
                            line=line+"\t"+str(spectrum_beta[i][x])
                    i=numgroups
                    if spectrum_beta[i][x]<1e-10:
                        spectrum_beta[i][x]=0
                    line=line+"\t"+str(spectrum_beta[i][x]) # Print the total
                    

            if x<NBsUse: # Print the energy levels
                if line=="": # if the DOS spectrum is finished
                    line=line+'\t'*(numgroups+2) # make the first two columns blank
                line=line+"\t"+str(evalue[x])
                if unres:
                    line=line+"\t"+str(evalue_beta[x])
                line=line+"\t-1"
                    
            line=line+"\n"
            outputfile.write(line)
        outputfile.close()



    # ******************** Gnuplot the DOS spectrum

# For res, want one plot with stacked PDOS plus evalues at bottom

# For unres, want one plot with stacked sum_of_PDOS's plus both evalues at bottom

        line=""; column=3

        if groups and overlapmatrix and pop:
            screen.write("Plotting the stacked PDOS\n")
            if not unres:
                row=[]
                for i in range(len(groupname)):
                    column=column+1
                    row.append("$"+str(i+2)) # Starts at ['$2'], then ['$2','$3'] etc.
                    if line!="":
                        line=line+","
                    line=(line+"'"+os.path.join(gaussdir,"DOS_spectrum.txt")+
                          "' using 1:("+string.join(row,"+")+") title '"+groupname[i]+"' with lines")
            else:
                row=[]
                for i in range(len(groupname)):
                    column=column+1
                    row.append("$"+str(i+2)) # Starts at ['$2','$6'], then ['$2','$6','$3','$7'] etc.
                    row.append("$"+str(i+2+len(groupname)))
                    if line!="":
                        line=line+","
                    line=(line+"'"+os.path.join(gaussdir,"DOS_spectrum.txt")+
                          "' using 1:("+string.join(row,"+")+") title '"+groupname[i]+"' with lines")
        else:
            screen.write("Plotting the total DOS\n")
            if not unres:
                line=line+"'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using 1:2 title 'DOS spectrum' with lines"
            else:
                line=line+"'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using 1:2 title 'Alpha DOS spectrum' with lines"
                line=line+", '"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using 1:3 title 'Beta DOS spectrum' with lines"
                line=line+", '"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using 1:($2+$3)/2 title 'Total DOS spectrum (scaled by 0.5)' with lines"
           
    # Plot the evalues
        title=""
        impulse_col=str(column+1)
        if unres:
            column=column+1 # To get past the extra convoluted beta DOS
            title="Alpha "
            if groups and overlapmatrix and pop:
                column=column+len(groupname) # To get past the groups
            impulse_col=str(column+2)
        line=(line+",'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using "+str(column)+":($"+str(column)+
              "<="+str(evalue[HOMO])+" ? $"+impulse_col+" : 1/0)"+" title '"+title+"Occupied Orbitals' with impulses")
        line=(line+",'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using "+str(column)+":($"+str(column)+">"+
              str(evalue[HOMO])+" ? $"+impulse_col+" : 1/0)"+" title '"+title+"Virtual orbitals' with impulses")
        if unres: # For the extra beta impulses
            title="Beta "            
            column=column+1
            line=(line+",'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using "+str(column)+":($"+str(column)+
                  "<="+str(evalue_beta[HOMO_beta])+" ? $"+impulse_col+" : 1/0)"+" title '"+title+"Occupied Orbitals' with impulses")
            line=(line+",'"+os.path.join(gaussdir,"DOS_spectrum.txt")+"' using "+str(column)+":($"+str(column)+">"+
                  str(evalue_beta[HOMO_beta])+" ? $"+impulse_col+" : 1/0)"+" title '"+title+"Virtual orbitals' with impulses")
            
        
        line="set xrange ["+str(start)+":"+str(end)+"]\nset yrange [-1:*]\nset xlabel 'Energy (eV)'\nplot "+line+"\n"

        if not unres:
            Gnuplot(root,gnuplotexec,line,"DOS spectrum")
        else:
            Gnuplot(root,gnuplotexec,line,"DOS spectrum (sum of alpha plus beta electrons)")
        


    screen.write("Finishing MO.py\n")


def nameorb(HOMO,orb):
    if orb<HOMO:
        level='H-'+str(HOMO-orb)
    elif orb>HOMO+1:
        level='L+'+str(orb-HOMO-1)
    elif orb==HOMO+1:
        level="LUMO"
    else:
        level="HOMO"
    return level

def tidy(num): # Changes +-0.155648 into +-0.16
    if num>=0:
        rounded=int(num*100+.5)/100.
        return str(rounded)[:4]
    else:
        rounded=int(num*100-.5)/100.
        return str(rounded)[:5]

def DOScalc(MOCoeff,overlap,name,variables,NBasis): # Works for Alpha and Beta

    (screen,gaussdir,groups,overlapmatrix,pop,groupatoms,groupname,atomorb,NBsUse,symmetry)=variables

    orb_MPA=[]
    for i in range(NBsUse):
        orb_MPA.append([])
    screen.write("\n%s electrons: Calculating contributions for MO no. (of %d)..." % (name,NBsUse) )
    for k in range(0,NBsUse): # For each of the MOs
        screen.write("%d " % (k+1))
        frag_MPA=[]
        for frag in range(len(groupname)):
            MPA=0
            for l in groupatoms[frag]:
                for j in atomorb[l-1]:
                    sum=0
                    for i in range(0,NBasis):
                        sum += MOCoeff[k][i]*overlap[j][i]
                    MPA += sum*MOCoeff[k][j]
            frag_MPA.append(MPA) # i.e. [frag1_MPA, frag2_MPA]
            
        orb_MPA[k]=frag_MPA[:] # i.e. [ [MPAs for orb1], [MPAs for orb2],..]

    return orb_MPA

    

def DOSconvolute(orb_MPA,evalue,name,variables,end,start,FWHM):

    (screen,gaussdir,groups,overlapmatrix,pop,groupatoms,groupname,atomorb,NBsUse,symmetry)=variables
    
    spectrum=[]; numgroups=len(groupname)
    for x in range(0,numgroups+1):
        spectrum.append([])

    for x in range(0,1000): # Will hold the spectrum from -20 to +20 eV
        for y in range(numgroups+1):
            spectrum[y].append(0)
    a=4*log(2)/FWHM**2
    width=end-start
    for x in range(0,NBsUse):
        for y in range(0,1000): # the index in the array
            realy=width*y/1000+start # the energy in eV we are currently looking at
	    # The eqn for a Gaussian curve is f=N exp(-a.x^2)
            z=exp(-a*(realy-evalue[x])**2) # FWHM=0.3eV is good for Ru complexes
            spectrum[numgroups][y]=spectrum[numgroups][y]+z # the full DOS
            if groups and overlapmatrix and pop:
                for i in range(numgroups):
                    spectrum[i][y]=spectrum[i][y]+z*orb_MPA[x][i]

    return spectrum


def DOSwritetofile(orb_MPA,evalue,name,HOMO,variables): # subroutine

    (screen,gaussdir,groups,overlapmatrix,pop,groupatoms,groupname,atomorb,NBsUse,symmetry)=variables

    screen.write("Writing orbital data to %s\n" % name)
    outputfile=open(os.path.join(gaussdir,name),"w")

    outputfile.write("NBasis:\t"+str(NBsUse)+"\n")
    outputfile.write("HOMO:\t"+str(HOMO+1)+"\n")
    outputfile.write("Groups:\t"+str(len(groupname))+"\n")

    if groups:
        for i in range(len(groupname)):
            line=groupname[i]+"\t"
            for x in groupatoms[i]:
                line=line+str(x)+" "
            line=line+"\n"
            outputfile.write(line)

    outputfile.write("\nMO\t\teV\tSymmetry")
    if groups and overlapmatrix and pop:
        line=""
        for x in groupname:
            line=line+"\t"+x
        outputfile.write(line)
        outputfile.write("\tAccurate values (for UVVis.py)")
    outputfile.write("\n")


    for i in range(NBsUse-1,-1,-1): # Print them out backwards
        line=str(i+1)+"\t"
        if i<HOMO:
            level='H-'+str(HOMO-i)
        elif i>HOMO+1:
            level='L+'+str(i-HOMO-1)
        elif i==HOMO+1:
            level="LUMO"
        else:
            level="HOMO"
        line=line+level+"\t"+str(round(evalue[i],2))+"\t"+symmetry[i]

        if groups and overlapmatrix and pop:
            for j in range(len(groupname)):
                line=line+"\t"+str(int(orb_MPA[i][j]*100+.5))
            for j in range(len(groupname)):
                line=line+"\t"+str(orb_MPA[i][j])
        outputfile.write(line+"\n")

    return True


# ****************************************************************************
if __name__=="__main__": # i.e. this module is being run (and not imported)
    root=Tk()
    MO(root,sys.stdout,"input/RUBPY3_STAB.out",0)
    mainloop()
