from logfile import logfile,myfloat
from math import log
import re

class Gaussian03(logfile):
    def __init__(self,filename):
        self.filename=filename


    def getNMR(self):
        # Returns a list of items
        # and the NMR comment
        
        inputfile=open(self.filename,"r")
        fileiter=iter(inputfile)

        # Find the route line (note : this will
        # crash if it reaches the end of file!)
        while fileiter.next().find("#")!=1: pass

        line=fileiter.next() # Get past the line of hyphens

        # Find the first line after this that starts with a hyphen
        while fileiter.next()[1]!="-": pass
        
        comment=fileiter.next() # This is the comment line

        data=[]
        for line in fileiter:
            if line.find("Isotropic")>=0:
                if line.find("Anisotropy")>=0:
                    t=line.split()
                    data.append([ t[1],myfloat(t[4]) ])
                    
        return data,comment


    def getGeoOpt(self):
        # Returns a tuple of three items:
        # The first is a string of lines to be written to the screen
        # The second is a list of numbers (to be plotted) (as string)
        # The third is a list of numbers (to be plotted) (as string)
        
        inputfile=open(self.filename,"r")
        energy=[]
        list_of_deviation=[]
        screenoutput=""
        
        x=inputfile.readline()
        while len(x)>0:
            if x.find('SCF Done')>=0: # We've found the energy info
                screenoutput=screenoutput+x
                energy.append(x.split()[4])
            if x.find('Converged?')>=0: # We've found the convergence info
                deviation=0
                for i in range(4):
                    line=inputfile.readline()
                    screenoutput=screenoutput+line
                    temp=line.split()
                    value=myfloat(temp[2])
                    target=myfloat(temp[3])
                    if value>target:
                        deviation+=log(value/target)
                list_of_deviation.append(str(deviation))
            x=inputfile.readline()

        inputfile.close()

        return screenoutput,energy,list_of_deviation
        
    def getSCF(self):
        # Returns a tuple of two items:
        # The first is a string of lines to be written to the screen
        # The second is a list of numbers (to be plotted) (as string)

        inputfile=open(self.filename,"r")
        screenoutput=""
        energylist=[] # Just in case it's never defined

        x="Starting off string"
        while x:
            x=inputfile.readline()
            if x.find('Requested convergence on RMS density matrix')>0:
                target_rms=myfloat(x.split('=')[1].split()[0])
            elif x.find('Requested convergence on MAX density matrix')>0:
                target_max=myfloat(x.strip().split('=')[1][:-1])
            elif x.find('Requested convergence on             energy')>0:
                target_energy=myfloat(x.strip().split('=')[1][:-1])
            elif x.find(' Cycle   1')>=0: # The first SCF step
                energylist=[] # wipe the slate each time
                while x and x.find("SCF Done")==-1:
                    x=inputfile.readline()
                    if x.find(' E=')==0:
                        screenoutput=screenoutput+x
                    if x.find(" RMSDP")==0:
                        temp=x.split()
                        progress=0
                        rms=myfloat(temp[0].split('=')[1])
                        if rms>target_rms:
                            progress+=log(rms/target_rms)
                        max=myfloat(temp[1].split('=')[1])
                        if max>target_max:
                            progress+=log(max/target_max)
                        energy=1.0
                        if len(temp)>4:
                            energy=temp[2].split('=')[1]
                            if energy=="":
                                energy=myfloat(temp[3])
                            else:
                                energy=myfloat(energy)
                            if energy>target_energy:
                                progress+=log(energy/target_energy)
                        screenoutput+=x
                        energylist.append(str(progress))
            elif x.find(' It=')==0:
                # For AM1 SCF convergence
                energylist=[] # wipe the slate each time
                while x and x.find(" Energy")!=0:
                    screenoutput+=x
                    temp=x.strip().split()
                    rms=myfloat(temp[-1][:-1])
                    if rms>1E-7:
                        progress=log(rms/1E-7)
                    else:
                        progress=0
                    energylist.append(str(progress))
                    x=inputfile.readline()
        
        inputfile.close()

        return screenoutput, energylist

    def getIR_Raman(self):
        # Returns a tuple as follows:
        # Item 1: screenoutput (STRING)
        # Item 2: freqs (FLOATS
        # Item 3: symmetry (STRING)
        # Item 4: ir (FLOAT)
        # Item 5: raman (may be empty list) (FLOAT)

        screenoutput=""
        freq=[]; sym=[]; ir=[]; raman=[]

        inputfile=open(self.filename,"r")
        line=inputfile.readline()
        while len(line)>0 and line.find("Harmonic freq")==-1:
            line=inputfile.readline()
        if len(line)==0:
            return screenoutput,freq,sym,ir,raman # all empty of course, but hey!

        line=inputfile.readline();
        while len(line[:15].split())>0:
            line=inputfile.readline()


        screenoutput=screenoutput+line
        line=inputfile.readline() # Should be the line with symmetries

        while len(line[:15].split())==0:
            screenoutput=screenoutput+line
            sym=sym+line.split() # Adding new symmetry
            line=inputfile.readline()
            screenoutput=screenoutput+line
            freq=freq+line[15:].split() # Adding new frequencies
            line=inputfile.readline(); line=inputfile.readline()
            line=inputfile.readline()
            screenoutput=screenoutput+line
            ir=ir+line[15:].split() # Adding IR intensities
            line=inputfile.readline()
            if line.find("Raman")>=0:
                screenoutput=screenoutput+line
                raman=raman+line[15:].split() # Adding Raman intensities

            line=inputfile.readline()
            while len(line[:15].split())>0:
                line=inputfile.readline()
            screenoutput=screenoutput+"\n"+line
               
            line=inputfile.readline() # Should be the line with symmetries

        inputfile.close()

        for i in range(len(freq)):
            freq[i]=myfloat(freq[i])
            if len(raman)>0:
                raman[i]=myfloat(raman[i])
            ir[i]=myfloat(ir[i])

        return screenoutput,freq,sym,ir,raman

    def getUV_Vis(self):
        # Returns a tuple of energy,wavelength,osc,sym,CIS,rotatory
        
        inputfile=open(self.filename,"r")
        
        line=inputfile.readline()

        energy=[]; wave=[]; osc=[]; sym=[]; CIS=[]; rotatory=[]

        unrestricted = False
        
        while len(line)>0:
            if line.find("Excited State")==1:
                # Handle info on electronic transitions
                # Need to deal with lines like:
                # (restricted calc)
                # Excited State   1:   Singlet-BU     5.3351 eV  232.39 nm  f=0.1695
                # (unrestricted calc)
                # Excited State   2:   ?Spin  -A      0.1222 eV 10148.75 nm  f=0.0000

                temp=line[36:].split()
                energy.append(myfloat(temp[0]))
                wave.append(myfloat(temp[2]))
                osc.append(myfloat(temp[4].split("=")[1]))
                sym.append(line[21:36].strip())
                
                line=inputfile.readline()
                
                CIScontrib=[]
                # Only do this for restricted calculations
                # As a quick hack for this version of GaussSum...
                if not unrestricted:
                    while line.find(" ->")>=0: # This is a contribution to the transition
                        temp=line.split("->")
                        fromMO=int(temp[0].strip()) # '       20 ' to '20'
                        t=temp[1].split()
                        toMO=int(t[0])
                        percent=myfloat(t[1])
                        sqr=percent**2*2 # The fractional contribution of this CI
                        if percent<0:
                            sqr=-sqr
                        CIScontrib.append([fromMO,toMO,sqr])
                        line=inputfile.readline()
                CIS.append(CIScontrib)
                
            elif line.find("<0|r|b> * <b|rxdel|0>  (Au), Rotatory Strengths (R)")==1:
                # Handle circular dichroism data
                line=inputfile.readline()
                line=inputfile.readline()
                line=inputfile.readline()
                temp=line.strip().split()
                while len(temp)==5:
                    
                    try:
                        R = myfloat(temp[-1])
                    except ValueError:
                        # nan or -nan if there is no first excited state
                        # (for unrestricted calculations)
                        unrestricted = True
                    else:
                        rotatory.append(R)
                    line=inputfile.readline()
                    temp=line.strip().split()
            line=inputfile.readline()

        inputfile.close()

        return energy,wave,osc,sym,CIS,rotatory


    def getenergylevels(self):
        # Returns an array of evalue, sym and the HOMO
        # Re: the number of the HOMO - the orbitals are numbered starting from zero
        # evalues are in eV

        # The details returned come from the *final* report of evalues and
        # the last list of symmetries in the log file
        # This is fine for GeoOpt and SP, but may be weird for TD and Freq(?)

        inputfile=open(self.filename,"r")

        line=inputfile.readline()
        HOMO=-1; HOMO_beta=-1; evalue_beta=[]; symmetry_beta=[]; unres=False
        while len(line)>0:
            if line.find("            Population analysis using the SCF density.")==0:
                # Start of the symmetry and evalue section
                
                symmetry=[]; evalue=[]; evalue_beta=[]; symmetry_beta=[] # Wipes the slate clean every time
                line=inputfile.readline()
                
                while line.find('Orbital symmetries')!=1 and line.find('Alpha')!=1:
                    line=inputfile.readline()

                # Some files don't have the symmetry data (NOSYM)
                if line.find('Orbital symmetries')==1: # Found the start of the symmetries
                    line=inputfile.readline()
                    if line.find("Alpha Orbitals")==1:
                        unres=True
                        line=inputfile.readline()
                    i=0
                    while len(line)>18 and line[17]=='(':
                        if line.find('Virtual')>=0:
                            HOMO=i-1 # 'HOMO' indexes the HOMO in the arrays
                        temp=line[17:].split()
                        for x in temp:
                            symmetry.append(x.strip('()'))
                            i=i+1
                        line=inputfile.readline()
                    if unres:
                        line=inputfile.readline()
                        # Repeat with new array names
                        i=0
                        while len(line)>18 and line[17]=='(':
                            if line.find('Virtual')>=0:
                                HOMO_beta=i-1 # 'HOMO' indexes the HOMO in the arrays
                            temp=line[17:].split()
                            for x in temp:
                                symmetry_beta.append(x.strip('()'))
                                i=i+1
                            line=inputfile.readline()

                        
                    line=inputfile.readline() # Reads in "The electronic state is 1-A"
                                

                while line.find('Alpha')==1: # It should happen at least once
                    if HOMO==-1 and line.split()[1]=="virt.": # If there aren't any symmetries, this is a good way to find the HOMO
                        HOMO=len(evalue)-1
                    temp=line[28:]
                    i=0
                    while i*10+4<len(temp):
                        x=temp[i*10:(i+1)*10]
                        evalue.append(myfloat(x)*27.2114) # from a.u. (hartrees) to eV
                        i=i+1
                    line=inputfile.readline()

                while line.find('Beta')==2: # It should happen at least once in the case of unrestricted calcs
                    if HOMO_beta==-1 and line.split()[1]=="virt.": # This is a good way to find the HOMO
                        HOMO_beta=len(evalue_beta)-1
                    temp=line[28:]
                    i=0
                    while i*10+4<len(temp):
                        x=temp[i*10:(i+1)*10]
                        evalue_beta.append(myfloat(x)*27.2114) # from a.u. (hartrees) to eV
                        i=i+1
                    line=inputfile.readline()
                
            line=inputfile.readline()
            
        inputfile.close()
        optional=[]
        if len(evalue_beta)>0:
            optional=[evalue_beta,symmetry_beta,HOMO_beta]

        return evalue,symmetry,HOMO,optional

    def getbasisinfo(self,groups):
        # Returns an array of:
        # NAtoms, NBasis, NBsUse, [Optional components]
        # The items in [] are:
        # Overlap matrix, Molecular orbital coefficients, Atomic orbitals on each atom

        NAtoms=0; NBasis=0; NBsUse=0
        optional=[]
        MOCoeff=[]; MOCoeff_beta=[]; overlap=[]; atomorb=[] # MO Coeffs for MO#1 are in MOCoeff[0]

        inputfile=open(self.filename,"r")

        line=inputfile.readline()
        while len(line)>0:
            if line.find("Standard orientation")>=0 or line.find("Input orientation")>=0 or line.find("Z-Matrix orientation")>=0:
                # NAtoms is only available with additional print
                # This way also works for normal print
                if NAtoms==0:
                    line=inputfile.readline()
                    line=inputfile.readline()
                    line=inputfile.readline()
                    hyphens=inputfile.readline()
                    line=inputfile.readline()
                    while line!=hyphens:
                        NAtoms=NAtoms+1
                        line=inputfile.readline()
                    
            elif line.find("NBasis")>=0:
                NBasis=int(line.split('=')[1].split()[0])
                    
            elif line.find("NBsUse")>=0:
                NBsUse=int(line.split('=')[1].split()[0])

            elif line.find("basis functions,")>=0:
                # For AM1 calculations
                # (these values will be overwritten if there is a line
                #  that explicitly gives a value for NBasis)
                if NBasis==0:
                    NBasis=int(line.split()[0])
                    if NBsUse==0:
                        NBsUse=NBasis
                    
            elif groups: # Only does these if there are groups
                if line.find("*** Overlap ***")>=0:
                    # Read overlap matrix
                    overlap=[] # Overlap integrals for basis fn#1 are in overlap[0]
                    for i in range(0,NBasis):
                        overlap.append([])
                        for j in range(0,NBasis):
                            overlap[i].append(None)
                    base=0
                    while base<NBasis:
                        line=inputfile.readline()
                        for i in range(0,NBasis-base): # Fewer lines this time
                            line=inputfile.readline()
                            temp=line.split()
                            for j in range(1,len(temp)): # Some lines are longer than others
                                overlap[base+j-1][i+base]=myfloat(temp[j])
                                overlap[i+base][base+j-1]=myfloat(temp[j])
                        base=base+5
                        
                elif line.find("     Molecular Orbital Coefficients")>=0 or line.find("     Alpha Molecular Orbital Coefficients")==0:
                    atomorb=[] # atomorb[0] will be a list of the atomic orbitals of atom#1
                    for i in range(0,NAtoms):
                        atomorb.append([])
                
                    for i in range(0,NBsUse):
                        MOCoeff.append([])
                        for j in range(0,NBasis):
                            MOCoeff[i].append(None)
                    base=0
                    while base<NBsUse:
                        line=inputfile.readline()
                        line=inputfile.readline()
                        line=inputfile.readline()
                        for i in range(0,NBasis):
                            line=inputfile.readline()
			    # Changed below from :12 to :11 to deal with Elmar Neumann's example
                            temp=line[:11].split()
                            if base==0: # Just do this the first time 'round
                                if len(temp)>1: # New atom
                                    atomno=int(temp[1])-1
                                atomorb[atomno].append(i)

                            temp=line[21:]
                            j=0
                            while j*10+4<len(temp):
                                MOCoeff[base+j][i]=myfloat(temp[j*10:(j+1)*10])
                                j=j+1
                        base=base+5

                elif line.find("     Beta Molecular Orbital Coefficients")==0:
                    for i in range(0,NBsUse):
                        MOCoeff_beta.append([])
                        for j in range(0,NBasis):
                            MOCoeff_beta[i].append(None)
                    base=0
                    while base<NBsUse:
                        line=inputfile.readline()
                        line=inputfile.readline()
                        line=inputfile.readline()
                        for i in range(0,NBasis):
                            line=inputfile.readline()
                            temp=line[21:]
                            j=0
                            while j*10+4<len(temp):
                                MOCoeff_beta[base+j][i]=myfloat(temp[j*10:(j+1)*10])
                                j=j+1
                        base=base+5

            line=inputfile.readline()

        inputfile.close()

        if MOCoeff: # Remember that [] is False
            optional.append(overlap)
            optional.append(MOCoeff)
            optional.append(atomorb)
            if MOCoeff_beta:
                optional.append(MOCoeff_beta)

        return NAtoms,NBasis,NBsUse,optional
            
            
