/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "resource_combo_changed.h"


void resource_combo_changed(struct w *widgets)
{
    gint active_index = 0;
    gchar *utf8 = NULL;

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->add_resource_type_combo));
    if( active_index <= 0 )
    {
	gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, 
	_("A DNS server: dns1.yourdomain.org"), NULL);
	gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, 
	_("An IPv4 or IPv6 address: 192.168.0.30 or 5F05:2000:80AD:5800:0058:0800:2023:1D71"), NULL);
    }
    if( active_index == 1 )
    {
	gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, 
	_("A mail server: mail1.yourdomain.org"), NULL);
	gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, 
	_("The priority of this mail server: 10 or 20 etc, 10 beeing the highest priority of these."), NULL);
    }
    if( active_index == 2 )
    {
	gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, 
	_("The hostname of some host: router.yourdomain.org"), NULL);
	gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, 
	_("The IPv4 address of this host: 192.168.0.100"), NULL);
    }
    if( active_index == 3 )
    {
	gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, 
	_("The hostname of some host: router.yourdomain.org"), NULL);
	gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, 
	_("The IPv6 address of this host: 5F05:2000:80AD:5800:0058:0800:2023:1D71"), NULL);
    }
    if( active_index == 4 )
    {
	gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, 
	_("The hostname of some host that already has an A record but not the name server: router.yourdomain.org"), NULL);
	gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, 
	_("The virtual/alias/additional name of the host: myrouter.yourdomain.org"), NULL);
    }
    
    if( utf8!=NULL )
        g_free(utf8);
}
