/* { dg-do run } */
/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffff000100000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffff000100000000;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op1[2]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op1[1]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op1[0]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xfff8fff8fff8fff8;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xfff8fff8fff8fff8;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op1[2]) = 0x2020202020206431;
  *((unsigned long *)&__m256i_op1[1]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op1[0]) = 0x2020202020206431;
  *((unsigned long *)&__m256i_op2[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000f7f8f7f8;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000003f78;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000f7f8f7f8;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000003f78;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op2[2]) = 0x805f0000ffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op2[0]) = 0x805f0000ffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000f7f8f7f8;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000003f78;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000f7f8f7f8;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000003f78;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000fc38fc38;
  *((unsigned long *)&__m256i_op0[2]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000fc38fc38;
  *((unsigned long *)&__m256i_op0[0]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0002001800ff0078;
  *((unsigned long *)&__m256i_op1[2]) = 0x01f8007001f80070;
  *((unsigned long *)&__m256i_op1[1]) = 0x0002001800ff0078;
  *((unsigned long *)&__m256i_op1[0]) = 0x01f8007001f80070;
  *((unsigned long *)&__m256i_op2[3]) = 0x0218ff78fc38fc38;
  *((unsigned long *)&__m256i_op2[2]) = 0xfc00000000000048;
  *((unsigned long *)&__m256i_op2[1]) = 0x0218ff78fc38fc38;
  *((unsigned long *)&__m256i_op2[0]) = 0xfc00000000000048;
  *((unsigned long *)&__m256i_result[3]) = 0x00300b40fc001678;
  *((unsigned long *)&__m256i_result[2]) = 0xfc00000000001f80;
  *((unsigned long *)&__m256i_result[1]) = 0x00300b40fc001678;
  *((unsigned long *)&__m256i_result[0]) = 0xfc00000000001f80;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffe8440000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffe8440000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffe8440000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffe8440000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffe8440000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffe8440000;
  __m256i_out = __lasx_xvmaddwev_h_b (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffefffef00000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffefffefffefffef;
  *((unsigned long *)&__m256i_op0[1]) = 0xffefffef00000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffefffefffefffef;
  *((unsigned long *)&__m256i_op1[3]) = 0xefdfefdf00000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xefdfefdfefdfefdf;
  *((unsigned long *)&__m256i_op1[1]) = 0xefdfefdf00000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xefdfefdfefdfefdf;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xffefffef00000000;
  *((unsigned long *)&__m256i_result[2]) = 0xffefffefffefffef;
  *((unsigned long *)&__m256i_result[1]) = 0xffefffef00000000;
  *((unsigned long *)&__m256i_result[0]) = 0xffefffefffefffef;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xe0e0e0e0e0e0e0e0;
  *((unsigned long *)&__m256i_op1[2]) = 0xe0e0e0e0e0e0e0e0;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000e0e0e0e0;
  *((unsigned long *)&__m256i_op1[0]) = 0xe0e0e0e0e0e0e0e0;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xfffffe20001dfe1f;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xfffffe20001dfe1f;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0xfffffe20001dfe1f;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xfffffe20001dfe1f;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_w_h (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xebfd15f000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x01700498ff8f1600;
  *((unsigned long *)&__m256i_op0[1]) = 0xf520c7c024221300;
  *((unsigned long *)&__m256i_op0[0]) = 0x00802fd0ff540a80;
  *((unsigned long *)&__m256i_op1[3]) = 0xebfd15f000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x01700498ff8f1600;
  *((unsigned long *)&__m256i_op1[1]) = 0xf520c7c024221300;
  *((unsigned long *)&__m256i_op1[0]) = 0x00802fd0ff540a80;
  *((unsigned long *)&__m256i_op2[3]) = 0xf96d674800000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x44a4330e2c7116c0;
  *((unsigned long *)&__m256i_op2[1]) = 0x14187a7822b653c0;
  *((unsigned long *)&__m256i_op2[0]) = 0xfbe0b866962b96d0;
  *((unsigned long *)&__m256i_result[3]) = 0xebfd15f000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x015c6a7facc39600;
  *((unsigned long *)&__m256i_result[1]) = 0xfa070a51cbd95300;
  *((unsigned long *)&__m256i_result[0]) = 0x00c7463075439280;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0555550000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0555550000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xc06500550055ffab;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xc06500550055ffab;
  *((unsigned long *)&__m256i_result[3]) = 0x0555550000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0555550000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x807e80fd80fe80fd;
  *((unsigned long *)&__m256i_op0[2]) = 0x80938013800d8002;
  *((unsigned long *)&__m256i_op0[1]) = 0x807e80fd80fe0000;
  *((unsigned long *)&__m256i_op0[0]) = 0x80938013800d0005;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffff00001fff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffff00001fff;
  *((unsigned long *)&__m256i_result[3]) = 0x807e80fd80fe80fd;
  *((unsigned long *)&__m256i_result[2]) = 0x80938013800d8002;
  *((unsigned long *)&__m256i_result[1]) = 0x807e80fd80fe0000;
  *((unsigned long *)&__m256i_result[0]) = 0x80938013800d0005;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_op0[2]) = 0x556caad9aabbaa88;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_op0[0]) = 0x556caad9aabbaa88;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_op1[2]) = 0x556caad9aabbaa88;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_op1[0]) = 0x556caad9aabbaa88;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_result[2]) = 0x556caad9aabbaa88;
  *((unsigned long *)&__m256i_result[1]) = 0x0000004a557baac4;
  *((unsigned long *)&__m256i_result[0]) = 0x556caad9aabbaa88;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xff7f7f7fff7fffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xff7f7f7fff7fffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x3f7f7f7eff800000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x3f7f7f7eff800000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffffeffffffdd;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffdc;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x002affaa00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[2]) = 0xfffffffeffffffdd;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffdc;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000100010001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000100010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000a00000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000010000000a;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000a00000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000010000000a;
  *((unsigned long *)&__m256i_op2[3]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000100010001;
  *((unsigned long *)&__m256i_op2[1]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000100010001;
  *((unsigned long *)&__m256i_result[3]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x00000001000b000b;
  *((unsigned long *)&__m256i_result[1]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x00000001000b000b;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000e0000000e00;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000e0000000e00;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x6018000000000cd1;
  *((unsigned long *)&__m256i_op0[2]) = 0x6040190d00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x132feea900000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x6040190d00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000008;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000008;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000008;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000008;
  *((unsigned long *)&__m256i_op2[3]) = 0x2020080800000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000004044f4f;
  *((unsigned long *)&__m256i_op2[1]) = 0x0ef11ae55a5a6767;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x6018000000000cd1;
  *((unsigned long *)&__m256i_result[2]) = 0x6040190d20227a78;
  *((unsigned long *)&__m256i_result[1]) = 0x132feeabd2d33b38;
  *((unsigned long *)&__m256i_result[0]) = 0x6040190d00000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);
  unsigned_int_out = __lasx_xvpickve2gr_wu (__m256i_op0, 0x3);
  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xfefefefe3f800000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xfefefefe3f800000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000fe0000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000fe0000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000118;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000118;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_d_w (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fff01fd7fff7fff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00007fff7fff7fff;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000000ff80;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fff01fd7fff7fff;
  *((unsigned long *)&__m256i_result[0]) = 0x00007fff7fff7fff;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op1[3]) = 0xff3cff3cff3cff3c;
  *((unsigned long *)&__m256i_op1[2]) = 0xff3cff3cff3cff3c;
  *((unsigned long *)&__m256i_op1[1]) = 0xff3cff3cff3cff3c;
  *((unsigned long *)&__m256i_op1[0]) = 0xff3cff3cff3cff3c;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fff7fff7fff7fff;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[0]) = 0x0001000100010001;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x1086658a18ba3594;
  *((unsigned long *)&__m256i_op0[2]) = 0x160fe9f000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x1086658a18ba3594;
  *((unsigned long *)&__m256i_op0[0]) = 0x160fe9f000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xe161616161614f61;
  *((unsigned long *)&__m256i_op1[2]) = 0xe161616161614f61;
  *((unsigned long *)&__m256i_op1[1]) = 0xe161616161614f61;
  *((unsigned long *)&__m256i_op1[0]) = 0xe161616161614f61;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000616100004f61;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000616100004f61;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000616100004f61;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000616100004f61;
  *((unsigned long *)&__m256i_result[3]) = 0x108659e46485f7e1;
  *((unsigned long *)&__m256i_result[2]) = 0x4df5b1a3ed5e02c1;
  *((unsigned long *)&__m256i_result[1]) = 0x108659e46485f7e1;
  *((unsigned long *)&__m256i_result[0]) = 0x4df5b1a3ed5e02c1;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x7ff0000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffff000100000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x01fffffffe000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x01fffffffe000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x01fffffffe000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x01fffffffe000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000001ffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xfe00000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000001ffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xfe00000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x00007f7f00007f7f;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00007f7f00007f7f;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0001fffe0000ffff;
  *((unsigned long *)&__m256i_op2[2]) = 0x0001fffe00010001;
  *((unsigned long *)&__m256i_op2[1]) = 0x0001fffe0000ffff;
  *((unsigned long *)&__m256i_op2[0]) = 0x0001fffe00010001;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000ffffffff;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x00000000aaabffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000aaabffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x000000000000ff01;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x000000000000ff01;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000ff810011;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000ff810011;
  *((unsigned long *)&__m256i_op2[3]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op2[2]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op2[1]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op2[0]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000000000fe;
  *((unsigned long *)&__m256i_result[2]) = 0x817f11ed81800ff0;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000000000fe;
  *((unsigned long *)&__m256i_result[0]) = 0x817f11ed81800ff0;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff00000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xff00000000ffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xff00000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xff00000000ffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0xff00000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xff00000000ffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xff00000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xff00000000ffffff;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000101000001010;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000101000001010;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000100010;
  *((unsigned long *)&__m256i_op2[2]) = 0x0010001000100010;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000100010;
  *((unsigned long *)&__m256i_op2[0]) = 0x0010001000100010;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000101000001010;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000101000001010;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffff80000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000005ffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000007ffffffce;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000005ffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000007ffffffce;
  *((unsigned long *)&__m256i_op2[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op2[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvmaddwev_q_d (__m256i_op0, __m256i_op1, __m256i_op2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
