/* { dg-do run } */
/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x1f);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0x9);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x7f00000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fff000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fff000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000001010101;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000001010101;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0xf);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x1d);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffc500000002d;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000200000034;
  *((unsigned long *)&__m256i_op1[3]) = 0xbfa3e127c147721f;
  *((unsigned long *)&__m256i_op1[2]) = 0x1729c173836edfbe;
  *((unsigned long *)&__m256i_op1[1]) = 0xdf91f111808007fb;
  *((unsigned long *)&__m256i_op1[0]) = 0x5ff1f90ffffbf30f;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000ff280016;
  *((unsigned long *)&__m256i_result[2]) = 0xd193a30f94b9b7df;
  *((unsigned long *)&__m256i_result[1]) = 0x000000000001001a;
  *((unsigned long *)&__m256i_result[0]) = 0xc88840fdf887fd87;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0x1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000ffffff00;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000000000f;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x1c);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffffc5556aaa8;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffffffc5556aaa8;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x555555553f800000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x555555553f800000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000007070205;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000002020100;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000007070205;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000002020100;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0xd);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x5980000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x5980000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x2);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffefefffffefe;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffffefe00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000003ff000003ff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x000003ff000003ff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x36);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x73);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xff00ffffff00ffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xff00ffffff00ffff;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xff00ffffff00ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xff00ffffff00ffff;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffe01fe01f;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffe01fe01f;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffe01fe01f;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffe01fe01f;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0xb);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000fe01020b0001;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000fe01020b0001;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0fff0fff00000020;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0fff0fff00000020;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x14);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xd207e90001fb16ef;
  *((unsigned long *)&__m256i_op0[2]) = 0xc8eab25698f97e90;
  *((unsigned long *)&__m256i_op0[1]) = 0xd207e90001fb16ef;
  *((unsigned long *)&__m256i_op0[0]) = 0xc8eab25698f97e90;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x01fb16ef98f97e90;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x01fb16ef98f97e90;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x0);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x003f003f003f003f;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x003f003f003f003f;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x1a);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffa0078fffa0074;
  *((unsigned long *)&__m256i_op0[1]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffa0078fffa0074;
  *((unsigned long *)&__m256i_op1[3]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffa2078fffa2074;
  *((unsigned long *)&__m256i_op1[1]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffa2078fffa2074;
  *((unsigned long *)&__m256i_result[3]) = 0x01ff01ff01ff01ff;
  *((unsigned long *)&__m256i_result[2]) = 0x01ff01ff01ff01ff;
  *((unsigned long *)&__m256i_result[1]) = 0x01ff01ff01ff01ff;
  *((unsigned long *)&__m256i_result[0]) = 0x01ff01ff01ff01ff;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x17);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000401000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x00003e6c0000cb7a;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000401000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x00003e6c0000cb7a;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x40000000b000032d;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x40000000b000032d;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x6);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x007f00ff007f00ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x007f00ff007f00ff;
  *((unsigned long *)&__m256i_op1[1]) = 0x007f00ff007f00ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x007f00ff007f00ff;
  *((unsigned long *)&__m256i_result[3]) = 0xfffffffffffffffc;
  *((unsigned long *)&__m256i_result[2]) = 0x01fc03fc01fc03fc;
  *((unsigned long *)&__m256i_result[1]) = 0xfffffffffffffffc;
  *((unsigned long *)&__m256i_result[0]) = 0x01fc03fc01fc03fc;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x3e);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00ff00ff00ef0120;
  *((unsigned long *)&__m256i_op0[1]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00ff00ff00ef0120;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000e9ece9ec;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000e9ece9ec;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000e9ece9ec;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000e9ece9ec;
  *((unsigned long *)&__m256i_result[3]) = 0x00ff00ff00ff0120;
  *((unsigned long *)&__m256i_result[2]) = 0x0000e9ec0000e9ec;
  *((unsigned long *)&__m256i_result[1]) = 0x00ff00ff00ff0120;
  *((unsigned long *)&__m256i_result[0]) = 0x0000e9ec0000e9ec;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x0);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffdd001dffe00020;
  *((unsigned long *)&__m256i_op0[2]) = 0xffdd001dffe00031;
  *((unsigned long *)&__m256i_op0[1]) = 0xffdd001dffe00020;
  *((unsigned long *)&__m256i_op0[0]) = 0xffdd001dffe00031;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x3ff73ff83ff73ff8;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x3ff73ff83ff73ff8;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x12);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00003fff00003fff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00003fff00003fff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00003fff00003fff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00003fff00003fff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0003000300030003;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0003000300030003;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0xc);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0003000300030003;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0003000300030003;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000003;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000003;
  *((unsigned long *)&__m256i_result[3]) = 0x0600060000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0600060000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x7);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0001fffe0000ffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0001fffe00010001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001fffe0000ffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0001fffe00010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0007fff8000ffff0;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000007fff8;
  *((unsigned long *)&__m256i_result[1]) = 0x0007fff8000ffff0;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000007fff8;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x1d);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_op0[2]) = 0x0010000f0000000f;
  *((unsigned long *)&__m256i_op0[1]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_op0[0]) = 0x0010000f0000000f;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x1e0000001e002000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x1e0000001e002000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x27);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffff3225;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffff3225;
  *((unsigned long *)&__m256i_op1[3]) = 0x2221201f1e1d1c1b;
  *((unsigned long *)&__m256i_op1[2]) = 0x1a19181716151413;
  *((unsigned long *)&__m256i_op1[1]) = 0x2221201f1e1d1c1b;
  *((unsigned long *)&__m256i_op1[0]) = 0x1a19181716151413;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000004442403;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000004442403;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x63);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7fef0000ffff0000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fef0000ffff0000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_result[3]) = 0xde00fe0000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000fe010000fe01;
  *((unsigned long *)&__m256i_result[1]) = 0xde00fe0000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000fe010000fe01;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x7);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00ff00fe00ff00fe;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00ff00fe00ff00fe;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000007070707;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff00ff07070707;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000007070707;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff00ff07070707;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0x5);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffff000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffff0000ffff0000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffff000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffff0000ffff0000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffff00000001;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000002;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffff00000001;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000002;
  *((unsigned long *)&__m256i_result[3]) = 0x03ff000003ff03ff;
  *((unsigned long *)&__m256i_result[2]) = 0x03ff000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x03ff000003ff03ff;
  *((unsigned long *)&__m256i_result[0]) = 0x03ff000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x16);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0x8);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000700000007;
  *((unsigned long *)&__m256i_result[2]) = 0x0007ffff0007ffff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000700000007;
  *((unsigned long *)&__m256i_result[0]) = 0x0007ffff0007ffff;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x2d);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x66);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000000e000e;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000000e000e;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000000e000e;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000000e000e;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x00000e0000000e00;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00000e0000000e00;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x8);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xfc003802fc000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xfc003802fc000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x03802fc000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x03802fc000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x14);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x5a);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x080808000828082f;
  *((unsigned long *)&__m256i_op0[2]) = 0x0808080008280820;
  *((unsigned long *)&__m256i_op0[1]) = 0x080808000828082f;
  *((unsigned long *)&__m256i_op0[0]) = 0x0808080008280820;
  *((unsigned long *)&__m256i_op1[3]) = 0x04e8296f18181818;
  *((unsigned long *)&__m256i_op1[2]) = 0x132feea900000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x04e8296f18181818;
  *((unsigned long *)&__m256i_op1[0]) = 0x132feea900000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00828082f0808080;
  *((unsigned long *)&__m256i_result[2]) = 0xf18181818132feea;
  *((unsigned long *)&__m256i_result[1]) = 0x00828082f0808080;
  *((unsigned long *)&__m256i_result[0]) = 0xf18181818132feea;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x24);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000200000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000004000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000200000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000004000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_w_d (__m256i_op0, __m256i_op1, 0x39);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x43);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xfe01fe01fc01fc01;
  *((unsigned long *)&__m256i_op0[2]) = 0x000000003fc03bbc;
  *((unsigned long *)&__m256i_op0[1]) = 0xfe01fe01fc01fc01;
  *((unsigned long *)&__m256i_op0[0]) = 0x000000003fc03bbc;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xfc01000000003fc0;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xfc01000000003fc0;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x10);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000000001fff0;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000feff0001ffb8;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000000001fff0;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000feff0001ffb8;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_h_w (__m256i_op0, __m256i_op1, 0x11);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000126000200;
  *((unsigned long *)&__m256i_op0[2]) = 0x2555205ea7bc4020;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000126000200;
  *((unsigned long *)&__m256i_op0[0]) = 0x2555205ea7bc4020;
  *((unsigned long *)&__m256i_op1[3]) = 0x0fffffff10000006;
  *((unsigned long *)&__m256i_op1[2]) = 0x10ffffff10000006;
  *((unsigned long *)&__m256i_op1[1]) = 0x0fffffff10000006;
  *((unsigned long *)&__m256i_op1[0]) = 0x10ffffff10000006;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000004980008;
  *((unsigned long *)&__m256i_result[2]) = 0x003ffffffc400000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000004980008;
  *((unsigned long *)&__m256i_result[0]) = 0x003ffffffc400000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x46);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00f0000000f00010;
  *((unsigned long *)&__m256i_op0[2]) = 0xfff0ff00fff0ff10;
  *((unsigned long *)&__m256i_op0[1]) = 0x00f0000000f00010;
  *((unsigned long *)&__m256i_op0[0]) = 0xfff0ff00fff0ff10;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0087ff87f807ff87;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0087ff87f807ff87;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0xd);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x68);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_b_h (__m256i_op0, __m256i_op1, 0x6);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x50);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0005000500050005;
  *((unsigned long *)&__m256i_op0[2]) = 0xfefefefefefefefe;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000050005;
  *((unsigned long *)&__m256i_op0[0]) = 0xfefefefefefefefe;
  *((unsigned long *)&__m256i_op1[3]) = 0xf007fe76f008fe19;
  *((unsigned long *)&__m256i_op1[2]) = 0xf08aff01f07cc291;
  *((unsigned long *)&__m256i_op1[1]) = 0xf007fe76f008fe19;
  *((unsigned long *)&__m256i_op1[0]) = 0xf08aff01f07cc291;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000001400;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000003c01ff9;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000003c01ff9;
  __m256i_out = __lasx_xvsrlni_d_q (__m256i_op0, __m256i_op1, 0x66);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
