#if USE_INTERNAL_IPC_SYSCALL
/* This version may work with some versions of libc/kernel.  */
#define __KERNEL__
#include <linux/ipc.h>
#ifndef LINUX_GLIBC1
#include <asm/ipc.h>
#endif

struct shmid_ds;

extern int chkr__ipc (int call, int first, int second, int third, void *ptr);
int chkr_shmctl (int shmid, int cmd, struct shmid_ds *buf);
			
int
chkr_shmctl (int shmid, int cmd, struct shmid_ds *buf)
{
  return chkr__ipc (SHMCTL, shmid, cmd, 0, buf);
}

#else /* USE_INTERNAL_IPC_SYSCALL  */

/* This version should work with any libc configuration.  */
/* However, it requires system call not to be hooked.  */
#include <sys/ipc.h>
#include <sys/shm.h>

int
chkr_shmctl (int shmid, int cmd, struct shmid_ds *buf)
{
  return shmctl (shmid, cmd, buf);
}
#endif /* !USE_INTERNAL_IPC_SYSCALL  */
