/* Based on:  */
/*
 * On a 486 or Pentium, we are better off not using the
 * byte string operations. But on a 386 or a PPro the
 * byte string ops are faster than doing it by hand
 * (MUCH faster on a Pentium).
 *
 * Also, the byte strings actually work correctly.
 */

/*
 * This string-include defines all string functions as inline
 * functions. Use gcc. It also assumes ds=es=data space, this should be
 * normal. Most of the string-functions are rather heavily hand-optimized,
 * see especially strtok,strstr,str[c]spn. They should work, but are not
 * very easy to understand. Everything is done entirely within the register
 * set, making the functions fast and clean. String instructions have been
 * used through-out, making for "slightly" unclear code :-)
 *
 *		NO Copyright (C) 1991, 1992 Linus Torvalds,
 *		consider these trivial functions to be PD.
 */
#include <stddef.h>

char * strcpy(char * dest,const char *src)
{
int d0, d1, d2;
__asm__ __volatile__(
	"cld\n"
	"1:\tlodsb\n\t"
	"stosb\n\t"
	"testb %%al,%%al\n\t"
	"jne 1b"
	: "=&S" (d0), "=&D" (d1), "=&a" (d2)
	:"0" (src),"1" (dest) : "memory");
return dest;
}

char * strncpy(char * dest,const char *src,size_t count)
{
  int d0, d1, d2, d3;
  __asm__ __volatile__(
		       "cld\n"
		       "1:\tdecl %2\n\t"
		       "js 2f\n\t"
		       "lodsb\n\t"
		       "stosb\n\t"
		       "testb %%al,%%al\n\t"
		       "jne 1b\n\t"
		       "rep\n\t"
		       "stosb\n"
		       "2:"
		       : "=&S" (d0), "=&D" (d1), "=&c" (d2), "=&a" (d3)
		       :"0" (src),"1" (dest),"2" (count) : "memory");
  return dest;
}

char * strcat(char * dest,const char * src)
{
int d0, d1, d2, d3;
__asm__ __volatile__(
	"cld\n\t"
	"repne\n\t"
	"scasb\n\t"
	"decl %1\n"
	"1:\tlodsb\n\t"
	"stosb\n\t"
	"testb %%al,%%al\n\t"
	"jne 1b"
	: "=&S" (d0), "=&D" (d1), "=&a" (d2), "=&c" (d3)
	: "0" (src), "1" (dest), "2" (0), "3" (0xffffffff):"memory");
return dest;
}

#if 0
#define __HAVE_ARCH_STRNCAT
extern inline char * strncat(char * dest,const char * src,size_t count)
{
int d0, d1, d2, d3;
__asm__ __volatile__(
	"cld\n\t"
	"repne\n\t"
	"scasb\n\t"
	"decl %1\n\t"
	"movl %8,%3\n"
	"1:\tdecl %3\n\t"
	"js 2f\n\t"
	"lodsb\n\t"
	"stosb\n\t"
	"testb %%al,%%al\n\t"
	"jne 1b\n"
	"2:\txorl %2,%2\n\t"
	"stosb"
	: "=&S" (d0), "=&D" (d1), "=&a" (d2), "=&c" (d3)
	: "0" (src),"1" (dest),"2" (0),"3" (0xffffffff), "g" (count)
	: "memory");
return dest;
}
#endif

int strcmp(const char * cs,const char * ct)
{
int d0, d1;
register int __res;
__asm__ __volatile__(
	"cld\n"
	"1:\tlodsb\n\t"
	"scasb\n\t"
	"jne 2f\n\t"
	"testb %%al,%%al\n\t"
	"jne 1b\n\t"
	"xorl %%eax,%%eax\n\t"
	"jmp 3f\n"
	"2:\tsbbl %%eax,%%eax\n\t"
	"orb $1,%%al\n"
	"3:"
	:"=a" (__res), "=&S" (d0), "=&D" (d1)
		     :"1" (cs),"2" (ct));
return __res;
}

int strncmp(const char * cs,const char * ct,size_t count)
{
  register int __res;
  int d0, d1, d2;
  __asm__ __volatile__(
		       "cld\n"
		       "1:\tdecl %3\n\t"
		       "js 2f\n\t"
		       "lodsb\n\t"
		       "scasb\n\t"
		       "jne 3f\n\t"
		       "testb %%al,%%al\n\t"
		       "jne 1b\n"
		       "2:\txorl %%eax,%%eax\n\t"
		       "jmp 4f\n"
		       "3:\tsbbl %%eax,%%eax\n\t"
		       "orb $1,%%al\n"
		       "4:"
		       :"=a" (__res), "=&S" (d0), "=&D" (d1), "=&c" (d2)
		       :"1" (cs),"2" (ct),"3" (count));
  return __res;
}

char * strchr(const char * s, int c)
{
  int d0;
  register char * __res;
  __asm__ __volatile__(
		       "cld\n\t"
		       "movb %%al,%%ah\n"
		       "1:\tlodsb\n\t"
		       "cmpb %%ah,%%al\n\t"
		       "je 2f\n\t"
		       "testb %%al,%%al\n\t"
		       "jne 1b\n\t"
		       "movl $1,%1\n"
		       "2:\tmovl %1,%0\n\t"
		       "decl %0"
		       :"=a" (__res), "=&S" (d0) : "1" (s),"0" (c));
  return __res;
}

#if 0
#define __HAVE_ARCH_STRRCHR
extern inline char * strrchr(const char * s, int c)
{
int d0, d1;
register char * __res;
__asm__ __volatile__(
	"cld\n\t"
	"movb %%al,%%ah\n"
	"1:\tlodsb\n\t"
	"cmpb %%ah,%%al\n\t"
	"jne 2f\n\t"
	"leal -1(%%esi),%0\n"
	"2:\ttestb %%al,%%al\n\t"
	"jne 1b"
	:"=g" (__res), "=&S" (d0), "=&a" (d1) :"0" (0),"1" (s),"2" (c));
return __res;
}
#endif

size_t strlen(const char * s)
{
  int d0;
  register int __res;
  __asm__ __volatile__(
		       "cld\n\t"
		       "repne\n\t"
		       "scasb\n\t"
		       "notl %0\n\t"
		       "decl %0"
		       :"=c" (__res), "=&D" (d0)
		       :"1" (s),"a" (0), "0" (0xffffffff));
  return __res;
}

void * memcpy(void * to, const void * from, size_t n)
{
  int d0, d1, d2;
  __asm__ __volatile__(
		       "cld\n\t"
		       "rep ; movsl\n\t"
		       "testb $2,%b4\n\t"
		       "je 1f\n\t"
		       "movsw\n"
		       "1:\ttestb $1,%b4\n\t"
		       "je 2f\n\t"
		       "movsb\n"
		       "2:"
		       : "=&c" (d0), "=&D" (d1), "=&S" (d2)
		       :"0" (n/4), "q" (n),"1" ((long) to),"2" ((long) from)
		       : "memory");
  return (to);
}

void *memmove(void * dest,const void * src, size_t n)
{
  int d0, d1, d2;
  if (dest<src)
    __asm__ __volatile__(
			 "cld\n\t"
			 "rep\n\t"
			 "movsb"
			 : "=&c" (d0), "=&S" (d1), "=&D" (d2)
			 :"0" (n),"1" (src),"2" (dest)
			 : "memory");
  else
    __asm__ __volatile__(
			 "std\n\t"
			 "rep\n\t"
			 "movsb\n\t"
			 "cld"
			 : "=&c" (d0), "=&S" (d1), "=&D" (d2)
			 :"0" (n),
			 "1" (n-1+(const char *)src),
			 "2" (n-1+(char *)dest)
			 :"memory");
  return dest;
}


void * memchr (const void * cs,int c,size_t count)
{
  int d0;
  register void * __res;
  if (!count)
    return NULL;
  __asm__ __volatile__(
		       "cld\n\t"
		       "repne\n\t"
		       "scasb\n\t"
		       "je 1f\n\t"
		       "movl $1,%0\n"
		       "1:\tdecl %0"
		       : "=D" (__res), "=&c" (d0)
		       : "a" (c),"0" (cs),"1" (count));
  return __res;
}

void *memset (void * s, char c,size_t count)
{
  int d0, d1;
  __asm__ __volatile__(
		       "cld\n\t"
		       "rep\n\t"
		       "stosb"
		       : "=&c" (d0), "=&D" (d1)
		       :"a" (c),"1" (s),"0" (count)
		       :"memory");
  return s;
}
