#include "available-stubs.h"

#include <stdio.h>
#include <gmp.h>
#include "checker_api.h"

#define ro(ARG) \
	stubs_chkr_check_addr (arg##ARG, sizeof *arg##ARG, CHKR_RO, "arg" #ARG)
#define wo(ARG) \
	stubs_chkr_check_addr (arg##ARG, sizeof *arg##ARG, CHKR_WO, "arg" #ARG)
#define rw(ARG) \
	stubs_chkr_check_addr (arg##ARG, sizeof *arg##ARG, CHKR_RW, "arg" #ARG)

#define CHKR_CHECK_STREAM(s) \
  stubs_chkr_check_addr (s, sizeof (FILE), CHKR_TW, "stream")

void *(*chkr_gmp_alloc)(size_t);
void *(*chkr_gmp_realloc)(void *, size_t, size_t);
void (*chkr_gmp_free)(void *, size_t);

/* compiled from: . */
#ifdef HAVE_mp_set_memory_functions
/* From `/usr/include/gmp.h:173'.  */
void chkr_stub_mp_set_memory_functions (void *(*arg0) (size_t), void *(*arg1) (void *, size_t, size_t), void (*arg2) (void *, size_t)) __asm__ (CHKR_PREFIX ("mp_set_memory_functions"));
void
chkr_stub_mp_set_memory_functions (void *(*arg0) (size_t), void *(*arg1) (void *, size_t, size_t), void (*arg2) (void *, size_t))
{
  chkr_check_exec (arg0);
  chkr_check_exec (arg1);
  chkr_check_exec (arg2);
  chkr_gmp_alloc = arg0;
  chkr_gmp_realloc = arg1;
  chkr_gmp_free = arg2;
#if USE_BI_JUMP
  __builtin_jump (mp_set_memory_functions);
#else
  mp_set_memory_functions (arg0, arg1, arg2);
#endif
}
#endif /* HAVE_mp_set_memory_functions */

#ifdef HAVE__mpz_realloc
/* From `/usr/include/gmp.h:181'.  */
void * chkr_stub__mpz_realloc (mpz_ptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("_mpz_realloc"));
void *
chkr_stub__mpz_realloc (mpz_ptr arg0, mp_size_t arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (_mpz_realloc);
#else
  return _mpz_realloc (arg0, arg1);
#endif
}
#endif /* HAVE__mpz_realloc */

#ifdef HAVE_mpz_abs
/* From `/usr/include/gmp.h:183'.  */
void chkr_stub_mpz_abs (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_abs"));
void
chkr_stub_mpz_abs (mpz_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_abs);
#else
  mpz_abs (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_abs */

#ifdef HAVE_mpz_add
/* From `/usr/include/gmp.h:184'.  */
void chkr_stub_mpz_add (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_add"));
void
chkr_stub_mpz_add (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_add);
#else
  mpz_add (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_add */

#ifdef HAVE_mpz_add_ui
/* From `/usr/include/gmp.h:185'.  */
void chkr_stub_mpz_add_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_add_ui"));
void
chkr_stub_mpz_add_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_add_ui);
#else
  mpz_add_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_add_ui */

#ifdef HAVE_mpz_and
/* From `/usr/include/gmp.h:186'.  */
void chkr_stub_mpz_and (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_and"));
void
chkr_stub_mpz_and (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_and);
#else
  mpz_and (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_and */

#ifdef HAVE_mpz_array_init
/* From `/usr/include/gmp.h:187'.  */
void chkr_stub_mpz_array_init (mpz_ptr arg0, mp_size_t arg1, mp_size_t arg2) __asm__ (CHKR_PREFIX ("mpz_array_init"));
void
chkr_stub_mpz_array_init (mpz_ptr arg0, mp_size_t arg1, mp_size_t arg2)
{
  stubs_chkr_check_addr (arg0, sizeof *arg0 * arg1, CHKR_WO, "array");
#if USE_BI_JUMP
  __builtin_jump (mpz_array_init);
#else
  mpz_array_init (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_array_init */

#ifdef HAVE_mpz_cdiv_q
/* From `/usr/include/gmp.h:188'.  */
void chkr_stub_mpz_cdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_cdiv_q"));
void
chkr_stub_mpz_cdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_q);
#else
  mpz_cdiv_q (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_q */

#ifdef HAVE_mpz_cdiv_q_ui
/* From `/usr/include/gmp.h:189'.  */
long unsigned int chkr_stub_mpz_cdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_cdiv_q_ui"));
long unsigned int
chkr_stub_mpz_cdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_q_ui);
#else
  return mpz_cdiv_q_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_q_ui */

#ifdef HAVE_mpz_cdiv_qr
/* From `/usr/include/gmp.h:190'.  */
void chkr_stub_mpz_cdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3) __asm__ (CHKR_PREFIX ("mpz_cdiv_qr"));
void
chkr_stub_mpz_cdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3)
{
  rw (0);
  rw (1);
  ro (2);
  ro (3);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_qr);
#else
  mpz_cdiv_qr (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_qr */

#ifdef HAVE_mpz_cdiv_qr_ui
/* From `/usr/include/gmp.h:191'.  */
long unsigned int chkr_stub_mpz_cdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3) __asm__ (CHKR_PREFIX ("mpz_cdiv_qr_ui"));
long unsigned int
chkr_stub_mpz_cdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3)
{
  rw (0);
  rw (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_qr_ui);
#else
  return mpz_cdiv_qr_ui (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_qr_ui */

#ifdef HAVE_mpz_cdiv_r
/* From `/usr/include/gmp.h:192'.  */
void chkr_stub_mpz_cdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_cdiv_r"));
void
chkr_stub_mpz_cdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_r);
#else
  mpz_cdiv_r (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_r */

#ifdef HAVE_mpz_cdiv_r_ui
/* From `/usr/include/gmp.h:193'.  */
long unsigned int chkr_stub_mpz_cdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_cdiv_r_ui"));
long unsigned int
chkr_stub_mpz_cdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_r_ui);
#else
  return mpz_cdiv_r_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_r_ui */

#ifdef HAVE_mpz_cdiv_ui
/* From `/usr/include/gmp.h:194'.  */
long unsigned int chkr_stub_mpz_cdiv_ui (mpz_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_cdiv_ui"));
long unsigned int
chkr_stub_mpz_cdiv_ui (mpz_srcptr arg0, long unsigned int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_cdiv_ui);
#else
  return mpz_cdiv_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cdiv_ui */

#ifdef HAVE_mpz_clear
/* From `/usr/include/gmp.h:195'.  */
void chkr_stub_mpz_clear (mpz_ptr arg0) __asm__ (CHKR_PREFIX ("mpz_clear"));
void
chkr_stub_mpz_clear (mpz_ptr arg0)
{
  rw (0);
  stubs_chkr_set_right (arg0, sizeof *arg0, CHKR_WO);
#if USE_BI_JUMP
  __builtin_jump (mpz_clear);
#else
  mpz_clear (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_clear */

#ifdef HAVE_mpz_clrbit
/* From `/usr/include/gmp.h:196'.  */
void chkr_stub_mpz_clrbit (mpz_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_clrbit"));
void
chkr_stub_mpz_clrbit (mpz_ptr arg0, long unsigned int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_clrbit);
#else
  mpz_clrbit (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_clrbit */

#ifdef HAVE_mpz_cmp
/* From `/usr/include/gmp.h:197'.  */
int chkr_stub_mpz_cmp (mpz_srcptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_cmp"));
int
chkr_stub_mpz_cmp (mpz_srcptr arg0, mpz_srcptr arg1)
{
  ro (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_cmp);
#else
  return mpz_cmp (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cmp */

#ifdef HAVE_mpz_cmp_si
/* From `/usr/include/gmp.h:198'.  */
int chkr_stub_mpz_cmp_si (mpz_srcptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpz_cmp_si"));
int
chkr_stub_mpz_cmp_si (mpz_srcptr arg0, long int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_cmp_si);
#else
  return mpz_cmp_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cmp_si */

#ifdef HAVE_mpz_cmp_ui
/* From `/usr/include/gmp.h:199'.  */
int chkr_stub_mpz_cmp_ui (mpz_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_cmp_ui"));
int
chkr_stub_mpz_cmp_ui (mpz_srcptr arg0, long unsigned int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_cmp_ui);
#else
  return mpz_cmp_ui (arg0, arg1);
  {
    int res;
    res = mpz_cmp_ui (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_cmp_ui */

#ifdef HAVE_mpz_com
/* From `/usr/include/gmp.h:200'.  */
void chkr_stub_mpz_com (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_com"));
void
chkr_stub_mpz_com (mpz_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_com);
#else
  mpz_com (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_com */

#ifdef HAVE_mpz_divexact
/* From `/usr/include/gmp.h:201'.  */
void chkr_stub_mpz_divexact (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_divexact"));
void
chkr_stub_mpz_divexact (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_divexact);
#else
  mpz_divexact (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_divexact */

#ifdef HAVE_mpz_fac_ui
/* From `/usr/include/gmp.h:202'.  */
void chkr_stub_mpz_fac_ui (mpz_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_fac_ui"));
void
chkr_stub_mpz_fac_ui (mpz_ptr arg0, long unsigned int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_fac_ui);
#else
  mpz_fac_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fac_ui */

#ifdef HAVE_mpz_fdiv_q
/* From `/usr/include/gmp.h:203'.  */
void chkr_stub_mpz_fdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_q"));
void
chkr_stub_mpz_fdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_q);
#else
  mpz_fdiv_q (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_q */

#ifdef HAVE_mpz_fdiv_q_2exp
/* From `/usr/include/gmp.h:204'.  */
void chkr_stub_mpz_fdiv_q_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_q_2exp"));
void
chkr_stub_mpz_fdiv_q_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_q_2exp);
#else
  mpz_fdiv_q_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_q_2exp */

#ifdef HAVE_mpz_fdiv_q_ui
/* From `/usr/include/gmp.h:205'.  */
long unsigned int chkr_stub_mpz_fdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_q_ui"));
long unsigned int
chkr_stub_mpz_fdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_q_ui);
#else
  return mpz_fdiv_q_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_q_ui */

#ifdef HAVE_mpz_fdiv_qr
/* From `/usr/include/gmp.h:206'.  */
void chkr_stub_mpz_fdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3) __asm__ (CHKR_PREFIX ("mpz_fdiv_qr"));
void
chkr_stub_mpz_fdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3)
{
  rw (0);
  rw (1);
  ro (2);
  ro (3);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_qr);
#else
  mpz_fdiv_qr (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_qr */

#ifdef HAVE_mpz_fdiv_qr_ui
/* From `/usr/include/gmp.h:207'.  */
long unsigned int chkr_stub_mpz_fdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3) __asm__ (CHKR_PREFIX ("mpz_fdiv_qr_ui"));
long unsigned int
chkr_stub_mpz_fdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3)
{
  rw (0);
  rw (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_qr_ui);
#else
  return mpz_fdiv_qr_ui (arg0, arg1, arg2, arg3);
  {
    long unsigned int res;
    res = mpz_fdiv_qr_ui (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_qr_ui */

#ifdef HAVE_mpz_fdiv_r
/* From `/usr/include/gmp.h:208'.  */
void chkr_stub_mpz_fdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_r"));
void
chkr_stub_mpz_fdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_r);
#else
  mpz_fdiv_r (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_r */

#ifdef HAVE_mpz_fdiv_r_2exp
/* From `/usr/include/gmp.h:209'.  */
void chkr_stub_mpz_fdiv_r_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_r_2exp"));
void
chkr_stub_mpz_fdiv_r_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_r_2exp);
#else
  mpz_fdiv_r_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_r_2exp */

#ifdef HAVE_mpz_fdiv_r_ui
/* From `/usr/include/gmp.h:210'.  */
long unsigned int chkr_stub_mpz_fdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_fdiv_r_ui"));
long unsigned int
chkr_stub_mpz_fdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_r_ui);
#else
  return mpz_fdiv_r_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_r_ui */

#ifdef HAVE_mpz_fdiv_ui
/* From `/usr/include/gmp.h:211'.  */
long unsigned int chkr_stub_mpz_fdiv_ui (mpz_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_fdiv_ui"));
long unsigned int
chkr_stub_mpz_fdiv_ui (mpz_srcptr arg0, long unsigned int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_fdiv_ui);
#else
  return mpz_fdiv_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_fdiv_ui */

#ifdef HAVE_mpz_gcd
/* From `/usr/include/gmp.h:212'.  */
void chkr_stub_mpz_gcd (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_gcd"));
void
chkr_stub_mpz_gcd (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_gcd);
#else
  mpz_gcd (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_gcd */

#ifdef HAVE_mpz_gcd_ui
/* From `/usr/include/gmp.h:213'.  */
long unsigned int chkr_stub_mpz_gcd_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_gcd_ui"));
long unsigned int
chkr_stub_mpz_gcd_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_gcd_ui);
#else
  return mpz_gcd_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_gcd_ui */

#ifdef HAVE_mpz_gcdext
/* From `/usr/include/gmp.h:214'.  */
void chkr_stub_mpz_gcdext (mpz_ptr arg0, mpz_ptr arg1, mpz_ptr arg2, mpz_srcptr arg3, mpz_srcptr arg4) __asm__ (CHKR_PREFIX ("mpz_gcdext"));
void
chkr_stub_mpz_gcdext (mpz_ptr arg0, mpz_ptr arg1, mpz_ptr arg2, mpz_srcptr arg3, mpz_srcptr arg4)
{
  rw (0);
  rw (1);
  rw (2);
  ro (3);
  ro (4);
#if USE_BI_JUMP
  __builtin_jump (mpz_gcdext);
#else
  mpz_gcdext (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_gcdext */

#ifdef HAVE_mpz_get_d
/* From `/usr/include/gmp.h:215'.  */
double chkr_stub_mpz_get_d (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_get_d"));
double
chkr_stub_mpz_get_d (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_get_d);
#else
  return mpz_get_d (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_get_d */

#ifdef HAVE_mpz_get_si
/* From `/usr/include/gmp.h:216'.  */
long int chkr_stub_mpz_get_si (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_get_si"));
long int
chkr_stub_mpz_get_si (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_get_si);
#else
  return mpz_get_si (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_get_si */

#ifdef HAVE_mpz_get_str
/* From `/usr/include/gmp.h:217'.  */
char * chkr_stub_mpz_get_str (char * arg0, int arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_get_str"));
char *
chkr_stub_mpz_get_str (char * arg0, int arg1, mpz_srcptr arg2)
{
  size_t minsize;
  ro (2);
  minsize = mpz_sizeinbase (arg2, arg1);
  if (arg0 == NULL)
    arg0 = chkr_gmp_alloc (minsize);
  stubs_chkr_check_addr (arg0, minsize, CHKR_WO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (mpz_get_str);
#else
  return mpz_get_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_get_str */

#ifdef HAVE_mpz_get_ui
/* From `/usr/include/gmp.h:218'.  */
long unsigned int chkr_stub_mpz_get_ui (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_get_ui"));
long unsigned int
chkr_stub_mpz_get_ui (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_get_ui);
#else
  return mpz_get_ui (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_get_ui */

#ifdef HAVE_mpz_getlimbn
/* From `/usr/include/gmp.h:219'.  */
mp_limb_t chkr_stub_mpz_getlimbn (mpz_srcptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("mpz_getlimbn"));
mp_limb_t
chkr_stub_mpz_getlimbn (mpz_srcptr arg0, mp_size_t arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_getlimbn);
#else
  return mpz_getlimbn (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_getlimbn */

#ifdef HAVE_mpz_hamdist
/* From `/usr/include/gmp.h:220'.  */
long unsigned int chkr_stub_mpz_hamdist (mpz_srcptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_hamdist"));
long unsigned int
chkr_stub_mpz_hamdist (mpz_srcptr arg0, mpz_srcptr arg1)
{
  ro (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_hamdist);
#else
  return mpz_hamdist (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_hamdist */

#ifdef HAVE_mpz_init
/* From `/usr/include/gmp.h:221'.  */
void chkr_stub_mpz_init (mpz_ptr arg0) __asm__ (CHKR_PREFIX ("mpz_init"));
void
chkr_stub_mpz_init (mpz_ptr arg0)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_init);
#else
  mpz_init (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init */

#ifdef HAVE_mpz_init_set
/* From `/usr/include/gmp.h:227'.  */
void chkr_stub_mpz_init_set (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_init_set"));
void
chkr_stub_mpz_init_set (mpz_ptr arg0, mpz_srcptr arg1)
{
  wo (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_init_set);
#else
  mpz_init_set (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init_set */

#ifdef HAVE_mpz_init_set_d
/* From `/usr/include/gmp.h:228'.  */
void chkr_stub_mpz_init_set_d (mpz_ptr arg0, double arg1) __asm__ (CHKR_PREFIX ("mpz_init_set_d"));
void
chkr_stub_mpz_init_set_d (mpz_ptr arg0, double arg1)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_init_set_d);
#else
  mpz_init_set_d (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init_set_d */

#ifdef HAVE_mpz_init_set_si
/* From `/usr/include/gmp.h:229'.  */
void chkr_stub_mpz_init_set_si (mpz_ptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpz_init_set_si"));
void
chkr_stub_mpz_init_set_si (mpz_ptr arg0, long int arg1)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_init_set_si);
#else
  mpz_init_set_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init_set_si */

#ifdef HAVE_mpz_init_set_str
/* From `/usr/include/gmp.h:230'.  */
int chkr_stub_mpz_init_set_str (mpz_ptr arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpz_init_set_str"));
int
chkr_stub_mpz_init_set_str (mpz_ptr arg0, const char * arg1, int arg2)
{
  wo (0);
  stubs_chkr_check_str (arg1, CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (mpz_init_set_str);
#else
  return mpz_init_set_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init_set_str */

#ifdef HAVE_mpz_init_set_ui
/* From `/usr/include/gmp.h:231'.  */
void chkr_stub_mpz_init_set_ui (mpz_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_init_set_ui"));
void
chkr_stub_mpz_init_set_ui (mpz_ptr arg0, long unsigned int arg1)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_init_set_ui);
#else
  mpz_init_set_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_init_set_ui */

#ifdef HAVE_mpz_invert
/* From `/usr/include/gmp.h:232'.  */
int chkr_stub_mpz_invert (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_invert"));
int
chkr_stub_mpz_invert (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_invert);
#else
  return mpz_invert (arg0, arg1, arg2);
  {
    int res;
    res = mpz_invert (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_invert */

#ifdef HAVE_mpz_ior
/* From `/usr/include/gmp.h:233'.  */
void chkr_stub_mpz_ior (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_ior"));
void
chkr_stub_mpz_ior (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_ior);
#else
  mpz_ior (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_ior */

#ifdef HAVE_mpz_jacobi
/* From `/usr/include/gmp.h:234'.  */
int chkr_stub_mpz_jacobi (mpz_srcptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_jacobi"));
int
chkr_stub_mpz_jacobi (mpz_srcptr arg0, mpz_srcptr arg1)
{
  ro (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_jacobi);
#else
  return mpz_jacobi (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_jacobi */

#ifdef HAVE_mpz_legendre
/* From `/usr/include/gmp.h:235'.  */
int chkr_stub_mpz_legendre (mpz_srcptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_legendre"));
int
chkr_stub_mpz_legendre (mpz_srcptr arg0, mpz_srcptr arg1)
{
  ro (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_legendre);
#else
  return mpz_legendre (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_legendre */

#ifdef HAVE_mpz_mod
/* From `/usr/include/gmp.h:236'.  */
void chkr_stub_mpz_mod (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_mod"));
void
chkr_stub_mpz_mod (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_mod);
#else
  mpz_mod (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_mod */

#ifdef HAVE_mpz_mul
/* From `/usr/include/gmp.h:237'.  */
void chkr_stub_mpz_mul (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_mul"));
void
chkr_stub_mpz_mul (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_mul);
#else
  mpz_mul (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_mul */

#ifdef HAVE_mpz_mul_2exp
/* From `/usr/include/gmp.h:238'.  */
void chkr_stub_mpz_mul_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_mul_2exp"));
void
chkr_stub_mpz_mul_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_mul_2exp);
#else
  mpz_mul_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_mul_2exp */

#ifdef HAVE_mpz_mul_ui
/* From `/usr/include/gmp.h:239'.  */
void chkr_stub_mpz_mul_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_mul_ui"));
void
chkr_stub_mpz_mul_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_mul_ui);
#else
  mpz_mul_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_mul_ui */

#ifdef HAVE_mpz_neg
/* From `/usr/include/gmp.h:240'.  */
void chkr_stub_mpz_neg (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_neg"));
void
chkr_stub_mpz_neg (mpz_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_neg);
#else
  mpz_neg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_neg */

#ifdef HAVE_mpz_perfect_square_p
/* From `/usr/include/gmp.h:246'.  */
int chkr_stub_mpz_perfect_square_p (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_perfect_square_p"));
int
chkr_stub_mpz_perfect_square_p (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_perfect_square_p);
#else
  return mpz_perfect_square_p (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_perfect_square_p */

#ifdef HAVE_mpz_popcount
/* From `/usr/include/gmp.h:247'.  */
long unsigned int chkr_stub_mpz_popcount (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_popcount"));
long unsigned int
chkr_stub_mpz_popcount (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_popcount);
#else
  return mpz_popcount (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_popcount */

#ifdef HAVE_mpz_pow_ui
/* From `/usr/include/gmp.h:248'.  */
void chkr_stub_mpz_pow_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_pow_ui"));
void
chkr_stub_mpz_pow_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_pow_ui);
#else
  mpz_pow_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_pow_ui */

#ifdef HAVE_mpz_powm
/* From `/usr/include/gmp.h:249'.  */
void chkr_stub_mpz_powm (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2, mpz_srcptr arg3) __asm__ (CHKR_PREFIX ("mpz_powm"));
void
chkr_stub_mpz_powm (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2, mpz_srcptr arg3)
{
  rw (0);
  ro (1);
  ro (2);
  ro (3);
#if USE_BI_JUMP
  __builtin_jump (mpz_powm);
#else
  mpz_powm (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_powm */

#ifdef HAVE_mpz_powm_ui
/* From `/usr/include/gmp.h:250'.  */
void chkr_stub_mpz_powm_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2, mpz_srcptr arg3) __asm__ (CHKR_PREFIX ("mpz_powm_ui"));
void
chkr_stub_mpz_powm_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2, mpz_srcptr arg3)
{
  rw (0);
  ro (1);
  ro (3);
#if USE_BI_JUMP
  __builtin_jump (mpz_powm_ui);
#else
  mpz_powm_ui (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_powm_ui */

#ifdef HAVE_mpz_probab_prime_p
/* From `/usr/include/gmp.h:251'.  */
int chkr_stub_mpz_probab_prime_p (mpz_srcptr arg0, int arg1) __asm__ (CHKR_PREFIX ("mpz_probab_prime_p"));
int
chkr_stub_mpz_probab_prime_p (mpz_srcptr arg0, int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_probab_prime_p);
#else
  return mpz_probab_prime_p (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_probab_prime_p */

#ifdef HAVE_mpz_random
/* From `/usr/include/gmp.h:252'.  */
void chkr_stub_mpz_random (mpz_ptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("mpz_random"));
void
chkr_stub_mpz_random (mpz_ptr arg0, mp_size_t arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_random);
#else
  mpz_random (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_random */

#ifdef HAVE_mpz_random2
/* From `/usr/include/gmp.h:253'.  */
void chkr_stub_mpz_random2 (mpz_ptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("mpz_random2"));
void
chkr_stub_mpz_random2 (mpz_ptr arg0, mp_size_t arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_random2);
#else
  mpz_random2 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_random2 */

#ifdef HAVE_mpz_scan0
/* From `/usr/include/gmp.h:254'.  */
long unsigned int chkr_stub_mpz_scan0 (mpz_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_scan0"));
long unsigned int
chkr_stub_mpz_scan0 (mpz_srcptr arg0, long unsigned int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_scan0);
#else
  return mpz_scan0 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_scan0 */

#ifdef HAVE_mpz_scan1
/* From `/usr/include/gmp.h:255'.  */
long unsigned int chkr_stub_mpz_scan1 (mpz_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_scan1"));
long unsigned int
chkr_stub_mpz_scan1 (mpz_srcptr arg0, long unsigned int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_scan1);
#else
  return mpz_scan1 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_scan1 */

#ifdef HAVE_mpz_set
/* From `/usr/include/gmp.h:256'.  */
void chkr_stub_mpz_set (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_set"));
void
chkr_stub_mpz_set (mpz_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_set);
#else
  mpz_set (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set */

#ifdef HAVE_mpz_set_d
/* From `/usr/include/gmp.h:257'.  */
void chkr_stub_mpz_set_d (mpz_ptr arg0, double arg1) __asm__ (CHKR_PREFIX ("mpz_set_d"));
void
chkr_stub_mpz_set_d (mpz_ptr arg0, double arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_set_d);
#else
  mpz_set_d (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_d */

#ifdef HAVE_mpz_set_f
/* From `/usr/include/gmp.h:258'.  */
void chkr_stub_mpz_set_f (mpz_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_set_f"));
void
chkr_stub_mpz_set_f (mpz_ptr arg0, mpf_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_set_f);
#else
  mpz_set_f (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_f */

#ifdef HAVE_mpz_set_q
/* From `/usr/include/gmp.h:259'.  */
void chkr_stub_mpz_set_q (mpz_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_set_q"));
void
chkr_stub_mpz_set_q (mpz_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_set_q);
#else
  mpz_set_q (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_q */

#ifdef HAVE_mpz_set_si
/* From `/usr/include/gmp.h:260'.  */
void chkr_stub_mpz_set_si (mpz_ptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpz_set_si"));
void
chkr_stub_mpz_set_si (mpz_ptr arg0, long int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_set_si);
#else
  mpz_set_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_si */

#ifdef HAVE_mpz_set_str
/* From `/usr/include/gmp.h:261'.  */
int chkr_stub_mpz_set_str (mpz_ptr arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpz_set_str"));
int
chkr_stub_mpz_set_str (mpz_ptr arg0, const char * arg1, int arg2)
{
  rw (0);
  stubs_chkr_check_str (arg1, CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (mpz_set_str);
#else
  return mpz_set_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_str */

#ifdef HAVE_mpz_set_ui
/* From `/usr/include/gmp.h:262'.  */
void chkr_stub_mpz_set_ui (mpz_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_set_ui"));
void
chkr_stub_mpz_set_ui (mpz_ptr arg0, long unsigned int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_set_ui);
#else
  mpz_set_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_set_ui */

#ifdef HAVE_mpz_setbit
/* From `/usr/include/gmp.h:263'.  */
void chkr_stub_mpz_setbit (mpz_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpz_setbit"));
void
chkr_stub_mpz_setbit (mpz_ptr arg0, long unsigned int arg1)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_setbit);
#else
  mpz_setbit (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_setbit */

#ifdef HAVE_mpz_size
/* From `/usr/include/gmp.h:264'.  */
size_t chkr_stub_mpz_size (mpz_srcptr arg0) __asm__ (CHKR_PREFIX ("mpz_size"));
size_t
chkr_stub_mpz_size (mpz_srcptr arg0)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_size);
#else
  return mpz_size (arg0);
  {
    size_t res;
    res = mpz_size (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_size */

#ifdef HAVE_mpz_sizeinbase
/* From `/usr/include/gmp.h:265'.  */
size_t chkr_stub_mpz_sizeinbase (mpz_srcptr arg0, int arg1) __asm__ (CHKR_PREFIX ("mpz_sizeinbase"));
size_t
chkr_stub_mpz_sizeinbase (mpz_srcptr arg0, int arg1)
{
  ro (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_sizeinbase);
#else
  return mpz_sizeinbase (arg0, arg1);
  {
    size_t res;
    res = mpz_sizeinbase (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_sizeinbase */

#ifdef HAVE_mpz_sqrt
/* From `/usr/include/gmp.h:266'.  */
void chkr_stub_mpz_sqrt (mpz_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_sqrt"));
void
chkr_stub_mpz_sqrt (mpz_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_sqrt);
#else
  mpz_sqrt (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_sqrt */

#ifdef HAVE_mpz_sqrtrem
/* From `/usr/include/gmp.h:267'.  */
void chkr_stub_mpz_sqrtrem (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_sqrtrem"));
void
chkr_stub_mpz_sqrtrem (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2)
{
  rw (0);
  rw (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_sqrtrem);
#else
  mpz_sqrtrem (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_sqrtrem */

#ifdef HAVE_mpz_sub
/* From `/usr/include/gmp.h:268'.  */
void chkr_stub_mpz_sub (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_sub"));
void
chkr_stub_mpz_sub (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_sub);
#else
  mpz_sub (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_sub */

#ifdef HAVE_mpz_sub_ui
/* From `/usr/include/gmp.h:269'.  */
void chkr_stub_mpz_sub_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_sub_ui"));
void
chkr_stub_mpz_sub_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_sub_ui);
#else
  mpz_sub_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_sub_ui */

#ifdef HAVE_mpz_tdiv_q
/* From `/usr/include/gmp.h:270'.  */
void chkr_stub_mpz_tdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_q"));
void
chkr_stub_mpz_tdiv_q (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_q);
#else
  mpz_tdiv_q (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_q */

#ifdef HAVE_mpz_tdiv_q_2exp
/* From `/usr/include/gmp.h:271'.  */
void chkr_stub_mpz_tdiv_q_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_q_2exp"));
void
chkr_stub_mpz_tdiv_q_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_q_2exp);
#else
  mpz_tdiv_q_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_q_2exp */

#ifdef HAVE_mpz_tdiv_q_ui
/* From `/usr/include/gmp.h:272'.  */
void chkr_stub_mpz_tdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_q_ui"));
void
chkr_stub_mpz_tdiv_q_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_q_ui);
#else
  mpz_tdiv_q_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_q_ui */

#ifdef HAVE_mpz_tdiv_qr
/* From `/usr/include/gmp.h:273'.  */
void chkr_stub_mpz_tdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3) __asm__ (CHKR_PREFIX ("mpz_tdiv_qr"));
void
chkr_stub_mpz_tdiv_qr (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, mpz_srcptr arg3)
{
  rw (0);
  rw (1);
  ro (2);
  ro (3);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_qr);
#else
  mpz_tdiv_qr (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_qr */

#ifdef HAVE_mpz_tdiv_qr_ui
/* From `/usr/include/gmp.h:274'.  */
void chkr_stub_mpz_tdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3) __asm__ (CHKR_PREFIX ("mpz_tdiv_qr_ui"));
void
chkr_stub_mpz_tdiv_qr_ui (mpz_ptr arg0, mpz_ptr arg1, mpz_srcptr arg2, long unsigned int arg3)
{
  rw (0);
  rw (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_qr_ui);
#else
  mpz_tdiv_qr_ui (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_qr_ui */

#ifdef HAVE_mpz_tdiv_r
/* From `/usr/include/gmp.h:275'.  */
void chkr_stub_mpz_tdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_r"));
void
chkr_stub_mpz_tdiv_r (mpz_ptr arg0, mpz_srcptr arg1, mpz_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_r);
#else
  mpz_tdiv_r (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_r */

#ifdef HAVE_mpz_tdiv_r_2exp
/* From `/usr/include/gmp.h:276'.  */
void chkr_stub_mpz_tdiv_r_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_r_2exp"));
void
chkr_stub_mpz_tdiv_r_2exp (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_r_2exp);
#else
  mpz_tdiv_r_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_r_2exp */

#ifdef HAVE_mpz_tdiv_r_ui
/* From `/usr/include/gmp.h:277'.  */
void chkr_stub_mpz_tdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_tdiv_r_ui"));
void
chkr_stub_mpz_tdiv_r_ui (mpz_ptr arg0, mpz_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpz_tdiv_r_ui);
#else
  mpz_tdiv_r_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_tdiv_r_ui */

#ifdef HAVE_mpz_ui_pow_ui
/* From `/usr/include/gmp.h:278'.  */
void chkr_stub_mpz_ui_pow_ui (mpz_ptr arg0, long unsigned int arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpz_ui_pow_ui"));
void
chkr_stub_mpz_ui_pow_ui (mpz_ptr arg0, long unsigned int arg1, long unsigned int arg2)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpz_ui_pow_ui);
#else
  mpz_ui_pow_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_ui_pow_ui */

#ifdef HAVE_mpq_init
/* From `/usr/include/gmp.h:282'.  */
void chkr_stub_mpq_init (mpq_ptr arg0) __asm__ (CHKR_PREFIX ("mpq_init"));
void
chkr_stub_mpq_init (mpq_ptr arg0)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpq_init);
#else
  mpq_init (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_init */

#ifdef HAVE_mpq_clear
/* From `/usr/include/gmp.h:283'.  */
void chkr_stub_mpq_clear (mpq_ptr arg0) __asm__ (CHKR_PREFIX ("mpq_clear"));
void
chkr_stub_mpq_clear (mpq_ptr arg0)
{
  rw (0);
  stubs_chkr_set_right (arg0, sizeof *arg0, CHKR_WO);
#if USE_BI_JUMP
  __builtin_jump (mpq_clear);
#else
  mpq_clear (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_clear */

#ifdef HAVE_mpq_set
/* From `/usr/include/gmp.h:284'.  */
void chkr_stub_mpq_set (mpq_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_set"));
void
chkr_stub_mpq_set (mpq_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpq_set);
#else
  mpq_set (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set */

#ifdef HAVE_mpq_set_ui
/* From `/usr/include/gmp.h:285'.  */
void chkr_stub_mpq_set_ui (mpq_ptr arg0, long unsigned int arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpq_set_ui"));
void
chkr_stub_mpq_set_ui (mpq_ptr arg0, long unsigned int arg1, long unsigned int arg2)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpq_set_ui);
#else
  mpq_set_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set_ui */

#ifdef HAVE_mpq_set_si
/* From `/usr/include/gmp.h:286'.  */
void chkr_stub_mpq_set_si (mpq_ptr arg0, long int arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpq_set_si"));
void
chkr_stub_mpq_set_si (mpq_ptr arg0, long int arg1, long unsigned int arg2)
{
  rw (0);
#if USE_BI_JUMP
  __builtin_jump (mpq_set_si);
#else
  mpq_set_si (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set_si */

#ifdef HAVE_mpq_set_z
/* From `/usr/include/gmp.h:287'.  */
void chkr_stub_mpq_set_z (mpq_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_set_z"));
void
chkr_stub_mpq_set_z (mpq_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
#if USE_BI_JUMP
  __builtin_jump (mpq_set_z);
#else
  mpq_set_z (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set_z */

#ifdef HAVE_mpq_add
/* From `/usr/include/gmp.h:288'.  */
void chkr_stub_mpq_add (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2) __asm__ (CHKR_PREFIX ("mpq_add"));
void
chkr_stub_mpq_add (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
#if USE_BI_JUMP
  __builtin_jump (mpq_add);
#else
  mpq_add (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_add */

#ifdef HAVE_mpq_sub
/* From `/usr/include/gmp.h:289'.  */
void chkr_stub_mpq_sub (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2) __asm__ (CHKR_PREFIX ("mpq_sub"));
void
chkr_stub_mpq_sub (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_sub);
#else
  mpq_sub (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_sub */

#ifdef HAVE_mpq_mul
/* From `/usr/include/gmp.h:290'.  */
void chkr_stub_mpq_mul (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2) __asm__ (CHKR_PREFIX ("mpq_mul"));
void
chkr_stub_mpq_mul (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_mul);
#else
  mpq_mul (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_mul */

#ifdef HAVE_mpq_div
/* From `/usr/include/gmp.h:291'.  */
void chkr_stub_mpq_div (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2) __asm__ (CHKR_PREFIX ("mpq_div"));
void
chkr_stub_mpq_div (mpq_ptr arg0, mpq_srcptr arg1, mpq_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_div);
#else
  mpq_div (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_div */

#ifdef HAVE_mpq_neg
/* From `/usr/include/gmp.h:292'.  */
void chkr_stub_mpq_neg (mpq_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_neg"));
void
chkr_stub_mpq_neg (mpq_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_neg);
#else
  mpq_neg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_neg */

#ifdef HAVE_mpq_cmp
/* From `/usr/include/gmp.h:293'.  */
int chkr_stub_mpq_cmp (mpq_srcptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_cmp"));
int
chkr_stub_mpq_cmp (mpq_srcptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_cmp);
#else
  return mpq_cmp (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_cmp */

#ifdef HAVE_mpq_cmp_ui
/* From `/usr/include/gmp.h:294'.  */
int chkr_stub_mpq_cmp_ui (mpq_srcptr arg0, long unsigned int arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpq_cmp_ui"));
int
chkr_stub_mpq_cmp_ui (mpq_srcptr arg0, long unsigned int arg1, long unsigned int arg2)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_cmp_ui);
#else
  return mpq_cmp_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_cmp_ui */

#ifdef HAVE_mpq_equal
/* From `/usr/include/gmp.h:295'.  */
int chkr_stub_mpq_equal (mpq_srcptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_equal"));
int
chkr_stub_mpq_equal (mpq_srcptr arg0, mpq_srcptr arg1)
{
  ro (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_equal);
#else
  return mpq_equal (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_equal */

#ifdef HAVE_mpq_inv
/* From `/usr/include/gmp.h:296'.  */
void chkr_stub_mpq_inv (mpq_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_inv"));
void
chkr_stub_mpq_inv (mpq_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_inv);
#else
  mpq_inv (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_inv */

#ifdef HAVE_mpq_set_num
/* From `/usr/include/gmp.h:297'.  */
void chkr_stub_mpq_set_num (mpq_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_set_num"));
void
chkr_stub_mpq_set_num (mpq_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_set_num);
#else
  mpq_set_num (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set_num */

#ifdef HAVE_mpq_set_den
/* From `/usr/include/gmp.h:298'.  */
void chkr_stub_mpq_set_den (mpq_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_set_den"));
void
chkr_stub_mpq_set_den (mpq_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_set_den);
#else
  mpq_set_den (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_set_den */

#ifdef HAVE_mpq_get_num
/* From `/usr/include/gmp.h:299'.  */
void chkr_stub_mpq_get_num (mpz_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_get_num"));
void
chkr_stub_mpq_get_num (mpz_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_get_num);
#else
  mpq_get_num (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_get_num */

#ifdef HAVE_mpq_get_den
/* From `/usr/include/gmp.h:300'.  */
void chkr_stub_mpq_get_den (mpz_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpq_get_den"));
void
chkr_stub_mpq_get_den (mpz_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_get_den);
#else
  mpq_get_den (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_get_den */

#ifdef HAVE_mpq_get_d
/* From `/usr/include/gmp.h:301'.  */
double chkr_stub_mpq_get_d (mpq_srcptr arg0) __asm__ (CHKR_PREFIX ("mpq_get_d"));
double
chkr_stub_mpq_get_d (mpq_srcptr arg0)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_get_d);
#else
  return mpq_get_d (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_get_d */

#ifdef HAVE_mpq_canonicalize
/* From `/usr/include/gmp.h:302'.  */
void chkr_stub_mpq_canonicalize (mpq_ptr arg0) __asm__ (CHKR_PREFIX ("mpq_canonicalize"));
void
chkr_stub_mpq_canonicalize (mpq_ptr arg0)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpq_canonicalize);
#else
  mpq_canonicalize (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpq_canonicalize */

#ifdef HAVE_mpf_abs
/* From `/usr/include/gmp.h:306'.  */
void chkr_stub_mpf_abs (mpf_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_abs"));
void
chkr_stub_mpf_abs (mpf_ptr arg0, mpf_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_abs);
#else
  mpf_abs (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_abs */

#ifdef HAVE_mpf_add
/* From `/usr/include/gmp.h:307'.  */
void chkr_stub_mpf_add (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_add"));
void
chkr_stub_mpf_add (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_add);
#else
  mpf_add (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_add */

#ifdef HAVE_mpf_add_ui
/* From `/usr/include/gmp.h:308'.  */
void chkr_stub_mpf_add_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_add_ui"));
void
chkr_stub_mpf_add_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_add_ui);
#else
  mpf_add_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_add_ui */

#ifdef HAVE_mpf_clear
/* From `/usr/include/gmp.h:309'.  */
void chkr_stub_mpf_clear (mpf_ptr arg0) __asm__ (CHKR_PREFIX ("mpf_clear"));
void
chkr_stub_mpf_clear (mpf_ptr arg0)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_clear);
#else
  mpf_clear (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_clear */

#ifdef HAVE_mpf_cmp
/* From `/usr/include/gmp.h:310'.  */
int chkr_stub_mpf_cmp (mpf_srcptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_cmp"));
int
chkr_stub_mpf_cmp (mpf_srcptr arg0, mpf_srcptr arg1)
{
  ro (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_cmp);
#else
  return mpf_cmp (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_cmp */

#ifdef HAVE_mpf_cmp_si
/* From `/usr/include/gmp.h:311'.  */
int chkr_stub_mpf_cmp_si (mpf_srcptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpf_cmp_si"));
int
chkr_stub_mpf_cmp_si (mpf_srcptr arg0, long int arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_cmp_si);
#else
  return mpf_cmp_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_cmp_si */

#ifdef HAVE_mpf_cmp_ui
/* From `/usr/include/gmp.h:312'.  */
int chkr_stub_mpf_cmp_ui (mpf_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_cmp_ui"));
int
chkr_stub_mpf_cmp_ui (mpf_srcptr arg0, long unsigned int arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_cmp_ui);
#else
  return mpf_cmp_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_cmp_ui */

#ifdef HAVE_mpf_div
/* From `/usr/include/gmp.h:313'.  */
void chkr_stub_mpf_div (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_div"));
void
chkr_stub_mpf_div (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_div);
#else
  mpf_div (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_div */

#ifdef HAVE_mpf_div_2exp
/* From `/usr/include/gmp.h:314'.  */
void chkr_stub_mpf_div_2exp (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_div_2exp"));
void
chkr_stub_mpf_div_2exp (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_div_2exp);
#else
  mpf_div_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_div_2exp */

#ifdef HAVE_mpf_div_ui
/* From `/usr/include/gmp.h:315'.  */
void chkr_stub_mpf_div_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_div_ui"));
void
chkr_stub_mpf_div_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_div_ui);
#else
  mpf_div_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_div_ui */

#ifdef HAVE_mpf_dump
/* From `/usr/include/gmp.h:316'.  */
void chkr_stub_mpf_dump (mpf_srcptr arg0) __asm__ (CHKR_PREFIX ("mpf_dump"));
void
chkr_stub_mpf_dump (mpf_srcptr arg0)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_dump);
#else
  mpf_dump (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_dump */

#ifdef HAVE_mpf_eq
/* From `/usr/include/gmp.h:317'.  */
int chkr_stub_mpf_eq (mpf_srcptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_eq"));
int
chkr_stub_mpf_eq (mpf_srcptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  ro (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_eq);
#else
  return mpf_eq (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_eq */

#ifdef HAVE_mpf_get_d
/* From `/usr/include/gmp.h:318'.  */
double chkr_stub_mpf_get_d (mpf_srcptr arg0) __asm__ (CHKR_PREFIX ("mpf_get_d"));
double
chkr_stub_mpf_get_d (mpf_srcptr arg0)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_get_d);
#else
  return mpf_get_d (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_get_d */

#ifdef HAVE_mpf_get_prec
/* From `/usr/include/gmp.h:319'.  */
long unsigned int chkr_stub_mpf_get_prec (mpf_srcptr arg0) __asm__ (CHKR_PREFIX ("mpf_get_prec"));
long unsigned int
chkr_stub_mpf_get_prec (mpf_srcptr arg0)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_get_prec);
#else
  return mpf_get_prec (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_get_prec */

#ifdef HAVE_mpf_get_str
/* From `/usr/include/gmp.h:320'.  */
char * chkr_stub_mpf_get_str (char * arg0, mp_exp_t * arg1, int arg2, size_t arg3, mpf_srcptr arg4) __asm__ (CHKR_PREFIX ("mpf_get_str"));
char *
chkr_stub_mpf_get_str (char * arg0, mp_exp_t * arg1, int arg2, size_t arg3, mpf_srcptr arg4)
{
  /* FIXME: this is cheating and won't always work. */
  stubs_chkr_check_addr (arg1, sizeof *arg1, CHKR_WO, "arg1");
  ro (4);
  {
    char * res;
    res = mpf_get_str (arg0, arg1, arg2, arg3, arg4);
    stubs_chkr_check_str (arg0, CHKR_WO, "arg0");
    return res;
  }
}
#endif /* HAVE_mpf_get_str */

#ifdef HAVE_mpf_init
/* From `/usr/include/gmp.h:321'.  */
void chkr_stub_mpf_init (mpf_ptr arg0) __asm__ (CHKR_PREFIX ("mpf_init"));
void
chkr_stub_mpf_init (mpf_ptr arg0)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpf_init);
#else
  mpf_init (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init */

#ifdef HAVE_mpf_init2
/* From `/usr/include/gmp.h:322'.  */
void chkr_stub_mpf_init2 (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_init2"));
void
chkr_stub_mpf_init2 (mpf_ptr arg0, long unsigned int arg1)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpf_init2);
#else
  mpf_init2 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init2 */

#ifdef HAVE_mpf_init_set
/* From `/usr/include/gmp.h:326'.  */
void chkr_stub_mpf_init_set (mpf_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_init_set"));
void
chkr_stub_mpf_init_set (mpf_ptr arg0, mpf_srcptr arg1)
{
  wo (0);
#if USE_BI_JUMP
  __builtin_jump (mpf_init_set);
#else
  mpf_init_set (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init_set */

#ifdef HAVE_mpf_init_set_d
/* From `/usr/include/gmp.h:327'.  */
void chkr_stub_mpf_init_set_d (mpf_ptr arg0, double arg1) __asm__ (CHKR_PREFIX ("mpf_init_set_d"));
void
chkr_stub_mpf_init_set_d (mpf_ptr arg0, double arg1)
{
  wo (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_init_set_d);
#else
  mpf_init_set_d (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init_set_d */

#ifdef HAVE_mpf_init_set_si
/* From `/usr/include/gmp.h:328'.  */
void chkr_stub_mpf_init_set_si (mpf_ptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpf_init_set_si"));
void
chkr_stub_mpf_init_set_si (mpf_ptr arg0, long int arg1)
{
  wo (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_init_set_si);
#else
  mpf_init_set_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init_set_si */

#ifdef HAVE_mpf_init_set_str
/* From `/usr/include/gmp.h:329'.  */
int chkr_stub_mpf_init_set_str (mpf_ptr arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpf_init_set_str"));
int
chkr_stub_mpf_init_set_str (mpf_ptr arg0, const char * arg1, int arg2)
{
  wo (0);
  
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (mpf_init_set_str);
#else
  return mpf_init_set_str (arg0, arg1, arg2);
  {
    int res;
    res = mpf_init_set_str (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init_set_str */

#ifdef HAVE_mpf_init_set_ui
/* From `/usr/include/gmp.h:330'.  */
void chkr_stub_mpf_init_set_ui (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_init_set_ui"));
void
chkr_stub_mpf_init_set_ui (mpf_ptr arg0, long unsigned int arg1)
{
  wo (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_init_set_ui);
#else
  mpf_init_set_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_init_set_ui */

#ifdef HAVE_mpf_mul
/* From `/usr/include/gmp.h:331'.  */
void chkr_stub_mpf_mul (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_mul"));
void
chkr_stub_mpf_mul (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_mul);
#else
  mpf_mul (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_mul */

#ifdef HAVE_mpf_mul_2exp
/* From `/usr/include/gmp.h:332'.  */
void chkr_stub_mpf_mul_2exp (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_mul_2exp"));
void
chkr_stub_mpf_mul_2exp (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_mul_2exp);
#else
  mpf_mul_2exp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_mul_2exp */

#ifdef HAVE_mpf_mul_ui
/* From `/usr/include/gmp.h:333'.  */
void chkr_stub_mpf_mul_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_mul_ui"));
void
chkr_stub_mpf_mul_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_mul_ui);
#else
  mpf_mul_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_mul_ui */

#ifdef HAVE_mpf_neg
/* From `/usr/include/gmp.h:334'.  */
void chkr_stub_mpf_neg (mpf_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_neg"));
void
chkr_stub_mpf_neg (mpf_ptr arg0, mpf_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_neg);
#else
  mpf_neg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_neg */

#ifdef HAVE_mpf_random2
/* From `/usr/include/gmp.h:338'.  */
void chkr_stub_mpf_random2 (mpf_ptr arg0, mp_size_t arg1, mp_exp_t arg2) __asm__ (CHKR_PREFIX ("mpf_random2"));
void
chkr_stub_mpf_random2 (mpf_ptr arg0, mp_size_t arg1, mp_exp_t arg2)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_random2);
#else
  mpf_random2 (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_random2 */

#ifdef HAVE_mpf_reldiff
/* From `/usr/include/gmp.h:339'.  */
void chkr_stub_mpf_reldiff (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_reldiff"));
void
chkr_stub_mpf_reldiff (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_reldiff);
#else
  mpf_reldiff (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_reldiff */

#ifdef HAVE_mpf_set
/* From `/usr/include/gmp.h:340'.  */
void chkr_stub_mpf_set (mpf_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_set"));
void
chkr_stub_mpf_set (mpf_ptr arg0, mpf_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set);
#else
  mpf_set (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set */

#ifdef HAVE_mpf_set_d
/* From `/usr/include/gmp.h:341'.  */
void chkr_stub_mpf_set_d (mpf_ptr arg0, double arg1) __asm__ (CHKR_PREFIX ("mpf_set_d"));
void
chkr_stub_mpf_set_d (mpf_ptr arg0, double arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_d);
#else
  mpf_set_d (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_d */

#ifdef HAVE_mpf_set_default_prec
/* From `/usr/include/gmp.h:342'.  */
void chkr_stub_mpf_set_default_prec (long unsigned int arg0) __asm__ (CHKR_PREFIX ("mpf_set_default_prec"));
void
chkr_stub_mpf_set_default_prec (long unsigned int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (mpf_set_default_prec);
#else
  mpf_set_default_prec (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_default_prec */

#ifdef HAVE_mpf_set_prec
/* From `/usr/include/gmp.h:343'.  */
void chkr_stub_mpf_set_prec (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_set_prec"));
void
chkr_stub_mpf_set_prec (mpf_ptr arg0, long unsigned int arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_prec);
#else
  mpf_set_prec (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_prec */

#ifdef HAVE_mpf_set_prec_raw
/* From `/usr/include/gmp.h:344'.  */
void chkr_stub_mpf_set_prec_raw (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_set_prec_raw"));
void
chkr_stub_mpf_set_prec_raw (mpf_ptr arg0, long unsigned int arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_prec_raw);
#else
  mpf_set_prec_raw (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_prec_raw */

#ifdef HAVE_mpf_set_q
/* From `/usr/include/gmp.h:345'.  */
void chkr_stub_mpf_set_q (mpf_ptr arg0, mpq_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_set_q"));
void
chkr_stub_mpf_set_q (mpf_ptr arg0, mpq_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_q);
#else
  mpf_set_q (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_q */

#ifdef HAVE_mpf_set_si
/* From `/usr/include/gmp.h:346'.  */
void chkr_stub_mpf_set_si (mpf_ptr arg0, long int arg1) __asm__ (CHKR_PREFIX ("mpf_set_si"));
void
chkr_stub_mpf_set_si (mpf_ptr arg0, long int arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_si);
#else
  mpf_set_si (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_si */

#ifdef HAVE_mpf_set_str
/* From `/usr/include/gmp.h:347'.  */
int chkr_stub_mpf_set_str (mpf_ptr arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpf_set_str"));
int
chkr_stub_mpf_set_str (mpf_ptr arg0, const char * arg1, int arg2)
{
  stubs_chkr_check_str (arg1, CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (mpf_set_str);
#else
  return mpf_set_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_str */

#ifdef HAVE_mpf_set_ui
/* From `/usr/include/gmp.h:348'.  */
void chkr_stub_mpf_set_ui (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_set_ui"));
void
chkr_stub_mpf_set_ui (mpf_ptr arg0, long unsigned int arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_ui);
#else
  mpf_set_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_ui */

#ifdef HAVE_mpf_set_z
/* From `/usr/include/gmp.h:349'.  */
void chkr_stub_mpf_set_z (mpf_ptr arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_set_z"));
void
chkr_stub_mpf_set_z (mpf_ptr arg0, mpz_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_set_z);
#else
  mpf_set_z (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_set_z */

#ifdef HAVE_mpf_size
/* From `/usr/include/gmp.h:350'.  */
size_t chkr_stub_mpf_size (mpf_srcptr arg0) __asm__ (CHKR_PREFIX ("mpf_size"));
size_t
chkr_stub_mpf_size (mpf_srcptr arg0)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_size);
#else
  return mpf_size (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_size */

#ifdef HAVE_mpf_sqrt
/* From `/usr/include/gmp.h:351'.  */
void chkr_stub_mpf_sqrt (mpf_ptr arg0, mpf_srcptr arg1) __asm__ (CHKR_PREFIX ("mpf_sqrt"));
void
chkr_stub_mpf_sqrt (mpf_ptr arg0, mpf_srcptr arg1)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_sqrt);
#else
  mpf_sqrt (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_sqrt */

#ifdef HAVE_mpf_sqrt_ui
/* From `/usr/include/gmp.h:352'.  */
void chkr_stub_mpf_sqrt_ui (mpf_ptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("mpf_sqrt_ui"));
void
chkr_stub_mpf_sqrt_ui (mpf_ptr arg0, long unsigned int arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_sqrt_ui);
#else
  mpf_sqrt_ui (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_sqrt_ui */

#ifdef HAVE_mpf_sub
/* From `/usr/include/gmp.h:353'.  */
void chkr_stub_mpf_sub (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_sub"));
void
chkr_stub_mpf_sub (mpf_ptr arg0, mpf_srcptr arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_sub);
#else
  mpf_sub (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_sub */

#ifdef HAVE_mpf_sub_ui
/* From `/usr/include/gmp.h:354'.  */
void chkr_stub_mpf_sub_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2) __asm__ (CHKR_PREFIX ("mpf_sub_ui"));
void
chkr_stub_mpf_sub_ui (mpf_ptr arg0, mpf_srcptr arg1, long unsigned int arg2)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_sub_ui);
#else
  mpf_sub_ui (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_sub_ui */

#ifdef HAVE_mpf_ui_div
/* From `/usr/include/gmp.h:355'.  */
void chkr_stub_mpf_ui_div (mpf_ptr arg0, long unsigned int arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_ui_div"));
void
chkr_stub_mpf_ui_div (mpf_ptr arg0, long unsigned int arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_ui_div);
#else
  mpf_ui_div (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_ui_div */

#ifdef HAVE_mpf_ui_sub
/* From `/usr/include/gmp.h:356'.  */
void chkr_stub_mpf_ui_sub (mpf_ptr arg0, long unsigned int arg1, mpf_srcptr arg2) __asm__ (CHKR_PREFIX ("mpf_ui_sub"));
void
chkr_stub_mpf_ui_sub (mpf_ptr arg0, long unsigned int arg1, mpf_srcptr arg2)
{
  rw (0);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_ui_sub);
#else
  mpf_ui_sub (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_ui_sub */

#ifdef HAVE___mpn_add
/* From `/usr/include/gmp.h:401'.  */
mp_limb_t chkr_stub___mpn_add (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4) __asm__ (CHKR_PREFIX ("__mpn_add"));
mp_limb_t
chkr_stub___mpn_add (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4)
{
  rw (0);
  ro (1);
  ro (3);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_add);
#else
  return __mpn_add (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_add */

#ifdef HAVE___mpn_add_1
/* From `/usr/include/gmp.h:402'.  */
mp_limb_t chkr_stub___mpn_add_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_add_1"));
mp_limb_t
chkr_stub___mpn_add_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_add_1);
#else
  return __mpn_add_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_add_1 */

#ifdef HAVE___mpn_add_n
/* From `/usr/include/gmp.h:403'.  */
mp_limb_t chkr_stub___mpn_add_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3) __asm__ (CHKR_PREFIX ("__mpn_add_n"));
mp_limb_t
chkr_stub___mpn_add_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_add_n);
#else
  return __mpn_add_n (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_add_n */

#ifdef HAVE___mpn_addmul_1
/* From `/usr/include/gmp.h:404'.  */
mp_limb_t chkr_stub___mpn_addmul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_addmul_1"));
mp_limb_t
chkr_stub___mpn_addmul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_addmul_1);
#else
  return __mpn_addmul_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_addmul_1 */

#ifdef HAVE___mpn_bdivmod
/* From `/usr/include/gmp.h:405'.  */
mp_limb_t chkr_stub___mpn_bdivmod (mp_ptr arg0, mp_ptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4, long unsigned int arg5) __asm__ (CHKR_PREFIX ("__mpn_bdivmod"));
mp_limb_t
chkr_stub___mpn_bdivmod (mp_ptr arg0, mp_ptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4, long unsigned int arg5)
{
  rw (0);
  rw (1);
  ro (3);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_bdivmod);
#else
  return __mpn_bdivmod (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_bdivmod */

#ifdef HAVE___mpn_cmp
/* From `/usr/include/gmp.h:406'.  */
int chkr_stub___mpn_cmp (mp_srcptr arg0, mp_srcptr arg1, mp_size_t arg2) __asm__ (CHKR_PREFIX ("__mpn_cmp"));
int
chkr_stub___mpn_cmp (mp_srcptr arg0, mp_srcptr arg1, mp_size_t arg2)
{
  ro (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_cmp);
#else
  return __mpn_cmp (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_cmp */

#ifdef HAVE___mpn_divmod_1
/* From `/usr/include/gmp.h:407'.  */
mp_limb_t chkr_stub___mpn_divmod_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_divmod_1"));
mp_limb_t
chkr_stub___mpn_divmod_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (1);

#if USE_BI_JUMP
  __builtin_jump (__mpn_divmod_1);
#else
  return __mpn_divmod_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_divmod_1 */

#ifdef HAVE___mpn_divrem
/* From `/usr/include/gmp.h:408'.  */
mp_limb_t chkr_stub___mpn_divrem (mp_ptr arg0, mp_size_t arg1, mp_ptr arg2, mp_size_t arg3, mp_srcptr arg4, mp_size_t arg5) __asm__ (CHKR_PREFIX ("__mpn_divrem"));
mp_limb_t
chkr_stub___mpn_divrem (mp_ptr arg0, mp_size_t arg1, mp_ptr arg2, mp_size_t arg3, mp_srcptr arg4, mp_size_t arg5)
{
  rw (0);
  rw (2);
  ro (4);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_divrem);
#else
  return __mpn_divrem (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_divrem */

#ifdef HAVE___mpn_divrem_1
/* From `/usr/include/gmp.h:409'.  */
mp_limb_t chkr_stub___mpn_divrem_1 (mp_ptr arg0, mp_size_t arg1, mp_srcptr arg2, mp_size_t arg3, mp_limb_t arg4) __asm__ (CHKR_PREFIX ("__mpn_divrem_1"));
mp_limb_t
chkr_stub___mpn_divrem_1 (mp_ptr arg0, mp_size_t arg1, mp_srcptr arg2, mp_size_t arg3, mp_limb_t arg4)
{
  rw (0);
  ro (2);

#if USE_BI_JUMP
  __builtin_jump (__mpn_divrem_1);
#else
  return __mpn_divrem_1 (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_divrem_1 */

#ifdef HAVE___mpn_dump
/* From `/usr/include/gmp.h:410'.  */
void chkr_stub___mpn_dump (mp_srcptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("__mpn_dump"));
void
chkr_stub___mpn_dump (mp_srcptr arg0, mp_size_t arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_dump);
#else
  __mpn_dump (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_dump */

#ifdef HAVE___mpn_gcd
/* From `/usr/include/gmp.h:411'.  */
mp_size_t chkr_stub___mpn_gcd (mp_ptr arg0, mp_ptr arg1, mp_size_t arg2, mp_ptr arg3, mp_size_t arg4) __asm__ (CHKR_PREFIX ("__mpn_gcd"));
mp_size_t
chkr_stub___mpn_gcd (mp_ptr arg0, mp_ptr arg1, mp_size_t arg2, mp_ptr arg3, mp_size_t arg4)
{
  rw (0);
  rw (1);
  rw (3);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_gcd);
#else
  return __mpn_gcd (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_gcd */

#ifdef HAVE___mpn_gcd_1
/* From `/usr/include/gmp.h:412'.  */
mp_limb_t chkr_stub___mpn_gcd_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2) __asm__ (CHKR_PREFIX ("__mpn_gcd_1"));
mp_limb_t
chkr_stub___mpn_gcd_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_gcd_1);
#else
  return __mpn_gcd_1 (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_gcd_1 */

#ifdef HAVE___mpn_gcdext
/* From `/usr/include/gmp.h:413'.  */
mp_size_t chkr_stub___mpn_gcdext (mp_ptr arg0, mp_ptr arg1, mp_ptr arg2, mp_size_t arg3, mp_ptr arg4, mp_size_t arg5) __asm__ (CHKR_PREFIX ("__mpn_gcdext"));
mp_size_t
chkr_stub___mpn_gcdext (mp_ptr arg0, mp_ptr arg1, mp_ptr arg2, mp_size_t arg3, mp_ptr arg4, mp_size_t arg5)
{
  rw (0);
  rw (1);
  rw (2);
  rw (4);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_gcdext);
#else
  return __mpn_gcdext (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_gcdext */

#ifdef HAVE___mpn_get_str
/* From `/usr/include/gmp.h:414'.  */
size_t chkr_stub___mpn_get_str (unsigned char * arg0, int arg1, mp_ptr arg2, mp_size_t arg3) __asm__ (CHKR_PREFIX ("__mpn_get_str"));
size_t
chkr_stub___mpn_get_str (unsigned char * arg0, int arg1, mp_ptr arg2, mp_size_t arg3)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "arg0");
  rw (2);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_get_str);
#else
  return __mpn_get_str (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_get_str */

#ifdef HAVE___mpn_hamdist
/* From `/usr/include/gmp.h:415'.  */
long unsigned int chkr_stub___mpn_hamdist (mp_srcptr arg0, mp_srcptr arg1, mp_size_t arg2) __asm__ (CHKR_PREFIX ("__mpn_hamdist"));
long unsigned int
chkr_stub___mpn_hamdist (mp_srcptr arg0, mp_srcptr arg1, mp_size_t arg2)
{
  ro (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_hamdist);
#else
  return __mpn_hamdist (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_hamdist */

#ifdef HAVE___mpn_lshift
/* From `/usr/include/gmp.h:416'.  */
mp_limb_t chkr_stub___mpn_lshift (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, unsigned int arg3) __asm__ (CHKR_PREFIX ("__mpn_lshift"));
mp_limb_t
chkr_stub___mpn_lshift (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, unsigned int arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_lshift);
#else
  return __mpn_lshift (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_lshift */

#ifdef HAVE___mpn_mod_1
/* From `/usr/include/gmp.h:417'.  */
mp_limb_t chkr_stub___mpn_mod_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2) __asm__ (CHKR_PREFIX ("__mpn_mod_1"));
mp_limb_t
chkr_stub___mpn_mod_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_mod_1);
#else
  return __mpn_mod_1 (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_mod_1 */

#ifdef HAVE___mpn_mul
/* From `/usr/include/gmp.h:418'.  */
mp_limb_t chkr_stub___mpn_mul (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4) __asm__ (CHKR_PREFIX ("__mpn_mul"));
mp_limb_t
chkr_stub___mpn_mul (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4)
{
  rw (0);
  ro (1);
  ro (3);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_mul);
#else
  return __mpn_mul (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_mul */

#ifdef HAVE___mpn_mul_1
/* From `/usr/include/gmp.h:419'.  */
mp_limb_t chkr_stub___mpn_mul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_mul_1"));
mp_limb_t
chkr_stub___mpn_mul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_mul_1);
#else
  return __mpn_mul_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_mul_1 */

#ifdef HAVE___mpn_mul_n
/* From `/usr/include/gmp.h:420'.  */
void chkr_stub___mpn_mul_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3) __asm__ (CHKR_PREFIX ("__mpn_mul_n"));
void
chkr_stub___mpn_mul_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_mul_n);
#else
  __mpn_mul_n (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_mul_n */

#ifdef HAVE___mpn_perfect_square_p
/* From `/usr/include/gmp.h:421'.  */
int chkr_stub___mpn_perfect_square_p (mp_srcptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("__mpn_perfect_square_p"));
int
chkr_stub___mpn_perfect_square_p (mp_srcptr arg0, mp_size_t arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_perfect_square_p);
#else
  return __mpn_perfect_square_p (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_perfect_square_p */

#ifdef HAVE___mpn_popcount
/* From `/usr/include/gmp.h:422'.  */
long unsigned int chkr_stub___mpn_popcount (mp_srcptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("__mpn_popcount"));
long unsigned int
chkr_stub___mpn_popcount (mp_srcptr arg0, mp_size_t arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_popcount);
#else
  return __mpn_popcount (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_popcount */

#ifdef HAVE___mpn_preinv_mod_1
/* From `/usr/include/gmp.h:423'.  */
mp_limb_t chkr_stub___mpn_preinv_mod_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_preinv_mod_1"));
mp_limb_t
chkr_stub___mpn_preinv_mod_1 (mp_srcptr arg0, mp_size_t arg1, mp_limb_t arg2, mp_limb_t arg3)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_preinv_mod_1);
#else
  return __mpn_preinv_mod_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_preinv_mod_1 */

#ifdef HAVE___mpn_random2
/* From `/usr/include/gmp.h:424'.  */
void chkr_stub___mpn_random2 (mp_ptr arg0, mp_size_t arg1) __asm__ (CHKR_PREFIX ("__mpn_random2"));
void
chkr_stub___mpn_random2 (mp_ptr arg0, mp_size_t arg1)
{
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_random2);
#else
  __mpn_random2 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_random2 */

#ifdef HAVE___mpn_rshift
/* From `/usr/include/gmp.h:425'.  */
mp_limb_t chkr_stub___mpn_rshift (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, unsigned int arg3) __asm__ (CHKR_PREFIX ("__mpn_rshift"));
mp_limb_t
chkr_stub___mpn_rshift (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, unsigned int arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_rshift);
#else
  return __mpn_rshift (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_rshift */

#ifdef HAVE___mpn_scan0
/* From `/usr/include/gmp.h:426'.  */
long unsigned int chkr_stub___mpn_scan0 (mp_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("__mpn_scan0"));
long unsigned int
chkr_stub___mpn_scan0 (mp_srcptr arg0, long unsigned int arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_scan0);
#else
  return __mpn_scan0 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_scan0 */

#ifdef HAVE___mpn_scan1
/* From `/usr/include/gmp.h:427'.  */
long unsigned int chkr_stub___mpn_scan1 (mp_srcptr arg0, long unsigned int arg1) __asm__ (CHKR_PREFIX ("__mpn_scan1"));
long unsigned int
chkr_stub___mpn_scan1 (mp_srcptr arg0, long unsigned int arg1)
{
  ro (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_scan1);
#else
  return __mpn_scan1 (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_scan1 */

#ifdef HAVE___mpn_set_str
/* From `/usr/include/gmp.h:428'.  */
mp_size_t chkr_stub___mpn_set_str (mp_ptr arg0, const unsigned char * arg1, size_t arg2, int arg3) __asm__ (CHKR_PREFIX ("__mpn_set_str"));
mp_size_t
chkr_stub___mpn_set_str (mp_ptr arg0, const unsigned char * arg1, size_t arg2, int arg3)
{
  stubs_chkr_check_str (arg1, CHKR_RO, "arg1");
  rw (0);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_set_str);
#else
  return __mpn_set_str (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_set_str */

#ifdef HAVE___mpn_sqrtrem
/* From `/usr/include/gmp.h:429'.  */
mp_size_t chkr_stub___mpn_sqrtrem (mp_ptr arg0, mp_ptr arg1, mp_srcptr arg2, mp_size_t arg3) __asm__ (CHKR_PREFIX ("__mpn_sqrtrem"));
mp_size_t
chkr_stub___mpn_sqrtrem (mp_ptr arg0, mp_ptr arg1, mp_srcptr arg2, mp_size_t arg3)
{
  rw (0);
  rw (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_sqrtrem);
#else
  return __mpn_sqrtrem (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_sqrtrem */

#ifdef HAVE___mpn_sub
/* From `/usr/include/gmp.h:430'.  */
mp_limb_t chkr_stub___mpn_sub (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4) __asm__ (CHKR_PREFIX ("__mpn_sub"));
mp_limb_t
chkr_stub___mpn_sub (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_srcptr arg3, mp_size_t arg4)
{
  rw (0);
  ro (1);
  ro (3);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_sub);
#else
  return __mpn_sub (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_sub */

#ifdef HAVE___mpn_sub_1
/* From `/usr/include/gmp.h:431'.  */
mp_limb_t chkr_stub___mpn_sub_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_sub_1"));
mp_limb_t
chkr_stub___mpn_sub_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_sub_1);
#else
  return __mpn_sub_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_sub_1 */

#ifdef HAVE___mpn_sub_n
/* From `/usr/include/gmp.h:432'.  */
mp_limb_t chkr_stub___mpn_sub_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3) __asm__ (CHKR_PREFIX ("__mpn_sub_n"));
mp_limb_t
chkr_stub___mpn_sub_n (mp_ptr arg0, mp_srcptr arg1, mp_srcptr arg2, mp_size_t arg3)
{
  rw (0);
  ro (1);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_sub_n);
#else
  return __mpn_sub_n (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_sub_n */

#ifdef HAVE___mpn_submul_1
/* From `/usr/include/gmp.h:433'.  */
mp_limb_t chkr_stub___mpn_submul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3) __asm__ (CHKR_PREFIX ("__mpn_submul_1"));
mp_limb_t
chkr_stub___mpn_submul_1 (mp_ptr arg0, mp_srcptr arg1, mp_size_t arg2, mp_limb_t arg3)
{
  rw (0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (__mpn_submul_1);
#else
  return __mpn_submul_1 (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___mpn_submul_1 */

/* /usr/include/gmp.h:223:NC */ extern size_t mpz_inp_binary (mpz_ptr, FILE *);
#ifdef HAVE_mpz_inp_raw
/* From `/usr/include/gmp.h:224'.  */
size_t chkr_stub_mpz_inp_raw (mpz_ptr arg0, FILE * arg1) __asm__ (CHKR_PREFIX ("mpz_inp_raw"));
size_t
chkr_stub_mpz_inp_raw (mpz_ptr arg0, FILE * arg1)
{
  rw (0);
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (mpz_inp_raw);
#else
  return mpz_inp_raw (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_inp_raw */

#ifdef HAVE_mpz_inp_str
/* From `/usr/include/gmp.h:225'.  */
size_t chkr_stub_mpz_inp_str (mpz_ptr arg0, FILE * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpz_inp_str"));
size_t
chkr_stub_mpz_inp_str (mpz_ptr arg0, FILE * arg1, int arg2)
{
  rw (0);
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (mpz_inp_str);
#else
  return mpz_inp_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_inp_str */

#ifdef HAVE_mpz_out_binary
/* From `/usr/include/gmp.h:242'.  */
size_t chkr_stub_mpz_out_binary (FILE * arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_out_binary"));
size_t
chkr_stub_mpz_out_binary (FILE * arg0, mpz_srcptr arg1)
{
  CHKR_CHECK_STREAM (arg0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpz_out_binary);
#else
  return mpz_out_binary (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_out_binary */

#ifdef HAVE_mpz_out_raw
/* From `/usr/include/gmp.h:243'.  */
size_t chkr_stub_mpz_out_raw (FILE * arg0, mpz_srcptr arg1) __asm__ (CHKR_PREFIX ("mpz_out_raw"));
size_t
chkr_stub_mpz_out_raw (FILE * arg0, mpz_srcptr arg1)
{
  CHKR_CHECK_STREAM (arg0);
  ro (1);
  
#if USE_BI_JUMP
  __builtin_jump (mpz_out_raw);
#else
  return mpz_out_raw (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_out_raw */

#ifdef HAVE_mpz_out_str
/* From `/usr/include/gmp.h:244'.  */
size_t chkr_stub_mpz_out_str (FILE * arg0, int arg1, mpz_srcptr arg2) __asm__ (CHKR_PREFIX ("mpz_out_str"));
size_t
chkr_stub_mpz_out_str (FILE * arg0, int arg1, mpz_srcptr arg2)
{
  CHKR_CHECK_STREAM (arg0);
  ro (2);
  
#if USE_BI_JUMP
  __builtin_jump (mpz_out_str);
#else
  return mpz_out_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpz_out_str */

#ifdef HAVE_mpf_inp_str
/* From `/usr/include/gmp.h:324'.  */
size_t chkr_stub_mpf_inp_str (mpf_ptr arg0, FILE * arg1, int arg2) __asm__ (CHKR_PREFIX ("mpf_inp_str"));
size_t
chkr_stub_mpf_inp_str (mpf_ptr arg0, FILE * arg1, int arg2)
{
  rw (0);
  CHKR_CHECK_STREAM (arg1);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_inp_str);
#else
  return mpf_inp_str (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_inp_str */

#ifdef HAVE_mpf_out_str
/* From `/usr/include/gmp.h:336'.  */
size_t chkr_stub_mpf_out_str (FILE * arg0, int arg1, size_t arg2, mpf_srcptr arg3) __asm__ (CHKR_PREFIX ("mpf_out_str"));
size_t
chkr_stub_mpf_out_str (FILE * arg0, int arg1, size_t arg2, mpf_srcptr arg3)
{
  CHKR_CHECK_STREAM (arg0);
  ro (3);
  
#if USE_BI_JUMP
  __builtin_jump (mpf_out_str);
#else
  return mpf_out_str (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mpf_out_str */

