/* Checker stubs for functions defined in ioctl.h
   Copyright 1995, 1996 Tristan Gingold
		  Written December 1995 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

 The author may be reached by US/French mail:
		Tristan Gingold 
		8 rue Parmentier
		F-91120 PALAISEAU
		FRANCE
*/
#include "available-stubs.h"

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#include <termio.h>
#include "checker_api.h"

static void
chkr_check_struct_termio (struct termio *buf, int right)
{
  stubs_chkr_check_addr (&(buf->c_iflag), sizeof (buf->c_iflag), right,
			 "c_iflag");
  stubs_chkr_check_addr (&(buf->c_oflag), sizeof (buf->c_oflag), right,
			 "c_oflag");
  stubs_chkr_check_addr (&(buf->c_cflag), sizeof (buf->c_cflag), right,
			 "c_cflag");
  stubs_chkr_check_addr (&(buf->c_lflag), sizeof (buf->c_lflag), right,
			 "c_lflag");
  stubs_chkr_check_addr (&(buf->c_line), sizeof (buf->c_line), right,
			 "c_line");
  stubs_chkr_check_addr (&(buf->c_cc), NCC, right, "c_cc");
}
  
int chkr_stub_ioctl (int fd, int req, char *arg)
  __asm__ (CHKR_PREFIX ("ioctl"));
int
chkr_stub_ioctl (int fd, int req, char *arg)
{
  fd_used_by_prog (fd);

  switch (req)
    {
    case TIOCGWINSZ:
      stubs_chkr_check_addr ((PTR) arg, sizeof (struct winsize), CHKR_WO,
			     "arg");
      break;
    case TIOCSWINSZ:
      stubs_chkr_check_addr ((PTR) arg, sizeof (struct winsize), CHKR_RO,
			     "arg");
      break;
#ifdef FIONREAD
    case FIONREAD:
      stubs_chkr_check_addr ((PTR) arg, sizeof (int), CHKR_WO, "arg");
      break;
#endif /* FIONREAD */      
    case TCGETA:
      chkr_check_struct_termio ((struct termio *) arg, CHKR_WO);
      break;
    case TCSETA:
      chkr_check_struct_termio ((struct termio *) arg, CHKR_RO);
      break;
#ifdef TIOCEXCL
    case TIOCEXCL:
      break;
#endif
    default:
      chkr_header ("Ioctl 0x%x not yet implemented.\n", req);
      chkr_disp_call_chain ();
    }
  return ioctl (fd, req, arg);
}

#endif /* HAVE_SYS_IOCTL_H */
