#include "available-stubs.h"

#include <pthread.h>
#include "checker_api.h"

#ifdef HAVE_pthread_create
/* From `/usr/include/pthread.h:159'.  */
int chkr_stub_pthread_create (pthread_t * arg0, const pthread_attr_t * arg1, void *(*) (void *) arg2, void * arg3) __asm__ (CHKR_PREFIX ("pthread_create"));
int
chkr_stub_pthread_create (pthread_t * arg0, const pthread_attr_t * arg1, void *(*) (void *) arg2, void * arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_attr_t), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (void), CHKR_XX, "arg3");
#if USE_BI_JUMP
  __builtin_jump (pthread_create);
#else
  return pthread_create (arg0, arg1, arg2, arg3);
  {
    int res;
    res = pthread_create (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_create */

#ifdef HAVE_pthread_self
/* From `/usr/include/pthread.h:162'.  */
pthread_t chkr_stub_pthread_self (void)
     __asm__ (CHKR_PREFIX ("pthread_self"));
pthread_t
chkr_stub_pthread_self (void )
{
#if USE_BI_JUMP
  __builtin_jump (pthread_self);
#else
  return pthread_self ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_self */

#ifdef HAVE_pthread_equal
/* From `/usr/include/pthread.h:165'.  */
int chkr_stub_pthread_equal (pthread_t t1, pthread_t t2)
     __asm__ (CHKR_PREFIX ("pthread_equal"));
int
chkr_stub_pthread_equal (pthread_t t1, pthread_t t2)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_equal);
#else
  return pthread_equal (t1, t2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_equal */

#ifdef HAVE_pthread_exit
/* From `/usr/include/pthread.h:168'.  */
void chkr_stub_pthread_exit (void * arg0) __asm__ (CHKR_PREFIX ("pthread_exit"));
void
chkr_stub_pthread_exit (void * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (void), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_exit);
#else
  pthread_exit (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_exit */

#ifdef HAVE_pthread_join
/* From `/usr/include/pthread.h:173'.  */
int chkr_stub_pthread_join (pthread_t arg0, void ** arg1) __asm__ (CHKR_PREFIX ("pthread_join"));
int
chkr_stub_pthread_join (pthread_t arg0, void ** arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (void *), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_join);
#else
  return pthread_join (arg0, arg1);
  {
    int res;
    res = pthread_join (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_join */

#ifdef HAVE_pthread_detach
/* From `/usr/include/pthread.h:179'.  */
int chkr_stub_pthread_detach (pthread_t arg0) __asm__ (CHKR_PREFIX ("pthread_detach"));
int
chkr_stub_pthread_detach (pthread_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_detach);
#else
  return pthread_detach (arg0);
  {
    int res;
    res = pthread_detach (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_detach */

#ifdef HAVE_pthread_attr_init
/* From `/usr/include/pthread.h:186'.  */
int chkr_stub_pthread_attr_init (pthread_attr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_attr_init"));
int
chkr_stub_pthread_attr_init (pthread_attr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_init);
#else
  return pthread_attr_init (arg0);
  {
    int res;
    res = pthread_attr_init (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_init */

#ifdef HAVE_pthread_attr_destroy
/* From `/usr/include/pthread.h:189'.  */
int chkr_stub_pthread_attr_destroy (pthread_attr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_attr_destroy"));
int
chkr_stub_pthread_attr_destroy (pthread_attr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_destroy);
#else
  return pthread_attr_destroy (arg0);
  {
    int res;
    res = pthread_attr_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_destroy */

#ifdef HAVE_pthread_attr_setdetachstate
/* From `/usr/include/pthread.h:193'.  */
int chkr_stub_pthread_attr_setdetachstate (pthread_attr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_attr_setdetachstate"));
int
chkr_stub_pthread_attr_setdetachstate (pthread_attr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_setdetachstate);
#else
  return pthread_attr_setdetachstate (arg0, arg1);
  {
    int res;
    res = pthread_attr_setdetachstate (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_setdetachstate */

#ifdef HAVE_pthread_attr_getdetachstate
/* From `/usr/include/pthread.h:197'.  */
int chkr_stub_pthread_attr_getdetachstate (const pthread_attr_t * arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_getdetachstate"));
int
chkr_stub_pthread_attr_getdetachstate (const pthread_attr_t * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_getdetachstate);
#else
  return pthread_attr_getdetachstate (arg0, arg1);
  {
    int res;
    res = pthread_attr_getdetachstate (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_getdetachstate */

#ifdef HAVE_pthread_attr_setschedparam
/* From `/usr/include/pthread.h:201'.  */
int chkr_stub_pthread_attr_setschedparam (pthread_attr_t * arg0, const struct sched_param * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_setschedparam"));
int
chkr_stub_pthread_attr_setschedparam (pthread_attr_t * arg0, const struct sched_param * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct sched_param), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_setschedparam);
#else
  return pthread_attr_setschedparam (arg0, arg1);
  {
    int res;
    res = pthread_attr_setschedparam (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_setschedparam */

#ifdef HAVE_pthread_attr_getschedparam
/* From `/usr/include/pthread.h:205'.  */
int chkr_stub_pthread_attr_getschedparam (const pthread_attr_t * arg0, struct sched_param * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_getschedparam"));
int
chkr_stub_pthread_attr_getschedparam (const pthread_attr_t * arg0, struct sched_param * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct sched_param), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_getschedparam);
#else
  return pthread_attr_getschedparam (arg0, arg1);
  {
    int res;
    res = pthread_attr_getschedparam (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_getschedparam */

#ifdef HAVE_pthread_attr_setschedpolicy
/* From `/usr/include/pthread.h:209'.  */
int chkr_stub_pthread_attr_setschedpolicy (pthread_attr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_attr_setschedpolicy"));
int
chkr_stub_pthread_attr_setschedpolicy (pthread_attr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_setschedpolicy);
#else
  return pthread_attr_setschedpolicy (arg0, arg1);
  {
    int res;
    res = pthread_attr_setschedpolicy (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_setschedpolicy */

#ifdef HAVE_pthread_attr_getschedpolicy
/* From `/usr/include/pthread.h:213'.  */
int chkr_stub_pthread_attr_getschedpolicy (const pthread_attr_t * arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_getschedpolicy"));
int
chkr_stub_pthread_attr_getschedpolicy (const pthread_attr_t * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_getschedpolicy);
#else
  return pthread_attr_getschedpolicy (arg0, arg1);
  {
    int res;
    res = pthread_attr_getschedpolicy (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_getschedpolicy */

#ifdef HAVE_pthread_attr_setinheritsched
/* From `/usr/include/pthread.h:217'.  */
int chkr_stub_pthread_attr_setinheritsched (pthread_attr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_attr_setinheritsched"));
int
chkr_stub_pthread_attr_setinheritsched (pthread_attr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_setinheritsched);
#else
  return pthread_attr_setinheritsched (arg0, arg1);
  {
    int res;
    res = pthread_attr_setinheritsched (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_setinheritsched */

#ifdef HAVE_pthread_attr_getinheritsched
/* From `/usr/include/pthread.h:221'.  */
int chkr_stub_pthread_attr_getinheritsched (const pthread_attr_t * arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_getinheritsched"));
int
chkr_stub_pthread_attr_getinheritsched (const pthread_attr_t * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_getinheritsched);
#else
  return pthread_attr_getinheritsched (arg0, arg1);
  {
    int res;
    res = pthread_attr_getinheritsched (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_getinheritsched */

#ifdef HAVE_pthread_attr_setscope
/* From `/usr/include/pthread.h:224'.  */
int chkr_stub_pthread_attr_setscope (pthread_attr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_attr_setscope"));
int
chkr_stub_pthread_attr_setscope (pthread_attr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_setscope);
#else
  return pthread_attr_setscope (arg0, arg1);
  {
    int res;
    res = pthread_attr_setscope (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_setscope */

#ifdef HAVE_pthread_attr_getscope
/* From `/usr/include/pthread.h:228'.  */
int chkr_stub_pthread_attr_getscope (const pthread_attr_t * arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_attr_getscope"));
int
chkr_stub_pthread_attr_getscope (const pthread_attr_t * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_attr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_attr_getscope);
#else
  return pthread_attr_getscope (arg0, arg1);
  {
    int res;
    res = pthread_attr_getscope (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_attr_getscope */

#ifdef HAVE_pthread_setschedparam
/* From `/usr/include/pthread.h:235'.  */
int chkr_stub_pthread_setschedparam (pthread_t arg0, int arg1, const struct sched_param * arg2) __asm__ (CHKR_PREFIX ("pthread_setschedparam"));
int
chkr_stub_pthread_setschedparam (pthread_t arg0, int arg1, const struct sched_param * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg2, sizeof (struct sched_param), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (pthread_setschedparam);
#else
  return pthread_setschedparam (arg0, arg1, arg2);
  {
    int res;
    res = pthread_setschedparam (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_setschedparam */

#ifdef HAVE_pthread_getschedparam
/* From `/usr/include/pthread.h:240'.  */
int chkr_stub_pthread_getschedparam (pthread_t arg0, int * arg1, struct sched_param * arg2) __asm__ (CHKR_PREFIX ("pthread_getschedparam"));
int
chkr_stub_pthread_getschedparam (pthread_t arg0, int * arg1, struct sched_param * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (struct sched_param), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (pthread_getschedparam);
#else
  return pthread_getschedparam (arg0, arg1, arg2);
  {
    int res;
    res = pthread_getschedparam (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_getschedparam */

#ifdef HAVE___pthread_mutex_init
/* From `/usr/include/pthread.h:248'.  */
int chkr_stub___pthread_mutex_init (pthread_mutex_t * arg0, const pthread_mutexattr_t * arg1) __asm__ (CHKR_PREFIX ("__pthread_mutex_init"));
int
chkr_stub___pthread_mutex_init (pthread_mutex_t * arg0, const pthread_mutexattr_t * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_mutexattr_t), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutex_init);
#else
  return __pthread_mutex_init (arg0, arg1);
  {
    int res;
    res = __pthread_mutex_init (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutex_init */

#ifdef HAVE_pthread_mutex_init
/* From `/usr/include/pthread.h:250'.  */
int chkr_stub_pthread_mutex_init (pthread_mutex_t * arg0, const pthread_mutexattr_t * arg1) __asm__ (CHKR_PREFIX ("pthread_mutex_init"));
int
chkr_stub_pthread_mutex_init (pthread_mutex_t * arg0, const pthread_mutexattr_t * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_mutexattr_t), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutex_init);
#else
  return pthread_mutex_init (arg0, arg1);
  {
    int res;
    res = pthread_mutex_init (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutex_init */

#ifdef HAVE___pthread_mutex_destroy
/* From `/usr/include/pthread.h:253'.  */
int chkr_stub___pthread_mutex_destroy (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutex_destroy"));
int
chkr_stub___pthread_mutex_destroy (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutex_destroy);
#else
  return __pthread_mutex_destroy (arg0);
  {
    int res;
    res = __pthread_mutex_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutex_destroy */

#ifdef HAVE_pthread_mutex_destroy
/* From `/usr/include/pthread.h:254'.  */
int chkr_stub_pthread_mutex_destroy (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("pthread_mutex_destroy"));
int
chkr_stub_pthread_mutex_destroy (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutex_destroy);
#else
  return pthread_mutex_destroy (arg0);
  {
    int res;
    res = pthread_mutex_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutex_destroy */

#ifdef HAVE___pthread_mutex_trylock
/* From `/usr/include/pthread.h:257'.  */
int chkr_stub___pthread_mutex_trylock (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutex_trylock"));
int
chkr_stub___pthread_mutex_trylock (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutex_trylock);
#else
  return __pthread_mutex_trylock (arg0);
  {
    int res;
    res = __pthread_mutex_trylock (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutex_trylock */

#ifdef HAVE_pthread_mutex_trylock
/* From `/usr/include/pthread.h:258'.  */
int chkr_stub_pthread_mutex_trylock (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("pthread_mutex_trylock"));
int
chkr_stub_pthread_mutex_trylock (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutex_trylock);
#else
  return pthread_mutex_trylock (arg0);
  {
    int res;
    res = pthread_mutex_trylock (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutex_trylock */

#ifdef HAVE___pthread_mutex_lock
/* From `/usr/include/pthread.h:261'.  */
int chkr_stub___pthread_mutex_lock (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutex_lock"));
int
chkr_stub___pthread_mutex_lock (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutex_lock);
#else
  return __pthread_mutex_lock (arg0);
  {
    int res;
    res = __pthread_mutex_lock (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutex_lock */

#ifdef HAVE_pthread_mutex_lock
/* From `/usr/include/pthread.h:262'.  */
int chkr_stub_pthread_mutex_lock (pthread_mutex_t *mutex)
     __asm__ (CHKR_PREFIX ("pthread_mutex_lock"));
int
chkr_stub_pthread_mutex_lock (pthread_mutex_t *mutex)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (mutex, sizeof (pthread_mutex_t), CHKR_TW, "mutex");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutex_lock);
#else
  return pthread_mutex_lock (mutex);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutex_lock */

#ifdef HAVE___pthread_mutex_unlock
/* From `/usr/include/pthread.h:265'.  */
int chkr_stub___pthread_mutex_unlock (pthread_mutex_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutex_unlock"));
int
chkr_stub___pthread_mutex_unlock (pthread_mutex_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutex_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutex_unlock);
#else
  return __pthread_mutex_unlock (arg0);
  {
    int res;
    res = __pthread_mutex_unlock (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutex_unlock */

#ifdef HAVE_pthread_mutex_unlock
/* From `/usr/include/pthread.h:266'.  */
int chkr_stub_pthread_mutex_unlock (pthread_mutex_t *mutex)
     __asm__ (CHKR_PREFIX ("pthread_mutex_unlock"));
int
chkr_stub_pthread_mutex_unlock (pthread_mutex_t *mutex)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (mutex, sizeof (pthread_mutex_t), CHKR_TW, "mutex");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutex_unlock);
#else
  return pthread_mutex_unlock (mutex);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutex_unlock */

#ifdef HAVE___pthread_mutexattr_init
/* From `/usr/include/pthread.h:273'.  */
int chkr_stub___pthread_mutexattr_init (pthread_mutexattr_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutexattr_init"));
int
chkr_stub___pthread_mutexattr_init (pthread_mutexattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutexattr_init);
#else
  return __pthread_mutexattr_init (arg0);
  {
    int res;
    res = __pthread_mutexattr_init (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutexattr_init */

#ifdef HAVE_pthread_mutexattr_init
/* From `/usr/include/pthread.h:274'.  */
int chkr_stub_pthread_mutexattr_init (pthread_mutexattr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_mutexattr_init"));
int
chkr_stub_pthread_mutexattr_init (pthread_mutexattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutexattr_init);
#else
  return pthread_mutexattr_init (arg0);
  {
    int res;
    res = pthread_mutexattr_init (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutexattr_init */

#ifdef HAVE___pthread_mutexattr_destroy
/* From `/usr/include/pthread.h:277'.  */
int chkr_stub___pthread_mutexattr_destroy (pthread_mutexattr_t * arg0) __asm__ (CHKR_PREFIX ("__pthread_mutexattr_destroy"));
int
chkr_stub___pthread_mutexattr_destroy (pthread_mutexattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutexattr_destroy);
#else
  return __pthread_mutexattr_destroy (arg0);
  {
    int res;
    res = __pthread_mutexattr_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutexattr_destroy */

#ifdef HAVE_pthread_mutexattr_destroy
/* From `/usr/include/pthread.h:278'.  */
int chkr_stub_pthread_mutexattr_destroy (pthread_mutexattr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_mutexattr_destroy"));
int
chkr_stub_pthread_mutexattr_destroy (pthread_mutexattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutexattr_destroy);
#else
  return pthread_mutexattr_destroy (arg0);
  {
    int res;
    res = pthread_mutexattr_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutexattr_destroy */

#ifdef HAVE___pthread_mutexattr_setkind_np
/* From `/usr/include/pthread.h:283'.  */
int chkr_stub___pthread_mutexattr_setkind_np (pthread_mutexattr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("__pthread_mutexattr_setkind_np"));
int
chkr_stub___pthread_mutexattr_setkind_np (pthread_mutexattr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_mutexattr_setkind_np);
#else
  return __pthread_mutexattr_setkind_np (arg0, arg1);
  {
    int res;
    res = __pthread_mutexattr_setkind_np (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_mutexattr_setkind_np */

#ifdef HAVE_pthread_mutexattr_setkind_np
/* From `/usr/include/pthread.h:285'.  */
int chkr_stub_pthread_mutexattr_setkind_np (pthread_mutexattr_t * arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_mutexattr_setkind_np"));
int
chkr_stub_pthread_mutexattr_setkind_np (pthread_mutexattr_t * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutexattr_setkind_np);
#else
  return pthread_mutexattr_setkind_np (arg0, arg1);
  {
    int res;
    res = pthread_mutexattr_setkind_np (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutexattr_setkind_np */

#ifdef HAVE_pthread_mutexattr_getkind_np
/* From `/usr/include/pthread.h:288'.  */
int chkr_stub_pthread_mutexattr_getkind_np (const pthread_mutexattr_t * arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_mutexattr_getkind_np"));
int
chkr_stub_pthread_mutexattr_getkind_np (const pthread_mutexattr_t * arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_mutexattr_t), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_mutexattr_getkind_np);
#else
  return pthread_mutexattr_getkind_np (arg0, arg1);
  {
    int res;
    res = pthread_mutexattr_getkind_np (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_mutexattr_getkind_np */

#ifdef HAVE_pthread_cond_init
/* From `/usr/include/pthread.h:296'.  */
int chkr_stub_pthread_cond_init (pthread_cond_t * arg0, const pthread_condattr_t * arg1) __asm__ (CHKR_PREFIX ("pthread_cond_init"));
int
chkr_stub_pthread_cond_init (pthread_cond_t * arg0, const pthread_condattr_t * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_condattr_t), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_init);
#else
  return pthread_cond_init (arg0, arg1);
  {
    int res;
    res = pthread_cond_init (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_init */

#ifdef HAVE_pthread_cond_destroy
/* From `/usr/include/pthread.h:299'.  */
int chkr_stub_pthread_cond_destroy (pthread_cond_t * arg0) __asm__ (CHKR_PREFIX ("pthread_cond_destroy"));
int
chkr_stub_pthread_cond_destroy (pthread_cond_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_destroy);
#else
  return pthread_cond_destroy (arg0);
  {
    int res;
    res = pthread_cond_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_destroy */

#ifdef HAVE_pthread_cond_signal
/* From `/usr/include/pthread.h:302'.  */
int chkr_stub_pthread_cond_signal (pthread_cond_t * arg0) __asm__ (CHKR_PREFIX ("pthread_cond_signal"));
int
chkr_stub_pthread_cond_signal (pthread_cond_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_signal);
#else
  return pthread_cond_signal (arg0);
  {
    int res;
    res = pthread_cond_signal (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_signal */

#ifdef HAVE_pthread_cond_broadcast
/* From `/usr/include/pthread.h:305'.  */
int chkr_stub_pthread_cond_broadcast (pthread_cond_t * arg0) __asm__ (CHKR_PREFIX ("pthread_cond_broadcast"));
int
chkr_stub_pthread_cond_broadcast (pthread_cond_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_broadcast);
#else
  return pthread_cond_broadcast (arg0);
  {
    int res;
    res = pthread_cond_broadcast (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_broadcast */

#ifdef HAVE_pthread_cond_wait
/* From `/usr/include/pthread.h:310'.  */
int chkr_stub_pthread_cond_wait (pthread_cond_t * arg0, pthread_mutex_t * arg1) __asm__ (CHKR_PREFIX ("pthread_cond_wait"));
int
chkr_stub_pthread_cond_wait (pthread_cond_t * arg0, pthread_mutex_t * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_mutex_t), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_wait);
#else
  return pthread_cond_wait (arg0, arg1);
  {
    int res;
    res = pthread_cond_wait (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_wait */

#ifdef HAVE_pthread_cond_timedwait
/* From `/usr/include/pthread.h:318'.  */
int chkr_stub_pthread_cond_timedwait (pthread_cond_t * arg0, pthread_mutex_t * arg1, const struct timespec * arg2) __asm__ (CHKR_PREFIX ("pthread_cond_timedwait"));
int
chkr_stub_pthread_cond_timedwait (pthread_cond_t * arg0, pthread_mutex_t * arg1, const struct timespec * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_cond_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (pthread_mutex_t), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (struct timespec), CHKR_RO, "arg2");
#if USE_BI_JUMP
  __builtin_jump (pthread_cond_timedwait);
#else
  return pthread_cond_timedwait (arg0, arg1, arg2);
  {
    int res;
    res = pthread_cond_timedwait (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cond_timedwait */

#ifdef HAVE_pthread_condattr_init
/* From `/usr/include/pthread.h:323'.  */
int chkr_stub_pthread_condattr_init (pthread_condattr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_condattr_init"));
int
chkr_stub_pthread_condattr_init (pthread_condattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_condattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_condattr_init);
#else
  return pthread_condattr_init (arg0);
  {
    int res;
    res = pthread_condattr_init (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_condattr_init */

#ifdef HAVE_pthread_condattr_destroy
/* From `/usr/include/pthread.h:326'.  */
int chkr_stub_pthread_condattr_destroy (pthread_condattr_t * arg0) __asm__ (CHKR_PREFIX ("pthread_condattr_destroy"));
int
chkr_stub_pthread_condattr_destroy (pthread_condattr_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_condattr_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_condattr_destroy);
#else
  return pthread_condattr_destroy (arg0);
  {
    int res;
    res = pthread_condattr_destroy (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_condattr_destroy */

#ifdef HAVE___pthread_key_create
/* From `/usr/include/pthread.h:338'.  */
int chkr_stub___pthread_key_create (pthread_key_t * arg0, void (*) (void *) arg1) __asm__ (CHKR_PREFIX ("__pthread_key_create"));
int
chkr_stub___pthread_key_create (pthread_key_t * arg0, void (*) (void *) arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_key_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_key_create);
#else
  return __pthread_key_create (arg0, arg1);
  {
    int res;
    res = __pthread_key_create (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_key_create */

#ifdef HAVE_pthread_key_create
/* From `/usr/include/pthread.h:340'.  */
int chkr_stub_pthread_key_create (pthread_key_t * arg0, void (*) (void *) arg1) __asm__ (CHKR_PREFIX ("pthread_key_create"));
int
chkr_stub_pthread_key_create (pthread_key_t * arg0, void (*) (void *) arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_key_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_key_create);
#else
  return pthread_key_create (arg0, arg1);
  {
    int res;
    res = pthread_key_create (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_key_create */

#ifdef HAVE_pthread_key_delete
/* From `/usr/include/pthread.h:343'.  */
int chkr_stub_pthread_key_delete (pthread_key_t arg0) __asm__ (CHKR_PREFIX ("pthread_key_delete"));
int
chkr_stub_pthread_key_delete (pthread_key_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_key_delete);
#else
  return pthread_key_delete (arg0);
  {
    int res;
    res = pthread_key_delete (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_key_delete */

#ifdef HAVE___pthread_setspecific
/* From `/usr/include/pthread.h:347'.  */
int chkr_stub___pthread_setspecific (pthread_key_t arg0, const void * arg1) __asm__ (CHKR_PREFIX ("__pthread_setspecific"));
int
chkr_stub___pthread_setspecific (pthread_key_t arg0, const void * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (void), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (__pthread_setspecific);
#else
  return __pthread_setspecific (arg0, arg1);
  {
    int res;
    res = __pthread_setspecific (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_setspecific */

#ifdef HAVE_pthread_setspecific
/* From `/usr/include/pthread.h:349'.  */
int chkr_stub_pthread_setspecific (pthread_key_t arg0, const void * arg1) __asm__ (CHKR_PREFIX ("pthread_setspecific"));
int
chkr_stub_pthread_setspecific (pthread_key_t arg0, const void * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (void), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_setspecific);
#else
  return pthread_setspecific (arg0, arg1);
  {
    int res;
    res = pthread_setspecific (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_setspecific */

#ifdef HAVE___pthread_getspecific
/* From `/usr/include/pthread.h:352'.  */
void * chkr_stub___pthread_getspecific (pthread_key_t arg0) __asm__ (CHKR_PREFIX ("__pthread_getspecific"));
void *
chkr_stub___pthread_getspecific (pthread_key_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (__pthread_getspecific);
#else
  return __pthread_getspecific (arg0);
  {
    void * res;
    res = __pthread_getspecific (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_getspecific */

#ifdef HAVE_pthread_getspecific
/* From `/usr/include/pthread.h:353'.  */
void * chkr_stub_pthread_getspecific (pthread_key_t arg0) __asm__ (CHKR_PREFIX ("pthread_getspecific"));
void *
chkr_stub_pthread_getspecific (pthread_key_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_getspecific);
#else
  return pthread_getspecific (arg0);
  {
    void * res;
    res = pthread_getspecific (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_getspecific */

#ifdef HAVE___pthread_once
/* From `/usr/include/pthread.h:363'.  */
int chkr_stub___pthread_once (pthread_once_t * arg0, void (*) (void) arg1) __asm__ (CHKR_PREFIX ("__pthread_once"));
int
chkr_stub___pthread_once (pthread_once_t * arg0, void (*) (void) arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_once_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__pthread_once);
#else
  return __pthread_once (arg0, arg1);
  {
    int res;
    res = __pthread_once (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_once */

#ifdef HAVE_pthread_once
/* From `/usr/include/pthread.h:365'.  */
int chkr_stub_pthread_once (pthread_once_t * arg0, void (*) (void) arg1) __asm__ (CHKR_PREFIX ("pthread_once"));
int
chkr_stub_pthread_once (pthread_once_t * arg0, void (*) (void) arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (pthread_once_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (pthread_once);
#else
  return pthread_once (arg0, arg1);
  {
    int res;
    res = pthread_once (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_once */

#ifdef HAVE_pthread_setcancelstate
/* From `/usr/include/pthread.h:372'.  */
int chkr_stub_pthread_setcancelstate (int arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_setcancelstate"));
int
chkr_stub_pthread_setcancelstate (int arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_setcancelstate);
#else
  return pthread_setcancelstate (arg0, arg1);
  {
    int res;
    res = pthread_setcancelstate (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_setcancelstate */

#ifdef HAVE___pthread_setcanceltype
/* From `/usr/include/pthread.h:376'.  */
int chkr_stub___pthread_setcanceltype (int arg0, int * arg1) __asm__ (CHKR_PREFIX ("__pthread_setcanceltype"));
int
chkr_stub___pthread_setcanceltype (int arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (__pthread_setcanceltype);
#else
  return __pthread_setcanceltype (arg0, arg1);
  {
    int res;
    res = __pthread_setcanceltype (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_setcanceltype */

#ifdef HAVE_pthread_setcanceltype
/* From `/usr/include/pthread.h:377'.  */
int chkr_stub_pthread_setcanceltype (int arg0, int * arg1) __asm__ (CHKR_PREFIX ("pthread_setcanceltype"));
int
chkr_stub_pthread_setcanceltype (int arg0, int * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (pthread_setcanceltype);
#else
  return pthread_setcanceltype (arg0, arg1);
  {
    int res;
    res = pthread_setcanceltype (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_setcanceltype */

#ifdef HAVE_pthread_cancel
/* From `/usr/include/pthread.h:380'.  */
int chkr_stub_pthread_cancel (pthread_t arg0) __asm__ (CHKR_PREFIX ("pthread_cancel"));
int
chkr_stub_pthread_cancel (pthread_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_cancel);
#else
  return pthread_cancel (arg0);
  {
    int res;
    res = pthread_cancel (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_cancel */

#ifdef HAVE_pthread_testcancel
/* From `/usr/include/pthread.h:385'.  */
void chkr_stub_pthread_testcancel (void ) __asm__ (CHKR_PREFIX ("pthread_testcancel"));
void
chkr_stub_pthread_testcancel (void )
{
#if USE_BI_JUMP
  __builtin_jump (pthread_testcancel);
#else
  pthread_testcancel ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_testcancel */

#ifdef HAVE__pthread_cleanup_push
/* From `/usr/include/pthread.h:401'.  */
void chkr_stub__pthread_cleanup_push (struct _pthread_cleanup_buffer * arg0, void (*) (void *) arg1, void * arg2) __asm__ (CHKR_PREFIX ("_pthread_cleanup_push"));
void
chkr_stub__pthread_cleanup_push (struct _pthread_cleanup_buffer * arg0, void (*) (void *) arg1, void * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct _pthread_cleanup_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (void), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (_pthread_cleanup_push);
#else
  _pthread_cleanup_push (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__pthread_cleanup_push */

#ifdef HAVE__pthread_cleanup_pop
/* From `/usr/include/pthread.h:410'.  */
void chkr_stub__pthread_cleanup_pop (struct _pthread_cleanup_buffer * arg0, int arg1) __asm__ (CHKR_PREFIX ("_pthread_cleanup_pop"));
void
chkr_stub__pthread_cleanup_pop (struct _pthread_cleanup_buffer * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct _pthread_cleanup_buffer), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (_pthread_cleanup_pop);
#else
  _pthread_cleanup_pop (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__pthread_cleanup_pop */

#ifdef HAVE__pthread_cleanup_push_defer
/* From `/usr/include/pthread.h:421'.  */
void chkr_stub__pthread_cleanup_push_defer (struct _pthread_cleanup_buffer * arg0, void (*) (void *) arg1, void * arg2) __asm__ (CHKR_PREFIX ("_pthread_cleanup_push_defer"));
void
chkr_stub__pthread_cleanup_push_defer (struct _pthread_cleanup_buffer * arg0, void (*) (void *) arg1, void * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct _pthread_cleanup_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (void), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (_pthread_cleanup_push_defer);
#else
  _pthread_cleanup_push_defer (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__pthread_cleanup_push_defer */

#ifdef HAVE__pthread_cleanup_pop_restore
/* From `/usr/include/pthread.h:431'.  */
void chkr_stub__pthread_cleanup_pop_restore (struct _pthread_cleanup_buffer * arg0, int arg1) __asm__ (CHKR_PREFIX ("_pthread_cleanup_pop_restore"));
void
chkr_stub__pthread_cleanup_pop_restore (struct _pthread_cleanup_buffer * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct _pthread_cleanup_buffer), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (_pthread_cleanup_pop_restore);
#else
  _pthread_cleanup_pop_restore (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__pthread_cleanup_pop_restore */

#ifdef HAVE_pthread_sigmask
/* From `/usr/include/pthread.h:439'.  */
int chkr_stub_pthread_sigmask (int arg0, const sigset_t * arg1, sigset_t * arg2) __asm__ (CHKR_PREFIX ("pthread_sigmask"));
int
chkr_stub_pthread_sigmask (int arg0, const sigset_t * arg1, sigset_t * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (sigset_t), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (sigset_t), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (pthread_sigmask);
#else
  return pthread_sigmask (arg0, arg1, arg2);
  {
    int res;
    res = pthread_sigmask (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_sigmask */

#ifdef HAVE_pthread_kill
/* From `/usr/include/pthread.h:443'.  */
int chkr_stub_pthread_kill (pthread_t arg0, int arg1) __asm__ (CHKR_PREFIX ("pthread_kill"));
int
chkr_stub_pthread_kill (pthread_t arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_kill);
#else
  return pthread_kill (arg0, arg1);
  {
    int res;
    res = pthread_kill (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_kill */

#ifdef HAVE___pthread_atfork
/* From `/usr/include/pthread.h:461'.  */
int chkr_stub___pthread_atfork (void (*) (void) arg0, void (*) (void) arg1, void (*) (void) arg2) __asm__ (CHKR_PREFIX ("__pthread_atfork"));
int
chkr_stub___pthread_atfork (void (*) (void) arg0, void (*) (void) arg1, void (*) (void) arg2)
{
#if USE_BI_JUMP
  __builtin_jump (__pthread_atfork);
#else
  return __pthread_atfork (arg0, arg1, arg2);
  {
    int res;
    res = __pthread_atfork (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_atfork */

#ifdef HAVE_pthread_atfork
/* From `/usr/include/pthread.h:464'.  */
int chkr_stub_pthread_atfork (void (*) (void) arg0, void (*) (void) arg1, void (*) (void) arg2) __asm__ (CHKR_PREFIX ("pthread_atfork"));
int
chkr_stub_pthread_atfork (void (*) (void) arg0, void (*) (void) arg1, void (*) (void) arg2)
{
#if USE_BI_JUMP
  __builtin_jump (pthread_atfork);
#else
  return pthread_atfork (arg0, arg1, arg2);
  {
    int res;
    res = pthread_atfork (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_atfork */

#ifdef HAVE___pthread_kill_other_threads_np
/* From `/usr/include/pthread.h:469'.  */
void chkr_stub___pthread_kill_other_threads_np (void ) __asm__ (CHKR_PREFIX ("__pthread_kill_other_threads_np"));
void
chkr_stub___pthread_kill_other_threads_np (void )
{
#if USE_BI_JUMP
  __builtin_jump (__pthread_kill_other_threads_np);
#else
  __pthread_kill_other_threads_np ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_kill_other_threads_np */

#ifdef HAVE_pthread_kill_other_threads_np
/* From `/usr/include/pthread.h:470'.  */
void chkr_stub_pthread_kill_other_threads_np (void ) __asm__ (CHKR_PREFIX ("pthread_kill_other_threads_np"));
void
chkr_stub_pthread_kill_other_threads_np (void )
{
#if USE_BI_JUMP
  __builtin_jump (pthread_kill_other_threads_np);
#else
  pthread_kill_other_threads_np ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_pthread_kill_other_threads_np */

#ifdef HAVE___pthread_initialize
/* From `/usr/include/pthread.h:474'.  */
void chkr_stub___pthread_initialize (void ) __asm__ (CHKR_PREFIX ("__pthread_initialize"));
void
chkr_stub___pthread_initialize (void )
{
#if USE_BI_JUMP
  __builtin_jump (__pthread_initialize);
#else
  __pthread_initialize ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___pthread_initialize */

