/* Copyright (C) 1998 Ben Pfaff <pfaffben@pilot.msu.edu>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.                   
 
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of         
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
   General Public License for more details.                           
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
   02111-1307, USA. */
#include "available-stubs.h"

#include <stdio.h>
#include <readline/readline.h>
#include <stdarg.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_rl_make_bare_keymap
/* From `/usr/include/readline/keymaps.h:73'.  */
Keymap chkr_stub_rl_make_bare_keymap (void ) __asm__ (CHKR_PREFIX ("rl_make_bare_keymap"));
Keymap
chkr_stub_rl_make_bare_keymap (void )
{
  Keymap res;
  res = rl_make_bare_keymap ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_rl_make_bare_keymap */

#ifdef HAVE_rl_copy_keymap
/* From `/usr/include/readline/keymaps.h:76'.  */
Keymap chkr_stub_rl_copy_keymap (Keymap arg0) __asm__ (CHKR_PREFIX ("rl_copy_keymap"));
Keymap
chkr_stub_rl_copy_keymap (Keymap arg0)
{
  Keymap res;
  res = rl_copy_keymap (arg0);
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_rl_copy_keymap */

#ifdef HAVE_rl_make_keymap
/* From `/usr/include/readline/keymaps.h:81'.  */
Keymap chkr_stub_rl_make_keymap (void ) __asm__ (CHKR_PREFIX ("rl_make_keymap"));
Keymap
chkr_stub_rl_make_keymap (void )
{
  Keymap res;
  res = rl_make_keymap ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_rl_make_keymap */

#ifdef HAVE_rl_discard_keymap
/* From `/usr/include/readline/keymaps.h:83'.  */
void chkr_stub_rl_discard_keymap (Keymap arg0) __asm__ (CHKR_PREFIX ("rl_discard_keymap"));
void
chkr_stub_rl_discard_keymap (Keymap arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_discard_keymap);
#else
  rl_discard_keymap (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_discard_keymap */

#ifdef HAVE_rl_get_keymap_by_name
/* From `/usr/include/readline/keymaps.h:87'.  */
Keymap chkr_stub_rl_get_keymap_by_name (char * arg0) __asm__ (CHKR_PREFIX ("rl_get_keymap_by_name"));
Keymap
chkr_stub_rl_get_keymap_by_name (char * arg0)
{
  Keymap res;
  
  stubs_chkr_check_str (arg0, CHKR_RO, "name");
  res = rl_get_keymap_by_name (arg0);
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_rl_get_keymap_by_name */

#ifdef HAVE_rl_get_keymap
/* From `/usr/include/readline/keymaps.h:90'.  */
Keymap chkr_stub_rl_get_keymap (void ) __asm__ (CHKR_PREFIX ("rl_get_keymap"));
Keymap
chkr_stub_rl_get_keymap (void )
{
  Keymap res;
  res = rl_get_keymap ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_rl_get_keymap */

#ifdef HAVE_rl_set_keymap
/* From `/usr/include/readline/keymaps.h:93'.  */
void chkr_stub_rl_set_keymap (Keymap arg0) __asm__ (CHKR_PREFIX ("rl_set_keymap"));
void
chkr_stub_rl_set_keymap (Keymap arg0)
{
  stubs_chkr_check_addr (arg0, sizeof (*arg0), CHKR_RO, "keymap");
#if USE_BI_JUMP
  __builtin_jump (rl_set_keymap);
#else
  rl_set_keymap (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_set_keymap */

#ifdef HAVE_tilde_expand
/* From `/usr/include/readline/tilde.h:59'.  */
char * chkr_stub_tilde_expand (char * arg0) __asm__ (CHKR_PREFIX ("tilde_expand"));
char *
chkr_stub_tilde_expand (char * arg0)
{
  char * res;
  
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
  res = tilde_expand (arg0);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_tilde_expand */

#ifdef HAVE_tilde_expand_word
/* From `/usr/include/readline/tilde.h:63'.  */
char * chkr_stub_tilde_expand_word (char * arg0) __asm__ (CHKR_PREFIX ("tilde_expand_word"));
char *
chkr_stub_tilde_expand_word (char * arg0)
{
  char * res;
  
  stubs_chkr_check_str (arg0, CHKR_RO, "arg0");
  res = tilde_expand_word (arg0);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_tilde_expand_word */

#ifdef HAVE_rl_tilde_expand
/* From `/usr/include/readline/readline.h:67'.  */
int chkr_stub_rl_tilde_expand (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_tilde_expand"));
int
chkr_stub_rl_tilde_expand (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_tilde_expand);
#else
  return rl_tilde_expand (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_tilde_expand */

#ifdef HAVE_rl_set_mark
/* From `/usr/include/readline/readline.h:67'.  */
int chkr_stub_rl_set_mark (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_set_mark"));
int
chkr_stub_rl_set_mark (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_set_mark);
#else
  return rl_set_mark (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_set_mark */

#ifdef HAVE_rl_exchange_point_and_mark
/* From `/usr/include/readline/readline.h:67'.  */
int chkr_stub_rl_exchange_point_and_mark (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_exchange_point_and_mark"));
int
chkr_stub_rl_exchange_point_and_mark (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_exchange_point_and_mark);
#else
  return rl_exchange_point_and_mark (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_exchange_point_and_mark */

#ifdef HAVE_rl_beg_of_line
/* From `/usr/include/readline/readline.h:68'.  */
int chkr_stub_rl_beg_of_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_beg_of_line"));
int
chkr_stub_rl_beg_of_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_beg_of_line);
#else
  return rl_beg_of_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_beg_of_line */

#ifdef HAVE_rl_backward
/* From `/usr/include/readline/readline.h:68'.  */
int chkr_stub_rl_backward (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_backward"));
int
chkr_stub_rl_backward (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_backward);
#else
  return rl_backward (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_backward */

#ifdef HAVE_rl_delete
/* From `/usr/include/readline/readline.h:68'.  */
int chkr_stub_rl_delete (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_delete"));
int
chkr_stub_rl_delete (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_delete);
#else
  return rl_delete (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_delete */

#ifdef HAVE_rl_end_of_line
/* From `/usr/include/readline/readline.h:68'.  */
int chkr_stub_rl_end_of_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_end_of_line"));
int
chkr_stub_rl_end_of_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_end_of_line);
#else
  return rl_end_of_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_end_of_line */

#ifdef HAVE_rl_forward
/* From `/usr/include/readline/readline.h:69'.  */
int chkr_stub_rl_forward (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_forward"));
int
chkr_stub_rl_forward (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_forward);
#else
  return rl_forward (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_forward */

#ifdef HAVE_ding
/* From `/usr/include/readline/readline.h:69'.  */
int chkr_stub_ding (void ) __asm__ (CHKR_PREFIX ("ding"));
int
chkr_stub_ding (void )
{
#if USE_BI_JUMP
  __builtin_jump (ding);
#else
  return ding ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_ding */

#ifdef HAVE_rl_newline
/* From `/usr/include/readline/readline.h:69'.  */
int chkr_stub_rl_newline (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_newline"));
int
chkr_stub_rl_newline (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_newline);
#else
  return rl_newline (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_newline */

#ifdef HAVE_rl_kill_line
/* From `/usr/include/readline/readline.h:69'.  */
int chkr_stub_rl_kill_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_kill_line"));
int
chkr_stub_rl_kill_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_kill_line);
#else
  return rl_kill_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_kill_line */

#ifdef HAVE_rl_copy_region_to_kill
/* From `/usr/include/readline/readline.h:70'.  */
int chkr_stub_rl_copy_region_to_kill (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_copy_region_to_kill"));
int
chkr_stub_rl_copy_region_to_kill (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_copy_region_to_kill);
#else
  return rl_copy_region_to_kill (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_copy_region_to_kill */

#ifdef HAVE_rl_kill_region
/* From `/usr/include/readline/readline.h:70'.  */
int chkr_stub_rl_kill_region (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_kill_region"));
int
chkr_stub_rl_kill_region (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_kill_region);
#else
  return rl_kill_region (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_kill_region */

#ifdef HAVE_rl_char_search
/* From `/usr/include/readline/readline.h:70'.  */
int chkr_stub_rl_char_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_char_search"));
int
chkr_stub_rl_char_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_char_search);
#else
  return rl_char_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_char_search */

#ifdef HAVE_rl_clear_screen
/* From `/usr/include/readline/readline.h:71'.  */
int chkr_stub_rl_clear_screen (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_clear_screen"));
int
chkr_stub_rl_clear_screen (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_clear_screen);
#else
  return rl_clear_screen (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_clear_screen */

#ifdef HAVE_rl_get_next_history
/* From `/usr/include/readline/readline.h:71'.  */
int chkr_stub_rl_get_next_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_get_next_history"));
int
chkr_stub_rl_get_next_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_get_next_history);
#else
  return rl_get_next_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_get_next_history */

#ifdef HAVE_rl_get_previous_history
/* From `/usr/include/readline/readline.h:71'.  */
int chkr_stub_rl_get_previous_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_get_previous_history"));
int
chkr_stub_rl_get_previous_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_get_previous_history);
#else
  return rl_get_previous_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_get_previous_history */

#ifdef HAVE_rl_quoted_insert
/* From `/usr/include/readline/readline.h:72'.  */
int chkr_stub_rl_quoted_insert (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_quoted_insert"));
int
chkr_stub_rl_quoted_insert (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_quoted_insert);
#else
  return rl_quoted_insert (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_quoted_insert */

#ifdef HAVE_rl_reverse_search_history
/* From `/usr/include/readline/readline.h:72'.  */
int chkr_stub_rl_reverse_search_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_reverse_search_history"));
int
chkr_stub_rl_reverse_search_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_reverse_search_history);
#else
  return rl_reverse_search_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_reverse_search_history */

#ifdef HAVE_rl_transpose_chars
/* From `/usr/include/readline/readline.h:72'.  */
int chkr_stub_rl_transpose_chars (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_transpose_chars"));
int
chkr_stub_rl_transpose_chars (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_transpose_chars);
#else
  return rl_transpose_chars (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_transpose_chars */

#ifdef HAVE_rl_unix_line_discard
/* From `/usr/include/readline/readline.h:73'.  */
int chkr_stub_rl_unix_line_discard (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_unix_line_discard"));
int
chkr_stub_rl_unix_line_discard (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_unix_line_discard);
#else
  return rl_unix_line_discard (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_unix_line_discard */

#ifdef HAVE_rl_unix_word_rubout
/* From `/usr/include/readline/readline.h:73'.  */
int chkr_stub_rl_unix_word_rubout (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_unix_word_rubout"));
int
chkr_stub_rl_unix_word_rubout (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_unix_word_rubout);
#else
  return rl_unix_word_rubout (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_unix_word_rubout */

#ifdef HAVE_rl_yank
/* From `/usr/include/readline/readline.h:74'.  */
int chkr_stub_rl_yank (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_yank"));
int
chkr_stub_rl_yank (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_yank);
#else
  return rl_yank (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_yank */

#ifdef HAVE_rl_rubout
/* From `/usr/include/readline/readline.h:74'.  */
int chkr_stub_rl_rubout (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_rubout"));
int
chkr_stub_rl_rubout (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_rubout);
#else
  return rl_rubout (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_rubout */

#ifdef HAVE_rl_backward_word
/* From `/usr/include/readline/readline.h:74'.  */
int chkr_stub_rl_backward_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_backward_word"));
int
chkr_stub_rl_backward_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_backward_word);
#else
  return rl_backward_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_backward_word */

#ifdef HAVE_rl_kill_word
/* From `/usr/include/readline/readline.h:74'.  */
int chkr_stub_rl_kill_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_kill_word"));
int
chkr_stub_rl_kill_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_kill_word);
#else
  return rl_kill_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_kill_word */

#ifdef HAVE_rl_forward_word
/* From `/usr/include/readline/readline.h:75'.  */
int chkr_stub_rl_forward_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_forward_word"));
int
chkr_stub_rl_forward_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_forward_word);
#else
  return rl_forward_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_forward_word */

#ifdef HAVE_rl_tab_insert
/* From `/usr/include/readline/readline.h:75'.  */
int chkr_stub_rl_tab_insert (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_tab_insert"));
int
chkr_stub_rl_tab_insert (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_tab_insert);
#else
  return rl_tab_insert (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_tab_insert */

#ifdef HAVE_rl_yank_pop
/* From `/usr/include/readline/readline.h:75'.  */
int chkr_stub_rl_yank_pop (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_yank_pop"));
int
chkr_stub_rl_yank_pop (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_yank_pop);
#else
  return rl_yank_pop (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_yank_pop */

#ifdef HAVE_rl_yank_nth_arg
/* From `/usr/include/readline/readline.h:75'.  */
int chkr_stub_rl_yank_nth_arg (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_yank_nth_arg"));
int
chkr_stub_rl_yank_nth_arg (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_yank_nth_arg);
#else
  return rl_yank_nth_arg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_yank_nth_arg */

#ifdef HAVE_rl_backward_kill_word
/* From `/usr/include/readline/readline.h:76'.  */
int chkr_stub_rl_backward_kill_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_backward_kill_word"));
int
chkr_stub_rl_backward_kill_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_backward_kill_word);
#else
  return rl_backward_kill_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_backward_kill_word */

#ifdef HAVE_rl_backward_kill_line
/* From `/usr/include/readline/readline.h:76'.  */
int chkr_stub_rl_backward_kill_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_backward_kill_line"));
int
chkr_stub_rl_backward_kill_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_backward_kill_line);
#else
  return rl_backward_kill_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_backward_kill_line */

#ifdef HAVE_rl_transpose_words
/* From `/usr/include/readline/readline.h:76'.  */
int chkr_stub_rl_transpose_words (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_transpose_words"));
int
chkr_stub_rl_transpose_words (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_transpose_words);
#else
  return rl_transpose_words (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_transpose_words */

#ifdef HAVE_rl_complete
/* From `/usr/include/readline/readline.h:77'.  */
int chkr_stub_rl_complete (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_complete"));
int
chkr_stub_rl_complete (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_complete);
#else
  return rl_complete (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_complete */

#ifdef HAVE_rl_possible_completions
/* From `/usr/include/readline/readline.h:77'.  */
int chkr_stub_rl_possible_completions (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_possible_completions"));
int
chkr_stub_rl_possible_completions (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_possible_completions);
#else
  return rl_possible_completions (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_possible_completions */

#ifdef HAVE_rl_insert_completions
/* From `/usr/include/readline/readline.h:77'.  */
int chkr_stub_rl_insert_completions (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_insert_completions"));
int
chkr_stub_rl_insert_completions (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_insert_completions);
#else
  return rl_insert_completions (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_insert_completions */

#ifdef HAVE_rl_do_lowercase_version
/* From `/usr/include/readline/readline.h:78'.  */
int chkr_stub_rl_do_lowercase_version (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_do_lowercase_version"));
int
chkr_stub_rl_do_lowercase_version (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_do_lowercase_version);
#else
  return rl_do_lowercase_version (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_do_lowercase_version */

#ifdef HAVE_rl_kill_full_line
/* From `/usr/include/readline/readline.h:78'.  */
int chkr_stub_rl_kill_full_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_kill_full_line"));
int
chkr_stub_rl_kill_full_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_kill_full_line);
#else
  return rl_kill_full_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_kill_full_line */

#ifdef HAVE_rl_digit_argument
/* From `/usr/include/readline/readline.h:79'.  */
int chkr_stub_rl_digit_argument (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_digit_argument"));
int
chkr_stub_rl_digit_argument (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_digit_argument);
#else
  return rl_digit_argument (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_digit_argument */

#ifdef HAVE_rl_universal_argument
/* From `/usr/include/readline/readline.h:79'.  */
int chkr_stub_rl_universal_argument (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_universal_argument"));
int
chkr_stub_rl_universal_argument (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_universal_argument);
#else
  return rl_universal_argument (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_universal_argument */

#ifdef HAVE_rl_abort
/* From `/usr/include/readline/readline.h:79'.  */
int chkr_stub_rl_abort (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_abort"));
int
chkr_stub_rl_abort (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_abort);
#else
  return rl_abort (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_abort */

#ifdef HAVE_rl_undo_command
/* From `/usr/include/readline/readline.h:80'.  */
int chkr_stub_rl_undo_command (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_undo_command"));
int
chkr_stub_rl_undo_command (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_undo_command);
#else
  return rl_undo_command (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_undo_command */

#ifdef HAVE_rl_revert_line
/* From `/usr/include/readline/readline.h:80'.  */
int chkr_stub_rl_revert_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_revert_line"));
int
chkr_stub_rl_revert_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_revert_line);
#else
  return rl_revert_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_revert_line */

#ifdef HAVE_rl_beginning_of_history
/* From `/usr/include/readline/readline.h:80'.  */
int chkr_stub_rl_beginning_of_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_beginning_of_history"));
int
chkr_stub_rl_beginning_of_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_beginning_of_history);
#else
  return rl_beginning_of_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_beginning_of_history */

#ifdef HAVE_rl_end_of_history
/* From `/usr/include/readline/readline.h:81'.  */
int chkr_stub_rl_end_of_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_end_of_history"));
int
chkr_stub_rl_end_of_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_end_of_history);
#else
  return rl_end_of_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_end_of_history */

#ifdef HAVE_rl_forward_search_history
/* From `/usr/include/readline/readline.h:81'.  */
int chkr_stub_rl_forward_search_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_forward_search_history"));
int
chkr_stub_rl_forward_search_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_forward_search_history);
#else
  return rl_forward_search_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_forward_search_history */

#ifdef HAVE_rl_insert
/* From `/usr/include/readline/readline.h:81'.  */
int chkr_stub_rl_insert (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_insert"));
int
chkr_stub_rl_insert (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_insert);
#else
  return rl_insert (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_insert */

#ifdef HAVE_rl_upcase_word
/* From `/usr/include/readline/readline.h:82'.  */
int chkr_stub_rl_upcase_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_upcase_word"));
int
chkr_stub_rl_upcase_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_upcase_word);
#else
  return rl_upcase_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_upcase_word */

#ifdef HAVE_rl_downcase_word
/* From `/usr/include/readline/readline.h:82'.  */
int chkr_stub_rl_downcase_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_downcase_word"));
int
chkr_stub_rl_downcase_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_downcase_word);
#else
  return rl_downcase_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_downcase_word */

#ifdef HAVE_rl_capitalize_word
/* From `/usr/include/readline/readline.h:82'.  */
int chkr_stub_rl_capitalize_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_capitalize_word"));
int
chkr_stub_rl_capitalize_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_capitalize_word);
#else
  return rl_capitalize_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_capitalize_word */

#ifdef HAVE_rl_restart_output
/* From `/usr/include/readline/readline.h:83'.  */
int chkr_stub_rl_restart_output (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_restart_output"));
int
chkr_stub_rl_restart_output (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_restart_output);
#else
  return rl_restart_output (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_restart_output */

#ifdef HAVE_rl_re_read_init_file
/* From `/usr/include/readline/readline.h:83'.  */
int chkr_stub_rl_re_read_init_file (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_re_read_init_file"));
int
chkr_stub_rl_re_read_init_file (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_re_read_init_file);
#else
  return rl_re_read_init_file (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_re_read_init_file */

#ifdef HAVE_rl_dump_functions
/* From `/usr/include/readline/readline.h:84'.  */
int chkr_stub_rl_dump_functions (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_dump_functions"));
int
chkr_stub_rl_dump_functions (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_dump_functions);
#else
  return rl_dump_functions (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_dump_functions */

#ifdef HAVE_rl_dump_variables
/* From `/usr/include/readline/readline.h:84'.  */
int chkr_stub_rl_dump_variables (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_dump_variables"));
int
chkr_stub_rl_dump_variables (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_dump_variables);
#else
  return rl_dump_variables (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_dump_variables */

#ifdef HAVE_rl_dump_macros
/* From `/usr/include/readline/readline.h:84'.  */
int chkr_stub_rl_dump_macros (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_dump_macros"));
int
chkr_stub_rl_dump_macros (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_dump_macros);
#else
  return rl_dump_macros (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_dump_macros */

#ifdef HAVE_rl_delete_horizontal_space
/* From `/usr/include/readline/readline.h:85'.  */
int chkr_stub_rl_delete_horizontal_space (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_delete_horizontal_space"));
int
chkr_stub_rl_delete_horizontal_space (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_delete_horizontal_space);
#else
  return rl_delete_horizontal_space (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_delete_horizontal_space */

#ifdef HAVE_rl_history_search_forward
/* From `/usr/include/readline/readline.h:85'.  */
int chkr_stub_rl_history_search_forward (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_history_search_forward"));
int
chkr_stub_rl_history_search_forward (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_history_search_forward);
#else
  return rl_history_search_forward (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_history_search_forward */

#ifdef HAVE_rl_history_search_backward
/* From `/usr/include/readline/readline.h:86'.  */
int chkr_stub_rl_history_search_backward (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_history_search_backward"));
int
chkr_stub_rl_history_search_backward (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_history_search_backward);
#else
  return rl_history_search_backward (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_history_search_backward */

#ifdef HAVE_rl_tty_status
/* From `/usr/include/readline/readline.h:86'.  */
int chkr_stub_rl_tty_status (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_tty_status"));
int
chkr_stub_rl_tty_status (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_tty_status);
#else
  return rl_tty_status (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_tty_status */

#ifdef HAVE_rl_yank_last_arg
/* From `/usr/include/readline/readline.h:86'.  */
int chkr_stub_rl_yank_last_arg (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_yank_last_arg"));
int
chkr_stub_rl_yank_last_arg (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_yank_last_arg);
#else
  return rl_yank_last_arg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_yank_last_arg */

#ifdef HAVE_rl_insert_comment
/* From `/usr/include/readline/readline.h:87'.  */
int chkr_stub_rl_insert_comment (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_insert_comment"));
int
chkr_stub_rl_insert_comment (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_insert_comment);
#else
  return rl_insert_comment (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_insert_comment */

#ifdef HAVE_rl_backward_char_search
/* From `/usr/include/readline/readline.h:87'.  */
int chkr_stub_rl_backward_char_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_backward_char_search"));
int
chkr_stub_rl_backward_char_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_backward_char_search);
#else
  return rl_backward_char_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_backward_char_search */

#ifdef HAVE_rl_copy_forward_word
/* From `/usr/include/readline/readline.h:88'.  */
int chkr_stub_rl_copy_forward_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_copy_forward_word"));
int
chkr_stub_rl_copy_forward_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_copy_forward_word);
#else
  return rl_copy_forward_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_copy_forward_word */

#ifdef HAVE_rl_copy_backward_word
/* From `/usr/include/readline/readline.h:88'.  */
int chkr_stub_rl_copy_backward_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_copy_backward_word"));
int
chkr_stub_rl_copy_backward_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_copy_backward_word);
#else
  return rl_copy_backward_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_copy_backward_word */

#ifdef HAVE_rl_insert_close
/* From `/usr/include/readline/readline.h:91'.  */
int chkr_stub_rl_insert_close (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_insert_close"));
int
chkr_stub_rl_insert_close (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_insert_close);
#else
  return rl_insert_close (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_insert_close */

#ifdef HAVE_rl_callback_handler_install
/* From `/usr/include/readline/readline.h:94'.  */
void chkr_stub_rl_callback_handler_install (char * arg0, VFunction * arg1) __asm__ (CHKR_PREFIX ("rl_callback_handler_install"));
void
chkr_stub_rl_callback_handler_install (char * arg0, VFunction * arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "prompt");
  stubs_chkr_check_exec (arg1, "lhandler");
#if USE_BI_JUMP
  __builtin_jump (rl_callback_handler_install);
#else
  rl_callback_handler_install (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_callback_handler_install */

#ifdef HAVE_rl_callback_read_char
/* From `/usr/include/readline/readline.h:95'.  */
void chkr_stub_rl_callback_read_char (void ) __asm__ (CHKR_PREFIX ("rl_callback_read_char"));
void
chkr_stub_rl_callback_read_char (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_callback_read_char);
#else
  rl_callback_read_char ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_callback_read_char */

#ifdef HAVE_rl_callback_handler_remove
/* From `/usr/include/readline/readline.h:96'.  */
void chkr_stub_rl_callback_handler_remove (void ) __asm__ (CHKR_PREFIX ("rl_callback_handler_remove"));
void
chkr_stub_rl_callback_handler_remove (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_callback_handler_remove);
#else
  rl_callback_handler_remove ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_callback_handler_remove */

#ifdef HAVE_rl_vi_editing_mode
/* From `/usr/include/readline/readline.h:99'.  */
int chkr_stub_rl_vi_editing_mode (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_editing_mode"));
int
chkr_stub_rl_vi_editing_mode (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_editing_mode);
#else
  return rl_vi_editing_mode (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_editing_mode */

#ifdef HAVE_rl_emacs_editing_mode
/* From `/usr/include/readline/readline.h:99'.  */
int chkr_stub_rl_emacs_editing_mode (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_emacs_editing_mode"));
int
chkr_stub_rl_emacs_editing_mode (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_emacs_editing_mode);
#else
  return rl_emacs_editing_mode (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_emacs_editing_mode */

#ifdef HAVE_rl_noninc_forward_search
/* From `/usr/include/readline/readline.h:103'.  */
int chkr_stub_rl_noninc_forward_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_noninc_forward_search"));
int
chkr_stub_rl_noninc_forward_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_noninc_forward_search);
#else
  return rl_noninc_forward_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_noninc_forward_search */

#ifdef HAVE_rl_noninc_reverse_search
/* From `/usr/include/readline/readline.h:103'.  */
int chkr_stub_rl_noninc_reverse_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_noninc_reverse_search"));
int
chkr_stub_rl_noninc_reverse_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_noninc_reverse_search);
#else
  return rl_noninc_reverse_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_noninc_reverse_search */

#ifdef HAVE_rl_noninc_forward_search_again
/* From `/usr/include/readline/readline.h:104'.  */
int chkr_stub_rl_noninc_forward_search_again (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_noninc_forward_search_again"));
int
chkr_stub_rl_noninc_forward_search_again (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_noninc_forward_search_again);
#else
  return rl_noninc_forward_search_again (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_noninc_forward_search_again */

#ifdef HAVE_rl_noninc_reverse_search_again
/* From `/usr/include/readline/readline.h:104'.  */
int chkr_stub_rl_noninc_reverse_search_again (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_noninc_reverse_search_again"));
int
chkr_stub_rl_noninc_reverse_search_again (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_noninc_reverse_search_again);
#else
  return rl_noninc_reverse_search_again (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_noninc_reverse_search_again */

#if 0
#ifdef HAVE_rl_vi_check
/* From `/usr/include/readline/readline.h:107'.  */
int chkr_stub_rl_vi_check (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_check"));
int
chkr_stub_rl_vi_check (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_check);
#else
  return rl_vi_check (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_check */
#endif

#ifdef HAVE_rl_vi_undo
/* From `/usr/include/readline/readline.h:109'.  */
int chkr_stub_rl_vi_undo (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_undo"));
int
chkr_stub_rl_vi_undo (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_undo);
#else
  return rl_vi_undo (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_undo */

#ifdef HAVE_rl_vi_redo
/* From `/usr/include/readline/readline.h:109'.  */
int chkr_stub_rl_vi_redo (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_redo"));
int
chkr_stub_rl_vi_redo (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_redo);
#else
  return rl_vi_redo (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_redo */

#ifdef HAVE_rl_vi_tilde_expand
/* From `/usr/include/readline/readline.h:109'.  */
int chkr_stub_rl_vi_tilde_expand (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_tilde_expand"));
int
chkr_stub_rl_vi_tilde_expand (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_tilde_expand);
#else
  return rl_vi_tilde_expand (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_tilde_expand */

#ifdef HAVE_rl_vi_movement_mode
/* From `/usr/include/readline/readline.h:110'.  */
int chkr_stub_rl_vi_movement_mode (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_movement_mode"));
int
chkr_stub_rl_vi_movement_mode (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_movement_mode);
#else
  return rl_vi_movement_mode (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_movement_mode */

#ifdef HAVE_rl_vi_insertion_mode
/* From `/usr/include/readline/readline.h:110'.  */
int chkr_stub_rl_vi_insertion_mode (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_insertion_mode"));
int
chkr_stub_rl_vi_insertion_mode (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_insertion_mode);
#else
  return rl_vi_insertion_mode (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_insertion_mode */

#ifdef HAVE_rl_vi_arg_digit
/* From `/usr/include/readline/readline.h:110'.  */
int chkr_stub_rl_vi_arg_digit (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_arg_digit"));
int
chkr_stub_rl_vi_arg_digit (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_arg_digit);
#else
  return rl_vi_arg_digit (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_arg_digit */

#ifdef HAVE_rl_vi_prev_word
/* From `/usr/include/readline/readline.h:111'.  */
int chkr_stub_rl_vi_prev_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_prev_word"));
int
chkr_stub_rl_vi_prev_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_prev_word);
#else
  return rl_vi_prev_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_prev_word */

#ifdef HAVE_rl_vi_next_word
/* From `/usr/include/readline/readline.h:111'.  */
int chkr_stub_rl_vi_next_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_next_word"));
int
chkr_stub_rl_vi_next_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_next_word);
#else
  return rl_vi_next_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_next_word */

#ifdef HAVE_rl_vi_char_search
/* From `/usr/include/readline/readline.h:111'.  */
int chkr_stub_rl_vi_char_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_char_search"));
int
chkr_stub_rl_vi_char_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_char_search);
#else
  return rl_vi_char_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_char_search */

#ifdef HAVE_rl_vi_eof_maybe
/* From `/usr/include/readline/readline.h:112'.  */
int chkr_stub_rl_vi_eof_maybe (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_eof_maybe"));
int
chkr_stub_rl_vi_eof_maybe (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_eof_maybe);
#else
  return rl_vi_eof_maybe (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_eof_maybe */

#ifdef HAVE_rl_vi_append_mode
/* From `/usr/include/readline/readline.h:112'.  */
int chkr_stub_rl_vi_append_mode (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_append_mode"));
int
chkr_stub_rl_vi_append_mode (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_append_mode);
#else
  return rl_vi_append_mode (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_append_mode */

#ifdef HAVE_rl_vi_put
/* From `/usr/include/readline/readline.h:112'.  */
int chkr_stub_rl_vi_put (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_put"));
int
chkr_stub_rl_vi_put (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_put);
#else
  return rl_vi_put (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_put */

#ifdef HAVE_rl_vi_append_eol
/* From `/usr/include/readline/readline.h:113'.  */
int chkr_stub_rl_vi_append_eol (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_append_eol"));
int
chkr_stub_rl_vi_append_eol (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_append_eol);
#else
  return rl_vi_append_eol (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_append_eol */

#ifdef HAVE_rl_vi_insert_beg
/* From `/usr/include/readline/readline.h:113'.  */
int chkr_stub_rl_vi_insert_beg (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_insert_beg"));
int
chkr_stub_rl_vi_insert_beg (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_insert_beg);
#else
  return rl_vi_insert_beg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_insert_beg */

#ifdef HAVE_rl_vi_delete
/* From `/usr/include/readline/readline.h:113'.  */
int chkr_stub_rl_vi_delete (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_delete"));
int
chkr_stub_rl_vi_delete (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_delete);
#else
  return rl_vi_delete (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_delete */

#ifdef HAVE_rl_vi_first_print
/* From `/usr/include/readline/readline.h:114'.  */
int chkr_stub_rl_vi_first_print (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_first_print"));
int
chkr_stub_rl_vi_first_print (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_first_print);
#else
  return rl_vi_first_print (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_first_print */

#ifdef HAVE_rl_vi_fword
/* From `/usr/include/readline/readline.h:114'.  */
int chkr_stub_rl_vi_fword (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_fword"));
int
chkr_stub_rl_vi_fword (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_fword);
#else
  return rl_vi_fword (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_fword */

#ifdef HAVE_rl_vi_fWord
/* From `/usr/include/readline/readline.h:114'.  */
int chkr_stub_rl_vi_fWord (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_fWord"));
int
chkr_stub_rl_vi_fWord (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_fWord);
#else
  return rl_vi_fWord (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_fWord */

#ifdef HAVE_rl_vi_bword
/* From `/usr/include/readline/readline.h:114'.  */
int chkr_stub_rl_vi_bword (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_bword"));
int
chkr_stub_rl_vi_bword (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_bword);
#else
  return rl_vi_bword (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_bword */

#ifdef HAVE_rl_vi_bWord
/* From `/usr/include/readline/readline.h:115'.  */
int chkr_stub_rl_vi_bWord (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_bWord"));
int
chkr_stub_rl_vi_bWord (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_bWord);
#else
  return rl_vi_bWord (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_bWord */

#ifdef HAVE_rl_vi_eword
/* From `/usr/include/readline/readline.h:115'.  */
int chkr_stub_rl_vi_eword (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_eword"));
int
chkr_stub_rl_vi_eword (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_eword);
#else
  return rl_vi_eword (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_eword */

#ifdef HAVE_rl_vi_eWord
/* From `/usr/include/readline/readline.h:115'.  */
int chkr_stub_rl_vi_eWord (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_eWord"));
int
chkr_stub_rl_vi_eWord (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_eWord);
#else
  return rl_vi_eWord (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_eWord */

#ifdef HAVE_rl_vi_end_word
/* From `/usr/include/readline/readline.h:115'.  */
int chkr_stub_rl_vi_end_word (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_end_word"));
int
chkr_stub_rl_vi_end_word (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_end_word);
#else
  return rl_vi_end_word (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_end_word */

#ifdef HAVE_rl_vi_change_case
/* From `/usr/include/readline/readline.h:116'.  */
int chkr_stub_rl_vi_change_case (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_change_case"));
int
chkr_stub_rl_vi_change_case (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_change_case);
#else
  return rl_vi_change_case (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_change_case */

#ifdef HAVE_rl_vi_match
/* From `/usr/include/readline/readline.h:116'.  */
int chkr_stub_rl_vi_match (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_match"));
int
chkr_stub_rl_vi_match (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_match);
#else
  return rl_vi_match (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_match */

#if 0
#ifdef HAVE_rl_vi_bracktype
/* From `/usr/include/readline/readline.h:116'.  */
int chkr_stub_rl_vi_bracktype (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_bracktype"));
int
chkr_stub_rl_vi_bracktype (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_bracktype);
#else
  return rl_vi_bracktype (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_bracktype */
#endif

#ifdef HAVE_rl_vi_change_char
/* From `/usr/include/readline/readline.h:117'.  */
int chkr_stub_rl_vi_change_char (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_change_char"));
int
chkr_stub_rl_vi_change_char (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_change_char);
#else
  return rl_vi_change_char (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_change_char */

#ifdef HAVE_rl_vi_yank_arg
/* From `/usr/include/readline/readline.h:117'.  */
int chkr_stub_rl_vi_yank_arg (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_yank_arg"));
int
chkr_stub_rl_vi_yank_arg (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_yank_arg);
#else
  return rl_vi_yank_arg (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_yank_arg */

#ifdef HAVE_rl_vi_search
/* From `/usr/include/readline/readline.h:117'.  */
int chkr_stub_rl_vi_search (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_search"));
int
chkr_stub_rl_vi_search (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_search);
#else
  return rl_vi_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_search */

#ifdef HAVE_rl_vi_search_again
/* From `/usr/include/readline/readline.h:118'.  */
int chkr_stub_rl_vi_search_again (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_search_again"));
int
chkr_stub_rl_vi_search_again (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_search_again);
#else
  return rl_vi_search_again (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_search_again */

#ifdef HAVE_rl_vi_subst
/* From `/usr/include/readline/readline.h:118'.  */
int chkr_stub_rl_vi_subst (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_subst"));
int
chkr_stub_rl_vi_subst (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_subst);
#else
  return rl_vi_subst (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_subst */

#ifdef HAVE_rl_vi_overstrike
/* From `/usr/include/readline/readline.h:118'.  */
int chkr_stub_rl_vi_overstrike (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_overstrike"));
int
chkr_stub_rl_vi_overstrike (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_overstrike);
#else
  return rl_vi_overstrike (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_overstrike */

#ifdef HAVE_rl_vi_overstrike_delete
/* From `/usr/include/readline/readline.h:119'.  */
int chkr_stub_rl_vi_overstrike_delete (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_overstrike_delete"));
int
chkr_stub_rl_vi_overstrike_delete (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_overstrike_delete);
#else
  return rl_vi_overstrike_delete (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_overstrike_delete */

#ifdef HAVE_rl_vi_replace
/* From `/usr/include/readline/readline.h:119'.  */
int chkr_stub_rl_vi_replace (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_replace"));
int
chkr_stub_rl_vi_replace (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_replace);
#else
  return rl_vi_replace (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_replace */

#ifdef HAVE_rl_vi_column
/* From `/usr/include/readline/readline.h:119'.  */
int chkr_stub_rl_vi_column (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_column"));
int
chkr_stub_rl_vi_column (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_column);
#else
  return rl_vi_column (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_column */

#ifdef HAVE_rl_vi_delete_to
/* From `/usr/include/readline/readline.h:120'.  */
int chkr_stub_rl_vi_delete_to (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_delete_to"));
int
chkr_stub_rl_vi_delete_to (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_delete_to);
#else
  return rl_vi_delete_to (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_delete_to */

#ifdef HAVE_rl_vi_change_to
/* From `/usr/include/readline/readline.h:120'.  */
int chkr_stub_rl_vi_change_to (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_change_to"));
int
chkr_stub_rl_vi_change_to (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_change_to);
#else
  return rl_vi_change_to (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_change_to */

#ifdef HAVE_rl_vi_yank_to
/* From `/usr/include/readline/readline.h:120'.  */
int chkr_stub_rl_vi_yank_to (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_yank_to"));
int
chkr_stub_rl_vi_yank_to (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_yank_to);
#else
  return rl_vi_yank_to (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_yank_to */

#ifdef HAVE_rl_vi_complete
/* From `/usr/include/readline/readline.h:121'.  */
int chkr_stub_rl_vi_complete (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_complete"));
int
chkr_stub_rl_vi_complete (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_complete);
#else
  return rl_vi_complete (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_complete */

#ifdef HAVE_rl_vi_fetch_history
/* From `/usr/include/readline/readline.h:121'.  */
int chkr_stub_rl_vi_fetch_history (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_fetch_history"));
int
chkr_stub_rl_vi_fetch_history (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_fetch_history);
#else
  return rl_vi_fetch_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_fetch_history */

#ifdef HAVE_rl_vi_set_mark
/* From `/usr/include/readline/readline.h:121'.  */
int chkr_stub_rl_vi_set_mark (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_set_mark"));
int
chkr_stub_rl_vi_set_mark (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_set_mark);
#else
  return rl_vi_set_mark (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_set_mark */

#ifdef HAVE_rl_vi_goto_mark
/* From `/usr/include/readline/readline.h:122'.  */
int chkr_stub_rl_vi_goto_mark (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_goto_mark"));
int
chkr_stub_rl_vi_goto_mark (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_goto_mark);
#else
  return rl_vi_goto_mark (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_goto_mark */

#ifdef HAVE_rl_vi_back_to_indent
/* From `/usr/include/readline/readline.h:122'.  */
int chkr_stub_rl_vi_back_to_indent (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_vi_back_to_indent"));
int
chkr_stub_rl_vi_back_to_indent (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_vi_back_to_indent);
#else
  return rl_vi_back_to_indent (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_vi_back_to_indent */

#ifdef HAVE_rl_start_kbd_macro
/* From `/usr/include/readline/readline.h:125'.  */
int chkr_stub_rl_start_kbd_macro (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_start_kbd_macro"));
int
chkr_stub_rl_start_kbd_macro (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_start_kbd_macro);
#else
  return rl_start_kbd_macro (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_start_kbd_macro */

#ifdef HAVE_rl_end_kbd_macro
/* From `/usr/include/readline/readline.h:125'.  */
int chkr_stub_rl_end_kbd_macro (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_end_kbd_macro"));
int
chkr_stub_rl_end_kbd_macro (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_end_kbd_macro);
#else
  return rl_end_kbd_macro (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_end_kbd_macro */

#ifdef HAVE_rl_call_last_kbd_macro
/* From `/usr/include/readline/readline.h:126'.  */
int chkr_stub_rl_call_last_kbd_macro (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_call_last_kbd_macro"));
int
chkr_stub_rl_call_last_kbd_macro (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_call_last_kbd_macro);
#else
  return rl_call_last_kbd_macro (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_call_last_kbd_macro */

#if 0
#ifdef HAVE_rl_push_macro_input
/* From `/usr/include/readline/readline.h:127'.  */
void chkr_stub_rl_push_macro_input (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_push_macro_input"));
void
chkr_stub_rl_push_macro_input (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_push_macro_input);
#else
  rl_push_macro_input (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_push_macro_input */
#endif

#ifdef HAVE_rl_arrow_keys
/* From `/usr/include/readline/readline.h:129'.  */
int chkr_stub_rl_arrow_keys (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_arrow_keys"));
int
chkr_stub_rl_arrow_keys (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_arrow_keys);
#else
  return rl_arrow_keys (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_arrow_keys */

#ifdef HAVE_rl_refresh_line
/* From `/usr/include/readline/readline.h:129'.  */
int chkr_stub_rl_refresh_line (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_refresh_line"));
int
chkr_stub_rl_refresh_line (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_refresh_line);
#else
  return rl_refresh_line (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_refresh_line */

#ifdef HAVE_readline
/* From `/usr/include/readline/readline.h:139'.  */
char * chkr_stub_readline (char * arg0) __asm__ (CHKR_PREFIX ("readline"));
char *
chkr_stub_readline (char * arg0)
{
  char *res;
  stubs_chkr_check_str (arg0, CHKR_RO, "prompt");
  res = readline (arg0);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_readline */

#ifdef HAVE_rl_add_defun
/* From `/usr/include/readline/readline.h:146'.  */
int chkr_stub_rl_add_defun (char * arg0, Function * arg1, int arg2) __asm__ (CHKR_PREFIX ("rl_add_defun"));
int
chkr_stub_rl_add_defun (char * arg0, Function * arg1, int arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "name");
  stubs_chkr_check_exec (arg1, "function");
#if USE_BI_JUMP
  __builtin_jump (rl_add_defun);
#else
  return rl_add_defun (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_add_defun */

#ifdef HAVE_rl_get_keymap_name
/* From `/usr/include/readline/readline.h:154'.  */
char * chkr_stub_rl_get_keymap_name (Keymap arg0) __asm__ (CHKR_PREFIX ("rl_get_keymap_name"));
char *
chkr_stub_rl_get_keymap_name (Keymap arg0)
{
  char * res;
  stubs_chkr_check_addr (arg0, sizeof (*arg0), CHKR_RO, "keymap");
  res = rl_get_keymap_name (arg0);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_rl_get_keymap_name */

#ifdef HAVE_rl_bind_key
/* From `/usr/include/readline/readline.h:156'.  */
int chkr_stub_rl_bind_key (int arg0, Function * arg1) __asm__ (CHKR_PREFIX ("rl_bind_key"));
int
chkr_stub_rl_bind_key (int arg0, Function * arg1)
{
  stubs_chkr_check_exec (arg1, "function");
#if USE_BI_JUMP
  __builtin_jump (rl_bind_key);
#else
  return rl_bind_key (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_bind_key */

#ifdef HAVE_rl_bind_key_in_map
/* From `/usr/include/readline/readline.h:156'.  */
int chkr_stub_rl_bind_key_in_map (int arg0, Function * arg1, Keymap arg2) __asm__ (CHKR_PREFIX ("rl_bind_key_in_map"));
int
chkr_stub_rl_bind_key_in_map (int arg0, Function * arg1, Keymap arg2)
{
  stubs_chkr_check_addr (arg2, sizeof (*arg2), CHKR_RO, "keymap");
  stubs_chkr_check_exec (arg1, "function");
#if USE_BI_JUMP
  __builtin_jump (rl_bind_key_in_map);
#else
  return rl_bind_key_in_map (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_bind_key_in_map */

#ifdef HAVE_rl_unbind_key
/* From `/usr/include/readline/readline.h:157'.  */
int chkr_stub_rl_unbind_key (int arg0) __asm__ (CHKR_PREFIX ("rl_unbind_key"));
int
chkr_stub_rl_unbind_key (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_unbind_key);
#else
  return rl_unbind_key (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_unbind_key */

#ifdef HAVE_rl_unbind_key_in_map
/* From `/usr/include/readline/readline.h:157'.  */
int chkr_stub_rl_unbind_key_in_map (int arg0, Keymap arg1) __asm__ (CHKR_PREFIX ("rl_unbind_key_in_map"));
int
chkr_stub_rl_unbind_key_in_map (int arg0, Keymap arg1)
{
  stubs_chkr_check_addr (arg1, sizeof (*arg1), CHKR_RO, "keymap");
#if USE_BI_JUMP
  __builtin_jump (rl_unbind_key_in_map);
#else
  return rl_unbind_key_in_map (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_unbind_key_in_map */

#ifdef HAVE_rl_set_key
/* From `/usr/include/readline/readline.h:158'.  */
int chkr_stub_rl_set_key (char * arg0, Function * arg1, Keymap arg2) __asm__ (CHKR_PREFIX ("rl_set_key"));
int
chkr_stub_rl_set_key (char * arg0, Function * arg1, Keymap arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "name");
  stubs_chkr_check_exec (arg1, "function");
  stubs_chkr_check_addr (arg2, sizeof (*arg2), CHKR_RO, "keymap");
#if USE_BI_JUMP
  __builtin_jump (rl_set_key);
#else
  return rl_set_key (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_set_key */

#ifdef HAVE_rl_generic_bind
/* From `/usr/include/readline/readline.h:159'.  */
int chkr_stub_rl_generic_bind (int arg0, char * arg1, char * arg2, Keymap arg3) __asm__ (CHKR_PREFIX ("rl_generic_bind"));
int
chkr_stub_rl_generic_bind (int arg0, char * arg1, char * arg2, Keymap arg3)
{
  stubs_chkr_check_str (arg1, CHKR_RO, "keyseq");
  stubs_chkr_check_addr (arg3, sizeof (*arg3), CHKR_RO, "keymap");
#if USE_BI_JUMP
  __builtin_jump (rl_generic_bind);
#else
  return rl_generic_bind (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_generic_bind */

#ifdef HAVE_rl_parse_and_bind
/* From `/usr/include/readline/readline.h:160'.  */
int chkr_stub_rl_parse_and_bind (char * arg0) __asm__ (CHKR_PREFIX ("rl_parse_and_bind"));
int
chkr_stub_rl_parse_and_bind (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "line");
#if USE_BI_JUMP
  __builtin_jump (rl_parse_and_bind);
#else
  return rl_parse_and_bind (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_parse_and_bind */

#ifdef HAVE_rl_macro_bind
/* From `/usr/include/readline/readline.h:162'.  */
int chkr_stub_rl_macro_bind (char * arg0, char * arg1, Keymap arg2) __asm__ (CHKR_PREFIX ("rl_macro_bind"));
int
chkr_stub_rl_macro_bind (char * arg0, char * arg1, Keymap arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "keyseq");
  stubs_chkr_check_str (arg1, CHKR_RO, "macro");
  stubs_chkr_check_addr (arg2, sizeof (*arg2), CHKR_RO, "keymap");
#if USE_BI_JUMP
  __builtin_jump (rl_macro_bind);
#else
  return rl_macro_bind (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_macro_bind */

#ifdef HAVE_rl_variable_bind
/* From `/usr/include/readline/readline.h:162'.  */
int chkr_stub_rl_variable_bind (char * arg0, char * arg1) __asm__ (CHKR_PREFIX ("rl_variable_bind"));
int
chkr_stub_rl_variable_bind (char * arg0, char * arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "name");
  stubs_chkr_check_str (arg1, CHKR_RO, "value");
#if USE_BI_JUMP
  __builtin_jump (rl_variable_bind);
#else
  return rl_variable_bind (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_variable_bind */

#ifdef HAVE_rl_read_init_file
/* From `/usr/include/readline/readline.h:164'.  */
int chkr_stub_rl_read_init_file (char * arg0) __asm__ (CHKR_PREFIX ("rl_read_init_file"));
int
chkr_stub_rl_read_init_file (char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_str (arg0, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (rl_read_init_file);
#else
  return rl_read_init_file (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_read_init_file */

#ifdef HAVE_rl_named_function
/* From `/usr/include/readline/readline.h:166'.  */
Function * chkr_stub_rl_named_function (char * arg0) __asm__ (CHKR_PREFIX ("rl_named_function"));
Function *
chkr_stub_rl_named_function (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (rl_named_function);
#else
  return rl_named_function (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_named_function */

#ifdef HAVE_rl_function_of_keyseq
/* From `/usr/include/readline/readline.h:166'.  */
Function * chkr_stub_rl_function_of_keyseq (char * arg0, Keymap arg1, int * arg2) __asm__ (CHKR_PREFIX ("rl_function_of_keyseq"));
Function *
chkr_stub_rl_function_of_keyseq (char * arg0, Keymap arg1, int * arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "keyseq");
  stubs_chkr_check_addr (arg1, sizeof (*arg1), CHKR_RO, "keymap");
  if (arg2)
    stubs_chkr_check_addr (arg2, sizeof (int), CHKR_WO, "type");
#if USE_BI_JUMP
  __builtin_jump (rl_function_of_keyseq);
#else
  return rl_function_of_keyseq (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_function_of_keyseq */

#ifdef HAVE_rl_invoking_keyseqs
/* From `/usr/include/readline/readline.h:167'.  */
char ** chkr_stub_rl_invoking_keyseqs (Function * arg0) __asm__ (CHKR_PREFIX ("rl_invoking_keyseqs"));
char **
chkr_stub_rl_invoking_keyseqs (Function * arg0)
{
  char ** res;

  stubs_chkr_check_exec (arg0, "function");
  res = rl_invoking_keyseqs (arg0);
  if (res)
    {
      char **iter;

      for (iter = res; ; iter++)
	{
	  stubs_chkr_set_right (iter, sizeof (char *), CHKR_RW);
	  if (*iter)
	    stubs_chkr_set_right (*iter, strlen (*iter) + 1, CHKR_RW);
	  else
	    break;
	}
    }
  return res;
}
#endif /* HAVE_rl_invoking_keyseqs */

#ifdef HAVE_rl_invoking_keyseqs_in_map
/* From `/usr/include/readline/readline.h:167'.  */
char ** chkr_stub_rl_invoking_keyseqs_in_map (Function * arg0, Keymap arg1) __asm__ (CHKR_PREFIX ("rl_invoking_keyseqs_in_map"));
char **
chkr_stub_rl_invoking_keyseqs_in_map (Function * arg0, Keymap arg1)
{
  char ** res;

  stubs_chkr_check_exec (arg0, "function");
  stubs_chkr_check_addr (arg1, sizeof (*arg1), CHKR_RO, "keymap");
  res = rl_invoking_keyseqs (arg0);
  if (res)
    {
      char **iter;

      for (iter = res; ; iter++)
	{
	  stubs_chkr_set_right (iter, sizeof (char *), CHKR_RW);
	  if (*iter)
	    stubs_chkr_set_right (*iter, strlen (*iter) + 1, CHKR_RW);
	  else
	    break;
	}
    }
  return res;
}
#endif /* HAVE_rl_invoking_keyseqs_in_map */

#ifdef HAVE_rl_function_dumper
/* From `/usr/include/readline/readline.h:168'.  */
void chkr_stub_rl_function_dumper (int arg0) __asm__ (CHKR_PREFIX ("rl_function_dumper"));
void
chkr_stub_rl_function_dumper (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_function_dumper);
#else
  rl_function_dumper (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_function_dumper */

#ifdef HAVE_rl_variable_dumper
/* From `/usr/include/readline/readline.h:169'.  */
void chkr_stub_rl_variable_dumper (int arg0) __asm__ (CHKR_PREFIX ("rl_variable_dumper"));
void
chkr_stub_rl_variable_dumper (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_variable_dumper);
#else
  rl_variable_dumper (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_variable_dumper */

#ifdef HAVE_rl_macro_dumper
/* From `/usr/include/readline/readline.h:170'.  */
void chkr_stub_rl_macro_dumper (int arg0) __asm__ (CHKR_PREFIX ("rl_macro_dumper"));
void
chkr_stub_rl_macro_dumper (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_macro_dumper);
#else
  rl_macro_dumper (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_macro_dumper */

#ifdef HAVE_rl_list_funmap_names
/* From `/usr/include/readline/readline.h:171'.  */
void chkr_stub_rl_list_funmap_names (void ) __asm__ (CHKR_PREFIX ("rl_list_funmap_names"));
void
chkr_stub_rl_list_funmap_names (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_list_funmap_names);
#else
  rl_list_funmap_names ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_list_funmap_names */

#ifdef HAVE_rl_translate_keyseq
/* From `/usr/include/readline/readline.h:174'.  */
int chkr_stub_rl_translate_keyseq (char * arg0, char * arg1, int * arg2) __asm__ (CHKR_PREFIX ("rl_translate_keyseq"));
int
chkr_stub_rl_translate_keyseq (char * arg0, char * arg1, int * arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_WO, "len");
#if USE_BI_JUMP
  __builtin_jump (rl_translate_keyseq);
#else
  return rl_translate_keyseq (arg0, arg1, arg2);
  {
    int res;
    res = rl_translate_keyseq (arg0, arg1, arg2);
    if (*arg2)
      stubs_chkr_check_addr (arg1, *arg2 + 1, CHKR_WO, "array");
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_translate_keyseq */

#ifdef HAVE_rl_initialize_funmap
/* From `/usr/include/readline/readline.h:175'.  */
void chkr_stub_rl_initialize_funmap (void ) __asm__ (CHKR_PREFIX ("rl_initialize_funmap"));
void
chkr_stub_rl_initialize_funmap (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_initialize_funmap);
#else
  rl_initialize_funmap ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_initialize_funmap */

#ifdef HAVE_rl_begin_undo_group
/* From `/usr/include/readline/readline.h:178'.  */
int chkr_stub_rl_begin_undo_group (void ) __asm__ (CHKR_PREFIX ("rl_begin_undo_group"));
int
chkr_stub_rl_begin_undo_group (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_begin_undo_group);
#else
  return rl_begin_undo_group ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_begin_undo_group */

#ifdef HAVE_rl_end_undo_group
/* From `/usr/include/readline/readline.h:178'.  */
int chkr_stub_rl_end_undo_group (void ) __asm__ (CHKR_PREFIX ("rl_end_undo_group"));
int
chkr_stub_rl_end_undo_group (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_end_undo_group);
#else
  return rl_end_undo_group ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_end_undo_group */

#ifdef HAVE_rl_add_undo
/* From `/usr/include/readline/readline.h:179'.  */
void chkr_stub_rl_add_undo (enum undo_code arg0, int arg1, int arg2, char * arg3) __asm__ (CHKR_PREFIX ("rl_add_undo"));
void
chkr_stub_rl_add_undo (enum undo_code arg0, int arg1, int arg2, char * arg3)
{
  stubs_chkr_check_str (arg3, CHKR_RO, "text");
#if USE_BI_JUMP
  __builtin_jump (rl_add_undo);
#else
  rl_add_undo (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_add_undo */

#ifdef HAVE_free_undo_list
/* From `/usr/include/readline/readline.h:179'.  */
void chkr_stub_free_undo_list (void ) __asm__ (CHKR_PREFIX ("free_undo_list"));
void
chkr_stub_free_undo_list (void )
{
#if USE_BI_JUMP
  __builtin_jump (free_undo_list);
#else
  free_undo_list ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_free_undo_list */

#ifdef HAVE_rl_do_undo
/* From `/usr/include/readline/readline.h:180'.  */
int chkr_stub_rl_do_undo (void ) __asm__ (CHKR_PREFIX ("rl_do_undo"));
int
chkr_stub_rl_do_undo (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_do_undo);
#else
  return rl_do_undo ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_do_undo */

#ifdef HAVE_rl_modifying
/* From `/usr/include/readline/readline.h:181'.  */
int chkr_stub_rl_modifying (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_modifying"));
int
chkr_stub_rl_modifying (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_modifying);
#else
  return rl_modifying (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_modifying */

#ifdef HAVE_rl_redisplay
/* From `/usr/include/readline/readline.h:184'.  */
void chkr_stub_rl_redisplay (void ) __asm__ (CHKR_PREFIX ("rl_redisplay"));
void
chkr_stub_rl_redisplay (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_redisplay);
#else
  rl_redisplay ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_redisplay */

#ifdef HAVE_rl_forced_update_display
/* From `/usr/include/readline/readline.h:185'.  */
int chkr_stub_rl_forced_update_display (void ) __asm__ (CHKR_PREFIX ("rl_forced_update_display"));
int
chkr_stub_rl_forced_update_display (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_forced_update_display);
#else
  return rl_forced_update_display ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_forced_update_display */

#ifdef HAVE_rl_clear_message
/* From `/usr/include/readline/readline.h:186'.  */
int chkr_stub_rl_clear_message (void ) __asm__ (CHKR_PREFIX ("rl_clear_message"));
int
chkr_stub_rl_clear_message (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_clear_message);
#else
  return rl_clear_message ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_clear_message */

#ifdef HAVE_rl_reset_line_state
/* From `/usr/include/readline/readline.h:187'.  */
int chkr_stub_rl_reset_line_state (void ) __asm__ (CHKR_PREFIX ("rl_reset_line_state"));
int
chkr_stub_rl_reset_line_state (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_reset_line_state);
#else
  return rl_reset_line_state ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_reset_line_state */

#ifdef HAVE_rl_on_new_line
/* From `/usr/include/readline/readline.h:188'.  */
int chkr_stub_rl_on_new_line (void) __asm__ (CHKR_PREFIX ("rl_on_new_line"));
int
chkr_stub_rl_on_new_line (void)
{
#if USE_BI_JUMP
  __builtin_jump (rl_on_new_line);
#else
  return rl_on_new_line ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_on_new_line */

#ifdef HAVE_rl_message
/* From `/usr/include/readline/readline.h:193'.  */
int chkr_stub_rl_message (void ) __asm__ (CHKR_PREFIX ("rl_message"));
int
chkr_stub_rl_message (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_message);
#else
  return rl_message ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_message */

#ifdef HAVE_rl_character_len
/* From `/usr/include/readline/readline.h:197'.  */
int chkr_stub_rl_character_len (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_character_len"));
int
chkr_stub_rl_character_len (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_character_len);
#else
  return rl_character_len (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_character_len */

#ifdef HAVE_rl_show_char
/* From `/usr/include/readline/readline.h:198'.  */
int chkr_stub_rl_show_char (int arg0) __asm__ (CHKR_PREFIX ("rl_show_char"));
int
chkr_stub_rl_show_char (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_show_char);
#else
  return rl_show_char (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_show_char */

#ifdef HAVE_crlf
/* From `/usr/include/readline/readline.h:199'.  */
int chkr_stub_crlf (void ) __asm__ (CHKR_PREFIX ("crlf"));
int
chkr_stub_crlf (void )
{
#if USE_BI_JUMP
  __builtin_jump (crlf);
#else
  return crlf ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_crlf */

#ifdef HAVE_rl_insert_text
/* From `/usr/include/readline/readline.h:202'.  */
int chkr_stub_rl_insert_text (char * arg0) __asm__ (CHKR_PREFIX ("rl_insert_text"));
int
chkr_stub_rl_insert_text (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (rl_insert_text);
#else
  return rl_insert_text (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_insert_text */

#ifdef HAVE_rl_delete_text
/* From `/usr/include/readline/readline.h:202'.  */
int chkr_stub_rl_delete_text (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_delete_text"));
int
chkr_stub_rl_delete_text (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_delete_text);
#else
  return rl_delete_text (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_delete_text */

#ifdef HAVE_rl_kill_text
/* From `/usr/include/readline/readline.h:203'.  */
int chkr_stub_rl_kill_text (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_kill_text"));
int
chkr_stub_rl_kill_text (int arg0, int arg1)
{
#if USE_BI_JUMP
  __builtin_jump (rl_kill_text);
#else
  return rl_kill_text (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_kill_text */

#ifdef HAVE_rl_copy_text
/* From `/usr/include/readline/readline.h:204'.  */
char * chkr_stub_rl_copy_text (int arg0, int arg1) __asm__ (CHKR_PREFIX ("rl_copy_text"));
char *
chkr_stub_rl_copy_text (int arg0, int arg1)
{
  char * res;
  res = rl_copy_text (arg0, arg1);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_rl_copy_text */

#ifdef HAVE_rl_reset_terminal
/* From `/usr/include/readline/readline.h:207'.  */
int chkr_stub_rl_reset_terminal (char * arg0) __asm__ (CHKR_PREFIX ("rl_reset_terminal"));
int
chkr_stub_rl_reset_terminal (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "terminal_name");
#if USE_BI_JUMP
  __builtin_jump (rl_reset_terminal);
#else
  return rl_reset_terminal (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_reset_terminal */

#ifdef HAVE_rl_stuff_char
/* From `/usr/include/readline/readline.h:208'.  */
int chkr_stub_rl_stuff_char (int arg0) __asm__ (CHKR_PREFIX ("rl_stuff_char"));
int
chkr_stub_rl_stuff_char (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_stuff_char);
#else
  return rl_stuff_char (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_stuff_char */

#ifdef HAVE_rl_read_key
/* From `/usr/include/readline/readline.h:209'.  */
int chkr_stub_rl_read_key (void ) __asm__ (CHKR_PREFIX ("rl_read_key"));
int
chkr_stub_rl_read_key (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_read_key);
#else
  return rl_read_key ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_read_key */

#ifdef HAVE_rl_getc
#define CHKR_CHECK_STREAM(s) stubs_chkr_check_addr (s, sizeof (FILE), CHKR_TW, "stream")

/* From `/usr/include/readline/readline.h:209'.  */
int chkr_stub_rl_getc (FILE * arg0) __asm__ (CHKR_PREFIX ("rl_getc"));
int
chkr_stub_rl_getc (FILE * arg0)
{
  CHKR_CHECK_STREAM (arg0);
#if USE_BI_JUMP
  __builtin_jump (rl_getc);
#else
  return rl_getc (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_getc */

#ifdef HAVE_rl_initialize
/* From `/usr/include/readline/readline.h:211'.  */
int chkr_stub_rl_initialize (void ) __asm__ (CHKR_PREFIX ("rl_initialize"));
int
chkr_stub_rl_initialize (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_initialize);
#else
  return rl_initialize ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_initialize */

#ifdef HAVE_rl_expand_prompt
/* From `/usr/include/readline/readline.h:214'.  */
int chkr_stub_rl_expand_prompt (char * arg0) __asm__ (CHKR_PREFIX ("rl_expand_prompt"));
int
chkr_stub_rl_expand_prompt (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "prompt");
#if USE_BI_JUMP
  __builtin_jump (rl_expand_prompt);
#else
  return rl_expand_prompt (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_expand_prompt */

#ifdef HAVE_rl_set_signals
/* From `/usr/include/readline/readline.h:215'.  */
int chkr_stub_rl_set_signals (void ) __asm__ (CHKR_PREFIX ("rl_set_signals"));
int
chkr_stub_rl_set_signals (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_set_signals);
#else
  return rl_set_signals ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_set_signals */

#ifdef HAVE_rl_clear_signals
/* From `/usr/include/readline/readline.h:215'.  */
int chkr_stub_rl_clear_signals (void ) __asm__ (CHKR_PREFIX ("rl_clear_signals"));
int
chkr_stub_rl_clear_signals (void )
{
#if USE_BI_JUMP
  __builtin_jump (rl_clear_signals);
#else
  return rl_clear_signals ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_clear_signals */

#ifdef HAVE_maybe_save_line
/* From `/usr/include/readline/readline.h:216'.  */
int chkr_stub_maybe_save_line (void ) __asm__ (CHKR_PREFIX ("maybe_save_line"));
int
chkr_stub_maybe_save_line (void )
{
#if USE_BI_JUMP
  __builtin_jump (maybe_save_line);
#else
  return maybe_save_line ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_maybe_save_line */

#ifdef HAVE_maybe_unsave_line
/* From `/usr/include/readline/readline.h:216'.  */
int chkr_stub_maybe_unsave_line (void ) __asm__ (CHKR_PREFIX ("maybe_unsave_line"));
int
chkr_stub_maybe_unsave_line (void )
{
#if USE_BI_JUMP
  __builtin_jump (maybe_unsave_line);
#else
  return maybe_unsave_line ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_maybe_unsave_line */

#ifdef HAVE_maybe_replace_line
/* From `/usr/include/readline/readline.h:216'.  */
int chkr_stub_maybe_replace_line (void ) __asm__ (CHKR_PREFIX ("maybe_replace_line"));
int
chkr_stub_maybe_replace_line (void )
{
#if USE_BI_JUMP
  __builtin_jump (maybe_replace_line);
#else
  return maybe_replace_line ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_maybe_replace_line */

#ifdef HAVE_rl_complete_internal
/* From `/usr/include/readline/readline.h:220'.  */
int chkr_stub_rl_complete_internal (int arg0) __asm__ (CHKR_PREFIX ("rl_complete_internal"));
int
chkr_stub_rl_complete_internal (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (rl_complete_internal);
#else
  return rl_complete_internal (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rl_complete_internal */

#ifdef HAVE_completion_matches
/* From `/usr/include/readline/readline.h:224'.  */
char ** chkr_stub_completion_matches (char * arg0, CPFunction * arg1) __asm__ (CHKR_PREFIX ("completion_matches"));
char **
chkr_stub_completion_matches (char * arg0, CPFunction * arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "text");
  stubs_chkr_check_exec (arg1, "entry_func");
  {
    char ** res;
    res = completion_matches (arg0, arg1);
    if (res)
      {
	char **iter;

	for (iter = res; ; iter++)
	  {
	    stubs_chkr_set_right (iter, sizeof (char *), CHKR_RW);
	    if (*iter)
	      stubs_chkr_set_right (*iter, strlen (*iter) + 1, CHKR_RW);
	    else
	      break;
	  }
      }
    return res;
  }
}
#endif /* HAVE_completion_matches */

#ifdef HAVE_username_completion_function
/* From `/usr/include/readline/readline.h:225'.  */
char * chkr_stub_username_completion_function (char * arg0, int arg1) __asm__ (CHKR_PREFIX ("username_completion_function"));
char *
chkr_stub_username_completion_function (char * arg0, int arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "text");
  {
    char * res;
    res = username_completion_function (arg0, arg1);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
    return res;
  }
}
#endif /* HAVE_username_completion_function */

#ifdef HAVE_filename_completion_function
/* From `/usr/include/readline/readline.h:226'.  */
char * chkr_stub_filename_completion_function (char * arg0, int arg1) __asm__ (CHKR_PREFIX ("filename_completion_function"));
char *
chkr_stub_filename_completion_function (char * arg0, int arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "text");
  {
    char * res;
    res = filename_completion_function (arg0, arg1);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
    return res;
  }
}
#endif /* HAVE_filename_completion_function */

