package GCPlugins::GCAmazonDE;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAmazonDE;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "b")
            {
                print "Got B ",$attr->{class},"\n";
                if ($attr->{class} eq 'h3color')
                {
                    $self->{insideH3Color} = 1;
                }
                else
                {
                    $self->{insideH3Color} = 0;
                }
            }
            return if ! $self->{parsingRealList};

            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=/)
                {
                    my $url = $attr->{href}; 
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
						elsif ($tagname eq "div")
						{
							$self->{isYear} = 1 if $attr->{class} eq "year";
						}
						elsif ($tagname eq "font")
						{
							$self->{isActors} = 1 if (($attr->{face} eq "verdana,arial,helvetica") && ($attr->{size} eq "-1"));
						}
        }
        else
        {
						if ($tagname eq "a")
						{
								if ($attr->{href} =~ /^http\:\/\/images-eu\.amazon\.com\/images\/P\/[A-Z0-9]*\.[0-9]*\.LZZZZZZZ\.jpg/)
								{
									$self->{curInfo}->{image} = $attr->{href};
								}
						}
						elsif ($tagname eq "b")
						{
							$self->{insideName} = 1 if $attr->{class} eq "sans";
						}
						elsif ($tagname eq "div")
						{
							$self->{insideSynopsis} = 1 if $attr->{class} eq "synopsis";
						}
						elsif ($tagname eq "ul")
						{
							$self->{insideInfos} = 1 if $attr->{class} eq "small";
						}
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            #print "Orig : $origtext\n";
        
            $self->{parsingRealList} = 1
                if ($self->{insideH3Color}) && ($origtext =~ /Alle [0-9]* Treffer f.r/);

            return if ! $self->{parsingRealList};

            if ($self->{isMovie})
            {
								$origtext =~ s/\n//g;
								$origtext =~ s/^\s*//;
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
						elsif ($self->{isYear})
						{
								$self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext;
								$self->{isYear} = 0;
						}
						elsif ($self->{isActors})
						{
							if ($origtext =~ /mit.(.*)/)
							{
								$self->{movieList}[$self->{movieIdx}]->{"actors"} = $1;
							}
								$self->{isActors} = 0;
						}
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;
            $origtext =~ s/\n//g if !$self->{insideSynopsis};

           	if ($self->{insideName})
           	{
							$origtext =~ s/\[endline\]//g;
          	  $self->{curInfo}->{title} = $origtext if !$self->{curInfo}->{title};
							$self->{insideName} = 0;
						}
            elsif ($self->{insideSynopsis})
            {
							$origtext =~ s/\[endline\]/\n/g;
            	$origtext =~ s/^\n*//g;
		          $self->{curInfo}->{synopsis} = $origtext;
							$self->{insideSynopsis} = 0;
						}
						elsif ($self->{insideInfos})
						{
							if ($origtext =~ /DVD Erscheinungstermin\:.(.*)/)
            	{
		       	 	  $self->{curInfo}->{date} = $1;
							}
           	 	elsif ($origtext =~ /Darsteller\:(.*)/)
           	 	{
		       	 	  ($self->{curInfo}->{actors} = $1) =~ s/,$//;
					   	}
           	 	if ($origtext =~ /Regie\:(.*)/)
           	 	{
		       	 	  ($self->{curInfo}->{director} = $1) =~ s/, $//;
					   	}
						}
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s/<b class="h1">([^<]*)<\/b>/$1/g;
        $html =~ s/<b>|<\/b>|<i>|<\/i>|<span class="(small|serif)">|<\/span>|<\/form>//gi;
        $html =~ s/<a href=\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-[0-9]*\/ref=sr_[0-9]*_[0-9]*_[0-9]*\/[0-9]*-[0-9]*-[0-9]*><img src="http\:\/\/images-eu\.amazon\.com\/images\/[A-Z]\/([A-Z0-9]*\.[0-9]*\.THUMBZZZ\.jpg|[0-9]*\/general\/no-img-de_[0-9]*x[0-9]*.gif)" width=[0-9]* height=[0-9]* border=0><\/a>//g;
        $html =~ s/<a href="\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-[0-9]*\/ref=sr_sp_bow\/[0-9]*-[0-9]*-[0-9]*">//g;
        $html =~ s/<p>|<\/p>|<br>/\[endline\]/gi;
        $html =~ s/\[endline\].Erscheinungstermin ([0-9]{1,2}?\.? ?\S* ?[0-9]{4})\[endline\]\n[A-Z]*\n\[endline\].(<font color=#990000> )?<font face=verdana,arial,helvetica size=-1>/<div class="year">$1<\/div>\n$2<font face=verdana,arial,helvetica size=-1>/g;
        $html =~ s/<a href="?\/exec\/obidos\/ASIN\/[A-Z0-9]*\/[0-9]*-[0-9]*-[0-9]*"?>([^<]*)<\/a>/$1/g;
        $html =~ s/<img src="http\:\/\/g-images\.amazon\.com\/images\/[^"]*"[^>]*>//g;
        #"
        $html =~ s/<a href="?\/exec\/obidos\/tg\/?[a-z0-9]*\/detail\/-\/?[a-z0-9]*\/[A-Z0-9]*\/?[a-z0-9]*\/[0-9]*-[0-9]*-[0-9]*[^>]*"?>([^<]*)<\/a>/$1/g;
        $html =~ s/<a name="[a-z0-9]*">//g;
        $html =~ s/<a name="amzn-reviews">Rezensionen\[endline\]<\/a>([^<]*)/<div class="synopsis">$1<\/div>\n/g;
        $html =~ s/<a href="\/exec\/obidos\/search-handle-url\/index=(?:video-)?dvd-de&field-(?:actor|director)=[^\/]*\/ref=sr_sp_dp_[0-9]*_[0-9]*\/[0-9]*-[0-9]*-[0-9]*">([^<]*)<\/a>,?/$1,/g;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.amazon.de/exec/obidos/search-handle-url/index=dvd-de&field-keywords=$word/028-8412067-4725342";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.amazon.de" . $url;
    }

    sub getName
    {
        return "Amazon.de";
    }
    
    sub getImageFile
    {
        return "amazon.de.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }

    sub getLang
    {
        return 'DE';
    }
    
    sub hasSearchDirector
    {
        return 0;
    }
}

1;
