package GCPlugins::GCPluginsBase;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

{
    package GCPluginParser;
    use base qw(HTML::Parser);
    use LWP::Simple qw($ua get);
    use URI::Escape;
    use HTML::Entities;
    use Encode;

    our $MAX_ACTORS = 6;
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        $self->{MAX_ACTORS} = 6;
        $ua->agent('Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.7.5) Gecko/20041111 Firefox/1.0');
        
        $self->{movieIdx} = -1;
        $self->{movieList} = ();
        
        bless ($self, $class);
        return $self;
    }

    sub getMoviesNumber
    {
        my ($self) = @_;

        return $self->{movieIdx} + 1;
    }

    sub getMovies
    {
        my ($self) = @_;
        return @{$self->{movieList}};
    }

    sub load
    {
        my $self = shift;
        
        $self->checkProxy;
         
        $self->{movieIdx} = -1;
        $self->{isInfo} = 0;
        $self->{movieList} = ();

        my $word = uri_escape($self->{title});
        $word =~ s/%20/+/g;

        my $url = $self->getSearchUrl($word);
        my $html = get($url);
        $self->{parsingList} = 1;
        $html = $self->preProcess($html);
        decode_entities($html);
        $self->{inside} = undef;
        $self->parse($html);
        
        for my $i(0..$self->{movieIdx})
        {
            $self->{movieList}->[$i]->{title} = $self->convertCharset($self->{movieList}->[$i]->{title});
        }
    }
    
    sub capWord
    {
        my ($self, $msg) = @_;
        
        use locale;
        
        (my $newmsg = lc $msg) =~ s/(\s|^)(\w)(\w)(\w*?)/$1\U$2\E$3$4/gi;
        return $newmsg;
    }

    sub hasSearchYear
    {
        return 1;
    }

    sub hasSearchDirector
    {
        return 1;
    }

    sub hasSearchActors
    {
        return 1;
    }

    sub getExtra
    {
        return '';
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }
    
    sub convertCharset
    {
        my ($self, $string) = @_;

        my $result = $string;

        $result = decode($self->getCharset, $result);

        # FIXME: Without this, there are some problems on Mandrake
        #use Encode 'decode_utf8';
        #if (decode_utf8($result))
        #{
        #    $result = decode_utf8($result);
        #}
        
        return $result;
    }
    
    sub getMovieInfo
    {
        my $self = shift;

        my $idx = $self->{wantedIdx};
        my $url = $self->getMovieUrl($self->{movieList}[$idx]->{'url'});
        
        $self->loadUrl($url);
    }
        
    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }
        
    sub loadUrl
    {
        my ($self, $url) = @_;
        
        $self->checkProxy;
        
        $url = $self->changeUrl($url);
        
        my $html = get($url);
        $self->{parsingList} = 0;
        #$html = $self->convertCharset($html);
        $html = $self->preProcess($html);
        decode_entities($html);
        $self->{curInfo} = {};
        $self->{curInfo}->{title} = '';
        $self->{curInfo}->{director} = '';
        $self->{curInfo}->{orig} = '';
        $self->{curInfo}->{actors} = '';
        $self->{curInfo}->{type} = '';
        $self->{curInfo}->{nat} = '';
        $self->{curInfo}->{date} = '';
        $self->{curInfo}->{time} = '';
        $self->{curInfo}->{synopsis} = '';
        $self->{curInfo}->{image} = '';
        $self->{curInfo}->{age} = 0;
        $self->{curInfo}->{audio} = '';
        $self->{curInfo}->{subt} = '';
                
        $self->{actorsCounter} = 0;
        $self->{curInfo}->{url} = $url;
        $self->{inside} = undef;
        $self->parse($html);

        if (! $self->{curInfo}->{title} && $self->{curInfo}->{orig})
        {
            $self->{curInfo}->{title} = $self->{curInfo}->{orig};
            $self->{curInfo}->{orig} = '';
        }
        
        
        
        foreach (keys %{$self->{curInfo}})
        {
            next if $_ eq 'url';
            $self->{curInfo}->{$_} = $self->convertCharset($self->{curInfo}->{$_});
            $self->{curInfo}->{$_} =~ s/\|/,/gm;
            $self->{curInfo}->{$_} =~ s/\r//gm;
        }
        
        return $self->{curInfo};
    }

    sub setProxy
    {
		my ($self, $proxy) = @_;
		
		$self->{proxy} = $proxy;
		#$ua->proxy(['http'], $proxy);
    }
    
    sub checkProxy
    {
        my $self = shift;
        $ua->proxy(['http'], $self->{proxy});
    }
    
}

1;