package GCPlugins::GCstar::GCAmazonCommon;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCstar::GCPluginAmazonCommon;

    sub extractImage
    {
        my ($self, $url) = @_;
        return 'http://images.amazon.com/images/P/'.$1.$2.'MZZZZZZZ.jpg'
            if ($url =~ m%^http://.*?images[.-]amazon\.com/images/P/([A-Z0-9]*)(\.[0-9]+\.)?[-A-Za-z0-9_.,]*?ZZZZZZZ(.*?)\.(jpg|gif)%);
        return '';
    }

    sub isEAN
    {
        my ($self, $value) = @_;
        
        my $l = length($value);
        return 1
            if ($l == 8)
            || ($l == 13)
            || ($l == 15)
            || ($l == 18);
        return 0;
    }

    sub getSearchUrl
    {
        my ($self, $word) = @_;
        if ($self->{searchField} eq $self->{codeField})
        {
            (my $code = $word) =~ s/\D//g;
            return ('http://s1.amazon.'.$self->{suffix}.'/exec/varzea/sdp/sai-condition/', ['sdp-sai-asin' => $code])
                if $self->isEAN($code);
                # =~ /^978/;
        }
        return "http://www.amazon.".$self->{suffix}."/gp/search/?redirect=true&search-alias=".$self->{searchType}."&keywords=$word";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
        return 'http://www.amazon.'.$self->{suffix} if !$url;
        return $url;
    }

    sub getImageFile
    {
        return "amazon.png";
    }

    sub getAuthor
    {
        return 'Tian';
    }
}

1;
