/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- June 1998
 */

/*
 * CvsIgnore.h --- parse the .cvsignore
 */

#ifndef CVSIGNORE_H
#define CVSIGNORE_H

#include <vector>
#include "CPStr.h"

#ifdef _MSC_VER
	using namespace std;
#endif

void BuildIgnoredList(std::vector<CStr> & ignlist, const char *path);
	// open and parse the .cvsignore in the current folder

bool MatchIgnoredList(const char * filename, const std::vector<CStr> & ignlist);
	// tells if the name match the .cvsignore

#endif /* CVSIGNORE_H */
