/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- July 1998
 */

/*
 * TagDlg.cpp : the cvs tag dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "GetPrefs.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LCheckBox.h>
#	include <LEditText.h>
#	include <LPopupGroupBox.h>
#	include <LRadioButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsConstant.h"
#endif /* qMacCvsPP */

#include "TagDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32

/////////////////////////////////////////////////////////////////////////////
// CTag_MAIN property page

IMPLEMENT_DYNCREATE(CTag_MAIN, CPropertyPage)

CTag_MAIN::CTag_MAIN(kTagDlgType type, 
		const char* sLastTag, 
		bool noRecurs, bool checkUnmod /*= false*/, bool overwriteExisting /*= false*/) 
		: CPropertyPage(CTag_MAIN::IDD)
{
	m_type = type;

	m_noRecurs = noRecurs;
	m_checkUnmod = checkUnmod;
	m_overwriteExisting = overwriteExisting;
	m_tagName = sLastTag;

	m_tagCombo.SetItems(&gRevNames);
}

CTag_MAIN::CTag_MAIN() : CPropertyPage(CTag_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CTag_MAIN)
	m_noRecurs = FALSE;
	m_checkUnmod = FALSE;
	m_overwriteExisting = FALSE;
	m_tagName = _T("");
	//}}AFX_DATA_INIT
}

CTag_MAIN::~CTag_MAIN()
{
}

void CTag_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTag_MAIN)
	DDX_Control(pDX, IDC_TAGDESC_TEXT, m_tagDescStatic);
	DDX_Control(pDX, IDC_GRPBOX_TEXT, m_grpBox);
	DDX_Control(pDX, IDC_OVERWRITE, m_overwriteExistingCheck);
	DDX_Control(pDX, IDC_CHECKUNMOD, m_checkUnmodCheck);
	DDX_Control(pDX, IDC_TAGNAME, m_tagCombo);
	DDX_Check(pDX, IDC_NORECURS, m_noRecurs);
	DDX_Check(pDX, IDC_CHECKUNMOD, m_checkUnmod);
	DDX_Check(pDX, IDC_OVERWRITE, m_overwriteExisting);
	DDX_CBString(pDX, IDC_TAGNAME, m_tagName);
	//}}AFX_DATA_MAP

	DDV_MinChars(pDX, m_tagName, 1);
	DDX_ComboMString(pDX, IDC_TAGNAME, m_tagCombo);
}


BEGIN_MESSAGE_MAP(CTag_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CTag_MAIN)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTag_MAIN message handlers

BOOL CTag_MAIN::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// set the type-specific data
	CString strGrpBox;
	CString strTagDesc;
	
	switch( m_type )
	{
	case kTagAdd:
		strGrpBox = "Enter the tag name to create:";
		strTagDesc = "New tag &name:";
		break;
	case kTagDelete:
		strGrpBox = "Enter the tag name to delete:";
		strTagDesc = "Delete tag &name:";

		m_checkUnmodCheck.ShowWindow(SW_HIDE);
		m_overwriteExistingCheck.ShowWindow(SW_HIDE);
		break;
	case kTagFork:
		strGrpBox = "Enter the branch name to create:";
		strTagDesc = "New branch &name:";

		m_overwriteExistingCheck.ShowWindow(SW_HIDE);
		break;
	default:
		ASSERT(FALSE); //unknown type
	}
	
	m_grpBox.SetWindowText(strGrpBox);
	m_tagDescStatic.SetWindowText(strTagDesc);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_TagCreateMain(LWindow *theDialog,
	CPStr & sLastTag, bool & noRecurs, bool & overwriteExist,
	bool & checkUnmod, bool putValue)
{
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkOverwrite = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_OverwriteRev));
	LCheckBox *chkUnmod = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckUnmod));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	
	fillTag->DoDataExchange(gRevNames, putValue);

	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkOverwrite->SetValue(overwriteExist ? Button_On : Button_Off);
		chkUnmod->SetValue(checkUnmod ? Button_On : Button_Off);
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
	}
	else
	{
		char str[255];
		Size len;
		
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		overwriteExist = chkOverwrite->GetValue() == Button_On;
		checkUnmod = chkUnmod->GetValue() == Button_On;
	}
}

static void DoDataExchange_TagDeleteMain(LWindow *theDialog,
	CPStr & sLastTag, bool & noRecurs, bool putValue)
{
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	
	fillTag->DoDataExchange(gRevNames, putValue);

	if(putValue)
	{
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;

		char str[255];
		Size len;
		
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
	}
}

static void DoDataExchange_TagBranchMain(LWindow *theDialog,
	CPStr & sLastBranch, bool & noRecurs, bool & checkUnmod, bool putValue)
{
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkUnmod = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckUnmod));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	
	fillTag->DoDataExchange(gRevNames, putValue);

	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkUnmod->SetValue(checkUnmod ? Button_On : Button_Off);
		tname->SetText((Ptr)(const char *)sLastBranch, sLastBranch.length());
	}
	else
	{
		char str[255];
		Size len;
		
		tname->GetText(str, 254, &len);
		sLastBranch.set(str, len);
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		checkUnmod = chkUnmod->GetValue() == Button_On;
	}
}

static void DoDataExchange_TagBranchOptions(LWindow *theDialog,
	bool & noRecurs, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
	}
}
#endif /* qMacCvsPP */

#if qUnix
class UCvsTagCreate : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagCreate)
public:
	UCvsTagCreate() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsTagCreate() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagCreate, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagCreate, UWidget)
	ON_UCOMMAND(UCvsTagCreate::kOK, UCvsTagCreate::OnOK)
	ON_UCOMMAND(UCvsTagCreate::kCancel, UCvsTagCreate::OnCancel)
UEND_MESSAGE_MAP()

int UCvsTagCreate::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsTagCreate::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsTagCreate::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsTagCreate_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagCreate_MAIN)
public:
	UCvsTagCreate_MAIN(const char * sLastTag, bool noRecurs,
					   bool overwriteExist, bool checkUnmod);
	virtual ~UCvsTagCreate_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kCheckRecurs,		// 1
		kCheckUnmod,		// 2
		kCheckOverwrite,	// 3
	};

	virtual void DoDataExchange(bool fill);

	UStr m_tagname;
	bool m_norecurs;
	bool m_checkunmod;
	bool m_overwrite;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagCreate_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagCreate_MAIN, UWidget)
UEND_MESSAGE_MAP()

UCvsTagCreate_MAIN::UCvsTagCreate_MAIN(const char * sLastTag, bool noRecurs,
					   bool overwriteExist, bool checkUnmod) : UWidget(::UEventGetWidID())
{
	m_tagname = sLastTag;
	m_norecurs = noRecurs;
	m_checkunmod = checkUnmod;
	m_overwrite = overwriteExist;
}

void UCvsTagCreate_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kEditTag, gRevNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckUnmod, m_checkunmod), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckOverwrite, m_overwrite), 0L);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);

		m_checkunmod = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckUnmod, 0L);
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
		m_overwrite = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckOverwrite, 0L);
	}
}

class UCvsTagDel : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagDel)
public:
	UCvsTagDel() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsTagDel() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagDel, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagDel, UWidget)
	ON_UCOMMAND(UCvsTagDel::kOK, UCvsTagDel::OnOK)
	ON_UCOMMAND(UCvsTagDel::kCancel, UCvsTagDel::OnCancel)
UEND_MESSAGE_MAP()

int UCvsTagDel::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsTagDel::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsTagDel::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsTagDel_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagDel_MAIN)
public:
	UCvsTagDel_MAIN(const char * sLastTag, bool noRecurs);
	virtual ~UCvsTagDel_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kCheckRecurs		// 1
	};

	virtual void DoDataExchange(bool fill);

	bool m_norecurs;
	UStr m_tagname;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagDel_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagDel_MAIN, UWidget)
UEND_MESSAGE_MAP()

UCvsTagDel_MAIN::UCvsTagDel_MAIN(const char * sLastTag, bool noRecurs) : UWidget(::UEventGetWidID())
{
	m_norecurs = noRecurs;
	m_tagname = sLastTag;
}

void UCvsTagDel_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kEditTag, gRevNames);
	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);

		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
	}
}

class UCvsTagBranch : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagBranch)
public:
	UCvsTagBranch() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsTagBranch() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagBranch, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagBranch, UWidget)
	ON_UCOMMAND(UCvsTagBranch::kOK, UCvsTagBranch::OnOK)
	ON_UCOMMAND(UCvsTagBranch::kCancel, UCvsTagBranch::OnCancel)
UEND_MESSAGE_MAP()

int UCvsTagBranch::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsTagBranch::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsTagBranch::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsTagBranch_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsTagBranch_MAIN)
public:
	UCvsTagBranch_MAIN(const char * sLastTag, bool noRecurs,
					   bool checkUnmod);
	virtual ~UCvsTagBranch_MAIN() {}

	enum
	{
		kEditTag = EV_COMMAND_START,	// 0
		kCheckRecurs,		// 1
		kCheckUnmod			// 2
	};

	virtual void DoDataExchange(bool fill);

	UStr m_tagname;
	bool m_norecurs;
	bool m_checkunmod;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsTagBranch_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsTagBranch_MAIN, UWidget)
UEND_MESSAGE_MAP()

UCvsTagBranch_MAIN::UCvsTagBranch_MAIN(const char * sLastTag, bool noRecurs,
									   bool checkUnmod) : UWidget(::UEventGetWidID())
{
	m_tagname = sLastTag;
	m_norecurs = noRecurs;
	m_checkunmod = checkUnmod;
}

void UCvsTagBranch_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kEditTag, gRevNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditTag, (void *)(const char *)m_tagname);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckUnmod, m_checkunmod), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditTag, &m_tagname);

		m_checkunmod = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckUnmod, 0L);
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
	}
}
#endif // qUnix

bool CompatTagCreate(bool & noRecurs, bool & overwriteExisting,
					 CPStr & tagName, bool & checkUnmod)
{
	bool userHitOK = false;

	static CPStr sLastTag;

	tagName = "";
	noRecurs = false;
	overwriteExisting = false;
	checkUnmod = false;

#ifdef WIN32
	CPropertySheet pages("Create tag settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CTag_MAIN page1(kTagAdd, sLastTag, noRecurs, checkUnmod, overwriteExisting);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		checkUnmod = page1.m_checkUnmod == TRUE;
		noRecurs = page1.m_noRecurs == TRUE;
		sLastTag = page1.m_tagName;
		overwriteExisting = page1.m_overwriteExisting == TRUE;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_TagDlg();

	UCvsTagCreate *dlg = new UCvsTagCreate();
	UCvsTagCreate_MAIN *tab1 =
		new UCvsTagCreate_MAIN(sLastTag, noRecurs, overwriteExisting, checkUnmod);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsTagCreate::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		checkUnmod = tab1->m_checkunmod;
		noRecurs = tab1->m_norecurs;
		sLastTag = tab1->m_tagname;
		overwriteExisting = tab1->m_overwrite;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_TagCreate, LCommander::GetTopCommander());
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPane *groupView = theDialog->FindPaneByID(item_GroupViewPrefs);
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_TagCreateMain(theDialog, sLastTag,
		noRecurs, overwriteExisting, checkUnmod, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_TagCreateMain(theDialog, sLastTag,
			noRecurs, overwriteExisting, checkUnmod, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		tagName = sLastTag;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatTagDelete(bool & noRecurs, CPStr & tagName)
{

	bool userHitOK = false;

	static CPStr sLastTag;

	tagName = "";
	noRecurs = false;

#ifdef WIN32
	CPropertySheet pages("Delete tag settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CTag_MAIN page1(kTagDelete, sLastTag, noRecurs);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		noRecurs = page1.m_noRecurs == TRUE;
		sLastTag = page1.m_tagName;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_UntagDlg();

	UCvsTagDel *dlg = new UCvsTagDel();
	UCvsTagDel_MAIN *tab1 = new UCvsTagDel_MAIN(sLastTag, noRecurs);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsTagDel::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		noRecurs = tab1->m_norecurs;
		sLastTag = tab1->m_tagname;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_TagDelete, LCommander::GetTopCommander());
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPane *groupView = theDialog->FindPaneByID(item_GroupViewPrefs);
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_TagDeleteMain(theDialog, sLastTag, noRecurs, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_TagDeleteMain(theDialog, sLastTag, noRecurs, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		tagName = sLastTag;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatTagBranch(bool & noRecurs, CPStr & branchName,
					 bool & checkUnmod)
{
	bool userHitOK = false;

	static CPStr sLastBranch;

	branchName = "";
	noRecurs = false;
	checkUnmod = false;

#ifdef WIN32
	CPropertySheet pages("Create branch settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CTag_MAIN page1(kTagFork, sLastBranch, noRecurs, checkUnmod);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		checkUnmod = page1.m_checkUnmod == TRUE;
		noRecurs = page1.m_noRecurs == TRUE;
		sLastBranch = page1.m_tagName;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#if qUnix
	void *wid = UCreate_BranchDlg();

	UCvsTagBranch *dlg = new UCvsTagBranch();
	UCvsTagBranch_MAIN *tab1 = new UCvsTagBranch_MAIN(sLastBranch, noRecurs, checkUnmod);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsTagBranch::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		checkUnmod = tab1->m_checkunmod;
		noRecurs = tab1->m_norecurs;
		sLastBranch = tab1->m_tagname;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_TagBranch, LCommander::GetTopCommander());
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPane *groupView = theDialog->FindPaneByID(item_GroupViewPrefs);
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_TagBranchMain(theDialog, sLastBranch,
		noRecurs, checkUnmod, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_TagBranchMain(theDialog, sLastBranch,
			noRecurs, checkUnmod, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		branchName = sLastBranch;

		gCvsPrefs.save();
	}

	return userHitOK;
}
