/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.ResourceBundle;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GenericFileFilter
extends FileFilter {
    private static java.util.ResourceBundle resources;
    private String description;
    private String extension;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ehi.basics.view.GenericFileFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resources = ResourceBundle.getBundle(clazz);
    }

    public GenericFileFilter(String description, String extension) {
        this.description = description;
        this.extension = extension;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = GenericFileFilter.getFileExtension(f);
        if (ext != null) {
            return ext.equalsIgnoreCase(this.extension);
        }
        return false;
    }

    public static GenericFileFilter createCsvFilter() {
        return new GenericFileFilter(resources.getString("CICsvFilter"), "csv");
    }

    public static GenericFileFilter createHtmlFilter() {
        return new GenericFileFilter(resources.getString("CIHtmlFilter"), "html");
    }

    public static GenericFileFilter createSqlFilter() {
        return new GenericFileFilter(resources.getString("CISqlFilter"), "sql");
    }

    public static GenericFileFilter createXmlFilter() {
        return new GenericFileFilter(resources.getString("CIXmlFilter"), "xml");
    }

    public static GenericFileFilter createXmlSchemaFilter() {
        return new GenericFileFilter(resources.getString("CIXsdFilter"), "xsd");
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        return this.extension;
    }

    public static String getFileExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0 && i < s.length()) {
            ext = s.substring(i + 1);
        }
        return ext;
    }
}

