/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* ---------------------------------------------------------------------- -*- c -*-
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvs/maptools/cvsroot/gdal/swig/perl/gdal_wrap.cpp,v 1.2 2005/10/03 20:29:43 kruland Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Contract support */

#define SWIG_contract_assert(expr,msg) if (!(expr)) { SWIG_croak(msg); } else

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#  ifndef PL_sv_yes
#    define PL_sv_yes sv_yes
#  endif
#  ifndef PL_sv_undef
#    define PL_sv_undef sv_undef
#  endif
#  ifndef PL_na
#    define PL_na na
#  endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER 1
#define SWIG_SHADOW 2

/* Common SWIG API */

#ifdef PERL_OBJECT
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(pPerl, obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(pPerl, p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(pPerl, sv, p, s, type)
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(pPerl, obj, p, s, type, flags)

#else
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(sv, p, s, type )
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(obj, p, s, type, flags)
#endif

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Perl_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Perl_SetModule(pointer)

/* Perl-specific API */
#ifdef PERL_OBJECT
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(pPerl, sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(pPerl, str)
#else
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(str)
#  define SWIG_SetErrorSV(str) \
     SWIG_Perl_SetErrorSV(str)
#endif

#define SWIG_SetErrorf SWIG_Perl_SetErrorf


#ifdef PERL_OBJECT
#  define SWIG_MAYBE_PERL_OBJECT CPerlObj *pPerl,
#else
#  define SWIG_MAYBE_PERL_OBJECT
#endif

static swig_cast_info *
SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty) {
  SWIG_TypeCheck_Template(sv_derived_from(rv, (char *) iter->type->name), ty);
}

/* Function for getting a pointer value */

static int
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_cast_info *tc;
  void *voidptr = (void *)0;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    IV tmp = 0;
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
            tmp = SvIV((SV*)SvRV(sv));
          }
        }
      } else {
        return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    voidptr = (void *)tmp;
    if (!_t) {
      *(ptr) = voidptr;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv))
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
    *(ptr) = (void *) 0;
    return -1;
  }
  if (_t) {
    /* Now see if the types match */
    char *_c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeCheck(_c,_t);
    if (!tc) {
      *ptr = voidptr;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
    return 0;
  }
  *ptr = voidptr;
  return 0;
}

static void
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) t->name, ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_OWNER) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) t->name, ptr);
  }
}

static SWIGINLINE SV *
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

static void
  SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  sv_setpv(sv, result);
}

/* Convert a packed value value */
static int
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return -1;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return -1;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return -1;
  }
  return 0;
}

static SWIGINLINE void
SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT const char *error) {
  if (error) sv_setpv(perl_get_sv("@", TRUE), error);
}

static SWIGINLINE void
SWIG_Perl_SetErrorSV(SWIG_MAYBE_PERL_OBJECT SV *error) {
  if (error) sv_setsv(perl_get_sv("@", TRUE), error);
}

static void
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

/* Macros for low-level exception handling */
#define SWIG_fail       goto fail
#define SWIG_croak(x)   { SWIG_SetError(x); goto fail; }
#define SWIG_croakSV(x) { SWIG_SetErrorSV(x); goto fail; }
/* most preprocessors do not support vararg macros :-( */
/* #define SWIG_croakf(x...) { SWIG_SetErrorf(x); goto fail; } */


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
  #else
     static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) {
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}


static swig_module_info *
SWIG_Perl_GetModule() {
  static void *type_pointer = (void *)0;
  SV *pointer;

  /* first check if pointer already created */
  if (!type_pointer) {
    pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, FALSE);
    if (pointer && SvOK(pointer)) {
      type_pointer = INT2PTR(swig_type_info **, SvIV(pointer));
    }
  }

  return (swig_module_info *) type_pointer;
}

static void
SWIG_Perl_SetModule(swig_module_info *module) {
  SV *pointer;

  /* create a new pointer */
  pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TRUE);
  sv_setiv(pointer, PTR2IV(module));
}

#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#ifdef ENTER
  #undef ENTER
#endif
#ifdef read
  #undef read
#endif
#ifdef write
  #undef write
#endif
#ifdef eof
  #undef eof
#endif
#ifdef bool
  #undef bool
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_CPLErrorHandler swig_types[0]
#define SWIGTYPE_p_CPLXMLNode swig_types[1]
#define SWIGTYPE_p_GDALColorEntry swig_types[2]
#define SWIGTYPE_p_GDALColorTable swig_types[3]
#define SWIGTYPE_p_GDALDatasetShadow swig_types[4]
#define SWIGTYPE_p_GDALDriverShadow swig_types[5]
#define SWIGTYPE_p_GDALMajorObjectShadow swig_types[6]
#define SWIGTYPE_p_GDALRasterBandShadow swig_types[7]
#define SWIGTYPE_p_GDAL_GCP swig_types[8]
#define SWIGTYPE_p_double swig_types[9]
#define SWIGTYPE_p_int swig_types[10]
#define SWIGTYPE_p_p_GDAL_GCP swig_types[11]
#define SWIGTYPE_p_p_char swig_types[12]
static swig_type_info *swig_types[14];
static swig_module_info swig_module = {swig_types, 13, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_gdal

#define SWIG_name   "gdalc::boot_gdal"
#define SWIG_prefix "gdalc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT void SWIG_init (CV* cv);
#else
SWIGEXPORT void SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT void SWIG_init (CV *cv, CPerlObj *);
#endif


#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;

typedef int FALSE_IS_ERR;



void VeryQuiteErrorHandler(CPLErr eclass, int code, const char *msg ) {
  /* If the error class is CE_Fatal, we want to have a message issued
     because the CPL support code does an abort() before any exception
     can be generated */
  if (eclass == CE_Fatal ) {
    CPLDefaultErrorHandler(eclass, code, msg );
  }
}


void UseExceptions() {
  CPLSetErrorHandler( (CPLErrorHandler) VeryQuiteErrorHandler );
}

void DontUseExceptions() {
  CPLSetErrorHandler( CPLDefaultErrorHandler );
}


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


#define SWIG_exception(a,b)   SWIG_croak(b)


#include <stdexcept>


  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, message );
  }
  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, msg );
  }

  CPLErr PushErrorHandler( char const * pszCallbackName = "CPLQuietErrorHandler" ) {
    CPLErrorHandler pfnHandler = NULL;
    if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


static char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
static void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
static char **GDALMajorObjectShadow_GetMetadata_Dict(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
static GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *name,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){
    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate( self, name, xsize, ysize, bands, eType, options );
    return ds;
  }
static GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *name,GDALDatasetShadow *src,int strict=1,char **options=0){
    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(self, name, src, strict, 0, 0, 0 );
    return ds;
  }
static int GDALDriverShadow_Delete(GDALDriverShadow *self,char const *name){
    return GDALDeleteDataset( self, name );
  }

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

static GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){
    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }
static void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }


double GDAL_GCP_GCPX_get( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



/* Duplicate, but transposed names for C# because 
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



static SV *
CreateArrayFromDoubleArray( double *first, unsigned int size ) {
  AV *av = (AV*)sv_2mortal((SV*)newAV());
  for( unsigned int i=0; i<size; i++ ) {
    av_store(av,i,newSVnv(*first));
    ++first;
  }
  return newRV_noinc((SV*)av);
}

static void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
static GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
static GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
static char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
static void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != 0 ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
static CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
static int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0){
    return GDALBuildOverviews( self, resampling, overviewlist, pOverviews, 0, 0, 0, 0);
  }
static int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
static char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
static void GDALDatasetShadow_GetGCPs(GDALDatasetShadow *self,int *nGCPs,GDAL_GCP const **pGCPs){
    *nGCPs = GDALGetGCPCount( self );
    *pGCPs = GDALGetGCPs( self );
  }
static CPLErr GDALDatasetShadow_SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
    return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
  }
static void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
static CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
static CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
    return GDALDatasetRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                (void*) buf_string, nxsize, nysize, ntype,
                                band_list, pband_list, 0, 0, 0 );
    if ( myBandList ) {
       CPLFree( pBandList );
    }
  }

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


static
CPLErr ReadRaster_internal( GDALRasterBandShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf )
{

  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );
  CPLErr result =  GDALRasterIO( obj, GF_Read, xoff, yoff, xsize, ysize,
                                 (void *) *buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

static
CPLErr WriteRaster_internal( GDALRasterBandShadow *obj,
                             int xoff, int yoff, int xsize, int ysize,
                             int buf_xsize, int buf_ysize,
                             GDALDataType buf_type,
                             int buf_size, char *buffer )
{
    if ( buf_size < buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type) /8 ) {
      return CE_Failure;
    }

    return GDALRasterIO( obj, GF_Write, xoff, yoff, xsize, ysize, 
		        (void *) buffer, buf_xsize, buf_ysize, buf_type, 0, 0 );
}

static GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
static CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
static void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
static CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
static void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
static void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
static void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
static void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
static int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
static GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
static int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
static void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
static CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
static CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return ReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype, buf_len, buf );
  }
static CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return WriteRaster_internal( self, xoff, yoff, xsize, ysize,
                                 nxsize, nysize, ntype, buf_len, buf_string );
  }
static void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
static GDALColorTable *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTable*) GDALGetRasterColorTable( self );
  }
static int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTable *arg){
    return GDALSetRasterColorTable( self, arg );
  }

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}


/************************************************************************/
/*                          XMLTreeToAV()                               */
/************************************************************************/
static AV *XMLTreeToAV( CPLXMLNode *psTree )
{
    AV *av;
    int      nChildCount = 0, iChild;
    CPLXMLNode *psChild;

    for( psChild = psTree->psChild; 
         psChild != NULL; 
         psChild = psChild->psNext )
        nChildCount++;

    av = (AV*)sv_2mortal((SV*)newAV());

    av_store(av,0,newSViv((int) psTree->eType));
    av_store(av,1,newSVpv(psTree->pszValue, strlen(psTree->pszValue)));

    for( psChild = psTree->psChild, iChild = 2; 
         psChild != NULL; 
         psChild = psChild->psNext, iChild++ )
    {
        av_store(av, iChild, newRV_noinc((SV*)(XMLTreeToAV( psChild ))) );
    }

    return av;
}


/************************************************************************/
/*                          AVToXMLTree()                               */
/************************************************************************/
static CPLXMLNode *AVToXMLTree( AV *av )

{
    int      nChildCount = 0, iChild, nType;
    CPLXMLNode *psThisNode;
    CPLXMLNode *psChild;
    char       *pszText = NULL;

    nChildCount = av_len(av) - 1;
    if( nChildCount < 0 )
    {
        croak("Error in input XMLTree.");
	return NULL;
    }

    nType = SvIV(*(av_fetch(av,0,0)));
    pszText = SvPV_nolen(*(av_fetch(av,1,0)));
    psThisNode = CPLCreateXMLNode( NULL, (CPLXMLNodeType) nType, pszText );

    for( iChild = 0; iChild < nChildCount; iChild++ )
    {
        psChild = AVToXMLTree( (AV *)(*(av_fetch(av,iChild+2,0))) );
        CPLAddXMLChild( psThisNode, psChild );
    }

    return psThisNode;
}


int GetDriverCount() {
  return GDALGetDriverCount();
}


GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpen( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpenShared( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    throw CPLGetLastErrorMsg();
  }
  return ds;
  
}

#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_gdal_var::
class _wrap_gdal_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}


#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_UseExceptions) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: UseExceptions();");
        }
        UseExceptions();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DontUseExceptions) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: DontUseExceptions();");
        }
        DontUseExceptions();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Debug) {
    {
        char *arg1 = (char *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Debug(msg_class,message);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            Debug((char const *)arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Error) {
    {
        CPLErr arg1 = (CPLErr) CE_Failure ;
        int arg2 = (int) 0 ;
        char *arg3 = (char *) "error" ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 3)) {
            SWIG_croak("Usage: Error(msg_class,err_code,msg);");
        }
        if (items > 0) {
            arg1 = (CPLErr) SvIV(ST(0));
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        {
            CPLErrorReset();
            Error(arg1,arg2,(char const *)arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PushErrorHandler__SWIG_0) {
    {
        char *arg1 = (char *) "CPLQuietErrorHandler" ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: PushErrorHandler(pszCallbackName);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        {
            CPLErrorReset();
            result = (CPLErr)PushErrorHandler((char const *)arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PushErrorHandler__SWIG_1) {
    {
        CPLErrorHandler arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: PushErrorHandler(CPLErrorHandler);");
        }
        {
            CPLErrorHandler * argp;
            if (SWIG_ConvertPtr(ST(0),(void **) &argp, SWIGTYPE_p_CPLErrorHandler,0) < 0) {
                SWIG_croak("Type error in argument 1 of PushErrorHandler. Expected _p_CPLErrorHandler");
            }
            arg1 = *argp;
        }
        {
            CPLErrorReset();
            CPLPushErrorHandler(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PushErrorHandler) {
    dXSARGS;
    
    if ((items >= 0) && (items <= 1)) {
        int _v;
        if (items <= 0) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_PushErrorHandler__SWIG_0); return;
        }
        {
            _v = SvPOK(ST(0)) ? 1 : 0;
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_PushErrorHandler__SWIG_0); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_CPLErrorHandler, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_PushErrorHandler__SWIG_1); return;
        }
    }
    
    croak("No matching function for overloaded 'PushErrorHandler'");
    XSRETURN(0);
}


XS(_wrap_PopErrorHandler) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: PopErrorHandler();");
        }
        {
            CPLErrorReset();
            CPLPopErrorHandler();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ErrorReset) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: ErrorReset();");
        }
        {
            CPLErrorReset();
            CPLErrorReset();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetLastErrorNo) {
    {
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetLastErrorNo();");
        }
        {
            CPLErrorReset();
            result = (int)CPLGetLastErrorNo();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetLastErrorType) {
    {
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetLastErrorType();");
        }
        {
            CPLErrorReset();
            result = (CPLErr)CPLGetLastErrorType();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetLastErrorMsg) {
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetLastErrorMsg();");
        }
        {
            CPLErrorReset();
            result = (char *)CPLGetLastErrorMsg();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PushFinderLocation) {
    {
        char *arg1 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: PushFinderLocation(char const *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            CPLErrorReset();
            CPLPushFinderLocation((char const *)arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PopFinderLocation) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: PopFinderLocation();");
        }
        {
            CPLErrorReset();
            CPLPopFinderLocation();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_FinderClean) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: FinderClean();");
        }
        {
            CPLErrorReset();
            CPLFinderClean();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_FindFile) {
    {
        char *arg1 = (char *) 0 ;
        char *arg2 = (char *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: FindFile(char const *,char const *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SetConfigOption) {
    {
        char *arg1 = (char *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SetConfigOption(char const *,char const *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            CPLSetConfigOption((char const *)arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetConfigOption) {
    {
        char *arg1 = (char *) 0 ;
        char *arg2 = (char *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GetConfigOption(char const *,char const *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            result = (char *)CPLGetConfigOption((char const *)arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_GetDescription) {
    {
        GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: MajorObject_GetDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of MajorObject_GetDescription. Expected _p_GDALMajorObjectShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_SetDescription) {
    {
        GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: MajorObject_SetDescription(self,pszNewDesc);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of MajorObject_SetDescription. Expected _p_GDALMajorObjectShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_GetMetadata) {
    {
        GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
        char *arg2 = (char *) "" ;
        char **result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: MajorObject_GetMetadata(self,pszDomain);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of MajorObject_GetMetadata. Expected _p_GDALMajorObjectShadow");
            }
        }
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        {
            CPLErrorReset();
            result = (char **)GDALMajorObjectShadow_GetMetadata_Dict(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) char **dict */
            char **stringarray = result;
            HV *hv = (HV*)sv_2mortal((SV*)newHV());
            if ( stringarray != NULL ) {
                while (*stringarray != NULL ) {
                    char const *valptr;
                    char *keyptr;
                    valptr = CPLParseNameValue( *stringarray, &keyptr );
                    if ( valptr != 0 ) {
                        size_t klen = strlen(keyptr);
                        size_t vlen = strlen(valptr);
                        hv_store(hv, keyptr, strlen(keyptr), newSVpv(valptr, strlen(valptr)), 0);
                        CPLFree( keyptr );
                    }
                    stringarray++;
                }
            }
            ST(argvi) = newRV((SV*)hv);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_SetMetadata__SWIG_0) {
    {
        GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
        char **arg2 = (char **) 0 ;
        char *arg3 = (char *) "" ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: MajorObject_SetMetadata(self,papszMetadata,pszDomain);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of MajorObject_SetMetadata. Expected _p_GDALMajorObjectShadow");
            }
        }
        {
            /* %typemap(in) char **dict */
            HV *hv = (HV*)SvRV(ST(1));
            SV *sv;
            char *key;
            I32 klen;
            arg2 = NULL;
            hv_iterinit(hv);
            while(sv = hv_iternextsv(hv,&key,&klen)) {
                arg2 = CSLAddNameValue( arg2, key, SvPV_nolen(sv) );
            }
        }
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        {
            /* %typemap(freearg) char **dict */
            CSLDestroy( arg2 );
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) char **dict */
            CSLDestroy( arg2 );
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_SetMetadata__SWIG_1) {
    {
        GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        char *arg3 = (char *) "" ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: MajorObject_SetMetadata(self,pszMetadataString,pszDomain);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of MajorObject_SetMetadata. Expected _p_GDALMajorObjectShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MajorObject_SetMetadata) {
    dXSARGS;
    
    if ((items >= 2) && (items <= 3)) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_GDALMajorObjectShadow, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                /* %typecheck(SWIG_TYPECHECK_POINTER) (char **dict) */
                _v = (SvROK(ST(1)) && (SvTYPE(SvRV(ST(1)))==SVt_PVHV)) ? 1 : 0;
            }
            if (_v) {
                if (items <= 2) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_MajorObject_SetMetadata__SWIG_0); return;
                }
                {
                    _v = SvPOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_MajorObject_SetMetadata__SWIG_0); return;
                }
            }
        }
    }
    if ((items >= 2) && (items <= 3)) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_GDALMajorObjectShadow, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvPOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                if (items <= 2) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_MajorObject_SetMetadata__SWIG_1); return;
                }
                {
                    _v = SvPOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_MajorObject_SetMetadata__SWIG_1); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'MajorObject_SetMetadata'");
    XSRETURN(0);
}


XS(_wrap_Driver_ShortName_get) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Driver_ShortName_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_ShortName_get. Expected _p_GDALDriverShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDriverShadow_ShortName_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Driver_LongName_get) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Driver_LongName_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_LongName_get. Expected _p_GDALDriverShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDriverShadow_LongName_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Driver_HelpTopic_get) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Driver_HelpTopic_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_HelpTopic_get. Expected _p_GDALDriverShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Driver_Create) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        int arg3 ;
        int arg4 ;
        int arg5 = (int) 1 ;
        GDALDataType arg6 = (GDALDataType) GDT_Byte ;
        char **arg7 = (char **) 0 ;
        GDALDatasetShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 7)) {
            SWIG_croak("Usage: Driver_Create(self,name,xsize,ysize,bands,eType,options);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_Create. Expected _p_GDALDriverShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        if (items > 4) {
            arg5 = (int) SvIV(ST(4));
        }
        if (items > 5) {
            arg6 = (GDALDataType) SvIV(ST(5));
        }
        if (items > 6) {
            {
                /* %typemap(in) char **options */
                if ( ! (SvROK(ST(6)) && (SvTYPE(SvRV(ST(6)))==SVt_PVAV)) ) {
                    croak("argument is not an array ref");
                    SWIG_fail;
                }
                AV *av = (AV*)(SvRV(ST(6)));
                for (int i = 0; i < av_len(av)-1; i++) {
                    char *pszItem = SvPV_nolen(*(av_fetch(av, i, 0)));
                    arg7 = CSLAddString( arg7, pszItem );
                }
            }
        }
        {
            CPLErrorReset();
            result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDatasetShadow, SWIG_SHADOW|SWIG_OWNER);
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg7 );
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg7 );
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Driver_CreateCopy) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
        int arg4 = (int) 1 ;
        char **arg5 = (char **) 0 ;
        GDALDatasetShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 5)) {
            SWIG_croak("Usage: Driver_CreateCopy(self,name,src,strict,options);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_CreateCopy. Expected _p_GDALDriverShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 3 of Driver_CreateCopy. Expected _p_GDALDatasetShadow");
            }
        }
        if (items > 3) {
            arg4 = (int) SvIV(ST(3));
        }
        if (items > 4) {
            {
                /* %typemap(in) char **options */
                if ( ! (SvROK(ST(4)) && (SvTYPE(SvRV(ST(4)))==SVt_PVAV)) ) {
                    croak("argument is not an array ref");
                    SWIG_fail;
                }
                AV *av = (AV*)(SvRV(ST(4)));
                for (int i = 0; i < av_len(av)-1; i++) {
                    char *pszItem = SvPV_nolen(*(av_fetch(av, i, 0)));
                    arg5 = CSLAddString( arg5, pszItem );
                }
            }
        }
        {
            CPLErrorReset();
            result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDatasetShadow, SWIG_SHADOW|SWIG_OWNER);
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg5 );
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg5 );
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Driver_Delete) {
    {
        GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Driver_Delete(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Driver_Delete. Expected _p_GDALDriverShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            result = (int)GDALDriverShadow_Delete(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPX_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_GCPX_set(self,GCPX);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPX_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPX_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPX_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_GCPX_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPX_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPX_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPY_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_GCPY_set(self,GCPY);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPY_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPY_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPY_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_GCPY_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPY_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPY_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPZ_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_GCPZ_set(self,GCPZ);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPZ_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPZ_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPZ_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_GCPZ_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPZ_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPZ_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPPixel_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_GCPPixel_set(self,GCPPixel);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPPixel_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPPixel_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPPixel_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_GCPPixel_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPPixel_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPPixel_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPLine_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_GCPLine_set(self,GCPLine);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPLine_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPLine_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_GCPLine_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_GCPLine_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_GCPLine_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPLine_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_Info_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_Info_set(self,Info);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_Info_set. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_Info_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_Info_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_Info_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_Info_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_Info_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_Id_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GCP_Id_set(self,Id);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_Id_set. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_Id_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCP_Id_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GCP_Id_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GCP_Id_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_Id_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_GCP) {
    {
        double arg1 = (double) 0.0 ;
        double arg2 = (double) 0.0 ;
        double arg3 = (double) 0.0 ;
        double arg4 = (double) 0.0 ;
        double arg5 = (double) 0.0 ;
        char *arg6 = (char *) "" ;
        char *arg7 = (char *) "" ;
        GDAL_GCP *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 7)) {
            SWIG_croak("Usage: new_GCP(x,y,z,pixel,line,info,id);");
        }
        if (items > 0) {
            arg1 = (double) SvNV(ST(0));
            
        }
        if (items > 1) {
            arg2 = (double) SvNV(ST(1));
            
        }
        if (items > 2) {
            arg3 = (double) SvNV(ST(2));
            
        }
        if (items > 3) {
            arg4 = (double) SvNV(ST(3));
            
        }
        if (items > 4) {
            arg5 = (double) SvNV(ST(4));
            
        }
        if (items > 5) {
            if (!SvOK((SV*) ST(5))) arg6 = 0;
            else arg6 = (char *) SvPV(ST(5), PL_na);
        }
        if (items > 6) {
            if (!SvOK((SV*) ST(6))) arg7 = 0;
            else arg7 = (char *) SvPV(ST(6), PL_na);
        }
        {
            CPLErrorReset();
            result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDAL_GCP, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_GCP) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_GCP(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_GCP. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            delete_GDAL_GCP(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPX_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_GCPX_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPX_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPX_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPX_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_GCPX_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPX_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPX_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPY_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_GCPY_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPY_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPY_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPY_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_GCPY_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPY_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPY_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPZ_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_GCPZ_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPZ_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPZ_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPZ_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_GCPZ_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPZ_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPZ_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPPixel_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_GCPPixel_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPPixel_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPPixel_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPPixel_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_GCPPixel_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPPixel_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPPixel_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPLine_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_GCPLine_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPLine_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_GCPLine_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_GCPLine_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_GCPLine_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_GCPLine_set. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_GCPLine_set(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_Info_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_Info_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_Info_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_Info_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_Info_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_Info_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_Info_set. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_Info_set(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_Id_get) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_Id_get(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_Id_get. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_Id_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_Id_set) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_Id_set(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_Id_set. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_Id_set(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_GCPX) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_GCPX(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_GCPX. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_get_GCPX(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_GCPX) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_GCPX(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_GCPX. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_set_GCPX(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_GCPY) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_GCPY(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_GCPY. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_get_GCPY(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_GCPY) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_GCPY(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_GCPY. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_set_GCPY(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_GCPZ) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_GCPZ(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_GCPZ. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_get_GCPZ(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_GCPZ) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_GCPZ(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_GCPZ. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_set_GCPZ(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_GCPPixel) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_GCPPixel(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_GCPPixel. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_get_GCPPixel(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_GCPPixel) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_GCPPixel(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_GCPPixel. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_set_GCPPixel(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_GCPLine) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_GCPLine(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_GCPLine. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (double)GDAL_GCP_get_GCPLine(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_GCPLine) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_GCPLine(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_GCPLine. Expected _p_GDAL_GCP");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            GDAL_GCP_set_GCPLine(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_Info) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_Info(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_Info. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_get_Info(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_Info) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_Info(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_Info. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_set_Info(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_get_Id) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDAL_GCP_get_Id(h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_get_Id. Expected _p_GDAL_GCP");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDAL_GCP_get_Id(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDAL_GCP_set_Id) {
    {
        GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
        char *arg2 = (char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: GDAL_GCP_set_Id(h,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDAL_GCP,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDAL_GCP_set_Id. Expected _p_GDAL_GCP");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            GDAL_GCP_set_Id(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GCPsToGeoTransform) {
    {
        int arg1 ;
        GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
        double *arg3 ;
        int arg4 = (int) 1 ;
        FALSE_IS_ERR result;
        GDAL_GCP *tmpGCPList1 ;
        double argout3[6] ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(in,numinputs=0) (double argout3[ANY]) */
            arg3 = argout3;
        }
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: GCPsToGeoTransform(nGCPs,pGCPs,bApproxOK);");
        }
        {
            /* %typemap(in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (! (SvROK(ST(0)) && (SvTYPE(SvRV(ST(0)))==SVt_PVAV))) {
                croak("argument is not an array ref");
                SWIG_fail;
            }
            AV *av = (AV*)(SvRV(ST(0)));
            arg1 = av_len(av)+1;
            tmpGCPList1 = (GDAL_GCP*) malloc(arg1*sizeof(GDAL_GCP));
            arg2 = tmpGCPList1;
            for( int i = 0; i<arg1; i++ ) {
                SV **sv = av_fetch(av, i, 0);
                GDAL_GCP *item = 0;
                SWIG_ConvertPtr( *sv, (void**)&item, SWIGTYPE_p_GDAL_GCP, 0 );
                if ( ! item ) {
                    SWIG_fail;
                }
                memcpy( (void*) tmpGCPList1, (void*) item, sizeof( GDAL_GCP ) );
                ++tmpGCPList1;
            }
        }
        if (items > 1) {
            arg4 = (int) SvIV(ST(1));
        }
        {
            CPLErrorReset();
            result = GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) IF_FALSE_RETURN_NONE */
        }
        {
            /* %typemap(argout) (double argout[ANY]) */
            ST(argvi) = CreateArrayFromDoubleArray( arg3, 6 );
            argvi++;
        }
        {
            /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (arg2) {
                free( (void*) arg2 );
            }
        }
        {
            /* %typemap(ret) IF_FALSE_RETURN_NONE */
            if (result == 0 ) {
                /* this is currently used only in GDALGCPsToGeoTransform
                       this is probably a memory leak
                       ST(argvi-1) is at this point an array which needs to be destr
                     */
                ST(argvi-1) = sv_newmortal();
            }
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (arg2) {
                free( (void*) arg2 );
            }
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_RasterXSize_get) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_RasterXSize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_RasterXSize_get. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_RasterYSize_get) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_RasterYSize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_RasterYSize_get. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_RasterCount_get) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_RasterCount_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_RasterCount_get. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALDatasetShadow_RasterCount_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_Dataset) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_Dataset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_Dataset. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            delete_GDALDatasetShadow(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetDriver) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        GDALDriverShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetDriver(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetDriver. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDriverShadow, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetRasterBand) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int arg2 ;
        GDALRasterBandShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Dataset_GetRasterBand(self,nBand);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetRasterBand. Expected _p_GDALDatasetShadow");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            CPLErrorReset();
            result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALRasterBandShadow, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetProjection) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetProjection(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetProjection. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDatasetShadow_GetProjection(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetProjectionRef) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetProjectionRef(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetProjectionRef. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_SetProjection) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Dataset_SetProjection(self,prj);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_SetProjection. Expected _p_GDALDatasetShadow");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            CPLErrorReset();
            result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetGeoTransform) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        double *arg2 ;
        double argout2[6] ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(in,numinputs=0) (double argout2[ANY]) */
            arg2 = argout2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetGeoTransform(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetGeoTransform. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            GDALDatasetShadow_GetGeoTransform(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(argout) (double argout[ANY]) */
            ST(argvi) = CreateArrayFromDoubleArray( arg2, 6 );
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_SetGeoTransform) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        double *arg2 ;
        CPLErr result;
        double argin2[6] ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Dataset_SetGeoTransform(self,argin);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_SetGeoTransform. Expected _p_GDALDatasetShadow");
            }
        }
        {
            /* %typemap(in) (double argin2[ANY]) */
            if (! (SvROK(ST(1)) && (SvTYPE(SvRV(ST(1)))==SVt_PVAV))) {
                croak("argument is not an array ref");
                SWIG_fail;
            }
            arg2 = argin2;
            AV *av = (AV*)(SvRV(ST(1)));
            int seq_size = av_len(av)+1;
            if ( seq_size != 6 ) {
                croak("argument array must have length %d",6);
                SWIG_fail;
            }
            for (unsigned int i=0; i<6; i++) {
                SV **sv = av_fetch(av, i, 0);
                arg2[i] =  SvNV(*sv);
            }
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_BuildOverviews) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *arg2 = (char *) "NEAREST" ;
        int arg3 = (int) 0 ;
        int *arg4 = (int *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 3)) {
            SWIG_croak("Usage: Dataset_BuildOverviews(self,resampling,overviewlist,pOverviews);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_BuildOverviews. Expected _p_GDALDatasetShadow");
            }
        }
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        if (items > 2) {
            {
                /* %typemap(in,numinputs=1) (int nList, int* pList) */
                if (! (SvROK(ST(2)) && (SvTYPE(SvRV(ST(2)))==SVt_PVAV))) {
                    croak("argument is not an array ref");
                    SWIG_fail;
                }
                AV *av = (AV*)(SvRV(ST(2)));
                arg3 = av_len(av)-1;
                arg4 = (int*) malloc(arg3*sizeof(int));
                for( int i = 0; i<arg3; i++ ) {
                    SV **sv = av_fetch(av, i, 0);
                    arg4[i] =  SvIV(*sv);
                }
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        {
            /* %typemap(freearg) (int nList, int* pList) */
            if (arg4) {
                free((void*) arg4);
            }
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) (int nList, int* pList) */
            if (arg4) {
                free((void*) arg4);
            }
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetGCPCount) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetGCPCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetGCPCount. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALDatasetShadow_GetGCPCount(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetGCPProjection) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetGCPProjection(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetGCPProjection. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_GetGCPs) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int *arg2 = (int *) 0 ;
        GDAL_GCP **arg3 = (GDAL_GCP **) 0 ;
        int nGCPs2 = 0 ;
        GDAL_GCP *pGCPs2 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(in,numinputs=0) (int *nGCPs2, GDAL_GCP const **pGCPs2 ) */
            arg2 = &nGCPs2;
            arg3 = &pGCPs2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_GetGCPs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_GetGCPs. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            GDALDatasetShadow_GetGCPs(arg1,arg2,(GDAL_GCP const **)arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(argout) (int *nGCPs, GDAL_GCP const **pGCPs ) */
            AV *dict = (AV*)sv_2mortal((SV*)newAV());
            for( int i = 0; i < *arg2; i++ ) {
                GDAL_GCP *o = new_GDAL_GCP( (*arg3)[i].dfGCPX,
                (*arg3)[i].dfGCPY,
                (*arg3)[i].dfGCPZ,
                (*arg3)[i].dfGCPPixel,
                (*arg3)[i].dfGCPLine,
                (*arg3)[i].pszInfo,
                (*arg3)[i].pszId );
                SV *sv = newSV(0);
                SWIG_MakePtr( sv, (void*)o, SWIGTYPE_p_GDAL_GCP, SWIG_SHADOW|SWIG_OWNER);
                av_store(dict, i, sv);
            }
            ST(argvi) = newRV_noinc((SV*)dict);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_SetGCPs) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int arg2 ;
        GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
        char *arg4 = (char *) 0 ;
        CPLErr result;
        GDAL_GCP *tmpGCPList2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: Dataset_SetGCPs(self,nGCPs,pGCPs,pszGCPProjection);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_SetGCPs. Expected _p_GDALDatasetShadow");
            }
        }
        {
            /* %typemap(in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (! (SvROK(ST(1)) && (SvTYPE(SvRV(ST(1)))==SVt_PVAV))) {
                croak("argument is not an array ref");
                SWIG_fail;
            }
            AV *av = (AV*)(SvRV(ST(1)));
            arg2 = av_len(av)+1;
            tmpGCPList2 = (GDAL_GCP*) malloc(arg2*sizeof(GDAL_GCP));
            arg3 = tmpGCPList2;
            for( int i = 0; i<arg2; i++ ) {
                SV **sv = av_fetch(av, i, 0);
                GDAL_GCP *item = 0;
                SWIG_ConvertPtr( *sv, (void**)&item, SWIGTYPE_p_GDAL_GCP, 0 );
                if ( ! item ) {
                    SWIG_fail;
                }
                memcpy( (void*) tmpGCPList2, (void*) item, sizeof( GDAL_GCP ) );
                ++tmpGCPList2;
            }
        }
        if (!SvOK((SV*) ST(2))) arg4 = 0;
        else arg4 = (char *) SvPV(ST(2), PL_na);
        {
            CPLErrorReset();
            result = (CPLErr)GDALDatasetShadow_SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        {
            /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (arg3) {
                free( (void*) arg3 );
            }
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
            if (arg3) {
                free( (void*) arg3 );
            }
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_FlushCache) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Dataset_FlushCache(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_FlushCache. Expected _p_GDALDatasetShadow");
            }
        }
        {
            CPLErrorReset();
            GDALDatasetShadow_FlushCache(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_AddBand) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        GDALDataType arg2 = (GDALDataType) GDT_Byte ;
        char **arg3 = (char **) 0 ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 3)) {
            SWIG_croak("Usage: Dataset_AddBand(self,datatype,options);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_AddBand. Expected _p_GDALDatasetShadow");
            }
        }
        if (items > 1) {
            arg2 = (GDALDataType) SvIV(ST(1));
        }
        if (items > 2) {
            {
                /* %typemap(in) char **options */
                if ( ! (SvROK(ST(2)) && (SvTYPE(SvRV(ST(2)))==SVt_PVAV)) ) {
                    croak("argument is not an array ref");
                    SWIG_fail;
                }
                AV *av = (AV*)(SvRV(ST(2)));
                for (int i = 0; i < av_len(av)-1; i++) {
                    char *pszItem = SvPV_nolen(*(av_fetch(av, i, 0)));
                    arg3 = CSLAddString( arg3, pszItem );
                }
            }
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg3 );
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) char **options */
            CSLDestroy( arg3 );
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Dataset_WriteRaster) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        int arg2 ;
        int arg3 ;
        int arg4 ;
        int arg5 ;
        int arg6 ;
        char *arg7 = (char *) 0 ;
        int *arg8 = (int *) 0 ;
        int *arg9 = (int *) 0 ;
        GDALDataType *arg10 = (GDALDataType *) 0 ;
        int arg11 = (int) 0 ;
        int *arg12 = (int *) 0 ;
        CPLErr result;
        int val8 ;
        int val9 ;
        int val10 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 10)) {
            SWIG_croak("Usage: Dataset_WriteRaster(self,xoff,yoff,xsize,ysize,buf_len,buf_string,buf_xsize,buf_ysize,buf_type,band_list,pband_list);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Dataset_WriteRaster. Expected _p_GDALDatasetShadow");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            /* %typemap(in,numinputs=1) (int nLen, char *pBuf ) */
            if (!SvPOK(ST(5))) {
                croak("buf argument has to be binary data");
                SWIG_fail;
            }
            STRLEN len = SvCUR(ST(5));
            arg7 = SvPV_nolen(ST(5));
            arg6 = len;
        }
        if (items > 6) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(6)) ) {
                    arg8 = 0;
                }
                else {
                    val8 = SvIV(ST(6));
                    arg8 = (int *)&val8;
                }
            }
        }
        if (items > 7) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(7)) ) {
                    arg9 = 0;
                }
                else {
                    val9 = SvIV(ST(7));
                    arg9 = (int *)&val9;
                }
            }
        }
        if (items > 8) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(8)) ) {
                    arg10 = 0;
                }
                else {
                    val10 = SvIV(ST(8));
                    arg10 = (GDALDataType *)&val10;
                }
            }
        }
        if (items > 9) {
            {
                /* %typemap(in,numinputs=1) (int nList, int* pList) */
                if (! (SvROK(ST(9)) && (SvTYPE(SvRV(ST(9)))==SVt_PVAV))) {
                    croak("argument is not an array ref");
                    SWIG_fail;
                }
                AV *av = (AV*)(SvRV(ST(9)));
                arg11 = av_len(av)-1;
                arg12 = (int*) malloc(arg11*sizeof(int));
                for( int i = 0; i<arg11; i++ ) {
                    SV **sv = av_fetch(av, i, 0);
                    arg12[i] =  SvIV(*sv);
                }
            }
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        {
            /* %typemap(freearg) (int nList, int* pList) */
            if (arg12) {
                free((void*) arg12);
            }
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) (int nList, int* pList) */
            if (arg12) {
                free((void*) arg12);
            }
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_XSize_get) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_XSize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_XSize_get. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALRasterBandShadow_XSize_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_YSize_get) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_YSize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_YSize_get. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALRasterBandShadow_YSize_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_DataType_get) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        GDALDataType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_DataType_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_DataType_get. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetRasterColorInterpretation) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        GDALColorInterp result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetRasterColorInterpretation(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetRasterColorInterpretation. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_SetRasterColorInterpretation) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        GDALColorInterp arg2 ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Band_SetRasterColorInterpretation(self,val);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_SetRasterColorInterpretation. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (GDALColorInterp) SvIV(ST(1));
        {
            CPLErrorReset();
            result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetNoDataValue) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 = (double *) 0 ;
        int *arg3 = (int *) 0 ;
        double tmpval2 ;
        int tmphasval2 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) (double *val, int *hasval) */
            arg2 = &tmpval2;
            arg3 = &tmphasval2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetNoDataValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetNoDataValue. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) (double *val, int *hasval) */
            ST(argvi) = sv_newmortal();
            if ( *arg3 )
            sv_setnv(ST(argvi), *arg2);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_SetNoDataValue) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double arg2 ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Band_SetNoDataValue(self,d);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_SetNoDataValue. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            CPLErrorReset();
            result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetMinimum) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 = (double *) 0 ;
        int *arg3 = (int *) 0 ;
        double tmpval2 ;
        int tmphasval2 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) (double *val, int *hasval) */
            arg2 = &tmpval2;
            arg3 = &tmphasval2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetMinimum(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetMinimum. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) (double *val, int *hasval) */
            ST(argvi) = sv_newmortal();
            if ( *arg3 )
            sv_setnv(ST(argvi), *arg2);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetMaximum) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 = (double *) 0 ;
        int *arg3 = (int *) 0 ;
        double tmpval2 ;
        int tmphasval2 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) (double *val, int *hasval) */
            arg2 = &tmpval2;
            arg3 = &tmphasval2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetMaximum(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetMaximum. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) (double *val, int *hasval) */
            ST(argvi) = sv_newmortal();
            if ( *arg3 )
            sv_setnv(ST(argvi), *arg2);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetOffset) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 = (double *) 0 ;
        int *arg3 = (int *) 0 ;
        double tmpval2 ;
        int tmphasval2 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) (double *val, int *hasval) */
            arg2 = &tmpval2;
            arg3 = &tmphasval2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetOffset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetOffset. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) (double *val, int *hasval) */
            ST(argvi) = sv_newmortal();
            if ( *arg3 )
            sv_setnv(ST(argvi), *arg2);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetScale) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 = (double *) 0 ;
        int *arg3 = (int *) 0 ;
        double tmpval2 ;
        int tmphasval2 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) (double *val, int *hasval) */
            arg2 = &tmpval2;
            arg3 = &tmphasval2;
        }
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetScale(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetScale. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) (double *val, int *hasval) */
            ST(argvi) = sv_newmortal();
            if ( *arg3 )
            sv_setnv(ST(argvi), *arg2);
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetOverviewCount) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetOverviewCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetOverviewCount. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetOverview) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int arg2 ;
        GDALRasterBandShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Band_GetOverview(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetOverview. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            CPLErrorReset();
            result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALRasterBandShadow, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_Checksum) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int arg2 = (int) 0 ;
        int arg3 = (int) 0 ;
        int *arg4 = (int *) 0 ;
        int *arg5 = (int *) 0 ;
        int result;
        int val4 ;
        int val5 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 5)) {
            SWIG_croak("Usage: Band_Checksum(self,xoff,yoff,xsize,ysize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_Checksum. Expected _p_GDALRasterBandShadow");
            }
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        if (items > 3) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(3)) ) {
                    arg4 = 0;
                }
                else {
                    val4 = SvIV(ST(3));
                    arg4 = (int *)&val4;
                }
            }
        }
        if (items > 4) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(4)) ) {
                    arg5 = 0;
                }
                else {
                    val5 = SvIV(ST(4));
                    arg5 = (int *)&val5;
                }
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_ComputeRasterMinMax) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double *arg2 ;
        int arg3 = (int) 0 ;
        double argout2[2] ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(in,numinputs=0) (double argout2[ANY]) */
            arg2 = argout2;
        }
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: Band_ComputeRasterMinMax(self,approx_ok);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_ComputeRasterMinMax. Expected _p_GDALRasterBandShadow");
            }
        }
        if (items > 1) {
            arg3 = (int) SvIV(ST(1));
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(argout) (double argout[ANY]) */
            ST(argvi) = CreateArrayFromDoubleArray( arg2, 2 );
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_Fill) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        double arg2 ;
        double arg3 = (double) 0.0 ;
        CPLErr result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: Band_Fill(self,real_fill,imag_fill);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_Fill. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (items > 2) {
            arg3 = (double) SvNV(ST(2));
            
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_ReadRaster) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int arg2 ;
        int arg3 ;
        int arg4 ;
        int arg5 ;
        int *arg6 = (int *) 0 ;
        char **arg7 = (char **) 0 ;
        int *arg8 = (int *) 0 ;
        int *arg9 = (int *) 0 ;
        int *arg10 = (int *) 0 ;
        CPLErr result;
        int nLen6 = 0 ;
        char *pBuf6 = 0 ;
        int val8 ;
        int val9 ;
        int val10 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(in,numinputs=0) (int *nLen6, char **pBuf6 ) */
            arg6 = &nLen6;
            arg7 = &pBuf6;
        }
        if ((items < 5) || (items > 8)) {
            SWIG_croak("Usage: Band_ReadRaster(self,xoff,yoff,xsize,ysize,buf_xsize,buf_ysize,buf_type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_ReadRaster. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        if (items > 5) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(5)) ) {
                    arg8 = 0;
                }
                else {
                    val8 = SvIV(ST(5));
                    arg8 = (int *)&val8;
                }
            }
        }
        if (items > 6) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(6)) ) {
                    arg9 = 0;
                }
                else {
                    val9 = SvIV(ST(6));
                    arg9 = (int *)&val9;
                }
            }
        }
        if (items > 7) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(7)) ) {
                    arg10 = 0;
                }
                else {
                    val10 = SvIV(ST(7));
                    arg10 = (int *)&val10;
                }
            }
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        {
            /* %typemap(argout) (int *nLen, char **pBuf ) */
            ST(argvi) = sv_2mortal(newSVpv( *arg7, *arg6 ));
            argvi++;
        }
        {
            /* %typemap(freearg) (int *nLen, char **pBuf ) */
            if( *arg6 ) {
                free( *arg7 );
            }
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(freearg) (int *nLen, char **pBuf ) */
            if( *arg6 ) {
                free( *arg7 );
            }
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_WriteRaster) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int arg2 ;
        int arg3 ;
        int arg4 ;
        int arg5 ;
        int arg6 ;
        char *arg7 = (char *) 0 ;
        int *arg8 = (int *) 0 ;
        int *arg9 = (int *) 0 ;
        int *arg10 = (int *) 0 ;
        CPLErr result;
        int val8 ;
        int val9 ;
        int val10 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 9)) {
            SWIG_croak("Usage: Band_WriteRaster(self,xoff,yoff,xsize,ysize,buf_len,buf_string,buf_xsize,buf_ysize,buf_type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_WriteRaster. Expected _p_GDALRasterBandShadow");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            /* %typemap(in,numinputs=1) (int nLen, char *pBuf ) */
            if (!SvPOK(ST(5))) {
                croak("buf argument has to be binary data");
                SWIG_fail;
            }
            STRLEN len = SvCUR(ST(5));
            arg7 = SvPV_nolen(ST(5));
            arg6 = len;
        }
        if (items > 6) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(6)) ) {
                    arg8 = 0;
                }
                else {
                    val8 = SvIV(ST(6));
                    arg8 = (int *)&val8;
                }
            }
        }
        if (items > 7) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(7)) ) {
                    arg9 = 0;
                }
                else {
                    val9 = SvIV(ST(7));
                    arg9 = (int *)&val9;
                }
            }
        }
        if (items > 8) {
            {
                /* %typemap(in) (int *optional_int) */
                if ( !SvOK(ST(8)) ) {
                    arg10 = 0;
                }
                else {
                    val10 = SvIV(ST(8));
                    arg10 = (int *)&val10;
                }
            }
        }
        {
            CPLErrorReset();
            result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(out) CPLErr */
            ST(argvi) = sv_2mortal(newSViv(result));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_FlushCache) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_FlushCache(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_FlushCache. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            GDALRasterBandShadow_FlushCache(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_GetRasterColorTable) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        GDALColorTable *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Band_GetRasterColorTable(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_GetRasterColorTable. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            CPLErrorReset();
            result = (GDALColorTable *)GDALRasterBandShadow_GetRasterColorTable(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALColorTable, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Band_SetRasterColorTable) {
    {
        GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
        GDALColorTable *arg2 = (GDALColorTable *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Band_SetRasterColorTable(self,arg);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of Band_SetRasterColorTable. Expected _p_GDALRasterBandShadow");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 2 of Band_SetRasterColorTable. Expected _p_GDALColorTable");
            }
        }
        {
            CPLErrorReset();
            result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_ColorTable) {
    {
        GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
        GDALColorTable *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_ColorTable(GDALPaletteInterp);");
        }
        if (items > 0) {
            arg1 = (GDALPaletteInterp) SvIV(ST(0));
        }
        {
            CPLErrorReset();
            result = (GDALColorTable *)new GDALColorTable(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALColorTable, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_ColorTable) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_ColorTable(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_ColorTable. Expected _p_GDALColorTable");
            }
        }
        {
            CPLErrorReset();
            delete arg1;
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_Clone) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        GDALColorTable *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: ColorTable_Clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_Clone. Expected _p_GDALColorTable");
            }
        }
        {
            CPLErrorReset();
            result = (GDALColorTable *)((GDALColorTable const *)arg1)->Clone();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALColorTable, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_GetPaletteInterpretation) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        GDALPaletteInterp result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: ColorTable_GetPaletteInterpretation(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_GetPaletteInterpretation. Expected _p_GDALColorTable");
            }
        }
        {
            CPLErrorReset();
            result = (GDALPaletteInterp)((GDALColorTable const *)arg1)->GetPaletteInterpretation();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_GetCount) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: ColorTable_GetCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_GetCount. Expected _p_GDALColorTable");
            }
        }
        {
            CPLErrorReset();
            result = (int)((GDALColorTable const *)arg1)->GetColorEntryCount();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_GetColorEntry) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        int arg2 ;
        GDALColorEntry *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: ColorTable_GetColorEntry(self,int);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_GetColorEntry. Expected _p_GDALColorTable");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            CPLErrorReset();
            result = (GDALColorEntry *)(arg1)->GetColorEntry(arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(perl5,out) GDALColorEntry* */
            if (result == NULL)
            croak("GetColorEntry failed at index %i",result);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) result->c1);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) result->c2);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) result->c3);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) result->c4);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_GetColorEntryAsRGB) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        int arg2 ;
        GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
        int result;
        GDALColorEntry e3 ;
        int argvi = 0;
        dXSARGS;
        
        {
            /* %typemap(perl5,in,numinputs=0) GDALColorEntry*(GDALColorEntry e3) */
            arg3 = &e3;
        }
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: ColorTable_GetColorEntryAsRGB(self,int);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_GetColorEntryAsRGB. Expected _p_GDALColorTable");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            CPLErrorReset();
            result = (int)((GDALColorTable const *)arg1)->GetColorEntryAsRGB(arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        {
            /* %typemap(perl5,argout) GDALColorEntry* */
            if (result == FALSE)
            croak("GetColorEntryAsRGB failed at index %i",result);
            argvi--;
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) e3.c1);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) e3.c2);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) e3.c3);
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi++), (IV) e3.c4);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ColorTable_SetColorEntry) {
    {
        GDALColorTable *arg1 = (GDALColorTable *) 0 ;
        int arg2 ;
        GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
        GDALColorEntry e3 ;
        int argvi = 0;
        SV * _saved[1] ;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: ColorTable_SetColorEntry(self,int,GDALColorEntry const *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALColorTable,0) < 0) {
                SWIG_croak("Type error in argument 1 of ColorTable_SetColorEntry. Expected _p_GDALColorTable");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            /* %typemap(perl5,in,numinputs=1) const GDALColorEntry*(GDALColorEntry e3) */
            arg3 = &e3;
            if (! (SvROK(ST(2)) && (SvTYPE(SvRV(ST(2)))==SVt_PVAV))) {
                croak("argument is not an array ref");
                SWIG_fail;
            }
            AV *av = (AV*)(SvRV(ST(2)));
            int seq_size = av_len(av);
            if ( seq_size != 3 ) {
                croak("color entry argument array must have length 4 (it is %i)",seq_size+1);
                SWIG_fail;
            }
            SV **sv = av_fetch(av, 0, 0);
            arg3->c1 =  SvIV(*sv);
            sv = av_fetch(av, 1, 0);
            arg3->c2 =  SvIV(*sv);
            sv = av_fetch(av, 2, 0);
            arg3->c3 =  SvIV(*sv);
            sv = av_fetch(av, 3, 0);
            arg3->c4 =  SvIV(*sv);
        }
        _saved[0] = ST(2);
        {
            CPLErrorReset();
            (arg1)->SetColorEntry(arg2,(GDALColorEntry const *)arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        {
            /* %typemap(perl5,argout) const GDALColorEntry* */
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_AllRegister) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: AllRegister();");
        }
        {
            CPLErrorReset();
            GDALAllRegister();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetCacheMax) {
    {
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetCacheMax();");
        }
        {
            CPLErrorReset();
            result = (int)GDALGetCacheMax();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SetCacheMax) {
    {
        int arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SetCacheMax(nBytes);");
        }
        arg1 = (int) SvIV(ST(0));
        {
            CPLErrorReset();
            GDALSetCacheMax(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetCacheUsed) {
    {
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetCacheUsed();");
        }
        {
            CPLErrorReset();
            result = (int)GDALGetCacheUsed();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDataTypeSize) {
    {
        GDALDataType arg1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetDataTypeSize(GDALDataType);");
        }
        arg1 = (GDALDataType) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (int)GDALGetDataTypeSize(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DataTypeIsComplex) {
    {
        GDALDataType arg1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DataTypeIsComplex(GDALDataType);");
        }
        arg1 = (GDALDataType) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (int)GDALDataTypeIsComplex(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDataTypeName) {
    {
        GDALDataType arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetDataTypeName(GDALDataType);");
        }
        arg1 = (GDALDataType) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (char *)GDALGetDataTypeName(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDataTypeByName) {
    {
        char *arg1 = (char *) 0 ;
        GDALDataType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetDataTypeByName(char const *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            CPLErrorReset();
            result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetColorInterpretationName) {
    {
        GDALColorInterp arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetColorInterpretationName(GDALColorInterp);");
        }
        arg1 = (GDALColorInterp) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (char *)GDALGetColorInterpretationName(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetPaletteInterpretationName) {
    {
        GDALPaletteInterp arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetPaletteInterpretationName(GDALPaletteInterp);");
        }
        arg1 = (GDALPaletteInterp) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (char *)GDALGetPaletteInterpretationName(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DecToDMS) {
    {
        double arg1 ;
        char *arg2 = (char *) 0 ;
        int arg3 = (int) 2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: DecToDMS(double,char const *,int);");
        }
        arg1 = (double) SvNV(ST(0));
        
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        {
            CPLErrorReset();
            result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_PackedDMSToDec) {
    {
        double arg1 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: PackedDMSToDec(double);");
        }
        arg1 = (double) SvNV(ST(0));
        
        {
            CPLErrorReset();
            result = (double)GDALPackedDMSToDec(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DecToPackedDMS) {
    {
        double arg1 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DecToPackedDMS(double);");
        }
        arg1 = (double) SvNV(ST(0));
        
        {
            CPLErrorReset();
            result = (double)GDALDecToPackedDMS(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_ParseXMLString) {
    {
        char *arg1 = (char *) 0 ;
        CPLXMLNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: ParseXMLString(char *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            CPLErrorReset();
            result = (CPLXMLNode *)CPLParseXMLString(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        {
            /* %typemap(perl5,out) (CPLXMLNode*) */
            ST(argvi) = newRV_noinc((SV*)XMLTreeToAV( result ));
            argvi++;
        }
        {
            /* %typemap(perl5,ret) (CPLXMLNode*) */
            if ( result ) CPLDestroyXMLNode( result );
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SerializeXMLTree) {
    {
        CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SerializeXMLTree(xmlnode);");
        }
        {
            /* %typemap(perl5,in) (CPLXMLNode* xmlnode ) */
            if ( ! (SvROK(ST(0)) && (SvTYPE(SvRV(ST(0)))==SVt_PVAV)) ) {
                croak("argument is not an array ref");
                SWIG_fail;
            }
            AV *av = (AV*)(SvRV(ST(0)));
            arg1 = AVToXMLTree( av );
            if ( !arg1 ) SWIG_fail;
        }
        {
            CPLErrorReset();
            result = (char *)CPLSerializeXMLTree(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            /* %typemap(perl5,freearg) (CPLXMLNode *xmlnode) */
            if ( arg1 ) CPLDestroyXMLNode( arg1 );
        }
        XSRETURN(argvi);
        fail:
        {
            /* %typemap(perl5,freearg) (CPLXMLNode *xmlnode) */
            if ( arg1 ) CPLDestroyXMLNode( arg1 );
        }
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDriverCount) {
    {
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: GetDriverCount();");
        }
        {
            CPLErrorReset();
            result = (int)GetDriverCount();
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDriverByName) {
    {
        char *arg1 = (char *) 0 ;
        GDALDriverShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetDriverByName(name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            CPLErrorReset();
            result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDriverShadow, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GetDriver) {
    {
        int arg1 ;
        GDALDriverShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GetDriver(i);");
        }
        arg1 = (int) SvIV(ST(0));
        {
            CPLErrorReset();
            result = (GDALDriverShadow *)GetDriver(arg1);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDriverShadow, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Open) {
    {
        char *arg1 = (char *) 0 ;
        GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
        GDALDatasetShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: Open(name,eAccess);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            arg2 = (GDALAccess) SvIV(ST(1));
        }
        {
            CPLErrorReset();
            result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDatasetShadow, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OpenShared) {
    {
        char *arg1 = (char *) 0 ;
        GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
        GDALDatasetShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: OpenShared(name,eAccess);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            arg2 = (GDALAccess) SvIV(ST(1));
        }
        {
            CPLErrorReset();
            result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDatasetShadow, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_AutoCreateWarpedVRT) {
    {
        GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
        char *arg2 = (char *) 0 ;
        char *arg3 = (char *) 0 ;
        GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
        double arg5 = (double) 0.0 ;
        GDALDatasetShadow *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 5)) {
            SWIG_croak("Usage: AutoCreateWarpedVRT(src_ds,src_wkt,dst_wkt,eResampleAlg,maxerror);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow,0) < 0) {
                SWIG_croak("Type error in argument 1 of AutoCreateWarpedVRT. Expected _p_GDALDatasetShadow");
            }
        }
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        if (items > 3) {
            arg4 = (GDALResampleAlg) SvIV(ST(3));
        }
        if (items > 4) {
            arg5 = (double) SvNV(ST(4));
            
        }
        {
            CPLErrorReset();
            result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
            
            CPLErr eclass = CPLGetLastErrorType();
            if ( eclass == CE_Failure || eclass == CE_Fatal ) {
                SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDALDatasetShadow, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_GDALDriverShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDriverShadow *) x));
}
static void *_p_GDALDatasetShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDatasetShadow *) x));
}
static void *_p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALRasterBandShadow *) x));
}
static swig_type_info _swigt__p_CPLErrorHandler = {"_p_CPLErrorHandler", "CPLErrorHandler *", 0, 0, 0};
static swig_type_info _swigt__p_CPLXMLNode = {"_p_CPLXMLNode", "CPLXMLNode *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorEntry = {"_p_GDALColorEntry", "GDALColorEntry *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorTable = {"gdal::ColorTable", "GDALColorTable *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDatasetShadow = {"gdal::Dataset", "GDALDatasetShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDriverShadow = {"gdal::Driver", "GDALDriverShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALMajorObjectShadow = {"gdal::MajorObject", "GDALMajorObjectShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALRasterBandShadow = {"gdal::Band", "GDALRasterBandShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDAL_GCP = {"gdal::GCP", "GDAL_GCP *", 0, 0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|GDALPaletteInterp *", 0, 0, 0};
static swig_type_info _swigt__p_p_GDAL_GCP = {"_p_p_GDAL_GCP", "GDAL_GCP **", 0, 0, 0};
static swig_type_info _swigt__p_p_char = {"_p_p_char", "char **", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_CPLErrorHandler,
  &_swigt__p_CPLXMLNode,
  &_swigt__p_GDALColorEntry,
  &_swigt__p_GDALColorTable,
  &_swigt__p_GDALDatasetShadow,
  &_swigt__p_GDALDriverShadow,
  &_swigt__p_GDALMajorObjectShadow,
  &_swigt__p_GDALRasterBandShadow,
  &_swigt__p_GDAL_GCP,
  &_swigt__p_double,
  &_swigt__p_int,
  &_swigt__p_p_GDAL_GCP,
  &_swigt__p_p_char,
};

static swig_cast_info _swigc__p_CPLErrorHandler[] = {  {&_swigt__p_CPLErrorHandler, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_CPLXMLNode[] = {  {&_swigt__p_CPLXMLNode, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorEntry[] = {  {&_swigt__p_GDALColorEntry, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorTable[] = {  {&_swigt__p_GDALColorTable, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDatasetShadow[] = {  {&_swigt__p_GDALDatasetShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDriverShadow[] = {  {&_swigt__p_GDALDriverShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALMajorObjectShadow[] = {  {&_swigt__p_GDALMajorObjectShadow, 0, 0, 0},  {&_swigt__p_GDALDriverShadow, _p_GDALDriverShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALDatasetShadow, _p_GDALDatasetShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALRasterBandShadow, _p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALRasterBandShadow[] = {  {&_swigt__p_GDALRasterBandShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDAL_GCP[] = {  {&_swigt__p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDAL_GCP[] = {  {&_swigt__p_p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_char[] = {  {&_swigt__p_p_char, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_CPLErrorHandler,
  _swigc__p_CPLXMLNode,
  _swigc__p_GDALColorEntry,
  _swigc__p_GDALColorTable,
  _swigc__p_GDALDatasetShadow,
  _swigc__p_GDALDriverShadow,
  _swigc__p_GDALMajorObjectShadow,
  _swigc__p_GDALRasterBandShadow,
  _swigc__p_GDAL_GCP,
  _swigc__p_double,
  _swigc__p_int,
  _swigc__p_p_GDAL_GCP,
  _swigc__p_p_char,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{0,0,0,0,0,0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
{0,0,0,0}
};
static swig_command_info swig_commands[] = {
{"gdalc::UseExceptions", _wrap_UseExceptions},
{"gdalc::DontUseExceptions", _wrap_DontUseExceptions},
{"gdalc::Debug", _wrap_Debug},
{"gdalc::Error", _wrap_Error},
{"gdalc::PushErrorHandler", _wrap_PushErrorHandler},
{"gdalc::PopErrorHandler", _wrap_PopErrorHandler},
{"gdalc::ErrorReset", _wrap_ErrorReset},
{"gdalc::GetLastErrorNo", _wrap_GetLastErrorNo},
{"gdalc::GetLastErrorType", _wrap_GetLastErrorType},
{"gdalc::GetLastErrorMsg", _wrap_GetLastErrorMsg},
{"gdalc::PushFinderLocation", _wrap_PushFinderLocation},
{"gdalc::PopFinderLocation", _wrap_PopFinderLocation},
{"gdalc::FinderClean", _wrap_FinderClean},
{"gdalc::FindFile", _wrap_FindFile},
{"gdalc::SetConfigOption", _wrap_SetConfigOption},
{"gdalc::GetConfigOption", _wrap_GetConfigOption},
{"gdalc::MajorObject_GetDescription", _wrap_MajorObject_GetDescription},
{"gdalc::MajorObject_SetDescription", _wrap_MajorObject_SetDescription},
{"gdalc::MajorObject_GetMetadata", _wrap_MajorObject_GetMetadata},
{"gdalc::MajorObject_SetMetadata", _wrap_MajorObject_SetMetadata},
{"gdalc::Driver_ShortName_get", _wrap_Driver_ShortName_get},
{"gdalc::Driver_LongName_get", _wrap_Driver_LongName_get},
{"gdalc::Driver_HelpTopic_get", _wrap_Driver_HelpTopic_get},
{"gdalc::Driver_Create", _wrap_Driver_Create},
{"gdalc::Driver_CreateCopy", _wrap_Driver_CreateCopy},
{"gdalc::Driver_Delete", _wrap_Driver_Delete},
{"gdalc::GCP_GCPX_set", _wrap_GCP_GCPX_set},
{"gdalc::GCP_GCPX_get", _wrap_GCP_GCPX_get},
{"gdalc::GCP_GCPY_set", _wrap_GCP_GCPY_set},
{"gdalc::GCP_GCPY_get", _wrap_GCP_GCPY_get},
{"gdalc::GCP_GCPZ_set", _wrap_GCP_GCPZ_set},
{"gdalc::GCP_GCPZ_get", _wrap_GCP_GCPZ_get},
{"gdalc::GCP_GCPPixel_set", _wrap_GCP_GCPPixel_set},
{"gdalc::GCP_GCPPixel_get", _wrap_GCP_GCPPixel_get},
{"gdalc::GCP_GCPLine_set", _wrap_GCP_GCPLine_set},
{"gdalc::GCP_GCPLine_get", _wrap_GCP_GCPLine_get},
{"gdalc::GCP_Info_set", _wrap_GCP_Info_set},
{"gdalc::GCP_Info_get", _wrap_GCP_Info_get},
{"gdalc::GCP_Id_set", _wrap_GCP_Id_set},
{"gdalc::GCP_Id_get", _wrap_GCP_Id_get},
{"gdalc::new_GCP", _wrap_new_GCP},
{"gdalc::delete_GCP", _wrap_delete_GCP},
{"gdalc::GDAL_GCP_GCPX_get", _wrap_GDAL_GCP_GCPX_get},
{"gdalc::GDAL_GCP_GCPX_set", _wrap_GDAL_GCP_GCPX_set},
{"gdalc::GDAL_GCP_GCPY_get", _wrap_GDAL_GCP_GCPY_get},
{"gdalc::GDAL_GCP_GCPY_set", _wrap_GDAL_GCP_GCPY_set},
{"gdalc::GDAL_GCP_GCPZ_get", _wrap_GDAL_GCP_GCPZ_get},
{"gdalc::GDAL_GCP_GCPZ_set", _wrap_GDAL_GCP_GCPZ_set},
{"gdalc::GDAL_GCP_GCPPixel_get", _wrap_GDAL_GCP_GCPPixel_get},
{"gdalc::GDAL_GCP_GCPPixel_set", _wrap_GDAL_GCP_GCPPixel_set},
{"gdalc::GDAL_GCP_GCPLine_get", _wrap_GDAL_GCP_GCPLine_get},
{"gdalc::GDAL_GCP_GCPLine_set", _wrap_GDAL_GCP_GCPLine_set},
{"gdalc::GDAL_GCP_Info_get", _wrap_GDAL_GCP_Info_get},
{"gdalc::GDAL_GCP_Info_set", _wrap_GDAL_GCP_Info_set},
{"gdalc::GDAL_GCP_Id_get", _wrap_GDAL_GCP_Id_get},
{"gdalc::GDAL_GCP_Id_set", _wrap_GDAL_GCP_Id_set},
{"gdalc::GDAL_GCP_get_GCPX", _wrap_GDAL_GCP_get_GCPX},
{"gdalc::GDAL_GCP_set_GCPX", _wrap_GDAL_GCP_set_GCPX},
{"gdalc::GDAL_GCP_get_GCPY", _wrap_GDAL_GCP_get_GCPY},
{"gdalc::GDAL_GCP_set_GCPY", _wrap_GDAL_GCP_set_GCPY},
{"gdalc::GDAL_GCP_get_GCPZ", _wrap_GDAL_GCP_get_GCPZ},
{"gdalc::GDAL_GCP_set_GCPZ", _wrap_GDAL_GCP_set_GCPZ},
{"gdalc::GDAL_GCP_get_GCPPixel", _wrap_GDAL_GCP_get_GCPPixel},
{"gdalc::GDAL_GCP_set_GCPPixel", _wrap_GDAL_GCP_set_GCPPixel},
{"gdalc::GDAL_GCP_get_GCPLine", _wrap_GDAL_GCP_get_GCPLine},
{"gdalc::GDAL_GCP_set_GCPLine", _wrap_GDAL_GCP_set_GCPLine},
{"gdalc::GDAL_GCP_get_Info", _wrap_GDAL_GCP_get_Info},
{"gdalc::GDAL_GCP_set_Info", _wrap_GDAL_GCP_set_Info},
{"gdalc::GDAL_GCP_get_Id", _wrap_GDAL_GCP_get_Id},
{"gdalc::GDAL_GCP_set_Id", _wrap_GDAL_GCP_set_Id},
{"gdalc::GCPsToGeoTransform", _wrap_GCPsToGeoTransform},
{"gdalc::Dataset_RasterXSize_get", _wrap_Dataset_RasterXSize_get},
{"gdalc::Dataset_RasterYSize_get", _wrap_Dataset_RasterYSize_get},
{"gdalc::Dataset_RasterCount_get", _wrap_Dataset_RasterCount_get},
{"gdalc::delete_Dataset", _wrap_delete_Dataset},
{"gdalc::Dataset_GetDriver", _wrap_Dataset_GetDriver},
{"gdalc::Dataset_GetRasterBand", _wrap_Dataset_GetRasterBand},
{"gdalc::Dataset_GetProjection", _wrap_Dataset_GetProjection},
{"gdalc::Dataset_GetProjectionRef", _wrap_Dataset_GetProjectionRef},
{"gdalc::Dataset_SetProjection", _wrap_Dataset_SetProjection},
{"gdalc::Dataset_GetGeoTransform", _wrap_Dataset_GetGeoTransform},
{"gdalc::Dataset_SetGeoTransform", _wrap_Dataset_SetGeoTransform},
{"gdalc::Dataset_BuildOverviews", _wrap_Dataset_BuildOverviews},
{"gdalc::Dataset_GetGCPCount", _wrap_Dataset_GetGCPCount},
{"gdalc::Dataset_GetGCPProjection", _wrap_Dataset_GetGCPProjection},
{"gdalc::Dataset_GetGCPs", _wrap_Dataset_GetGCPs},
{"gdalc::Dataset_SetGCPs", _wrap_Dataset_SetGCPs},
{"gdalc::Dataset_FlushCache", _wrap_Dataset_FlushCache},
{"gdalc::Dataset_AddBand", _wrap_Dataset_AddBand},
{"gdalc::Dataset_WriteRaster", _wrap_Dataset_WriteRaster},
{"gdalc::Band_XSize_get", _wrap_Band_XSize_get},
{"gdalc::Band_YSize_get", _wrap_Band_YSize_get},
{"gdalc::Band_DataType_get", _wrap_Band_DataType_get},
{"gdalc::Band_GetRasterColorInterpretation", _wrap_Band_GetRasterColorInterpretation},
{"gdalc::Band_SetRasterColorInterpretation", _wrap_Band_SetRasterColorInterpretation},
{"gdalc::Band_GetNoDataValue", _wrap_Band_GetNoDataValue},
{"gdalc::Band_SetNoDataValue", _wrap_Band_SetNoDataValue},
{"gdalc::Band_GetMinimum", _wrap_Band_GetMinimum},
{"gdalc::Band_GetMaximum", _wrap_Band_GetMaximum},
{"gdalc::Band_GetOffset", _wrap_Band_GetOffset},
{"gdalc::Band_GetScale", _wrap_Band_GetScale},
{"gdalc::Band_GetOverviewCount", _wrap_Band_GetOverviewCount},
{"gdalc::Band_GetOverview", _wrap_Band_GetOverview},
{"gdalc::Band_Checksum", _wrap_Band_Checksum},
{"gdalc::Band_ComputeRasterMinMax", _wrap_Band_ComputeRasterMinMax},
{"gdalc::Band_Fill", _wrap_Band_Fill},
{"gdalc::Band_ReadRaster", _wrap_Band_ReadRaster},
{"gdalc::Band_WriteRaster", _wrap_Band_WriteRaster},
{"gdalc::Band_FlushCache", _wrap_Band_FlushCache},
{"gdalc::Band_GetRasterColorTable", _wrap_Band_GetRasterColorTable},
{"gdalc::Band_SetRasterColorTable", _wrap_Band_SetRasterColorTable},
{"gdalc::new_ColorTable", _wrap_new_ColorTable},
{"gdalc::delete_ColorTable", _wrap_delete_ColorTable},
{"gdalc::ColorTable_Clone", _wrap_ColorTable_Clone},
{"gdalc::ColorTable_GetPaletteInterpretation", _wrap_ColorTable_GetPaletteInterpretation},
{"gdalc::ColorTable_GetCount", _wrap_ColorTable_GetCount},
{"gdalc::ColorTable_GetColorEntry", _wrap_ColorTable_GetColorEntry},
{"gdalc::ColorTable_GetColorEntryAsRGB", _wrap_ColorTable_GetColorEntryAsRGB},
{"gdalc::ColorTable_SetColorEntry", _wrap_ColorTable_SetColorEntry},
{"gdalc::AllRegister", _wrap_AllRegister},
{"gdalc::GetCacheMax", _wrap_GetCacheMax},
{"gdalc::SetCacheMax", _wrap_SetCacheMax},
{"gdalc::GetCacheUsed", _wrap_GetCacheUsed},
{"gdalc::GetDataTypeSize", _wrap_GetDataTypeSize},
{"gdalc::DataTypeIsComplex", _wrap_DataTypeIsComplex},
{"gdalc::GetDataTypeName", _wrap_GetDataTypeName},
{"gdalc::GetDataTypeByName", _wrap_GetDataTypeByName},
{"gdalc::GetColorInterpretationName", _wrap_GetColorInterpretationName},
{"gdalc::GetPaletteInterpretationName", _wrap_GetPaletteInterpretationName},
{"gdalc::DecToDMS", _wrap_DecToDMS},
{"gdalc::PackedDMSToDec", _wrap_PackedDMSToDec},
{"gdalc::DecToPackedDMS", _wrap_DecToPackedDMS},
{"gdalc::ParseXMLString", _wrap_ParseXMLString},
{"gdalc::SerializeXMLTree", _wrap_SerializeXMLTree},
{"gdalc::GetDriverCount", _wrap_GetDriverCount},
{"gdalc::GetDriverByName", _wrap_GetDriverByName},
{"gdalc::GetDriver", _wrap_GetDriver},
{"gdalc::Open", _wrap_Open},
{"gdalc::OpenShared", _wrap_OpenShared},
{"gdalc::AutoCreateWarpedVRT", _wrap_AutoCreateWarpedVRT},
{0,0}
};
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif



#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    
    SWIG_InitializeModule(0);
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        } else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            SWIG_MakePackedObj(sv, swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype));
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    
    /* gdal_perl.i %init code */
    UseExceptions();
    if ( GDALGetDriverCount() == 0 ) {
        GDALAllRegister();
    }
    
    SWIG_TypeClientData(SWIGTYPE_p_GDALMajorObjectShadow, (void*) "gdal::MajorObject");
    SWIG_TypeClientData(SWIGTYPE_p_GDALDriverShadow, (void*) "gdal::Driver");
    SWIG_TypeClientData(SWIGTYPE_p_GDAL_GCP, (void*) "gdal::GCP");
    SWIG_TypeClientData(SWIGTYPE_p_GDALDatasetShadow, (void*) "gdal::Dataset");
    SWIG_TypeClientData(SWIGTYPE_p_GDALRasterBandShadow, (void*) "gdal::Band");
    SWIG_TypeClientData(SWIGTYPE_p_GDALColorTable, (void*) "gdal::ColorTable");
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

