/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



#include <Python.h>

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * SWIG API. Portion that goes into the runtime
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * for internal method declarations
 * ----------------------------------------------------------------------------- */

#ifndef SWIGINTERN
#  define SWIGINTERN static SWIGUNUSED
#endif

#ifndef SWIGINTERNINLINE
#  define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/*
  Exception handling in wrappers
*/
#define SWIG_fail                goto fail
#define SWIG_arg_fail(arg)       SWIG_Python_ArgFail(arg)
#define SWIG_append_errmsg(msg)   SWIG_Python_AddErrMesg(msg,0)
#define SWIG_preppend_errmsg(msg) SWIG_Python_AddErrMesg(msg,1)
#define SWIG_type_error(type,obj) SWIG_Python_TypeError(type,obj)
#define SWIG_null_ref(type)       SWIG_Python_NullRef(type)

/*
  Contract support
*/
#define SWIG_contract_assert(expr, msg) \
 if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

/* -----------------------------------------------------------------------------
 * Constant declarations
 * ----------------------------------------------------------------------------- */

/* Constant Types */
#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;


/* -----------------------------------------------------------------------------
 * Alloc. memory flags
 * ----------------------------------------------------------------------------- */
#define SWIG_OLDOBJ  1
#define SWIG_NEWOBJ  SWIG_OLDOBJ + 1
#define SWIG_PYSTR   SWIG_NEWOBJ + 1

#ifdef __cplusplus
}
#endif


/***********************************************************************
 * pyrun.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags)    SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags)       SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags)  SWIG_Python_MustGetPtr(p, type, argnum, flags)
 

/* Python-specific SWIG API */
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags)   SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type)              SWIG_Python_NewPackedObj(ptr, sz, type)

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Python_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Python_SetModule(pointer)

/* -----------------------------------------------------------------------------
 * Pointer declarations
 * ----------------------------------------------------------------------------- */
/*
  Use SWIG_NO_COBJECT_TYPES to force the use of strings to represent
  C/C++ pointers in the python side. Very useful for debugging, but
  not always safe.
*/
#if !defined(SWIG_NO_COBJECT_TYPES) && !defined(SWIG_COBJECT_TYPES)
#  define SWIG_COBJECT_TYPES
#endif

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2


/* Add PyOS_snprintf for old Pythons */
#if PY_VERSION_HEX < 0x02020000
#define PyOS_snprintf snprintf
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * Create a new pointer string 
 * ----------------------------------------------------------------------------- */
#ifndef SWIG_BUFFER_SIZE
#define SWIG_BUFFER_SIZE 1024
#endif

/* A crude PyString_FromFormat implementation for old Pythons */
#if PY_VERSION_HEX < 0x02020000
static PyObject *
PyString_FromFormat(const char *fmt, ...) {
  va_list ap;
  char buf[SWIG_BUFFER_SIZE * 2];
  int res;
  va_start(ap, fmt);
  res = vsnprintf(buf, sizeof(buf), fmt, ap);
  va_end(ap);
  return (res < 0 || res >= sizeof(buf)) ? 0 : PyString_FromString(buf);
}
#endif

#if PY_VERSION_HEX < 0x01060000
#define PyObject_Del(op) PyMem_DEL((op))
#endif

#if defined(SWIG_COBJECT_TYPES)
#if !defined(SWIG_COBJECT_PYTHON)
/* -----------------------------------------------------------------------------
 * Implements a simple Swig Object type, and use it instead of PyCObject
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *ptr;
  const char *desc;
} PySwigObject;

/* Declarations for objects of type PySwigObject */

SWIGRUNTIME int
PySwigObject_print(PySwigObject *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  flags = flags;
  if (SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result))) {
    fputs("<Swig Object at ", fp); fputs(result, fp); fputs(">", fp);
    return 0; 
  } else {
    return 1; 
  }
}
  
SWIGRUNTIME PyObject *
PySwigObject_repr(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromFormat("<Swig Object at %s>", result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_str(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromString(result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_long(PySwigObject *v)
{
  return PyLong_FromVoidPtr(v->ptr);
}

SWIGRUNTIME PyObject *
PySwigObject_format(const char* fmt, PySwigObject *v)
{
  PyObject *res = NULL;
  PyObject *args = PyTuple_New(1);
  if (args && (PyTuple_SetItem(args, 0, PySwigObject_long(v)) == 0)) {
    PyObject *ofmt = PyString_FromString(fmt);
    if (ofmt) {
      res = PyString_Format(ofmt,args);
      Py_DECREF(ofmt);
    }
    Py_DECREF(args);
  }  
  return res;
}

SWIGRUNTIME PyObject *
PySwigObject_oct(PySwigObject *v)
{
  return PySwigObject_format("%o",v);
}

SWIGRUNTIME PyObject *
PySwigObject_hex(PySwigObject *v)
{
  return PySwigObject_format("%x",v);
}

SWIGRUNTIME int
PySwigObject_compare(PySwigObject *v, PySwigObject *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return (c > 0) ? 1 : -1;
  } else {
    void *i = v->ptr;
    void *j = w->ptr;
    return (i < j) ? -1 : ((i > j) ? 1 : 0);
  }
}

SWIGRUNTIME void
PySwigObject_dealloc(PySwigObject *self)
{
  PyObject_Del(self);
}

SWIGRUNTIME PyTypeObject*
PySwigObject_type(void) {
  static char pyswigobject_type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  
  static PyNumberMethods PySwigObject_as_number = {
    (binaryfunc)0, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)0, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0, /*nb_remainder*/
    (binaryfunc)0, /*nb_divmod*/
    (ternaryfunc)0,/*nb_power*/
    (unaryfunc)0,  /*nb_negative*/
    (unaryfunc)0,  /*nb_positive*/
    (unaryfunc)0,  /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    0,		   /*nb_invert*/
    0,		   /*nb_lshift*/
    0,		   /*nb_rshift*/
    0,		   /*nb_and*/
    0,		   /*nb_xor*/
    0,		   /*nb_or*/
    (coercion)0,   /*nb_coerce*/
    (unaryfunc)PySwigObject_long, /*nb_int*/
    (unaryfunc)PySwigObject_long, /*nb_long*/
    (unaryfunc)0,                 /*nb_float*/
    (unaryfunc)PySwigObject_oct,  /*nb_oct*/
    (unaryfunc)PySwigObject_hex,  /*nb_hex*/
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_true_divide */ 
#elif PY_VERSION_HEX >= 0x02000000
    0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_or */
#endif
  };

  static PyTypeObject pyswigobject_type
#if !defined(__cplusplus)
  ;  
  static int type_init = 0;
  if (!type_init) {
    PyTypeObject tmp
#endif
    = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    (char *)"PySwigObject",		/*tp_name*/
    sizeof(PySwigObject),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigObject_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigObject_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigObject_compare,	/*tp_compare*/
    (reprfunc)PySwigObject_repr,	/*tp_repr*/
    &PySwigObject_as_number,	        /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigObject_str,		/*tp_str*/
    /* Space for future expansion */
    0,0,0,0,
    pyswigobject_type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
#if !defined(__cplusplus)
    pyswigobject_type = tmp;
    type_init = 1;
  }
#endif
  return &pyswigobject_type;
}

SWIGRUNTIME PyObject *
PySwigObject_FromVoidPtrAndDesc(void *ptr, const char *desc)
{
  PySwigObject *self = PyObject_NEW(PySwigObject, PySwigObject_type());
  if (self) {
    self->ptr = ptr;
    self->desc = desc;
  }
  return (PyObject *)self;
}

SWIGRUNTIMEINLINE void *
PySwigObject_AsVoidPtr(PyObject *self)
{
  return ((PySwigObject *)self)->ptr;
}

SWIGRUNTIMEINLINE const char *
PySwigObject_GetDesc(PyObject *self)
{
  return ((PySwigObject *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigObject_Check(PyObject *op) {
  return ((op)->ob_type == PySwigObject_type()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigObject") == 0);
}

/* -----------------------------------------------------------------------------
 * Implements a simple Swig Packed type, and use it instead of string
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *pack;
  const char *desc;
  size_t size;
} PySwigPacked;

SWIGRUNTIME int
PySwigPacked_print(PySwigPacked *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  flags = flags;
  fputs("<Swig Packed ", fp); 
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    fputs("at ", fp); 
    fputs(result, fp); 
  }
  fputs(v->desc,fp); 
  fputs(">", fp);
  return 0; 
}
  
SWIGRUNTIME PyObject *
PySwigPacked_repr(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    return PyString_FromFormat("<Swig Packed at %s%s>", result, v->desc);
  } else {
    return PyString_FromFormat("<Swig Packed %s>", v->desc);
  }  
}

SWIGRUNTIME PyObject *
PySwigPacked_str(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))){
    return PyString_FromFormat("%s%s", result, v->desc);
  } else {
    return PyString_FromString(v->desc);
  }  
}

SWIGRUNTIME int
PySwigPacked_compare(PySwigPacked *v, PySwigPacked *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return (c > 0) ? 1 : -1;
  } else {
    size_t i = v->size;
    size_t j = w->size;
    int s = (i < j) ? -1 : ((i > j) ? 1 : 0);
    return s ? s : strncmp((char *)v->pack, (char *)w->pack, 2*v->size);
  }
}

SWIGRUNTIME void
PySwigPacked_dealloc(PySwigPacked *self)
{
  free(self->pack);
  PyObject_Del(self);
}

SWIGRUNTIME PyTypeObject*
PySwigPacked_type(void) {
  static char pyswigpacked_type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  static PyTypeObject pyswigpacked_type
#if !defined(__cplusplus)
  ;
  static int type_init = 0;  
  if (!type_init) {
    PyTypeObject tmp
#endif
    = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    (char *)"PySwigPacked",		/*tp_name*/
    sizeof(PySwigPacked),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigPacked_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigPacked_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigPacked_compare,	/*tp_compare*/
    (reprfunc)PySwigPacked_repr,	/*tp_repr*/
    0,	                                /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigPacked_str,		/*tp_str*/
    /* Space for future expansion */
    0,0,0,0,
    pyswigpacked_type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000         
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
#if !defined(__cplusplus)
    pyswigpacked_type = tmp;
    type_init = 1;
  }
#endif
  return &pyswigpacked_type;
}

SWIGRUNTIME PyObject *
PySwigPacked_FromDataAndDesc(void *ptr, size_t size, const char *desc)
{
  PySwigPacked *self = PyObject_NEW(PySwigPacked, PySwigPacked_type());
  if (self == NULL) {
    return NULL;
  } else {
    void *pack = malloc(size);
    if (pack) {
      memcpy(pack, ptr, size);
      self->pack = pack;
      self->desc = desc;
      self->size = size;
      return (PyObject *) self;
    }
    return NULL;
  }
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_UnpackData(PyObject *obj, void *ptr, size_t size)
{
  PySwigPacked *self = (PySwigPacked *)obj;
  if (self->size != size) return 0;
  memcpy(ptr, self->pack, size);
  return self->desc;
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_GetDesc(PyObject *self)
{
  return ((PySwigPacked *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigPacked_Check(PyObject *op) {
  return ((op)->ob_type == PySwigPacked_type()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigPacked") == 0);
}

#else
/* -----------------------------------------------------------------------------
 * Use the old Python PyCObject instead of PySwigObject
 * ----------------------------------------------------------------------------- */

#define PySwigObject_GetDesc(obj)	           PyCObject_GetDesc(obj)
#define PySwigObject_Check(obj)	           PyCObject_Check(obj)
#define PySwigObject_AsVoidPtr(obj)	   PyCObject_AsVoidPtr(obj)
#define PySwigObject_FromVoidPtrAndDesc(p, d)  PyCObject_FromVoidPtrAndDesc(p, d, NULL)

#endif

#endif

/* -----------------------------------------------------------------------------
 * errors manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIME void
SWIG_Python_TypeError(const char *type, PyObject *obj)
{
  if (type) {
#if defined(SWIG_COBJECT_TYPES)
    if (obj && PySwigObject_Check(obj)) {
      const char *otype = (const char *) PySwigObject_GetDesc(obj);
      if (otype) {
	PyErr_Format(PyExc_TypeError, "a '%s' is expected, 'PySwigObject(%s)' is received",
		     type, otype);
	return;
      }
    } else 
#endif      
    {
      const char *otype = (obj ? obj->ob_type->tp_name : 0); 
      if (otype) {
	PyObject *str = PyObject_Str(obj);
	const char *cstr = str ? PyString_AsString(str) : 0;
	if (cstr) {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s(%s)' is received",
		       type, otype, cstr);
	} else {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s' is received",
		       type, otype);
	}
	Py_XDECREF(str);
	return;
      }
    }   
    PyErr_Format(PyExc_TypeError, "a '%s' is expected", type);
  } else {
    PyErr_Format(PyExc_TypeError, "unexpected type is received");
  }
}

SWIGRUNTIMEINLINE void
SWIG_Python_NullRef(const char *type)
{
  if (type) {
    PyErr_Format(PyExc_TypeError, "null reference of type '%s' was received",type);
  } else {
    PyErr_Format(PyExc_TypeError, "null reference was received");
  }
}

SWIGRUNTIME int
SWIG_Python_AddErrMesg(const char* mesg, int infront)
{
  if (PyErr_Occurred()) {
    PyObject *type = 0;
    PyObject *value = 0;
    PyObject *traceback = 0;
    PyErr_Fetch(&type, &value, &traceback);
    if (value) {
      PyObject *old_str = PyObject_Str(value);
      Py_XINCREF(type);
      PyErr_Clear();
      if (infront) {
	PyErr_Format(type, "%s %s", mesg, PyString_AsString(old_str));
      } else {
	PyErr_Format(type, "%s %s", PyString_AsString(old_str), mesg);
      }
      Py_DECREF(old_str);
    }
    return 1;
  } else {
    return 0;
  }
}

SWIGRUNTIME int
SWIG_Python_ArgFail(int argnum)
{
  if (PyErr_Occurred()) {
    /* add information about failing argument */
    char mesg[256];
    PyOS_snprintf(mesg, sizeof(mesg), "argument number %d:", argnum);
    return SWIG_Python_AddErrMesg(mesg, 1);
  } else {
    return 0;
  }
}


/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

/* Convert a pointer value */
SWIGRUNTIME int
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;
  void *vptr;
  
  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }

#ifdef SWIG_COBJECT_TYPES
  if (!(PySwigObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PySwigObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  vptr = PySwigObject_AsVoidPtr(obj);
  c = (const char *) PySwigObject_GetDesc(obj);
  if (newref) { Py_DECREF(obj); }
  goto type_check;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackVoidPtr(c, &vptr, ty->name);
  if (newref) { Py_DECREF(obj); }
  if (!c) goto type_error;
#endif

type_check:
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,vptr);
  } else {
    *ptr = vptr;
  }
  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject_SetAttrString(pyobj,(char*)"thisown",Py_False);
  }
  return 0;

type_error:
  PyErr_Clear();
  if (pyobj && !obj) {    
    obj = pyobj;
    if (PyCFunction_Check(obj)) {
      /* here we get the method pointer for callbacks */
      char *doc = (((PyCFunctionObject *)obj) -> m_ml -> ml_doc);
      c = doc ? strstr(doc, "swig_ptr: ") : 0;
      if (c) {
	c = ty ? SWIG_UnpackVoidPtr(c + 10, &vptr, ty->name) : 0;
	if (!c) goto type_error;
	goto type_check;
      }
    }
  }
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ pointer", obj);
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME void *
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  if (SWIG_Python_ConvertPtr(obj, &result, ty, flags) == -1) {
    PyErr_Clear();
    if (flags & SWIG_POINTER_EXCEPTION) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
      SWIG_Python_ArgFail(argnum);
    }
  }
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME int
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, size_t sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char *c = 0;

#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  c = PySwigPacked_UnpackData(obj, ptr, sz);
#else
  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackDataName(c, ptr, sz, ty->name);
#endif
  if (!c) goto type_error;
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:
  PyErr_Clear();
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ packed data", obj);
    }
  }
  return -1;
}  

/* Create a new array object */
SWIGRUNTIME PyObject *
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj = 0;
  if (!type) {
    if (!PyErr_Occurred()) {
      PyErr_Format(PyExc_TypeError, "Swig: null type passed to NewPointerObj");
    }
    return robj;
  }
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PySwigObject_FromVoidPtrAndDesc((void *) ptr, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackVoidPtr(result, ptr, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject_SetAttrString(inst,(char*)"thisown",Py_True);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME PyObject *
SWIG_Python_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  robj = PySwigPacked_FromDataAndDesc((void *) ptr, sz, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackDataName(result, ptr, sz, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  return robj;
}

/* -----------------------------------------------------------------------------*
 *  Get type list 
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
void *SWIG_ReturnGlobalTypeList(void *);
#endif

SWIGRUNTIME swig_module_info *
SWIG_Python_GetModule(void) {
  static void *type_pointer = (void *)0;
  /* first check if module already created */
  if (!type_pointer) {
#ifdef SWIG_LINK_RUNTIME
    type_pointer = SWIG_ReturnGlobalTypeList((void *)0);
#else
    type_pointer = PyCObject_Import((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				    (char*)"type_pointer" SWIG_TYPE_TABLE_NAME);
    if (PyErr_Occurred()) {
      PyErr_Clear();
      type_pointer = (void *)0;
    }
#endif
  }
  return (swig_module_info *) type_pointer;
}

#if PY_MAJOR_VERSION < 2
/* PyModule_AddObject function was introduced in Python 2.0.  The following function
is copied out of Python/modsupport.c in python version 2.3.4 */
SWIGINTERN int
PyModule_AddObject(PyObject *m, char *name, PyObject *o)
{
  PyObject *dict;
  if (!PyModule_Check(m)) {
    PyErr_SetString(PyExc_TypeError,
		    "PyModule_AddObject() needs module as first arg");
    return -1;
  }
  if (!o) {
    PyErr_SetString(PyExc_TypeError,
		    "PyModule_AddObject() needs non-NULL value");
    return -1;
  }
  
  dict = PyModule_GetDict(m);
  if (dict == NULL) {
    /* Internal error -- modules must have a dict! */
    PyErr_Format(PyExc_SystemError, "module '%s' has no __dict__",
		 PyModule_GetName(m));
    return -1;
  }
  if (PyDict_SetItemString(dict, name, o))
    return -1;
  Py_DECREF(o);
  return 0;
}
#endif

SWIGRUNTIME void
SWIG_Python_SetModule(swig_module_info *swig_module) {
  static PyMethodDef swig_empty_runtime_method_table[] = { {NULL, NULL, 0, NULL} };/* Sentinel */

  PyObject *module = Py_InitModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				   swig_empty_runtime_method_table);
  PyObject *pointer = PyCObject_FromVoidPtr((void *) swig_module, NULL);
  if (pointer && module) {
    PyModule_AddObject(module, (char*)"type_pointer" SWIG_TYPE_TABLE_NAME, pointer);
  }
}

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_OSRCoordinateTransformationShadow swig_types[0]
#define SWIGTYPE_p_OSRSpatialReferenceShadow swig_types[1]
#define SWIGTYPE_p_char swig_types[2]
#define SWIGTYPE_p_double swig_types[3]
#define SWIGTYPE_p_int swig_types[4]
#define SWIGTYPE_p_long swig_types[5]
#define SWIGTYPE_p_p_char swig_types[6]
#define SWIGTYPE_p_p_double swig_types[7]
#define SWIGTYPE_ptrdiff_t swig_types[8]
#define SWIGTYPE_size_t swig_types[9]
#define SWIGTYPE_std__ptrdiff_t swig_types[10]
#define SWIGTYPE_std__size_t swig_types[11]
static swig_type_info *swig_types[13];
static swig_module_info swig_module = {swig_types, 12, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _osr.so
  ------------------------------------------------*/
#define SWIG_init    init_osr

#define SWIG_name    "_osr"

SWIGINTERN PyObject *
SWIG_FromCharPtr(const char* cptr)
{ 
  if (cptr) {
    size_t size = strlen(cptr);
    if (size > INT_MAX) {
      return SWIG_NewPointerObj(const_cast<char* >(cptr), 
				SWIG_TypeQuery("char *"), 0);
    } else {
      if (size != 0) {
	return PyString_FromStringAndSize(cptr, size);
      } else {
	return PyString_FromString(cptr);
      }
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}


  /*@/home/kruland/opt/share/swig/1.3.26/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_double PyFloat_FromDouble
/*@@*/


#include <iostream>
using namespace std;

#include "cpl_string.h"
#include "cpl_conv.h"

#include "ogr_srs_api.h"

typedef void OSRSpatialReferenceShadow;
typedef void OSRCoordinateTransformationShadow;



static PyObject *
py_OPTGetProjectionMethods(PyObject *self, PyObject *args) {

    PyObject *py_MList;
    char     **papszMethods;
    int      iMethod;
    
    self = self;
    args = args;

    papszMethods = OPTGetProjectionMethods();
    py_MList = PyList_New(CSLCount(papszMethods));

    for( iMethod = 0; papszMethods[iMethod] != NULL; iMethod++ )
    {
	char    *pszUserMethodName;
	char    **papszParameters;
	PyObject *py_PList;
	int       iParam;

	papszParameters = OPTGetParameterList( papszMethods[iMethod], 
					       &pszUserMethodName );
        if( papszParameters == NULL )
            return NULL;

	py_PList = PyList_New(CSLCount(papszParameters));
	for( iParam = 0; papszParameters[iParam] != NULL; iParam++ )
       	{
	    char    *pszType;
	    char    *pszUserParamName;
            double  dfDefault;

	    OPTGetParameterInfo( papszMethods[iMethod], 
				 papszParameters[iParam], 
				 &pszUserParamName, 
				 &pszType, &dfDefault );
	    PyList_SetItem(py_PList, iParam, 
			   Py_BuildValue("(sssd)", 
					 papszParameters[iParam], 
					 pszUserParamName, 
                                         pszType, dfDefault ));
	}
	
	CSLDestroy( papszParameters );

	PyList_SetItem(py_MList, iMethod, 
		       Py_BuildValue("(ssO)", 
		                     papszMethods[iMethod], 
				     pszUserMethodName, 
		                     py_PList));
    }

    CSLDestroy( papszMethods );

    return py_MList;
}


OGRErr GetWellKnownGeogCSAsWKT( const char *name, char **argout ) {
  OGRSpatialReferenceH srs = OSRNewSpatialReference("");
  OSRSetWellKnownGeogCS( srs, name );
  OGRErr rcode = OSRExportToWkt ( srs, argout );  
  OSRDestroySpatialReference( srs );
  return rcode;
}


/* returns SWIG_OLDOBJ if the input is a raw char*, SWIG_PYSTR if is a PyString */
SWIGINTERN int
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize)
{
  static swig_type_info* pchar_info = 0;
  char* vptr = 0;
  if (!pchar_info) pchar_info = SWIG_TypeQuery("char *");
  if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_info, 0) != -1) {
    if (cptr) *cptr = vptr;
    if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
    return SWIG_OLDOBJ;
  } else {
    PyErr_Clear();
    if (PyString_Check(obj)) {
      if (cptr) {
	*cptr = PyString_AS_STRING(obj);
	if (psize) {
	  *psize = PyString_GET_SIZE(obj) + 1;
	}
      }
      return SWIG_PYSTR;
    }
  }
  if (cptr) {
    SWIG_type_error("char *", obj);
  }
  return 0;
}


SWIGINTERNINLINE int
SWIG_AsCharPtr(PyObject *obj, char **val)
{
  if (SWIG_AsCharPtrAndSize(obj, val, (size_t*)(0))) {
    return 1;
  }
  if (val) {
    PyErr_Clear();
    SWIG_type_error("char *", obj);
  }
  return 0;
}


SWIGINTERN PyObject*
t_output_helper(PyObject* target, PyObject* o) {
  if (!target) {
    target = o;
  } else if (target == Py_None) {  
    Py_DECREF(target);
    target = o;
  } else {
    if (!PyList_Check(target)) {
      PyObject *o2 = target;
      target = PyList_New(1);
      PyList_SetItem(target, 0, o2);
    }
    PyList_Append(target,o);
    Py_DECREF(o);
    }
  return target;
}



static char const *
OGRErrMessages( int rc ) {
  switch( rc ) {
  case 0:
    return "OGR Error: None";
  case 1:
    return "OGR Error: Not enough data";
  case 2:
    return "OGR Error: Not enough memory";
  case 3:
    return "OGR Error: Unsupported geometry type";
  case 4:
    return "OGR Error: Unsupported operation";
  case 5:
    return "OGR Error: Corrupt data";
  case 6:
    return "OGR Error: General Error";
  case 7:
    return "OGR Error: Unsupported SRS";
  default:
    return "OGR Error: Unknown";
  }
}

static OSRSpatialReferenceShadow *new_OSRSpatialReferenceShadow(char const *wkt=""){
    OSRSpatialReferenceShadow *sr = (OSRSpatialReferenceShadow*) OSRNewSpatialReference(wkt);
    if (sr) {
      OSRReference( sr );
    }
    return sr;
  }
static void delete_OSRSpatialReferenceShadow(OSRSpatialReferenceShadow *self){
    if (OSRDereference( self ) == 0 ) {
      OSRDestroySpatialReference( self );
    }
  }
static char *OSRSpatialReferenceShadow___str__(OSRSpatialReferenceShadow *self){
    char *buf = 0;
    OSRExportToPrettyWkt( self, &buf, 0 );
    return buf;
  }
static int OSRSpatialReferenceShadow_IsSame(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRIsSame( self, rhs );
  }

  /*@/home/kruland/opt/share/swig/1.3.26/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_int PyInt_FromLong
/*@@*/

static int OSRSpatialReferenceShadow_IsSameGeogCS(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRIsSameGeogCS( self, rhs );
  }
static int OSRSpatialReferenceShadow_IsGeographic(OSRSpatialReferenceShadow *self){
    return OSRIsGeographic(self);
  }
static int OSRSpatialReferenceShadow_IsProjected(OSRSpatialReferenceShadow *self){
    return OSRIsProjected(self);
  }

#include <limits.h>


SWIGINTERN int
  SWIG_CheckLongInRange(long value, long min_value, long max_value,
			const char *errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %ld is less than '%s' minimum %ld", 
		   value, errmsg, min_value);
    }
    return 0;    
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %ld is greater than '%s' maximum %ld", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGINTERN int
  SWIG_AsVal_long(PyObject * obj, long* val)
{
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AsLong(obj);
    return 1;
  }
  if (val) {
    SWIG_type_error("long", obj);
  }
  return 0;
 }


#if INT_MAX != LONG_MAX
SWIGINTERN int
  SWIG_AsVal_int(PyObject *obj, int *val)
{ 
  const char* errmsg = val ? "int" : (char*)0;
  long v;
  if (SWIG_AsVal_long(obj, &v)) {
    if (SWIG_CheckLongInRange(v, INT_MIN,INT_MAX, errmsg)) {
      if (val) *val = static_cast<int >(v);
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNINLINE int
  SWIG_AsVal_int(PyObject *obj, int *val)
{
  return SWIG_AsVal_long(obj,(long*)val);
}
#endif


SWIGINTERNINLINE int
SWIG_As_int(PyObject* obj)
{
  int v;
  if (!SWIG_AsVal_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(int));
  }
  return v;
}

  
SWIGINTERNINLINE int
SWIG_Check_int(PyObject* obj)
{
  return SWIG_AsVal_int(obj, (int*)0);
}

static char const *OSRSpatialReferenceShadow_GetAttrValue(OSRSpatialReferenceShadow *self,char const *name,int child=0){
    return OSRGetAttrValue( self, name, child );
  }
static OGRErr OSRSpatialReferenceShadow_SetAttrValue(OSRSpatialReferenceShadow *self,char const *name,char const *value){
    return OSRSetAttrValue( self, name, value ); 
  }

SWIGINTERN int
  SWIG_AsVal_double(PyObject *obj, double *val)
{
  if (PyFloat_Check(obj)) {
    if (val) *val = PyFloat_AsDouble(obj);
    return 1;
  }  
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AsLong(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    double v = PyLong_AsDouble(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    SWIG_type_error("double", obj);
  }
  return 0;
}


SWIGINTERNINLINE double
SWIG_As_double(PyObject* obj)
{
  double v;
  if (!SWIG_AsVal_double(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(double));
  }
  return v;
}

  
SWIGINTERNINLINE int
SWIG_Check_double(PyObject* obj)
{
  return SWIG_AsVal_double(obj, (double*)0);
}

static OGRErr OSRSpatialReferenceShadow_SetAngularUnits(OSRSpatialReferenceShadow *self,char const *name,double to_radians){
    return OSRSetAngularUnits( self, name, to_radians );
  }
static double OSRSpatialReferenceShadow_GetAngularUnits(OSRSpatialReferenceShadow *self){
    // Return code ignored.
    return OSRGetAngularUnits( self, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetLinearUnits(OSRSpatialReferenceShadow *self,char const *name,double to_meters){
    return OSRSetAngularUnits( self, name, to_meters );
  }
static double OSRSpatialReferenceShadow_GetLinearUnits(OSRSpatialReferenceShadow *self){
    // Return code ignored.
    return OSRGetLinearUnits( self, 0 );
  }
static char const *OSRSpatialReferenceShadow_GetLinearUnitsName(OSRSpatialReferenceShadow *self){
    const char *name = 0;
    if ( OSRIsProjected( self ) ) {
      name = OSRGetAttrValue( self, "PROJCS|UNIT", 0 );
    }
    else if ( OSRIsLocal( self ) ) {
      name = OSRGetAttrValue( self, "LOCAL_CS|UNIT", 0 );
    }

    if (name != 0) 
      return name;

    return "Meter";
  }
static char const *OSRSpatialReferenceShadow_GetAuthorityCode(OSRSpatialReferenceShadow *self,char const *target_key){
    return OSRGetAuthorityCode( self, target_key );
  }
static char const *OSRSpatialReferenceShadow_GetAuthorityName(OSRSpatialReferenceShadow *self,char const *target_key){
    return OSRGetAuthorityName( self, target_key );
  }
static OGRErr OSRSpatialReferenceShadow_SetUTM(OSRSpatialReferenceShadow *self,int zone,int north=1){
    return OSRSetUTM( self, zone, north );
  }
static OGRErr OSRSpatialReferenceShadow_SetStatePlane(OSRSpatialReferenceShadow *self,int zone,int is_nad83=1,char const *unitsname="",double units=0.0){
    return OSRSetStatePlaneWithUnits( self, zone, is_nad83, unitsname, units );
  }
static OGRErr OSRSpatialReferenceShadow_AutoIdentifyEPSG(OSRSpatialReferenceShadow *self){
    return OSRAutoIdentifyEPSG( self );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjection(OSRSpatialReferenceShadow *self,char const *arg){
    return OSRSetProjection( self, arg );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjParm(OSRSpatialReferenceShadow *self,char const *name,double val){
    return OSRSetProjParm( self, name, val ); 
  }
static double OSRSpatialReferenceShadow_GetProjParm(OSRSpatialReferenceShadow *self,char const *name,double default_val=0.0){
    // Return code ignored.
    return OSRGetProjParm( self, name, default_val, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetNormProjParm(OSRSpatialReferenceShadow *self,char const *name,double val){
    return OSRSetNormProjParm( self, name, val );
  }
static double OSRSpatialReferenceShadow_GetNormProjParm(OSRSpatialReferenceShadow *self,char const *name,double default_val=0.0){
    // Return code ignored.
    return OSRGetNormProjParm( self, name, default_val, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetACEA(OSRSpatialReferenceShadow *self,double stdp1,double stdp2,double clat,double clong,double fe,double fn){
    return OSRSetACEA( self, stdp1, stdp2, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetAE(OSRSpatialReferenceShadow *self,double clat,double clon,double fe,double fn){
    return OSRSetAE( self, clat, clon, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetCS(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetCS( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetBonne(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetBonne( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEC(OSRSpatialReferenceShadow *self,double stdp1,double stdp2,double clat,double clong,double fe,double fn){
    return OSRSetEC( self, stdp1, stdp2, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEckertIV(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetEckertIV( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEckertVI(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetEckertVI( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEquirectangular(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetEquirectangular( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetGS(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetGS( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetWellKnownGeogCS(OSRSpatialReferenceShadow *self,char const *name){
    return OSRSetWellKnownGeogCS( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_SetFromUserInput(OSRSpatialReferenceShadow *self,char const *name){
    return OSRSetFromUserInput( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_CopyGeogCSFrom(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRCopyGeogCSFrom( self, rhs );
  }
static OGRErr OSRSpatialReferenceShadow_SetTOWGS84(OSRSpatialReferenceShadow *self,double p1,double p2,double p3,double p4=0.0,double p5=0.0,double p6=0.0,double p7=0.0){
    return OSRSetTOWGS84( self, p1, p2, p3, p4, p5, p6, p7 );
  }

static PyObject *
CreateTupleFromDoubleArray( double *first, unsigned int size ) {
  PyObject *out = PyTuple_New( size );
  for( unsigned int i=0; i<size; i++ ) {
    PyObject *val = PyFloat_FromDouble( *first );
    ++first;
    PyTuple_SetItem( out, i, val );
  }
  return out;
}

static OGRErr OSRSpatialReferenceShadow_GetTOWGS84(OSRSpatialReferenceShadow *self,double argout[7]){
    return OSRGetTOWGS84( self, argout, 7 );
  }
static OGRErr OSRSpatialReferenceShadow_SetGeogCS(OSRSpatialReferenceShadow *self,char const *pszGeogName,char const *pszDatumName,char const *pszEllipsoidName,double dfSemiMajor,double dfInvFlattening,char const *pszPMName="Greenwich",double dfPMOffset=0.0,char const *pszUnits="degree",double dfConvertToRadians=0.0174532925199433){
    return OSRSetGeogCS( self, pszGeogName, pszDatumName, pszEllipsoidName,
                         dfSemiMajor, dfInvFlattening,
                         pszPMName, dfPMOffset, pszUnits, dfConvertToRadians );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjCS(OSRSpatialReferenceShadow *self,char const *name="unnamed"){
    return OSRSetProjCS( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromWkt(OSRSpatialReferenceShadow *self,char **ppszInput){
    return OSRImportFromWkt( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromProj4(OSRSpatialReferenceShadow *self,char *ppszInput){
    return OSRImportFromProj4( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromESRI(OSRSpatialReferenceShadow *self,char **ppszInput){
    return OSRImportFromESRI( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromEPSG(OSRSpatialReferenceShadow *self,int arg){
    return OSRImportFromEPSG(self, arg);
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromPCI(OSRSpatialReferenceShadow *self,char const *proj,char const *units="METRE",double argin[17]=0){
    return OSRImportFromPCI( self, proj, units, argin );
  }

SWIGINTERNINLINE long
SWIG_As_long(PyObject* obj)
{
  long v;
  if (!SWIG_AsVal_long(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(long));
  }
  return v;
}

  
SWIGINTERNINLINE int
SWIG_Check_long(PyObject* obj)
{
  return SWIG_AsVal_long(obj, (long*)0);
}

static OGRErr OSRSpatialReferenceShadow_ImportFromUSGS(OSRSpatialReferenceShadow *self,long proj_code,long zone=0,double argin[15]=0,long datum_code=0){
    return OSRImportFromUSGS( self, proj_code, zone, argin, datum_code );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromXML(OSRSpatialReferenceShadow *self,char const *xmlString){
    return OSRImportFromXML( self, xmlString );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToWkt(OSRSpatialReferenceShadow *self,char **argout){
    return OSRExportToWkt( self, argout );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToPrettyWkt(OSRSpatialReferenceShadow *self,char **argout,int simplify=0){
    return OSRExportToPrettyWkt( self, argout, simplify );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToProj4(OSRSpatialReferenceShadow *self,char **argout){
    return OSRExportToProj4( self, argout );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToPCI(OSRSpatialReferenceShadow *self,char **proj,char **units,double *parms[17]){
    return OSRExportToPCI( self, proj, units, parms );
  }

  /*@/home/kruland/opt/share/swig/1.3.26/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_long PyInt_FromLong
/*@@*/


static OGRErr OSRSpatialReferenceShadow_ExportToUSGS(OSRSpatialReferenceShadow *self,long *code,long *zone,double *parms[15],long *datum){
    return OSRExportToUSGS( self, code, zone, parms, datum );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToXML(OSRSpatialReferenceShadow *self,char **argout,char const *dialect=""){
    return OSRExportToXML( self, argout, dialect );
  }
static OSRSpatialReferenceShadow *OSRSpatialReferenceShadow_CloneGeogCS(OSRSpatialReferenceShadow *self){
    return (OSRSpatialReferenceShadow*) OSRCloneGeogCS(self);
  }
static OGRErr OSRSpatialReferenceShadow_Validate(OSRSpatialReferenceShadow *self){
    return OSRValidate(self);
  }
static OGRErr OSRSpatialReferenceShadow_StripCTParms(OSRSpatialReferenceShadow *self){
    return OSRStripCTParms(self);
  }
static OGRErr OSRSpatialReferenceShadow_FixupOrdering(OSRSpatialReferenceShadow *self){
    return OSRFixupOrdering(self);
  }
static OGRErr OSRSpatialReferenceShadow_Fixup(OSRSpatialReferenceShadow *self){
    return OSRFixup(self);
  }
static OGRErr OSRSpatialReferenceShadow_MorphToESRI(OSRSpatialReferenceShadow *self){
    return OSRMorphToESRI(self);
  }
static OGRErr OSRSpatialReferenceShadow_MorphFromESRI(OSRSpatialReferenceShadow *self){
    return OSRMorphFromESRI(self);
  }
static OSRCoordinateTransformationShadow *new_OSRCoordinateTransformationShadow(OSRSpatialReferenceShadow *src,OSRSpatialReferenceShadow *dst){
    OSRCoordinateTransformationShadow *obj = (OSRCoordinateTransformationShadow*) OCTNewCoordinateTransformation( src, dst );
    if (obj == 0 ) {
      throw "Failed to create coordinate transformation";
    }
    return obj;
  }
static void delete_OSRCoordinateTransformationShadow(OSRCoordinateTransformationShadow *self){
    OCTDestroyCoordinateTransformation( self );
  }
static void OSRCoordinateTransformationShadow_TransformPoint__SWIG_0(OSRCoordinateTransformationShadow *self,double inout[3]){
    OCTTransform( self, 1, &inout[0], &inout[1], &inout[2] );
  }
static void OSRCoordinateTransformationShadow_TransformPoint__SWIG_1(OSRCoordinateTransformationShadow *self,double argout[3],double x,double y,double z=0.0){
    argout[0] = x;
    argout[1] = y;
    argout[2] = z;
    OCTTransform( self, 1, &argout[0], &argout[1], &argout[2] );
  }
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_GetWellKnownGeogCSAsWKT(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    PyObject * obj0 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:GetWellKnownGeogCSAsWKT",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (OGRErr)GetWellKnownGeogCSAsWKT((char const *)arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    return NULL;
}


static PyObject *_wrap_new_SpatialReference(PyObject *, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) "" ;
    OSRSpatialReferenceShadow *result;
    PyObject * obj0 = 0 ;
    char *kwnames[] = {
        (char *) "wkt", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"|O:new_SpatialReference",kwnames,&obj0)) goto fail;
    if (obj0) {
        if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    result = (OSRSpatialReferenceShadow *)new_OSRSpatialReferenceShadow((char const *)arg1);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_OSRSpatialReferenceShadow, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_SpatialReference(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_SpatialReference",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    delete_OSRSpatialReferenceShadow(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference___str__(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference___str__",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)OSRSpatialReferenceShadow___str__(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_IsSame(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_IsSame",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    result = (int)OSRSpatialReferenceShadow_IsSame(arg1,arg2);
    
    {
        resultobj = SWIG_From_int(static_cast<int >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_IsSameGeogCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_IsSameGeogCS",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    result = (int)OSRSpatialReferenceShadow_IsSameGeogCS(arg1,arg2);
    
    {
        resultobj = SWIG_From_int(static_cast<int >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_IsGeographic(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_IsGeographic",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)OSRSpatialReferenceShadow_IsGeographic(arg1);
    
    {
        resultobj = SWIG_From_int(static_cast<int >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_IsProjected(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_IsProjected",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)OSRSpatialReferenceShadow_IsProjected(arg1);
    
    {
        resultobj = SWIG_From_int(static_cast<int >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetAttrValue(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:SpatialReference_GetAttrValue",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<int >(SWIG_As_int(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (char *)OSRSpatialReferenceShadow_GetAttrValue(arg1,(char const *)arg2,arg3);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetAttrValue(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:SpatialReference_SetAttrValue",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetAttrValue(arg1,(char const *)arg2,(char const *)arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetAngularUnits(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:SpatialReference_SetAngularUnits",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetAngularUnits(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetAngularUnits(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_GetAngularUnits",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (double)OSRSpatialReferenceShadow_GetAngularUnits(arg1);
    
    {
        resultobj = SWIG_From_double(static_cast<double >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetLinearUnits(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:SpatialReference_SetLinearUnits",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetLinearUnits(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetLinearUnits(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_GetLinearUnits",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (double)OSRSpatialReferenceShadow_GetLinearUnits(arg1);
    
    {
        resultobj = SWIG_From_double(static_cast<double >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetLinearUnitsName(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_GetLinearUnitsName",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)OSRSpatialReferenceShadow_GetLinearUnitsName(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetAuthorityCode(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_GetAuthorityCode",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (char *)OSRSpatialReferenceShadow_GetAuthorityCode(arg1,(char const *)arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetAuthorityName(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_GetAuthorityName",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (char *)OSRSpatialReferenceShadow_GetAuthorityName(arg1,(char const *)arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetUTM(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:SpatialReference_SetUTM",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<int >(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<int >(SWIG_As_int(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetUTM(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetStatePlane(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    int arg3 = (int) 1 ;
    char *arg4 = (char *) "" ;
    double arg5 = (double) 0.0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|OOO:SpatialReference_SetStatePlane",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<int >(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<int >(SWIG_As_int(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    if (obj3) {
        if (!SWIG_AsCharPtr(obj3, (char**)&arg4)) {
            SWIG_arg_fail(4);SWIG_fail;
        }
    }
    if (obj4) {
        {
            arg5 = static_cast<double >(SWIG_As_double(obj4)); 
            if (SWIG_arg_fail(5)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetStatePlane(arg1,arg2,arg3,(char const *)arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_AutoIdentifyEPSG(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_AutoIdentifyEPSG",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_AutoIdentifyEPSG(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetProjection(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_SetProjection",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjection(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetProjParm(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:SpatialReference_SetProjParm",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjParm(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetProjParm(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 = (double) 0.0 ;
    double result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:SpatialReference_GetProjParm",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<double >(SWIG_As_double(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (double)OSRSpatialReferenceShadow_GetProjParm(arg1,(char const *)arg2,arg3);
    
    {
        resultobj = SWIG_From_double(static_cast<double >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetNormProjParm(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:SpatialReference_SetNormProjParm",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetNormProjParm(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetNormProjParm(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 = (double) 0.0 ;
    double result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:SpatialReference_GetNormProjParm",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<double >(SWIG_As_double(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (double)OSRSpatialReferenceShadow_GetNormProjParm(arg1,(char const *)arg2,arg3);
    
    {
        resultobj = SWIG_From_double(static_cast<double >(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetACEA(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    double arg6 ;
    double arg7 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:SpatialReference_SetACEA",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = static_cast<double >(SWIG_As_double(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        arg7 = static_cast<double >(SWIG_As_double(obj6)); 
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetACEA(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetAE(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:SpatialReference_SetAE",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetAE(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:SpatialReference_SetCS",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetCS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetBonne(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:SpatialReference_SetBonne",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetBonne(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetEC(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    double arg6 ;
    double arg7 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:SpatialReference_SetEC",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = static_cast<double >(SWIG_As_double(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        arg7 = static_cast<double >(SWIG_As_double(obj6)); 
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetEC(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetEckertIV(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:SpatialReference_SetEckertIV",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetEckertIV(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetEckertVI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:SpatialReference_SetEckertVI",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetEckertVI(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetEquirectangular(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:SpatialReference_SetEquirectangular",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetEquirectangular(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetGS(PyObject *, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    char *kwnames[] = {
        (char *) "self",(char *) "cm",(char *) "fe",(char *) "fn", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOO:SpatialReference_SetGS",kwnames,&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetGS(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetWellKnownGeogCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_SetWellKnownGeogCS",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetWellKnownGeogCS(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetFromUserInput(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_SetFromUserInput",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetFromUserInput(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_CopyGeogCSFrom(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_CopyGeogCSFrom",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_CopyGeogCSFrom(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetTOWGS84(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0.0 ;
    double arg6 = (double) 0.0 ;
    double arg7 = (double) 0.0 ;
    double arg8 = (double) 0.0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO|OOOO:SpatialReference_SetTOWGS84",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    if (obj4) {
        {
            arg5 = static_cast<double >(SWIG_As_double(obj4)); 
            if (SWIG_arg_fail(5)) SWIG_fail;
        }
    }
    if (obj5) {
        {
            arg6 = static_cast<double >(SWIG_As_double(obj5)); 
            if (SWIG_arg_fail(6)) SWIG_fail;
        }
    }
    if (obj6) {
        {
            arg7 = static_cast<double >(SWIG_As_double(obj6)); 
            if (SWIG_arg_fail(7)) SWIG_fail;
        }
    }
    if (obj7) {
        {
            arg8 = static_cast<double >(SWIG_As_double(obj7)); 
            if (SWIG_arg_fail(8)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetTOWGS84(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_GetTOWGS84(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double *arg2 ;
    OGRErr result;
    double argout2[7] ;
    PyObject * obj0 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_GetTOWGS84",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_GetTOWGS84(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (double argout[ANY]) */
        PyObject *out = CreateTupleFromDoubleArray( arg2, 7 );
        resultobj = t_output_helper(resultobj,out);
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetGeogCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    double arg5 ;
    double arg6 ;
    char *arg7 = (char *) "Greenwich" ;
    double arg8 = (double) 0.0 ;
    char *arg9 = (char *) "degree" ;
    double arg10 = (double) 0.0174532925199433 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    PyObject * obj8 = 0 ;
    PyObject * obj9 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO|OOOO:SpatialReference_SetGeogCS",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7,&obj8,&obj9)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    if (!SWIG_AsCharPtr(obj3, (char**)&arg4)) {
        SWIG_arg_fail(4);SWIG_fail;
    }
    {
        arg5 = static_cast<double >(SWIG_As_double(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = static_cast<double >(SWIG_As_double(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    if (obj6) {
        if (!SWIG_AsCharPtr(obj6, (char**)&arg7)) {
            SWIG_arg_fail(7);SWIG_fail;
        }
    }
    if (obj7) {
        {
            arg8 = static_cast<double >(SWIG_As_double(obj7)); 
            if (SWIG_arg_fail(8)) SWIG_fail;
        }
    }
    if (obj8) {
        if (!SWIG_AsCharPtr(obj8, (char**)&arg9)) {
            SWIG_arg_fail(9);SWIG_fail;
        }
    }
    if (obj9) {
        {
            arg10 = static_cast<double >(SWIG_As_double(obj9)); 
            if (SWIG_arg_fail(10)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetGeogCS(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,(char const *)arg7,arg8,(char const *)arg9,arg10);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_SetProjCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) "unnamed" ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:SpatialReference_SetProjCS",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (obj1) {
        if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
            SWIG_arg_fail(2);SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjCS(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromWkt(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *val2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_ImportFromWkt",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        /* %typemap(in) (char **ignorechange) */
        PyArg_Parse( obj1, "s", &val2 );
        arg2 = &val2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromWkt(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromProj4(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_ImportFromProj4",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromProj4(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromESRI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *val2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_ImportFromESRI",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        /* %typemap(in) (char **ignorechange) */
        PyArg_Parse( obj1, "s", &val2 );
        arg2 = &val2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromESRI(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromEPSG(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_ImportFromEPSG",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<int >(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromEPSG(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromPCI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) "METRE" ;
    double *arg4 = (double *) (double *)0 ;
    OGRErr result;
    double argin4[17] ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|OO:SpatialReference_ImportFromPCI",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (obj2) {
        if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
            SWIG_arg_fail(3);SWIG_fail;
        }
    }
    if (obj3) {
        {
            /* %typemap(in) (double argin4[ANY]) */
            arg4 = argin4;
            if (! PySequence_Check(obj3) ) {
                PyErr_SetString(PyExc_TypeError, "not a sequence");
                SWIG_fail;
            }
            int seq_size = PySequence_Size(obj3);
            if ( seq_size != 17 ) {
                PyErr_SetString(PyExc_TypeError, "sequence must have length ##size");
                SWIG_fail;
            }
            for (unsigned int i=0; i<17; i++) {
                PyObject *o = PySequence_GetItem(obj3,i);
                double val;
                PyArg_Parse(o, "d", &val );
                arg4[i] =  val;
            }
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromPCI(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromUSGS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    long arg2 ;
    long arg3 = (long) 0 ;
    double *arg4 = (double *) (double *)0 ;
    long arg5 = (long) 0 ;
    OGRErr result;
    double argin4[15] ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|OOO:SpatialReference_ImportFromUSGS",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = static_cast<long >(SWIG_As_long(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = static_cast<long >(SWIG_As_long(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    if (obj3) {
        {
            /* %typemap(in) (double argin4[ANY]) */
            arg4 = argin4;
            if (! PySequence_Check(obj3) ) {
                PyErr_SetString(PyExc_TypeError, "not a sequence");
                SWIG_fail;
            }
            int seq_size = PySequence_Size(obj3);
            if ( seq_size != 15 ) {
                PyErr_SetString(PyExc_TypeError, "sequence must have length ##size");
                SWIG_fail;
            }
            for (unsigned int i=0; i<15; i++) {
                PyObject *o = PySequence_GetItem(obj3,i);
                double val;
                PyArg_Parse(o, "d", &val );
                arg4[i] =  val;
            }
        }
    }
    if (obj4) {
        {
            arg5 = static_cast<long >(SWIG_As_long(obj4)); 
            if (SWIG_arg_fail(5)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromUSGS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ImportFromXML(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:SpatialReference_ImportFromXML",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromXML(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToWkt(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    PyObject * obj0 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_ExportToWkt",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToWkt(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToPrettyWkt(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    int arg3 = (int) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O|O:SpatialReference_ExportToPrettyWkt",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (obj1) {
        {
            arg3 = static_cast<int >(SWIG_As_int(obj1)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToPrettyWkt(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToProj4(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    PyObject * obj0 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_ExportToProj4",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToProj4(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToPCI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char **arg3 = (char **) 0 ;
    double **arg4 ;
    OGRErr result;
    char *argout2 = 0 ;
    char *argout3 = 0 ;
    double *argout4 ;
    PyObject * obj0 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    {
        /* %typemap(in,numinputs=0) (char **argout3) */
        arg3 = &argout3;
        resultobj = 0;
    }
    {
        /* %typemap(in,numinputs=0) (double *argout4[ANY]) */
        arg4 = &argout4;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_ExportToPCI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToPCI(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg3 ) {
            o = PyString_FromString( *arg3 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(argout) (double *argout[ANY]) */
        PyObject *out = CreateTupleFromDoubleArray( *arg4, 17 );
        resultobj = t_output_helper(resultobj,out);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg3 )
        CPLFree( *arg3 );
    }
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(*arg4);
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg3 )
        CPLFree( *arg3 );
    }
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(*arg4);
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToUSGS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    long *arg2 = (long *) 0 ;
    long *arg3 = (long *) 0 ;
    double **arg4 ;
    long *arg5 = (long *) 0 ;
    OGRErr result;
    long temp2 ;
    int res2 = 0 ;
    long temp3 ;
    int res3 = 0 ;
    double *argout4 ;
    long temp5 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    
    arg2 = &temp2; res2 = SWIG_NEWOBJ;
    arg3 = &temp3; res3 = SWIG_NEWOBJ;
    {
        /* %typemap(in,numinputs=0) (double *argout4[ANY]) */
        arg4 = &argout4;
        resultobj = 0;
    }
    arg5 = &temp5; res5 = SWIG_NEWOBJ;
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_ExportToUSGS",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToUSGS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    resultobj = t_output_helper(resultobj, ((res2 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg2)) : SWIG_NewPointerObj((void*)(arg2), SWIGTYPE_p_long, 0)));
    resultobj = t_output_helper(resultobj, ((res3 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg3)) : SWIG_NewPointerObj((void*)(arg3), SWIGTYPE_p_long, 0)));
    {
        /* %typemap(argout) (double *argout[ANY]) */
        PyObject *out = CreateTupleFromDoubleArray( *arg4, 15 );
        resultobj = t_output_helper(resultobj,out);
    }
    resultobj = t_output_helper(resultobj, ((res5 == SWIG_NEWOBJ) ?
    SWIG_From_long((*arg5)) : SWIG_NewPointerObj((void*)(arg5), SWIGTYPE_p_long, 0)));
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(*arg4);
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(*arg4);
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_ExportToXML(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) "" ;
    OGRErr result;
    char *argout2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (char **argout2) */
        arg2 = &argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"O|O:SpatialReference_ExportToXML",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (obj1) {
        if (!SWIG_AsCharPtr(obj1, (char**)&arg3)) {
            SWIG_arg_fail(3);SWIG_fail;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToXML(arg1,arg2,(char const *)arg3);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        PyObject *o;
        if ( arg2 ) {
            o = PyString_FromString( *arg2 );
        }
        else {
            o = Py_None;
            Py_INCREF( o );
        }
        resultobj = t_output_helper(resultobj, o);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    {
        /* %typemap(freearg) (char **argout) */
        if ( *arg2 )
        CPLFree( *arg2 );
    }
    return NULL;
}


static PyObject *_wrap_SpatialReference_CloneGeogCS(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_CloneGeogCS",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OSRSpatialReferenceShadow *)OSRSpatialReferenceShadow_CloneGeogCS(arg1);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_OSRSpatialReferenceShadow, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_Validate(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_Validate",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_Validate(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_StripCTParms(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_StripCTParms",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_StripCTParms(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_FixupOrdering(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_FixupOrdering",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_FixupOrdering(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_Fixup(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_Fixup",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_Fixup(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_MorphToESRI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_MorphToESRI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_MorphToESRI(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_SpatialReference_MorphFromESRI(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:SpatialReference_MorphFromESRI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (OGRErr)OSRSpatialReferenceShadow_MorphFromESRI(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if ( result != 0) {
            PyErr_SetString( PyExc_RuntimeError, OGRErrMessages(result) );
            SWIG_fail;
        }
    }
    {
        /* %typemap(ret) OGRErr */
        if (resultobj == Py_None ) {
            Py_DECREF(resultobj);
            resultobj = 0;
        }
        if (resultobj == 0) {
            resultobj = PyInt_FromLong( 0 );
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * SpatialReference_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_OSRSpatialReferenceShadow, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_CoordinateTransformation(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OSRCoordinateTransformationShadow *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_CoordinateTransformation",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    result = (OSRCoordinateTransformationShadow *)new_OSRCoordinateTransformationShadow(arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_OSRCoordinateTransformationShadow, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_CoordinateTransformation(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_CoordinateTransformation",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRCoordinateTransformationShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    delete_OSRCoordinateTransformationShadow(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_CoordinateTransformation_TransformPoint__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    double *arg2 ;
    double argin2[3] ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:CoordinateTransformation_TransformPoint",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRCoordinateTransformationShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        /* %typemap(in) (double argin2[ANY]) */
        arg2 = argin2;
        if (! PySequence_Check(obj1) ) {
            PyErr_SetString(PyExc_TypeError, "not a sequence");
            SWIG_fail;
        }
        int seq_size = PySequence_Size(obj1);
        if ( seq_size != 3 ) {
            PyErr_SetString(PyExc_TypeError, "sequence must have length ##size");
            SWIG_fail;
        }
        for (unsigned int i=0; i<3; i++) {
            PyObject *o = PySequence_GetItem(obj1,i);
            double val;
            PyArg_Parse(o, "d", &val );
            arg2[i] =  val;
        }
    }
    OSRCoordinateTransformationShadow_TransformPoint__SWIG_0(arg1,arg2);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        /* %typemap(argout) (double argout[ANY]) */
        PyObject *out = CreateTupleFromDoubleArray( arg2, 3 );
        resultobj = t_output_helper(resultobj,out);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_CoordinateTransformation_TransformPoint__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj = NULL;
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    double *arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0.0 ;
    double argout2[3] ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    {
        /* %typemap(in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
        resultobj = 0;
    }
    if(!PyArg_ParseTuple(args,(char *)"OOO|O:CoordinateTransformation_TransformPoint",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_OSRCoordinateTransformationShadow, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg3 = static_cast<double >(SWIG_As_double(obj1)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = static_cast<double >(SWIG_As_double(obj2)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    if (obj3) {
        {
            arg5 = static_cast<double >(SWIG_As_double(obj3)); 
            if (SWIG_arg_fail(5)) SWIG_fail;
        }
    }
    OSRCoordinateTransformationShadow_TransformPoint__SWIG_1(arg1,arg2,arg3,arg4,arg5);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        /* %typemap(argout) (double argout[ANY]) */
        PyObject *out = CreateTupleFromDoubleArray( arg2, 3 );
        resultobj = t_output_helper(resultobj,out);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_CoordinateTransformation_TransformPoint(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OSRCoordinateTransformationShadow, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_double, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_CoordinateTransformation_TransformPoint__SWIG_0(self,args);
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OSRCoordinateTransformationShadow, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_double(argv[1]);
            if (_v) {
                _v = SWIG_Check_double(argv[2]);
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_CoordinateTransformation_TransformPoint__SWIG_1(self,args);
                    }
                    _v = SWIG_Check_double(argv[3]);
                    if (_v) {
                        return _wrap_CoordinateTransformation_TransformPoint__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'CoordinateTransformation_TransformPoint'");
    return NULL;
}


static PyObject * CoordinateTransformation_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_OSRCoordinateTransformationShadow, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyMethodDef SwigMethods[] = {
	 { (char *)"GetProjectionMethods", py_OPTGetProjectionMethods, METH_VARARGS, NULL},
	 { (char *)"GetWellKnownGeogCSAsWKT", _wrap_GetWellKnownGeogCSAsWKT, METH_VARARGS, NULL},
	 { (char *)"new_SpatialReference", (PyCFunction) _wrap_new_SpatialReference, METH_VARARGS | METH_KEYWORDS, NULL},
	 { (char *)"delete_SpatialReference", _wrap_delete_SpatialReference, METH_VARARGS, NULL},
	 { (char *)"SpatialReference___str__", _wrap_SpatialReference___str__, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_IsSame", _wrap_SpatialReference_IsSame, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_IsSameGeogCS", _wrap_SpatialReference_IsSameGeogCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_IsGeographic", _wrap_SpatialReference_IsGeographic, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_IsProjected", _wrap_SpatialReference_IsProjected, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetAttrValue", _wrap_SpatialReference_GetAttrValue, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetAttrValue", _wrap_SpatialReference_SetAttrValue, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetAngularUnits", _wrap_SpatialReference_SetAngularUnits, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetAngularUnits", _wrap_SpatialReference_GetAngularUnits, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetLinearUnits", _wrap_SpatialReference_SetLinearUnits, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetLinearUnits", _wrap_SpatialReference_GetLinearUnits, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetLinearUnitsName", _wrap_SpatialReference_GetLinearUnitsName, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetAuthorityCode", _wrap_SpatialReference_GetAuthorityCode, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetAuthorityName", _wrap_SpatialReference_GetAuthorityName, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetUTM", _wrap_SpatialReference_SetUTM, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetStatePlane", _wrap_SpatialReference_SetStatePlane, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_AutoIdentifyEPSG", _wrap_SpatialReference_AutoIdentifyEPSG, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetProjection", _wrap_SpatialReference_SetProjection, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetProjParm", _wrap_SpatialReference_SetProjParm, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetProjParm", _wrap_SpatialReference_GetProjParm, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetNormProjParm", _wrap_SpatialReference_SetNormProjParm, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetNormProjParm", _wrap_SpatialReference_GetNormProjParm, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetACEA", _wrap_SpatialReference_SetACEA, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetAE", _wrap_SpatialReference_SetAE, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetCS", _wrap_SpatialReference_SetCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetBonne", _wrap_SpatialReference_SetBonne, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetEC", _wrap_SpatialReference_SetEC, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetEckertIV", _wrap_SpatialReference_SetEckertIV, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetEckertVI", _wrap_SpatialReference_SetEckertVI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetEquirectangular", _wrap_SpatialReference_SetEquirectangular, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetGS", (PyCFunction) _wrap_SpatialReference_SetGS, METH_VARARGS | METH_KEYWORDS, NULL},
	 { (char *)"SpatialReference_SetWellKnownGeogCS", _wrap_SpatialReference_SetWellKnownGeogCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetFromUserInput", _wrap_SpatialReference_SetFromUserInput, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_CopyGeogCSFrom", _wrap_SpatialReference_CopyGeogCSFrom, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetTOWGS84", _wrap_SpatialReference_SetTOWGS84, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_GetTOWGS84", _wrap_SpatialReference_GetTOWGS84, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetGeogCS", _wrap_SpatialReference_SetGeogCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_SetProjCS", _wrap_SpatialReference_SetProjCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromWkt", _wrap_SpatialReference_ImportFromWkt, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromProj4", _wrap_SpatialReference_ImportFromProj4, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromESRI", _wrap_SpatialReference_ImportFromESRI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromEPSG", _wrap_SpatialReference_ImportFromEPSG, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromPCI", _wrap_SpatialReference_ImportFromPCI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromUSGS", _wrap_SpatialReference_ImportFromUSGS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ImportFromXML", _wrap_SpatialReference_ImportFromXML, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToWkt", _wrap_SpatialReference_ExportToWkt, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToPrettyWkt", _wrap_SpatialReference_ExportToPrettyWkt, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToProj4", _wrap_SpatialReference_ExportToProj4, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToPCI", _wrap_SpatialReference_ExportToPCI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToUSGS", _wrap_SpatialReference_ExportToUSGS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_ExportToXML", _wrap_SpatialReference_ExportToXML, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_CloneGeogCS", _wrap_SpatialReference_CloneGeogCS, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_Validate", _wrap_SpatialReference_Validate, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_StripCTParms", _wrap_SpatialReference_StripCTParms, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_FixupOrdering", _wrap_SpatialReference_FixupOrdering, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_Fixup", _wrap_SpatialReference_Fixup, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_MorphToESRI", _wrap_SpatialReference_MorphToESRI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_MorphFromESRI", _wrap_SpatialReference_MorphFromESRI, METH_VARARGS, NULL},
	 { (char *)"SpatialReference_swigregister", SpatialReference_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_CoordinateTransformation", _wrap_new_CoordinateTransformation, METH_VARARGS, NULL},
	 { (char *)"delete_CoordinateTransformation", _wrap_delete_CoordinateTransformation, METH_VARARGS, NULL},
	 { (char *)"CoordinateTransformation_TransformPoint", _wrap_CoordinateTransformation_TransformPoint, METH_VARARGS, NULL},
	 { (char *)"CoordinateTransformation_swigregister", CoordinateTransformation_swigregister, METH_VARARGS, NULL},
	 { NULL, NULL, 0, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_OSRCoordinateTransformationShadow = {"_p_OSRCoordinateTransformationShadow", "OSRCoordinateTransformationShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OSRSpatialReferenceShadow = {"_p_OSRSpatialReferenceShadow", "OSRSpatialReferenceShadow *", 0, 0, 0};
static swig_type_info _swigt__p_char = {"_p_char", "char *", 0, 0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|OGRErr *", 0, 0, 0};
static swig_type_info _swigt__p_long = {"_p_long", "long *", 0, 0, 0};
static swig_type_info _swigt__p_p_char = {"_p_p_char", "char **", 0, 0, 0};
static swig_type_info _swigt__p_p_double = {"_p_p_double", "double **", 0, 0, 0};
static swig_type_info _swigt__ptrdiff_t = {"_ptrdiff_t", "ptrdiff_t", 0, 0, 0};
static swig_type_info _swigt__size_t = {"_size_t", "size_t", 0, 0, 0};
static swig_type_info _swigt__std__ptrdiff_t = {"_std__ptrdiff_t", "std::ptrdiff_t", 0, 0, 0};
static swig_type_info _swigt__std__size_t = {"_std__size_t", "std::size_t", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_OSRCoordinateTransformationShadow,
  &_swigt__p_OSRSpatialReferenceShadow,
  &_swigt__p_char,
  &_swigt__p_double,
  &_swigt__p_int,
  &_swigt__p_long,
  &_swigt__p_p_char,
  &_swigt__p_p_double,
  &_swigt__ptrdiff_t,
  &_swigt__size_t,
  &_swigt__std__ptrdiff_t,
  &_swigt__std__size_t,
};

static swig_cast_info _swigc__p_OSRCoordinateTransformationShadow[] = {  {&_swigt__p_OSRCoordinateTransformationShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OSRSpatialReferenceShadow[] = {  {&_swigt__p_OSRSpatialReferenceShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_char[] = {  {&_swigt__p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_long[] = {  {&_swigt__p_long, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_char[] = {  {&_swigt__p_p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_double[] = {  {&_swigt__p_p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__ptrdiff_t[] = {  {&_swigt__ptrdiff_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__size_t[] = {  {&_swigt__size_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__std__ptrdiff_t[] = {  {&_swigt__std__ptrdiff_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__std__size_t[] = {  {&_swigt__std__size_t, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_OSRCoordinateTransformationShadow,
  _swigc__p_OSRSpatialReferenceShadow,
  _swigc__p_char,
  _swigc__p_double,
  _swigc__p_int,
  _swigc__p_long,
  _swigc__p_p_char,
  _swigc__p_p_double,
  _swigc__ptrdiff_t,
  _swigc__size_t,
  _swigc__std__ptrdiff_t,
  _swigc__std__size_t,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{ SWIG_PY_POINTER, (char*)"SRS_PT_ALBERS_CONIC_EQUAL_AREA", 0, 0, (void *)SRS_PT_ALBERS_CONIC_EQUAL_AREA, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_AZIMUTHAL_EQUIDISTANT", 0, 0, (void *)SRS_PT_AZIMUTHAL_EQUIDISTANT, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_CASSINI_SOLDNER", 0, 0, (void *)SRS_PT_CASSINI_SOLDNER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_CYLINDRICAL_EQUAL_AREA", 0, 0, (void *)SRS_PT_CYLINDRICAL_EQUAL_AREA, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_ECKERT_IV", 0, 0, (void *)SRS_PT_ECKERT_IV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_ECKERT_VI", 0, 0, (void *)SRS_PT_ECKERT_VI, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_EQUIDISTANT_CONIC", 0, 0, (void *)SRS_PT_EQUIDISTANT_CONIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_EQUIRECTANGULAR", 0, 0, (void *)SRS_PT_EQUIRECTANGULAR, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_GALL_STEREOGRAPHIC", 0, 0, (void *)SRS_PT_GALL_STEREOGRAPHIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_GNOMONIC", 0, 0, (void *)SRS_PT_GNOMONIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_GOODE_HOMOLOSINE", 0, 0, (void *)SRS_PT_GOODE_HOMOLOSINE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_HOTINE_OBLIQUE_MERCATOR", 0, 0, (void *)SRS_PT_HOTINE_OBLIQUE_MERCATOR, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_HOTINE_OBLIQUE_MERCATOR_TWO_POINT_NATURAL_ORIGIN", 0, 0, (void *)SRS_PT_HOTINE_OBLIQUE_MERCATOR_TWO_POINT_NATURAL_ORIGIN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_LABORDE_OBLIQUE_MERCATOR", 0, 0, (void *)SRS_PT_LABORDE_OBLIQUE_MERCATOR, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_LAMBERT_CONFORMAL_CONIC_1SP", 0, 0, (void *)SRS_PT_LAMBERT_CONFORMAL_CONIC_1SP, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP", 0, 0, (void *)SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP_BELGIUM", 0, 0, (void *)SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP_BELGIUM, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_LAMBERT_AZIMUTHAL_EQUAL_AREA", 0, 0, (void *)SRS_PT_LAMBERT_AZIMUTHAL_EQUAL_AREA, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_MERCATOR_1SP", 0, 0, (void *)SRS_PT_MERCATOR_1SP, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_MERCATOR_2SP", 0, 0, (void *)SRS_PT_MERCATOR_2SP, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_MILLER_CYLINDRICAL", 0, 0, (void *)SRS_PT_MILLER_CYLINDRICAL, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_MOLLWEIDE", 0, 0, (void *)SRS_PT_MOLLWEIDE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_NEW_ZEALAND_MAP_GRID", 0, 0, (void *)SRS_PT_NEW_ZEALAND_MAP_GRID, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_OBLIQUE_STEREOGRAPHIC", 0, 0, (void *)SRS_PT_OBLIQUE_STEREOGRAPHIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_ORTHOGRAPHIC", 0, 0, (void *)SRS_PT_ORTHOGRAPHIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_POLAR_STEREOGRAPHIC", 0, 0, (void *)SRS_PT_POLAR_STEREOGRAPHIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_POLYCONIC", 0, 0, (void *)SRS_PT_POLYCONIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_ROBINSON", 0, 0, (void *)SRS_PT_ROBINSON, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_SINUSOIDAL", 0, 0, (void *)SRS_PT_SINUSOIDAL, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_STEREOGRAPHIC", 0, 0, (void *)SRS_PT_STEREOGRAPHIC, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_SWISS_OBLIQUE_CYLINDRICAL", 0, 0, (void *)SRS_PT_SWISS_OBLIQUE_CYLINDRICAL, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR_SOUTH_ORIENTED", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR_SOUTH_ORIENTED, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR_MI_22", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR_MI_22, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR_MI_23", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR_MI_23, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR_MI_24", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR_MI_24, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TRANSVERSE_MERCATOR_MI_25", 0, 0, (void *)SRS_PT_TRANSVERSE_MERCATOR_MI_25, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_TUNISIA_MINING_GRID", 0, 0, (void *)SRS_PT_TUNISIA_MINING_GRID, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_VANDERGRINTEN", 0, 0, (void *)SRS_PT_VANDERGRINTEN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PT_KROVAK", 0, 0, (void *)SRS_PT_KROVAK, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_CENTRAL_MERIDIAN", 0, 0, (void *)SRS_PP_CENTRAL_MERIDIAN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_SCALE_FACTOR", 0, 0, (void *)SRS_PP_SCALE_FACTOR, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_STANDARD_PARALLEL_1", 0, 0, (void *)SRS_PP_STANDARD_PARALLEL_1, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_STANDARD_PARALLEL_2", 0, 0, (void *)SRS_PP_STANDARD_PARALLEL_2, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_PSEUDO_STD_PARALLEL_1", 0, 0, (void *)SRS_PP_PSEUDO_STD_PARALLEL_1, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LONGITUDE_OF_CENTER", 0, 0, (void *)SRS_PP_LONGITUDE_OF_CENTER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LATITUDE_OF_CENTER", 0, 0, (void *)SRS_PP_LATITUDE_OF_CENTER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LONGITUDE_OF_ORIGIN", 0, 0, (void *)SRS_PP_LONGITUDE_OF_ORIGIN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LATITUDE_OF_ORIGIN", 0, 0, (void *)SRS_PP_LATITUDE_OF_ORIGIN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_FALSE_EASTING", 0, 0, (void *)SRS_PP_FALSE_EASTING, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_FALSE_NORTHING", 0, 0, (void *)SRS_PP_FALSE_NORTHING, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_AZIMUTH", 0, 0, (void *)SRS_PP_AZIMUTH, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LONGITUDE_OF_POINT_1", 0, 0, (void *)SRS_PP_LONGITUDE_OF_POINT_1, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LATITUDE_OF_POINT_1", 0, 0, (void *)SRS_PP_LATITUDE_OF_POINT_1, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LONGITUDE_OF_POINT_2", 0, 0, (void *)SRS_PP_LONGITUDE_OF_POINT_2, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LATITUDE_OF_POINT_2", 0, 0, (void *)SRS_PP_LATITUDE_OF_POINT_2, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LONGITUDE_OF_POINT_3", 0, 0, (void *)SRS_PP_LONGITUDE_OF_POINT_3, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LATITUDE_OF_POINT_3", 0, 0, (void *)SRS_PP_LATITUDE_OF_POINT_3, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_RECTIFIED_GRID_ANGLE", 0, 0, (void *)SRS_PP_RECTIFIED_GRID_ANGLE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_LANDSAT_NUMBER", 0, 0, (void *)SRS_PP_LANDSAT_NUMBER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_PATH_NUMBER", 0, 0, (void *)SRS_PP_PATH_NUMBER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_PERSPECTIVE_POINT_HEIGHT", 0, 0, (void *)SRS_PP_PERSPECTIVE_POINT_HEIGHT, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_FIPSZONE", 0, 0, (void *)SRS_PP_FIPSZONE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_PP_ZONE", 0, 0, (void *)SRS_PP_ZONE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_METER", 0, 0, (void *)SRS_UL_METER, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_FOOT", 0, 0, (void *)SRS_UL_FOOT, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_FOOT_CONV", 0, 0, (void *)SRS_UL_FOOT_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_US_FOOT", 0, 0, (void *)SRS_UL_US_FOOT, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_US_FOOT_CONV", 0, 0, (void *)SRS_UL_US_FOOT_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_NAUTICAL_MILE", 0, 0, (void *)SRS_UL_NAUTICAL_MILE, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_NAUTICAL_MILE_CONV", 0, 0, (void *)SRS_UL_NAUTICAL_MILE_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_LINK", 0, 0, (void *)SRS_UL_LINK, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_LINK_CONV", 0, 0, (void *)SRS_UL_LINK_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_CHAIN", 0, 0, (void *)SRS_UL_CHAIN, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_CHAIN_CONV", 0, 0, (void *)SRS_UL_CHAIN_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_ROD", 0, 0, (void *)SRS_UL_ROD, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_UL_ROD_CONV", 0, 0, (void *)SRS_UL_ROD_CONV, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_DN_NAD27", 0, 0, (void *)SRS_DN_NAD27, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_DN_NAD83", 0, 0, (void *)SRS_DN_NAD83, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_DN_WGS72", 0, 0, (void *)SRS_DN_WGS72, &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"SRS_DN_WGS84", 0, 0, (void *)SRS_DN_WGS84, &SWIGTYPE_p_char},
{0, 0, 0, 0.0, 0, 0}};

#ifdef __cplusplus
}
#endif
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif



#ifdef __cplusplus
extern "C" {
#endif
    
    /* Python-specific SWIG API */
#define SWIG_newvarlink()                             SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr)  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_InstallConstants(d, constants)           SWIG_Python_InstallConstants(d, constants)
    
    /* -----------------------------------------------------------------------------
     * global variable support code.
     * ----------------------------------------------------------------------------- */
    
    typedef struct swig_globalvar {
        char       *name;                  /* Name of global variable */
        PyObject *(*get_attr)(void);       /* Return the current value */
        int       (*set_attr)(PyObject *); /* Set the value */
        struct swig_globalvar *next;
    } swig_globalvar;
    
    typedef struct swig_varlinkobject {
        PyObject_HEAD
        swig_globalvar *vars;
    } swig_varlinkobject;
    
    SWIGINTERN PyObject *
    swig_varlink_repr(swig_varlinkobject *v) {
        v = v;
        return PyString_FromString("<Swig global variables>");
    }
    
    SWIGINTERN int
    swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
        swig_globalvar  *var;
        flags = flags;
        fprintf(fp,"Swig global variables { ");
        for (var = v->vars; var; var=var->next) {
            fprintf(fp,"%s", var->name);
            if (var->next) fprintf(fp,", ");
        }
        fprintf(fp," }\n");
        return 0;
    }
    
    SWIGINTERN PyObject *
    swig_varlink_getattr(swig_varlinkobject *v, char *n) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->get_attr)();
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return NULL;
    }
    
    SWIGINTERN int
    swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->set_attr)(p);
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return 1;
    }
    
    SWIGINTERN PyTypeObject*
    swig_varlink_type(void) {
        static char varlink__doc__[] = "Swig var link object";
        static PyTypeObject varlink_type
#if !defined(__cplusplus)
        ;
        static int type_init = 0;  
        if (!type_init) {
            PyTypeObject tmp
#endif
            = {
                PyObject_HEAD_INIT(&PyType_Type)
                0,                                  /* Number of items in variable part (ob_size) */
                (char *)"swigvarlink",              /* Type name (tp_name) */
                sizeof(swig_varlinkobject),         /* Basic size (tp_basicsize) */
                0,                                  /* Itemsize (tp_itemsize) */
                0,                                  /* Deallocator (tp_dealloc) */ 
                (printfunc) swig_varlink_print,     /* Print (tp_print) */
                (getattrfunc) swig_varlink_getattr, /* get attr (tp_getattr) */
                (setattrfunc) swig_varlink_setattr, /* Set attr (tp_setattr) */
                0,                                  /* tp_compare */
                (reprfunc) swig_varlink_repr,       /* tp_repr */
                0,                                  /* tp_as_number */
                0,                                  /* tp_as_sequence */
                0,                                  /* tp_as_mapping */
                0,                                  /* tp_hash */
                0,                                  /* tp_call */
                0,                                  /* tp_str */
                0,                                  /* tp_getattro */
                0,                                  /* tp_setattro */
                0,                                  /* tp_as_buffer */
                0,                                  /* tp_flags */
                varlink__doc__,                     /* tp_doc */
#if PY_VERSION_HEX >= 0x02000000
                0,                                  /* tp_traverse */
                0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
                0,                                  /* tp_richcompare */
                0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
                0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
                0,0,0,0                             /* tp_alloc -> tp_next */
#endif
            };
#if !defined(__cplusplus)
            varlink_type = tmp;
            type_init = 1;
        }
#endif
        return &varlink_type;
    }
    
    /* Create a variable linking object for use later */
    SWIGINTERN PyObject *
    SWIG_Python_newvarlink(void) {
        swig_varlinkobject *result = PyObject_NEW(swig_varlinkobject, swig_varlink_type());
        if (result) {
            result->vars = 0;
        }
        return ((PyObject*) result);
    }
    
    SWIGINTERN void 
    SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
        swig_varlinkobject *v = (swig_varlinkobject *) p;
        swig_globalvar *gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
        if (gv) {
            size_t size = strlen(name)+1;
            gv->name = (char *)malloc(size);
            if (gv->name) {
                strncpy(gv->name,name,size);
                gv->get_attr = get_attr;
                gv->set_attr = set_attr;
                gv->next = v->vars;
            }
        }
        v->vars = gv;
    }
    
    /* -----------------------------------------------------------------------------
     * constants/methods manipulation
     * ----------------------------------------------------------------------------- */
    
    /* Install Constants */
    SWIGINTERN void
    SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
        PyObject *obj = 0;
        size_t i;
        for (i = 0; constants[i].type; ++i) {
            switch(constants[i].type) {
                case SWIG_PY_INT:
                obj = PyInt_FromLong(constants[i].lvalue);
                break;
                case SWIG_PY_FLOAT:
                obj = PyFloat_FromDouble(constants[i].dvalue);
                break;
                case SWIG_PY_STRING:
                if (constants[i].pvalue) {
                    obj = PyString_FromString((char *) constants[i].pvalue);
                } else {
                    Py_INCREF(Py_None);
                    obj = Py_None;
                }
                break;
                case SWIG_PY_POINTER:
                obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
                break;
                case SWIG_PY_BINARY:
                obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
                break;
                default:
                obj = 0;
                break;
            }
            if (obj) {
                PyDict_SetItemString(d,constants[i].name,obj);
                Py_DECREF(obj);
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*/
    /* Fix SwigMethods to carry the callback ptrs when needed */
    /* -----------------------------------------------------------------------------*/
    
    SWIGINTERN void
    SWIG_Python_FixMethods(PyMethodDef *methods,
    swig_const_info *const_table,
    swig_type_info **types,
    swig_type_info **types_initial) {
        size_t i;
        for (i = 0; methods[i].ml_name; ++i) {
            char *c = methods[i].ml_doc;
            if (c && (c = strstr(c, "swig_ptr: "))) {
                int j;
                swig_const_info *ci = 0;
                char *name = c + 10;
                for (j = 0; const_table[j].type; ++j) {
                    if (strncmp(const_table[j].name, name, 
                    strlen(const_table[j].name)) == 0) {
                        ci = &(const_table[j]);
                        break;
                    }
                }
                if (ci) {
                    size_t shift = (ci->ptype) - types;
                    swig_type_info *ty = types_initial[shift];
                    size_t ldoc = (c - methods[i].ml_doc);
                    size_t lptr = strlen(ty->name)+2*sizeof(void*)+2;
                    char *ndoc = (char*)malloc(ldoc + lptr + 10);
                    if (ndoc) {
                        char *buff = ndoc;
                        void *ptr = (ci->type == SWIG_PY_POINTER) ? ci->pvalue : 0;
                        if (ptr) {
                            strncpy(buff, methods[i].ml_doc, ldoc);
                            buff += ldoc;
                            strncpy(buff, "swig_ptr: ", 10);
                            buff += 10;
                            SWIG_PackVoidPtr(buff, ptr, ty->name, lptr);
                            methods[i].ml_doc = ndoc;
                        }
                    }
                }
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*
     *  Initialize type list
     * -----------------------------------------------------------------------------*/
    
#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------*
 *  Partial Init method
 * -----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT void SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    PyObject *m, *d;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    
    /* Fix SwigMethods to carry the callback ptrs when needed */
    SWIG_Python_FixMethods(SwigMethods, swig_const_table, swig_types, swig_type_initial);
    
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    SWIG_InitializeModule(0);
    SWIG_InstallConstants(d,swig_const_table);
    
    PyDict_SetItemString(d,"SRS_PT_ALBERS_CONIC_EQUAL_AREA", SWIG_FromCharPtr(SRS_PT_ALBERS_CONIC_EQUAL_AREA));
    PyDict_SetItemString(d,"SRS_PT_AZIMUTHAL_EQUIDISTANT", SWIG_FromCharPtr(SRS_PT_AZIMUTHAL_EQUIDISTANT));
    PyDict_SetItemString(d,"SRS_PT_CASSINI_SOLDNER", SWIG_FromCharPtr(SRS_PT_CASSINI_SOLDNER));
    PyDict_SetItemString(d,"SRS_PT_CYLINDRICAL_EQUAL_AREA", SWIG_FromCharPtr(SRS_PT_CYLINDRICAL_EQUAL_AREA));
    PyDict_SetItemString(d,"SRS_PT_ECKERT_IV", SWIG_FromCharPtr(SRS_PT_ECKERT_IV));
    PyDict_SetItemString(d,"SRS_PT_ECKERT_VI", SWIG_FromCharPtr(SRS_PT_ECKERT_VI));
    PyDict_SetItemString(d,"SRS_PT_EQUIDISTANT_CONIC", SWIG_FromCharPtr(SRS_PT_EQUIDISTANT_CONIC));
    PyDict_SetItemString(d,"SRS_PT_EQUIRECTANGULAR", SWIG_FromCharPtr(SRS_PT_EQUIRECTANGULAR));
    PyDict_SetItemString(d,"SRS_PT_GALL_STEREOGRAPHIC", SWIG_FromCharPtr(SRS_PT_GALL_STEREOGRAPHIC));
    PyDict_SetItemString(d,"SRS_PT_GNOMONIC", SWIG_FromCharPtr(SRS_PT_GNOMONIC));
    PyDict_SetItemString(d,"SRS_PT_GOODE_HOMOLOSINE", SWIG_FromCharPtr(SRS_PT_GOODE_HOMOLOSINE));
    PyDict_SetItemString(d,"SRS_PT_HOTINE_OBLIQUE_MERCATOR", SWIG_FromCharPtr(SRS_PT_HOTINE_OBLIQUE_MERCATOR));
    PyDict_SetItemString(d,"SRS_PT_HOTINE_OBLIQUE_MERCATOR_TWO_POINT_NATURAL_ORIGIN", SWIG_FromCharPtr(SRS_PT_HOTINE_OBLIQUE_MERCATOR_TWO_POINT_NATURAL_ORIGIN));
    PyDict_SetItemString(d,"SRS_PT_LABORDE_OBLIQUE_MERCATOR", SWIG_FromCharPtr(SRS_PT_LABORDE_OBLIQUE_MERCATOR));
    PyDict_SetItemString(d,"SRS_PT_LAMBERT_CONFORMAL_CONIC_1SP", SWIG_FromCharPtr(SRS_PT_LAMBERT_CONFORMAL_CONIC_1SP));
    PyDict_SetItemString(d,"SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP", SWIG_FromCharPtr(SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP));
    PyDict_SetItemString(d,"SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP_BELGIUM", SWIG_FromCharPtr(SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP_BELGIUM));
    PyDict_SetItemString(d,"SRS_PT_LAMBERT_AZIMUTHAL_EQUAL_AREA", SWIG_FromCharPtr(SRS_PT_LAMBERT_AZIMUTHAL_EQUAL_AREA));
    PyDict_SetItemString(d,"SRS_PT_MERCATOR_1SP", SWIG_FromCharPtr(SRS_PT_MERCATOR_1SP));
    PyDict_SetItemString(d,"SRS_PT_MERCATOR_2SP", SWIG_FromCharPtr(SRS_PT_MERCATOR_2SP));
    PyDict_SetItemString(d,"SRS_PT_MILLER_CYLINDRICAL", SWIG_FromCharPtr(SRS_PT_MILLER_CYLINDRICAL));
    PyDict_SetItemString(d,"SRS_PT_MOLLWEIDE", SWIG_FromCharPtr(SRS_PT_MOLLWEIDE));
    PyDict_SetItemString(d,"SRS_PT_NEW_ZEALAND_MAP_GRID", SWIG_FromCharPtr(SRS_PT_NEW_ZEALAND_MAP_GRID));
    PyDict_SetItemString(d,"SRS_PT_OBLIQUE_STEREOGRAPHIC", SWIG_FromCharPtr(SRS_PT_OBLIQUE_STEREOGRAPHIC));
    PyDict_SetItemString(d,"SRS_PT_ORTHOGRAPHIC", SWIG_FromCharPtr(SRS_PT_ORTHOGRAPHIC));
    PyDict_SetItemString(d,"SRS_PT_POLAR_STEREOGRAPHIC", SWIG_FromCharPtr(SRS_PT_POLAR_STEREOGRAPHIC));
    PyDict_SetItemString(d,"SRS_PT_POLYCONIC", SWIG_FromCharPtr(SRS_PT_POLYCONIC));
    PyDict_SetItemString(d,"SRS_PT_ROBINSON", SWIG_FromCharPtr(SRS_PT_ROBINSON));
    PyDict_SetItemString(d,"SRS_PT_SINUSOIDAL", SWIG_FromCharPtr(SRS_PT_SINUSOIDAL));
    PyDict_SetItemString(d,"SRS_PT_STEREOGRAPHIC", SWIG_FromCharPtr(SRS_PT_STEREOGRAPHIC));
    PyDict_SetItemString(d,"SRS_PT_SWISS_OBLIQUE_CYLINDRICAL", SWIG_FromCharPtr(SRS_PT_SWISS_OBLIQUE_CYLINDRICAL));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR_SOUTH_ORIENTED", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR_SOUTH_ORIENTED));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR_MI_22", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR_MI_22));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR_MI_23", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR_MI_23));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR_MI_24", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR_MI_24));
    PyDict_SetItemString(d,"SRS_PT_TRANSVERSE_MERCATOR_MI_25", SWIG_FromCharPtr(SRS_PT_TRANSVERSE_MERCATOR_MI_25));
    PyDict_SetItemString(d,"SRS_PT_TUNISIA_MINING_GRID", SWIG_FromCharPtr(SRS_PT_TUNISIA_MINING_GRID));
    PyDict_SetItemString(d,"SRS_PT_VANDERGRINTEN", SWIG_FromCharPtr(SRS_PT_VANDERGRINTEN));
    PyDict_SetItemString(d,"SRS_PT_KROVAK", SWIG_FromCharPtr(SRS_PT_KROVAK));
    PyDict_SetItemString(d,"SRS_PP_CENTRAL_MERIDIAN", SWIG_FromCharPtr(SRS_PP_CENTRAL_MERIDIAN));
    PyDict_SetItemString(d,"SRS_PP_SCALE_FACTOR", SWIG_FromCharPtr(SRS_PP_SCALE_FACTOR));
    PyDict_SetItemString(d,"SRS_PP_STANDARD_PARALLEL_1", SWIG_FromCharPtr(SRS_PP_STANDARD_PARALLEL_1));
    PyDict_SetItemString(d,"SRS_PP_STANDARD_PARALLEL_2", SWIG_FromCharPtr(SRS_PP_STANDARD_PARALLEL_2));
    PyDict_SetItemString(d,"SRS_PP_PSEUDO_STD_PARALLEL_1", SWIG_FromCharPtr(SRS_PP_PSEUDO_STD_PARALLEL_1));
    PyDict_SetItemString(d,"SRS_PP_LONGITUDE_OF_CENTER", SWIG_FromCharPtr(SRS_PP_LONGITUDE_OF_CENTER));
    PyDict_SetItemString(d,"SRS_PP_LATITUDE_OF_CENTER", SWIG_FromCharPtr(SRS_PP_LATITUDE_OF_CENTER));
    PyDict_SetItemString(d,"SRS_PP_LONGITUDE_OF_ORIGIN", SWIG_FromCharPtr(SRS_PP_LONGITUDE_OF_ORIGIN));
    PyDict_SetItemString(d,"SRS_PP_LATITUDE_OF_ORIGIN", SWIG_FromCharPtr(SRS_PP_LATITUDE_OF_ORIGIN));
    PyDict_SetItemString(d,"SRS_PP_FALSE_EASTING", SWIG_FromCharPtr(SRS_PP_FALSE_EASTING));
    PyDict_SetItemString(d,"SRS_PP_FALSE_NORTHING", SWIG_FromCharPtr(SRS_PP_FALSE_NORTHING));
    PyDict_SetItemString(d,"SRS_PP_AZIMUTH", SWIG_FromCharPtr(SRS_PP_AZIMUTH));
    PyDict_SetItemString(d,"SRS_PP_LONGITUDE_OF_POINT_1", SWIG_FromCharPtr(SRS_PP_LONGITUDE_OF_POINT_1));
    PyDict_SetItemString(d,"SRS_PP_LATITUDE_OF_POINT_1", SWIG_FromCharPtr(SRS_PP_LATITUDE_OF_POINT_1));
    PyDict_SetItemString(d,"SRS_PP_LONGITUDE_OF_POINT_2", SWIG_FromCharPtr(SRS_PP_LONGITUDE_OF_POINT_2));
    PyDict_SetItemString(d,"SRS_PP_LATITUDE_OF_POINT_2", SWIG_FromCharPtr(SRS_PP_LATITUDE_OF_POINT_2));
    PyDict_SetItemString(d,"SRS_PP_LONGITUDE_OF_POINT_3", SWIG_FromCharPtr(SRS_PP_LONGITUDE_OF_POINT_3));
    PyDict_SetItemString(d,"SRS_PP_LATITUDE_OF_POINT_3", SWIG_FromCharPtr(SRS_PP_LATITUDE_OF_POINT_3));
    PyDict_SetItemString(d,"SRS_PP_RECTIFIED_GRID_ANGLE", SWIG_FromCharPtr(SRS_PP_RECTIFIED_GRID_ANGLE));
    PyDict_SetItemString(d,"SRS_PP_LANDSAT_NUMBER", SWIG_FromCharPtr(SRS_PP_LANDSAT_NUMBER));
    PyDict_SetItemString(d,"SRS_PP_PATH_NUMBER", SWIG_FromCharPtr(SRS_PP_PATH_NUMBER));
    PyDict_SetItemString(d,"SRS_PP_PERSPECTIVE_POINT_HEIGHT", SWIG_FromCharPtr(SRS_PP_PERSPECTIVE_POINT_HEIGHT));
    PyDict_SetItemString(d,"SRS_PP_FIPSZONE", SWIG_FromCharPtr(SRS_PP_FIPSZONE));
    PyDict_SetItemString(d,"SRS_PP_ZONE", SWIG_FromCharPtr(SRS_PP_ZONE));
    PyDict_SetItemString(d,"SRS_UL_METER", SWIG_FromCharPtr(SRS_UL_METER));
    PyDict_SetItemString(d,"SRS_UL_FOOT", SWIG_FromCharPtr(SRS_UL_FOOT));
    PyDict_SetItemString(d,"SRS_UL_FOOT_CONV", SWIG_FromCharPtr(SRS_UL_FOOT_CONV));
    PyDict_SetItemString(d,"SRS_UL_US_FOOT", SWIG_FromCharPtr(SRS_UL_US_FOOT));
    PyDict_SetItemString(d,"SRS_UL_US_FOOT_CONV", SWIG_FromCharPtr(SRS_UL_US_FOOT_CONV));
    PyDict_SetItemString(d,"SRS_UL_NAUTICAL_MILE", SWIG_FromCharPtr(SRS_UL_NAUTICAL_MILE));
    PyDict_SetItemString(d,"SRS_UL_NAUTICAL_MILE_CONV", SWIG_FromCharPtr(SRS_UL_NAUTICAL_MILE_CONV));
    PyDict_SetItemString(d,"SRS_UL_LINK", SWIG_FromCharPtr(SRS_UL_LINK));
    PyDict_SetItemString(d,"SRS_UL_LINK_CONV", SWIG_FromCharPtr(SRS_UL_LINK_CONV));
    PyDict_SetItemString(d,"SRS_UL_CHAIN", SWIG_FromCharPtr(SRS_UL_CHAIN));
    PyDict_SetItemString(d,"SRS_UL_CHAIN_CONV", SWIG_FromCharPtr(SRS_UL_CHAIN_CONV));
    PyDict_SetItemString(d,"SRS_UL_ROD", SWIG_FromCharPtr(SRS_UL_ROD));
    PyDict_SetItemString(d,"SRS_UL_ROD_CONV", SWIG_FromCharPtr(SRS_UL_ROD_CONV));
    PyDict_SetItemString(d,"SRS_DN_NAD27", SWIG_FromCharPtr(SRS_DN_NAD27));
    PyDict_SetItemString(d,"SRS_DN_NAD83", SWIG_FromCharPtr(SRS_DN_NAD83));
    PyDict_SetItemString(d,"SRS_DN_WGS72", SWIG_FromCharPtr(SRS_DN_WGS72));
    PyDict_SetItemString(d,"SRS_DN_WGS84", SWIG_FromCharPtr(SRS_DN_WGS84));
    {
        PyDict_SetItemString(d,"SRS_WGS84_SEMIMAJOR", SWIG_From_double(static_cast<double >(SRS_WGS84_SEMIMAJOR))); 
    }
    {
        PyDict_SetItemString(d,"SRS_WGS84_INVFLATTENING", SWIG_From_double(static_cast<double >(SRS_WGS84_INVFLATTENING))); 
    }
}

