/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_OWN           0x1
#define SWIG_POINTER_DISOWN        0x2
#define SWIG_TRACK_OBJECTS	        0x4

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * rubytracking.swg
 *
 * This file contains support for tracking mappings from 
 * Ruby objects to C++ objects.  This functionality is needed
 * to implement mark functions for Ruby's mark and sweep
 * garbage collector.
 ************************************************************************/

/* Global Ruby hash table to store Trackings from C/C++
   structs to Ruby Objects. */
static VALUE swig_ruby_trackings;

/* Setup a Ruby hash table to store Trackings */
static void SWIG_RubyInitializeTrackings() {
	/* Create a ruby hash table to store Trackings from C++ 
	objects to Ruby objects.  Also make sure to tell
	the garabage collector about the hash table. */
	swig_ruby_trackings = rb_hash_new();
	rb_gc_register_address(&swig_ruby_trackings);
}

/* Get a Ruby number to reference a pointer */
static VALUE SWIG_RubyPtrToReference(void* ptr) {
	/* We cast the pointer to an unsigned long
	 and then store a reference to it using
	 a Ruby number object. */

	/* Convert the pointer to a Ruby number */
	unsigned long value = (unsigned long) ptr;
	return LONG2NUM(value);
}

/* Get a Ruby number to reference an object */
static VALUE SWIG_RubyObjectToReference(VALUE object) {
	/* We cast the object to an unsigned long
	 and then store a reference to it using
	 a Ruby number object. */

	/* Convert the Object to a Ruby number */
	unsigned long value = (unsigned long) object;
	return LONG2NUM(value);
}

/* Get a Ruby object from a previously stored reference */
static VALUE SWIG_RubyReferenceToObject(VALUE reference) {
	/* The provided Ruby number object is a reference
	to the Ruby object we want.*/

	/* First convert the Ruby number to a C number */
	unsigned long value = NUM2LONG(reference);
	return (VALUE) value;
}

/* Add a Tracking from a C/C++ struct to a Ruby object */
static void SWIG_RubyAddTracking(void* ptr, VALUE object) {
	/* In a Ruby hash table we store the pointer and
	the associated Ruby object.  The trick here is
	that we cannot store the Ruby object directly - if
	we do then it cannot be garbage collected.  So
	instead we typecast it as a unsigned long and
	convert it to a Ruby number object.*/

	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Get a reference to the Ruby object as a Ruby number */
	VALUE value = SWIG_RubyObjectToReference(object);

  /* Store the mapping to the global hash table. */
	rb_hash_aset(swig_ruby_trackings, key, value);
}

/* Get the Ruby object that owns the specified C/C++ struct */
static VALUE SWIG_RubyInstanceFor(void* ptr) {
	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Now lookup the value stored in the global hash table */
	VALUE value = rb_hash_aref(swig_ruby_trackings, key);
	
	if (value == Qnil) {
	  /* No object exists - return nil. */
		return Qnil;
	}
	else {
		/* Convert this value to Ruby object */
		return SWIG_RubyReferenceToObject(value);
	}
}

/* Remove a Tracking from a C/C++ struct to a Ruby object */
static void SWIG_RubyRemoveTracking(void* ptr) {
	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Define delete method - in C++ this could be marked as
	   static but unfortunately not in C. */
	VALUE delete_function = rb_intern("delete");

	/* Delete the object from the hash table by calling Ruby's
	   do this we need to call the Hash.delete method.*/
	rb_funcall(swig_ruby_trackings, delete_function, 1, key);
}

/* This is a helper method that unlinks a Ruby object from its
   underlying C++ object.  This is needed if the lifetime of the
   Ruby object is longer than the C++ object */
static void SWIG_RubyUnlinkObjects(void* ptr) {
	VALUE object = SWIG_RubyInstanceFor(ptr);

	if (object != Qnil) {
		DATA_PTR(object) = 0;
	}
}

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)
#define SWIG_GetModule(clientdata) \
  SWIG_Ruby_GetModule()
#define SWIG_SetModule(clientdata, pointer) \
  SWIG_Ruby_SetModule(pointer)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;
static VALUE swig_runtime_data_type_pointer = Qnil;

/* Initialize Ruby runtime support */
static void
SWIG_Ruby_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
static void
SWIG_Ruby_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
static VALUE
SWIG_Ruby_NewPointerObj(void *ptr, swig_type_info *type, int flags)
{
	 int own = flags & SWIG_POINTER_OWN;
	 int track = flags & SWIG_TRACK_OBJECTS;
	 
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
      return Qnil;
    
    /* Have we already wrapped this pointer? */
    if (track) {
	    obj = SWIG_RubyInstanceFor(ptr);
   	 if (obj != Qnil) {
      	return obj;
    	}
    }
		
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    
    /* Keep track of this object if necessary */
    if (track) {
	   SWIG_RubyAddTracking(ptr, obj);
    }
   
    return obj;
}

/* Create a new class instance (always owned) */
static VALUE
SWIG_Ruby_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
static SWIGINLINE char *
SWIG_Ruby_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return StringValuePtr(stype);
}

/* Convert a pointer value */
static int
SWIG_Ruby_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_cast_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else {
    Data_Get_Struct(obj, void, *ptr);
  }
  
  /* Check to see if the input object is giving up ownership
     of the underlying C struct or C++ object.  If so then we
     need to reset the destructor since the Ruby object no 
     longer owns the underlying C++ object.*/ 
  if (flags & SWIG_POINTER_DISOWN) {
	 if (flags & SWIG_TRACK_OBJECTS) {
      /* We are tracking objects.  Thus we change the destructor
		 * to SWIG_RubyRemoveTracking.  This allows us to
		 * remove the mapping from the C++ to Ruby object
		 * when the Ruby object is garbage collected.  If we don't
		 * do this, then it is possible we will return a reference 
		 * to a Ruby object that no longer exists thereby crashing Ruby. */
		RDATA(obj)->dfree = SWIG_RubyRemoveTracking;
  	 } else {    
      RDATA(obj)->dfree = 0;
    }
  }

  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (*ptr == 0)
            rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
          return 0;
        }
    }
    if ((c = SWIG_MangleStr(obj)) == NULL) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    *ptr = SWIG_TypeCast(tc, *ptr);
  }
  return 0;
}

/* Convert a pointer value, signal an exception on a type mismatch */
static SWIGINLINE void *
SWIG_Ruby_MustGetPtr(VALUE obj, swig_type_info *ty, int argnum, int flags)
{
  void *result;
  SWIG_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Check convert */
static SWIGINLINE int
SWIG_Ruby_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

static VALUE
SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
static void
SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = StringValuePtr(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

static swig_module_info *SWIG_Ruby_GetModule() {
    VALUE pointer;
    swig_module_info *ret = 0;

   /* first check if pointer already created */
    pointer = rb_gv_get("$swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
    if (pointer != Qnil) {
      Data_Get_Struct(pointer, swig_module_info, ret);
    }
    return ret;
}

static void SWIG_Ruby_SetModule(swig_module_info *pointer) {
      /* register a new class */
      VALUE cl = rb_define_class("swig_runtime_data", rb_cObject);
      /* create and store the structure pointer to a global variable */
      swig_runtime_data_type_pointer = Data_Wrap_Struct(cl, 0, 0, pointer);
      rb_define_readonly_variable("$swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, &swig_runtime_data_type_pointer);
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_GIntBig swig_types[0]
#define SWIGTYPE_p_OGRDataSourceShadow swig_types[1]
#define SWIGTYPE_p_OGRDriverShadow swig_types[2]
#define SWIGTYPE_p_OGRFeatureDefnShadow swig_types[3]
#define SWIGTYPE_p_OGRFeatureShadow swig_types[4]
#define SWIGTYPE_p_OGRFieldDefnShadow swig_types[5]
#define SWIGTYPE_p_OGRGeometryShadow swig_types[6]
#define SWIGTYPE_p_OGRLayerShadow swig_types[7]
#define SWIGTYPE_p_OSRCoordinateTransformationShadow swig_types[8]
#define SWIGTYPE_p_OSRSpatialReferenceShadow swig_types[9]
#define SWIGTYPE_p_double swig_types[10]
#define SWIGTYPE_p_int swig_types[11]
#define SWIGTYPE_p_p_char swig_types[12]
#define SWIGTYPE_p_unsigned_long swig_types[13]
static swig_type_info *swig_types[15];
static swig_module_info swig_module = {swig_types, 14, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_ogr
#define SWIG_name    "Gdal::Ogr"

static VALUE mOgr;

static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_exception_(int code, const char *msg) {
    switch (code) {
        case SWIG_MemoryError:
            rb_raise(rb_eNoMemError, msg);
            break;
        case SWIG_IOError:
            rb_raise(rb_eIOError, msg);
            break;
        case SWIG_RuntimeError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        case SWIG_IndexError:
            rb_raise(rb_eIndexError, msg);
            break;
        case SWIG_TypeError:
            rb_raise(rb_eTypeError, msg);
            break;
        case SWIG_DivisionByZero:
            rb_raise(rb_eZeroDivError, msg);
            break;
        case SWIG_OverflowError:
            rb_raise(rb_eRangeError, msg);
            break;
        case SWIG_SyntaxError:
            rb_raise(rb_eSyntaxError, msg);
            break;
        case SWIG_ValueError:
            rb_raise(rb_eArgError, msg);
            break;
        case SWIG_SystemError:
            rb_raise(rb_eFatal, msg);
            break;
        case SWIG_UnknownError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        default:
            break;
    }
}

#define SWIG_exception(a, b) SWIG_exception_((a), (b))


#include <stdexcept>


#include <iostream>
using namespace std;

#include "ogr_api.h"
#include "ogr_core.h"
#include "cpl_port.h"
#include "cpl_string.h"

typedef void OSRSpatialReferenceShadow;
typedef void OGRDriverShadow;
typedef void OGRDataSourceShadow;
typedef void OGRLayerShadow;
typedef void OGRFeatureShadow;
typedef void OGRFeatureDefnShadow;
typedef void OGRGeometryShadow;
typedef void OSRCoordinateTransformationShadow;
typedef void OGRFieldDefnShadow;


#ifdef __cplusplus
extern "C" {
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
struct timeval rb_time_timeval(VALUE);
#endif
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
#include "rubyio.h"
#ifdef __cplusplus
}
#endif



static char const *
OGRErrMessages( int rc ) {
  switch( rc ) {
  case 0:
    return "OGR Error: None";
  case 1:
    return "OGR Error: Not enough data";
  case 2:
    return "OGR Error: Not enough memory";
  case 3:
    return "OGR Error: Unsupported geometry type";
  case 4:
    return "OGR Error: Unsupported operation";
  case 5:
    return "OGR Error: Corrupt data";
  case 6:
    return "OGR Error: General Error";
  case 7:
    return "OGR Error: Unsupported SRS";
  default:
    return "OGR Error: Unknown";
  }
}


void VeryQuiteErrorHandler(CPLErr eclass, int code, const char *msg ) {
  /* If the error class is CE_Fatal, we want to have a message issued
     because the CPL support code does an abort() before any exception
     can be generated */
  if (eclass == CE_Fatal ) {
    CPLDefaultErrorHandler(eclass, code, msg );
  }
}


void UseExceptions() {
  CPLSetErrorHandler( (CPLErrorHandler) VeryQuiteErrorHandler );
}

void DontUseExceptions() {
  CPLSetErrorHandler( CPLDefaultErrorHandler );
}

static OGRDataSourceShadow *OGRDriverShadow_CreateDataSource(OGRDriverShadow *self,char const *name,char **options=0){
    OGRDataSourceShadow *ds = (OGRDataSourceShadow*) OGR_Dr_CreateDataSource( self, name, options);
    return ds;
  }
static OGRDataSourceShadow *OGRDriverShadow_CopyDataSource(OGRDriverShadow *self,OGRDataSourceShadow *copy_ds,char const *name,char **options=0){
    OGRDataSourceShadow *ds = (OGRDataSourceShadow*) OGR_Dr_CopyDataSource(self, copy_ds, name, options);
    return ds;
  }
static OGRDataSourceShadow *OGRDriverShadow_Open(OGRDriverShadow *self,char const *name,int update=0){
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*) OGR_Dr_Open(self, name, update);
    return ds;
  }
static int OGRDriverShadow_DeleteDataSource(OGRDriverShadow *self,char const *name){
    return OGR_Dr_DeleteDataSource( self, name );
  }
static bool OGRDriverShadow_TestCapability(OGRDriverShadow *self,char const *cap){
    return OGR_Dr_TestCapability(self, cap);
  }
static char const *OGRDriverShadow_GetName(OGRDriverShadow *self){
    return OGR_Dr_GetName( self );
  }
static int OGRDataSourceShadow_GetRefCount(OGRDataSourceShadow *self){
    return OGR_DS_GetRefCount(self);
  }
static int OGRDataSourceShadow_GetSummaryRefCount(OGRDataSourceShadow *self){
    return OGR_DS_GetSummaryRefCount(self);
  }
static int OGRDataSourceShadow_GetLayerCount(OGRDataSourceShadow *self){
    return OGR_DS_GetLayerCount(self);
  }
static char const *OGRDataSourceShadow_GetName(OGRDataSourceShadow *self){
    return OGR_DS_GetName(self);
  }
static OGRErr OGRDataSourceShadow_DeleteLayer(OGRDataSourceShadow *self,int index){
    return OGR_DS_DeleteLayer(self, index);
  }
static OGRLayerShadow *OGRDataSourceShadow_CreateLayer(OGRDataSourceShadow *self,char const *name,OSRSpatialReferenceShadow *reference=NULL,OGRwkbGeometryType geom_type=wkbUnknown,char **options=0){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_CreateLayer( self,
                                                        name,
                                                        reference,
                                                        geom_type,
                                                        options);
    return layer;
  }
static OGRLayerShadow *OGRDataSourceShadow_CopyLayer(OGRDataSourceShadow *self,OGRLayerShadow *src_layer,char const *new_name,char **options=0){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_CopyLayer( self,
                                                      src_layer,
                                                      new_name,
                                                      options);
    return layer;
  }
static bool OGRDataSourceShadow_TestCapability(OGRDataSourceShadow *self,char const *cap){
    return OGR_DS_TestCapability(self, cap);
  }
static OGRLayerShadow *OGRDataSourceShadow_ExecuteSQL(OGRDataSourceShadow *self,char const *statement,OGRGeometryShadow *geom=NULL,char const *dialect=""){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_ExecuteSQL((OGRDataSourceShadow*)self,
                                                      statement,
                                                      geom,
                                                      dialect);
    return layer;
  }
static void OGRDataSourceShadow_ReleaseResultSet(OGRDataSourceShadow *self,OGRLayerShadow *layer){
    OGR_DS_ReleaseResultSet(self, layer);
  }
static OGRLayerShadow *OGRDataSourceShadow_GetLayer(OGRDataSourceShadow *self,VALUE whichLayer){
		// get field index
		switch (TYPE(whichLayer)) {
			case T_STRING: {
				char* name = StringValuePtr(whichLayer);
				return OGR_DS_GetLayerByName(self, name);
				break;
			}
			case T_FIXNUM: {
				int index = NUM2INT(whichLayer);
				return OGR_DS_GetLayer(self, index);
				break;
			}
			default:
				SWIG_exception(SWIG_TypeError, "Value must be a string or integer.");
		}
	}
static int OGRLayerShadow_GetRefCount(OGRLayerShadow *self){
    return OGR_L_GetRefCount(self);
  }
static void OGRLayerShadow_SetSpatialFilter(OGRLayerShadow *self,OGRGeometryShadow *filter){
    OGR_L_SetSpatialFilter (self, filter);
  }
static void OGRLayerShadow_SetSpatialFilterRect(OGRLayerShadow *self,double minx,double miny,double maxx,double maxy){
    OGR_L_SetSpatialFilterRect(self, minx, miny, maxx, maxy);                          
  }
static OGRGeometryShadow *OGRLayerShadow_GetSpatialFilter(OGRLayerShadow *self){
    return (OGRGeometryShadow *) OGR_L_GetSpatialFilter(self);
  }
static OGRErr OGRLayerShadow_SetAttributeFilter(OGRLayerShadow *self,char *filter_string){
    OGRErr err = OGR_L_SetAttributeFilter((OGRLayerShadow*)self, filter_string);
    if (err != 0) {
      throw err;
    } 
    return 0;
  }
static void OGRLayerShadow_ResetReading(OGRLayerShadow *self){
    OGR_L_ResetReading(self);
  }
static char const *OGRLayerShadow_GetName(OGRLayerShadow *self){
    return OGR_FD_GetName(OGR_L_GetLayerDefn(self));
  }
static OGRFeatureShadow *OGRLayerShadow_GetFeature(OGRLayerShadow *self,long fid){
    return (OGRFeatureShadow*) OGR_L_GetFeature(self, fid);
  }
static OGRFeatureShadow *OGRLayerShadow_GetNextFeature(OGRLayerShadow *self){
    return (OGRFeatureShadow*) OGR_L_GetNextFeature(self);
  }
static OGRErr OGRLayerShadow_SetNextByIndex(OGRLayerShadow *self,long new_index){
    OGRErr err = OGR_L_SetNextByIndex(self, new_index);
    if (err != 0) {
      throw err;
    }
    return 0;
  }
static OGRErr OGRLayerShadow_SetFeature(OGRLayerShadow *self,OGRFeatureShadow *feature){
    OGRErr err = OGR_L_SetFeature(self, feature);
    if (err != 0) {
      throw err;
    }
    return 0;
  }
static OGRErr OGRLayerShadow_CreateFeature(OGRLayerShadow *self,OGRFeatureShadow *feature){
    OGRErr err = OGR_L_CreateFeature(self, feature);
    if (err != 0) {
      throw err;
    }
    return 0;
  }
static OGRErr OGRLayerShadow_DeleteFeature(OGRLayerShadow *self,long fid){
    OGRErr err = OGR_L_DeleteFeature(self, fid);
    if (err != 0) {
      throw err;
    }
    return 0;
  }
static OGRErr OGRLayerShadow_SyncToDisk(OGRLayerShadow *self){
    OGRErr err = OGR_L_SyncToDisk(self);
    if (err != 0) {
      throw err;
    }
    return 0;
  }
static OGRFeatureDefnShadow *OGRLayerShadow_GetLayerDefn(OGRLayerShadow *self){
    return (OGRFeatureDefnShadow*) OGR_L_GetLayerDefn(self);
  }
static int OGRLayerShadow_GetFeatureCount(OGRLayerShadow *self,int force=1){
    return OGR_L_GetFeatureCount(self, force);
  }
static void OGRLayerShadow_GetExtent(OGRLayerShadow *self,double argout[4],int force=1){
    OGRErr err = OGR_L_GetExtent(self, (OGREnvelope*)argout, force);
    if (err != 0)
      throw err;
  }
static bool OGRLayerShadow_TestCapability(OGRLayerShadow *self,char const *cap){
    return OGR_L_TestCapability(self, cap);
  }
static OGRErr OGRLayerShadow_CreateField(OGRLayerShadow *self,OGRFieldDefnShadow *field_def,int approx_ok=1){
    OGRErr err = OGR_L_CreateField(self, field_def, approx_ok);
    if (err != 0)
      throw err;
    return 0;
  }
static OGRErr OGRLayerShadow_StartTransaction(OGRLayerShadow *self){
    OGRErr err = OGR_L_StartTransaction(self);
    if (err != 0)
      throw err;
    return 0;
  }
static OGRErr OGRLayerShadow_CommitTransaction(OGRLayerShadow *self){
    OGRErr err = OGR_L_CommitTransaction(self);
    if (err != 0)
      throw err;
    return 0;
  }
static OGRErr OGRLayerShadow_RollbackTransaction(OGRLayerShadow *self){
    OGRErr err = OGR_L_RollbackTransaction(self);
    if (err != 0)
      throw err;
    return 0;
  }
static OSRSpatialReferenceShadow *OGRLayerShadow_GetSpatialRef(OGRLayerShadow *self){
    return (OSRSpatialReferenceShadow*) OGR_L_GetSpatialRef(self);
  }
static GIntBig OGRLayerShadow_GetFeatureRead(OGRLayerShadow *self){
    return OGR_L_GetFeaturesRead(self);
  }
static void OGRLayerShadow_each(OGRLayerShadow *self){
		OGRFeatureShadow* feature = NULL;

 		while (feature = (OGRFeatureShadow*) OGR_L_GetNextFeature(self))
 		{
			/* Convert the pointer to a Ruby object.  Note we set the flag
		   to one manually to show this is a new object */
			VALUE object = SWIG_NewPointerObj((void *) feature, SWIGTYPE_p_OGRFeatureShadow, SWIG_POINTER_OWN);			

			/* Now invoke the block specified for this method. */
			rb_yield(object);
		}
  }
static OGRFeatureShadow *new_OGRFeatureShadow(OGRFeatureDefnShadow *feature_def=0){
    return (OGRFeatureShadow*) OGR_F_Create( feature_def );
  }
static OGRFeatureDefnShadow *OGRFeatureShadow_GetDefnRef(OGRFeatureShadow *self){
    return (OGRFeatureDefnShadow*) OGR_F_GetDefnRef(self);
  }
static OGRErr OGRFeatureShadow_SetGeometry(OGRFeatureShadow *self,OGRGeometryShadow *geom){
    OGRErr err = OGR_F_SetGeometry(self, geom);
    if (err != 0)
      throw err;
    return 0;
  }
static OGRErr OGRFeatureShadow_SetGeometryDirectly(OGRFeatureShadow *self,OGRGeometryShadow *geom){
    OGRErr err = OGR_F_SetGeometryDirectly(self, geom);
    if (err != 0)
      throw err;
    return 0;
  }
static OGRGeometryShadow *OGRFeatureShadow_GetGeometryRef(OGRFeatureShadow *self){
    return (OGRGeometryShadow*) OGR_F_GetGeometryRef(self);
  }
static OGRFeatureShadow *OGRFeatureShadow_Clone(OGRFeatureShadow *self){
    return (OGRFeatureShadow*) OGR_F_Clone(self);
  }
static bool OGRFeatureShadow_Equal(OGRFeatureShadow *self,OGRFeatureShadow *feature){
    return OGR_F_Equal(self, feature);
  }
static int OGRFeatureShadow_GetFieldCount(OGRFeatureShadow *self){
    return OGR_F_GetFieldCount(self);
  }
static OGRFieldDefnShadow *OGRFeatureShadow_GetFieldDefnRef__SWIG_0(OGRFeatureShadow *self,int id){
    return (OGRFieldDefnShadow *) OGR_F_GetFieldDefnRef(self, id);
  }
static OGRFieldDefnShadow *OGRFeatureShadow_GetFieldDefnRef__SWIG_1(OGRFeatureShadow *self,char const *name){
    return (OGRFieldDefnShadow *) OGR_F_GetFieldDefnRef(self, OGR_F_GetFieldIndex(self, name));
  }
static char const *OGRFeatureShadow_GetFieldAsString__SWIG_0(OGRFeatureShadow *self,int id){
    return (const char *) OGR_F_GetFieldAsString(self, id);
  }
static char const *OGRFeatureShadow_GetFieldAsString__SWIG_1(OGRFeatureShadow *self,char const *name){
    return (const char *) OGR_F_GetFieldAsString(self, OGR_F_GetFieldIndex(self, name));
  }
static int OGRFeatureShadow_GetFieldAsInteger__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_GetFieldAsInteger(self, id);
  }
static int OGRFeatureShadow_GetFieldAsInteger__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldAsInteger(self, OGR_F_GetFieldIndex(self, name));
  }
static double OGRFeatureShadow_GetFieldAsDouble__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_GetFieldAsDouble(self, id);
  }
static double OGRFeatureShadow_GetFieldAsDouble__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldAsDouble(self, OGR_F_GetFieldIndex(self, name));
  }
static bool OGRFeatureShadow_IsFieldSet__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_IsFieldSet(self, id);
  }
static bool OGRFeatureShadow_IsFieldSet__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_IsFieldSet(self, OGR_F_GetFieldIndex(self, name));
  }
static int OGRFeatureShadow_GetFieldIndex(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldIndex(self, name);
  }
static int OGRFeatureShadow_GetFID(OGRFeatureShadow *self){
    return OGR_F_GetFID(self);
  }
static OGRErr OGRFeatureShadow_SetFID(OGRFeatureShadow *self,int fid){
    OGRErr err = OGR_F_SetFID(self, fid);
    if (err != 0)
      throw err;
    return 0;
  }
static void OGRFeatureShadow_DumpReadable(OGRFeatureShadow *self){
    OGR_F_DumpReadable(self, NULL);
  }
static void OGRFeatureShadow_UnsetField__SWIG_0(OGRFeatureShadow *self,int id){
    OGR_F_UnsetField(self, id);
  }
static void OGRFeatureShadow_UnsetField__SWIG_1(OGRFeatureShadow *self,char const *name){
    OGR_F_UnsetField(self, OGR_F_GetFieldIndex(self, name));
  }
static void OGRFeatureShadow_SetField__SWIG_0(OGRFeatureShadow *self,int id,char const *value){
    OGR_F_SetFieldString(self, id, value);
  }
static void OGRFeatureShadow_SetField__SWIG_1(OGRFeatureShadow *self,char const *name,char const *value){
    OGR_F_SetFieldString(self, OGR_F_GetFieldIndex(self, name), value);
  }
static OGRErr OGRFeatureShadow_SetFrom(OGRFeatureShadow *self,OGRFeatureShadow *other,int forgiving=1){
    OGRErr err = OGR_F_SetFrom(self, other, forgiving);
    if (err != 0)
      throw err;
    return 0;
  }
static char const *OGRFeatureShadow_GetStyleString(OGRFeatureShadow *self){
    return (const char*) OGR_F_GetStyleString(self);
  }
static void OGRFeatureShadow_SetStyleString(OGRFeatureShadow *self,char const *the_string){
    OGR_F_SetStyleString(self, the_string);
  }
static OGRFieldType OGRFeatureShadow_GetFieldType__SWIG_0(OGRFeatureShadow *self,int id){
    return (OGRFieldType) OGR_Fld_GetType( OGR_F_GetFieldDefnRef( self, id));
  }
static OGRFieldType OGRFeatureShadow_GetFieldType__SWIG_1(OGRFeatureShadow *self,char const *name,char const *value){
    return (OGRFieldType) OGR_Fld_GetType( 
                            OGR_F_GetFieldDefnRef( self,  
                                                   OGR_F_GetFieldIndex(self, 
                                                                       name)
                                                  )
                                          );
    
  }
static VALUE OGRFeatureShadow_GetField(OGRFeatureShadow *self,VALUE object){
		VALUE result;

		int index;

		// get field index
		switch (TYPE(object)) {
			case T_STRING:
				index = OGR_F_GetFieldIndex(self, StringValuePtr(object));
				break;
			case T_FIXNUM:
				index = NUM2INT(object);
				break;
			default:
				SWIG_exception(SWIG_TypeError, "Value must be a string or integer.");
		}
		
		int count = OGR_F_GetFieldCount(self);
		
		if (index < 0 || index > count) {
			SWIG_exception(SWIG_IndexError, "Illegal field requested.");
		}

		// is the field unset?
	  if (!OGR_F_IsFieldSet(self, index)) {
	  	result = Qnil;
	  	return result;
	  }
	  
	  // get field type
    OGRFieldType field_type = (OGRFieldType) OGR_Fld_GetType(OGR_F_GetFieldDefnRef( self, index));

		switch (field_type) {
			case OFTInteger: {
				const int value = OGR_F_GetFieldAsInteger(self, index);
				result = INT2NUM(value);
				break;
			}

			case OFTIntegerList: {
				int len = 0;
				const int* list = OGR_F_GetFieldAsIntegerList(self, index, &len);
				
				result = rb_ary_new2(len);
				
		    for ( int i = 0; i < len; ++i, ++list ) {
					VALUE item = INT2NUM(*list);
		      rb_ary_store(result, item, i);
		    }
		    break;
			}

			case OFTReal: {
				const double value = OGR_F_GetFieldAsDouble(self, index);
				return rb_float_new(value);
				break;
			}

			case OFTRealList: {
				int len = 0;
				const double* list = OGR_F_GetFieldAsDoubleList(self, index, &len);
				
				result = rb_ary_new2(len);
				
		    for ( int i = 0; i < len; ++i, ++list ) {
					VALUE item = rb_float_new(*list);
		      rb_ary_store(result, item, i);
		    }
		    break;
			}

			case OFTString: {
				const char* value = (const char *) OGR_F_GetFieldAsString(self, index);
				return rb_str_new2(value);
				break;
			}

			case OFTStringList:
/*				int len3 = 0;
				const char** string_list = OGR_F_GetFieldAsStringList(self, index, &len);
				
				result = rb_ary_new2(len3);
				
		    for ( int i = 0; i < len; ++i, ++string_list ) {
					VALUE item = rb_str_new2(*string_list);
		      rb_ary_store(result, item, i);
		    }*/
		    result = Qnil;
		    break;
			default:
				SWIG_exception(SWIG_TypeError, "Unsupported field type.");
		}
	
		return result;		
	}
static OGRFeatureDefnShadow *new_OGRFeatureDefnShadow(char const *name=NULL){
    return (OGRFeatureDefnShadow* )OGR_FD_Create(name);
  }
static char const *OGRFeatureDefnShadow_GetName(OGRFeatureDefnShadow *self){
    return OGR_FD_GetName(self);
  }
static int OGRFeatureDefnShadow_GetFieldCount(OGRFeatureDefnShadow *self){
    return OGR_FD_GetFieldCount(self);
  }
static OGRFieldDefnShadow *OGRFeatureDefnShadow_GetFieldDefn(OGRFeatureDefnShadow *self,int i){
    return (OGRFieldDefnShadow*) OGR_FD_GetFieldDefn(self, i);
  }
static int OGRFeatureDefnShadow_GetFieldIndex(OGRFeatureDefnShadow *self,char const *name){
    return OGR_FD_GetFieldIndex(self, name);
  }
static void OGRFeatureDefnShadow_AddFieldDefn(OGRFeatureDefnShadow *self,OGRFieldDefnShadow *defn){
    OGR_FD_AddFieldDefn(self, defn);
  }
static OGRwkbGeometryType OGRFeatureDefnShadow_GetGeomType(OGRFeatureDefnShadow *self){
    return (OGRwkbGeometryType) OGR_FD_GetGeomType(self);
  }
static void OGRFeatureDefnShadow_SetGeomType(OGRFeatureDefnShadow *self,OGRwkbGeometryType geom_type){
    OGR_FD_SetGeomType(self, geom_type);
  }
static int OGRFeatureDefnShadow_GetReferenceCount(OGRFeatureDefnShadow *self){
    return OGR_FD_GetReferenceCount(self);
  }
static OGRFieldDefnShadow *new_OGRFieldDefnShadow(char const *name="unnamed",OGRFieldType field_type=OFTString){
    return (OGRFieldDefnShadow*) OGR_Fld_Create(name, field_type);
  }
static char const *OGRFieldDefnShadow_GetName(OGRFieldDefnShadow *self){
    return (const char *) OGR_Fld_GetNameRef(self);
  }
static char const *OGRFieldDefnShadow_GetNameRef(OGRFieldDefnShadow *self){
    return (const char *) OGR_Fld_GetNameRef(self);
  }
static void OGRFieldDefnShadow_SetName(OGRFieldDefnShadow *self,char const *name){
    OGR_Fld_SetName(self, name);
  }
static OGRFieldType OGRFieldDefnShadow_GetType(OGRFieldDefnShadow *self){
    return OGR_Fld_GetType(self);
  }
static void OGRFieldDefnShadow_SetType(OGRFieldDefnShadow *self,OGRFieldType type){
    OGR_Fld_SetType(self, type);
  }
static OGRJustification OGRFieldDefnShadow_GetJustify(OGRFieldDefnShadow *self){
    return OGR_Fld_GetJustify(self);
  }
static void OGRFieldDefnShadow_SetJustify(OGRFieldDefnShadow *self,OGRJustification justify){
    OGR_Fld_SetJustify(self, justify);
  }
static int OGRFieldDefnShadow_GetWidth(OGRFieldDefnShadow *self){
    return OGR_Fld_GetWidth(self);
  }
static void OGRFieldDefnShadow_SetWidth(OGRFieldDefnShadow *self,int width){
    OGR_Fld_SetWidth(self, width);
  }
static int OGRFieldDefnShadow_GetPrecision(OGRFieldDefnShadow *self){
    return OGR_Fld_GetPrecision(self);
  }
static void OGRFieldDefnShadow_SetPrecision(OGRFieldDefnShadow *self,int precision){
    OGR_Fld_SetPrecision(self, precision);
  }
static char const *OGRFieldDefnShadow_GetFieldTypeName(OGRFieldDefnShadow *self,OGRFieldType type){
    return OGR_GetFieldTypeName(type);
  }

  OGRGeometryShadow* CreateGeometryFromWkb( int len, char *bin_string, 
                                            OSRSpatialReferenceShadow *reference=NULL ) {
    void *geom;
    OGRErr err = OGR_G_CreateFromWkb( (unsigned char *) bin_string,
                                      reference,
                                      &geom,
                                      len );
    if (err != 0 )
       throw err;
    return (OGRGeometryShadow*) geom;
  }
 


  OGRGeometryShadow* CreateGeometryFromWkt( char **val, 
                                      OSRSpatialReferenceShadow *reference=NULL ) {
    void *geom;
    OGRErr err = OGR_G_CreateFromWkt(val,
                                      reference,
                                      &geom);
    if (err != 0 )
       throw err;
    return (OGRGeometryShadow*) geom;
  }
 


  OGRGeometryShadow *CreateGeometryFromGML( const char * input_string ) {
    OGRGeometryShadow* geom = (OGRGeometryShadow*)OGR_G_CreateFromGML(input_string);
    return geom;
  }
 

static OGRGeometryShadow *new_OGRGeometryShadow(OGRwkbGeometryType type=wkbUnknown,char *wkt=0,int wkb=0,char *wkb_buf=0,char *gml=0){
    if (type != wkbUnknown ) {
      return (OGRGeometryShadow*) OGR_G_CreateGeometry( type );
    }
    else if ( wkt != 0 ) {
      return CreateGeometryFromWkt( &wkt );
    }
    else if ( wkb != 0 ) {
      return CreateGeometryFromWkb( wkb, wkb_buf );
    }
    else if ( gml != 0 ) {
      return CreateGeometryFromGML( gml );
    }
    // throw?
    else return 0;
  }
static char const *OGRGeometryShadow_ExportToWkt(OGRGeometryShadow *self){
    char * output;
    OGRErr err = OGR_G_ExportToWkt(self, &output);
    if (err != 0) 
      throw err;
    return output;
  }
static OGRErr OGRGeometryShadow_ExportToWkb(OGRGeometryShadow *self,int *nLen,char **pBuf,OGRwkbByteOrder byte_order=wkbXDR){
    *nLen = OGR_G_WkbSize( self );
    *pBuf = (char *) malloc( *nLen * sizeof(unsigned char) );
    return OGR_G_ExportToWkb(self, byte_order, (unsigned char*) *pBuf );
  }
static char const *OGRGeometryShadow_ExportToGML(OGRGeometryShadow *self){
    return (const char *) OGR_G_ExportToGML(self);
  }
static void OGRGeometryShadow_AddPoint(OGRGeometryShadow *self,double x,double y,double z=0){
    OGR_G_AddPoint( self, x, y, z );
  }
static OGRErr OGRGeometryShadow_AddGeometryDirectly(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_AddGeometryDirectly( self, other );
  }
static OGRErr OGRGeometryShadow_AddGeometry(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_AddGeometry( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Clone(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_Clone(self);
  }
static OGRwkbGeometryType OGRGeometryShadow_GetGeometryType(OGRGeometryShadow *self){
    return (OGRwkbGeometryType) OGR_G_GetGeometryType(self);
  }
static char const *OGRGeometryShadow_GetGeometryName(OGRGeometryShadow *self){
    return (const char *) OGR_G_GetGeometryName(self);
  }
static double OGRGeometryShadow_GetArea(OGRGeometryShadow *self){
    return OGR_G_GetArea(self);
  }
static int OGRGeometryShadow_GetPointCount(OGRGeometryShadow *self){
    return OGR_G_GetPointCount(self);
  }
static double OGRGeometryShadow_GetX(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetX(self, point);
  }
static double OGRGeometryShadow_GetY(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetY(self, point);
  }
static double OGRGeometryShadow_GetZ(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetZ(self, point);
  }
static int OGRGeometryShadow_GetGeometryCount(OGRGeometryShadow *self){
    return OGR_G_GetGeometryCount(self);
  }
static void OGRGeometryShadow_SetPoint(OGRGeometryShadow *self,int point,double x,double y,double z=0){
    OGR_G_SetPoint(self, point, x, y, z);
  }
static OGRGeometryShadow *OGRGeometryShadow_GetGeometryRef(OGRGeometryShadow *self,int geom){
    return (OGRGeometryShadow*) OGR_G_GetGeometryRef(self, geom);
  }
static OGRGeometryShadow *OGRGeometryShadow_GetBoundary(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_GetBoundary(self);
  }
static OGRGeometryShadow *OGRGeometryShadow_ConvexHull(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_ConvexHull(self);
  }
static OGRGeometryShadow *OGRGeometryShadow_Buffer(OGRGeometryShadow *self,double distance,int quadsecs=30){
    return (OGRGeometryShadow*) OGR_G_Buffer( self, distance, quadsecs );
  }
static OGRGeometryShadow *OGRGeometryShadow_Intersection(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Intersection( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Union(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Union( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Difference(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Difference( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_SymmetricDifference(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_SymmetricDifference( self, other );
  }
static double OGRGeometryShadow_Distance(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Distance(self, other);
  }
static void OGRGeometryShadow_Empty(OGRGeometryShadow *self){
    OGR_G_Empty(self);
  }
static bool OGRGeometryShadow_Intersect(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Intersect(self, other);
  }
static bool OGRGeometryShadow_Equal(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Equal(self, other);
  }
static bool OGRGeometryShadow_Disjoint(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Disjoint(self, other);
  }
static bool OGRGeometryShadow_Touches(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Touches(self, other);
  }
static bool OGRGeometryShadow_Crosses(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Crosses(self, other);
  }
static bool OGRGeometryShadow_Within(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Within(self, other);
  }
static bool OGRGeometryShadow_Contains(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Contains(self, other);
  }
static bool OGRGeometryShadow_Overlaps(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Overlaps(self, other);
  }
static OGRErr OGRGeometryShadow_TransformTo(OGRGeometryShadow *self,OSRSpatialReferenceShadow *reference){
    return OGR_G_TransformTo(self, reference);
  }
static OGRErr OGRGeometryShadow_Transform(OGRGeometryShadow *self,OSRCoordinateTransformationShadow *trans){
    return OGR_G_Transform(self, trans);
  }
static OSRSpatialReferenceShadow *OGRGeometryShadow_GetSpatialReference(OGRGeometryShadow *self){
    return (OSRSpatialReferenceShadow*)OGR_G_GetSpatialReference(self);
  }
static void OGRGeometryShadow_AssignSpatialReference(OGRGeometryShadow *self,OSRSpatialReferenceShadow *reference){
    OGR_G_AssignSpatialReference(self, reference);
  }
static void OGRGeometryShadow_CloseRings(OGRGeometryShadow *self){
    OGR_G_CloseRings(self);
  }
static void OGRGeometryShadow_FlattenTo2D(OGRGeometryShadow *self){
    OGR_G_FlattenTo2D(self);
  }
static void OGRGeometryShadow_GetEnvelope(OGRGeometryShadow *self,double argout[4]){
    OGR_G_GetEnvelope(self, (OGREnvelope*)argout);
  }
static OGRGeometryShadow *OGRGeometryShadow_Centroid(OGRGeometryShadow *self){
    OGRGeometryShadow *pt = new_OGRGeometryShadow( wkbPoint );
    OGRErr rcode = OGR_G_Centroid( self, pt );
    return pt;
  }
static int OGRGeometryShadow_WkbSize(OGRGeometryShadow *self){
    return OGR_G_WkbSize(self);
  }
static int OGRGeometryShadow_GetCoordinateDimension(OGRGeometryShadow *self){
    return OGR_G_GetCoordinateDimension(self);
  }
static int OGRGeometryShadow_GetDimension(OGRGeometryShadow *self){
    return OGR_G_GetDimension(self);
  }

char const *OGRDriverShadow_get_name( OGRDriverShadow *h ) {
  return OGR_Dr_GetName( h );
}

char const *OGRDataSourceShadow_get_name( OGRDataSourceShadow *h ) {
  return OGR_DS_GetName( h );
}

char const *OGRDriverShadow_name_get( OGRDriverShadow *h ) {
  return OGR_Dr_GetName( h );
}

char const *OGRDataSourceShadow_name_get( OGRDataSourceShadow *h ) {
  return OGR_DS_GetName( h );
}


  OGRDataSourceShadow* GetOpenDS(int ds_number) {
    OGRDataSourceShadow* layer = (OGRDataSourceShadow*) OGRGetOpenDS(ds_number);
    return layer;
  }


  OGRDataSourceShadow* Open( const char *filename, int update =0 ) {
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*)OGROpen(filename,update,NULL);
    return ds;
  }


  OGRDataSourceShadow* OpenShared( const char *filename, int update =0 ) {
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*)OGROpenShared(filename,update,NULL);
    return ds;
  }


OGRDriverShadow* GetDriverByName( char const *name ) {
  return (OGRDriverShadow*) OGRGetDriverByName( name );
}

OGRDriverShadow* GetDriver(int driver_number) {
  return (OGRDriverShadow*) OGRGetDriver(driver_number);
}

static VALUE
_wrap_use_exceptions(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    UseExceptions();
    
    return Qnil;
}


static VALUE
_wrap_dont_use_exceptions(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    DontUseExceptions();
    
    return Qnil;
}


swig_class cDriver;

static VALUE
_wrap_Driver_name_get(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRDriverShadow_name_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Driver_create_data_source(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char **arg3 = (char **) 0 ;
    OGRDataSourceShadow *result;
    char *kwnames[] = {
        "self","name","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    if (argc > 1) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[1], T_ARRAY);
            
            int size = RARRAY(argv[1])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[1], i);
                char *pszItem = StringValuePtr(item);
                arg3 = CSLAddString( arg3, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)OGRDriverShadow_CreateDataSource(arg1,(char const *)arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,1);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg3 );
    }
    return vresult;
}


static VALUE
_wrap_Driver_copy_data_source(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    OGRDataSourceShadow *arg2 = (OGRDataSourceShadow *) 0 ;
    char *arg3 = (char *) 0 ;
    char **arg4 = (char **) 0 ;
    OGRDataSourceShadow *result;
    char *kwnames[] = {
        "self","copy_ds","name","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg3 = StringValuePtr(argv[1]);
    if (argc > 2) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[2], T_ARRAY);
            
            int size = RARRAY(argv[2])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[2], i);
                char *pszItem = StringValuePtr(item);
                arg4 = CSLAddString( arg4, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)OGRDriverShadow_CopyDataSource(arg1,arg2,(char const *)arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,1);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg4 );
    }
    return vresult;
}


static VALUE
_wrap_Driver_open(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    OGRDataSourceShadow *result;
    char *kwnames[] = {
        "self","name","update", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    if (argc > 1) {
        arg3 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)OGRDriverShadow_Open(arg1,(char const *)arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,1);
    return vresult;
}


static VALUE
_wrap_Driver_delete_data_source(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (int)OGRDriverShadow_DeleteDataSource(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Driver_test_capability(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (bool)OGRDriverShadow_TestCapability(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Driver_get_name(int argc, VALUE *argv, VALUE self) {
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDriverShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRDriverShadow_GetName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


swig_class cDataSource;

static VALUE
_wrap_DataSource_name_get(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRDataSourceShadow_name_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static void delete_OGRDataSourceShadow(OGRDataSourceShadow *self){
    OGRReleaseDataSource(self);
  }
static void
free_OGRDataSourceShadow(OGRDataSourceShadow *arg1) {
    delete_OGRDataSourceShadow(arg1);
}

static VALUE
_wrap_DataSource_get_ref_count(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRDataSourceShadow_GetRefCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DataSource_get_summary_ref_count(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRDataSourceShadow_GetSummaryRefCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DataSource_get_layer_count(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRDataSourceShadow_GetLayerCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DataSource_get_name(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRDataSourceShadow_GetName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_DataSource_delete_layer(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRDataSourceShadow_DeleteLayer(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_DataSource_create_layer(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OSRSpatialReferenceShadow *arg3 = (OSRSpatialReferenceShadow *) NULL ;
    OGRwkbGeometryType arg4 = (OGRwkbGeometryType) wkbUnknown ;
    char **arg5 = (char **) 0 ;
    OGRLayerShadow *result;
    char *kwnames[] = {
        "self","name","reference","geom_type","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_OSRSpatialReferenceShadow, 0);
    }
    if (argc > 2) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg4 = (OGRwkbGeometryType) NUM2INT(argv[2]);
        }
    }
    if (argc > 3) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[3], T_ARRAY);
            
            int size = RARRAY(argv[3])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[3], i);
                char *pszItem = StringValuePtr(item);
                arg5 = CSLAddString( arg5, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (OGRLayerShadow *)OGRDataSourceShadow_CreateLayer(arg1,(char const *)arg2,arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRLayerShadow,0);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg5 );
    }
    return vresult;
}


static VALUE
_wrap_DataSource_copy_layer(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    OGRLayerShadow *arg2 = (OGRLayerShadow *) 0 ;
    char *arg3 = (char *) 0 ;
    char **arg4 = (char **) 0 ;
    OGRLayerShadow *result;
    char *kwnames[] = {
        "self","src_layer","new_name","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRLayerShadow, 0);
    arg3 = StringValuePtr(argv[1]);
    if (argc > 2) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[2], T_ARRAY);
            
            int size = RARRAY(argv[2])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[2], i);
                char *pszItem = StringValuePtr(item);
                arg4 = CSLAddString( arg4, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (OGRLayerShadow *)OGRDataSourceShadow_CopyLayer(arg1,arg2,(char const *)arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRLayerShadow,0);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg4 );
    }
    return vresult;
}


static VALUE
_wrap_DataSource_test_capability(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (bool)OGRDataSourceShadow_TestCapability(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DataSource_execute_sql(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRGeometryShadow *arg3 = (OGRGeometryShadow *) NULL ;
    char *arg4 = (char *) "" ;
    OGRLayerShadow *result;
    char *kwnames[] = {
        "self","statement","geom","dialect", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_OGRGeometryShadow, 0);
    }
    if (argc > 2) {
        arg4 = StringValuePtr(argv[2]);
    }
    {
        CPLErrorReset();
        result = (OGRLayerShadow *)OGRDataSourceShadow_ExecuteSQL(arg1,(char const *)arg2,arg3,(char const *)arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRLayerShadow,1);
    return vresult;
}


static VALUE
_wrap_DataSource_release_result_set(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    OGRLayerShadow *arg2 = (OGRLayerShadow *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRLayerShadow, SWIG_POINTER_DISOWN);
    {
        CPLErrorReset();
        OGRDataSourceShadow_ReleaseResultSet(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_DataSource_get_layer(int argc, VALUE *argv, VALUE self) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    VALUE arg2 ;
    OGRLayerShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRDataSourceShadow, 0);
    arg2 = argv[0];
    {
        CPLErrorReset();
        result = (OGRLayerShadow *)OGRDataSourceShadow_GetLayer(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRLayerShadow,0);
    return vresult;
}


swig_class cLayer;

static VALUE
_wrap_Layer_get_ref_count(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRLayerShadow_GetRefCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Layer_set_spatial_filter(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        OGRLayerShadow_SetSpatialFilter(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Layer_set_spatial_filter_rect(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    arg5 = (double) NUM2DBL(argv[3]);
    {
        CPLErrorReset();
        OGRLayerShadow_SetSpatialFilterRect(arg1,arg2,arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Layer_get_spatial_filter(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRLayerShadow_GetSpatialFilter(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,0);
    return vresult;
}


static VALUE
_wrap_Layer_set_attribute_filter(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_SetAttributeFilter(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_reset_reading(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        OGRLayerShadow_ResetReading(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Layer_get_name(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRLayerShadow_GetName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Layer_get_feature(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRFeatureShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = NUM2LONG(argv[0]);
    {
        CPLErrorReset();
        result = (OGRFeatureShadow *)OGRLayerShadow_GetFeature(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFeatureShadow,1);
    return vresult;
}


static VALUE
_wrap_Layer_get_next_feature(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRFeatureShadow *)OGRLayerShadow_GetNextFeature(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFeatureShadow,1);
    return vresult;
}


static VALUE
_wrap_Layer_set_next_by_index(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = NUM2LONG(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_SetNextByIndex(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_set_feature(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_SetFeature(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_create_feature(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_CreateFeature(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_delete_feature(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = NUM2LONG(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_DeleteFeature(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_sync_to_disk(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_SyncToDisk(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_get_layer_defn(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureDefnShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRFeatureDefnShadow *)OGRLayerShadow_GetLayerDefn(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFeatureDefnShadow,0);
    return vresult;
}


static VALUE
_wrap_Layer_get_feature_count(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    int arg2 = (int) 1 ;
    int result;
    char *kwnames[] = {
        "self","force", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    if (argc > 0) {
        arg2 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (int)OGRLayerShadow_GetFeatureCount(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Layer_get_extent(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    double *arg2 ;
    int arg3 = (int) 1 ;
    double argout2[4] ;
    char *kwnames[] = {
        "self","force", NULL 
    };
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    if (argc > 0) {
        arg3 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        OGRLayerShadow_GetExtent(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double argout[ANY]) */
        vresult = rb_ary_new();
        
        for(int i=0; i<4; i++)
        {
            VALUE value = rb_float_new(arg2[i]);
            rb_ary_push(vresult, value);
        }
    }
    return vresult;
}


static VALUE
_wrap_Layer_test_capability(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (bool)OGRLayerShadow_TestCapability(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Layer_create_field(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFieldDefnShadow *arg2 = (OGRFieldDefnShadow *) 0 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    char *kwnames[] = {
        "self","field_def","approx_ok", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    if (argc > 1) {
        arg3 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_CreateField(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_start_transaction(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_StartTransaction(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_commit_transaction(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_CommitTransaction(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_rollback_transaction(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRLayerShadow_RollbackTransaction(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Layer_get_spatial_ref(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = (OSRSpatialReferenceShadow *)OGRLayerShadow_GetSpatialRef(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OSRSpatialReferenceShadow,0);
    return vresult;
}


static VALUE
_wrap_Layer_get_feature_read(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    GIntBig result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        result = OGRLayerShadow_GetFeatureRead(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        GIntBig * resultptr;
        resultptr = new GIntBig((GIntBig &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_GIntBig, 1);
    }
    return vresult;
}


static VALUE
_wrap_Layer_each(int argc, VALUE *argv, VALUE self) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRLayerShadow, 0);
    {
        CPLErrorReset();
        OGRLayerShadow_each(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


swig_class cFeature;

static void delete_OGRFeatureShadow(OGRFeatureShadow *self){
    OGR_F_Destroy(self);
  }
static void
free_OGRFeatureShadow(OGRFeatureShadow *arg1) {
    delete_OGRFeatureShadow(arg1);
}

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Feature_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Feature_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_OGRFeatureShadow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Feature(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRFeatureShadow *result;
    char *kwnames[] = {
        "feature_def", NULL 
    };
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    }
    {
        CPLErrorReset();
        result = (OGRFeatureShadow *)new_OGRFeatureShadow(arg1);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static VALUE
_wrap_Feature_get_defn_ref(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureDefnShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (OGRFeatureDefnShadow *)OGRFeatureShadow_GetDefnRef(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFeatureDefnShadow,0);
    return vresult;
}


static VALUE
_wrap_Feature_set_geometry(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRFeatureShadow_SetGeometry(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Feature_set_geometry_directly(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, SWIG_POINTER_DISOWN);
    {
        CPLErrorReset();
        result = (OGRErr)OGRFeatureShadow_SetGeometryDirectly(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Feature_get_geometry_ref(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRFeatureShadow_GetGeometryRef(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,0);
    return vresult;
}


static VALUE
_wrap_Feature_clone(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (OGRFeatureShadow *)OGRFeatureShadow_Clone(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFeatureShadow,1);
    return vresult;
}


static VALUE
_wrap_Feature_equal(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRFeatureShadow_Equal(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Feature_get_field_count(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFeatureShadow_GetFieldCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_defn_ref__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRFieldDefnShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRFieldDefnShadow *)OGRFeatureShadow_GetFieldDefnRef__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFieldDefnShadow,0);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_defn_ref__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRFieldDefnShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (OGRFieldDefnShadow *)OGRFeatureShadow_GetFieldDefnRef__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFieldDefnShadow,0);
    return vresult;
}


static VALUE _wrap_Feature_get_field_defn_ref(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_defn_ref__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_defn_ref__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_get_field_defn_ref'");
    return Qnil;
}


static VALUE
_wrap_Feature_get_field_as_string__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (char *)OGRFeatureShadow_GetFieldAsString__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_as_string__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (char *)OGRFeatureShadow_GetFieldAsString__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE _wrap_Feature_get_field_as_string(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_string__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_string__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_get_field_as_string'");
    return Qnil;
}


static VALUE
_wrap_Feature_get_field_as_integer__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (int)OGRFeatureShadow_GetFieldAsInteger__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_as_integer__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (int)OGRFeatureShadow_GetFieldAsInteger__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE _wrap_Feature_get_field_as_integer(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_integer__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_integer__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_get_field_as_integer'");
    return Qnil;
}


static VALUE
_wrap_Feature_get_field_as_double__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (double)OGRFeatureShadow_GetFieldAsDouble__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_as_double__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (double)OGRFeatureShadow_GetFieldAsDouble__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_Feature_get_field_as_double(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_double__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_as_double__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_get_field_as_double'");
    return Qnil;
}


static VALUE
_wrap_Feature_is_field_set__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (bool)OGRFeatureShadow_IsFieldSet__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Feature_is_field_set__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (bool)OGRFeatureShadow_IsFieldSet__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE _wrap_Feature_is_field_set(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_is_field_set__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_is_field_set__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_is_field_set'");
    return Qnil;
}


static VALUE
_wrap_Feature_get_field_index(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (int)OGRFeatureShadow_GetFieldIndex(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_fid(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFeatureShadow_GetFID(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Feature_set_fid(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRFeatureShadow_SetFID(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Feature_dump_readable(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        OGRFeatureShadow_DumpReadable(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Feature_unset_field__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        OGRFeatureShadow_UnsetField__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Feature_unset_field__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        OGRFeatureShadow_UnsetField__SWIG_1(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE _wrap_Feature_unset_field(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_unset_field__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_unset_field__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_unset_field'");
    return Qnil;
}


static VALUE
_wrap_Feature_set_field__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    arg3 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        OGRFeatureShadow_SetField__SWIG_0(arg1,arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Feature_set_field__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        OGRFeatureShadow_SetField__SWIG_1(arg1,(char const *)arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE _wrap_Feature_set_field(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Feature_set_field__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Feature_set_field__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_set_field'");
    return Qnil;
}


static VALUE
_wrap_Feature_set_from(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    char *kwnames[] = {
        "self","other","forgiving", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFeatureShadow, 0);
    if (argc > 1) {
        arg3 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRErr)OGRFeatureShadow_SetFrom(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Feature_get_style_string(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRFeatureShadow_GetStyleString(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Feature_set_style_string(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        OGRFeatureShadow_SetStyleString(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Feature_get_field_type__SWIG_0(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRFieldType result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRFieldType)OGRFeatureShadow_GetFieldType__SWIG_0(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Feature_get_field_type__SWIG_1(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    OGRFieldType result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        result = (OGRFieldType)OGRFeatureShadow_GetFieldType__SWIG_1(arg1,(char const *)arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE _wrap_Feature_get_field_type(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Feature_get_field_type__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_OGRFeatureShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Feature_get_field_type__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Feature_get_field_type'");
    return Qnil;
}


static VALUE
_wrap_Feature_get_field(int argc, VALUE *argv, VALUE self) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    VALUE arg2 ;
    VALUE result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureShadow, 0);
    arg2 = argv[0];
    {
        CPLErrorReset();
        result = (VALUE)OGRFeatureShadow_GetField(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result;
    return vresult;
}


swig_class cFeatureDefn;

static void delete_OGRFeatureDefnShadow(OGRFeatureDefnShadow *self){
    OGR_FD_Destroy(self);
  }
static void
free_OGRFeatureDefnShadow(OGRFeatureDefnShadow *arg1) {
    delete_OGRFeatureDefnShadow(arg1);
}

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FeatureDefn_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FeatureDefn_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_OGRFeatureDefnShadow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FeatureDefn(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) NULL ;
    OGRFeatureDefnShadow *result;
    char *kwnames[] = {
        "name", NULL 
    };
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = StringValuePtr(argv[0]);
    }
    {
        CPLErrorReset();
        result = (OGRFeatureDefnShadow *)new_OGRFeatureDefnShadow((char const *)arg1);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static VALUE
_wrap_FeatureDefn_get_name(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRFeatureDefnShadow_GetName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_FeatureDefn_get_field_count(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFeatureDefnShadow_GetFieldCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FeatureDefn_get_field_defn(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int arg2 ;
    OGRFieldDefnShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRFieldDefnShadow *)OGRFeatureDefnShadow_GetFieldDefn(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRFieldDefnShadow,0);
    return vresult;
}


static VALUE
_wrap_FeatureDefn_get_field_index(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (int)OGRFeatureDefnShadow_GetFieldIndex(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FeatureDefn_add_field_defn(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRFieldDefnShadow *arg2 = (OGRFieldDefnShadow *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        OGRFeatureDefnShadow_AddFieldDefn(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FeatureDefn_get_geom_type(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRwkbGeometryType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    {
        CPLErrorReset();
        result = (OGRwkbGeometryType)OGRFeatureDefnShadow_GetGeomType(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FeatureDefn_set_geom_type(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRwkbGeometryType arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    {
        /* %typemap(ruby,in) CPLErr */
        arg2 = (OGRwkbGeometryType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        OGRFeatureDefnShadow_SetGeomType(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FeatureDefn_get_reference_count(int argc, VALUE *argv, VALUE self) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFeatureDefnShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFeatureDefnShadow_GetReferenceCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


swig_class cFieldDefn;

static void delete_OGRFieldDefnShadow(OGRFieldDefnShadow *self){
    OGR_Fld_Destroy(self);
  }
static void
free_OGRFieldDefnShadow(OGRFieldDefnShadow *arg1) {
    delete_OGRFieldDefnShadow(arg1);
}

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FieldDefn_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FieldDefn_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_OGRFieldDefnShadow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FieldDefn(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) "unnamed" ;
    OGRFieldType arg2 = (OGRFieldType) OFTString ;
    OGRFieldDefnShadow *result;
    char *kwnames[] = {
        "name","field_type", NULL 
    };
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = StringValuePtr(argv[0]);
    }
    if (argc > 1) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg2 = (OGRFieldType) NUM2INT(argv[1]);
        }
    }
    {
        CPLErrorReset();
        result = (OGRFieldDefnShadow *)new_OGRFieldDefnShadow((char const *)arg1,arg2);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static VALUE
_wrap_FieldDefn_get_name(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRFieldDefnShadow_GetName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_get_name_ref(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRFieldDefnShadow_GetNameRef(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_set_name(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        OGRFieldDefnShadow_SetName(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FieldDefn_get_type(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (OGRFieldType)OGRFieldDefnShadow_GetType(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_set_type(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        /* %typemap(ruby,in) CPLErr */
        arg2 = (OGRFieldType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        OGRFieldDefnShadow_SetType(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FieldDefn_get_justify(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRJustification result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (OGRJustification)OGRFieldDefnShadow_GetJustify(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_set_justify(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRJustification arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        /* %typemap(ruby,in) CPLErr */
        arg2 = (OGRJustification) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        OGRFieldDefnShadow_SetJustify(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FieldDefn_get_width(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFieldDefnShadow_GetWidth(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_set_width(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        OGRFieldDefnShadow_SetWidth(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FieldDefn_get_precision(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRFieldDefnShadow_GetPrecision(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_FieldDefn_set_precision(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        OGRFieldDefnShadow_SetPrecision(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_FieldDefn_get_field_type_name(int argc, VALUE *argv, VALUE self) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType arg2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRFieldDefnShadow, 0);
    {
        /* %typemap(ruby,in) CPLErr */
        arg2 = (OGRFieldType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char *)OGRFieldDefnShadow_GetFieldTypeName(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_create_geometry_from_wkb(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    char *arg2 = (char *) 0 ;
    OSRSpatialReferenceShadow *arg3 = (OSRSpatialReferenceShadow *) NULL ;
    OGRGeometryShadow *result;
    char *kwnames[] = {
        "len","reference", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        arg1 = (int) StringValueLen(argv[0]);
        arg2 = (char *) StringValuePtr(argv[0]);
    }
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_OSRSpatialReferenceShadow, 0);
    }
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)CreateGeometryFromWkb(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_create_geometry_from_wkt(int argc, VALUE *argv, VALUE self) {
    char **arg1 = (char **) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) NULL ;
    OGRGeometryShadow *result;
    char *val1 = 0 ;
    char *kwnames[] = {
        "val","reference", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) char ** ( char *val1=0 ) */
        
        val1 = StringValuePtr(argv[0]);
        arg1 = &val1;
    }
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, 0);
    }
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)CreateGeometryFromWkt(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_create_geometry_from_gml(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)CreateGeometryFromGML((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


swig_class cGeometry;

static void delete_OGRGeometryShadow(OGRGeometryShadow *self){
    OGR_G_DestroyGeometry( self );
  }
static void
free_OGRGeometryShadow(OGRGeometryShadow *arg1) {
    delete_OGRGeometryShadow(arg1);
}

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Geometry_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Geometry_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_OGRGeometryShadow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Geometry(int argc, VALUE *argv, VALUE self) {
    OGRwkbGeometryType arg1 = (OGRwkbGeometryType) wkbUnknown ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    char *arg4 = (char *) 0 ;
    char *arg5 = (char *) 0 ;
    OGRGeometryShadow *result;
    char *kwnames[] = {
        "type","wkt","wkb","wkb_buf","gml", NULL 
    };
    
    if ((argc < 0) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg1 = (OGRwkbGeometryType) NUM2INT(argv[0]);
        }
    }
    if (argc > 1) {
        arg2 = StringValuePtr(argv[1]);
    }
    if (argc > 2) {
        arg3 = NUM2INT(argv[2]);
    }
    if (argc > 3) {
        arg4 = StringValuePtr(argv[3]);
    }
    if (argc > 4) {
        arg5 = StringValuePtr(argv[4]);
    }
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)new_OGRGeometryShadow(arg1,arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static VALUE
_wrap_Geometry_export_to_wkt(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRGeometryShadow_ExportToWkt(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Geometry_export_to_wkb(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int *arg2 = (int *) 0 ;
    char **arg3 = (char **) 0 ;
    OGRwkbByteOrder arg4 = (OGRwkbByteOrder) wkbXDR ;
    OGRErr result;
    int nLen2 = 0 ;
    char *pBuf2 = 0 ;
    char *kwnames[] = {
        "self","byte_order", NULL 
    };
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (int *nLen2, char **pBuf2 ) ( int nLen2 = 0, char *pBuf2 = 0 ) */
        arg2 = &nLen2;
        arg3 = &pBuf2;
    }
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    if (argc > 0) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg4 = (OGRwkbByteOrder) NUM2INT(argv[0]);
        }
    }
    {
        CPLErrorReset();
        result = (OGRErr)OGRGeometryShadow_ExportToWkb(arg1,arg2,arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    {
        /* %typemap(ruby,argout) (int *nLen, char **pBuf ) */
        vresult = rb_str_new(*arg3, *arg2);
    }
    {
        /* %typemap(ruby,freearg) (int *nLen, char **pBuf ) */
        if( *arg3 ) {
            free( *arg3 );
        }
    }
    return vresult;
}


static VALUE
_wrap_Geometry_export_to_gml(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRGeometryShadow_ExportToGML(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Geometry_add_point(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 = (double) 0 ;
    char *kwnames[] = {
        "self","x","y","z", NULL 
    };
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = (double) NUM2DBL(argv[2]);
    }
    {
        CPLErrorReset();
        OGRGeometryShadow_AddPoint(arg1,arg2,arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_add_geometry_directly(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, SWIG_POINTER_DISOWN);
    {
        CPLErrorReset();
        result = (OGRErr)OGRGeometryShadow_AddGeometryDirectly(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Geometry_add_geometry(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRGeometryShadow_AddGeometry(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Geometry_clone(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Clone(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_get_geometry_type(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRwkbGeometryType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRwkbGeometryType)OGRGeometryShadow_GetGeometryType(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_geometry_name(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (char *)OGRGeometryShadow_GetGeometryName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_area(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (double)OGRGeometryShadow_GetArea(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_point_count(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRGeometryShadow_GetPointCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_x(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    char *kwnames[] = {
        "self","point", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    if (argc > 0) {
        arg2 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (double)OGRGeometryShadow_GetX(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_y(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    char *kwnames[] = {
        "self","point", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    if (argc > 0) {
        arg2 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (double)OGRGeometryShadow_GetY(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_z(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    char *kwnames[] = {
        "self","point", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    if (argc > 0) {
        arg2 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (double)OGRGeometryShadow_GetZ(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_geometry_count(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRGeometryShadow_GetGeometryCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Geometry_set_point(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0 ;
    char *kwnames[] = {
        "self","point","x","y","z", NULL 
    };
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    arg4 = (double) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = (double) NUM2DBL(argv[3]);
    }
    {
        CPLErrorReset();
        OGRGeometryShadow_SetPoint(arg1,arg2,arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_get_geometry_ref(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_GetGeometryRef(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,0);
    return vresult;
}


static VALUE
_wrap_Geometry_get_boundary(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_GetBoundary(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_convex_hull(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_ConvexHull(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_buffer(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double arg2 ;
    int arg3 = (int) 30 ;
    OGRGeometryShadow *result;
    char *kwnames[] = {
        "self","distance","quadsecs", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Buffer(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_intersection(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Intersection(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_union_(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Union(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_difference(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Difference(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_symmetric_difference(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_SymmetricDifference(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_distance(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (double)OGRGeometryShadow_Distance(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Geometry_empty(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        OGRGeometryShadow_Empty(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_intersect(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Intersect(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_equal(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Equal(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_disjoint(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Disjoint(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_touches(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Touches(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_crosses(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Crosses(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_within(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Within(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_contains(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Contains(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_overlaps(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (bool)OGRGeometryShadow_Overlaps(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Geometry_transform_to(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRGeometryShadow_TransformTo(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Geometry_transform(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRCoordinateTransformationShadow *arg2 = (OSRCoordinateTransformationShadow *) 0 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OSRCoordinateTransformationShadow, 0);
    {
        CPLErrorReset();
        result = (OGRErr)OGRGeometryShadow_Transform(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_Geometry_get_spatial_reference(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OSRSpatialReferenceShadow *)OGRGeometryShadow_GetSpatialReference(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OSRSpatialReferenceShadow,0);
    return vresult;
}


static VALUE
_wrap_Geometry_assign_spatial_reference(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_OSRSpatialReferenceShadow, 0);
    {
        CPLErrorReset();
        OGRGeometryShadow_AssignSpatialReference(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_close_rings(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        OGRGeometryShadow_CloseRings(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_flatten_to2d(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        OGRGeometryShadow_FlattenTo2D(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Geometry_get_envelope(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double *arg2 ;
    double argout2[4] ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        OGRGeometryShadow_GetEnvelope(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double argout[ANY]) */
        vresult = rb_ary_new();
        
        for(int i=0; i<4; i++)
        {
            VALUE value = rb_float_new(arg2[i]);
            rb_ary_push(vresult, value);
        }
    }
    return vresult;
}


static VALUE
_wrap_Geometry_centroid(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (OGRGeometryShadow *)OGRGeometryShadow_Centroid(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRGeometryShadow,1);
    return vresult;
}


static VALUE
_wrap_Geometry_wkb_size(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRGeometryShadow_WkbSize(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_coordinate_dimension(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRGeometryShadow_GetCoordinateDimension(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Geometry_get_dimension(int argc, VALUE *argv, VALUE self) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_OGRGeometryShadow, 0);
    {
        CPLErrorReset();
        result = (int)OGRGeometryShadow_GetDimension(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_get_driver_count(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)OGRGetDriverCount();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_get_open_dscount(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)OGRGetOpenDSCount();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_set_generate_db2_v72_byte_order(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    OGRErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRErr)OGRSetGenerate_DB2_V72_BYTE_ORDER(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, out) OGRErr */
        
        /* If an OGRErr occurred then result will be non-zero number.
             In that case raise an exception.  Otherwise return true to
        	  indicate success. Note if exceptions are turned on this
        	  code is not relevant because it won't be reached. */
        if (result != 0) {
            rb_raise(rb_eRuntimeError, OGRErrMessages(result));
        }
        
        vresult = Qtrue;
    }
    return vresult;
}


static VALUE
_wrap_register_all(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        OGRRegisterAll();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_get_open_ds(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    OGRDataSourceShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)GetOpenDS(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,0);
    return vresult;
}


static VALUE
_wrap_open(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    int arg2 = (int) 0 ;
    OGRDataSourceShadow *result;
    char *kwnames[] = {
        "filename","update", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)Open((char const *)arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,1);
    return vresult;
}


static VALUE
_wrap_open_shared(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    int arg2 = (int) 0 ;
    OGRDataSourceShadow *result;
    char *kwnames[] = {
        "filename","update", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = (OGRDataSourceShadow *)OpenShared((char const *)arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDataSourceShadow,1);
    return vresult;
}


static VALUE
_wrap_get_driver_by_name(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    OGRDriverShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (OGRDriverShadow *)GetDriverByName((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDriverShadow,0);
    return vresult;
}


static VALUE
_wrap_get_driver(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    OGRDriverShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (OGRDriverShadow *)GetDriver(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_OGRDriverShadow,0);
    return vresult;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_GIntBig = {"_p_GIntBig", "GIntBig *", 0, 0, 0};
static swig_type_info _swigt__p_OGRDataSourceShadow = {"_p_OGRDataSourceShadow", "OGRDataSourceShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRDriverShadow = {"_p_OGRDriverShadow", "OGRDriverShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRFeatureDefnShadow = {"_p_OGRFeatureDefnShadow", "OGRFeatureDefnShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRFeatureShadow = {"_p_OGRFeatureShadow", "OGRFeatureShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRFieldDefnShadow = {"_p_OGRFieldDefnShadow", "OGRFieldDefnShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRGeometryShadow = {"_p_OGRGeometryShadow", "OGRGeometryShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OGRLayerShadow = {"_p_OGRLayerShadow", "OGRLayerShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OSRCoordinateTransformationShadow = {"_p_OSRCoordinateTransformationShadow", "OSRCoordinateTransformationShadow *", 0, 0, 0};
static swig_type_info _swigt__p_OSRSpatialReferenceShadow = {"_p_OSRSpatialReferenceShadow", "OSRSpatialReferenceShadow *", 0, 0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *", 0, 0, 0};
static swig_type_info _swigt__p_p_char = {"_p_p_char", "char **", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_long = {"_p_unsigned_long", "unsigned long *|VALUE *", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_GIntBig,
  &_swigt__p_OGRDataSourceShadow,
  &_swigt__p_OGRDriverShadow,
  &_swigt__p_OGRFeatureDefnShadow,
  &_swigt__p_OGRFeatureShadow,
  &_swigt__p_OGRFieldDefnShadow,
  &_swigt__p_OGRGeometryShadow,
  &_swigt__p_OGRLayerShadow,
  &_swigt__p_OSRCoordinateTransformationShadow,
  &_swigt__p_OSRSpatialReferenceShadow,
  &_swigt__p_double,
  &_swigt__p_int,
  &_swigt__p_p_char,
  &_swigt__p_unsigned_long,
};

static swig_cast_info _swigc__p_GIntBig[] = {  {&_swigt__p_GIntBig, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRDataSourceShadow[] = {  {&_swigt__p_OGRDataSourceShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRDriverShadow[] = {  {&_swigt__p_OGRDriverShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRFeatureDefnShadow[] = {  {&_swigt__p_OGRFeatureDefnShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRFeatureShadow[] = {  {&_swigt__p_OGRFeatureShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRFieldDefnShadow[] = {  {&_swigt__p_OGRFieldDefnShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRGeometryShadow[] = {  {&_swigt__p_OGRGeometryShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OGRLayerShadow[] = {  {&_swigt__p_OGRLayerShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OSRCoordinateTransformationShadow[] = {  {&_swigt__p_OSRCoordinateTransformationShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_OSRSpatialReferenceShadow[] = {  {&_swigt__p_OSRSpatialReferenceShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_char[] = {  {&_swigt__p_p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_long[] = {  {&_swigt__p_unsigned_long, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_GIntBig,
  _swigc__p_OGRDataSourceShadow,
  _swigc__p_OGRDriverShadow,
  _swigc__p_OGRFeatureDefnShadow,
  _swigc__p_OGRFeatureShadow,
  _swigc__p_OGRFieldDefnShadow,
  _swigc__p_OGRGeometryShadow,
  _swigc__p_OGRLayerShadow,
  _swigc__p_OSRCoordinateTransformationShadow,
  _swigc__p_OSRSpatialReferenceShadow,
  _swigc__p_double,
  _swigc__p_int,
  _swigc__p_p_char,
  _swigc__p_unsigned_long,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif

SWIGRUNTIME void
SWIG_InitializeModule(void *clientdata) {
  swig_type_info *type, *ret;
  swig_cast_info *cast;
  size_t i;
  swig_module_info *module_head;
  static int init_run = 0;

  clientdata = clientdata;

  if (init_run) return;
  init_run = 1;

  /* Initialize the swig_module */
  swig_module.type_initial = swig_type_initial;
  swig_module.cast_initial = swig_cast_initial;

  /* Try and load any already created modules */
  module_head = SWIG_GetModule(clientdata);
  if (module_head) {
    swig_module.next = module_head->next;
    module_head->next = &swig_module;
  } else {
    /* This is the first module loaded */
    swig_module.next = &swig_module;
    SWIG_SetModule(clientdata, &swig_module);
  }
		 
  /* Now work on filling in swig_module.types */
  for (i = 0; i < swig_module.size; ++i) {
    type = 0;

    /* if there is another module already loaded */
    if (swig_module.next != &swig_module) {
      type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
    }
    if (type) {
      /* Overwrite clientdata field */
      if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
    } else {
      type = swig_module.type_initial[i];
    }

    /* Insert casting types */
    cast = swig_module.cast_initial[i];
    while (cast->type) {
    
      /* Don't need to add information already in the list */
      ret = 0;
      if (swig_module.next != &swig_module) {
        ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
      }
      if (ret && type == swig_module.type_initial[i]) {
        cast->type = ret;
        ret = 0;
      }
      
      if (!ret) {
        if (type->cast) {
          type->cast->prev = cast;
          cast->next = type->cast;
        }
        type->cast = cast;
      }

      cast++;
    }

    /* Set entry in modules->types array equal to the type */
    swig_module.types[i] = type;
  }
  swig_module.types[i] = 0;
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientData(void) {
  size_t i;
  swig_cast_info *equiv;
  static int init_run = 0;

  if (init_run) return;
  init_run = 1;

  for (i = 0; i < swig_module.size; i++) {
    if (swig_module.types[i]->clientdata) {
      equiv = swig_module.types[i]->cast;
      while (equiv) {
        if (!equiv->converter) {
          if (equiv->type && !equiv->type->clientdata)
            SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
        }
        equiv = equiv->next;
      }
    }
  }
}

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT void Init_ogr(void) {
    size_t i;
    
    SWIG_InitRuntime();
    mOgr = rb_define_module("Gdal");
    mOgr = rb_define_module_under(mOgr, "Ogr");
    
    SWIG_InitializeModule(0);
    for (i = 0; i < swig_module.size; i++) {
        SWIG_define_class(swig_module.types[i]);
    }
    
    SWIG_RubyInitializeTrackings();
    rb_define_const(mOgr,"Wkb25Bit", INT2NUM(wkb25DBit));
    rb_define_const(mOgr,"WkbUnknown", INT2NUM(0));
    rb_define_const(mOgr,"WkbPoint", INT2NUM(1));
    rb_define_const(mOgr,"WkbLineString", INT2NUM(2));
    rb_define_const(mOgr,"WkbPolygon", INT2NUM(3));
    rb_define_const(mOgr,"WkbMultiPoint", INT2NUM(4));
    rb_define_const(mOgr,"WkbMultiLineString", INT2NUM(5));
    rb_define_const(mOgr,"WkbMultiPolygon", INT2NUM(6));
    rb_define_const(mOgr,"WkbGeometryCollection", INT2NUM(7));
    rb_define_const(mOgr,"WkbNone", INT2NUM(100));
    rb_define_const(mOgr,"WkbLinearRing", INT2NUM(101));
    rb_define_const(mOgr,"WkbPoint25D", INT2NUM(wkbPoint+wkb25DBit));
    rb_define_const(mOgr,"WkbLineString25D", INT2NUM(wkbLineString+wkb25DBit));
    rb_define_const(mOgr,"WkbPolygon25D", INT2NUM(wkbPolygon+wkb25DBit));
    rb_define_const(mOgr,"WkbMultiPoint25D", INT2NUM(wkbMultiPoint+wkb25DBit));
    rb_define_const(mOgr,"WkbMultiLineString25D", INT2NUM(wkbMultiLineString+wkb25DBit));
    rb_define_const(mOgr,"WkbMultiPolygon25D", INT2NUM(wkbMultiPolygon+wkb25DBit));
    rb_define_const(mOgr,"WkbGeometryCollection25D", INT2NUM(wkbGeometryCollection+wkb25DBit));
    rb_define_const(mOgr,"OFTInteger", INT2NUM(0));
    rb_define_const(mOgr,"OFTIntegerList", INT2NUM(1));
    rb_define_const(mOgr,"OFTReal", INT2NUM(2));
    rb_define_const(mOgr,"OFTRealList", INT2NUM(3));
    rb_define_const(mOgr,"OFTString", INT2NUM(4));
    rb_define_const(mOgr,"OFTStringList", INT2NUM(5));
    rb_define_const(mOgr,"OFTWideString", INT2NUM(6));
    rb_define_const(mOgr,"OFTWideStringList", INT2NUM(7));
    rb_define_const(mOgr,"OFTBinary", INT2NUM(8));
    rb_define_const(mOgr,"OJUndefined", INT2NUM(0));
    rb_define_const(mOgr,"OJLeft", INT2NUM(1));
    rb_define_const(mOgr,"OJRight", INT2NUM(2));
    rb_define_const(mOgr,"WkbXDR", INT2NUM(0));
    rb_define_const(mOgr,"WkbNDR", INT2NUM(1));
    rb_define_const(mOgr,"OLCRandomRead", rb_str_new2("RandomRead"));
    rb_define_const(mOgr,"OLCSequentialWrite", rb_str_new2("SequentialWrite"));
    rb_define_const(mOgr,"OLCRandomWrite", rb_str_new2("RandomWrite"));
    rb_define_const(mOgr,"OLCFastSpatialFilter", rb_str_new2("FastSpatialFilter"));
    rb_define_const(mOgr,"OLCFastFeatureCount", rb_str_new2("FastFeatureCount"));
    rb_define_const(mOgr,"OLCFastGetExtent", rb_str_new2("FastGetExtent"));
    rb_define_const(mOgr,"OLCCreateField", rb_str_new2("CreateField"));
    rb_define_const(mOgr,"OLCTransactions", rb_str_new2("Transactions"));
    rb_define_const(mOgr,"OLCDeleteFeature", rb_str_new2("DeleteFeature"));
    rb_define_const(mOgr,"OLCFastSetNextByIndex", rb_str_new2("FastSetNextByIndex"));
    rb_define_const(mOgr,"ODsCCreateLayer", rb_str_new2("CreateLayer"));
    rb_define_const(mOgr,"ODsCDeleteLayer", rb_str_new2("DeleteLayer"));
    rb_define_const(mOgr,"ODrCCreateDataSource", rb_str_new2("CreateDataSource"));
    rb_define_const(mOgr,"ODrCDeleteDataSource", rb_str_new2("DeleteDataSource"));
    rb_define_module_function(mOgr, "use_exceptions", VALUEFUNC(_wrap_use_exceptions), -1);
    rb_define_module_function(mOgr, "dont_use_exceptions", VALUEFUNC(_wrap_dont_use_exceptions), -1);
    
    
    if ( OGRGetDriverCount() == 0 ) {
        OGRRegisterAll();
    }
    
    /* Setup exception handling */
    UseExceptions();
    
    rb_require("gdal/osr");
    
    cDriver.klass = rb_define_class_under(mOgr, "Driver", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRDriverShadow, (void *) &cDriver);
    rb_undef_alloc_func(cDriver.klass);
    rb_define_method(cDriver.klass, "name", VALUEFUNC(_wrap_Driver_name_get), -1);
    rb_define_method(cDriver.klass, "create_data_source", VALUEFUNC(_wrap_Driver_create_data_source), -1);
    rb_define_method(cDriver.klass, "copy_data_source", VALUEFUNC(_wrap_Driver_copy_data_source), -1);
    rb_define_method(cDriver.klass, "open", VALUEFUNC(_wrap_Driver_open), -1);
    rb_define_method(cDriver.klass, "delete_data_source", VALUEFUNC(_wrap_Driver_delete_data_source), -1);
    rb_define_method(cDriver.klass, "test_capability", VALUEFUNC(_wrap_Driver_test_capability), -1);
    rb_define_method(cDriver.klass, "get_name", VALUEFUNC(_wrap_Driver_get_name), -1);
    cDriver.mark = 0;
    
    cDataSource.klass = rb_define_class_under(mOgr, "DataSource", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRDataSourceShadow, (void *) &cDataSource);
    rb_undef_alloc_func(cDataSource.klass);
    rb_define_method(cDataSource.klass, "name", VALUEFUNC(_wrap_DataSource_name_get), -1);
    rb_define_method(cDataSource.klass, "get_ref_count", VALUEFUNC(_wrap_DataSource_get_ref_count), -1);
    rb_define_method(cDataSource.klass, "get_summary_ref_count", VALUEFUNC(_wrap_DataSource_get_summary_ref_count), -1);
    rb_define_method(cDataSource.klass, "get_layer_count", VALUEFUNC(_wrap_DataSource_get_layer_count), -1);
    rb_define_method(cDataSource.klass, "get_name", VALUEFUNC(_wrap_DataSource_get_name), -1);
    rb_define_method(cDataSource.klass, "delete_layer", VALUEFUNC(_wrap_DataSource_delete_layer), -1);
    rb_define_method(cDataSource.klass, "create_layer", VALUEFUNC(_wrap_DataSource_create_layer), -1);
    rb_define_method(cDataSource.klass, "copy_layer", VALUEFUNC(_wrap_DataSource_copy_layer), -1);
    rb_define_method(cDataSource.klass, "test_capability", VALUEFUNC(_wrap_DataSource_test_capability), -1);
    rb_define_method(cDataSource.klass, "execute_sql", VALUEFUNC(_wrap_DataSource_execute_sql), -1);
    rb_define_method(cDataSource.klass, "release_result_set", VALUEFUNC(_wrap_DataSource_release_result_set), -1);
    rb_define_method(cDataSource.klass, "get_layer", VALUEFUNC(_wrap_DataSource_get_layer), -1);
    cDataSource.mark = 0;
    cDataSource.destroy = (void (*)(void *)) free_OGRDataSourceShadow;
    
    cLayer.klass = rb_define_class_under(mOgr, "Layer", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRLayerShadow, (void *) &cLayer);
    rb_include_module(cLayer.klass, rb_eval_string("Enumerable"));
    rb_undef_alloc_func(cLayer.klass);
    rb_define_method(cLayer.klass, "get_ref_count", VALUEFUNC(_wrap_Layer_get_ref_count), -1);
    rb_define_method(cLayer.klass, "set_spatial_filter", VALUEFUNC(_wrap_Layer_set_spatial_filter), -1);
    rb_define_method(cLayer.klass, "set_spatial_filter_rect", VALUEFUNC(_wrap_Layer_set_spatial_filter_rect), -1);
    rb_define_method(cLayer.klass, "get_spatial_filter", VALUEFUNC(_wrap_Layer_get_spatial_filter), -1);
    rb_define_method(cLayer.klass, "set_attribute_filter", VALUEFUNC(_wrap_Layer_set_attribute_filter), -1);
    rb_define_method(cLayer.klass, "reset_reading", VALUEFUNC(_wrap_Layer_reset_reading), -1);
    rb_define_method(cLayer.klass, "get_name", VALUEFUNC(_wrap_Layer_get_name), -1);
    rb_define_method(cLayer.klass, "get_feature", VALUEFUNC(_wrap_Layer_get_feature), -1);
    rb_define_method(cLayer.klass, "get_next_feature", VALUEFUNC(_wrap_Layer_get_next_feature), -1);
    rb_define_method(cLayer.klass, "set_next_by_index", VALUEFUNC(_wrap_Layer_set_next_by_index), -1);
    rb_define_method(cLayer.klass, "set_feature", VALUEFUNC(_wrap_Layer_set_feature), -1);
    rb_define_method(cLayer.klass, "create_feature", VALUEFUNC(_wrap_Layer_create_feature), -1);
    rb_define_method(cLayer.klass, "delete_feature", VALUEFUNC(_wrap_Layer_delete_feature), -1);
    rb_define_method(cLayer.klass, "sync_to_disk", VALUEFUNC(_wrap_Layer_sync_to_disk), -1);
    rb_define_method(cLayer.klass, "get_layer_defn", VALUEFUNC(_wrap_Layer_get_layer_defn), -1);
    rb_define_method(cLayer.klass, "get_feature_count", VALUEFUNC(_wrap_Layer_get_feature_count), -1);
    rb_define_method(cLayer.klass, "get_extent", VALUEFUNC(_wrap_Layer_get_extent), -1);
    rb_define_method(cLayer.klass, "test_capability", VALUEFUNC(_wrap_Layer_test_capability), -1);
    rb_define_method(cLayer.klass, "create_field", VALUEFUNC(_wrap_Layer_create_field), -1);
    rb_define_method(cLayer.klass, "start_transaction", VALUEFUNC(_wrap_Layer_start_transaction), -1);
    rb_define_method(cLayer.klass, "commit_transaction", VALUEFUNC(_wrap_Layer_commit_transaction), -1);
    rb_define_method(cLayer.klass, "rollback_transaction", VALUEFUNC(_wrap_Layer_rollback_transaction), -1);
    rb_define_method(cLayer.klass, "get_spatial_ref", VALUEFUNC(_wrap_Layer_get_spatial_ref), -1);
    rb_define_method(cLayer.klass, "get_feature_read", VALUEFUNC(_wrap_Layer_get_feature_read), -1);
    rb_define_method(cLayer.klass, "each", VALUEFUNC(_wrap_Layer_each), -1);
    cLayer.mark = 0;
    
    cFeature.klass = rb_define_class_under(mOgr, "Feature", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRFeatureShadow, (void *) &cFeature);
    rb_define_alloc_func(cFeature.klass, _wrap_Feature_allocate);
    rb_define_method(cFeature.klass, "initialize", VALUEFUNC(_wrap_new_Feature), -1);
    rb_define_method(cFeature.klass, "get_defn_ref", VALUEFUNC(_wrap_Feature_get_defn_ref), -1);
    rb_define_method(cFeature.klass, "set_geometry", VALUEFUNC(_wrap_Feature_set_geometry), -1);
    rb_define_method(cFeature.klass, "set_geometry_directly", VALUEFUNC(_wrap_Feature_set_geometry_directly), -1);
    rb_define_method(cFeature.klass, "get_geometry_ref", VALUEFUNC(_wrap_Feature_get_geometry_ref), -1);
    rb_define_method(cFeature.klass, "clone", VALUEFUNC(_wrap_Feature_clone), -1);
    rb_define_method(cFeature.klass, "equal", VALUEFUNC(_wrap_Feature_equal), -1);
    rb_define_method(cFeature.klass, "get_field_count", VALUEFUNC(_wrap_Feature_get_field_count), -1);
    rb_define_method(cFeature.klass, "get_field_defn_ref", VALUEFUNC(_wrap_Feature_get_field_defn_ref), -1);
    rb_define_method(cFeature.klass, "get_field_as_string", VALUEFUNC(_wrap_Feature_get_field_as_string), -1);
    rb_define_method(cFeature.klass, "get_field_as_integer", VALUEFUNC(_wrap_Feature_get_field_as_integer), -1);
    rb_define_method(cFeature.klass, "get_field_as_double", VALUEFUNC(_wrap_Feature_get_field_as_double), -1);
    rb_define_method(cFeature.klass, "is_field_set", VALUEFUNC(_wrap_Feature_is_field_set), -1);
    rb_define_method(cFeature.klass, "get_field_index", VALUEFUNC(_wrap_Feature_get_field_index), -1);
    rb_define_method(cFeature.klass, "get_fid", VALUEFUNC(_wrap_Feature_get_fid), -1);
    rb_define_method(cFeature.klass, "set_fid", VALUEFUNC(_wrap_Feature_set_fid), -1);
    rb_define_method(cFeature.klass, "dump_readable", VALUEFUNC(_wrap_Feature_dump_readable), -1);
    rb_define_method(cFeature.klass, "unset_field", VALUEFUNC(_wrap_Feature_unset_field), -1);
    rb_define_method(cFeature.klass, "set_field", VALUEFUNC(_wrap_Feature_set_field), -1);
    rb_define_method(cFeature.klass, "set_from", VALUEFUNC(_wrap_Feature_set_from), -1);
    rb_define_method(cFeature.klass, "get_style_string", VALUEFUNC(_wrap_Feature_get_style_string), -1);
    rb_define_method(cFeature.klass, "set_style_string", VALUEFUNC(_wrap_Feature_set_style_string), -1);
    rb_define_method(cFeature.klass, "get_field_type", VALUEFUNC(_wrap_Feature_get_field_type), -1);
    rb_define_method(cFeature.klass, "get_field", VALUEFUNC(_wrap_Feature_get_field), -1);
    cFeature.mark = 0;
    cFeature.destroy = (void (*)(void *)) free_OGRFeatureShadow;
    
    cFeatureDefn.klass = rb_define_class_under(mOgr, "FeatureDefn", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRFeatureDefnShadow, (void *) &cFeatureDefn);
    rb_define_alloc_func(cFeatureDefn.klass, _wrap_FeatureDefn_allocate);
    rb_define_method(cFeatureDefn.klass, "initialize", VALUEFUNC(_wrap_new_FeatureDefn), -1);
    rb_define_method(cFeatureDefn.klass, "get_name", VALUEFUNC(_wrap_FeatureDefn_get_name), -1);
    rb_define_method(cFeatureDefn.klass, "get_field_count", VALUEFUNC(_wrap_FeatureDefn_get_field_count), -1);
    rb_define_method(cFeatureDefn.klass, "get_field_defn", VALUEFUNC(_wrap_FeatureDefn_get_field_defn), -1);
    rb_define_method(cFeatureDefn.klass, "get_field_index", VALUEFUNC(_wrap_FeatureDefn_get_field_index), -1);
    rb_define_method(cFeatureDefn.klass, "add_field_defn", VALUEFUNC(_wrap_FeatureDefn_add_field_defn), -1);
    rb_define_method(cFeatureDefn.klass, "get_geom_type", VALUEFUNC(_wrap_FeatureDefn_get_geom_type), -1);
    rb_define_method(cFeatureDefn.klass, "set_geom_type", VALUEFUNC(_wrap_FeatureDefn_set_geom_type), -1);
    rb_define_method(cFeatureDefn.klass, "get_reference_count", VALUEFUNC(_wrap_FeatureDefn_get_reference_count), -1);
    cFeatureDefn.mark = 0;
    cFeatureDefn.destroy = (void (*)(void *)) free_OGRFeatureDefnShadow;
    
    cFieldDefn.klass = rb_define_class_under(mOgr, "FieldDefn", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRFieldDefnShadow, (void *) &cFieldDefn);
    rb_define_alloc_func(cFieldDefn.klass, _wrap_FieldDefn_allocate);
    rb_define_method(cFieldDefn.klass, "initialize", VALUEFUNC(_wrap_new_FieldDefn), -1);
    rb_define_method(cFieldDefn.klass, "get_name", VALUEFUNC(_wrap_FieldDefn_get_name), -1);
    rb_define_method(cFieldDefn.klass, "get_name_ref", VALUEFUNC(_wrap_FieldDefn_get_name_ref), -1);
    rb_define_method(cFieldDefn.klass, "set_name", VALUEFUNC(_wrap_FieldDefn_set_name), -1);
    rb_define_method(cFieldDefn.klass, "get_type", VALUEFUNC(_wrap_FieldDefn_get_type), -1);
    rb_define_method(cFieldDefn.klass, "set_type", VALUEFUNC(_wrap_FieldDefn_set_type), -1);
    rb_define_method(cFieldDefn.klass, "get_justify", VALUEFUNC(_wrap_FieldDefn_get_justify), -1);
    rb_define_method(cFieldDefn.klass, "set_justify", VALUEFUNC(_wrap_FieldDefn_set_justify), -1);
    rb_define_method(cFieldDefn.klass, "get_width", VALUEFUNC(_wrap_FieldDefn_get_width), -1);
    rb_define_method(cFieldDefn.klass, "set_width", VALUEFUNC(_wrap_FieldDefn_set_width), -1);
    rb_define_method(cFieldDefn.klass, "get_precision", VALUEFUNC(_wrap_FieldDefn_get_precision), -1);
    rb_define_method(cFieldDefn.klass, "set_precision", VALUEFUNC(_wrap_FieldDefn_set_precision), -1);
    rb_define_method(cFieldDefn.klass, "get_field_type_name", VALUEFUNC(_wrap_FieldDefn_get_field_type_name), -1);
    cFieldDefn.mark = 0;
    cFieldDefn.destroy = (void (*)(void *)) free_OGRFieldDefnShadow;
    rb_define_module_function(mOgr, "create_geometry_from_wkb", VALUEFUNC(_wrap_create_geometry_from_wkb), -1);
    rb_define_module_function(mOgr, "create_geometry_from_wkt", VALUEFUNC(_wrap_create_geometry_from_wkt), -1);
    rb_define_module_function(mOgr, "create_geometry_from_gml", VALUEFUNC(_wrap_create_geometry_from_gml), -1);
    
    cGeometry.klass = rb_define_class_under(mOgr, "Geometry", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_OGRGeometryShadow, (void *) &cGeometry);
    rb_define_alloc_func(cGeometry.klass, _wrap_Geometry_allocate);
    rb_define_method(cGeometry.klass, "initialize", VALUEFUNC(_wrap_new_Geometry), -1);
    rb_define_method(cGeometry.klass, "export_to_wkt", VALUEFUNC(_wrap_Geometry_export_to_wkt), -1);
    rb_define_method(cGeometry.klass, "export_to_wkb", VALUEFUNC(_wrap_Geometry_export_to_wkb), -1);
    rb_define_method(cGeometry.klass, "export_to_gml", VALUEFUNC(_wrap_Geometry_export_to_gml), -1);
    rb_define_method(cGeometry.klass, "add_point", VALUEFUNC(_wrap_Geometry_add_point), -1);
    rb_define_method(cGeometry.klass, "add_geometry_directly", VALUEFUNC(_wrap_Geometry_add_geometry_directly), -1);
    rb_define_method(cGeometry.klass, "add_geometry", VALUEFUNC(_wrap_Geometry_add_geometry), -1);
    rb_define_method(cGeometry.klass, "clone", VALUEFUNC(_wrap_Geometry_clone), -1);
    rb_define_method(cGeometry.klass, "get_geometry_type", VALUEFUNC(_wrap_Geometry_get_geometry_type), -1);
    rb_define_method(cGeometry.klass, "get_geometry_name", VALUEFUNC(_wrap_Geometry_get_geometry_name), -1);
    rb_define_method(cGeometry.klass, "get_area", VALUEFUNC(_wrap_Geometry_get_area), -1);
    rb_define_method(cGeometry.klass, "get_point_count", VALUEFUNC(_wrap_Geometry_get_point_count), -1);
    rb_define_method(cGeometry.klass, "get_x", VALUEFUNC(_wrap_Geometry_get_x), -1);
    rb_define_method(cGeometry.klass, "get_y", VALUEFUNC(_wrap_Geometry_get_y), -1);
    rb_define_method(cGeometry.klass, "get_z", VALUEFUNC(_wrap_Geometry_get_z), -1);
    rb_define_method(cGeometry.klass, "get_geometry_count", VALUEFUNC(_wrap_Geometry_get_geometry_count), -1);
    rb_define_method(cGeometry.klass, "set_point", VALUEFUNC(_wrap_Geometry_set_point), -1);
    rb_define_method(cGeometry.klass, "get_geometry_ref", VALUEFUNC(_wrap_Geometry_get_geometry_ref), -1);
    rb_define_method(cGeometry.klass, "get_boundary", VALUEFUNC(_wrap_Geometry_get_boundary), -1);
    rb_define_method(cGeometry.klass, "convex_hull", VALUEFUNC(_wrap_Geometry_convex_hull), -1);
    rb_define_method(cGeometry.klass, "buffer", VALUEFUNC(_wrap_Geometry_buffer), -1);
    rb_define_method(cGeometry.klass, "intersection", VALUEFUNC(_wrap_Geometry_intersection), -1);
    rb_define_method(cGeometry.klass, "union_", VALUEFUNC(_wrap_Geometry_union_), -1);
    rb_define_alias(cGeometry.klass, "union", "union_");
    rb_define_method(cGeometry.klass, "difference", VALUEFUNC(_wrap_Geometry_difference), -1);
    rb_define_method(cGeometry.klass, "symmetric_difference", VALUEFUNC(_wrap_Geometry_symmetric_difference), -1);
    rb_define_method(cGeometry.klass, "distance", VALUEFUNC(_wrap_Geometry_distance), -1);
    rb_define_method(cGeometry.klass, "empty", VALUEFUNC(_wrap_Geometry_empty), -1);
    rb_define_method(cGeometry.klass, "intersect", VALUEFUNC(_wrap_Geometry_intersect), -1);
    rb_define_method(cGeometry.klass, "equal", VALUEFUNC(_wrap_Geometry_equal), -1);
    rb_define_method(cGeometry.klass, "disjoint", VALUEFUNC(_wrap_Geometry_disjoint), -1);
    rb_define_method(cGeometry.klass, "touches", VALUEFUNC(_wrap_Geometry_touches), -1);
    rb_define_method(cGeometry.klass, "crosses", VALUEFUNC(_wrap_Geometry_crosses), -1);
    rb_define_method(cGeometry.klass, "within", VALUEFUNC(_wrap_Geometry_within), -1);
    rb_define_method(cGeometry.klass, "contains", VALUEFUNC(_wrap_Geometry_contains), -1);
    rb_define_method(cGeometry.klass, "overlaps", VALUEFUNC(_wrap_Geometry_overlaps), -1);
    rb_define_method(cGeometry.klass, "transform_to", VALUEFUNC(_wrap_Geometry_transform_to), -1);
    rb_define_method(cGeometry.klass, "transform", VALUEFUNC(_wrap_Geometry_transform), -1);
    rb_define_method(cGeometry.klass, "get_spatial_reference", VALUEFUNC(_wrap_Geometry_get_spatial_reference), -1);
    rb_define_method(cGeometry.klass, "assign_spatial_reference", VALUEFUNC(_wrap_Geometry_assign_spatial_reference), -1);
    rb_define_method(cGeometry.klass, "close_rings", VALUEFUNC(_wrap_Geometry_close_rings), -1);
    rb_define_method(cGeometry.klass, "flatten_to2d", VALUEFUNC(_wrap_Geometry_flatten_to2d), -1);
    rb_define_method(cGeometry.klass, "get_envelope", VALUEFUNC(_wrap_Geometry_get_envelope), -1);
    rb_define_method(cGeometry.klass, "centroid", VALUEFUNC(_wrap_Geometry_centroid), -1);
    rb_define_method(cGeometry.klass, "wkb_size", VALUEFUNC(_wrap_Geometry_wkb_size), -1);
    rb_define_method(cGeometry.klass, "get_coordinate_dimension", VALUEFUNC(_wrap_Geometry_get_coordinate_dimension), -1);
    rb_define_method(cGeometry.klass, "get_dimension", VALUEFUNC(_wrap_Geometry_get_dimension), -1);
    cGeometry.mark = 0;
    cGeometry.destroy = (void (*)(void *)) free_OGRGeometryShadow;
    rb_define_module_function(mOgr, "get_driver_count", VALUEFUNC(_wrap_get_driver_count), -1);
    rb_define_module_function(mOgr, "get_open_dscount", VALUEFUNC(_wrap_get_open_dscount), -1);
    rb_define_module_function(mOgr, "set_generate_db2_v72_byte_order", VALUEFUNC(_wrap_set_generate_db2_v72_byte_order), -1);
    rb_define_module_function(mOgr, "register_all", VALUEFUNC(_wrap_register_all), -1);
    rb_define_module_function(mOgr, "get_open_ds", VALUEFUNC(_wrap_get_open_ds), -1);
    rb_define_module_function(mOgr, "open", VALUEFUNC(_wrap_open), -1);
    rb_define_module_function(mOgr, "open_shared", VALUEFUNC(_wrap_open_shared), -1);
    rb_define_module_function(mOgr, "get_driver_by_name", VALUEFUNC(_wrap_get_driver_by_name), -1);
    rb_define_module_function(mOgr, "get_driver", VALUEFUNC(_wrap_get_driver), -1);
}

