/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Evaluable;

public abstract class Expression
extends Evaluable {

    public static class Negation
    extends Expression {
        protected Evaluable negated;

        public Negation(Evaluable negated) {
            this.negated = negated;
        }

        public Evaluable getNegated() {
            return this.negated;
        }
    }

    public static class Disjunction
    extends Expression {
        protected Evaluable[] disjoined;

        public Disjunction(Evaluable[] disjoined) {
            if (disjoined.length < 2) {
                throw new IllegalArgumentException();
            }
            this.disjoined = disjoined;
        }

        public Evaluable[] getDisjoined() {
            return this.disjoined;
        }
    }

    public static class Conjunction
    extends Expression {
        protected Evaluable[] conjoined;

        public Conjunction(Evaluable[] conjoined) {
            if (conjoined.length < 2) {
                throw new IllegalArgumentException();
            }
            this.conjoined = conjoined;
        }

        public Evaluable[] getConjoined() {
            return this.conjoined;
        }
    }

    public static class Equality
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public Equality(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class Inequality
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public Inequality(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class GreaterThan
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public GreaterThan(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class LessThan
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public LessThan(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class LessThanOrEqual
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public LessThanOrEqual(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class GreaterThanOrEqual
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public GreaterThanOrEqual(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }
    }

    public static class DefinedCheck
    extends Expression {
        protected Evaluable argument;

        public DefinedCheck(Evaluable argument) {
            this.argument = argument;
        }

        public Evaluable getArgument() {
            return this.argument;
        }
    }
}

