/******************************************************************************
 * $Id: ogr_geos.h,v 1.2 2005/10/20 19:55:29 fwarmerdam Exp $
 *
 * Project:  OpenGIS Simple Features Reference Implementation
 * Purpose:  Definitions related to support for use of GEOS in OGR.
 *           This file is only intended to be pulled in by OGR implementation
 *           code directly accessing GEOS.
 * Author:   Frank Warmerdam <warmerdam@pobox.com>
 *
 ******************************************************************************
 * Copyright (c) 2004, Frank Warmerdam <warmerdam@pobox.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************
 *
 * $Log: ogr_geos.h,v $
 * Revision 1.2  2005/10/20 19:55:29  fwarmerdam
 * added GEOS C API support
 *
 * Revision 1.1  2004/07/10 04:52:58  warmerda
 * New
 *
 */

#ifndef _OGR_GEOS_H_INCLUDED
#define _OGR_GEOS_H_INCLUDED

#ifdef HAVE_GEOS 

#ifdef GEOS_C_API
#  include "geos_c.h"
#else
#  include "geos/geom.h"
#  include "geos/io.h"
#  include "geos/util.h"
#endif

#else

namespace geos { 
    class Geometry;
};

#endif

#endif /* ndef _OGR_GEOS_H_INCLUDED */
