/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.interlis.ili2c.generator.IndentPrintWriter;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.ConditionalExpression;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Contract;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DecompositionView;
import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.FunctionallyDerivedUnit;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.JoinView;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.ParameterAssignment;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.SignInstruction;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UnionView;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public final class Interlis2Generator {
    IndentPrintWriter ipw;
    TransferDescription td;
    PredefinedModel modelInterlis;
    Unit anyUnit;
    boolean withPredefined;
    int numErrors = 0;
    private ArrayList selfStandingConstraints = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    private Interlis2Generator(Writer out, TransferDescription td, boolean withPredefined) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.modelInterlis = td.INTERLIS;
        this.anyUnit = td.INTERLIS.ANYUNIT;
        this.withPredefined = withPredefined;
    }

    private void finish() {
        this.ipw.close();
    }

    protected void printError() {
        this.ipw.print(Element.makeErrorName(null));
        ++this.numErrors;
    }

    public static int generate(Writer out, TransferDescription td, boolean withPredefined) {
        Interlis2Generator i = new Interlis2Generator(out, td, withPredefined);
        i.printTransferDescription(td);
        i.finish();
        return i.numErrors;
    }

    public static Interlis2Generator generateElements(Writer out, TransferDescription td) {
        Interlis2Generator i = new Interlis2Generator(out, td, false);
        return i;
    }

    private boolean printModifierHelper(boolean first, boolean flag, String what) {
        if (flag) {
            if (!first) {
                this.ipw.print(", ");
            }
            this.ipw.print(what);
            return false;
        }
        return first;
    }

    private void printModifiers(boolean _abstract, boolean _final, boolean _extended, boolean _ordered, boolean _external) {
        if (!(_abstract || _final || _extended || _ordered || _external)) {
            return;
        }
        boolean first = true;
        this.ipw.print(" (");
        first = this.printModifierHelper(first, _abstract, "ABSTRACT");
        first = this.printModifierHelper(first, _final, "FINAL");
        first = this.printModifierHelper(first, _extended, "EXTENDED");
        first = this.printModifierHelper(first, _ordered, "ORDERED");
        first = this.printModifierHelper(first, _external, "EXTERNAL");
        this.ipw.print(')');
    }

    protected void printTopic(Topic topic) {
        if (topic == null) {
            return;
        }
        this.selfStandingConstraints = new ArrayList();
        Topic extending = (Topic)topic.getExtending();
        this.ipw.print("TOPIC ");
        this.ipw.print(topic.getName());
        this.printModifiers(topic.isAbstract(), topic.isFinal(), false, false, false);
        if (extending != null) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(topic));
        }
        this.ipw.println(" =");
        this.ipw.indent();
        Iterator it = topic.getDependentOn();
        if (it.hasNext()) {
            this.ipw.print("DEPENDS ON ");
            this.ipw.print(((Topic)it.next()).getScopedName(topic));
            while (it.hasNext()) {
                this.ipw.print(", ");
                this.ipw.print(((Topic)it.next()).getScopedName(topic));
            }
            this.ipw.println(';');
            this.ipw.println();
        }
        this.printElements(topic);
        Iterator csi = ((AbstractList)this.selfStandingConstraints).iterator();
        Viewable view = null;
        Viewable lastView = null;
        while (csi.hasNext()) {
            Constraint cs = (Constraint)csi.next();
            view = (Viewable)cs.getContainer();
            if (view != lastView) {
                if (lastView != null) {
                    this.ipw.unindent();
                    this.ipw.println("END;");
                } else {
                    this.ipw.println();
                }
                lastView = view;
                this.ipw.print("CONSTRAINTS OF ");
                this.ipw.print(view.getName());
                this.ipw.println('=');
                this.ipw.indent();
            }
            this.printConstraint(cs);
        }
        if (lastView != null) {
            this.ipw.unindent();
            this.ipw.println("END;");
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.ipw.print(topic.getName());
        this.ipw.println(';');
    }

    protected void printTable(Table tdef) {
        String keyword = tdef.isIdentifiable() ? "CLASS" : "STRUCTURE";
        this.printStart(keyword, tdef, null);
        this.printElements(tdef);
        this.printEnd(tdef);
    }

    protected void printAssociationDef(AssociationDef def) {
        this.printStart("ASSOCIATION", def, null);
        this.printElements(def);
        this.printEnd(def);
    }

    private void printRenamedViewableRef(Container scope, ViewableAlias ref) {
        if (ref == null) {
            this.printError();
            return;
        }
        String name = ref.getName();
        Viewable v = ref.getAliasing();
        if (name == null || v == null) {
            this.printError();
            return;
        }
        if (!name.equals(v.getName())) {
            this.ipw.print(name);
            this.ipw.print('~');
        }
        this.ipw.print(v.getScopedName(scope));
    }

    protected void printRenamedViewableRefs(Container scope, ViewableAlias[] refs) {
        if (refs == null || refs.length == 0) {
            return;
        }
        this.printRenamedViewableRef(scope, refs[0]);
        int i = 1;
        while (i < refs.length) {
            this.ipw.print(", ");
            this.printRenamedViewableRef(scope, refs[i]);
            ++i;
        }
    }

    protected void printStart(String keyword, ExtendableContainer ec, Viewable basedOn) {
        if (ec == null) {
            return;
        }
        ExtendableContainer extending = (ExtendableContainer)ec.getExtending();
        boolean extendingSameName = false;
        if (extending != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Topic myTopic = (Topic)ec.getContainer(clazz);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Topic extendedTopic = (Topic)ec.getContainer(clazz2);
            if (myTopic != null && extendedTopic != null && myTopic.isExtending(extendedTopic) && ec.getName().equals(extending.getName())) {
                extendingSameName = true;
            }
        }
        this.ipw.print(keyword);
        this.ipw.print(' ');
        this.ipw.print(ec.getName());
        this.printModifiers(ec.isAbstract(), ec.isFinal(), extendingSameName, false, false);
        if (extending != null && !extendingSameName) {
            this.ipw.print(" EXTENDS ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.ipw.print(extending.getScopedName(ec.getContainer(clazz)));
        }
        if (basedOn != null) {
            this.ipw.print(" BASED ON ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.ipw.print(basedOn.getScopedName(ec.getContainer(clazz)));
        }
        this.ipw.println(" =");
        this.ipw.indent();
    }

    protected void printEnd(ExtendableContainer ec) {
        if (ec == null) {
            return;
        }
        this.ipw.unindent();
        this.ipw.print("END ");
        this.ipw.print(ec.getName());
        this.ipw.println(';');
    }

    public void printView(View view) {
        this.printStart("VIEW", view, null);
        if (view instanceof Projection) {
            this.ipw.print("PROJECTION OF ");
            this.ipw.print(((Projection)view).getSelected().getAliasing().getScopedName(view));
        } else if (view instanceof JoinView) {
            this.ipw.print("JOIN OF ");
            this.printRenamedViewableRefs(view, ((JoinView)view).getJoining());
        } else if (view instanceof UnionView) {
            this.ipw.print("UNION OF ");
            this.printRenamedViewableRefs(view, ((UnionView)view).getUnited());
        } else if (view instanceof DecompositionView) {
            Object decomposedViewable = null;
            ObjectPath decomposedAttribute = ((DecompositionView)view).getDecomposedAttribute();
            if (((DecompositionView)view).isAreaDecomposition()) {
                this.ipw.print("AREA ");
            }
            this.ipw.print("DECOMPOSITION OF ");
            if (decomposedAttribute == null) {
                this.printError();
            }
        } else {
            this.printError();
            this.ipw.println("<unknown view type>");
        }
        this.ipw.println(';');
        this.printElements(view);
        this.printEnd(view);
    }

    public void printGraphic(Graphic graph) {
        if (graph == null) {
            return;
        }
        this.printStart("GRAPHIC", graph, graph.getBasedOn());
        this.printElements(graph);
        this.printEnd(graph);
    }

    protected int getExpressionPrecedence(Evaluable ev) {
        if (ev instanceof Expression.Disjunction) {
            return 1;
        }
        if (ev instanceof Expression.Conjunction) {
            return 2;
        }
        if (ev instanceof Expression.Negation) {
            return 4;
        }
        if (ev instanceof Expression.Equality || ev instanceof Expression.Inequality || ev instanceof Expression.LessThanOrEqual || ev instanceof Expression.LessThan || ev instanceof Expression.GreaterThanOrEqual || ev instanceof Expression.GreaterThan) {
            return 5;
        }
        if (ev instanceof Expression.DefinedCheck) {
            return 7;
        }
        return 8;
    }

    protected void printExpression(Container scope, Evaluable expr) {
        this.printExpression(scope, expr, 1);
    }

    protected void printExpression(Container scope, Evaluable expr, int precedence) {
        int exprPrec = this.getExpressionPrecedence(expr);
        if (exprPrec < precedence) {
            this.ipw.print('(');
            this.printExpression(scope, expr, 1);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ObjectPath) {
            this.printAttributePath(scope, (ObjectPath)expr);
            return;
        }
        if (expr instanceof Constant.Undefined) {
            this.ipw.print("UNDEFINED");
            return;
        }
        if (expr instanceof Constant.Numeric) {
            Constant.Numeric cnum = (Constant.Numeric)expr;
            this.ipw.print(cnum.getValue());
            if (cnum.getUnit() != null) {
                this.ipw.print('[');
                this.printRef(scope, cnum.getUnit());
                this.ipw.print(']');
            }
            return;
        }
        if (expr instanceof Constant.Text) {
            this.ipw.print('\"');
            this.ipw.print(((Constant.Text)expr).getValue());
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.Enumeration) {
            this.ipw.print('#');
            String[] val = ((Constant.Enumeration)expr).getValue();
            if (val == null) {
                this.printError();
            } else {
                int i = 0;
                while (i < val.length) {
                    if (i > 0) {
                        this.ipw.print('.');
                    }
                    if (val[i] == null) {
                        this.printError();
                    } else {
                        this.ipw.print(val[i]);
                    }
                    ++i;
                }
            }
            return;
        }
        if (expr instanceof Constant.ReferenceToMetaObject) {
            MetaObject refMO = ((Constant.ReferenceToMetaObject)expr).getReferred();
            this.ipw.print('\"');
            if (refMO != null) {
                this.ipw.print(refMO.getName());
            } else {
                this.printError();
            }
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.Structured) {
            String val = ((Constant.Structured)expr).toString();
            if (val == null) {
                this.printError();
            } else {
                this.ipw.print(val);
            }
            return;
        }
        if (expr instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)expr;
            this.printRef(scope, f.getFunction());
            this.ipw.print(" (");
            Evaluable[] args = f.getArguments();
            if (args == null) {
                this.printError();
            } else {
                int i = 0;
                while (i < args.length) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.printExpression(scope, args[i]);
                    ++i;
                }
            }
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ParameterValue) {
            this.ipw.print("PARAMETER ");
            this.printRef(scope, ((ParameterValue)expr).getParameter());
            return;
        }
        if (expr instanceof Expression.Disjunction) {
            Evaluable[] disjoined = ((Expression.Disjunction)expr).getDisjoined();
            int i = 0;
            while (i < disjoined.length) {
                if (i > 0) {
                    this.ipw.print(" OR ");
                }
                this.printExpression(scope, disjoined[i], 2);
                ++i;
            }
            return;
        }
        if (expr instanceof Expression.Conjunction) {
            Evaluable[] conjoined = ((Expression.Conjunction)expr).getConjoined();
            int i = 0;
            while (i < conjoined.length) {
                if (i > 0) {
                    this.ipw.print(" AND ");
                }
                this.printExpression(scope, conjoined[i], 3);
                ++i;
            }
            return;
        }
        if (expr instanceof Expression.Negation) {
            this.ipw.print("NOT (");
            this.printExpression(scope, ((Expression.Negation)expr).getNegated(), 5);
            this.ipw.print(")");
            return;
        }
        if (expr instanceof Expression.Equality) {
            this.printExpression(scope, ((Expression.Equality)expr).getLeft(), 6);
            this.ipw.print(" == ");
            this.printExpression(scope, ((Expression.Equality)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.Inequality) {
            this.printExpression(scope, ((Expression.Inequality)expr).getLeft(), 6);
            this.ipw.print(" <> ");
            this.printExpression(scope, ((Expression.Inequality)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.LessThanOrEqual) {
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getLeft(), 6);
            this.ipw.print(" <= ");
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.GreaterThanOrEqual) {
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getLeft(), 6);
            this.ipw.print(" >= ");
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.LessThan) {
            this.printExpression(scope, ((Expression.LessThan)expr).getLeft(), 6);
            this.ipw.print(" < ");
            this.printExpression(scope, ((Expression.LessThan)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.GreaterThan) {
            this.printExpression(scope, ((Expression.GreaterThan)expr).getLeft(), 6);
            this.ipw.print(" > ");
            this.printExpression(scope, ((Expression.GreaterThan)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.DefinedCheck) {
            this.ipw.print("DEFINED (");
            this.printExpression(scope, ((Expression.DefinedCheck)expr).getArgument(), 7);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ConditionalExpression) {
            ConditionalExpression.Condition[] conds = ((ConditionalExpression)expr).getConditions();
            this.ipw.print("WITH ");
            this.printAttributePath(scope, ((ConditionalExpression)expr).getAttribute());
            this.ipw.println(" (");
            this.ipw.indent();
            if (conds == null) {
                this.printError();
            } else {
                int i = 0;
                while (i < conds.length) {
                    if (i != 0) {
                        this.ipw.println(",");
                    }
                    if (conds[i] == null) {
                        this.printError();
                    } else {
                        this.printExpression(scope, conds[i].getValue());
                        this.ipw.print(" WHEN IN ");
                        this.printExpression(scope, conds[i].getCondition());
                    }
                    ++i;
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
            return;
        }
        this.printError();
    }

    protected void printExistenceConstraint(Viewable forTable, ExistenceConstraint ec) {
        this.ipw.print("EXISTENCE CONSTRAINT ");
        ObjectPath attr = ec.getRestrictedAttribute();
        this.printAttributePath(forTable, attr);
        this.ipw.print(" REQUIRED IN ");
        Iterator reqi = ec.iteratorRequiredIn();
        String next = "";
        while (reqi.hasNext()) {
            ObjectPath req = (ObjectPath)reqi.next();
            this.ipw.print(next);
            next = " OR ";
            this.printRef(forTable, req.getRoot());
            this.ipw.print(":");
            this.printAttributePath(forTable, req);
        }
        this.ipw.println(';');
    }

    protected void printUniquenessConstraint(Viewable forTable, UniquenessConstraint uc) {
        UniqueEl uel = uc.getElements();
        Iterator pathi = uel.iteratorAttribute();
        if (uc.getLocal()) {
            this.ipw.print("UNIQUE (LOCAL) ");
            ObjectPath prefix = uc.getPrefix();
            this.printAttributePath(forTable, prefix);
            String next = ": ";
            while (pathi.hasNext()) {
                ObjectPath path = (ObjectPath)pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path);
            }
        } else {
            this.ipw.print("UNIQUE");
            String next = " ";
            while (pathi.hasNext()) {
                ObjectPath path = (ObjectPath)pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path);
            }
        }
        this.ipw.println(';');
    }

    public void printConstraint(Constraint elt) {
        Container container = elt.getContainer();
        if (elt instanceof MandatoryConstraint) {
            this.ipw.println("MANDATORY CONSTRAINT");
            this.ipw.indent();
            this.printExpression(container, ((MandatoryConstraint)elt).getCondition());
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof PlausibilityConstraint) {
            PlausibilityConstraint pc = (PlausibilityConstraint)elt;
            this.ipw.print("CONSTRAINT ");
            if (pc.getDirection() == 0) {
                this.ipw.print(" >= ");
            } else {
                this.ipw.print(" <= ");
            }
            this.ipw.print(pc.getPercentage());
            this.ipw.println('%');
            this.ipw.indent();
            this.printExpression(container, pc.getCondition());
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof UniquenessConstraint) {
            UniquenessConstraint uc = (UniquenessConstraint)elt;
            this.printUniquenessConstraint((Viewable)container, uc);
        } else if (elt instanceof ExistenceConstraint) {
            this.printExistenceConstraint((Viewable)container, (ExistenceConstraint)elt);
        }
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp) {
        this.ipw.print(gfxp.getName());
        this.ipw.print(" : ");
        this.printType(gfxp.getContainer(), gfxp.getDomain());
        this.ipw.println(";");
    }

    public void printMetaDataUseDef(MetaDataUseDef mu) {
        if (mu.isSignData()) {
            this.ipw.print("SIGN BASKET ");
        } else {
            this.ipw.print("REFSYSTEM BASKET ");
        }
        this.ipw.print(mu.getName());
        this.printModifiers(false, mu.isFinal(), false, false, false);
        Topic topic = mu.getTopic();
        this.ipw.print("~");
        this.ipw.print(topic.getContainer().getName());
        this.ipw.print(".");
        this.ipw.print(topic.getName());
        this.ipw.println(";");
    }

    public void printUnit(Container scope, Unit u) {
        if (u == null) {
            this.printError();
            return;
        }
        Unit extending = (Unit)u.getExtending();
        this.ipw.print(u.getDocName());
        if (!u.getDocName().equals(u.getName())) {
            this.ipw.print(" [");
            this.ipw.print(u.getName());
            this.ipw.print(']');
        }
        this.printModifiers(u.isAbstract(), false, false, false, false);
        if (extending != null && extending != this.anyUnit && !(u instanceof DerivedUnit)) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(scope));
        }
        if (u instanceof NumericallyDerivedUnit) {
            NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)u).getConversionFactors();
            this.ipw.print(" =");
            if (factors.length > 1) {
                int i = 0;
                while (i < factors.length) {
                    if (i > 0) {
                        this.ipw.print(' ');
                        this.ipw.print(factors[i].getConversionOperator());
                    }
                    this.ipw.print(' ');
                    this.printNumericConst(factors[i].getConversionFactor());
                    ++i;
                }
            } else if (factors.length == 1 && factors[0].getConversionFactor() != 1.0) {
                this.ipw.print(' ');
                this.printNumericConst(factors[0].getConversionFactor());
            }
            this.ipw.print(" [");
            this.printRef(scope, ((NumericallyDerivedUnit)u).getExtending());
            this.ipw.print(']');
        } else if (u instanceof FunctionallyDerivedUnit) {
            this.ipw.print(" = FUNCTION ");
            this.printExplanation(((FunctionallyDerivedUnit)u).getExplanation());
            this.ipw.print(" [");
            this.printRef(scope, ((FunctionallyDerivedUnit)u).getExtending());
            this.ipw.print(']');
        } else if (u instanceof ComposedUnit) {
            ComposedUnit.Composed[] composed = ((ComposedUnit)u).getComposedUnits();
            this.ipw.print(" = (");
            int i = 0;
            while (i < composed.length) {
                if (i > 0) {
                    this.ipw.print(' ');
                    this.ipw.print(composed[i].getCompositionOperator());
                    this.ipw.print(' ');
                }
                this.printRef(scope, composed[i].getUnit());
                ++i;
            }
            this.ipw.print(')');
        } else if (u instanceof StructuredUnit) {
            StructuredUnit.Part[] parts = ((StructuredUnit)u).getParts();
            this.ipw.print(" = {");
            this.printRef(scope, ((StructuredUnit)u).getFirstUnit());
            int i = 0;
            while (i < parts.length) {
                this.ipw.print(':');
                this.printRef(scope, parts[i].getUnit());
                this.ipw.print('[');
                this.ipw.print(parts[i].getMinimum());
                this.ipw.print("..");
                this.ipw.print(parts[i].getMaximum());
                this.ipw.print(']');
                ++i;
            }
            this.ipw.print('}');
            if (((StructuredUnit)u).isContinuous()) {
                this.ipw.print(" CONTINUOUS");
            }
        }
        this.ipw.println(';');
    }

    private void printRef(Container scope, Element elt) {
        if (elt == null) {
            this.printError();
        } else {
            this.ipw.print(elt.getScopedName(scope));
        }
    }

    public void printParameter(Container scope, Parameter par) {
        if (par == null) {
            this.printError();
            return;
        }
        this.ipw.print(par.getName());
        Parameter ext = par.getExtending();
        if (ext != null) {
            if (par.getName().equals(ext.getName())) {
                this.ipw.print(" (EXTENDED)");
            } else {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, ext);
            }
        }
        this.ipw.print(": ");
        Type typ = par.getType();
        if (typ instanceof ReferenceType) {
            this.ipw.print("-> ");
            this.printRef(scope, ((ReferenceType)typ).getReferred());
        } else {
            this.printType(scope, typ);
        }
        this.ipw.println(';');
    }

    private void printNumericConst(double num) {
        if (num == Math.PI) {
            this.ipw.print("PI");
            return;
        }
        StringBuffer s = new StringBuffer(30);
        s.append(num);
        int l = s.length();
        int i = 0;
        while (i < l) {
            if (s.charAt(i) == 'E') {
                s.setCharAt(i, 'S');
                break;
            }
            ++i;
        }
        this.ipw.print(s.toString());
    }

    protected void printRoleDef(Container scope, RoleDef role) {
        this.ipw.print(role.getName());
        this.printModifiers(role.isAbstract(), role.isFinal(), role.isExtended(), role.isOrdered(), role.isExternal());
        String kind = "";
        switch (role.getKind()) {
            case 1: {
                kind = " -- ";
                break;
            }
            case 2: {
                kind = " -<> ";
                break;
            }
            case 3: {
                kind = " -<#> ";
            }
        }
        this.ipw.print(kind);
        if (role.getDefinedCardinality() != null) {
            this.ipw.print(role.getDefinedCardinality() + " ");
        }
        this.printRef(scope, role.getDestination());
        this.ipw.println(';');
    }

    protected void printAttribute(Container scope, AttributeDef attrib) {
        if (attrib == null) {
            this.printError();
            return;
        }
        this.ipw.print(attrib.getName());
        this.printModifiers(attrib.isAbstract(), attrib.isFinal(), attrib.getExtending() != null, false, false);
        this.ipw.print(": ");
        if (attrib instanceof LocalAttribute) {
            this.printType(scope, attrib.getDomain());
            ObjectPath[] paths = null;
            if (paths != null && paths.length != 0) {
                this.ipw.print(" := ");
                int i = 0;
                while (i < paths.length) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.printAttributePath(scope, paths[i]);
                    ++i;
                }
            }
        }
        this.ipw.println(';');
    }

    protected void printSignAttribute(Graphic scope, SignAttribute attrib) {
        SignAttribute extending = (SignAttribute)attrib.getExtending();
        this.ipw.print(attrib.getName());
        this.printModifiers(false, false, extending != null, false, false);
        if (extending == null || attrib.getGenerating() != extending.getGenerating()) {
            this.ipw.print(" OF ");
            this.printRef(scope, attrib.getGenerating());
        }
        this.ipw.println(":");
        this.ipw.indent();
        SignInstruction[] instructions = attrib.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            if (i > 0) {
                this.ipw.println(',');
            }
            this.printSignInstruction(scope.getBasedOn(), instructions[i]);
            ++i;
        }
        this.ipw.unindent();
        this.ipw.println(';');
    }

    protected void printSignInstruction(Viewable basedOn, SignInstruction instr) {
        if (instr == null) {
            this.printError();
            return;
        }
        Evaluable restrictor = instr.getRestrictor();
        if (restrictor != null) {
            this.ipw.print("WHERE ");
            this.printExpression(basedOn, restrictor);
            this.ipw.println();
        }
        this.ipw.println('(');
        this.ipw.indent();
        ParameterAssignment[] assignments = instr.getAssignments();
        int i = 0;
        while (i < assignments.length) {
            if (i > 0) {
                this.ipw.println(';');
            }
            this.printParameterAssignment(basedOn, assignments[i]);
            ++i;
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print(')');
    }

    protected void printParameterAssignment(Viewable basedOn, ParameterAssignment parass) {
        if (parass == null) {
            this.printError();
            return;
        }
        Parameter assigned = parass.getAssigned();
        if (assigned == null) {
            this.printError();
        } else {
            this.ipw.print(assigned.getName());
        }
        this.ipw.print(" := ");
        this.printExpression(basedOn, parass.getValue());
    }

    protected void printModel(Model mdef) {
        this.ipw.print(mdef.toString());
        if (mdef.getLanguage() != null) {
            this.ipw.print("(" + mdef.getLanguage() + ")");
        }
        this.ipw.println(" =");
        this.ipw.indent();
        this.ipw.println();
        Contract[] contractv = mdef.getContracts();
        int i = 0;
        while (i < contractv.length) {
            this.ipw.println("CONTRACT ISSUED BY");
            this.ipw.indent();
            this.ipw.print(contractv[i].getIssuer());
            String expl = contractv[i].getExplanation();
            if (expl != null && expl.length() > 0) {
                this.ipw.print(' ');
                this.printExplanation(expl);
            }
            this.ipw.println(';');
            this.ipw.unindent();
            ++i;
        }
        Model[] imported = mdef.getImporting();
        if (imported.length > 0) {
            this.ipw.println("IMPORTS");
            this.ipw.indent();
            int i2 = 0;
            while (i2 < imported.length) {
                Model curImport;
                if (i2 > 0) {
                    this.ipw.print(", ");
                }
                if ((curImport = imported[i2]) instanceof Model) {
                    this.ipw.print(curImport.getName());
                } else {
                    this.printError();
                }
                ++i2;
            }
            this.ipw.println(';');
            this.ipw.unindent();
            this.ipw.println();
        }
        this.printElements(mdef);
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.ipw.print(mdef.getName());
        this.ipw.println('.');
        this.ipw.println();
    }

    protected void printExplanation(String explanationText) {
        this.ipw.print("//");
        this.ipw.print(explanationText);
        this.ipw.print("//");
    }

    protected void printDomainDef(Container scope, Domain dd) {
        Domain extending = dd.getExtending();
        this.ipw.print(dd.getName());
        this.printModifiers(dd.isAbstract(), dd.isFinal(), false, false, false);
        if (extending != null) {
            this.ipw.print(" EXTENDS ");
            this.printRef(scope, extending);
        }
        this.ipw.print(" = ");
        this.printType(scope, dd.getType());
        this.ipw.println(';');
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr) {
        if (rsr == null) {
            this.printError();
            return;
        }
        if (rsr instanceof RefSystemRef.CoordSystem) {
            RefSystemRef.CoordSystem cs = (RefSystemRef.CoordSystem)rsr;
            this.ipw.print('{');
            this.printRef(scope, cs.getSystem());
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordSystemAxis) {
            RefSystemRef.CoordSystemAxis csa = (RefSystemRef.CoordSystemAxis)rsr;
            this.ipw.print('{');
            this.printRef(scope, csa.getSystem());
            this.ipw.print('[');
            this.ipw.print(csa.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordDomain) {
            RefSystemRef.CoordDomain cda = (RefSystemRef.CoordDomain)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain());
            this.ipw.print('>');
        } else if (rsr instanceof RefSystemRef.CoordDomainAxis) {
            RefSystemRef.CoordDomainAxis cda = (RefSystemRef.CoordDomainAxis)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain());
            this.ipw.print('[');
            this.ipw.print(cda.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('>');
        } else {
            this.printError();
        }
    }

    public void printType(Container scope, Type dd) {
        if (dd == null) {
            this.printError();
            return;
        }
        if (dd.isMandatory()) {
            this.ipw.print("MANDATORY ");
        }
        if (dd instanceof NumericalType) {
            this.printNumericalType(scope, (NumericalType)dd);
        } else if (dd instanceof TextType) {
            int len = ((TextType)dd).getMaxLength();
            this.ipw.print("TEXT");
            if (len != -1) {
                this.ipw.print('*');
                this.ipw.print(len);
            }
        } else if (dd instanceof EnumerationType) {
            EnumerationType et = (EnumerationType)dd;
            this.printEnumeration(et.getEnumeration());
            if (et.isCircular()) {
                this.ipw.print(" CIRCULAR");
            } else if (et.isOrdered()) {
                this.ipw.print(" ORDERED");
            }
        } else if (dd instanceof TypeAlias) {
            Domain def = ((TypeAlias)dd).getAliasing();
            if (def == this.modelInterlis.BOOLEAN) {
                this.ipw.print("BOOLEAN");
            } else if (def == this.modelInterlis.VALIGNMENT) {
                this.ipw.print("VALIGNMENT");
            } else if (def == this.modelInterlis.HALIGNMENT) {
                this.ipw.print("HALIGNMENT");
            } else {
                this.printRef(scope, ((TypeAlias)dd).getAliasing());
            }
        } else if (dd instanceof CompositionType) {
            CompositionType comp = (CompositionType)dd;
            Cardinality card = comp.getCardinality();
            if (comp.isOrdered() && card.getMaximum() == 1L) {
                if (card.getMinimum() == 1L) {
                    this.ipw.print("MANDATORY ");
                }
            } else {
                this.ipw.print(comp.isOrdered() ? "LIST " : "BAG ");
                if (card.getMaximum() != Long.MAX_VALUE || card.getMinimum() != 0L) {
                    this.ipw.print(card);
                    this.ipw.print(' ');
                }
            }
            this.ipw.print("OF ");
            this.printRef(scope, comp.getComponentType());
        } else if (dd instanceof ReferenceType) {
            ReferenceType comp = (ReferenceType)dd;
            this.ipw.print("REFERENCE TO ");
            this.printRef(scope, comp.getReferred());
        } else if (dd instanceof CoordType) {
            NumericalType[] nts = ((CoordType)dd).getDimensions();
            int nullAxis = ((CoordType)dd).getNullAxis();
            int piHalfAxis = ((CoordType)dd).getPiHalfAxis();
            this.ipw.print("COORD ");
            this.ipw.indent();
            int i = 0;
            while (i < nts.length) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printNumericalType(scope, nts[i]);
                ++i;
            }
            if (nullAxis != 0) {
                this.ipw.println(',');
                this.ipw.print("ROTATION ");
                this.ipw.print(nullAxis);
                this.ipw.print(" -> ");
                if (piHalfAxis > 0) {
                    this.ipw.print(piHalfAxis);
                } else {
                    this.printError();
                }
            }
            this.ipw.unindent();
        } else if (dd instanceof LineType) {
            LineType lt = (LineType)dd;
            if (lt instanceof PolylineType) {
                this.ipw.print(((PolylineType)lt).isDirected() ? "DIRECTED POLYLINE" : "POLYLINE");
            } else if (lt instanceof SurfaceType) {
                this.ipw.print("SURFACE");
            } else if (lt instanceof AreaType) {
                this.ipw.print("AREA");
            } else {
                this.printError();
            }
            LineForm[] lineForms = lt.getLineForms();
            PrecisionDecimal maxOverlap = lt.getMaxOverlap();
            Domain controlPointDomain = lt.getControlPointDomain();
            Table lineAttributeStructure = null;
            if (lt instanceof SurfaceOrAreaType) {
                lineAttributeStructure = ((SurfaceOrAreaType)lt).getLineAttributeStructure();
            }
            this.ipw.indent();
            boolean needNewLine = false;
            if (lineForms.length > 0) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITH (");
                int i = 0;
                while (i < lineForms.length) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.ipw.print(lineForms[i].getName());
                    ++i;
                }
                this.ipw.print(')');
                needNewLine = true;
            }
            if (controlPointDomain != null) {
                this.ipw.print(" VERTEX ");
                this.printRef(scope, controlPointDomain);
                needNewLine = true;
            }
            if (maxOverlap != null) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print("WITHOUT OVERLAPS > ");
                this.ipw.print(maxOverlap.toString());
            }
            if (lineAttributeStructure != null) {
                this.ipw.println();
                this.ipw.print("LINE ATTRIBUTES ");
                this.printRef(scope, lineAttributeStructure);
            }
            this.ipw.unindent();
        } else if (dd instanceof OIDType) {
            Type type = ((OIDType)dd).getOIDType();
            if (type == null) {
                this.ipw.print("OID ANY");
            } else {
                this.ipw.print("OID ");
                this.printType(scope, type);
            }
        } else if (dd instanceof BasketType) {
            BasketType bt = (BasketType)dd;
            this.ipw.print("BASKET");
            int kind = bt.getKind();
            if (kind == 16) {
                this.ipw.print(" (DATA)");
            } else if (kind == 32) {
                this.ipw.print(" (VIEW)");
            } else if (kind == 64) {
                this.ipw.print(" (BASE)");
            } else if (kind == 128) {
                this.ipw.print(" (GRAPHIC)");
            }
            Topic spec = bt.getTopic();
            if (spec != null) {
                this.ipw.print(" OF ");
                this.printRef(scope, spec);
            }
        } else if (dd instanceof ClassType) {
            ClassType ct = (ClassType)dd;
            if (ct.isStructure()) {
                this.ipw.print("STRUCTURE");
            } else {
                this.ipw.print("CLASS");
            }
            String next = " RESTRICTED TO ";
            Iterator resti = ct.iteratorRestrictedTo();
            while (resti.hasNext()) {
                Table rest = (Table)resti.next();
                this.ipw.print(next);
                this.printRef(scope, rest);
                next = " ,";
            }
        } else if (dd instanceof ObjectType) {
            ObjectType ot = (ObjectType)dd;
            this.ipw.print("OBJECT OF ");
            Viewable ref = ot.getRef();
            if (ref == this.modelInterlis.ANYCLASS) {
                this.ipw.print("ANYCLASS");
            } else if (ref == this.modelInterlis.ANYSTRUCTURE) {
                this.ipw.print("ANYSTRUCTURE");
            } else {
                this.printRef(scope, ref);
            }
        } else if (dd instanceof MetaobjectType) {
            MetaobjectType ot = (MetaobjectType)dd;
            this.ipw.print("METAOBJECT");
            Table ref = ot.getReferred();
            if (ref != scope) {
                this.ipw.print(" OF ");
                this.printRef(scope, ref);
            }
        }
    }

    protected void printNumericalType(Container scope, NumericalType type) {
        if (type == null) {
            this.printError();
            return;
        }
        if (type instanceof NumericType) {
            NumericType ntyp = (NumericType)type;
            PrecisionDecimal min = ntyp.getMinimum();
            PrecisionDecimal max = ntyp.getMaximum();
            if (min == null) {
                this.ipw.print("NUMERIC");
            } else {
                this.ipw.print(min.toString());
                this.ipw.print(" .. ");
                this.ipw.print(max.toString());
            }
        } else if (type instanceof StructuredUnitType) {
            this.ipw.print(((StructuredUnitType)type).getMinimum().toString());
            this.ipw.print(" .. ");
            this.ipw.print(((StructuredUnitType)type).getMaximum().toString());
        }
        if (type.isCircular()) {
            this.ipw.print(" CIRCULAR");
        }
        if (type.getUnit() != null) {
            this.ipw.print(" [");
            this.ipw.print(type.getUnit().getScopedName(scope));
            this.ipw.print(']');
        }
        switch (type.getRotation()) {
            case 2: {
                this.ipw.print(" COUNTERCLOCKWISE");
                break;
            }
            case 1: {
                this.ipw.print(" CLOCKWISE");
            }
        }
        if (type.getReferenceSystem() != null) {
            this.ipw.print(' ');
            this.printReferenceSysRef(scope, type.getReferenceSystem());
        }
    }

    protected void printEnumeration(Enumeration enumer) {
        this.ipw.println('(');
        this.ipw.indent();
        if (enumer == null) {
            this.printError();
        } else {
            Iterator iter = enumer.getElements();
            while (iter.hasNext()) {
                this.printEnumerationElement((Enumeration.Element)iter.next());
                if (!iter.hasNext()) continue;
                this.ipw.println(',');
            }
        }
        this.ipw.unindent();
        this.ipw.print(')');
    }

    protected void printEnumerationElement(Enumeration.Element ee) {
        this.ipw.print(ee.getName());
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum);
        }
    }

    public void printLineFormTypeDef(Container scope, LineForm lf) {
        if (lf == null) {
            this.printError();
            return;
        }
        this.ipw.print(lf.getName());
        String explanation = lf.getExplanation();
        if (explanation != null) {
            this.ipw.print(' ');
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    public void printFunctionDeclaration(Container scope, Function f) {
        if (f == null) {
            this.printError();
            return;
        }
        this.ipw.print("FUNCTION ");
        this.ipw.print(f.getName());
        this.ipw.print(" (");
        FormalArgument[] args = f.getArguments();
        if (args == null) {
            this.printError();
        } else {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.ipw.print("; ");
                }
                this.ipw.print(String.valueOf(args[i].getName()) + ":");
                this.printType(scope, args[i].getType());
                ++i;
            }
        }
        this.ipw.print(") : ");
        this.printType(scope, f.getDomain());
        String explanation = f.getExplanation();
        if (explanation != null) {
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    protected void printAttributeRefs(AttributeRef[] refs) {
        if (refs == null) {
            this.printError();
            return;
        }
        int i = 0;
        while (i < refs.length) {
            if (i > 0) {
                this.ipw.print('.');
            }
            if (refs[i] == null) {
                this.printError();
            } else {
                this.ipw.print(refs[i].getName());
            }
            ++i;
        }
    }

    protected void printAttributePath(Container scope, ObjectPath path) {
        if (path == null) {
            this.printError();
            return;
        }
        PathEl[] elv = path.getPathElements();
        String sep = "";
        int i = 0;
        while (i < elv.length) {
            this.ipw.print(sep);
            sep = "->";
            this.ipw.print(elv[i].getName());
            ++i;
        }
    }

    protected void printElements(Container container) {
        Class<?> lastClass = null;
        Iterator it = container.iterator();
        while (it.hasNext()) {
            Element elt = (Element)it.next();
            if (elt instanceof AttributeDef) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.AttributeDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (lastClass != clazz) {
                    if (lastClass != null) {
                        this.ipw.println();
                    }
                    this.ipw.println("ATTRIBUTE");
                }
                this.ipw.indent();
                this.printAttribute(container, (AttributeDef)elt);
                this.ipw.unindent();
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("ch.interlis.ili2c.metamodel.AttributeDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz2;
                continue;
            }
            if (elt instanceof RoleDef) {
                this.ipw.indent();
                this.printRoleDef(container, (RoleDef)elt);
                this.ipw.unindent();
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.RoleDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Function) {
                if (lastClass != null) {
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("ch.interlis.ili2c.metamodel.Function");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (lastClass != clazz) {
                        this.ipw.println();
                    }
                }
                this.printFunctionDeclaration(container, (Function)elt);
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Function");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Parameter) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Parameter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (lastClass != clazz) {
                    if (lastClass != null) {
                        this.ipw.println();
                    }
                    this.ipw.println("PARAMETER");
                }
                this.ipw.indent();
                this.printParameter(container, (Parameter)elt);
                this.ipw.unindent();
                Class<?> clazz3 = class$5;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("ch.interlis.ili2c.metamodel.Parameter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz3;
                continue;
            }
            if (elt instanceof Domain) {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Domain");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (lastClass != clazz) {
                    if (lastClass != null) {
                        this.ipw.println();
                    }
                    this.ipw.println("DOMAIN");
                }
                this.ipw.indent();
                this.printDomainDef(container, (Domain)elt);
                this.ipw.unindent();
                Class<?> clazz4 = class$6;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("ch.interlis.ili2c.metamodel.Domain");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz4;
                continue;
            }
            if (elt instanceof LineForm) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.LineForm");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (lastClass != clazz) {
                    if (lastClass != null) {
                        this.ipw.println();
                    }
                    this.ipw.println("LINE FORM");
                }
                this.ipw.indent();
                this.printLineFormTypeDef(container, (LineForm)elt);
                this.ipw.unindent();
                Class<?> clazz5 = class$7;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("ch.interlis.ili2c.metamodel.LineForm");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz5;
                continue;
            }
            if (elt instanceof Unit) {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Unit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (lastClass != clazz) {
                    if (lastClass != null) {
                        this.ipw.println();
                    }
                    this.ipw.println("UNIT");
                }
                this.ipw.indent();
                this.printUnit(container, (Unit)elt);
                this.ipw.unindent();
                Class<?> clazz6 = class$8;
                if (clazz6 == null) {
                    try {
                        clazz6 = Class.forName("ch.interlis.ili2c.metamodel.Unit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz6;
                continue;
            }
            if (elt instanceof Model) {
                if (!this.withPredefined && elt instanceof PredefinedModel) continue;
                this.ipw.println();
                this.printModel((Model)elt);
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Model");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Topic) {
                this.ipw.println();
                this.ipw.println();
                this.printTopic((Topic)elt);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Table) {
                if (((Table)elt).isImplicit()) continue;
                this.ipw.println();
                this.printTable((Table)elt);
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.AbstractClassDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof AssociationDef) {
                this.ipw.println();
                this.printAssociationDef((AssociationDef)elt);
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.AbstractClassDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof View) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.printView((View)elt);
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.View");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Graphic) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.printGraphic((Graphic)elt);
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Graphic");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof Constraint) {
                if (((Constraint)elt).isSelfStanding()) {
                    this.selfStandingConstraints.add(elt);
                    continue;
                }
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.printConstraint((Constraint)elt);
                Class<?> clazz = class$13;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.Constraint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (elt instanceof ExpressionSelection) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("WHERE");
                this.ipw.indent();
                this.printExpression(((ExpressionSelection)elt).getSelected(), ((ExpressionSelection)elt).getCondition());
                this.ipw.println(';');
                this.ipw.unindent();
                Class<?> clazz = class$14;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("ch.interlis.ili2c.metamodel.ExpressionSelection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                lastClass = clazz;
                continue;
            }
            if (!(elt instanceof SignAttribute)) continue;
            Class<?> clazz = class$15;
            if (clazz == null) {
                try {
                    clazz = Class.forName("ch.interlis.ili2c.metamodel.SignAttribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (lastClass != clazz && lastClass != null) {
                this.ipw.println();
            }
            this.printSignAttribute((Graphic)container, (SignAttribute)elt);
            Class<?> clazz7 = class$15;
            if (clazz7 == null) {
                try {
                    clazz7 = Class.forName("ch.interlis.ili2c.metamodel.SignAttribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            lastClass = clazz7;
        }
    }

    protected void printTransferDescription(TransferDescription td) {
        this.ipw.println("INTERLIS 2.2;");
        this.ipw.unindent();
        this.ipw.println();
        this.printElements(td);
    }
}

