/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*
 * php4.swg
 *
 * PHP4 runtime library
 *
 */

#ifdef __cplusplus
extern "C" {
#endif
#include "zend.h"
#include "zend_API.h"
#include "php.h"

/* These TSRMLS_ stuff should already be defined now, but with older php under
   redhat are not... */
#ifndef TSRMLS_D
#define TSRMLS_D
#endif
#ifndef TSRMLS_DC
#define TSRMLS_DC
#endif
#ifndef TSRMLS_C
#define TSRMLS_C
#endif
#ifndef TSRMLS_CC
#define TSRMLS_CC
#endif

#ifdef __cplusplus
}
#endif

/* But in fact SWIG_ConvertPtr is the native interface for getting typed
   pointer values out of zvals.  We need the TSRMLS_ macros for when we
   make PHP type calls later as we handle php resources */
#define SWIG_ConvertPtr(obj,pp,type,flags) SWIG_ZTS_ConvertPtr(obj,pp,type,flags TSRMLS_CC)

/* Flags for SWIG_ConvertPtr */
#define SWIG_POINTER_DISOWN  0x1

#define SWIG_fail goto fail

static char *default_error_msg = "Unknown error occurred";
static int default_error_code = E_ERROR;

#define SWIG_PHP_Arg_Error_Msg(argnum,extramsg) "Error in argument " #argnum " "#extramsg

#define SWIG_PHP_Error(code,msg) ErrorCode() = code; ErrorMsg() = msg; SWIG_fail;

#define SWIG_contract_assert(expr,msg) \
  if (!(expr) ) { zend_printf("Contract Assert Failed %s\n",msg ); } else

/* Standard SWIG API */
#define SWIG_GetModule(clientdata) SWIG_Php4_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Php4_SetModule(pointer)

/* used to wrap returned objects in so we know whether they are newobject
   and need freeing, or not */
typedef struct _swig_object_wrapper {
  void * ptr;
  int newobject;
} swig_object_wrapper;

/* empty zend destructor for types without one */
static ZEND_RSRC_DTOR_FUNC(SWIG_landfill) {};

#define SWIG_SetPointerZval(a,b,c,d) SWIG_ZTS_SetPointerZval(a,b,c,d, SWIG_module_entry TSRMLS_CC)

static void
SWIG_ZTS_SetPointerZval(zval *z, void *ptr, swig_type_info *type, int newobject, zend_module_entry* module_entry TSRMLS_DC) {
  swig_object_wrapper *value=NULL;
  /*
   * First test for Null pointers.  Return those as PHP native NULL
   */
  if (!ptr ) {
    ZVAL_NULL(z);
    return;
  }
  if (type->clientdata) {
    if (! (*(int *)(type->clientdata)))
      zend_error(E_ERROR, "Type: %s failed to register with zend",type->name);
    value=(swig_object_wrapper *)emalloc(sizeof(swig_object_wrapper));
    value->ptr=ptr;
    value->newobject=newobject;
    ZEND_REGISTER_RESOURCE(z, value, *(int *)(type->clientdata));
    return;
  } else { /* have to deal with old fashioned string pointer?
              but this should not get this far */
    zend_error(E_ERROR, "Type: %s not registered with zend",type->name);
  }
}

/* This is a new pointer conversion routine
   Taking the native pointer p (which would have been converted from the old
   string pointer) and it's php type id, and it's type name (which also would
   have come from the old string pointer) it converts it to ptr calling 
   appropriate casting functions according to ty
   Sadly PHP has no API to find a type name from a type id, only from an instance
   of a resource of the type id, so we have to pass type_name as well.
   The two functions which might call this are:
   SWIG_ZTS_ConvertResourcePtr which gets the type name from the resource
   and the registered zend destructors for which we have one per type each
   with the type name hard wired in. */
static int
SWIG_ZTS_ConvertResourceData(void * p, int type, const char *type_name, void **ptr, swig_type_info *ty TSRMLS_DC) {
  swig_cast_info *tc;

  if (ty) {
    if (! type_name) {  
      /* can't convert p to ptr type ty if we don't know what type p is */
      return -1;
    } else {
      /* convert and cast p from type_name to ptr as ty
         Need to sort out const-ness, can SWIG_TypeCast really not take a const? */
      tc = SWIG_TypeCheck((char *)type_name,ty);
      if (!tc) return -1;
      *ptr = SWIG_TypeCast(tc, (void*)p);
    }
  } else {
    /* They don't care about the target type, so just pass on the pointer! */
    *ptr = (void *) p;
  }
  return 0;
}

/* This function fills ptr with a pointer of type ty by extracting the pointer
   and type info from the resource in z.  z must be a resource
   It uses SWIG_ZTS_ConvertResourceData to do the real work. */
static int
SWIG_ZTS_ConvertResourcePtr(zval *z, void **ptr, swig_type_info *ty, int flags TSRMLS_DC) {
  swig_object_wrapper *value;
  void *p;
  int type;
  char *type_name;

  value = (swig_object_wrapper *) zend_list_find(z->value.lval,&type);
  if ( flags && SWIG_POINTER_DISOWN ) {
    value->newobject = 0;
  }
  p = value->ptr;
  if (type==-1) return -1;

  type_name=zend_rsrc_list_get_rsrc_type(z->value.lval TSRMLS_CC);

  return SWIG_ZTS_ConvertResourceData(p,type,type_name,ptr,ty TSRMLS_CC);
}

/* We allow passing of a STRING or RESOURCE pointing to the object
   or an OBJECT whose _cPtr is a string or resource pointing to the object
   STRING pointers are very depracated */
static int
SWIG_ZTS_ConvertPtr(zval *z, void **ptr, swig_type_info *ty, int flags TSRMLS_DC) {
   char *c;
   zval *val;
   
   if(z == NULL) {
	*ptr = 0;
	return 0;
   }

   if (z->type==IS_OBJECT) {
     zval ** _cPtr;
     if (zend_hash_find(HASH_OF(z),"_cPtr",sizeof("_cPtr"),(void**)&_cPtr)==SUCCESS) {
       /* Don't co-erce to string if it isn't */
       if ((*_cPtr)->type==IS_STRING) c = Z_STRVAL_PP(_cPtr);
       else if ((*_cPtr)->type==IS_RESOURCE) {
         return SWIG_ZTS_ConvertResourcePtr(*_cPtr,ptr,ty, flags TSRMLS_CC);
       } else goto type_error; /* _cPtr was not string or resource property */
     } else goto type_error; /* can't find property _cPtr */
   } else if (z->type==IS_RESOURCE) {
     return SWIG_ZTS_ConvertResourcePtr(z,ptr,ty, flags TSRMLS_CC);
   } else goto type_error;

type_error:

    return -1;
}

static char const_name[] = "swig_runtime_data_type_pointer";
static swig_module_info *SWIG_Php4_GetModule() {
  zval *pointer;
  swig_module_info *ret = 0;

  MAKE_STD_ZVAL(pointer);

  if (zend_get_constant(const_name, sizeof(const_name), pointer)) {
    if (pointer->type == IS_LONG) {
      ret = (swig_module_info *) pointer->value.lval;
    }
  } 
  return 0;
}

static void SWIG_Php4_SetModule(swig_module_info *pointer) {
  REGISTER_MAIN_LONG_CONSTANT(const_name, (long) pointer, 0);
}


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_CPLErrorHandler swig_types[0]
#define SWIGTYPE_p_CPLXMLNode swig_types[1]
#define SWIGTYPE_p_GDALColorEntry swig_types[2]
#define SWIGTYPE_p_GDALColorTable swig_types[3]
#define SWIGTYPE_p_GDALDatasetShadow swig_types[4]
#define SWIGTYPE_p_GDALDriverShadow swig_types[5]
#define SWIGTYPE_p_GDALMajorObjectShadow swig_types[6]
#define SWIGTYPE_p_GDALRasterBandShadow swig_types[7]
#define SWIGTYPE_p_GDAL_GCP swig_types[8]
#define SWIGTYPE_p_double swig_types[9]
#define SWIGTYPE_p_int swig_types[10]
#define SWIGTYPE_p_p_CPLXMLNode swig_types[11]
#define SWIGTYPE_p_p_GDALColorTable swig_types[12]
#define SWIGTYPE_p_p_GDALDatasetShadow swig_types[13]
#define SWIGTYPE_p_p_GDALDriverShadow swig_types[14]
#define SWIGTYPE_p_p_GDALMajorObjectShadow swig_types[15]
#define SWIGTYPE_p_p_GDALRasterBandShadow swig_types[16]
#define SWIGTYPE_p_p_GDAL_GCP swig_types[17]
#define SWIGTYPE_p_p_char swig_types[18]
static swig_type_info *swig_types[20];
static swig_module_info swig_module = {swig_types, 19, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

/* header section */
/*
  +----------------------------------------------------------------------+
  | PHP version 4.0                                                      |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors:                                                             |
  |                                                                      |
  +----------------------------------------------------------------------+
 */
ZEND_BEGIN_MODULE_GLOBALS(gdal)
char *error_msg;
int error_code;
ZEND_END_MODULE_GLOBALS(gdal)
ZEND_DECLARE_MODULE_GLOBALS(gdal)
#ifdef ZTS
#define ErrorMsg() TSRMG(gdal_globals_id, zend_gdal_globals *, error_msg );
#define ErrorCode() TSRMG(gdal_globals_id, zend_gdal_globals *, error_code );
#else
#define ErrorMsg() (gdal_globals.error_msg)
#define ErrorCode() (gdal_globals.error_code)
#endif

static void gdal_init_globals(zend_gdal_globals *gdal_globals ) {
  gdal_globals->error_msg = default_error_msg;
  gdal_globals->error_code = default_error_code;
}
static void gdal_destroy_globals(zend_gdal_globals *gdal_globals) { }

void SWIG_ResetError() {
  ErrorMsg() = default_error_msg;
  ErrorCode() = default_error_code;
}
#define SWIG_name  "gdal"
#ifdef __cplusplus
extern "C" {
#endif
#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_gdal.h"
#ifdef __cplusplus
}
#endif


#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;

typedef int FALSE_IS_ERR;



  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, message );
  }
  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, msg );
  }

  CPLErr PushErrorHandler( char const * pszCallbackName = "CPLQuietErrorHandler" ) {
    CPLErrorHandler pfnHandler = NULL;
    if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


static char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
static void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
static char **GDALMajorObjectShadow_GetMetadata_Dict(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
static char **GDALMajorObjectShadow_GetMetadata_List(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
static int _wrap_propset_MajorObject(zend_property_reference *property_reference, pval *value);
static int _propset_MajorObject(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_MajorObject(zend_property_reference *property_reference);
static int _propget_MajorObject(zend_property_reference *property_reference, pval *value);
static GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *name,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){
    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate( self, name, xsize, ysize, bands, eType, options );
    return ds;
  }
static GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *name,GDALDatasetShadow *src,int strict=1,char **options=0){
    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(self, name, src, strict, 0, 0, 0 );
    return ds;
  }
static int GDALDriverShadow_Delete(GDALDriverShadow *self,char const *name){
    return GDALDeleteDataset( self, name );
  }
static int _wrap_propset_Driver(zend_property_reference *property_reference, pval *value);
static int _propset_Driver(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_Driver(zend_property_reference *property_reference);
static int _propget_Driver(zend_property_reference *property_reference, pval *value);

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

static GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){
    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }
static void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }
static int _wrap_propset_GCP(zend_property_reference *property_reference, pval *value);
static int _propset_GCP(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_GCP(zend_property_reference *property_reference);
static int _propget_GCP(zend_property_reference *property_reference, pval *value);


double GDAL_GCP_GCPX_get( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



/* Duplicate, but transposed names for C# because 
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



  zval *
  CreateTupleFromDoubleArray( double *first, unsigned int size ) {
    zval *tmp;
    MAKE_STD_ZVAL(tmp);
    array_init(tmp);
    for( unsigned int i=0; i<size; i++ ) {
      add_next_index_double( tmp, *first );
      ++first;
    }
    return tmp;
 }


void
t_output_helper( zval **target, zval *o) {
  if ( (*target)->type == IS_ARRAY ) {
    /* it's already an array, just append */
    add_next_index_zval( *target, o );
    return;
  }
  if ( (*target)->type == IS_NULL ) {
    REPLACE_ZVAL_VALUE(target,o,1);
    return;
  }
  zval *tmp;
  tmp = *target;
  zval_copy_ctor(tmp);
  array_init(*target);
  add_next_index_zval( *target, tmp);
  add_next_index_zval( *target, o);

}

static void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
static GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
static GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
static char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
static void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != 0 ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
static CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
static int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0){
    return GDALBuildOverviews( self, resampling, overviewlist, pOverviews, 0, 0, 0, 0);
  }
static int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
static char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
static void GDALDatasetShadow_GetGCPs(GDALDatasetShadow *self,int *nGCPs,GDAL_GCP const **pGCPs){
    *nGCPs = GDALGetGCPCount( self );
    *pGCPs = GDALGetGCPs( self );
  }
static CPLErr GDALDatasetShadow_SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
    return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
  }
static void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
static CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
static CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
    return GDALDatasetRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                (void*) buf_string, nxsize, nysize, ntype,
                                band_list, pband_list, 0, 0, 0 );
    if ( myBandList ) {
       CPLFree( pBandList );
    }
  }
static int _wrap_propset_Dataset(zend_property_reference *property_reference, pval *value);
static int _propset_Dataset(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_Dataset(zend_property_reference *property_reference);
static int _propget_Dataset(zend_property_reference *property_reference, pval *value);

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


static
CPLErr ReadRaster_internal( GDALRasterBandShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf )
{

  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );
  CPLErr result =  GDALRasterIO( obj, GF_Read, xoff, yoff, xsize, ysize,
                                 (void *) *buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

static
CPLErr WriteRaster_internal( GDALRasterBandShadow *obj,
                             int xoff, int yoff, int xsize, int ysize,
                             int buf_xsize, int buf_ysize,
                             GDALDataType buf_type,
                             int buf_size, char *buffer )
{
    if ( buf_size < buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type) /8 ) {
      return CE_Failure;
    }

    return GDALRasterIO( obj, GF_Write, xoff, yoff, xsize, ysize, 
		        (void *) buffer, buf_xsize, buf_ysize, buf_type, 0, 0 );
}

static GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
static CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
static void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
static CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
static void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
static void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
static void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
static void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
static int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
static GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
static int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
static void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
static CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
static CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return ReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype, buf_len, buf );
  }
static CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return WriteRaster_internal( self, xoff, yoff, xsize, ysize,
                                 nxsize, nysize, ntype, buf_len, buf_string );
  }
static void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
static GDALColorTable *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTable*) GDALGetRasterColorTable( self );
  }
static int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTable *arg){
    return GDALSetRasterColorTable( self, arg );
  }
static int _wrap_propset_Band(zend_property_reference *property_reference, pval *value);
static int _propset_Band(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_Band(zend_property_reference *property_reference);
static int _propget_Band(zend_property_reference *property_reference, pval *value);

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}

static int _wrap_propset_ColorTable(zend_property_reference *property_reference, pval *value);
static int _propset_ColorTable(zend_property_reference *property_reference, pval *value);
static pval _wrap_propget_ColorTable(zend_property_reference *property_reference);
static int _propget_ColorTable(zend_property_reference *property_reference, pval *value);

int GetDriverCount() {
  return GDALGetDriverCount();
}


GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpen( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpenShared( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    throw CPLGetLastErrorMsg();
  }
  return ds;
  
}

/* class entry subsection */
/* Function entries for MajorObject */
static zend_function_entry MajorObject_functions[] = {
 ZEND_NAMED_FE(majorobject_getdescription,_wrap_MajorObject_GetDescription, NULL)
 ZEND_NAMED_FE(getdescription,_wrap_MajorObject_GetDescription, NULL)
 ZEND_NAMED_FE(majorobject_setdescription,_wrap_MajorObject_SetDescription, NULL)
 ZEND_NAMED_FE(setdescription,_wrap_MajorObject_SetDescription, NULL)
 ZEND_NAMED_FE(majorobject_getmetadata_dict,_wrap_MajorObject_GetMetadata_Dict, NULL)
 ZEND_NAMED_FE(getmetadata_dict,_wrap_MajorObject_GetMetadata_Dict, NULL)
 ZEND_NAMED_FE(majorobject_getmetadata_list,_wrap_MajorObject_GetMetadata_List, NULL)
 ZEND_NAMED_FE(getmetadata_list,_wrap_MajorObject_GetMetadata_List, NULL)
 ZEND_NAMED_FE(setmetadata,_wrap_MajorObject_SetMetadata, NULL)
 ZEND_NAMED_FE(majorobject_setmetadata,_wrap_MajorObject_SetMetadata, NULL)
 ZEND_NAMED_FE(setmetadata,_wrap_MajorObject_SetMetadata, NULL)
   { NULL, NULL, NULL}
};
/* Function entries for Driver */
static zend_function_entry Driver_functions[] = {
 ZEND_NAMED_FE(driver_create,_wrap_Driver_Create, NULL)
 ZEND_NAMED_FE(create,_wrap_Driver_Create, NULL)
 ZEND_NAMED_FE(driver_createcopy,_wrap_Driver_CreateCopy, NULL)
 ZEND_NAMED_FE(createcopy,_wrap_Driver_CreateCopy, NULL)
 ZEND_NAMED_FE(driver_delete,_wrap_Driver_Delete, NULL)
 ZEND_NAMED_FE(delete,_wrap_Driver_Delete, NULL)
   { NULL, NULL, NULL}
};
/* Function entries for GCP */
static zend_function_entry GCP_functions[] = {
 ZEND_NAMED_FE(new_gcp,_wrap_new_GCP, NULL)
 ZEND_NAMED_FE(gcp,_wrap_new_GCP, NULL)
   { NULL, NULL, NULL}
};
/* Function entries for Dataset */
static zend_function_entry Dataset_functions[] = {
 ZEND_NAMED_FE(dataset_getdriver,_wrap_Dataset_GetDriver, NULL)
 ZEND_NAMED_FE(getdriver,_wrap_Dataset_GetDriver, NULL)
 ZEND_NAMED_FE(dataset_getrasterband,_wrap_Dataset_GetRasterBand, NULL)
 ZEND_NAMED_FE(getrasterband,_wrap_Dataset_GetRasterBand, NULL)
 ZEND_NAMED_FE(dataset_getprojection,_wrap_Dataset_GetProjection, NULL)
 ZEND_NAMED_FE(getprojection,_wrap_Dataset_GetProjection, NULL)
 ZEND_NAMED_FE(dataset_getprojectionref,_wrap_Dataset_GetProjectionRef, NULL)
 ZEND_NAMED_FE(getprojectionref,_wrap_Dataset_GetProjectionRef, NULL)
 ZEND_NAMED_FE(dataset_setprojection,_wrap_Dataset_SetProjection, NULL)
 ZEND_NAMED_FE(setprojection,_wrap_Dataset_SetProjection, NULL)
 ZEND_NAMED_FE(dataset_getgeotransform,_wrap_Dataset_GetGeoTransform, NULL)
 ZEND_NAMED_FE(getgeotransform,_wrap_Dataset_GetGeoTransform, NULL)
 ZEND_NAMED_FE(dataset_setgeotransform,_wrap_Dataset_SetGeoTransform, NULL)
 ZEND_NAMED_FE(setgeotransform,_wrap_Dataset_SetGeoTransform, NULL)
 ZEND_NAMED_FE(dataset_buildoverviews,_wrap_Dataset_BuildOverviews, NULL)
 ZEND_NAMED_FE(buildoverviews,_wrap_Dataset_BuildOverviews, NULL)
 ZEND_NAMED_FE(dataset_getgcpcount,_wrap_Dataset_GetGCPCount, NULL)
 ZEND_NAMED_FE(getgcpcount,_wrap_Dataset_GetGCPCount, NULL)
 ZEND_NAMED_FE(dataset_getgcpprojection,_wrap_Dataset_GetGCPProjection, NULL)
 ZEND_NAMED_FE(getgcpprojection,_wrap_Dataset_GetGCPProjection, NULL)
 ZEND_NAMED_FE(dataset_getgcps,_wrap_Dataset_GetGCPs, NULL)
 ZEND_NAMED_FE(getgcps,_wrap_Dataset_GetGCPs, NULL)
 ZEND_NAMED_FE(dataset_setgcps,_wrap_Dataset_SetGCPs, NULL)
 ZEND_NAMED_FE(setgcps,_wrap_Dataset_SetGCPs, NULL)
 ZEND_NAMED_FE(dataset_flushcache,_wrap_Dataset_FlushCache, NULL)
 ZEND_NAMED_FE(flushcache,_wrap_Dataset_FlushCache, NULL)
 ZEND_NAMED_FE(dataset_addband,_wrap_Dataset_AddBand, NULL)
 ZEND_NAMED_FE(addband,_wrap_Dataset_AddBand, NULL)
 ZEND_NAMED_FE(dataset_writeraster,_wrap_Dataset_WriteRaster, NULL)
 ZEND_NAMED_FE(writeraster,_wrap_Dataset_WriteRaster, NULL)
   { NULL, NULL, NULL}
};
/* Function entries for Band */
static zend_function_entry Band_functions[] = {
 ZEND_NAMED_FE(band_getrastercolorinterpretation,_wrap_Band_GetRasterColorInterpretation, NULL)
 ZEND_NAMED_FE(getrastercolorinterpretation,_wrap_Band_GetRasterColorInterpretation, NULL)
 ZEND_NAMED_FE(band_setrastercolorinterpretation,_wrap_Band_SetRasterColorInterpretation, NULL)
 ZEND_NAMED_FE(setrastercolorinterpretation,_wrap_Band_SetRasterColorInterpretation, NULL)
 ZEND_NAMED_FE(band_getnodatavalue,_wrap_Band_GetNoDataValue, NULL)
 ZEND_NAMED_FE(getnodatavalue,_wrap_Band_GetNoDataValue, NULL)
 ZEND_NAMED_FE(band_setnodatavalue,_wrap_Band_SetNoDataValue, NULL)
 ZEND_NAMED_FE(setnodatavalue,_wrap_Band_SetNoDataValue, NULL)
 ZEND_NAMED_FE(band_getminimum,_wrap_Band_GetMinimum, NULL)
 ZEND_NAMED_FE(getminimum,_wrap_Band_GetMinimum, NULL)
 ZEND_NAMED_FE(band_getmaximum,_wrap_Band_GetMaximum, NULL)
 ZEND_NAMED_FE(getmaximum,_wrap_Band_GetMaximum, NULL)
 ZEND_NAMED_FE(band_getoffset,_wrap_Band_GetOffset, NULL)
 ZEND_NAMED_FE(getoffset,_wrap_Band_GetOffset, NULL)
 ZEND_NAMED_FE(band_getscale,_wrap_Band_GetScale, NULL)
 ZEND_NAMED_FE(getscale,_wrap_Band_GetScale, NULL)
 ZEND_NAMED_FE(band_getoverviewcount,_wrap_Band_GetOverviewCount, NULL)
 ZEND_NAMED_FE(getoverviewcount,_wrap_Band_GetOverviewCount, NULL)
 ZEND_NAMED_FE(band_getoverview,_wrap_Band_GetOverview, NULL)
 ZEND_NAMED_FE(getoverview,_wrap_Band_GetOverview, NULL)
 ZEND_NAMED_FE(band_checksum,_wrap_Band_Checksum, NULL)
 ZEND_NAMED_FE(checksum,_wrap_Band_Checksum, NULL)
 ZEND_NAMED_FE(band_computerasterminmax,_wrap_Band_ComputeRasterMinMax, NULL)
 ZEND_NAMED_FE(computerasterminmax,_wrap_Band_ComputeRasterMinMax, NULL)
 ZEND_NAMED_FE(band_fill,_wrap_Band_Fill, NULL)
 ZEND_NAMED_FE(fill,_wrap_Band_Fill, NULL)
 ZEND_NAMED_FE(band_readraster,_wrap_Band_ReadRaster, NULL)
 ZEND_NAMED_FE(readraster,_wrap_Band_ReadRaster, NULL)
 ZEND_NAMED_FE(band_writeraster,_wrap_Band_WriteRaster, NULL)
 ZEND_NAMED_FE(writeraster,_wrap_Band_WriteRaster, NULL)
 ZEND_NAMED_FE(band_flushcache,_wrap_Band_FlushCache, NULL)
 ZEND_NAMED_FE(flushcache,_wrap_Band_FlushCache, NULL)
 ZEND_NAMED_FE(band_getrastercolortable,_wrap_Band_GetRasterColorTable, NULL)
 ZEND_NAMED_FE(getrastercolortable,_wrap_Band_GetRasterColorTable, NULL)
 ZEND_NAMED_FE(band_setrastercolortable,_wrap_Band_SetRasterColorTable, NULL)
 ZEND_NAMED_FE(setrastercolortable,_wrap_Band_SetRasterColorTable, NULL)
   { NULL, NULL, NULL}
};
/* Function entries for ColorTable */
static zend_function_entry ColorTable_functions[] = {
 ZEND_NAMED_FE(new_colortable,_wrap_new_ColorTable, NULL)
 ZEND_NAMED_FE(colortable,_wrap_new_ColorTable, NULL)
 ZEND_NAMED_FE(colortable_clone,_wrap_ColorTable_Clone, NULL)
 ZEND_NAMED_FE(clone,_wrap_ColorTable_Clone, NULL)
 ZEND_NAMED_FE(colortable_getpaletteinterpretation,_wrap_ColorTable_GetPaletteInterpretation, NULL)
 ZEND_NAMED_FE(getpaletteinterpretation,_wrap_ColorTable_GetPaletteInterpretation, NULL)
 ZEND_NAMED_FE(colortable_getcount,_wrap_ColorTable_GetCount, NULL)
 ZEND_NAMED_FE(getcount,_wrap_ColorTable_GetCount, NULL)
 ZEND_NAMED_FE(colortable_getcolorentry,_wrap_ColorTable_GetColorEntry, NULL)
 ZEND_NAMED_FE(getcolorentry,_wrap_ColorTable_GetColorEntry, NULL)
 ZEND_NAMED_FE(colortable_getcolorentryasrgb,_wrap_ColorTable_GetColorEntryAsRGB, NULL)
 ZEND_NAMED_FE(getcolorentryasrgb,_wrap_ColorTable_GetColorEntryAsRGB, NULL)
 ZEND_NAMED_FE(colortable_setcolorentry,_wrap_ColorTable_SetColorEntry, NULL)
 ZEND_NAMED_FE(setcolorentry,_wrap_ColorTable_SetColorEntry, NULL)
   { NULL, NULL, NULL}
};


/* entry subsection */
/* Every non-class user visible function must have an entry here */
function_entry gdal_functions[] = {
  ZEND_NAMED_FE(debug,_wrap_Debug, NULL)
  ZEND_NAMED_FE(error,_wrap_Error, NULL)
  ZEND_NAMED_FE(pusherrorhandler,_wrap_PushErrorHandler, NULL)
  ZEND_NAMED_FE(poperrorhandler,_wrap_PopErrorHandler, NULL)
  ZEND_NAMED_FE(errorreset,_wrap_ErrorReset, NULL)
  ZEND_NAMED_FE(getlasterrorno,_wrap_GetLastErrorNo, NULL)
  ZEND_NAMED_FE(getlasterrortype,_wrap_GetLastErrorType, NULL)
  ZEND_NAMED_FE(getlasterrormsg,_wrap_GetLastErrorMsg, NULL)
  ZEND_NAMED_FE(pushfinderlocation,_wrap_PushFinderLocation, NULL)
  ZEND_NAMED_FE(popfinderlocation,_wrap_PopFinderLocation, NULL)
  ZEND_NAMED_FE(finderclean,_wrap_FinderClean, NULL)
  ZEND_NAMED_FE(findfile,_wrap_FindFile, NULL)
  ZEND_NAMED_FE(setconfigoption,_wrap_SetConfigOption, NULL)
  ZEND_NAMED_FE(getconfigoption,_wrap_GetConfigOption, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpx_get,_wrap_GDAL_GCP_GCPX_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpx_set,_wrap_GDAL_GCP_GCPX_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpy_get,_wrap_GDAL_GCP_GCPY_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpy_set,_wrap_GDAL_GCP_GCPY_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpz_get,_wrap_GDAL_GCP_GCPZ_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpz_set,_wrap_GDAL_GCP_GCPZ_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcppixel_get,_wrap_GDAL_GCP_GCPPixel_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcppixel_set,_wrap_GDAL_GCP_GCPPixel_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpline_get,_wrap_GDAL_GCP_GCPLine_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_gcpline_set,_wrap_GDAL_GCP_GCPLine_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_info_get,_wrap_GDAL_GCP_Info_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_info_set,_wrap_GDAL_GCP_Info_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_id_get,_wrap_GDAL_GCP_Id_get, NULL)
  ZEND_NAMED_FE(gdal_gcp_id_set,_wrap_GDAL_GCP_Id_set, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_gcpx,_wrap_GDAL_GCP_get_GCPX, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_gcpx,_wrap_GDAL_GCP_set_GCPX, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_gcpy,_wrap_GDAL_GCP_get_GCPY, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_gcpy,_wrap_GDAL_GCP_set_GCPY, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_gcpz,_wrap_GDAL_GCP_get_GCPZ, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_gcpz,_wrap_GDAL_GCP_set_GCPZ, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_gcppixel,_wrap_GDAL_GCP_get_GCPPixel, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_gcppixel,_wrap_GDAL_GCP_set_GCPPixel, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_gcpline,_wrap_GDAL_GCP_get_GCPLine, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_gcpline,_wrap_GDAL_GCP_set_GCPLine, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_info,_wrap_GDAL_GCP_get_Info, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_info,_wrap_GDAL_GCP_set_Info, NULL)
  ZEND_NAMED_FE(gdal_gcp_get_id,_wrap_GDAL_GCP_get_Id, NULL)
  ZEND_NAMED_FE(gdal_gcp_set_id,_wrap_GDAL_GCP_set_Id, NULL)
  ZEND_NAMED_FE(gcpstogeotransform,_wrap_GCPsToGeoTransform, NULL)
  ZEND_NAMED_FE(allregister,_wrap_AllRegister, NULL)
  ZEND_NAMED_FE(getcachemax,_wrap_GetCacheMax, NULL)
  ZEND_NAMED_FE(setcachemax,_wrap_SetCacheMax, NULL)
  ZEND_NAMED_FE(getcacheused,_wrap_GetCacheUsed, NULL)
  ZEND_NAMED_FE(getdatatypesize,_wrap_GetDataTypeSize, NULL)
  ZEND_NAMED_FE(datatypeiscomplex,_wrap_DataTypeIsComplex, NULL)
  ZEND_NAMED_FE(getdatatypename,_wrap_GetDataTypeName, NULL)
  ZEND_NAMED_FE(getdatatypebyname,_wrap_GetDataTypeByName, NULL)
  ZEND_NAMED_FE(getcolorinterpretationname,_wrap_GetColorInterpretationName, NULL)
  ZEND_NAMED_FE(getpaletteinterpretationname,_wrap_GetPaletteInterpretationName, NULL)
  ZEND_NAMED_FE(dectodms,_wrap_DecToDMS, NULL)
  ZEND_NAMED_FE(packeddmstodec,_wrap_PackedDMSToDec, NULL)
  ZEND_NAMED_FE(dectopackeddms,_wrap_DecToPackedDMS, NULL)
  ZEND_NAMED_FE(parsexmlstring,_wrap_ParseXMLString, NULL)
  ZEND_NAMED_FE(serializexmltree,_wrap_SerializeXMLTree, NULL)
  ZEND_NAMED_FE(getdrivercount,_wrap_GetDriverCount, NULL)
  ZEND_NAMED_FE(getdriverbyname,_wrap_GetDriverByName, NULL)
  ZEND_NAMED_FE(getdriver,_wrap_GetDriver, NULL)
  ZEND_NAMED_FE(open,_wrap_Open, NULL)
  ZEND_NAMED_FE(openshared,_wrap_OpenShared, NULL)
  ZEND_NAMED_FE(autocreatewarpedvrt,_wrap_AutoCreateWarpedVRT, NULL)
 {NULL, NULL, NULL}
};

zend_module_entry gdal_module_entry = {
#if ZEND_MODULE_API_NO > 20010900
    STANDARD_MODULE_HEADER,
#endif
    "gdal",
    gdal_functions,
    PHP_MINIT(gdal),
    PHP_MSHUTDOWN(gdal),
    PHP_RINIT(gdal),
    PHP_RSHUTDOWN(gdal),
    PHP_MINFO(gdal),
#if ZEND_MODULE_API_NO > 20010900
    NO_VERSION_YET,
#endif
    STANDARD_MODULE_PROPERTIES
};
zend_module_entry* SWIG_module_entry = &gdal_module_entry;


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_p_GDALDriverShadowTo_p_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow **)  ((GDALDriverShadow **) x));
}
static void *_p_p_GDALDatasetShadowTo_p_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow **)  ((GDALDatasetShadow **) x));
}
static void *_p_p_GDALRasterBandShadowTo_p_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow **)  ((GDALRasterBandShadow **) x));
}
static void *_p_GDALDriverShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDriverShadow *) x));
}
static void *_p_GDALDatasetShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDatasetShadow *) x));
}
static void *_p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALRasterBandShadow *) x));
}
static swig_type_info _swigt__p_CPLErrorHandler = {"_p_CPLErrorHandler", "CPLErrorHandler *", 0, 0, 0};
static swig_type_info _swigt__p_CPLXMLNode = {"_p_CPLXMLNode", "CPLXMLNode *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorEntry = {"_p_GDALColorEntry", "GDALColorEntry *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorTable = {"_p_GDALColorTable", "GDALColorTable *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDatasetShadow = {"_p_GDALDatasetShadow", "GDALDatasetShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDriverShadow = {"_p_GDALDriverShadow", "GDALDriverShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALMajorObjectShadow = {"_p_GDALMajorObjectShadow", "GDALMajorObjectShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALRasterBandShadow = {"_p_GDALRasterBandShadow", "GDALRasterBandShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDAL_GCP = {"_p_GDAL_GCP", "GDAL_GCP *", 0, 0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|GDALPaletteInterp *", 0, 0, 0};
static swig_type_info _swigt__p_p_CPLXMLNode = {"_p_p_CPLXMLNode", "CPLXMLNode **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDALColorTable = {"_p_p_GDALColorTable", "GDALColorTable **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDALDatasetShadow = {"_p_p_GDALDatasetShadow", "GDALDatasetShadow **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDALDriverShadow = {"_p_p_GDALDriverShadow", "GDALDriverShadow **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDALMajorObjectShadow = {"_p_p_GDALMajorObjectShadow", "GDALMajorObjectShadow **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDALRasterBandShadow = {"_p_p_GDALRasterBandShadow", "GDALRasterBandShadow **", 0, 0, 0};
static swig_type_info _swigt__p_p_GDAL_GCP = {"_p_p_GDAL_GCP", "GDAL_GCP **", 0, 0, 0};
static swig_type_info _swigt__p_p_char = {"_p_p_char", "char **", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_CPLErrorHandler,
  &_swigt__p_CPLXMLNode,
  &_swigt__p_GDALColorEntry,
  &_swigt__p_GDALColorTable,
  &_swigt__p_GDALDatasetShadow,
  &_swigt__p_GDALDriverShadow,
  &_swigt__p_GDALMajorObjectShadow,
  &_swigt__p_GDALRasterBandShadow,
  &_swigt__p_GDAL_GCP,
  &_swigt__p_double,
  &_swigt__p_int,
  &_swigt__p_p_CPLXMLNode,
  &_swigt__p_p_GDALColorTable,
  &_swigt__p_p_GDALDatasetShadow,
  &_swigt__p_p_GDALDriverShadow,
  &_swigt__p_p_GDALMajorObjectShadow,
  &_swigt__p_p_GDALRasterBandShadow,
  &_swigt__p_p_GDAL_GCP,
  &_swigt__p_p_char,
};

static swig_cast_info _swigc__p_CPLErrorHandler[] = {  {&_swigt__p_CPLErrorHandler, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_CPLXMLNode[] = {  {&_swigt__p_CPLXMLNode, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorEntry[] = {  {&_swigt__p_GDALColorEntry, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorTable[] = {  {&_swigt__p_GDALColorTable, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDatasetShadow[] = {  {&_swigt__p_GDALDatasetShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDriverShadow[] = {  {&_swigt__p_GDALDriverShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALMajorObjectShadow[] = {  {&_swigt__p_GDALMajorObjectShadow, 0, 0, 0},  {&_swigt__p_GDALDriverShadow, _p_GDALDriverShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALDatasetShadow, _p_GDALDatasetShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALRasterBandShadow, _p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALRasterBandShadow[] = {  {&_swigt__p_GDALRasterBandShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDAL_GCP[] = {  {&_swigt__p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_CPLXMLNode[] = {  {&_swigt__p_p_CPLXMLNode, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDALColorTable[] = {  {&_swigt__p_p_GDALColorTable, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDALDatasetShadow[] = {  {&_swigt__p_p_GDALDatasetShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDALDriverShadow[] = {  {&_swigt__p_p_GDALDriverShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDALMajorObjectShadow[] = {  {&_swigt__p_p_GDALMajorObjectShadow, 0, 0, 0},  {&_swigt__p_p_GDALDriverShadow, _p_p_GDALDriverShadowTo_p_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_p_GDALDatasetShadow, _p_p_GDALDatasetShadowTo_p_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_p_GDALRasterBandShadow, _p_p_GDALRasterBandShadowTo_p_p_GDALMajorObjectShadow, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDALRasterBandShadow[] = {  {&_swigt__p_p_GDALRasterBandShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDAL_GCP[] = {  {&_swigt__p_p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_char[] = {  {&_swigt__p_p_char, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_CPLErrorHandler,
  _swigc__p_CPLXMLNode,
  _swigc__p_GDALColorEntry,
  _swigc__p_GDALColorTable,
  _swigc__p_GDALDatasetShadow,
  _swigc__p_GDALDriverShadow,
  _swigc__p_GDALMajorObjectShadow,
  _swigc__p_GDALRasterBandShadow,
  _swigc__p_GDAL_GCP,
  _swigc__p_double,
  _swigc__p_int,
  _swigc__p_p_CPLXMLNode,
  _swigc__p_p_GDALColorTable,
  _swigc__p_p_GDALDatasetShadow,
  _swigc__p_p_GDALDriverShadow,
  _swigc__p_p_GDALMajorObjectShadow,
  _swigc__p_p_GDALRasterBandShadow,
  _swigc__p_p_GDAL_GCP,
  _swigc__p_p_char,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/* end header section */
/* vdecl subsection */
static zend_class_entry ce_swig_MajorObject;
static zend_class_entry* ptr_ce_swig_MajorObject=NULL;
static zend_class_entry ce_swig_Driver;
static zend_class_entry* ptr_ce_swig_Driver=NULL;
static zend_class_entry ce_swig_GCP;
static zend_class_entry* ptr_ce_swig_GCP=NULL;
static zend_class_entry ce_swig_Dataset;
static zend_class_entry* ptr_ce_swig_Dataset=NULL;
static zend_class_entry ce_swig_Band;
static zend_class_entry* ptr_ce_swig_Band=NULL;
static zend_class_entry ce_swig_ColorTable;
static zend_class_entry* ptr_ce_swig_ColorTable=NULL;
static int le_swig__p_double=0; /* handle for  */
static int le_swig__p_GDALColorEntry=0; /* handle for  */
static int le_swig__p_p_char=0; /* handle for  */
static int le_swig__p_p_GDAL_GCP=0; /* handle for  */
static int le_swig__p_GDAL_GCP=0; /* handle for GCP */
static int le_swig__p_CPLErrorHandler=0; /* handle for GCP */
static int le_swig__p_CPLXMLNode=0; /* handle for GCP */
static int le_swig__p_p_CPLXMLNode=0; /* handle for GCP */
static int le_swig__p_GDALColorTable=0; /* handle for ColorTable */
static int le_swig__p_p_GDALColorTable=0; /* handle for ColorTable */
static int le_swig__p_int=0; /* handle for ColorTable */
static int le_swig__p_p_GDALRasterBandShadow=0; /* handle for ColorTable */
static int le_swig__p_GDALRasterBandShadow=0; /* handle for Band */
static int le_swig__p_p_GDALDatasetShadow=0; /* handle for Band */
static int le_swig__p_GDALDatasetShadow=0; /* handle for Dataset */
static int le_swig__p_p_GDALDriverShadow=0; /* handle for Dataset */
static int le_swig__p_GDALDriverShadow=0; /* handle for Driver */
static int le_swig__p_p_GDALMajorObjectShadow=0; /* handle for Driver */
static int le_swig__p_GDALMajorObjectShadow=0; /* handle for MajorObject */
/* end vdecl subsection */
/* wrapper section */
ZEND_NAMED_FUNCTION(_wrap_Debug) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    Debug((char const *)arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Error) {
    CPLErr arg1 = (CPLErr) CE_Failure ;
    int arg2 = (int) 0 ;
    char *arg3 = (char *) "error" ;
    zval **args[3];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<0 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    if(arg_count > 0) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[0]);
            arg1 = (CPLErr) Z_LVAL_PP(args[0]);
            /*@@*/;
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[1]);
            arg2 = (int) Z_LVAL_PP(args[1]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[2]);
            arg3 = (char *) Z_STRVAL_PP(args[2]);
            /*@@*/;
        }
    }
    Error(arg1,arg2,(char const *)arg3);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PushErrorHandler__SWIG_0) {
    char *arg1 = (char *) "CPLQuietErrorHandler" ;
    CPLErr result;
    zval **args[1];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<0 || arg_count>1)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    if(arg_count > 0) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[0]);
            arg1 = (char *) Z_STRVAL_PP(args[0]);
            /*@@*/;
        }
    }
    result = (CPLErr)PushErrorHandler((char const *)arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PushErrorHandler__SWIG_1) {
    CPLErrorHandler arg1 ;
    CPLErrorHandler *tmp1 ;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        if(SWIG_ConvertPtr(*args[0], (void **) &tmp1, SWIGTYPE_p_CPLErrorHandler, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of PushErrorHandler. Expected SWIGTYPE_p_CPLErrorHandler");
        }
        arg1 = *tmp1;
    }
    CPLPushErrorHandler(arg1);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PushErrorHandler) {
    int argc;
    zval **argv[1];
    int ii;
    
    argc = ZEND_NUM_ARGS();
    zend_get_parameters_array_ex(argc,argv);
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_PushErrorHandler__SWIG_0(INTERNAL_FUNCTION_PARAM_PASSTHRU);
        }
        _v = (Z_TYPE_PP(argv[0]) == IS_LONG ||
        Z_TYPE_PP(argv[0]) == IS_DOUBLE ||
        Z_TYPE_PP(argv[0]) == IS_STRING) ? 1 : 0; 
        if (_v) {
            return _wrap_PushErrorHandler__SWIG_0(INTERNAL_FUNCTION_PARAM_PASSTHRU);
        }
    }
    if (argc == 1) {
        int _v;
        /* typecheck SWIGTYPE */ 
        if (_v) {
            return _wrap_PushErrorHandler__SWIG_1(INTERNAL_FUNCTION_PARAM_PASSTHRU);
        }
    }
    
    /*No matching function for overloaded 'PushErrorHandler'*/
    
}


ZEND_NAMED_FUNCTION(_wrap_PopErrorHandler) {
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    CPLPopErrorHandler();
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ErrorReset) {
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    CPLErrorReset();
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetLastErrorNo) {
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (int)CPLGetLastErrorNo();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetLastErrorType) {
    CPLErr result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (CPLErr)CPLGetLastErrorType();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetLastErrorMsg) {
    char *result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (char *)CPLGetLastErrorMsg();
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PushFinderLocation) {
    char *arg1 = (char *) 0 ;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    CPLPushFinderLocation((char const *)arg1);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PopFinderLocation) {
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    CPLPopFinderLocation();
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_FinderClean) {
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    CPLFinderClean();
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_FindFile) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_SetConfigOption) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    CPLSetConfigOption((char const *)arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetConfigOption) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    result = (char *)CPLGetConfigOption((char const *)arg1,(char const *)arg2);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_GetDescription) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_GetDescription. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_SetDescription) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_SetDescription. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_GetMetadata_Dict) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) "" ;
    char **result;
    zval **args[1];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_GetMetadata_Dict. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[0]);
            arg2 = (char *) Z_STRVAL_PP(args[0]);
            /*@@*/;
        }
    }
    result = (char **)GDALMajorObjectShadow_GetMetadata_Dict(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) char **dict */
        char **stringarray = result;
        array_init(return_value);
        if ( stringarray != NULL ) {
            while (*stringarray != NULL ) {
                char const *valptr;
                char *keyptr;
                valptr = CPLParseNameValue( *stringarray, &keyptr );
                if ( valptr != 0 ) {
                    add_assoc_string(return_value,keyptr,(char*)valptr,1);
                    CPLFree( keyptr );
                }
                stringarray++;
            }
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_GetMetadata_List) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) "" ;
    char **result;
    zval **args[1];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_GetMetadata_List. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[0]);
            arg2 = (char *) Z_STRVAL_PP(args[0]);
            /*@@*/;
        }
    }
    result = (char **)GDALMajorObjectShadow_GetMetadata_List(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) char ** -> ( string ) */
        char **stringarray = result;
        if ( stringarray == NULL ) {
            RETVAL_NULL();
        }
        else {
            int len = CSLCount( stringarray );
            array_init(return_value);
            for ( int i = 0; i < len; ++i, ++stringarray ) {
                add_next_index_string( return_value, *stringarray, 1 );
            }
            CSLDestroy( result );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_SetMetadata__SWIG_0) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) "" ;
    CPLErr result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<2 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_SetMetadata. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    {
        /* %typemap(in) char **dict */
        zend_error(E_ERROR,"Typemap (in) char **dict not properly defined");
        /*  if ( PySequence_Check( args[0] ) ) {
            int size = PySequence_Size(args[0]);
            for (int i = 0; i < size; i++) {
              char *pszItem = NULL;
              if ( ! PyArg_Parse( PySequence_GetItem(args[0],i), "s", &pszItem ) ) {
                PyErr_SetString(PyExc_TypeError,"sequence must contain strings");
                SWIG_fail;
              }
              arg2 = CSLAddString( arg2, pszItem );
            }
          }
        */
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[1]);
            arg3 = (char *) Z_STRVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(freearg) char **dict */
        CSLDestroy( arg2 );
    }
    return;
    fail:
    {
        /* %typemap(freearg) char **dict */
        CSLDestroy( arg2 );
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_SetMetadata__SWIG_1) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) "" ;
    CPLErr result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<2 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of MajorObject_SetMetadata. Expected SWIGTYPE_p_p_GDALMajorObjectShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[1]);
            arg3 = (char *) Z_STRVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_MajorObject_SetMetadata) {
    int argc;
    zval **argv[3];
    int ii;
    
    argc = ZEND_NUM_ARGS();
    zend_get_parameters_array_ex(argc,argv);
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            /* typecheck SWIGTYPE * */
            void *tmp;
            _v = (SWIG_ConvertPtr( *argv[0], (void**)&tmp, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0)? 0:1;
        }
        if (_v) {
            {
                /* %typecheck(SWIG_TYPECHECK_POINTER) (char **dict) */
                _v = 0; //(PyMapping_Check(argv[1]) || PySequence_Check(argv[1]) ) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_MajorObject_SetMetadata__SWIG_0(INTERNAL_FUNCTION_PARAM_PASSTHRU);
                }
                _v = (Z_TYPE_PP(argv[2]) == IS_LONG ||
                Z_TYPE_PP(argv[2]) == IS_DOUBLE ||
                Z_TYPE_PP(argv[2]) == IS_STRING) ? 1 : 0; 
                if (_v) {
                    return _wrap_MajorObject_SetMetadata__SWIG_0(INTERNAL_FUNCTION_PARAM_PASSTHRU);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            /* typecheck SWIGTYPE * */
            void *tmp;
            _v = (SWIG_ConvertPtr( *argv[0], (void**)&tmp, SWIGTYPE_p_GDALMajorObjectShadow, 0) < 0)? 0:1;
        }
        if (_v) {
            _v = (Z_TYPE_PP(argv[1]) == IS_LONG ||
            Z_TYPE_PP(argv[1]) == IS_DOUBLE ||
            Z_TYPE_PP(argv[1]) == IS_STRING) ? 1 : 0; 
            if (_v) {
                if (argc <= 2) {
                    return _wrap_MajorObject_SetMetadata__SWIG_1(INTERNAL_FUNCTION_PARAM_PASSTHRU);
                }
                _v = (Z_TYPE_PP(argv[2]) == IS_LONG ||
                Z_TYPE_PP(argv[2]) == IS_DOUBLE ||
                Z_TYPE_PP(argv[2]) == IS_STRING) ? 1 : 0; 
                if (_v) {
                    return _wrap_MajorObject_SetMetadata__SWIG_1(INTERNAL_FUNCTION_PARAM_PASSTHRU);
                }
            }
        }
    }
    
    /*No matching function for overloaded 'MajorObject_SetMetadata'*/
    
}


/* property handler for class MajorObject */
static pval _wrap_propget_MajorObject(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_MajorObject(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_MajorObject(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  return FAILURE;
}

static int _wrap_propset_MajorObject(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_MajorObject(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is MajorObject */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_MajorObject(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  return FAILURE;
}

static pval _wrap_Driver_ShortName_get(zend_property_reference *property_reference) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_ShortName_get. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    result = (char *)GDALDriverShadow_ShortName_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Driver_LongName_get(zend_property_reference *property_reference) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_LongName_get. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    result = (char *)GDALDriverShadow_LongName_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Driver_HelpTopic_get(zend_property_reference *property_reference) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_HelpTopic_get. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Driver_Create) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 ;
    int arg4 ;
    int arg5 = (int) 1 ;
    GDALDataType arg6 = (GDALDataType) GDT_Byte ;
    char **arg7 = (char **) 0 ;
    GDALDatasetShadow *result;
    zval **args[6];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<4 || arg_count>7)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_Create. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[1]);
        arg3 = (int) Z_LVAL_PP(args[1]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[2]);
        arg4 = (int) Z_LVAL_PP(args[2]);
        /*@@*/;
    }
    if(arg_count > 4) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[3]);
            arg5 = (int) Z_LVAL_PP(args[3]);
            /*@@*/;
        }
    }
    if(arg_count > 5) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[4]);
            arg6 = (GDALDataType) Z_LVAL_PP(args[4]);
            /*@@*/;
        }
    }
    if(arg_count > 6) {
        {
            /* %typemap(in) char **options */
            zend_error(E_ERROR,"Typemap (in) char **options not properly defined");
            //  int size = PySequence_Size(args[5]);
            //  for (int i = 0; i < size; i++) {
            //    char *pszItem = NULL;
            //    if ( ! PyArg_Parse( PySequence_GetItem(args[5],i), "s", &pszItem ) ) {
            //      PyErr_SetString(PyExc_TypeError,"sequence must contain strings");
            //      SWIG_fail;
            //    }
            //    arg7 = CSLAddString( arg7, pszItem );
            //  }
        }
    }
    result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDatasetShadow, 1);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Dataset);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg7 );
    }
    return;
    fail:
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg7 );
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Driver_CreateCopy) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
    int arg4 = (int) 1 ;
    char **arg5 = (char **) 0 ;
    GDALDatasetShadow *result;
    zval **args[4];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<3 || arg_count>5)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_CreateCopy. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[1], (void **) &arg3, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 3 of Driver_CreateCopy. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    if(arg_count > 3) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[2]);
            arg4 = (int) Z_LVAL_PP(args[2]);
            /*@@*/;
        }
    }
    if(arg_count > 4) {
        {
            /* %typemap(in) char **options */
            zend_error(E_ERROR,"Typemap (in) char **options not properly defined");
            //  int size = PySequence_Size(args[3]);
            //  for (int i = 0; i < size; i++) {
            //    char *pszItem = NULL;
            //    if ( ! PyArg_Parse( PySequence_GetItem(args[3],i), "s", &pszItem ) ) {
            //      PyErr_SetString(PyExc_TypeError,"sequence must contain strings");
            //      SWIG_fail;
            //    }
            //    arg5 = CSLAddString( arg5, pszItem );
            //  }
        }
    }
    result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDatasetShadow, 1);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Dataset);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg5 );
    }
    return;
    fail:
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg5 );
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Driver_Delete) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Driver_Delete. Expected SWIGTYPE_p_p_GDALDriverShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    result = (int)GDALDriverShadow_Delete(arg1,(char const *)arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* property handler for class Driver */
static pval _wrap_propget_Driver(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_Driver(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_Driver(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  if (strcmp(propname,"HelpTopic")==0) {
    *value=_wrap_Driver_HelpTopic_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"ShortName")==0) {
    *value=_wrap_Driver_ShortName_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"LongName")==0) {
    *value=_wrap_Driver_LongName_get(property_reference);
    return SUCCESS;
  } else  {
    /* chain to base class */
    if (_propget_MajorObject(property_reference,  value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

static int _wrap_propset_Driver(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_Driver(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is Driver */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_Driver(zend_property_reference *property_reference, pval *value) {
  /* No extra properties for subclass Driver */
  {
    /* chain to base class */
    if (_propset_MajorObject(property_reference, value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

static int _wrap_GCP_GCPX_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPX_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(&value);
        arg2 = (double) Z_DVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_GCPX_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_GCPX_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPX_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPX_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_GCPY_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPY_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(&value);
        arg2 = (double) Z_DVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_GCPY_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_GCPY_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPY_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPY_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_GCPZ_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPZ_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(&value);
        arg2 = (double) Z_DVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_GCPZ_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_GCPZ_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPZ_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_GCPPixel_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPPixel_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(&value);
        arg2 = (double) Z_DVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_GCPPixel_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPPixel_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_GCPLine_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPLine_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(&value);
        arg2 = (double) Z_DVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_GCPLine_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_GCPLine_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_GCPLine_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_Info_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_Info_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(&value);
        arg2 = (char *) Z_STRVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_Info_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_Info_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_Info_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_Info_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static int _wrap_GCP_Id_set(zend_property_reference *property_reference, pval *value) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_Id_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(&value);
        arg2 = (char *) Z_STRVAL_PP(&value);
        /*@@*/;
    }
    GDAL_GCP_Id_set(arg1,arg2);
    
    
    return SUCCESS;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_GCP_Id_get(zend_property_reference *property_reference) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GCP_Id_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_Id_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_new_GCP) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 0.0 ;
    double arg3 = (double) 0.0 ;
    double arg4 = (double) 0.0 ;
    double arg5 = (double) 0.0 ;
    char *arg6 = (char *) "" ;
    char *arg7 = (char *) "" ;
    GDAL_GCP *result;
    zval **args[7];
    int arg_count;
    
    SWIG_ResetError();
    /* NATIVE Constructor */
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<0 || arg_count>7)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    if(arg_count > 0) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[0]);
            arg1 = (double) Z_DVAL_PP(args[0]);
            /*@@*/;
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[1]);
            arg2 = (double) Z_DVAL_PP(args[1]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[2]);
            arg3 = (double) Z_DVAL_PP(args[2]);
            /*@@*/;
        }
    }
    if(arg_count > 3) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[3]);
            arg4 = (double) Z_DVAL_PP(args[3]);
            /*@@*/;
        }
    }
    if(arg_count > 4) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[4]);
            arg5 = (double) Z_DVAL_PP(args[4]);
            /*@@*/;
        }
    }
    if(arg_count > 5) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[5]);
            arg6 = (char *) Z_STRVAL_PP(args[5]);
            /*@@*/;
        }
    }
    if(arg_count > 6) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[6]);
            arg7 = (char *) Z_STRVAL_PP(args[6]);
            /*@@*/;
        }
    }
    result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDAL_GCP, 1);
    }
    /* Wrap this return value */
    if (this_ptr) {
        /* NATIVE Constructor, use this_ptr */
        zval *_cPtr; MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        add_property_zval(this_ptr,"_cPtr",_cPtr);
    } else if (! this_ptr) {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_GCP);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* This function is designed to be called by the zend list destructors */
/* to typecast and do the actual destruction */
void __wrap_delete_GCP(zend_rsrc_list_entry *rsrc, const char *type_name TSRMLS_DC) {
    swig_object_wrapper *value=(swig_object_wrapper *) rsrc->ptr ;
    void *ptr=value->ptr ;
    int newobject=value->newobject ;
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    
    efree(value);
    if (! newobject) return; /* can't delete it! */
    SWIG_ZTS_ConvertResourceData(ptr,rsrc->type,type_name,(void **) &arg1,SWIGTYPE_p_GDAL_GCP TSRMLS_CC);
    if (! arg1) zend_error(E_ERROR, "GDAL_GCP resource already free'd");
    delete_GDAL_GCP(arg1);
    
}


/* property handler for class GCP */
static pval _wrap_propget_GCP(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_GCP(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_GCP(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  if (strcmp(propname,"GCPLine")==0) {
    *value=_wrap_GCP_GCPLine_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"Id")==0) {
    *value=_wrap_GCP_Id_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"GCPX")==0) {
    *value=_wrap_GCP_GCPX_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"GCPZ")==0) {
    *value=_wrap_GCP_GCPZ_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"GCPPixel")==0) {
    *value=_wrap_GCP_GCPPixel_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"Info")==0) {
    *value=_wrap_GCP_Info_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"GCPY")==0) {
    *value=_wrap_GCP_GCPY_get(property_reference);
    return SUCCESS;
  } else  return FAILURE;
}

static int _wrap_propset_GCP(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_GCP(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is GCP */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_GCP(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  if (strcmp(propname,"GCPPixel")==0) {
    return _wrap_GCP_GCPPixel_set(property_reference, value);
  } else  if (strcmp(propname,"Info")==0) {
    return _wrap_GCP_Info_set(property_reference, value);
  } else  if (strcmp(propname,"GCPY")==0) {
    return _wrap_GCP_GCPY_set(property_reference, value);
  } else  if (strcmp(propname,"GCPLine")==0) {
    return _wrap_GCP_GCPLine_set(property_reference, value);
  } else  if (strcmp(propname,"Id")==0) {
    return _wrap_GCP_Id_set(property_reference, value);
  } else  if (strcmp(propname,"GCPX")==0) {
    return _wrap_GCP_GCPX_set(property_reference, value);
  } else  if (strcmp(propname,"GCPZ")==0) {
    return _wrap_GCP_GCPZ_set(property_reference, value);
  } else  return FAILURE;
}

ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPX_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPX_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPX_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPX_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPX_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_GCPX_set(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPY_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPY_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPY_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPY_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPY_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_GCPY_set(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPZ_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPZ_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPZ_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPZ_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_GCPZ_set(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPPixel_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPPixel_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPPixel_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPPixel_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPLine_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPLine_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_GCPLine_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_GCPLine_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_GCPLine_set(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_Info_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_Info_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_Info_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_Info_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_Info_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_Info_set(arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_Id_get) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_Id_get. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_Id_get(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_Id_set) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_Id_set. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_Id_set(arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_GCPX) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_GCPX. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_get_GCPX(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_GCPX) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_GCPX. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_GCPX(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_GCPY) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_GCPY. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_get_GCPY(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_GCPY) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_GCPY. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_GCPY(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_GCPZ) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_GCPZ. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_get_GCPZ(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_GCPZ) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_GCPZ. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_GCPZ(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_GCPPixel) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_GCPPixel. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_get_GCPPixel(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_GCPPixel) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_GCPPixel. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_GCPPixel(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_GCPLine) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_GCPLine. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (double)GDAL_GCP_get_GCPLine(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_GCPLine) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_GCPLine. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[1]);
        arg2 = (double) Z_DVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_GCPLine(arg1,arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_Info) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_Info. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_get_Info(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_Info) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_Info. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_Info(arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_get_Id) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_get_Id. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    result = (char *)GDAL_GCP_get_Id(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GDAL_GCP_set_Id) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of GDAL_GCP_set_Id. Expected SWIGTYPE_p_p_GDAL_GCP");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    GDAL_GCP_set_Id(arg1,(char const *)arg2);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GCPsToGeoTransform) {
    int arg1 ;
    GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
    double *arg3 ;
    int arg4 = (int) 1 ;
    FALSE_IS_ERR result;
    GDAL_GCP *tmpGCPList1 ;
    double argout3[6] ;
    zval **args[2];
    int arg_count;
    
    {
        /* %typemap(in,numinputs=0) (double argout3[ANY]) */
        arg3 = argout3;
    }
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* %typemap(in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[1]);
            arg4 = (int) Z_LVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
    
    {
        /* %typemap(out) IF_FALSE_RETURN_NONE */
        RETVAL_NULL();  
    }
    {
        /* %typemap(argout) (double argout[ANY]) */
        zval *t = CreateTupleFromDoubleArray( arg3, 6 );
        t_output_helper( &return_value, t );
    }
    {
        /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg2) {
            free( (void*) arg2 );
        }
    }
    {
        /* %typemap(ret) IF_FALSE_RETURN_NONE */
        RETVAL_NULL();
    }
    return;
    fail:
    {
        /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg2) {
            free( (void*) arg2 );
        }
    }
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Dataset_RasterXSize_get(zend_property_reference *property_reference) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_RasterXSize_get. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Dataset_RasterYSize_get(zend_property_reference *property_reference) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_RasterYSize_get. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Dataset_RasterCount_get(zend_property_reference *property_reference) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_RasterCount_get. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (int)GDALDatasetShadow_RasterCount_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* This function is designed to be called by the zend list destructors */
/* to typecast and do the actual destruction */
void __wrap_delete_Dataset(zend_rsrc_list_entry *rsrc, const char *type_name TSRMLS_DC) {
    swig_object_wrapper *value=(swig_object_wrapper *) rsrc->ptr ;
    void *ptr=value->ptr ;
    int newobject=value->newobject ;
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    
    efree(value);
    if (! newobject) return; /* can't delete it! */
    SWIG_ZTS_ConvertResourceData(ptr,rsrc->type,type_name,(void **) &arg1,SWIGTYPE_p_GDALDatasetShadow TSRMLS_CC);
    if (! arg1) zend_error(E_ERROR, "GDALDatasetShadow resource already free'd");
    delete_GDALDatasetShadow(arg1);
    
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetDriver) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    GDALDriverShadow *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetDriver. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDriverShadow, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Driver);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetRasterBand) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    GDALRasterBandShadow *result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetRasterBand. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALRasterBandShadow, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Band);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetProjection) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetProjection. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (char *)GDALDatasetShadow_GetProjection(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetProjectionRef) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetProjectionRef. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_SetProjection) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    CPLErr result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_SetProjection. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg2 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetGeoTransform) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    double *arg2 ;
    double argout2[6] ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetGeoTransform. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    GDALDatasetShadow_GetGeoTransform(arg1,arg2);
    
    
    {
        /* %typemap(argout) (double argout[ANY]) */
        zval *t = CreateTupleFromDoubleArray( arg2, 6 );
        t_output_helper( &return_value, t );
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_SetGeoTransform) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    double *arg2 ;
    CPLErr result;
    double argin2[6] ;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_SetGeoTransform. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    {
        /* %typemap(in) (double argin2[ANY]) */
        arg2 = argin2;
        for (unsigned int i=0; i<6; i++) {
            double val = 0.0; /* extract val from i-th position of args[0] */
            arg2[i] =  val;
        }
    }
    result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_BuildOverviews) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) "NEAREST" ;
    int arg3 = (int) 0 ;
    int *arg4 = (int *) 0 ;
    int result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_BuildOverviews. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[0]);
            arg2 = (char *) Z_STRVAL_PP(args[0]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /* %typemap(in,numinputs=1) (int nList, int* pList)*/
            zend_error(E_ERROR,"Typemap (in,numinputs=1) (int nList, int*pList) not properly defined");
            /* check if is List */
            //  if ( !PySequence_Check(args[1]) ) {
            //    PyErr_SetString(PyExc_TypeError, "not a sequence");
            //    SWIG_fail;
            //  }
            //  arg3 = PySequence_Size(args[1]);
            //  arg4 = (int*) malloc(arg3*sizeof(int));
            //  for( int i = 0; i<arg3; i++ ) {
            //    PyObject *o = PySequence_GetItem(args[1],i);
            //    if ( !PyArg_Parse(o,"i",&arg4[i]) ) {
            //      SWIG_fail;
            //    }
            //  }
        }
    }
    result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(freearg) (int nList, int* pList) */
        if (arg4) {
            free((void*) arg4);
        }
    }
    return;
    fail:
    {
        /* %typemap(freearg) (int nList, int* pList) */
        if (arg4) {
            free((void*) arg4);
        }
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetGCPCount) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetGCPCount. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (int)GDALDatasetShadow_GetGCPCount(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetGCPProjection) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetGCPProjection. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_GetGCPs) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int *arg2 = (int *) 0 ;
    GDAL_GCP **arg3 = (GDAL_GCP **) 0 ;
    int nGCPs2 = 0 ;
    GDAL_GCP *pGCPs2 = 0 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (int *nGCPs2, GDAL_GCP const **pGCPs2 ) */
        arg2 = &nGCPs2;
        arg3 = &pGCPs2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_GetGCPs. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    GDALDatasetShadow_GetGCPs(arg1,arg2,(GDAL_GCP const **)arg3);
    
    
    {
        /* %typemap(argout) (int *nGCPs, GDAL_GCP const **pGCPs ) */
        zval *out;
        MAKE_STD_ZVAL(out);
        array_init(out);
        for( int i = 0; i < *arg2; i++ ) {
            GDAL_GCP *o = new_GDAL_GCP( (*arg3)[i].dfGCPX,
            (*arg3)[i].dfGCPY,
            (*arg3)[i].dfGCPZ,
            (*arg3)[i].dfGCPPixel,
            (*arg3)[i].dfGCPLine,
            (*arg3)[i].pszInfo,
            (*arg3)[i].pszId );
            zval *t;
            MAKE_STD_ZVAL(t);
            SWIG_SetPointerZval(t,(void*)o,SWIGTYPE_p_GDAL_GCP,1);
            add_next_index_zval(out,t);
        }
        return_value = out;
        zval_copy_ctor(return_value);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_SetGCPs) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
    char *arg4 = (char *) 0 ;
    CPLErr result;
    GDAL_GCP *tmpGCPList2 ;
    zval **args[2];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_SetGCPs. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    {
        /* %typemap(in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg4 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    result = (CPLErr)GDALDatasetShadow_SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg3) {
            free( (void*) arg3 );
        }
    }
    return;
    fail:
    {
        /* %typemap(freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg3) {
            free( (void*) arg3 );
        }
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_FlushCache) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_FlushCache. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    GDALDatasetShadow_FlushCache(arg1);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_AddBand) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    GDALDataType arg2 = (GDALDataType) GDT_Byte ;
    char **arg3 = (char **) 0 ;
    CPLErr result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_AddBand. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[0]);
            arg2 = (GDALDataType) Z_LVAL_PP(args[0]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /* %typemap(in) char **options */
            zend_error(E_ERROR,"Typemap (in) char **options not properly defined");
            //  int size = PySequence_Size(args[1]);
            //  for (int i = 0; i < size; i++) {
            //    char *pszItem = NULL;
            //    if ( ! PyArg_Parse( PySequence_GetItem(args[1],i), "s", &pszItem ) ) {
            //      PyErr_SetString(PyExc_TypeError,"sequence must contain strings");
            //      SWIG_fail;
            //    }
            //    arg3 = CSLAddString( arg3, pszItem );
            //  }
        }
    }
    result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg3 );
    }
    return;
    fail:
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg3 );
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Dataset_WriteRaster) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    char *arg7 = (char *) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    GDALDataType *arg10 = (GDALDataType *) 0 ;
    int arg11 = (int) 0 ;
    int *arg12 = (int *) 0 ;
    CPLErr result;
    int val8 ;
    int val9 ;
    GDALDataType val10 ;
    zval **args[9];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<6 || arg_count>10)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Dataset_WriteRaster. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[1]);
        arg3 = (int) Z_LVAL_PP(args[1]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[2]);
        arg4 = (int) Z_LVAL_PP(args[2]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[3]);
        arg5 = (int) Z_LVAL_PP(args[3]);
        /*@@*/;
    }
    {
        /* %typemap(in,numinputs=1) (int nLen, char *pBuf ) */
        convert_to_string_ex(args[4]);
        arg7 = Z_STRVAL_PP(args[4]);
        arg6 = Z_STRLEN_PP(args[4]);
    }
    if(arg_count > 6) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[5]) ) {
                arg8 = 0;
            }
            convert_to_long_ex(args[5]);
            val8 = (int) Z_LVAL_PP( args[5] );
            arg8 = &val8;  
        }
    }
    if(arg_count > 7) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[6]) ) {
                arg9 = 0;
            }
            convert_to_long_ex(args[6]);
            val9 = (int) Z_LVAL_PP( args[6] );
            arg9 = &val9;  
        }
    }
    if(arg_count > 8) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[7]) ) {
                arg10 = 0;
            }
            convert_to_long_ex(args[7]);
            val10 = (GDALDataType) Z_LVAL_PP( args[7] );
            arg10 = &val10;  
        }
    }
    if(arg_count > 9) {
        {
            /* %typemap(in,numinputs=1) (int nList, int* pList)*/
            zend_error(E_ERROR,"Typemap (in,numinputs=1) (int nList, int*pList) not properly defined");
            /* check if is List */
            //  if ( !PySequence_Check(args[8]) ) {
            //    PyErr_SetString(PyExc_TypeError, "not a sequence");
            //    SWIG_fail;
            //  }
            //  arg11 = PySequence_Size(args[8]);
            //  arg12 = (int*) malloc(arg11*sizeof(int));
            //  for( int i = 0; i<arg11; i++ ) {
            //    PyObject *o = PySequence_GetItem(args[8],i);
            //    if ( !PyArg_Parse(o,"i",&arg12[i]) ) {
            //      SWIG_fail;
            //    }
            //  }
        }
    }
    result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(freearg) (int nList, int* pList) */
        if (arg12) {
            free((void*) arg12);
        }
    }
    return;
    fail:
    {
        /* %typemap(freearg) (int nList, int* pList) */
        if (arg12) {
            free((void*) arg12);
        }
    }
    zend_error(ErrorCode(),ErrorMsg());
}


/* property handler for class Dataset */
static pval _wrap_propget_Dataset(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_Dataset(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_Dataset(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  if (strcmp(propname,"RasterXSize")==0) {
    *value=_wrap_Dataset_RasterXSize_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"RasterYSize")==0) {
    *value=_wrap_Dataset_RasterYSize_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"RasterCount")==0) {
    *value=_wrap_Dataset_RasterCount_get(property_reference);
    return SUCCESS;
  } else  {
    /* chain to base class */
    if (_propget_MajorObject(property_reference,  value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

static int _wrap_propset_Dataset(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_Dataset(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is Dataset */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_Dataset(zend_property_reference *property_reference, pval *value) {
  /* No extra properties for subclass Dataset */
  {
    /* chain to base class */
    if (_propset_MajorObject(property_reference, value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

static pval _wrap_Band_XSize_get(zend_property_reference *property_reference) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_XSize_get. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (int)GDALRasterBandShadow_XSize_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Band_YSize_get(zend_property_reference *property_reference) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_YSize_get. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (int)GDALRasterBandShadow_YSize_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


static pval _wrap_Band_DataType_get(zend_property_reference *property_reference) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALDataType result;
    zval **args[1];
    zval _return_value;
    zval *return_value=&_return_value;
    
    SWIG_ResetError();
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&(property_reference->object), (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_DataType_get. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return _return_value;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetRasterColorInterpretation) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorInterp result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetRasterColorInterpretation. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_SetRasterColorInterpretation) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorInterp arg2 ;
    CPLErr result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_SetRasterColorInterpretation. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (GDALColorInterp) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetNoDataValue) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetNoDataValue. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double *val, int*hasval) */
        if ( !*arg3 ) {
            RETVAL_NULL();
        }
        else {
            RETVAL_DOUBLE( *arg2 );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_SetNoDataValue) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double arg2 ;
    CPLErr result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_SetNoDataValue. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[0]);
        arg2 = (double) Z_DVAL_PP(args[0]);
        /*@@*/;
    }
    result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetMinimum) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetMinimum. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double *val, int*hasval) */
        if ( !*arg3 ) {
            RETVAL_NULL();
        }
        else {
            RETVAL_DOUBLE( *arg2 );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetMaximum) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetMaximum. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double *val, int*hasval) */
        if ( !*arg3 ) {
            RETVAL_NULL();
        }
        else {
            RETVAL_DOUBLE( *arg2 );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetOffset) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetOffset. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double *val, int*hasval) */
        if ( !*arg3 ) {
            RETVAL_NULL();
        }
        else {
            RETVAL_DOUBLE( *arg2 );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetScale) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    zval **args[0];
    
    {
        /* %typemap(in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetScale. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double *val, int*hasval) */
        if ( !*arg3 ) {
            RETVAL_NULL();
        }
        else {
            RETVAL_DOUBLE( *arg2 );
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetOverviewCount) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetOverviewCount. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetOverview) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    GDALRasterBandShadow *result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetOverview. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALRasterBandShadow, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Band);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_Checksum) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 = (int) 0 ;
    int arg3 = (int) 0 ;
    int *arg4 = (int *) 0 ;
    int *arg5 = (int *) 0 ;
    int result;
    int val4 ;
    int val5 ;
    zval **args[4];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>5)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_Checksum. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[0]);
            arg2 = (int) Z_LVAL_PP(args[0]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[1]);
            arg3 = (int) Z_LVAL_PP(args[1]);
            /*@@*/;
        }
    }
    if(arg_count > 3) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[2]) ) {
                arg4 = 0;
            }
            convert_to_long_ex(args[2]);
            val4 = (int) Z_LVAL_PP( args[2] );
            arg4 = &val4;  
        }
    }
    if(arg_count > 4) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[3]) ) {
                arg5 = 0;
            }
            convert_to_long_ex(args[3]);
            val5 = (int) Z_LVAL_PP( args[3] );
            arg5 = &val5;  
        }
    }
    result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_ComputeRasterMinMax) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 ;
    int arg3 = (int) 0 ;
    double argout2[2] ;
    zval **args[1];
    int arg_count;
    
    {
        /* %typemap(in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_ComputeRasterMinMax. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[0]);
            arg3 = (int) Z_LVAL_PP(args[0]);
            /*@@*/;
        }
    }
    GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
    
    
    {
        /* %typemap(argout) (double argout[ANY]) */
        zval *t = CreateTupleFromDoubleArray( arg2, 2 );
        t_output_helper( &return_value, t );
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_Fill) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double arg2 ;
    double arg3 = (double) 0.0 ;
    CPLErr result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<2 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_Fill. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[0]);
        arg2 = (double) Z_DVAL_PP(args[0]);
        /*@@*/;
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[1]);
            arg3 = (double) Z_DVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_ReadRaster) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int *arg6 = (int *) 0 ;
    char **arg7 = (char **) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    int *arg10 = (int *) 0 ;
    CPLErr result;
    int nLen6 = 0 ;
    char *pBuf6 = 0 ;
    int val8 ;
    int val9 ;
    int val10 ;
    zval **args[7];
    int arg_count;
    
    {
        /* %typemap(in,numinputs=0) (int *nLen6, char **pBuf6 ) */
        arg6 = &nLen6;
        arg7 = &pBuf6;
    }
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<5 || arg_count>8)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_ReadRaster. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[1]);
        arg3 = (int) Z_LVAL_PP(args[1]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[2]);
        arg4 = (int) Z_LVAL_PP(args[2]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[3]);
        arg5 = (int) Z_LVAL_PP(args[3]);
        /*@@*/;
    }
    if(arg_count > 5) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[4]) ) {
                arg8 = 0;
            }
            convert_to_long_ex(args[4]);
            val8 = (int) Z_LVAL_PP( args[4] );
            arg8 = &val8;  
        }
    }
    if(arg_count > 6) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[5]) ) {
                arg9 = 0;
            }
            convert_to_long_ex(args[5]);
            val9 = (int) Z_LVAL_PP( args[5] );
            arg9 = &val9;  
        }
    }
    if(arg_count > 7) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[6]) ) {
                arg10 = 0;
            }
            convert_to_long_ex(args[6]);
            val10 = (int) Z_LVAL_PP( args[6] );
            arg10 = &val10;  
        }
    }
    result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    
    {
        ZVAL_LONG(return_value,result);
    }
    {
        /* %typemap(argout) (int *nLen, char **pBuf ) */
        ZVAL_STRINGL( return_value, *arg7, *arg6, 1 );
    }
    {
        /* %typemap(freearg) (int *nLen, char **pBuf ) */
        if( *arg6 ) {
            free( *arg7 );
        }
    }
    return;
    fail:
    {
        /* %typemap(freearg) (int *nLen, char **pBuf ) */
        if( *arg6 ) {
            free( *arg7 );
        }
    }
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_WriteRaster) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    char *arg7 = (char *) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    int *arg10 = (int *) 0 ;
    CPLErr result;
    int val8 ;
    int val9 ;
    int val10 ;
    zval **args[8];
    int arg_count;
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<6 || arg_count>9)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_WriteRaster. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[1]);
        arg3 = (int) Z_LVAL_PP(args[1]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[2]);
        arg4 = (int) Z_LVAL_PP(args[2]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[3]);
        arg5 = (int) Z_LVAL_PP(args[3]);
        /*@@*/;
    }
    {
        /* %typemap(in,numinputs=1) (int nLen, char *pBuf ) */
        convert_to_string_ex(args[4]);
        arg7 = Z_STRVAL_PP(args[4]);
        arg6 = Z_STRLEN_PP(args[4]);
    }
    if(arg_count > 6) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[5]) ) {
                arg8 = 0;
            }
            convert_to_long_ex(args[5]);
            val8 = (int) Z_LVAL_PP( args[5] );
            arg8 = &val8;  
        }
    }
    if(arg_count > 7) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[6]) ) {
                arg9 = 0;
            }
            convert_to_long_ex(args[6]);
            val9 = (int) Z_LVAL_PP( args[6] );
            arg9 = &val9;  
        }
    }
    if(arg_count > 8) {
        {
            /* %typemap(in) (int *optional_int) */
            if ( ZVAL_IS_NULL(*args[7]) ) {
                arg10 = 0;
            }
            convert_to_long_ex(args[7]);
            val10 = (int) Z_LVAL_PP( args[7] );
            arg10 = &val10;  
        }
    }
    result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_FlushCache) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_FlushCache. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    GDALRasterBandShadow_FlushCache(arg1);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_GetRasterColorTable) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorTable *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_GetRasterColorTable. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    result = (GDALColorTable *)GDALRasterBandShadow_GetRasterColorTable(arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALColorTable, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_ColorTable);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Band_SetRasterColorTable) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorTable *arg2 = (GDALColorTable *) 0 ;
    int result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of Band_SetRasterColorTable. Expected SWIGTYPE_p_p_GDALRasterBandShadow");
        }
    }
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg2, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 2 of Band_SetRasterColorTable. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* property handler for class Band */
static pval _wrap_propget_Band(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_Band(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_Band(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  if (strcmp(propname,"XSize")==0) {
    *value=_wrap_Band_XSize_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"YSize")==0) {
    *value=_wrap_Band_YSize_get(property_reference);
    return SUCCESS;
  } else  if (strcmp(propname,"DataType")==0) {
    *value=_wrap_Band_DataType_get(property_reference);
    return SUCCESS;
  } else  {
    /* chain to base class */
    if (_propget_MajorObject(property_reference,  value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

static int _wrap_propset_Band(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_Band(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is Band */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_Band(zend_property_reference *property_reference, pval *value) {
  /* No extra properties for subclass Band */
  {
    /* chain to base class */
    if (_propset_MajorObject(property_reference, value)==SUCCESS) return SUCCESS;
  }
  return FAILURE;
}

ZEND_NAMED_FUNCTION(_wrap_new_ColorTable) {
    GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
    GDALColorTable *result;
    zval **args[1];
    int arg_count;
    
    SWIG_ResetError();
    /* NATIVE Constructor */
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<0 || arg_count>1)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    if(arg_count > 0) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[0]);
            arg1 = (GDALPaletteInterp) Z_LVAL_PP(args[0]);
            /*@@*/;
        }
    }
    result = (GDALColorTable *)new GDALColorTable(arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALColorTable, 1);
    }
    /* Wrap this return value */
    if (this_ptr) {
        /* NATIVE Constructor, use this_ptr */
        zval *_cPtr; MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        add_property_zval(this_ptr,"_cPtr",_cPtr);
    } else if (! this_ptr) {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_ColorTable);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* This function is designed to be called by the zend list destructors */
/* to typecast and do the actual destruction */
void __wrap_delete_ColorTable(zend_rsrc_list_entry *rsrc, const char *type_name TSRMLS_DC) {
    swig_object_wrapper *value=(swig_object_wrapper *) rsrc->ptr ;
    void *ptr=value->ptr ;
    int newobject=value->newobject ;
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    
    efree(value);
    if (! newobject) return; /* can't delete it! */
    SWIG_ZTS_ConvertResourceData(ptr,rsrc->type,type_name,(void **) &arg1,SWIGTYPE_p_GDALColorTable TSRMLS_CC);
    if (! arg1) zend_error(E_ERROR, "GDALColorTable resource already free'd");
    delete arg1;
    
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_Clone) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    GDALColorTable *result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_Clone. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    result = (GDALColorTable *)((GDALColorTable const *)arg1)->Clone();
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALColorTable, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_ColorTable);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_GetPaletteInterpretation) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    GDALPaletteInterp result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_GetPaletteInterpretation. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    result = (GDALPaletteInterp)((GDALColorTable const *)arg1)->GetPaletteInterpretation();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_GetCount) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_GetCount. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    result = (int)((GDALColorTable const *)arg1)->GetColorEntryCount();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_GetColorEntry) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *result;
    zval **args[1];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_GetColorEntry. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALColorEntry *)(arg1)->GetColorEntry(arg2);
    
    {
        /* %typemap(out) GDALColorEntry* */
        array_init(return_value);
        add_next_index_long(return_value,(*result).c1);
        add_next_index_long(return_value,(*result).c2);
        add_next_index_long(return_value,(*result).c3);
        add_next_index_long(return_value,(*result).c4);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_GetColorEntryAsRGB) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
    int result;
    zval **args[2];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_GetColorEntryAsRGB. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /* %typemap(in) GDALColorEntry* */
        GDALColorEntry ce = {
            255,255,255,255
        };
        // Need to parse the array values from args[1]
        arg3 = &ce;
    }
    result = (int)((GDALColorTable const *)arg1)->GetColorEntryAsRGB(arg2,arg3);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ColorTable_SetColorEntry) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
    zval **args[2];
    
    SWIG_ResetError();
    /* This function uses a this_ptr*/
    if(((ZEND_NUM_ARGS() )!= 2) || (zend_get_parameters_array_ex(2, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*&this_ptr, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of ColorTable_SetColorEntry. Expected SWIGTYPE_p_p_GDALColorTable");
        }
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg2 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /* %typemap(in) GDALColorEntry* */
        GDALColorEntry ce = {
            255,255,255,255
        };
        // Need to parse the array values from args[1]
        arg3 = &ce;
    }
    (arg1)->SetColorEntry(arg2,(GDALColorEntry const *)arg3);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* property handler for class ColorTable */
static pval _wrap_propget_ColorTable(zend_property_reference *property_reference) {
  pval result;
  pval **_result;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  result.type = IS_NULL;
  if (_propget_ColorTable(property_reference, &result)==SUCCESS) return result;
  /* return it ourselves */
  if (zend_hash_find(Z_OBJPROP_P(property_reference->object),Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),(void**)&_result)==SUCCESS) {
  zval *_value;
  MAKE_STD_ZVAL(_value);  *_value=**_result;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return *_value;
  }
  result.type = IS_NULL;
  return result;
}
static int _propget_ColorTable(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  return FAILURE;
}

static int _wrap_propset_ColorTable(zend_property_reference *property_reference, pval *value) { 
  zval * _value;
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  if (_propset_ColorTable(property_reference, value)==SUCCESS) return SUCCESS;
  /* set it ourselves as it is ColorTable */
  MAKE_STD_ZVAL(_value);
  *_value=*value;
  INIT_PZVAL(_value);
  zval_copy_ctor(_value);
  return add_property_zval_ex(property_reference->object,Z_STRVAL_P(&(property->element)),1+Z_STRLEN_P(&(property->element)),_value);
}
static int _propset_ColorTable(zend_property_reference *property_reference, pval *value) {
  /* get the property name */
  zend_llist_element *element = property_reference->elements_list->head;
  zend_overloaded_element *property=(zend_overloaded_element *)element->data;
  char *propname=Z_STRVAL_P(&(property->element));
  return FAILURE;
}

ZEND_NAMED_FUNCTION(_wrap_AllRegister) {
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    GDALAllRegister();
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetCacheMax) {
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (int)GDALGetCacheMax();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_SetCacheMax) {
    int arg1 ;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    GDALSetCacheMax(arg1);
    
    
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetCacheUsed) {
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (int)GDALGetCacheUsed();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDataTypeSize) {
    GDALDataType arg1 ;
    int result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (GDALDataType) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (int)GDALGetDataTypeSize(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_DataTypeIsComplex) {
    GDALDataType arg1 ;
    int result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (GDALDataType) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (int)GDALDataTypeIsComplex(arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDataTypeName) {
    GDALDataType arg1 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (GDALDataType) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (char *)GDALGetDataTypeName(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDataTypeByName) {
    char *arg1 = (char *) 0 ;
    GDALDataType result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetColorInterpretationName) {
    GDALColorInterp arg1 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (GDALColorInterp) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (char *)GDALGetColorInterpretationName(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetPaletteInterpretationName) {
    GDALPaletteInterp arg1 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (GDALPaletteInterp) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (char *)GDALGetPaletteInterpretationName(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_DecToDMS) {
    double arg1 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 2 ;
    char *result;
    zval **args[3];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<2 || arg_count>3)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[0]);
        arg1 = (double) Z_DVAL_PP(args[0]);
        /*@@*/;
    }
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[1]);
        arg2 = (char *) Z_STRVAL_PP(args[1]);
        /*@@*/;
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[2]);
            arg3 = (int) Z_LVAL_PP(args[2]);
            /*@@*/;
        }
    }
    result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_PackedDMSToDec) {
    double arg1 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[0]);
        arg1 = (double) Z_DVAL_PP(args[0]);
        /*@@*/;
    }
    result = (double)GDALPackedDMSToDec(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_DecToPackedDMS) {
    double arg1 ;
    double result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
        convert_to_double_ex(args[0]);
        arg1 = (double) Z_DVAL_PP(args[0]);
        /*@@*/;
    }
    result = (double)GDALDecToPackedDMS(arg1);
    
    {
        ZVAL_DOUBLE(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_ParseXMLString) {
    char *arg1 = (char *) 0 ;
    CPLXMLNode *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    result = (CPLXMLNode *)CPLParseXMLString(arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_CPLXMLNode, 0);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_SerializeXMLTree) {
    CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
    char *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_CPLXMLNode, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of SerializeXMLTree. Expected SWIGTYPE_p_p_CPLXMLNode");
        }
    }
    result = (char *)CPLSerializeXMLTree(arg1);
    
    {
        if(!result) {
            ZVAL_NULL(return_value);
        } else {
            ZVAL_STRING(return_value,result, 1);
        }
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDriverCount) {
    int result;
    zval **args[0];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 0) || (zend_get_parameters_array_ex(0, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (int)GetDriverCount();
    
    {
        ZVAL_LONG(return_value,result);
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDriverByName) {
    char *arg1 = (char *) 0 ;
    GDALDriverShadow *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDriverShadow, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Driver);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_GetDriver) {
    int arg1 ;
    GDALDriverShadow *result;
    zval **args[1];
    
    SWIG_ResetError();
    if(((ZEND_NUM_ARGS() )!= 1) || (zend_get_parameters_array_ex(1, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
        convert_to_long_ex(args[0]);
        arg1 = (int) Z_LVAL_PP(args[0]);
        /*@@*/;
    }
    result = (GDALDriverShadow *)GetDriver(arg1);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDriverShadow, 0);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Driver);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_Open) {
    char *arg1 = (char *) 0 ;
    GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
    GDALDatasetShadow *result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[1]);
            arg2 = (GDALAccess) Z_LVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDatasetShadow, 1);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Dataset);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_OpenShared) {
    char *arg1 = (char *) 0 ;
    GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
    GDALDatasetShadow *result;
    zval **args[2];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>2)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
        convert_to_string_ex(args[0]);
        arg1 = (char *) Z_STRVAL_PP(args[0]);
        /*@@*/;
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[1]);
            arg2 = (GDALAccess) Z_LVAL_PP(args[1]);
            /*@@*/;
        }
    }
    result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDatasetShadow, 1);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Dataset);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


ZEND_NAMED_FUNCTION(_wrap_AutoCreateWarpedVRT) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
    double arg5 = (double) 0.0 ;
    GDALDatasetShadow *result;
    zval **args[5];
    int arg_count;
    
    SWIG_ResetError();
    arg_count = ZEND_NUM_ARGS();
    if(arg_count<1 || arg_count>5)
    WRONG_PARAM_COUNT;
    
    if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)
    WRONG_PARAM_COUNT;
    
    {
        /* typemap(in) SWIGTYPE * */
        if(SWIG_ConvertPtr(*args[0], (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0) < 0) {
            SWIG_PHP_Error(E_ERROR, "Type error in argument 1 of AutoCreateWarpedVRT. Expected SWIGTYPE_p_p_GDALDatasetShadow");
        }
    }
    if(arg_count > 1) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[1]);
            arg2 = (char *) Z_STRVAL_PP(args[1]);
            /*@@*/;
        }
    }
    if(arg_count > 2) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,23,CONVERT_STRING_IN@*/
            convert_to_string_ex(args[2]);
            arg3 = (char *) Z_STRVAL_PP(args[2]);
            /*@@*/;
        }
    }
    if(arg_count > 3) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,4,CONVERT_INT_IN@*/
            convert_to_long_ex(args[3]);
            arg4 = (GDALResampleAlg) Z_LVAL_PP(args[3]);
            /*@@*/;
        }
    }
    if(arg_count > 4) {
        {
            /*@/home/kruland/opt/share/swig/1.3.26/php4/utils.i,13,CONVERT_FLOAT_IN@*/
            convert_to_double_ex(args[4]);
            arg5 = (double) Z_DVAL_PP(args[4]);
            /*@@*/;
        }
    }
    result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
    
    {
        SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_GDALDatasetShadow, 1);
    }
    /* Wrap this return value */
    {
        /* ALTERNATIVE Constructor, make an object wrapper */
        zval *obj, *_cPtr;
        MAKE_STD_ZVAL(obj);
        MAKE_STD_ZVAL(_cPtr);
        *_cPtr = *return_value;
        INIT_ZVAL(*return_value);
        object_init_ex(obj,ptr_ce_swig_Dataset);
        add_property_zval(obj,"_cPtr",_cPtr);
        *return_value=*obj;
    }
    return;
    fail:
    zend_error(ErrorCode(),ErrorMsg());
}


/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_double) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALColorEntry) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_char) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDAL_GCP) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDAL_GCP) {
  /* has destructor: __wrap_delete_GCP */
  __wrap_delete_GCP(rsrc, SWIGTYPE_p_GDAL_GCP->name TSRMLS_CC);
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_CPLErrorHandler) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_CPLXMLNode) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_CPLXMLNode) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALColorTable) {
  /* has destructor: __wrap_delete_ColorTable */
  __wrap_delete_ColorTable(rsrc, SWIGTYPE_p_GDALColorTable->name TSRMLS_CC);
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDALColorTable) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_int) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDALRasterBandShadow) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALRasterBandShadow) {
  /* bah! No destructor for this wrapped class!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDALDatasetShadow) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALDatasetShadow) {
  /* has destructor: __wrap_delete_Dataset */
  __wrap_delete_Dataset(rsrc, SWIGTYPE_p_GDALDatasetShadow->name TSRMLS_CC);
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDALDriverShadow) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALDriverShadow) {
  /* bah! No destructor for this wrapped class!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_p_GDALMajorObjectShadow) {
  /* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_GDALMajorObjectShadow) {
  /* bah! No destructor for this wrapped class!! */
}
/* end wrapper section */
/* init section */
#ifdef __cplusplus
extern "C" {
#endif
ZEND_GET_MODULE(gdal)
#ifdef __cplusplus
}
#endif

#define SWIG_php_minit PHP_MINIT_FUNCTION(gdal)
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif

SWIGRUNTIME void
SWIG_InitializeModule(void *clientdata) {
  swig_type_info *type, *ret;
  swig_cast_info *cast;
  size_t i;
  swig_module_info *module_head;
  static int init_run = 0;

  clientdata = clientdata;

  if (init_run) return;
  init_run = 1;

  /* Initialize the swig_module */
  swig_module.type_initial = swig_type_initial;
  swig_module.cast_initial = swig_cast_initial;

  /* Try and load any already created modules */
  module_head = SWIG_GetModule(clientdata);
  if (module_head) {
    swig_module.next = module_head->next;
    module_head->next = &swig_module;
  } else {
    /* This is the first module loaded */
    swig_module.next = &swig_module;
    SWIG_SetModule(clientdata, &swig_module);
  }
		 
  /* Now work on filling in swig_module.types */
  for (i = 0; i < swig_module.size; ++i) {
    type = 0;

    /* if there is another module already loaded */
    if (swig_module.next != &swig_module) {
      type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
    }
    if (type) {
      /* Overwrite clientdata field */
      if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
    } else {
      type = swig_module.type_initial[i];
    }

    /* Insert casting types */
    cast = swig_module.cast_initial[i];
    while (cast->type) {
    
      /* Don't need to add information already in the list */
      ret = 0;
      if (swig_module.next != &swig_module) {
        ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
      }
      if (ret && type == swig_module.type_initial[i]) {
        cast->type = ret;
        ret = 0;
      }
      
      if (!ret) {
        if (type->cast) {
          type->cast->prev = cast;
          cast->next = type->cast;
        }
        type->cast = cast;
      }

      cast++;
    }

    /* Set entry in modules->types array equal to the type */
    swig_module.types[i] = type;
  }
  swig_module.types[i] = 0;
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientData(void) {
  size_t i;
  swig_cast_info *equiv;
  static int init_run = 0;

  if (init_run) return;
  init_run = 1;

  for (i = 0; i < swig_module.size; i++) {
    if (swig_module.types[i]->clientdata) {
      equiv = swig_module.types[i]->cast;
      while (equiv) {
        if (!equiv->converter) {
          if (equiv->type && !equiv->type->clientdata)
            SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
        }
        equiv = equiv->next;
      }
    }
  }
}

#ifdef __cplusplus
}
#endif


  SWIG_php_minit {
    SWIG_InitializeModule(0);


  if (GDALGetDriverCount() == 0 ) {
    GDALAllRegister();
  }

/* oinit subsection */
ZEND_INIT_MODULE_GLOBALS(gdal, gdal_init_globals, gdal_destroy_globals);
/* Define class MajorObject */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_MajorObject,"majorobject",MajorObject_functions,NULL,_wrap_propget_MajorObject,_wrap_propset_MajorObject);
if (! (ptr_ce_swig_MajorObject=zend_register_internal_class_ex(&ce_swig_MajorObject,NULL,NULL))) zend_error(E_ERROR,"Error registering wrapper for class MajorObject");

/* Define class Driver */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_Driver,"driver",Driver_functions,NULL,_wrap_propget_Driver,_wrap_propset_Driver);
if (! (ptr_ce_swig_Driver=zend_register_internal_class_ex(&ce_swig_Driver,&ce_swig_MajorObject,NULL))) zend_error(E_ERROR,"Error registering wrapper for class Driver");

/* Define class GCP */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_GCP,"gcp",GCP_functions,NULL,_wrap_propget_GCP,_wrap_propset_GCP);
if (! (ptr_ce_swig_GCP=zend_register_internal_class_ex(&ce_swig_GCP,NULL,NULL))) zend_error(E_ERROR,"Error registering wrapper for class GCP");

/* Define class Dataset */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_Dataset,"dataset",Dataset_functions,NULL,_wrap_propget_Dataset,_wrap_propset_Dataset);
if (! (ptr_ce_swig_Dataset=zend_register_internal_class_ex(&ce_swig_Dataset,&ce_swig_MajorObject,NULL))) zend_error(E_ERROR,"Error registering wrapper for class Dataset");

/* Define class Band */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_Band,"band",Band_functions,NULL,_wrap_propget_Band,_wrap_propset_Band);
if (! (ptr_ce_swig_Band=zend_register_internal_class_ex(&ce_swig_Band,&ce_swig_MajorObject,NULL))) zend_error(E_ERROR,"Error registering wrapper for class Band");

/* Define class ColorTable */
INIT_OVERLOADED_CLASS_ENTRY(ce_swig_ColorTable,"colortable",ColorTable_functions,NULL,_wrap_propget_ColorTable,_wrap_propset_ColorTable);
if (! (ptr_ce_swig_ColorTable=zend_register_internal_class_ex(&ce_swig_ColorTable,NULL,NULL))) zend_error(E_ERROR,"Error registering wrapper for class ColorTable");


/* Register resource destructors for pointer types */
le_swig__p_double=zend_register_list_destructors_ex(_wrap_destroy_p_double,NULL,(char *)(SWIGTYPE_p_double->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_double,&le_swig__p_double);
le_swig__p_GDALColorEntry=zend_register_list_destructors_ex(_wrap_destroy_p_GDALColorEntry,NULL,(char *)(SWIGTYPE_p_GDALColorEntry->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALColorEntry,&le_swig__p_GDALColorEntry);
le_swig__p_p_char=zend_register_list_destructors_ex(_wrap_destroy_p_p_char,NULL,(char *)(SWIGTYPE_p_p_char->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_char,&le_swig__p_p_char);
le_swig__p_p_GDAL_GCP=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDAL_GCP,NULL,(char *)(SWIGTYPE_p_p_GDAL_GCP->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDAL_GCP,&le_swig__p_p_GDAL_GCP);
le_swig__p_GDAL_GCP=zend_register_list_destructors_ex(_wrap_destroy_p_GDAL_GCP,NULL,(char *)(SWIGTYPE_p_GDAL_GCP->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDAL_GCP,&le_swig__p_GDAL_GCP);
le_swig__p_CPLErrorHandler=zend_register_list_destructors_ex(_wrap_destroy_p_CPLErrorHandler,NULL,(char *)(SWIGTYPE_p_CPLErrorHandler->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_CPLErrorHandler,&le_swig__p_CPLErrorHandler);
le_swig__p_CPLXMLNode=zend_register_list_destructors_ex(_wrap_destroy_p_CPLXMLNode,NULL,(char *)(SWIGTYPE_p_CPLXMLNode->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_CPLXMLNode,&le_swig__p_CPLXMLNode);
le_swig__p_p_CPLXMLNode=zend_register_list_destructors_ex(_wrap_destroy_p_p_CPLXMLNode,NULL,(char *)(SWIGTYPE_p_p_CPLXMLNode->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_CPLXMLNode,&le_swig__p_p_CPLXMLNode);
le_swig__p_GDALColorTable=zend_register_list_destructors_ex(_wrap_destroy_p_GDALColorTable,NULL,(char *)(SWIGTYPE_p_GDALColorTable->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALColorTable,&le_swig__p_GDALColorTable);
le_swig__p_p_GDALColorTable=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDALColorTable,NULL,(char *)(SWIGTYPE_p_p_GDALColorTable->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDALColorTable,&le_swig__p_p_GDALColorTable);
le_swig__p_int=zend_register_list_destructors_ex(_wrap_destroy_p_int,NULL,(char *)(SWIGTYPE_p_int->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_int,&le_swig__p_int);
le_swig__p_p_GDALRasterBandShadow=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDALRasterBandShadow,NULL,(char *)(SWIGTYPE_p_p_GDALRasterBandShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDALRasterBandShadow,&le_swig__p_p_GDALRasterBandShadow);
le_swig__p_GDALRasterBandShadow=zend_register_list_destructors_ex(_wrap_destroy_p_GDALRasterBandShadow,NULL,(char *)(SWIGTYPE_p_GDALRasterBandShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALRasterBandShadow,&le_swig__p_GDALRasterBandShadow);
le_swig__p_p_GDALDatasetShadow=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDALDatasetShadow,NULL,(char *)(SWIGTYPE_p_p_GDALDatasetShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDALDatasetShadow,&le_swig__p_p_GDALDatasetShadow);
le_swig__p_GDALDatasetShadow=zend_register_list_destructors_ex(_wrap_destroy_p_GDALDatasetShadow,NULL,(char *)(SWIGTYPE_p_GDALDatasetShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALDatasetShadow,&le_swig__p_GDALDatasetShadow);
le_swig__p_p_GDALDriverShadow=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDALDriverShadow,NULL,(char *)(SWIGTYPE_p_p_GDALDriverShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDALDriverShadow,&le_swig__p_p_GDALDriverShadow);
le_swig__p_GDALDriverShadow=zend_register_list_destructors_ex(_wrap_destroy_p_GDALDriverShadow,NULL,(char *)(SWIGTYPE_p_GDALDriverShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALDriverShadow,&le_swig__p_GDALDriverShadow);
le_swig__p_p_GDALMajorObjectShadow=zend_register_list_destructors_ex(_wrap_destroy_p_p_GDALMajorObjectShadow,NULL,(char *)(SWIGTYPE_p_p_GDALMajorObjectShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_p_GDALMajorObjectShadow,&le_swig__p_p_GDALMajorObjectShadow);
le_swig__p_GDALMajorObjectShadow=zend_register_list_destructors_ex(_wrap_destroy_p_GDALMajorObjectShadow,NULL,(char *)(SWIGTYPE_p_GDALMajorObjectShadow->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_GDALMajorObjectShadow,&le_swig__p_GDALMajorObjectShadow);
CG(active_class_entry) = NULL;
/* end oinit subsection */

    return SUCCESS;
}
PHP_RINIT_FUNCTION(gdal)
{
/* rinit section */

/* cinit subsection */
/* end cinit subsection */

/* vinit subsection */
/* end vinit subsection */

    return SUCCESS;
}
PHP_MSHUTDOWN_FUNCTION(gdal)
{
/* shutdown section */

    return SUCCESS;
}
PHP_RSHUTDOWN_FUNCTION(gdal)
{
/* rshutdown section */

    return SUCCESS;
}
PHP_MINFO_FUNCTION(gdal)
{
}
/* end init section */
