from sensor.Sensor import Sensor

import commands
import re


#
# Sensor for watching ACPI status.
#
class ACPISensor(Sensor):

    ACPI_SOURCE = "acpi -tb"

    RE_BATTERY = re.compile("Battery[ 0-9:]+(?P<mode>[a-z]+)\, " \
                           "(?P<fill>[0-9\.]+)%(, (?P<remaining>[0-9:]+) .*)?")
    RE_THERMAL = re.compile("Thermal.*, (?P<temperature>[0-9\.]+) .*")


    def __init__(self):

        Sensor.__init__(self)
        self._add_timer(0, self.__get_data)

        

    def __get_data(self):

        fail, data = commands.getstatusoutput(self.ACPI_SOURCE)
        if (fail): self._add_timer(3000, self.__get_data)

        line1, line2 = data.splitlines()

        mode = self.RE_BATTERY.search(line1).group("mode")
        fill = int(self.RE_BATTERY.search(line1).group("fill"))
        remaining = self.RE_BATTERY.search(line1).group("remaining") or "N/A"

        temperature = self.RE_THERMAL.search(line2).group("temperature")


        # compute color
        delta = int(255.0 * (fill / 100.0))
        red = 255 - delta
        green = delta
        blue = 0
        color = "#" + hex(red + 256)[-2:] + \
                hex(green + 256)[-2:] + \
                hex(blue + 256)[-2:] + "70"

        settings = self._new_output()
        settings.set("mode", mode)
        settings.set("battery-color", color)
        settings.set("battery-fill", fill)
        settings.set("temperature", temperature)
        settings.set("remaining", remaining)
        self._send_output(settings)

        self._add_timer(3000, self.__get_data)



def new_sensor(args): return apply(ACPISensor, args)
