from GConfBackend import GConfBackend
from DummyBackend import DummyBackend
import settings
import migration

_CONFIG_LOCATION = "/apps/gdesklets"


#
# Class for managing configuration.
#
class ConfigManager:

    def __init__(self):

        # hashtable for config change handlers: path -> handler
        self.__handlers = {}


        if (settings.no_config):
            self.__backend = DummyBackend(_CONFIG_LOCATION)
        else:
            self.__backend = GConfBackend(_CONFIG_LOCATION)
            migration.check_for_profiles(self)

        #settings.profile = self.get("profile")
        self.__backend.add_observer(self.__on_observe_backend)



    def __on_observe_backend(self, src, cmd, *args):

        if (cmd == src.OBS_UPDATE):
            path, value = args

            for i in xrange(len(path)):
                handler = self.__handlers.get(tuple(path[:i + 1]))
                if (handler): break
            #end for

            if (handler):
                handler( * [path, value] )



    #
    # Sets a configuration value
    #
    def set(self, *args):

        self.__backend.set(*args)



    #
    # Gets a configuration value
    #
    def get(self, *args):

        return self.__backend.get(*args)



    #
    # Sets a callback handler for watching changes for the given configuration
    # entry.
    #
    def watch(self, *args):
        
        handler = args[-1]
        path = args[:-1]
        self.__handlers[tuple(path)] = handler



    #
    # Removes a watch callback handler.
    #
    def remove_watcher(self, *args):

        path = args[:-1]
        if (self.__handlers.has_key(path)):
            del self.__handlers[path]



    #
    # Clears an ID entry in the configuration backend
    #
    def clear(self, *path):

        entries = self.list(*path)
        if (not entries):
            self.__backend.clear(*path)
        else:
            for e in entries:
                self.clear( * list(path) + [e] )



    #
    # Lists directories in the configuration backend
    #
    def list(self, *args):

        return self.__backend.list(*args)



    #
    # Recursively copies a configuration node.
    #
    def copy(self, src, dest):

        dirs = self.list(*src)
        for d in dirs:
            self.copy(src + [d], dest + [src[-1], d])

        value = self.get(*src)
        if (value): self.set( * dest + [value] )
