#
# Container for displays. This class is a container proxy which has to be
# replaced by an implementation derived from this.
#
class DisplayContainer:

    def __init__(self, display):

        self.__window_flags = ""
        self.__shape = None
        self.__position = None
        self.__size = None


    def set_position(self, x, y):

        self.__position = (x, y)


    def is_placed(self):

        return 1


    def set_size(self, width, height):

        self.__size = (width, height)


    def set_shape(self, mask):

        self.__shape = mask


    def set_window_flags(self, flags):

        self.__window_flags = flags

        
    def close(self): raise NotImplementedError


    def pass_values(self, other):

        if (self.__position):
            x, y = self.__position
            other.set_position(x, y)

        if (self.__size):
            w, h = self.__size
            other.set_size(w, h)

        if (self.__shape):
            other.set_shape(self.__shape)

        if (self.__window_flags):
            other.set_window_flags(self.__window_flags)
