from ContainerTarget import ContainerTarget
from utils.TilingImage import TilingImage
from utils.datatypes import *
from utils import vfs

import os
import gtk


#
# Class for putting frames around targets.
#
class TargetFrame(ContainerTarget):

    def __init__(self, parent, display):

        self.__size = (0, 0)
        self.__inner_size = (0, 0)
        self.__frame_widths = [2, 2, 2, 2]
        self.__images = []


        ContainerTarget.__init__(self, parent, display)
        self.__table = gtk.Table(3, 3)
        self.__table.show()
        self.add(self.__table)

        for x, y in [(0, 1), (1, 0), (2, 1), (1, 2),
                     (0, 0), (2, 0), (2, 2), (0, 2)]:
            img = TilingImage()
            img.show()
            self.__table.attach(img, x, x + 1, y, y + 1)
            self.__images.append(img)
        #end for

        self.__box = gtk.HBox()
        self.__box.show()
        self.__table.attach(self.__box, 1, 2, 1, 2)

        self.connect("expose-event", self.__redraw_frame)
        self.add_observer(self.__on_resize)
        self._set_property_type("border-uris", TYPE_LIST)
        self._set_property_type("border-width", TYPE_LIST)



    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.__box.add(self._get_child())
        #self._get_child().add_observer(self.__on_resize)
        self._init_children()


    def __on_resize(self, src, cmd, *args):

        if (cmd == src.OBS_GEOMETRY):
            self.__redraw_frame()
            

    def __redraw_frame(self, src = None, event = None):
        
        x, y, w, h = self.get_geometry()
        #if (self._get_child()):
        #    cx, cy, cw, ch = self._get_child().get_geometry()
        #else:
        #    cx, cy, cw, ch = 0, 0, 1, 1
        
        #if ((cw, ch) != self.__inner_size or (w, h) != self.__size):
        if ((w, h) != self.__size):
            self.__size = (w, h)
            #self.__inner_size = (cw, ch)
            
            sizes = self.__compute_size()
            cnt = 0
            for img in self.__images:
                iw, ih = sizes[cnt]
                #img.set_size_request(max(iw, 1), max(1, ih))
                img.tile(max(iw, 1), max(1, ih))
                cnt += 1
            #end for
            w, h = sizes[-1]
            self.__box.set_size_request(w, h)


    def __compute_size(self):

        x, y, w, h = self.get_container_geometry()
        w1, h1, w2, h2 = self.__frame_widths
        ret = [(w1, h),
               (w, h1),
               (w2, h),
               (w, h2),
               (w1, h1),
               (w2, h1),
               (w2, h2),
               (w1, h2),
               (w, h)]

        return ret


    def __set_border_width(self, args):

        for i in xrange(len(args)):
            self.__frame_widths[i] = int(args[i])

        self.__size = (0, 0)
        self.adjust_geometry()
            

    def __set_border(self, args):

        sizes = self.__compute_size()
        cnt = 0
        for uri in args:
            w, h = sizes[cnt]
            uri = os.path.join(self.get_path(), uri)
            self.__images[cnt].set_from_file(uri)
            cnt += 1
        #end for
        self.__size = (0, 0)
        self.__redraw_frame()


    def get_border_size(self):

        return self.__frame_widths[:]

    
    def get_container_geometry(self):

        w1, h1, w2, h2 = self.__frame_widths
        x, y, w, h = self.get_geometry()
        x += w1
        y += h1
        w -= w1 + w2
        h -= h1 + h2
        
        return (x, y, max(w, 1), max(h, 1))



    #
    # TODO: properties
    #
    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "border-uris"):
            self.__set_border(value)

        elif (key == "border-width"):
            self.__set_border_width(value)

        else:
            ContainerTarget.set_config(self, key, value)



    #
    # Returns the target at the given position and its path.
    #
    def get_target_at(self, px, py, path):

        x, y, w, h = self.get_geometry()

        if (x <= px <= x + w and y <= py <= y + h):
            child = self._get_child()
            if (not child): return ([], [])
            ctargets = child.get_target_at(px - x , py - y, path)

            ret = [(self, path)] + ctargets
            return ret

        else:
            return []

        #end if
