from ContainerTarget import ContainerTarget
from utils.TilingImage import TilingImage
from utils.Hash2D import Hash2D
from utils.datatypes import *
from utils import vfs

import gtk
import os



#
# Class for grouping different targets together.
#
class TargetGroup(ContainerTarget):

    def __init__(self, parent, display):

        # the area zones covered by the child targets
        self.__zones = Hash2D()

        # the background pixmap
        self.__pixbuf = None

        # flag for ensuring that only one collapse action takes place
        self.__block = 0

        # the maximum size values of all the children
        self.__max_size = (0, 0)
        

        ContainerTarget.__init__(self, parent, display)
        self.__layout = gtk.Fixed()
        self.__layout.show()

        self.add(self.__layout)

        self.__image = TilingImage()
        self.__image.show()
        self.__layout.put(self.__image, 0, 0)

        self._set_property_type("bg-uri", TYPE_STRING)
        self._set_property_type("bg-color", TYPE_STRING)

        #self.connect("expose-event", self.__on_expose)
        self.add_observer(self.__on_observe_size)




    def __on_observe_size(self, src, cmd, *args):

        if (cmd == src.OBS_GEOMETRY):
            x, y, w, h = self.get_geometry()
            self.__image.tile(w, h)



    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        for child in self._get_children():
            self.__layout.put(child, 0, 0)
            self.__zones.set(0, 0, 0, 0, child)
            child.add_observer(self.__on_observe_target)
        #end for

        self._init_children()



    def __on_observe_target(self, src, cmd, *args):

        if (cmd == src.OBS_GEOMETRY):
            x, y, w, h = src.get_geometry()

            self.__layout.move(src, x, y)
            self.__zones.set(x, y, x + w, y + h, src)

            return
            


    #
    # Sets the background color.
    #
    def __set_color(self, color):

        self.__image.set_from_color(color)


    #
    # Sets the background image.
    #
    def __set_background(self, uri):

        if (not uri):
            self.__set_color("#00000000")
            return

        uri = vfs.join(self.get_path(), uri)
        if (vfs.exists(uri)):
            self.__image.set_from_file(uri)
            
        else:
            self.__set_color("#ffffffa0")

        #self.__image.set_size_request(width, height)



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "bg-uri"):
            self.__set_background(value)
            
        elif (key == "bg-color"):
            self.__set_color(value)

        else:
            ContainerTarget.set_config(self, key, value)
