from DisplayTarget import DisplayTarget
from utils.datatypes import *

import gtk
import gnome
import gtkhtml2
import urllib
import urlparse


#
# Class for a HTML display target.
#
class TargetHTML(DisplayTarget):

    def __init__(self, parent, display):

        self.__current_url = ""


        DisplayTarget.__init__(self, parent, display)

        self.__document = gtkhtml2.Document()
        self.__document.connect("request_url", self.__on_request_url)
        self.__document.connect("link_clicked", self.__on_link_clicked)
        self.__document.clear()

        self.__scrwin = gtk.ScrolledWindow()
        self.__scrwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.__scrwin.show()
        self.add(self.__scrwin)
        
        self.__html_view = gtkhtml2.View()
        #self.__html_view.connect("request_object", self.__on_request_object)
        self.__html_view.set_document(self.__document)
        self.__html_view.show()
        self.__scrwin.add(self.__html_view)
        
        self._set_property_type("data", TYPE_STRING)
        self._set_property_type("uri", TYPE_STRING)
        self._set_property_type("scrollbars", TYPE_BOOL)




    #
    # Returns whether the given URL is relative to the server.
    #
    def __is_relative_to_server(self, url):

        parts = urlparse.urlparse(url)
        if parts[0] or parts[1]:
            return 0
        return 1



    #
    # Resolves the given URL and returns it.
    #
    def __resolve_uri(self, uri):
        
        if self.__is_relative_to_server(uri):
            return urlparse.urljoin(self.__current_url, uri)
        return uri



    #
    # Opens the given URL and returns a file handle.
    #
    def __open_url(self, url):

        uri = self.__resolve_uri(url)
        return urllib.FancyURLopener().open(uri)





    #
    # Reacts on requesting an URL.
    #
    def __on_request_url(self, document, url, stream):

        f = self.__open_url(url)
        stream.write(f.read())



    #
    # Reacts on clicking a link.
    #
    def __on_link_clicked(self, document, link):

        try:
            url = self.__resolve_uri(link)
            gnome.url_show(url)
            #fd = self.__open_url(link)
            #url = self.__resolve_uri(link)
            #self.__current_url = url
            #self.__load_html(fd.read())
            
        except:
            print "failed to open", link
            return





    #
    # Loads the given data into the view.
    #
    def __load_html(self, data):

        self.__document.clear()
        self.__document.open_stream("text/html")
        self.__document.write_stream(data)
        self.__document.close_stream()



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "data"):
            self.__load_html(value)

        elif (key == "uri"):
            try:
                fd = self.__open_url(value)
                self.__current_url = value
                self.__load_html(fd.read())
            except:
                pass

        elif (key == "scrollbars"):
            if (value): self.__scrwin.set_policy(gtk.POLICY_AUTOMATIC,
                                                 gtk.POLICY_AUTOMATIC)
            else: self.__scrwin.set_policy(gtk.POLICY_NEVER,
                                           gtk.POLICY_NEVER)

        else:
            DisplayTarget.set_config(self, key, value)
