from config.ConfigManager import ConfigManager
from SensorFactory import SensorFactory
from sensor.DefaultSensor import DefaultSensor
from utils.TargetSettings import TargetSettings
from display.Display import Display
from display import targetregistry
from utils import singleton
from utils.TypeConverter import TypeConverter
from utils.datatypes import *
from utils import dialog
from config import settings as cfgsettings

from main import _
from main import DEFAULT_SENSOR

from xml import sax
import os


#
# Class for creating Displays from XML data.
#
class DisplayFactory(sax.handler.ContentHandler):

    def __init__(self):

        self.__children_stack = [[]]
        self.__nesting_stack = []
        self.__sensors = []
        self.__display = None
        self.__display_settings = None
        self.__id = ""
        self.__sensor_factory = singleton.get(SensorFactory)
        self.__type_converter = TypeConverter()


        sax.handler.ContentHandler.__init__(self)
        self.__type_converter.add_type("module", TYPE_LIST)



    #
    # Parses the given XML data and returns a new Display object.
    #
    def create_display(self, ident, data):

        self.__display = Display(ident)
        self.__id = ident

        # parse display data
        try:
            sax.parseString(data, self)
        except sax._exceptions.SAXParseException, e:
            print "Parse Error:", e
            # abort if an parse error occured
            return None
        except:
            return None

        # add the sensors
        for ident, sensor in self.__sensors:
            self.__display.add_sensor(ident, sensor)

        # add the DefaultSensor
        defsensor = DefaultSensor()
        defsensor.set_profile(cfgsettings.profile)
        defsensor.set_config_id(self.__id + DEFAULT_SENSOR)
        self.__display.add_sensor(DEFAULT_SENSOR, defsensor)
        if (cfgsettings.orig_coords):
            self.__display_settings.set("x", "0")
            self.__display_settings.set("y", "0")

        # we don't wanna override watch settings from the .display
        watch_settings = self.__display_settings.get("watch") or ""
        if (watch_settings): watch_settings += ","
        self.__display_settings.set("watch",
                                    watch_settings + \
                                    "x=" + DEFAULT_SENSOR + ":x,"
                                    "y=" + DEFAULT_SENSOR + ":y")

        # add the children and configure
        try:
            self.__display.add_children(self.__children_stack.pop())
            for key, value in self.__display_settings.get_entries():
                self.__display.set_config(key, value)

        except StandardError, e:
            # a stack trace could be useful for debugging
            import traceback; traceback.print_exc()

            # make the corrupt display visible so that the user can
            # remove it
            #self.__display.show()
            #self.__display.set_decorated(1)
            self.__display.set_size_request(500, 100)
            #self.__display.set_title("Broken display in %s" %broken_display )
            #self.__display.set_transparency_mode(0, 500, 100)
            print "Error while configuring display:" + str(e)
            dialog.warning(_("Error while configuring display"),
                           _("A display could not be configured properly. "
                             "It will most likely be broken and you should "
                             "consider removing it."))

        dsp = self.__display
        self.__display = None
        self.__sensors = []

        return dsp



    #
    # Creates a TargetSettings object from the given Attributes object.
    #
    def __create_settings(self, attrs):

        settings = TargetSettings()
        for key, value in attrs.items():
            settings.set(key, value)

        return settings



    def startElement(self, name, attrs):

        if (name == "display"):
            self.__children_stack = [[]]
            self.__nesting_stack = []
            self.__sensors = []
            self.__display_settings = self.__create_settings(attrs)

        elif (name == "sensor"):
            ident = attrs["id"]
            moduledata = self.__type_converter.str2type("module",
                                                        attrs["module"])
            module = moduledata[0]
            args = moduledata[1:]
            sensor = self.__sensor_factory.create_sensor(module, args)
            if (sensor):
                sensor.set_profile(cfgsettings.profile)
                sensor.set_id(ident)
                sensor.set_config_id(self.__id + ident)
                self.__sensors.append((ident, sensor))
            else:
                raise RuntimeError("Could not load sensor")


        # ignore the <meta> tag for now
        elif (name == "meta"):
            pass

        else:
            settings = self.__create_settings(attrs)
            # if there is no ID given, guess a unique one
            ident = attrs.get("id", str(settings))
            self.__children_stack.append([])
            # remember everything for later
            self.__nesting_stack.append((name, ident, settings))



    def endElement(self, name):

        if (name in ["display", "sensor", "meta"]): return

        oname, ident, settings = self.__nesting_stack.pop()
        if (not name == oname):
            # nesting errors in XML are detected by the SAX parser; if we get
            # here, it means our parser is buggy, not the XML input
            print "Nesting error: expected " + oname + ", got " + name
            return

        clss = targetregistry.get_target_class(name)
        if (not clss):
            print "Unknown tag: " + name

        else:
            children = self.__children_stack.pop()
            self.__children_stack[-1].append((ident, clss, settings, children))
