import polling
import glibtop

import os
import re


#
# TODO: support SMP
#
class CPU:

    def __init__(self):

        # for remembering previous values
        self.__tT = 0.0
        self.__uT = 0.0
        self.__sT = 0.0
        self.__nT = 0.0
        self.__iT = 0.0


        self.__get_cpu      = polling.wrap(self.__poll_cpu, 10)
        self.get_model      = polling.wrap(self.__poll_model, 0)
        self.get_speed      = polling.wrap(self.__poll_speed, 10)
        self.get_cache_size = polling.wrap(self.__poll_cache, 0)
        self.get_load       = polling.wrap(self.__poll_load, 0.2)


    #
    #:function get_model | | Returns the model name of the installed CPU.
    #:  param | |
    #:  return The model name of the installed CPU as string.
    #:/function
    #
    def __poll_model(self): return self.__get_cpu()[0]


    #
    #:function get_speed | | Returns the CPU clock.
    #:  param | |
    #:  return The CPU clock as string.
    #:/function
    #
    def __poll_speed(self): return self.__get_cpu()[1]


    #
    #:function get_cache_size | | Returns the 2nd level cache size of the
    #                             installed CPU.
    #:  param | |
    #:  return The 2nd level cache size of the installed CPU as string.
    #:/function
    #
    def __poll_cache(self): return self.__get_cpu()[2]



    def __poll_cpu(self):

        import libdesklets as lib

        arch = lib.sys.get_arch()
        platform = lib.sys.get_os()

        if (arch in ["i386", "i486", "i586", "i686"]):
            if (platform == "FreeBSD"):
                fd = os.popen("grep -3 CPU /var/run/dmesg.boot |"
                              " head -7 | tail -4", "r")
                lines = fd.readlines()
                fd.close()
                m = re.search('^CPU: (.*) \(([0-9]+.*)-MHz [0-9]+-class CPU\)',
                              lines[0])
                model_name = m.group(1)           # or sysctl hw.model
                cpu_mhz = m.group(2)              # or sysctl hw.clockrate
                cpu_cache = " "                   # not available by default

            elif (platform == "Linux"):
                fd = open("/proc/cpuinfo", "r")
                lines = fd.readlines()
                fd.close()
                fields = lines[4].split()
                model_name = " ".join(fields[3:])
                fields = lines[6].split()
                cpu_mhz = fields[3]
                fields = lines[7].split()
                cpu_cache = " ".join(fields[3:5])

            else:
                print "Unknown OS, strange things may happen."
                return

        # I've never seen any *BSD for PPC's. I need some help here.
        elif (arch == "ppc"):
            fields = lines[0].split()
            model_name = fields[2]
            fields = lines[2].split()
            cpu_mhz = fields[2]
            fields = lines[10].split()
            cpu_cache = fields[3]

        else:
            # TODO: alpha, m68k, mips, ppc64, sparc
            model_name, cpu_mhz, cpu_cache = "Unknown CPU", "0", " "

        return (model_name, cpu_mhz, cpu_cache)



    #
    #:function get_load | | Returns total and current load.
    #:  param | |
    #:  return Total load and current load of the installed CPU.
    #:/function
    #
    def __poll_load(self):

        total, user, nice, sys, idle, freq = glibtop.get_cpu()[:6]
        totaldiff = total - self.__tT
        load = int(freq * ((user + sys + nice) -
                           (self.__uT + self.__sT + self.__nT)) /
                   (totaldiff + 0.001) + 0.5)

        if (load > 100): load = 100

        self.__tT = total
        self.__uT = user
        self.__sT = sys
        self.__nT = nice
        self.__iT = idle

        return (total, load)
