from main import USERHOME, HOME, NAME, PURGE_KEY
from factory.DisplayFactory import DisplayFactory
from display.Window import Window
from display.Plug import Plug
from config.ConfigManager import ConfigManager
from utils import singleton
from utils import dialog
from utils import vfs
from config import settings
import admin

from main import _

import os
import shutil
import gtk


# This class starts, restarts and kills Displays
class Starter:

    def __init__(self):

        # the set of open displays as a hashtable "id -> display"
        self.__open_displays = {}

        self.__factory = singleton.get(DisplayFactory)        
        self.__config = singleton.get(ConfigManager)

        self.__config.watch("profile", self.__on_change_profile)

        # setup a nice systray icon
        if (settings.tray_icon):
            from utils.systray import SysTrayIcon
            trayicon = SysTrayIcon()
            trayicon.set_icon("gdesklets")


    #
    # Reacts on observer messages from the display.
    #
    def __on_display_action(self, src, cmd, *args):

        if (cmd == src.OBS_CLOSE):
            ident = args[0]
            admin.remove_display(ident)
            del src

        elif (cmd == src.OBS_RESTART):
            ident = args[0]
            displays = admin.get_displays()
            path = displays[ident]    
            admin.remove_display(ident)
            gtk.timeout_add(250, admin.add_display, path, ident)
            del src

        #end if



    #
    # Reacts on changing the user profile.
    #
    def __on_change_profile(self, key, value):

        if (settings.profile == value): return
        
        # shut down displays
        while len(self.__open_displays) != 0:
            self.__open_displays.popitem() [1] .remove_display()

        settings.profile = value
        # load displays
        self.start_displays()
        print "PROFILE CHANGE", value
        


    #
    # Reacts on changes in the list of displays.
    #
    def __on_watch(self, key, value):

        displays = admin.get_displays()

        # check whether displays have been added
        for ident in displays.keys():
            if (not self.__open_displays.has_key(ident)):
                self.__add_display(ident, displays[ident])
        #end for

        # check whether displays have been removed
        for ident in self.__open_displays.keys():
            if (not displays.has_key(ident)):
                self.__remove_display(ident)
        #end for


    #
    # Waits until the given callback returns TRUE.
    #
    def __wait_for(self, callback):

        while (not callback()):
            gtk.threads_enter()
            gtk.mainiteration()
            gtk.threads_leave()
            

    #
    # Adds the given display.
    #
    def __add_display(self, ident, path):

        if (not self.__open_displays.has_key(ident)):
            dsp = self.__create_display(ident, path)
            self.__open_displays[ident] = dsp

            displaytype = admin.get_display_type(ident)

            if (dsp):
                print "[" + path + "]"
                self.__open_displays[ident] = dsp
                dsp.add_observer(self.__on_display_action)
                
                if (displaytype == admin.DISPLAY_TYPE_WINDOW):
                    win = Window(dsp)
                    # win.move(-2000, -2000)
                    gtk.idle_add(win.show)
                    dsp.show()
                    self.__wait_for(win.is_placed)
                    
                elif (displaytype == admin.DISPLAY_TYPE_PLUG):
                    plug = Plug(dsp)
                    print plug.get_xembed_id()
                    print "Plugs are not yet fully supported."
            #endif
        #end if



    #
    # Creates and returns a new display from the given data, or None in case
    # of an error.
    #
    def __create_display(self, ident, path):

        try:
            if (not vfs.exists(path)): raise IOError("File does not exist.")
            fd = vfs.open(path, "r")
            data = vfs.read_all(fd)
            fd.close()

        except:
            import traceback; traceback.print_exc()
            dialog.warning(_("Could not open display file '%(path)s'")
                           % vars(),
                           _("The display file could not be opened because "
                             "the file was not readable."))
            admin.remove_display(ident)

            return

        rep = os.path.dirname(path)

        vfs.chdir(rep)
        display = self.__factory.create_display(ident, data)

        if (not display):
            dialog.warning(_("Invalid display file '%(path)s'") % vars(),
                           _("The display file contains invalid data and "
                             "could not be loaded."))
            admin.remove_display(ident)

        return display



    #
    # Removes the given display.
    #
    def __remove_display(self, ident):

        if (self.__open_displays.has_key(ident)):
            print "closing", ident
            d = self.__open_displays[ident]
            if d : d.remove_display()
            del self.__open_displays[ident]
            
            import gc
            print "collected garbage:", gc.collect(),
            print "    uncollectable:", len(gc.garbage)

        gtk.timeout_add(500, self.__purge_config)



    #
    # Purges unused config entries.
    #
    def __purge_config(self):

        opened_displays = self.__open_displays.keys()

        reps = [ r for r in self.__config.list("profiles", settings.profile)
                 if r[0].isdigit() ]        

        for rep in reps:

            for ident in opened_displays:
                if rep.startswith(ident):
                    break
                
            else: # rep doesn't start with any ident
                  # so we can safely purge it
                
                # get paths to purge
                # empty are ignored
                purge = filter( None,
                                self.__config.get("profiles", settings.profile,
                                                 rep, PURGE_KEY).split(",")
                               )
                
                for p in purge:

                    # relative paths are relative to USERHOME
                    p = os.path.normpath(os.path.join(USERHOME, p))
                    
                    # make sure that only paths below USERHOME can be purged
                    if (p.startswith(USERHOME) and os.path.exists(p)):
                        print "purging path", p
                        shutil.rmtree(p)
                #end for
                
                print "purging", rep
                self.__config.clear("profiles", settings.profile, rep)
            #end for_else
        #end for



    #
    # Starts up all displays.
    #
    def start_displays(self):

        # watches main/displays in the configuration base and calls on_watch if
        # something's changed
        self.__config.watch("profiles", admin.get_profile(),
                            "main", "displays", self.__on_watch)
        self.__on_watch(None, None)
